;ISN Autoitstudio Addons.au3


Func _Pruefe_auf_mehrere_Projektdateien($Pfad = "")
	If $Pfad = "" Then Return False
	$Dateien_Array = _FileListToArray($Pfad, "*.isn", $FLTA_FILES, True)
	If Not IsArray($Dateien_Array) Then Return False
	If UBound($Dateien_Array) - 1 > 1 Then Return True ;Wenn mehr als eine .isn Datei gefunden wurde
	Return False ;Wenn nur eine *.isn Datei gefunden wurde
EndFunc   ;==>_Pruefe_auf_mehrere_Projektdateien



Func _Finde_Projektdatei($Pfad = "")
	If $Pfad = "" Then Return ""
	Local $result = "" ;"" Wenn keine Datei gefunden wurde
	$Dateien_Array = _FileListToArray($Pfad, "*.isn", $FLTA_FILES, True)
	If Not IsArray($Dateien_Array) Then Return $result
	If UBound($Dateien_Array) - 1 > 1 Then Return $result ;Wenn mehr als eine .isn Datei gefunden wurde
	Return $Dateien_Array[1] ;Wenn nur eine *.isn Datei gefunden wurde, wird diese verwendet
EndFunc   ;==>_Finde_Projektdatei


Func _hit_win($GUI)
	$wpos = _WinGetPos($GUI, "")
	$mpos = MouseGetPos()
	If Not IsArray($wpos) Then Return
	If Not IsArray($mpos) Then Return
	If @error Then Return
	If ($mpos[0] > $wpos[0] And $mpos[1] > $wpos[1]) And ($mpos[0] < $wpos[0] + $wpos[2] And $mpos[1] < $wpos[1] + $wpos[3]) Then
		Return 1
	Else
		Return 0
	EndIf
EndFunc   ;==>_hit_win





;___END__BUTTONICONS__

Func _Dummyfunc()
EndFunc   ;==>_Dummyfunc

Func _Write_log($str, $colour = "000000", $big = "false", $notime = "false")
	$str = StringReplace($str, "\", "\\")
	$str = StringReplace($str, "/", "//")
	;uictrlsetdata($Programm_log,guictrlread($Programm_log)&@hour&":"&@min&":"&@sec&"  "&$str&@crlf)
	If $ISN_Dark_Mode = "true" Then
		If $colour = "000000" Then $colour = "DFDFDF"
	EndIf

	If $WindowBackgroundIsDark Then
		If $colour = "000000" Then $colour = StringReplace(String($Schriftfarbe), "0x", "")
	EndIf

	$time = @HOUR & ":" & @MIN & ":" & @SEC & "  "
	If $ISN_Dark_Mode = "true" Then $time = "[c=#DFDFDF]" & $time & "[/c] "

	$str = "[c=#" & $colour & "]" & $str & "[/c] "
	If $big = "true" Then $str = "[b]" & $str & "[/b] "
	If $notime = "true" Then $time = ""

	_ChatBoxAdd($Programm_log, $time & $str & @CRLF)
	;_GUICtrlEdit_Scroll($Programm_log, $SB_SCROLLCARET)
	_SendMessage($Programm_log, $WM_VSCROLL, $SB_BOTTOM, 0)
EndFunc   ;==>_Write_log

Func _show_Loading($Text1, $Text2)
	GUISetCursor(15, 1, $Loading_GUI)
	GUICtrlSetData($Loading_Text1, $Text1)
	GUICtrlSetData($Loading_Text2, $Text2)
	GUISetState(@SW_SHOW, $Loading_GUI)
	GUISetState(@SW_DISABLE, $StudioFenster)
EndFunc   ;==>_show_Loading

Func _Loading_Progress($zahl)
	GUICtrlSetData($Loading_progressbar, $zahl)
EndFunc   ;==>_Loading_Progress

Func _Hide_Loading()
	GUISetCursor(2, 1, $Loading_GUI)
	GUISetState(@SW_HIDE, $Loading_GUI)
	_Rezize()
EndFunc   ;==>_Hide_Loading

Func _Create_New_Project()
	If GUICtrlRead($new_projectvorlage_combo) = "" And GUICtrlRead($new_projectvorlage_radio1) = $GUI_CHECKED Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(380), 0, $NEW_PROJECT_GUI)
		Return
	EndIf


	If GUICtrlRead($new_projectname) = "" Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(24), 0, $NEW_PROJECT_GUI)
		_Input_Error_FX($new_projectname)
		Return
	EndIf

	If GUICtrlRead($neues_projekt_projektdatei_name) = "" Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1118), 0, $NEW_PROJECT_GUI)
		_Input_Error_FX($neues_projekt_projektdatei_name)
		Return
	EndIf

	If GUICtrlRead($new_projectmainfile) = "" Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(26), 0, $NEW_PROJECT_GUI)
		_Input_Error_FX($new_projectmainfile)
		Return
	EndIf

	If GUICtrlRead($new_projectvorlage_radio2) = $GUI_CHECKED Then
		If GUICtrlRead($new_projectusefollowingmainfile_input) = "" Then
			MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(503), 0, $NEW_PROJECT_GUI)
			_Input_Error_FX($new_projectusefollowingmainfile_input)
			Return
		EndIf
	EndIf

	If GUICtrlRead($new_projectmainfile_create_in_folder) = "" Or Not StringInStr(GUICtrlRead($new_projectmainfile_create_in_folder), "\") Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1411), 0, $NEW_PROJECT_GUI)
		Return
	EndIf

	If FileExists(_ISN_Variablen_aufloesen(_WinAPI_PathRemoveBackslash(GUICtrlRead($new_projectmainfile_create_in_folder)))) And GUICtrlRead($new_projectstammordner_checkbox) = $GUI_UNCHECKED Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(27), 0, $NEW_PROJECT_GUI)
		Return
	EndIf

	$i = GUICtrlRead($new_projectname)
	If StringInStr($i, "\") Or StringInStr($i, "/") Or StringInStr($i, "?") Or StringInStr($i, ":") Or StringInStr($i, "*") Or StringInStr($i, "|") Or StringInStr($i, "<") Or StringInStr($i, ">") Or StringInStr($i, "'") Or StringInStr($i, '"') Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(390) & @CRLF & _Get_langstr(389), 0, $NEW_PROJECT_GUI)
		_Input_Error_FX($new_projectname)
		Return
	EndIf

	$i = GUICtrlRead($new_projectmainfile)
	If StringInStr($i, "\") Or StringInStr($i, "/") Or StringInStr($i, "?") Or StringInStr($i, ":") Or StringInStr($i, "*") Or StringInStr($i, "|") Or StringInStr($i, "<") Or StringInStr($i, ">") Or StringInStr($i, "'") Or StringInStr($i, '"') Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(505) & @CRLF & _Get_langstr(389), 0, $NEW_PROJECT_GUI)
		_Input_Error_FX($new_projectmainfile)
		Return
	EndIf


	Local $Noopen = 0
	Local $Pfad_zur_isn = ""
	Local $new_isn_path = ""
	Local $state
	Local $Pfad_zur_Project_ISN_backup
	Local $NewProject_RootPath = _WinAPI_PathRemoveBackslash(GUICtrlRead($new_projectmainfile_create_in_folder))
	Local $ISN_NewProject_MainfileName = GUICtrlRead($new_projectmainfile)
	Local $ISN_NewProject_ISNProjectFileName = GUICtrlRead($neues_projekt_projektdatei_name)
	Local $NewProjectFullMainfilePath = ""

	;add .au3 to the mainfile name, if it´s not there
	$ISN_NewProject_MainfileName = StringReplace($ISN_NewProject_MainfileName, '.' & $Autoitextension, "")
	$ISN_NewProject_MainfileName = $ISN_NewProject_MainfileName & '.' & $Autoitextension

	;add .isn to the isn project file name, if it´s not there
	$ISN_NewProject_ISNProjectFileName = StringReplace($ISN_NewProject_ISNProjectFileName, '.isn', "")
	$ISN_NewProject_ISNProjectFileName = $ISN_NewProject_ISNProjectFileName & '.isn'

	;First, try to create the new project folder
	If GUICtrlRead($new_projectstammordner_checkbox) = $GUI_UNCHECKED Then
		$res = DirCreate(_ISN_Variablen_aufloesen($NewProject_RootPath))
		If $res = 0 Then
			MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1557), 0, $NEW_PROJECT_GUI)
			Return
		EndIf
	EndIf

	;Disable Subclassing for some controls (for inteliwrite)
	GUIUnRegisterMsg20($new_projectname, $WM_PASTE, _ISN_NewProjectDialog_InteliwriteSubClass)
	GUIUnRegisterMsg20($new_projectname, $WM_CHAR, _ISN_NewProjectDialog_InteliwriteSubClass)
	GUIUnRegisterMsg20($new_projectname, $WM_KEYUP, _ISN_NewProjectDialog_InteliwriteSubClass)

	GUIUnRegisterMsg20($new_projectmainfile, $WM_PASTE, _ISN_NewProjectDialog_InteliwriteSubClass)
	GUIUnRegisterMsg20($new_projectmainfile, $WM_CHAR, _ISN_NewProjectDialog_InteliwriteSubClass)
	GUIUnRegisterMsg20($new_projectmainfile, $WM_KEYUP, _ISN_NewProjectDialog_InteliwriteSubClass)

	GUIUnRegisterMsg20($neues_projekt_projektdatei_name, $WM_PASTE, _ISN_NewProjectDialog_InteliwriteSubClass)
	GUIUnRegisterMsg20($neues_projekt_projektdatei_name, $WM_CHAR, _ISN_NewProjectDialog_InteliwriteSubClass)
	GUIUnRegisterMsg20($neues_projekt_projektdatei_name, $WM_KEYUP, _ISN_NewProjectDialog_InteliwriteSubClass)

	$state = WinGetState($projectmanager, "")
	If BitAND($state, 2) Then
		$Noopen = 1
	Else
		$Noopen = 0
	EndIf


	If $Noopen = 0 Then
		_Write_log(_Get_langstr(33) & "(" & GUICtrlRead($new_projectname) & ")", "000000", "true", "true")
		GUISetState(@SW_ENABLE, $StudioFenster)
		GUISetState(@SW_HIDE, $NEW_PROJECT_GUI)
		GUISetState(@SW_HIDE, $Welcome_GUI)
		GUISetState(@SW_DISABLE, $StudioFenster)
		GUISetState(@SW_SHOW, $StudioFenster)
		_show_Loading(_Get_langstr(22), _Get_langstr(23))
	Else
		GUISetState(@SW_ENABLE, $projectmanager)
		GUISetState(@SW_HIDE, $NEW_PROJECT_GUI)
	EndIf

	_Loading_Progress(10)
	$NewProjectFullMainfilePath = _ISN_Variablen_aufloesen($NewProject_RootPath & "\" & $ISN_NewProject_MainfileName)

	If GUICtrlRead($new_projectvorlage_radio1) = $GUI_CHECKED Or GUICtrlRead($new_projectvorlage_radio0) = $GUI_CHECKED Then
		If GUICtrlRead($new_projectvorlage_radio1) = $GUI_CHECKED Then
			_FileOperationProgress($new_projectvorlage_combo_ARRAY[_GUICtrlComboBox_GetCurSel($new_projectvorlage_combo) + 1] & "\*.*", _ISN_Variablen_aufloesen($NewProject_RootPath), 1, $FO_COPY, $FOF_SIMPLEPROGRESS + $FOF_NOCONFIRMATION)
			$Pfad_zur_isn = _Finde_Projektdatei(_ISN_Variablen_aufloesen($NewProject_RootPath))
			FileMove($Pfad_zur_isn, _ISN_Variablen_aufloesen($NewProject_RootPath & "\" & $ISN_NewProject_ISNProjectFileName), 1)
			$Pfad_zur_isn = _Finde_Projektdatei(_ISN_Variablen_aufloesen($NewProject_RootPath))
			$templatemainfile = IniRead(_Finde_Projektdatei($new_projectvorlage_combo_ARRAY[_GUICtrlComboBox_GetCurSel($new_projectvorlage_combo) + 1]), "ISNAUTOITSTUDIO", "mainfile", "")
			FileMove(_ISN_Variablen_aufloesen($NewProject_RootPath & "\" & $templatemainfile), _ISN_Variablen_aufloesen($NewProject_RootPath & "\" & $ISN_NewProject_MainfileName), 1)
		Else
			;Leeres Projekt
			$file = FileOpen(_ISN_Variablen_aufloesen($NewProject_RootPath & "\" & $ISN_NewProject_MainfileName), 1)
			FileClose($file)
		EndIf

		;Projektdatei erstellen / konvertieren
		If FileExists(_ISN_Variablen_aufloesen($NewProject_RootPath & "\" & $ISN_NewProject_ISNProjectFileName)) Then
			_Datei_nach_UTF16_konvertieren(_ISN_Variablen_aufloesen($NewProject_RootPath & "\" & $ISN_NewProject_ISNProjectFileName))
		Else
			_Leere_UTF16_Datei_erstellen(_ISN_Variablen_aufloesen($NewProject_RootPath & "\" & $ISN_NewProject_ISNProjectFileName))
		EndIf


		IniWrite(_ISN_Variablen_aufloesen($NewProject_RootPath & "\" & $ISN_NewProject_ISNProjectFileName), "ISNAUTOITSTUDIO", "mainfile", $ISN_NewProject_MainfileName)
		$Pfad_zur_isn = _Finde_Projektdatei(_ISN_Variablen_aufloesen($NewProject_RootPath))
	EndIf


	If GUICtrlRead($new_projectvorlage_radio2) = $GUI_CHECKED Then
		If GUICtrlRead($new_projectstammordner_checkbox) = $GUI_CHECKED Then
			$new_isn_path = StringTrimRight(GUICtrlRead($new_projectusefollowingmainfile_input), StringLen(GUICtrlRead($new_projectusefollowingmainfile_input)) - StringInStr(GUICtrlRead($new_projectusefollowingmainfile_input), "\", 0, -1) + 1) & "\" & $ISN_NewProject_ISNProjectFileName
			_Leere_UTF16_Datei_erstellen($new_isn_path)
			IniWrite($new_isn_path, "ISNAUTOITSTUDIO", "mainfile", StringTrimLeft(GUICtrlRead($new_projectusefollowingmainfile_input), StringInStr(GUICtrlRead($new_projectusefollowingmainfile_input), "\", 0, -1)))
			$mainfile = StringTrimLeft(GUICtrlRead($new_projectusefollowingmainfile_input), StringInStr(GUICtrlRead($new_projectusefollowingmainfile_input), "\", 0, -1))
			$Default_Name = StringTrimRight($mainfile, StringLen($mainfile) - StringInStr($mainfile, ".", 0, -1) + 1)
			IniWrite($new_isn_path, "ISNAUTOITSTUDIO", "compile_exename", $Default_Name)
			$NewProjectFullMainfilePath = $NewProject_RootPath & "\" & $mainfile

		Else
			FileCopy(GUICtrlRead($new_projectusefollowingmainfile_input), _ISN_Variablen_aufloesen($NewProject_RootPath), 1)
			$new_isn_path = _ISN_Variablen_aufloesen($NewProject_RootPath & "\" & $ISN_NewProject_ISNProjectFileName)
			_Leere_UTF16_Datei_erstellen($new_isn_path)
			IniWrite($new_isn_path, "ISNAUTOITSTUDIO", "mainfile", StringTrimLeft(GUICtrlRead($new_projectusefollowingmainfile_input), StringInStr(GUICtrlRead($new_projectusefollowingmainfile_input), "\", 0, -1)))
			$mainfile = StringTrimLeft(GUICtrlRead($new_projectusefollowingmainfile_input), StringInStr(GUICtrlRead($new_projectusefollowingmainfile_input), "\", 0, -1))
			$Default_Name = StringTrimRight($mainfile, StringLen($mainfile) - StringInStr($mainfile, ".", 0, -1) + 1)
			IniWrite($new_isn_path, "ISNAUTOITSTUDIO", "compile_exename", $Default_Name)
			$NewProjectFullMainfilePath = $NewProject_RootPath & "\" & $mainfile

			;Ordnerinhalt kopieren
			If GUICtrlRead($new_project_ordnerinhaltkopieren_checkbox) = $GUI_CHECKED Then
				$Quellordner = GUICtrlRead($new_projectusefollowingmainfile_input)
				$Quellordner = StringTrimRight($Quellordner, (StringLen($Quellordner) - StringInStr($Quellordner, "\", 0, -1)) + 1)
				If FileExists($Quellordner) Then _FileOperationProgress($Quellordner & "\*.*", _ISN_Variablen_aufloesen($NewProject_RootPath), 1, $FO_COPY, $FOF_SIMPLEPROGRESS + $FOF_NOCONFIRMATION)
			EndIf

		EndIf
	EndIf

	_Loading_Progress(60)
	If GUICtrlRead($new_projectstammordner_checkbox) = $GUI_CHECKED Then
		$new_isn_path = StringTrimRight(GUICtrlRead($new_projectusefollowingmainfile_input), StringLen(GUICtrlRead($new_projectusefollowingmainfile_input)) - StringInStr(GUICtrlRead($new_projectusefollowingmainfile_input), "\", 0, -1) + 1) & "\" & $ISN_NewProject_ISNProjectFileName
	Else
		$new_isn_path = _ISN_Variablen_aufloesen($NewProject_RootPath & "\" & $ISN_NewProject_ISNProjectFileName)
	EndIf

	;gewählten Autor für´s nächste mal speichern
	_Write_in_Config("new_project_author", GUICtrlRead($new_projectauthor))


	_Write_ISN_Debug_Console("New project created! (" & GUICtrlRead($new_projectname) & ")", 1)
	IniWrite($new_isn_path, "ISNAUTOITSTUDIO", "name", GUICtrlRead($new_projectname))
	IniWrite($new_isn_path, "ISNAUTOITSTUDIO", "date", @MDAY & "." & @MON & "." & @YEAR)
	IniWrite($new_isn_path, "ISNAUTOITSTUDIO", "author", GUICtrlRead($new_projectauthor))
	IniWrite($new_isn_path, "ISNAUTOITSTUDIO", "comment", GUICtrlRead($new_projectcomment))
	IniWrite($new_isn_path, "ISNAUTOITSTUDIO", "studioversion", $Studioversion)
	IniWrite($new_isn_path, "ISNAUTOITSTUDIO", "version", GUICtrlRead($new_projectversion))
	IniWrite($new_isn_path, "ISNAUTOITSTUDIO", "time", "0")
	IniWrite($new_isn_path, "ISNAUTOITSTUDIO", "projectopened", "0")
	If GUICtrlRead($new_project_aenderungsprotokolle_checkbox) = $GUI_CHECKED Then IniWrite($new_isn_path, "ISNAUTOITSTUDIO", "use_changelog_manager", "true")
	If GUICtrlRead($new_project_aenderungsprotokolle_author_checkbox) = $GUI_CHECKED Then IniWrite($new_isn_path, "ISNAUTOITSTUDIO", "changelog_use_author_from_project", "true")


	;Organize Mainfile
	If GUICtrlRead($new_projectvorlage_radio1) = $GUI_CHECKED Then
		Dim $aRecords
		$Pfad_zur_Project_ISN_backup = $Pfad_zur_Project_ISN
		$Pfad_zur_Project_ISN = $new_isn_path
		_FileReadToArray(_ISN_Variablen_aufloesen($NewProject_RootPath & "\" & $ISN_NewProject_MainfileName), $aRecords)
		If IsArray($aRecords) Then
			For $x = 1 To $aRecords[0]
				;Alte Variablen (für Kompatibilität)
				$aRecords[$x] = StringReplace($aRecords[$x], "$FILENAME", $ISN_NewProject_MainfileName)
				$aRecords[$x] = StringReplace($aRecords[$x], "$AUTHOR", GUICtrlRead($new_projectauthor))
				$aRecords[$x] = StringReplace($aRecords[$x], "$PROGRAMMVERSION", $Studioversion)
				$aRecords[$x] = StringReplace($aRecords[$x], "$STR30", _Get_langstr(30))
				$aRecords[$x] = StringReplace($aRecords[$x], "$COMMENT", GUICtrlRead($new_projectcomment))

				;Overwrite some stuff for templates (only needed here cause, for example, $Offenes_Projekt_name is not filled when creating a new project)
				$aRecords[$x] = StringReplace($aRecords[$x], "%projectname%", GUICtrlRead($new_projectname))
				$aRecords[$x] = StringReplace($aRecords[$x], "%ProjectVersion%", GUICtrlRead($new_projectversion))
				$aRecords[$x] = StringReplace($aRecords[$x], "%ProjectAuthor%", GUICtrlRead($new_projectauthor))
				$aRecords[$x] = StringReplace($aRecords[$x], "%ProjectComment%", GUICtrlRead($new_projectcomment))
				$aRecords[$x] = StringReplace($aRecords[$x], "%ProjectDir%", $NewProject_RootPath)

				;Neue Variablen
				$aRecords[$x] = _ISN_Variablen_aufloesen($aRecords[$x], _ISN_Variablen_aufloesen($NewProject_RootPath), $ISN_NewProject_MainfileName)
			Next
			_FileWriteFromArray(_ISN_Variablen_aufloesen($NewProject_RootPath & "\" & $ISN_NewProject_MainfileName), $aRecords, 1)
		EndIf
		$Pfad_zur_Project_ISN = $Pfad_zur_Project_ISN_backup
	EndIf

	;Insert HighDPI Code in the script
	If GUICtrlRead($new_project_HighDPIProject_checkbox) = $GUI_CHECKED Then

		Dim $aRecords
		_FileReadToArray($NewProjectFullMainfilePath, $aRecords, $FRTA_NOCOUNT)
		If IsArray($aRecords) Then
			Local $PositionFound = False
			For $cnt = 0 To UBound($aRecords) - 1

				If StringInStr($aRecords[$cnt], "#include ") Then
					;Found an include, include the HighDPI code above
					$PositionFound = True
					_ArrayInsert($aRecords, $cnt - 1, $ISN_HighDPICodeSnippet)
					ExitLoop
				EndIf

				If StringInStr($aRecords[$cnt], "GuiCreate") Then
					;Found an GUI, include the HighDPI code above
					$PositionFound = True
					_ArrayInsert($aRecords, $cnt - 1, $ISN_HighDPICodeSnippet)
					ExitLoop
				EndIf

			Next
			If Not $PositionFound Then
				;If no include was include it at the end of the file
				_ArrayAdd($aRecords, $ISN_HighDPICodeSnippet)
			EndIf
		EndIf
		_FileWriteFromArray($NewProjectFullMainfilePath, $aRecords, 1)
	EndIf


	If $Noopen = 0 Then
		Sleep(500)
		GUISetState(@SW_ENABLE, $StudioFenster)
		If GUICtrlRead($new_projectstammordner_checkbox) = $GUI_CHECKED Then
			_Load_Project_by_Foldername(_ISN_Variablen_aufloesen($NewProject_RootPath))
			$History_Projekte_Array = _fuege_in_History_ein($History_Projekte_Array, StringTrimRight(GUICtrlRead($new_projectusefollowingmainfile_input), StringLen(GUICtrlRead($new_projectusefollowingmainfile_input)) - StringInStr(GUICtrlRead($new_projectusefollowingmainfile_input), "\", 0, -1) + 1))
		Else
			_Load_Project_by_Foldername(_ISN_Variablen_aufloesen($NewProject_RootPath))
			$History_Projekte_Array = _fuege_in_History_ein($History_Projekte_Array, _ISN_Variablen_aufloesen($NewProject_RootPath))
		EndIf
	Else
		GUISetState(@SW_ENABLE, $projectmanager)
		_Show_Projectman()
	EndIf

	_Earn_trophy(1, 1)

EndFunc   ;==>_Create_New_Project



Func _oeffne_Editormodus_Leer()
	_oeffne_Editormodus("")
EndFunc   ;==>_oeffne_Editormodus_Leer

Func _oeffne_Editormodus_mit_Datei_waehlen()
	If $Skin_is_used = "true" Then
		$var = _WinAPI_OpenFileDlg(_Get_langstr(508), "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}", _Get_langstr(58) & " (*.*)", 0, '', '', BitOR($OFN_PATHMUSTEXIST, $OFN_FILEMUSTEXIST, $OFN_HIDEREADONLY), $OFN_EX_NOPLACESBAR, 0, 0, $Welcome_GUI)
	Else
		$var = FileOpenDialog(_Get_langstr(508), "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}", _Get_langstr(58) & " (*.*)", 1 + 2, "", $Welcome_GUI)
	EndIf
	FileChangeDir(@ScriptDir)
	If $var = "" Then Return
	If @error Then Return
	_oeffne_Editormodus($var)
EndFunc   ;==>_oeffne_Editormodus_mit_Datei_waehlen



Func _oeffne_Editormodus($Datei = "")
	If Not FileExists($Arbeitsverzeichnis & "\Data\Editormode\project.isn") Then
		_Write_ISN_Debug_Console("\\Data\\Editormode\\project.isn not found! I create the file for you now... :)", 2)
		DirCreate($Arbeitsverzeichnis & "\Data\Editormode")
		IniWrite($Arbeitsverzeichnis & "\Data\Editormode\project.isn", "ISNAUTOITSTUDIO", "name", "Editormode")
	EndIf
	_Write_ISN_Debug_Console("Switch to Editormode...")
	_show_Loading(_Get_langstr(662), _Get_langstr(23))
	GUISetState(@SW_HIDE, $Welcome_GUI)
;~ 	GUISetState(@SW_LOCK, $studiofenster)
	$Studiomodus = 2 ;EDITOR MODUS
	$Offene_tabs = 0
	$Offenes_Projekt = $Arbeitsverzeichnis & "\Data\Editormode"
	$Pfad_zur_Project_ISN = _Finde_Projektdatei($Offenes_Projekt)
	;Prüfe, ob die Projektdatei bereits auf UTF-16 (LE) konvertiert wurde
	If FileGetEncoding($Pfad_zur_Project_ISN) <> 32 Then
		_Datei_nach_UTF16_konvertieren($Pfad_zur_Project_ISN, False)
	EndIf
	$Offenes_Projekt_name = "Editormode"
	_Loading_Progress(30)
	_RDC_Delete($RDC_UDFs_Thread)
	$RDC_UDFs_Thread = _RDC_Create(_ISN_Variablen_aufloesen($UDFs_Folder), 1, BitOR($FILE_NOTIFY_CHANGE_FILE_NAME, $FILE_NOTIFY_CHANGE_DIR_NAME), 0, $Studiofenster)
	_Write_log(_Get_langstr(662), "000000", "true", "true")
	GUICtrlSetState($Projecttree_Searchbar, $GUI_HIDE)
	GUICtrlSetState($Projecttree_Searchbar_ClearButton, $GUI_HIDE)
	_Aktualisiere_Splittercontrols()
	_Skripteditor_APIs_und_properties_neu_einlesen()
	SCI_InitEditorAu3($scintilla_Codeausschnitt, $SCI_DEFAULTCALLTIPDIR, $SCI_DEFAULTKEYWORDDIR, $SCI_DEFAULTABBREVDIR)
	SCI_InitEditorAu3($Makro_Codeausschnitt_GUI_scintilla, $SCI_DEFAULTCALLTIPDIR, $SCI_DEFAULTKEYWORDDIR, $SCI_DEFAULTABBREVDIR)
	SCI_InitEditorAu3($pelock_obfuscator_GUI_Eingabe_scintilla, $SCI_DEFAULTCALLTIPDIR, $SCI_DEFAULTKEYWORDDIR, $SCI_DEFAULTABBREVDIR)
	SCI_InitEditorAu3($pelock_obfuscator_GUI_Ausgabe_scintilla, $SCI_DEFAULTCALLTIPDIR, $SCI_DEFAULTKEYWORDDIR, $SCI_DEFAULTABBREVDIR)
	SCI_InitEditorAu3($ISN_UDF_Manager_GUI_UDFPreview_scintilla, $SCI_DEFAULTCALLTIPDIR, $SCI_DEFAULTKEYWORDDIR, $SCI_DEFAULTABBREVDIR)
	_Aktualisiere_oder_erstelle_Projektbaum("")
	_GUICtrlTVExplorer_Expand($hWndTreeview)

	;Set focus to the first item in the treeview
	If $ShowFavoritesInProjecttree = "true" Then _GUICtrlTVExplorer_Expand($hWndTreeview, _ISN_Variablen_aufloesen($FavoritesSubfolder))
	Local $FirstItem = _GUICtrlTreeView_GetFirstItem($hWndTreeview)
	_GUICtrlTreeView_SelectItem($hWndTreeview, $FirstItem, $TVGN_CARET)


	_Write_in_Config("lastproject", _ISN_Pfad_durch_Variablen_ersetzen($Offenes_Projekt, 1))
	_ISN_Set_Variable_in_Plugin($ISN_Helper_Threads[$ISN_Helper_Scripttree][$ISN_Helper_Handle], "$ISN_AutoIt_Studio_ISN_file_Path", $Pfad_zur_Project_ISN) ;Update $ISN_AutoIt_Studio_ISN_file_Path in scripttree thread
	_ISN_Set_Variable_in_Plugin($ISN_Helper_Threads[$ISN_Helper_Scripttree][$ISN_Helper_Handle], "$ISN_AutoIt_Studio_opened_project_Path", $Offenes_Projekt) ;Update $ISN_AutoIt_Studio_opened_project_Path in scripttree thread
	_ISN_Set_Variable_in_Plugin($ISN_Helper_Threads[$ISN_Helper_Scripttree][$ISN_Helper_Handle], "$ISN_AutoIt_Studio_opened_project_Name", $Offenes_Projekt_name) ;Update $ISN_AutoIt_Studio_opened_project_Name in scripttree thread
	_ISN_Set_Variable_in_Plugin($ISN_Helper_Threads[$ISN_Helper_Scripttree][$ISN_Helper_Handle], "$Studiomodus", $Studiomodus) ;Update $Studiomodus in scripttree thread

	If $Datei <> "" Then $History_Projekte_Array = _fuege_in_History_ein($History_Projekte_Array, $Datei)
	If $Datei <> "" Then _GUICtrlTVExplorer_Expand($hWndTreeview, $Datei)
	_Lade_Zuletzt_Verwendete_Dateien_aus_projectISN()
	_ToDo_Liste_erstelle_Standard_Kategorien()
	_Reload_Ruleslots()
	_Check_Buttons(0)
	_ISN_Call_Async_Function_in_Plugin($ISN_Helper_Threads[$ISN_Helper_Scripttree][$ISN_Helper_Handle], "_Scripttree_reload_filterarray") ;Reload Filterarray in thread
	If $lade_zuletzt_geoeffnete_Dateien = "true" Then _Oeffne_alte_Tabs(IniRead($Arbeitsverzeichnis & "\Data\Editormode\project.isn", "ISNAUTOITSTUDIO", "opened_tabs", ""))
	_Loading_Progress(50)
	If $Datei <> "" And FileExists($Datei) Then Try_to_opten_file($Datei)
	_Loading_Progress(70)
	_deaktiviere_Buttons_fuer_Editormodus()
	_QuickView_Load_Notes_from_ISN()
	_QuickView_ToDo_Liste_neu_einlesen()
	WinSetTitle($Studiofenster, "", _Get_langstr(1) & " - " & _Get_langstr(661))
;~ 	GUISetState(@SW_UNLOCK, $studiofenster)
	GUISetState(@SW_ENABLE, $StudioFenster)
	_Loading_Progress(100)
	_Hide_Loading()
	_QuickView_Tab_Event()
	_Show_Warning("confirmeditormode", 308, _Get_langstr(61), _Get_langstr(667), _Get_langstr(7))

EndFunc   ;==>_oeffne_Editormodus

Func _Try_to_Open_project()
	If _GUICtrlListView_GetSelectionMark($Projects_Listview) = -1 Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(29), 0, $Welcome_GUI)
		Return
	EndIf

	If _Pruefe_auf_mehrere_Projektdateien(_ISN_Variablen_aufloesen(_GUICtrlListView_GetItemText($Projects_Listview, _GUICtrlListView_GetSelectionMark($Projects_Listview), 3))) = True Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1104), 0, $Welcome_GUI)
		Return
	EndIf

	$PID_Read = IniRead(_Finde_Projektdatei(_ISN_Variablen_aufloesen(_GUICtrlListView_GetItemText($Projects_Listview, _GUICtrlListView_GetSelectionMark($Projects_Listview), 3))), "ISNAUTOITSTUDIO", "opened", "")
	If ProcessExists($PID_Read) Then
		$PIDWarningResult = MsgBox(262144 + 48 + 4, _Get_langstr(394), _Get_langstr(331) & @CRLF & @CRLF & _Get_langstr(1553), 0, $Welcome_GUI)
		If $PIDWarningResult = 7 Or @error Then
			If $Autoload = "true" Then GUISetState(@SW_SHOW, $Welcome_GUI)
			Return
		EndIf
	EndIf

	_Load_Project_by_Foldername(_ISN_Variablen_aufloesen(_GUICtrlListView_GetItemText($Projects_Listview, _GUICtrlListView_GetSelectionMark($Projects_Listview), 3)))

EndFunc   ;==>_Try_to_Open_project



Func _Try_to_delete_project_at_welcomepage()
	If _GUICtrlListView_GetSelectionMark($Projects_Listview) = -1 Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(170), 0, $Welcome_GUI)
		Return
	EndIf
	$folder = _ISN_Variablen_aufloesen(_GUICtrlListView_GetItemText($Projects_Listview, _GUICtrlListView_GetSelectionMark($Projects_Listview), 3))
	$answer = MsgBox(262144 + 32 + 4, _Get_langstr(48), _Get_langstr(169) & @CRLF & @CRLF & _Get_langstr(5) & " " & _
			IniRead(_Finde_Projektdatei($folder), "ISNAUTOITSTUDIO", "name", "#ERROR#") & @CRLF & _
			_Get_langstr(18) & " " & IniRead(_Finde_Projektdatei($folder), "ISNAUTOITSTUDIO", "author", "#ERROR#") & @CRLF & _
			_Get_langstr(171) & " " & IniRead(_Finde_Projektdatei($folder), "ISNAUTOITSTUDIO", "date", "#ERROR#") & @CRLF & _
			_Get_langstr(17) & " " & IniRead(_Finde_Projektdatei($folder), "ISNAUTOITSTUDIO", "comment", "#ERROR#") & @CRLF & @CRLF & _
			_Get_langstr(172), 0, $Welcome_GUI)

	If $answer = 6 Then
		DirRemove($folder, 1)
		_Load_Projectlist()
	EndIf
EndFunc   ;==>_Try_to_delete_project_at_welcomepage

;===============================================================================
;
; Function Name:   _RunReadStd()
;
; Description::    Run a specified command, and return the Exitcode, StdOut text and
;                  StdErr text from from it. StdOut and StdErr are @tab delimited,
;                  with blank lines removed.
;
; Parameter(s):    $doscmd: the actual command to run, same as used with Run command
;                  $timeoutSeconds: maximum execution time in seconds, optional, default: 0 (wait forever),
;                  $workingdir: directory in which to execute $doscmd, optional, default: @ScriptDir
;                  $flag: show/hide flag, optional, default: @SW_HIDE
;                  $sDelim: stdOut and stdErr output deliminter, optional, default: @TAB
;                  $nRetVal: return single item from function instead of array, optional, default: -1 (return array)
;                  $MultiByteCodepage: Codepage for MultiByteToWideChar (if needed)
;
;
; Requirement(s):  AutoIt 3.2.10.0
;
; Return Value(s): An array with three values, Exit Code, StdOut and StdErr
;
; Author(s):       lod3n
;                  (Thanks to mrRevoked for delimiter choice and non array return selection)
;                  (Thanks to mHZ for _ProcessOpenHandle() and _ProcessGetExitCode())
;                  (MetaThanks to DaveF for posting these DllCalls in Support Forum)
;                  (MetaThanks to JPM for including CloseHandle as needed)
;
;===============================================================================

Func _RunReadStd($doscmd, $timeoutSeconds = 0, $workingdir = @ScriptDir, $flag = @SW_HIDE, $nRetVal = -1, $sDelim = @TAB, $MultiByteCodepage = -1)
	Local $aReturn, $i_Pid, $h_Process, $i_ExitCode, $sStdOut, $sStdErr, $runTimer
	Dim $aReturn[3]

	; run process with StdErr and StdOut flags
	$runTimer = TimerInit()
	$i_Pid = Run($doscmd, $workingdir, $flag, 6) ; 6 = $STDERR_CHILD+$STDOUT_CHILD
	$RUNNING_SCRIPT = $i_Pid
	; Get process handle
	Sleep(100) ; or DllCall may fail - experimental
	$h_Process = DllCall('kernel32.dll', 'ptr', 'OpenProcess', 'int', 0x400, 'int', 0, 'int', $i_Pid)

	Global $iProcessID = $i_Pid

	$hPDHQuery = _PDH_GetNewQueryHandle()

	; Get the localized name for "Process"
	$sProcessLocal = _PDH_GetCounterNameByIndex(230, "")

	Global $poCounter = _PDH_ProcessObjectCreate($sProcess, $iProcessID)
;~ 	ConsoleWrite($poCounter & @CRLF)
	_PDH_ProcessObjectAddCounters($poCounter, "6;180") ; "% Processor Time;Working Set"
	_PDH_ProcessObjectCollectQueryData($poCounter)

	; create tab delimited string containing StdOut text from process
	$aReturn[1] = ""
	$sStdOut = ""
	While 1
		Sleep(500)
		$line = StdoutRead($i_Pid)
		If @error Then ExitLoop
		If $MultiByteCodepage <> -1 Then $line = _WinAPI_MultiByteToWideChar($line, $MultiByteCodepage, 0, True) ;Convert Multibyte Chars
		$sStdOut &= $line
		_Write_debug($line)
	WEnd

	; fetch exit code and close process handle
	If IsArray($h_Process) Then
		Sleep(100) ; or DllCall may fail - experimental
		$i_ExitCode = DllCall('kernel32.dll', 'ptr', 'GetExitCodeProcess', 'ptr', $h_Process[0], 'int*', 0)
		If IsArray($i_ExitCode) Then
			$aReturn[0] = $i_ExitCode[2]
		Else
			$aReturn[0] = -1
		EndIf
		Sleep(100) ; or DllCall may fail - experimental
		DllCall('kernel32.dll', 'ptr', 'CloseHandle', 'ptr', $h_Process[0])
	Else
		$aReturn[0] = -2
	EndIf

	$aReturn[0] = $sStdOut
	$aReturn[1] = $i_ExitCode[2]
	$aReturn[2] = $i_Pid
	Return $aReturn

	; return single item if correctly specified with with $nRetVal
	If $nRetVal <> -1 And $nRetVal >= 0 And $nRetVal <= 2 Then Return $aReturn[$nRetVal]

	; return array with exit code, stdout, and stderr
	Return $aReturn
EndFunc   ;==>_RunReadStd

Func _Disable_edit()
	If _GUICtrlTab_GetItemCount($htab) = 0 Then Return
	WinSetState($SCE_EDITOR[_GUICtrlTab_GetCurFocus($htab)], "", @SW_DISABLE)
EndFunc   ;==>_Disable_edit

Func _ENABLE_edit()
	If _GUICtrlTab_GetItemCount($htab) = 0 Then Return
	WinSetState($SCE_EDITOR[_GUICtrlTab_GetCurFocus($htab)], "", @SW_ENABLE)
EndFunc   ;==>_ENABLE_edit

Func _Try_to_Exit()
	If $closeaction = "close" Then AdlibRegister("_exit", 1)
	If $closeaction = "closeproject" Then AdlibRegister("_Close_Project_Adlib", 1)
	If $closeaction = "minimize" Then WinSetState($Studiofenster, "", @SW_MINIMIZE)
EndFunc   ;==>_Try_to_Exit

Func _exit_force()
	$AskExit = "false"
	$SHOW_DEBUG_CONSOLE = "false"
	AdlibRegister("_exit", 1)
EndFunc   ;==>_exit_force

Func _exit()
	AdlibUnRegister("_exit")

	If $Can_open_new_tab = 0 Then Return

	If $AskExit = "true" Then
		$i = MsgBox(262144 + 32 + 4, _Get_langstr(48), _Get_langstr(188), 0, $Studiofenster)
		If $i = 7 Then Return
	EndIf
	_Write_ISN_Debug_Console("Shutting down ISN AutoIt Studio...", 2)
	$ISN_Shutdown_initiated = 1
	_EasyHotKey_Pause()
	AdlibUnRegister("_Adlib_ISN_Ram_bereinigen")
	AdlibUnRegister("_ISN_Helper_Thread_Adlib")


	_ISN_AutoIt_Studio_Unregister_CommandLineTool()
	_ISN_Gui_Size_Saving_Save_Settings()
	GUISetState(@SW_HIDE, $msgboxcreator)
	GUISetState(@SW_HIDE, $fFind1)
	GUISetState(@SW_HIDE, $colour_picker)
	GUISetState(@SW_HIDE, $bitwise_operations_GUI)
	GUISetState(@SW_HIDE, $ToDoList_Manager)
	GUISetState(@SW_HIDE, $ParameterEditor_GUI)
	GUISetState(@SW_HIDE, $Welcome_GUI)
	GUISetState(@SW_HIDE, $QuickView_GUI)
	GUISetState(@SW_HIDE, $StudioFenster)
	WinMove($StudioFenster, "", 900000, 900000)


	;If a project is opened, close them carefully
	If $Offenes_Projekt <> "" Then
		_Write_ISN_Debug_Console("|--> Close opened project...", 1)
		If _GUICtrlTab_GetItemCount($htab) > 0 And _GUICtrlTab_GetCurFocus($htab) <> -1 Then
			WinMove($SCE_EDITOR[_GUICtrlTab_GetCurFocus($htab)], "", 900000, 900000)
			If $Plugin_Handle[_GUICtrlTab_GetCurFocus($htab)] <> -1 Then _ISN_Send_Message_to_Plugin($Plugin_Handle[_GUICtrlTab_GetCurFocus($htab)], "resize") ;Plugin versteckt sich auch beim herunterfahren
		EndIf
		_Close_Project()
	EndIf

	;Remove WTS Session Notification
	DllCall("Wtsapi32.dll", "int", "WTSUnRegisterSessionNotification", "hwnd", $Studiofenster)

	;Exit the helper threads
	_Write_ISN_Debug_Console("|--> Exit all helper threads (except the updater)..", 1)
	_ISN_AutoIt_Studio_Exit_All_Helper_Threads()


	;Clean up some stuff
	FileDelete($Cachefile)
	_ISN_Reset_Backuplist()
	If FileExists($Arbeitsverzeichnis & "\Data\Cache\temprun.au3") Then FileDelete($Arbeitsverzeichnis & "\Data\Cache\temprun.au3")
	If FileExists($Arbeitsverzeichnis & "\Data\Cache\print.html") Then FileDelete($Arbeitsverzeichnis & "\Data\Cache\print.html")
	If FileExists($Arbeitsverzeichnis & "\data\cache\AutoIt_Studio_Print.txt") Then FileDelete($Arbeitsverzeichnis & "\data\cache\AutoIt_Studio_Print.txt")
	If FileExists($Arbeitsverzeichnis & "\Data\Cache\tempcompile") Then DirRemove($Arbeitsverzeichnis & "\Data\Cache\tempcompile", 1)

	;Run a app before exiting the isn
	If $runafter <> "" Then
		_Write_ISN_Debug_Console("|--> Run '" & $runafter & "' before exiting...", 1)
		_Run_Beforexit()
	EndIf


	;Deactivate WindowMessages and callbacks
	_Write_ISN_Debug_Console("|--> Deactivate WindowMessages and callbacks...", 1)
	GUIRegisterMsg($WM_NOTIFY, '')
	GUIRegisterMsg($WM_COMMAND, "")
	GUIRegisterMsg($WM_SYSCOMMAND, "")
	GUIRegisterMsg($WM_DROPFILES, "")
	GUIRegisterMsg($WM_GETMINMAXINFO, "")
	GUIRegisterMsg($WM_WINDOWPOSCHANGING, "")
	GUIRegisterMsg($WM_NCLBUTTONDBLCLK, "")
	GUIRegisterMsg($WM_SIZE, "")
	GUIRegisterMsg($WM_SIZING, "")
	GUIRegisterMsg($WM_ENTERSIZEMOVE, "")
	GUIRegisterMsg($WM_EXITSIZEMOVE, "")
	GUIRegisterMsg($WM_NCACTIVATE, "")
	GUIRegisterMsg($WM_RDC, '')
	GUIRegisterMsg($WM_DRAWCLIPBOARD, "")
	GUIRegisterMsg($WM_ACTIVATE, "")

	_ISN_AutoIt_Studio_Destroy_GUI_Tooltips()
	_GUICtrlListView_UnRegisterSortCallBack($changelogmanager_listview)
	_ClipBoard_ChangeChain($StudioFenster, $ISN_ClipBoardNextHwnd) ;Remove the main window from the clipboard-chain

	_Write_ISN_Debug_Console("|--> ISN AutoIt Studio shutdown complete! Bye... ;)", 1)
	;If $SHOW_DEBUG_CONSOLE = "true" And $ISN_Restart_initiated = 0 Then MsgBox(262144, "ISN AutoIt Studio", "Press ok to exit", 0,$console_GUI)
	GUISetState(@SW_HIDE, $console_GUI)


	;Shutdown UDFs an all the other stuff
	_ChatBoxDestroy($console_chatbox)
	_ChatBoxDestroy($Programm_log)
	_ChatBoxDestroy($Credits_Srollbox)
	_RDC_Destroy()
	_RDC_CloseDll()
	_GUICtrlTVExplorer_DestroyAll()
	_ISN_UDF_Manager_DestroyTreeView()
	_PDH_UnInit()
	OnAutoItExit_modern()
	OnAutoItExit()
	_USkin_Exit()
	DllClose($dll)
	DllClose($user32)
	DllClose($kernel32)

	;Was a restart initated?
	If $ISN_Restart_initiated = 1 Then
		If @Compiled Then
			If FileExists(@ScriptDir & "\Autoit_Studio.exe") Then
				If IsAdmin() And $StartISNAsAdmin = "false" Then
					_RunWithReducedPrivileges(@ScriptDir & "\Autoit_Studio.exe", '', @ScriptDir)
				Else
					ShellExecute(@ScriptDir & "\Autoit_Studio.exe")
				EndIf
			EndIf
		Else
			If IsAdmin() And $StartISNAsAdmin = "false" Then
				_RunWithReducedPrivileges($autoitexe, '"' & $autoitexe & '" "' & @ScriptDir & '\' & @ScriptName & '"', @ScriptDir)
			Else
				ShellExecute($autoitexe, '"' & @ScriptDir & '\' & @ScriptName & '"')
			EndIf
		EndIf
	EndIf

	Exit 0 ;bye
EndFunc   ;==>_exit

Func _Close_Project_Adlib()
	AdlibUnRegister("_Close_Project_Adlib")
	_Close_Project()
EndFunc   ;==>_Close_Project_Adlib

Func _Close_Project($Changelogeintrag_anzeigen = "true")
	If $Offenes_Projekt = "" Then Return 1 ;No project opened
	If $Can_open_new_tab = 0 Then Return
	If $SKRIPT_LAUEFT = 1 Then _STOPSCRIPT()
	IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "opened", "")
	$Benoetigte_Zeit = 0
	If $Templatemode = 0 And $Tempmode = 0 And $Studiomodus = 1 Then $Benoetigte_Zeit = _stop_Project_timer()
	_Write_ISN_Debug_Console("Closing project (" & $Offenes_Projekt_name & ")...", 1)
	_Colour_Calltipp_Set_State("hide")
	_Clear_Debuglog()
	_ISN_VariablesSelector_HideGUI()	
	_QuickView_Save_Notes()
	_ISN_UDFManager_ClearSearchbar()
	_ISN_QuickSearchBar_ClearInputButton()
	_ISN_ProjecttreeSearchbar_ClearInputButton()
	_ISN_QuickView_UDFExplorer_ClearSearchbar()
	_ISN_UDF_Manager_DestroyTreeView()
	Sci_DelLines($QuickView_Notes_Scintilla)
	_Debug_clear_redo()
	GUISetState(@SW_HIDE, $msgboxcreator)
	GUISetState(@SW_HIDE, $fFind1)
	GUISetState(@SW_HIDE, $colour_picker)
	GUISetState(@SW_HIDE, $bitwise_operations_GUI)
	GUISetState(@SW_HIDE, $ToDoList_Manager)
	GUISetState(@SW_HIDE, $ParameterEditor_GUI)
	;Speichere geöffnete Tabs in die project.IsNumber
	$Pfade = ""
	If _GUICtrlTab_GetItemCount($htab) > 0 Then
		For $x = 0 To _GUICtrlTab_GetItemCount($htab) - 1
			$Pfade = $Pfade & _ISN_Pfad_durch_Variablen_ersetzen($Datei_pfad[$x]) & "|"
		Next
	EndIf
	IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "opened_tabs", $Pfade)

	;Reset some fields
	_GUICtrlTreeView_DeleteAll($hWndTreeview)
	_GUICtrlListView_DeleteAllItems(GUICtrlGetHandle($in_dateien_suchen_gefundene_elemente_listview))
	GUICtrlSetData($in_dateien_suchen_suchtext_input, "")
	_ISN_QuickSearchBar_Set_State("hide")
	_Close_All_Tabs()
	_Write_ISN_Debug_Console("|--> Closing Type 3 Plugins...", 1)
	_Laufende_Type3_Plugins_Beenden()
	_Write_ISN_Debug_Console("|--> Type 3 Plugins closed!", 1)
	_Reset_all_Helperthreads()
	WinSetTitle($Studiofenster, "", _Get_langstr(1))
	If $Studiomodus = 1 Then
		_Write_log(_Get_langstr(311) & "(" & $Offenes_Projekt_name & ")", "000000", "true", "true")
	Else
		_Write_log(_Get_langstr(665) & "...", "000000", "true", "true")
	EndIf
	_Write_log("", "000000", "true", "true")
	If $Changelogeintrag_anzeigen = "true" Then _Zeige_neuer_changelog_eintrag_GUI()
	_run_rule($Section_Trigger_BeforeCloseProject)
	AdlibUnRegister("_Backup_Files")
	AdlibUnRegister("_ISN_Automatische_Speicherung_Sekundenevent")
	_ISN_Reset_Backuplist() ;Lösche Backupcache
	_Clear_Projecttree_Rebuild()
	_RDC_Destroy()
	_Write_ISN_Debug_Console("|--> Killing Type 3 Plugins...", 1)
	_Kille_Laufende_Type3_Plugins()
	If $Tempmode = 1 Then DirRemove($Offenes_Projekt, 1) ;Clean up tempprojects
	$Offenes_Projekt = ""
	$Offenes_Projekt_name = ""
	$Pfad_zur_Project_ISN = ""
	$Parameter_SCE_HANDLE = ""
	$Offene_tabs = 0
	$Tempmode = 0
	$SKRIPT_LAUEFT = 0
	$Studiomodus = 1
	$Projektbaum_ist_bereit = 1
	$QuickView_Current_Tab = -1
	$Can_switch_tabs = 1
	_GUICtrlStatusBar_SetText_ISN($Status_bar, "")
	If $ISN_Shutdown_initiated <> 1 Then _Load_Projectlist()
	_ToDo_Liste_leeren()
	;RDC Verzeichnise freigeben

	If BitAND(WinGetState($StudioFenster, ""), 2) Then
		;If ISN Window is still visible
		;If it´s already hidden..the ISN is maybe already shutting down. So we ned not to show any guis here
		GUISetState(@SW_DISABLE, $StudioFenster)
		If $Templatemode = 0 Then
			GUISetState(@SW_SHOW, $Welcome_GUI)
		Else
			GUISetState(@SW_SHOW, $projectmanager)
		EndIf
		$Templatemode = 0

	EndIf
EndFunc   ;==>_Close_Project


Func _GUICtrlStatusBar_SetText_ISN($handle = "", $text = "")
	If $handle = "" Then Return
	_GUICtrlStatusBar_SetText($handle, $text)
EndFunc   ;==>_GUICtrlStatusBar_SetText_ISN

Func _Load_Projectlist()
	_Write_ISN_Debug_Console("|--> Loading Projects...", 1, 0)
	_Read_Last_4_Projects()
	_GUICtrlListView_DeleteAllItems(GUICtrlGetHandle($Projects_Listview))
	ScanforProjects()
	_Write_ISN_Debug_Console("done", 1, 1, 1, 1)
EndFunc   ;==>_Load_Projectlist

Func ScanforProjects()
	Local $Search
	Local $file
	Local $FileAttributes
	Local $FullFilePath
	$Count = 0


	;List Projects in the main ISN Projects folder
	$Search = FileFindFirstFile(_ISN_Variablen_aufloesen($Projectfolder) & "\*.*")
	_GUICtrlListView_BeginUpdate($Projects_Listview)
	While 1
		If $Search = -1 Then
			ExitLoop
		EndIf
		$file = FileFindNextFile($Search)
		If @error Then ExitLoop
		If $file = "." Or $file = ".." Then ContinueLoop
		$FullFilePath = _ISN_Variablen_aufloesen($Projectfolder) & "\" & $file
		$FileAttributes = FileGetAttrib($FullFilePath)
		If StringInStr($FileAttributes, "D") Then
			If FileExists(_Finde_Projektdatei($FullFilePath)) Then
				$tmp_isn_file = _Finde_Projektdatei($FullFilePath)
				$tmp = IniReadSection($tmp_isn_file, "ISNAUTOITSTUDIO")
				If Not @error Then
					$Count = $Count + 1
					_GUICtrlListView_AddItem($Projects_Listview, IniRead($tmp_isn_file, "ISNAUTOITSTUDIO", "name", "#ERROR#"), 39)
					_GUICtrlListView_AddSubItem($Projects_Listview, _GUICtrlListView_GetItemCount($Projects_Listview) - 1, IniRead($tmp_isn_file, "ISNAUTOITSTUDIO", "author", ""), 1)
					_GUICtrlListView_AddSubItem($Projects_Listview, _GUICtrlListView_GetItemCount($Projects_Listview) - 1, IniRead($tmp_isn_file, "ISNAUTOITSTUDIO", "comment", ""), 2)
					_GUICtrlListView_AddSubItem($Projects_Listview, _GUICtrlListView_GetItemCount($Projects_Listview) - 1, _ISN_Pfad_durch_Variablen_ersetzen($FullFilePath), 3)
				EndIf
			EndIf
		EndIf
	WEnd
	FileClose($Search)

	;Add aditional paths for ISN projects to the list and enable the group view (if vista or higher)
	If $Additional_project_paths <> "" Then
		$Additional_Paths_Array = StringSplit($Additional_project_paths, "|", 2)
		If IsArray($Additional_Paths_Array) Then
			For $path_count = 0 To UBound($Additional_Paths_Array) - 1
				If $Additional_Paths_Array[$path_count] = "" Then ContinueLoop
				If FileExists(_ISN_Variablen_aufloesen($Additional_Paths_Array[$path_count])) Then
					$Search = FileFindFirstFile(_ISN_Variablen_aufloesen($Additional_Paths_Array[$path_count]) & "\*.*")
					While 1
						If $Search = -1 Then
							ExitLoop
						EndIf
						$file = FileFindNextFile($Search)
						If @error Then ExitLoop
						If $file = "." Or $file = ".." Then ContinueLoop
						$FullFilePath = _ISN_Variablen_aufloesen($Additional_Paths_Array[$path_count]) & "\" & $file
						$FileAttributes = FileGetAttrib($FullFilePath)
						If StringInStr($FileAttributes, "D") Then
							If FileExists(_Finde_Projektdatei($FullFilePath)) Then
								$tmp_isn_file = _Finde_Projektdatei($FullFilePath)
								$tmp = IniReadSection($tmp_isn_file, "ISNAUTOITSTUDIO")
								If Not @error Then
									$Count = $Count + 1
									$new_item = _GUICtrlListView_AddItem($Projects_Listview, IniRead($tmp_isn_file, "ISNAUTOITSTUDIO", "name", "#ERROR#"), 39)
									_GUICtrlListView_AddSubItem($Projects_Listview, _GUICtrlListView_GetItemCount($Projects_Listview) - 1, IniRead($tmp_isn_file, "ISNAUTOITSTUDIO", "author", ""), 1)
									_GUICtrlListView_AddSubItem($Projects_Listview, _GUICtrlListView_GetItemCount($Projects_Listview) - 1, IniRead($tmp_isn_file, "ISNAUTOITSTUDIO", "comment", ""), 2)
									_GUICtrlListView_AddSubItem($Projects_Listview, _GUICtrlListView_GetItemCount($Projects_Listview) - 1, _ISN_Pfad_durch_Variablen_ersetzen($FullFilePath), 3)
								EndIf
							EndIf
						EndIf
					WEnd
					FileClose($Search)
				EndIf
			Next
		EndIf
	EndIf


	$Descending = False
	_GUICtrlListView_SimpleSort($Projects_Listview, $Descending, 0)
	_GUICtrlListView_SetItemSelected($Projects_Listview, -1, False, False)
	_GUICtrlListView_EndUpdate($Projects_Listview)
	If $Count > 4 Then _Earn_trophy(5, 1)
EndFunc   ;==>ScanforProjects

Func _Clear_Projecttree_Rebuild()
	$Projektbaum_Treeview_Expanded_Array = $Projektbaum_Treeview_Expanded_Array_empty
EndFunc   ;==>_Clear_Projecttree_Rebuild

Func _Clear_Scripttree_Rebuild()
	$Scripttree_Treeview_Expanded_Array = $Projektbaum_Treeview_Expanded_Array_empty
EndFunc   ;==>_Clear_Scripttree_Rebuild

; #FUNCTION# ;===============================================================================
;
; Name...........: _Speichere_TVExplorer
; Description ...: Speichert alle geöffneten (expanded) Elemente des Projektbaumen im $Projektbaum_Treeview_Expanded_Array Array
; Syntax.........: _Speichere_TVExplorer($hTreeView)
; Parameters ....: $hTreeView			- Handle zum Treeview
; Return values .: None
; Author ........: ISI360
; Modified.......:
; Remarks .......:
; Related .......:
; Link ..........: https://www.isnetwork.at
; Example .......: No
;
; ;==========================================================================================

Func _Speichere_TVExplorer($hTreeViewcntrl = "")
	If $hTreeViewcntrl = "" Then Return
	_Clear_Projecttree_Rebuild()
	$found = 0
	$hItem = _GUICtrlTreeView_GetFirstItem($hTreeViewcntrl)
	If _GUICtrlTreeView_GetExpanded($hTreeViewcntrl, $hItem) = True Then
		$Projektbaum_Treeview_Expanded_Array[$found] = _GUICtrlTreeView_GetText($hTreeViewcntrl, $hItem)
		$found = $found + 1
	EndIf
	While True
		$hItem = _GUICtrlTreeView_GetNext($hTreeViewcntrl, $hItem)
		If $hItem = 0 Then ExitLoop
		If _GUICtrlTreeView_GetExpanded($hTreeViewcntrl, $hItem) = True Then
			$Projektbaum_Treeview_Expanded_Array[$found] = _GUICtrlTreeView_GetText($hTreeViewcntrl, $hItem)
			$found = $found + 1
		EndIf
	WEnd
EndFunc   ;==>_Speichere_TVExplorer

; #FUNCTION# ;===============================================================================
;
; Name...........:  _Lade_TVExplorer
; Description ...: Lädt alle geöffneten (expanded) Elemente des Projektbaumen aus dem $Projektbaum_Treeview_Expanded_Array Array
; Syntax.........:  _Lade_TVExplorer($hTreeView)
; Parameters ....: $hTreeView			- Handle zum Treeview
; Return values .: None
; Author ........: ISI360
; Modified.......:
; Remarks .......:
; Related .......:
; Link ..........: https://www.isnetwork.at
; Example .......: No
;
; ;==========================================================================================

Func _Lade_TVExplorer($hTreeViewcntrl = "")
	If $hTreeViewcntrl = "" Then Return
	Local $hItem = _GUICtrlTreeView_GetFirstItem($hTreeViewcntrl)
	$res = _ArraySearch($Projektbaum_Treeview_Expanded_Array, _GUICtrlTreeView_GetText($hTreeViewcntrl, $hItem))
	If $res <> -1 Then
		_GUICtrlTVExplorer_Expand($hTreeViewcntrl, _GUICtrlTVExplorer_GetPathFromItem($hTreeViewcntrl, $hItem))
	EndIf
	While True
		$hItem = _GUICtrlTreeView_GetNext($hTreeViewcntrl, $hItem)
		If $hItem = 0 Then ExitLoop
		$res = _ArraySearch($Projektbaum_Treeview_Expanded_Array, _GUICtrlTreeView_GetText($hTreeViewcntrl, $hItem))
		If $res <> -1 Then
			If StringInStr($Offenes_Projekt, _GUICtrlTreeView_GetText($hTreeViewcntrl, $hItem)) And $AutoIt_Projekte_in_Projektbaum_anzeigen = "true" And StringInStr(_GUICtrlTreeView_GetTree($hTreeViewcntrl, $hItem), _Get_langstr(881)) Then ContinueLoop
			_GUICtrlTVExplorer_Expand($hTreeViewcntrl, _GUICtrlTVExplorer_GetPathFromItem($hTreeViewcntrl, $hItem))
		EndIf
	WEnd
EndFunc   ;==>_Lade_TVExplorer

; #FUNCTION# ;===============================================================================
;
; Name...........:  _Update_Treeview
; Description ...: Aktualisiert den Projektbaum
; Syntax.........: _Update_Treeview()
; Parameters ....: None
; Return values .: None
; Author ........: ISI360
; Modified.......:
; Remarks .......: Speichert automatisch geöffnete Elemente und stellt diese nach dem Aktualisieren wieder her
; Related .......:
; Link ..........: https://www.isnetwork.at
; Example .......: No
;
; ;==========================================================================================

Func _Update_Treeview()

	AdlibUnRegister("_Update_Treeview")

	Local $TVExplorer_Control = ""
	If $Offenes_Projekt = "" Then Return
	For $cnt = 0 To UBound($tvData) - 1

		$TVExplorer_Control = $tvData[$cnt][0]
		If Not IsHWnd($TVExplorer_Control) Then ContinueLoop

		;Refreseh only trees, that could contain this file
		If $Studiomodus = 1 And Not StringInStr($LastRDCEventFilePath, $tvData[$cnt][9]) And $LastRDCEventFilePath <> "" Then ContinueLoop
		If $Studiomodus = 2 Then
			If $LastRDCEventFilePath <> "" And $tvData[$cnt][9] <> "" Then
				If Not StringInStr($LastRDCEventFilePath, $tvData[$cnt][9]) Then ContinueLoop
			Else
				If $Current_TVExplorer_TreeView <> $TVExplorer_Control Then ContinueLoop
			EndIf
		EndIf


		Local $tSCROLLINFO_Projecttree_Vert = _GUIScrollBars_GetScrollInfoEx($TVExplorer_Control, $SB_VERT)
		Local $tSCROLLINFO_Projecttree_Horz = _GUIScrollBars_GetScrollInfoEx($TVExplorer_Control, $SB_HORZ)

		_GUICtrlTreeView_BeginUpdate($TVExplorer_Control)
		_Speichere_TVExplorer($TVExplorer_Control) ;Speichere geöffnete Elemente

		Local $old_selected_file = ""

		If $Porjecttree_FileToSelect_after_Update <> "" Then
			$old_selected_file = $Porjecttree_FileToSelect_after_Update
			$Porjecttree_FileToSelect_after_Update = ""
		Else
			$old_selected_file = _GUICtrlTVExplorer_GetSelected($TVExplorer_Control)
		EndIf


		_GUICtrlTVExplorer_AttachFolder($TVExplorer_Control) ;Lade Treeview neu

		If FileExists($old_selected_file) Then
			_GUICtrlTVExplorer_Expand($TVExplorer_Control, $old_selected_file)
		Else
			_GUICtrlTVExplorer_Expand($TVExplorer_Control)
		EndIf

		_Lade_TVExplorer($TVExplorer_Control) ;Geöffnete Elemente wiederherstellen


		If FileExists($old_selected_file) Then
			_GUICtrlTVExplorer_Expand($TVExplorer_Control, $old_selected_file)
		Else
			_GUICtrlTVExplorer_Expand($TVExplorer_Control)
		EndIf


		Local $GetSelectionResult = _GUICtrlTreeView_GetSelection($TVExplorer_Control)

		_GUIScrollBars_SetScrollInfo($TVExplorer_Control, $SB_VERT, $tSCROLLINFO_Projecttree_Vert, False)
		_GUIScrollBars_SetScrollInfo($TVExplorer_Control, $SB_HORZ, $tSCROLLINFO_Projecttree_Horz, False)

		_GUICtrlTreeView_EndUpdate($TVExplorer_Control)

		If $GetSelectionResult <> 0 Then
			If Not _GUICtrlTreeView_GetVisible($TVExplorer_Control, $GetSelectionResult) Then _GUICtrlTreeView_EnsureVisible($TVExplorer_Control, $GetSelectionResult)
		EndIf



		;Additional stuff (for example: also refresh the ACInput control in the udf manager´s search bar
		Switch $TVExplorer_Control

			Case $ISN_UDF_Manager_GUI_hTreeview
				If $ISN_UDF_Manager_GUI_hTreeview <> "" Then AdlibRegister("_ISN_UDFManager_BackgroundScanForAcInput", 1)

			Case $quick_view_udfexplorer_htreeview
				If $quick_view_udfexplorer_htreeview <> "" Then AdlibRegister("_ISN_UDFManager_BackgroundScanForAcInput", 1)

			Case $hWndTreeview
				If $hWndTreeview <> "" Then AdlibRegister("_ISN_Projecttree_BackgroundScanForAcInput", 1)

		EndSwitch


	Next

	$LastRDCEventFilePath = ""

EndFunc   ;==>_Update_Treeview




; #FUNCTION# ;===============================================================================
;
; Name...........: _Aktualisiere_oder_erstelle_Projektbaum
; Description ...: Erstellt bzw.
; Syntax.........: _Aktualisiere_oder_erstelle_Projektbaum($Rootfolder)
; Parameters ....: $Rootfolder			- Ordnerpfad der im Projektbaum angezeigt werden soll
; Return values .: None
; Author ........: ISI360
; Modified.......:
; Remarks .......: Wird jedesmal aufgerufen wenn ein Projekt geöffnet wird. Löscht das alte Treeview Control und erzeugt ein neues mit dem angegebenen Rootpfad
;					Erstellt auch über die Funktion "" das Kontextmenü für den Treeview
; Related .......:
; Link ..........: https://www.isnetwork.at
; Example .......: No
;
; ;==========================================================================================
Func _Aktualisiere_oder_erstelle_Projektbaum($Rootfolder = "")
	$alte_position = _ControlGetPos($Studiofenster, "", $hTreeView) ;hole zuerst die positionen des alten Controls
	_GUICtrlTVExplorer_Destroy($hWndTreeview) ;Zerstöre Inhalt der TVExplorer UDF
;~ 	Global $tvData[1][31] = [[0, _GUIImageList_Create(_WinAPI_GetSystemMetrics(49), _WinAPI_GetSystemMetrics(50), 5, 1), GUICreate('')]] ;Deklariere neu
;~ 	Global $tvIcon[101][3] = [[0]] ;Deklariere neu
	GUISwitch($studiofenster) ;wechsle zum Studiofenster
	_GUICtrlTVExplorer_Create($Rootfolder, $alte_position[0], $alte_position[1], $alte_position[2], $alte_position[3], -1, $WS_EX_CLIENTEDGE, $TV_FLAG_SHOWFILESEXTENSION + $TV_FLAG_SHOWFILES + $TV_FLAG_SHOWFOLDERICON + $TV_FLAG_SHOWFILEICON + $TV_FLAG_SHOWLIKEEXPLORER, "_Projecttree_event", '', $hTreeView) ;Erstelle neuen Treeview an der Position des alten
	;Global $hWndTreeview = GUICtrlGetHandle($hTreeView) ;Erneuere Handle
	GUICtrlSetFont($hTreeView, $treefont_size, 400, 0, $treefont_font) ;Schrift
	GUICtrlSetColor($hTreeView, $treefont_colour) ;Farbe
	GUICtrlSetState($hTreeView, $GUI_DROPACCEPTED) ;aktiviere Drag´nDrop
;~ _Erstelle_Kontextmenue_fuer_Projektbaum()


;~ _GUICtrlTVExplorer_SetExplorerStyle($hWndTreeview) ;aktiviere modernen Explorer Style ;)
EndFunc   ;==>_Aktualisiere_oder_erstelle_Projektbaum

Func _Load_Project($Foldername)
	_ISN_Reset_Backuplist()
	_GUICtrlTab_DeleteAllItems($htab)
	$Offene_tabs = 0
	GUICtrlSetState($hTreeView, $GUI_ENABLE)
	$Pfad_zur_Project_ISN = _Finde_Projektdatei($Foldername)

	;Prüfe, ob die Projektdatei bereits auf UTF-16 (LE) konvertiert wurde
	If FileGetEncoding($Pfad_zur_Project_ISN) <> 32 Then
		MsgBox(262144 + 64, _Get_langstr(61), _Get_langstr(1292), 0, $StudioFenster)
		_Datei_nach_UTF16_konvertieren($Pfad_zur_Project_ISN)
	EndIf

	$Offenes_Projekt = $Foldername
	$Offenes_Projekt_name = IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "name", "")
	_RDC_Delete($RDC_Main_Thread)
	_RDC_Delete($RDC_UDFs_Thread)
	$RDC_Main_Thread = _RDC_Create($Offenes_Projekt, 1, BitOR($FILE_NOTIFY_CHANGE_FILE_NAME, $FILE_NOTIFY_CHANGE_DIR_NAME), 0, $Studiofenster)
	$RDC_UDFs_Thread = _RDC_Create(_ISN_Variablen_aufloesen($UDFs_Folder), 1, BitOR($FILE_NOTIFY_CHANGE_FILE_NAME, $FILE_NOTIFY_CHANGE_DIR_NAME), 0, $Studiofenster)
	_Aktualisiere_oder_erstelle_Projektbaum($Offenes_Projekt)
	_GUICtrlTVExplorer_Expand($hWndTreeview)

	;Set focus to the first item in the treeview
	If $ShowFavoritesInProjecttree = "true" Then _GUICtrlTVExplorer_Expand($hWndTreeview, _ISN_Variablen_aufloesen($FavoritesSubfolder))
	Local $FirstItem = _GUICtrlTreeView_GetFirstItem($hWndTreeview)
	_GUICtrlTreeView_SelectItem($hWndTreeview, $FirstItem, $TVGN_CARET)

	_ISN_Set_Variable_in_Plugin($ISN_Helper_Threads[$ISN_Helper_Scripttree][$ISN_Helper_Handle], "$ISN_AutoIt_Studio_ISN_file_Path", $Pfad_zur_Project_ISN) ;Update $ISN_AutoIt_Studio_ISN_file_Path in scripttree thread
	_ISN_Set_Variable_in_Plugin($ISN_Helper_Threads[$ISN_Helper_Scripttree][$ISN_Helper_Handle], "$ISN_AutoIt_Studio_opened_project_Path", $Offenes_Projekt) ;Update $ISN_AutoIt_Studio_opened_project_Path in scripttree thread
	_ISN_Set_Variable_in_Plugin($ISN_Helper_Threads[$ISN_Helper_Scripttree][$ISN_Helper_Handle], "$ISN_AutoIt_Studio_opened_project_Name", $Offenes_Projekt_name) ;Update $ISN_AutoIt_Studio_opened_project_Name in scripttree thread
	_ISN_Set_Variable_in_Plugin($ISN_Helper_Threads[$ISN_Helper_Scripttree][$ISN_Helper_Handle], "$Studiomodus", $Studiomodus) ;Update $Studiomodus in scripttree thread

	_Lade_Zuletzt_Verwendete_Dateien_aus_projectISN()
	WinSetTitle($Studiofenster, "", IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "name", "") & " - " & _Get_langstr(1))
	$oldoppened = IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "projectopened", "0")
	$oldoppened = $oldoppened + 1
	IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "projectopened", $oldoppened)
	_Reload_Ruleslots()
	_Skripteditor_APIs_und_properties_neu_einlesen()
	_Seach_Labels_Set_Code_Style()
	SCI_InitEditorAu3($scintilla_Codeausschnitt, $SCI_DEFAULTCALLTIPDIR, $SCI_DEFAULTKEYWORDDIR, $SCI_DEFAULTABBREVDIR)
	SCI_InitEditorAu3($Makro_Codeausschnitt_GUI_scintilla, $SCI_DEFAULTCALLTIPDIR, $SCI_DEFAULTKEYWORDDIR, $SCI_DEFAULTABBREVDIR)
	SCI_InitEditorAu3($pelock_obfuscator_GUI_Eingabe_scintilla, $SCI_DEFAULTCALLTIPDIR, $SCI_DEFAULTKEYWORDDIR, $SCI_DEFAULTABBREVDIR)
	SCI_InitEditorAu3($pelock_obfuscator_GUI_Ausgabe_scintilla, $SCI_DEFAULTCALLTIPDIR, $SCI_DEFAULTKEYWORDDIR, $SCI_DEFAULTABBREVDIR)
	SCI_InitEditorAu3($ISN_UDF_Manager_GUI_UDFPreview_scintilla, $SCI_DEFAULTCALLTIPDIR, $SCI_DEFAULTKEYWORDDIR, $SCI_DEFAULTABBREVDIR)
	_ISN_Call_Function_in_Plugin($ISN_Helper_Threads[$ISN_Helper_Scripttree][$ISN_Helper_Handle], "_Scripttree_reload_filterarray") ;Reload Filterarray in thread
	_QuickView_ToDo_Liste_neu_einlesen()
	_ToDo_Liste_erstelle_Standard_Kategorien()
	_deaktiviere_Buttons_fuer_Editormodus()
	_QuickView_Load_Notes_from_ISN()
;~ 	If $lade_zuletzt_geoeffnete_Dateien = "true" Then _Oeffne_alte_Tabs(IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "opened_tabs", ""))
;~ 	If $autoloadmainfile = "true" Then Try_to_opten_file($Offenes_Projekt & "\" & IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "mainfile", "#ERROR#"))
EndFunc   ;==>_Load_Project

Func _CheckCtrlDblClick($GUI, $CTRL)
	Local $CtrlPos = _ControlGetPos($GUI, '', $CTRL)
	If Not IsArray($pos) Then Return
	If Not IsArray($CtrlPos) Then Return
	If ($pos[0] >= $CtrlPos[0] And $pos[0] <= $CtrlPos[0] + $CtrlPos[2]) And _
			($pos[1] >= $CtrlPos[1] + 20 And $pos[1] <= $CtrlPos[1] + 20 + $CtrlPos[3]) Then
		$n += 1
		$MousePos = True
		If $n = 2 And (TimerDiff($start) < $clickspeed) Then
			Return True
		Else
			$start = TimerInit()
			$n = 1
		EndIf
	EndIf
EndFunc   ;==>_CheckCtrlDblClick

Func _CheckCtrlClick($GUI, $CTRL)
	Local $CtrlPos = _ControlGetPos($GUI, '', $CTRL)
	If ($pos[0] >= $CtrlPos[0] And $pos[0] <= $CtrlPos[0] + $CtrlPos[2]) And _
			($pos[1] >= $CtrlPos[1] + 20 And $pos[1] <= $CtrlPos[1] + 20 + $CtrlPos[3]) Then
		$n += 1
		$MousePos = True
		Return True
	EndIf
EndFunc   ;==>_CheckCtrlClick

Func _PRIMARYdown()
;~ 	$pos = MouseGetPos()
;~ 	Select
;~ 		Case _CheckCtrlDblClick($StudioFenster, $Debug_log)
;~ 			_trytofinderror()
;~ 		Case Else
;~ 			$MousePos = False
;~ 	EndSelect

	;Drag´n Drop für Tabitems
	If BitAND(WinGetState($StudioFenster, ""), 8) Then ;Studiofenster must be active
		If IsDeclared("Studiofenster") And IsDeclared("htab") Then
			$aCInfo = GUIGetCursorInfo($Studiofenster)
			If IsArray($aCInfo) And IsDeclared("htab") Then
				Switch $aCInfo[4]

					Case $htab
						If _GUICtrlTab_GetItemCount($htab) > 1 Then ;Nur wenn mehr als 1 Tab aktiv ist
							Local $SelectedItem = _GUICtrlTab_GetCurSel($htab)
							$Tab_Item0Rect = _GUICtrlTab_GetItemRect($htab, 0)
							$Tab_Control_Pos = _ControlGetPos($Studiofenster, "", $htab)
							Opt("MouseCoordMode", 2) ;1=absolute, 0=relative, 2=client
							$pos = MouseGetPos()
							Opt("MouseCoordMode", 1) ;1=absolute, 0=relative, 2=client
							If IsArray($Tab_Control_Pos) And IsArray($Tab_Item0Rect) And IsArray($pos) Then
								If $pos[1] < $Tab_Control_Pos[1] + $Tab_Item0Rect[3] Then ;Nur wenn sich maus auf den "Tabitems" befindet
									$getroffenes_item = _GUICtrlTab_HitTest($htab, $pos[0] - $Tab_Control_Pos[0], $pos[1] - $Tab_Control_Pos[1])
									If IsArray($getroffenes_item) Then
										If $getroffenes_item[0] <> -1 Then
											;Es wurde ein Tabitem getroffen
											Sleep(700) ;Warte ob Mausteste nach 700ms immer noch gedrückt ist
											If _IsPressed("01", $user32) And $SelectedItem = _GUICtrlTab_GetCurSel($htab) Then
												;Drag´n Drop Tabitem


												GUISwitch($Studiofenster)
												$Tab_Dragndrop_Poslabel = GUICtrlCreateIcon($smallIconsdll, 1564, 0, 0, 15, 15)
												GUICtrlSetState(-1, $GUI_HIDE)

												Opt("MouseCoordMode", 2) ;1=absolute, 0=relative, 2=client
												While _IsPressed("01", $user32)
													Sleep(50)
													$pos = MouseGetPos()
													If Not IsArray($pos) Then Return
													If Not IsArray($Tab_Control_Pos) Then Return
													$Maus_ueber_Item = _GUICtrlTab_HitTest($htab, $pos[0] - $Tab_Control_Pos[0], $pos[1] - $Tab_Control_Pos[1])
													If Not IsArray($getroffenes_item) Then ExitLoop
													If Not IsArray($Maus_ueber_Item) Then ExitLoop
													If $Maus_ueber_Item[0] = -1 Then
														GUICtrlSetState($Tab_Dragndrop_Poslabel, $GUI_HIDE)
														ContinueLoop
													EndIf

													If $Maus_ueber_Item[0] = $getroffenes_item[0] Then
														GUICtrlSetState($Tab_Dragndrop_Poslabel, $GUI_HIDE)
														ContinueLoop
													EndIf

													$Tab_Dragndrop_Itemrect = _GUICtrlTab_GetItemRect($htab, $Maus_ueber_Item[0])
													If $Maus_ueber_Item[0] > $getroffenes_item[0] Then
														;Maus ist rechts neben den aktuellen Item
														GUICtrlSetImage($Tab_Dragndrop_Poslabel, $smallIconsdll, 1566)
														GUICtrlSetPos($Tab_Dragndrop_Poslabel, ($Tab_Control_Pos[0] + $Tab_Dragndrop_Itemrect[2]) - 19, $Tab_Control_Pos[1] + 5)

													Else
														;Maus ist links neben den aktuellen Item
														GUICtrlSetImage($Tab_Dragndrop_Poslabel, $smallIconsdll, 1563)
														GUICtrlSetPos($Tab_Dragndrop_Poslabel, ($Tab_Control_Pos[0] + $Tab_Dragndrop_Itemrect[0]) + 1, $Tab_Control_Pos[1] + 5)

													EndIf
													$iFlags = BitOR($SWP_SHOWWINDOW, $SWP_NOSIZE, $SWP_NOMOVE)
													_WinAPI_SetWindowPos(GUICtrlGetHandle($Tab_Dragndrop_Poslabel), $HWND_TOP, 0, 0, 0, 0, $iFlags)
												WEnd
												Opt("MouseCoordMode", 1) ;1=absolute, 0=relative, 2=client
												GUICtrlDelete($Tab_Dragndrop_Poslabel)
												If IsArray($getroffenes_item) And IsArray($Maus_ueber_Item) Then _Tabseiten_austauschen($getroffenes_item[0], $Maus_ueber_Item[0])
											EndIf
										EndIf
									EndIf
								EndIf
							EndIf

						EndIf


				EndSwitch
			EndIf
		EndIf
	EndIf



EndFunc   ;==>_PRIMARYdown



Func _Tabseiten_austauschen($Quellindex = -1, $Zielindex = -1)
	If $Quellindex = -1 Then Return
	If $Zielindex = -1 Then Return

	$Quelle_State = _GUICtrlTab_GetItem($htab, $Quellindex)
	$Quelle_State2 = _GUICtrlTab_GetItemState($htab, $Quellindex)
	If Not IsArray($Quelle_State) Then Return

	;Modify the ISN Arrays
	_ISN_ArrayMoveRow($SCE_EDITOR, $Quellindex, $Zielindex)
	_ISN_ArrayMoveRow($Plugin_Handle, $Quellindex, $Zielindex)
	_ISN_ArrayMoveRow($FILE_CACHE, $Quellindex, $Zielindex, "####NODELIM#####")
	_ISN_ArrayMoveRow($Datei_pfad, $Quellindex, $Zielindex)
	_ISN_ArrayMoveRow($ISN_Tabs_Additional_Infos_Array, $Quellindex, $Zielindex)

	;Also swap stuff for the dual editor mode
	If $Scripteditor_EnableDualEditor = "true" Then
		$DualRightIndex = _ArraySearch($SCE_EDITOR, $Scripteditor_DualEditor_Handle)
		$DualLeftIndex = _ArraySearch($SCE_EDITOR, $Scripteditor_DualEditor_MainTabHandle)
		If $DualRightIndex <> -1 And $DualLeftIndex <> -1 Then
			$Scripteditor_DualEditor_TabNrToUse = $DualRightIndex
			$Scripteditor_DualEditor_MainTabNr = $DualLeftIndex
		EndIf
	EndIf

	;Delete source tab and insert a new page with stats of the source one
	_GUICtrlTab_DeleteItem($htab, $Quellindex)
	_GUICtrlTab_InsertItem($htab, $Zielindex, $Quelle_State[1], $Quelle_State[2])
	_GUICtrlTab_SetItemState($htab, $Zielindex, $Quelle_State2)
	_GUICtrlTab_SetCurSel($htab, $Zielindex)
	_ISN_Call_Async_Function_in_Plugin($ISN_Helper_Threads[$ISN_Helper_Scripttree][$ISN_Helper_Handle], "_Scripttree_Swap_Arrays", String($Quellindex), String($Zielindex))
	_Show_Tab($Zielindex)
	_Check_Buttons()
EndFunc   ;==>_Tabseiten_austauschen


Func _GUICtrlTab_ActivateTabX($hWnd, $iIndex, $rebildtree = 1)
	If _GUICtrlTab_GetItemCount($hWnd) = 0 Then Return
	_GUICtrlTab_SetCurSel($hWnd, $iIndex)
	If $rebildtree = 1 Then _Check_Buttons()
EndFunc   ;==>_GUICtrlTab_ActivateTabX

Func _Try_to_import_folder()
	Local $ImportTo_Root = _GUICtrlTVExplorer_GetRootPath($Current_TVExplorer_TreeView)
	$PauseRDCEvents = 1
	$var = _WinAPI_BrowseForFolderDlg("", _Get_langstr(455), $BIF_NEWDIALOGSTYLE + $BIF_RETURNONLYFSDIRS, 0, 0, $Studiofenster)
	If @error Or $var = "" Then
		$PauseRDCEvents = 0
		Return
	Else
		$Count = 0
		$res = _WinAPI_BrowseForFolderDlg($ImportTo_Root, _Get_langstr(59), $BIF_NEWDIALOGSTYLE + $BIF_RETURNONLYFSDIRS, 0, 0, $Studiofenster)

		If @error Or $res = "" Then
			$PauseRDCEvents = 0
			Return
		Else
			$PauseRDCEvents = 0
			$Porjecttree_FileToSelect_after_Update = $res
			_FileOperationProgress($var & "\*.*", $res, 1, $FO_COPY, $FOF_SIMPLEPROGRESS + $FOF_NOCONFIRMATION)
			If @extended == 1 Then ;ERROR
				$PauseRDCEvents = 0
				Return
			EndIf
			_Write_log($var & " " & _Get_langstr(63))
		EndIf
	EndIf
	$PauseRDCEvents = 0
	FileChangeDir(@ScriptDir)
	If $Studiomodus = 2 Then AdlibRegister("_Update_Treeview") ;Trigger Treeview Refresh in Editormode
	;_Update_Treeview()

	_Show_Warning("confirmimportfolder", 9, _Get_langstr(61), _Get_langstr(456), _Get_langstr(7))
EndFunc   ;==>_Try_to_import_folder




Func _Try_to_import_file()
	_Lock_Plugintabs("lock")
	Local $ImportTo_Root = _GUICtrlTVExplorer_GetRootPath($Current_TVExplorer_TreeView)
	$PauseRDCEvents = 1
	If $Skin_is_used = "true" Then
		$var = _WinAPI_OpenFileDlg(_Get_langstr(57), "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}", _Get_langstr(58) & " (*.*)", 0, '', '', BitOR($OFN_ALLOWMULTISELECT, $OFN_PATHMUSTEXIST, $OFN_FILEMUSTEXIST, $OFN_HIDEREADONLY, $OFN_EXPLORER, $OFN_DONTADDTORECENT), $OFN_EX_NOPLACESBAR, 0, 0, $StudioFenster)
		$var = __WinAPI_OpenFileDlg_Multi_to_FileOpenDialog_MultiStr($var)
	Else
		$var = FileOpenDialog(_Get_langstr(57), "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}", _Get_langstr(58) & " (*.*)", 1 + 2 + 4, "", $StudioFenster)
	EndIf

	_Lock_Plugintabs("unlock")
	FileChangeDir(@ScriptDir)
	If @error Or $var = "" Then
		$PauseRDCEvents = 0
		Return
	Else
		$Count = 0
		$res = _WinAPI_BrowseForFolderDlg($ImportTo_Root, _Get_langstr(59), $BIF_NEWDIALOGSTYLE + $BIF_RETURNONLYFSDIRS, 0, 0, $Studiofenster)
		If @error Or $res = "" Then
			$PauseRDCEvents = 0
			Return
		Else
			If StringInStr($var, "|") = 0 Then
				$Count = 1
				;FileCopy ($var, $res&"\*.*" , 1)
				$PauseRDCEvents = 0
				$Porjecttree_FileToSelect_after_Update = $res & "\" & StringTrimLeft($var, StringInStr($var, "\", 0, -1))
				_FileOperationProgress($var, $res, 1, $FO_COPY, $FOF_SIMPLEPROGRESS + $FOF_NOCONFIRMATION)
				If @extended == 1 Then ;ERROR
					$PauseRDCEvents = 0
					Return
				EndIf
				_Write_log($var & " " & _Get_langstr(63))
			Else
				$Pfad = StringTrimRight($var, (StringLen($var) - StringInStr($var, "|")) + 1)
				$filelist = StringTrimLeft($var, (StringInStr($var, "|"))) & "|"
				$Count = 0
				$PauseRDCEvents = 0
				While StringLen($filelist) > 1
					$Datei = StringTrimRight($filelist, (StringLen($filelist) - StringInStr($filelist, "|")) + 1)
					;FileCopy ($pfad&"\"&$Datei, $res&"\*.*" , 1)
					$Porjecttree_FileToSelect_after_Update = $res & "\" & $Datei
					_FileOperationProgress($Pfad & "\" & $Datei, $res, 1, $FO_COPY, $FOF_SIMPLEPROGRESS + $FOF_NOCONFIRMATION)
					_Write_log($Datei & " " & _Get_langstr(63))
					$filelist = StringTrimLeft($filelist, StringInStr($filelist, "|"))
					$Count = $Count + 1
				WEnd
			EndIf

		EndIf
	EndIf
	$PauseRDCEvents = 0
	;_Update_Treeview()
	_Show_Warning("confirmimportfiles", 9, _Get_langstr(61), $Count & " " & _Get_langstr(60), _Get_langstr(7))
	If $Count > 14 Then _Earn_trophy(7, 2)
	If $Studiomodus = 2 Then AdlibRegister("_Update_Treeview") ;Trigger Treeview Refresh in Editormode
EndFunc   ;==>_Try_to_import_file

Func _plugin_send_msg($plugin, $msg = "")
	If $msg = "" Then
		WinSetTitle($plugin, "", "##WAITING##")
	Else
		WinSetTitle($plugin, "", $msg)
	EndIf
EndFunc   ;==>_plugin_send_msg

Func _ShowFileProperties($sFile, $sVerb = "properties", $hWnd = 0)
	; function by Rasim
	; http://www.autoitscript.com/forum/index....p?showtopic=78236&view=findpos

	Local Const $SEE_MASK_INVOKEIDLIST = 0xC
	Local Const $SEE_MASK_NOCLOSEPROCESS = 0x40
	Local Const $SEE_MASK_FLAG_NO_UI = 0x400

	Local $PropBuff, $FileBuff, $SHELLEXECUTEINFO

	$PropBuff = DllStructCreate("char[256]")
	DllStructSetData($PropBuff, 1, $sVerb)

	$FileBuff = DllStructCreate("char[256]")
	DllStructSetData($FileBuff, 1, $sFile)

	$SHELLEXECUTEINFO = DllStructCreate("int cbSize;long fMask;hwnd hWnd;ptr lpVerb;ptr lpFile;ptr lpParameters;ptr lpDirectory;" & _
			"int nShow;int hInstApp;ptr lpIDList;ptr lpClass;hwnd hkeyClass;int dwHotKey;hwnd hIcon;" & _
			"hwnd hProcess")

	DllStructSetData($SHELLEXECUTEINFO, "cbSize", DllStructGetSize($SHELLEXECUTEINFO))
	DllStructSetData($SHELLEXECUTEINFO, "fMask", $SEE_MASK_INVOKEIDLIST)
	DllStructSetData($SHELLEXECUTEINFO, "hwnd", $hWnd)
	DllStructSetData($SHELLEXECUTEINFO, "lpVerb", DllStructGetPtr($PropBuff, 1))
	DllStructSetData($SHELLEXECUTEINFO, "lpFile", DllStructGetPtr($FileBuff, 1))

	$aRet = DllCall("shell32.dll", "int", "ShellExecuteEx", "ptr", DllStructGetPtr($SHELLEXECUTEINFO))
	If $aRet[0] = 0 Then Return SetError(2, 0, 0)

	Return $aRet[0]
EndFunc   ;==>_ShowFileProperties

;1=$sPath is a dir|0=$sPath is not a dir

Func _IsDir($sPath)
	If Not StringInStr(FileGetAttrib($sPath), "D") Then Return False
	Return True
EndFunc   ;==>_IsDir






Func _Show_Delete_file_GUI()
	Local $Treeview = $Current_TVExplorer_TreeView
	If _GUICtrlTreeView_GetSelection($Treeview) = 0 Then Return
	If _GUICtrlTVExplorer_GetSelected($Treeview) = $Offenes_Projekt Then Return
	If _WinAPI_PathIsRoot(_GUICtrlTVExplorer_GetSelected($Treeview)) Then Return
	Local $Pfad = _GUICtrlTVExplorer_GetSelected($Treeview)
	If _Schuetze_Wichtige_daten($Pfad) = False Then Return
	$OwnerWindow = _WinAPI_GetAncestor($Treeview, $GA_PARENT)
	If _FileInUse($Pfad) = 1 Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(951), 0, $OwnerWindow)
		Return
	EndIf


	If StringInStr($Pfad, _ISN_Variablen_aufloesen($FavoritesSubfolder)) And StringRight($Pfad, 4) = ".lnk" Then
		GUICtrlSetData($Datei_loeschen_GUI_HeaderLabel, _Get_langstr(1517))
		WinSetTitle($Datei_loeschen_GUI, "", _Get_langstr(1517))
		GUICtrlSetData($Datei_loeschen_GUI_FooterLabel, _Get_langstr(1518))
	Else
		GUICtrlSetData($Datei_loeschen_GUI_HeaderLabel, _Get_langstr(74))
		WinSetTitle($Datei_loeschen_GUI, "", _Get_langstr(74))
		GUICtrlSetData($Datei_loeschen_GUI_FooterLabel, _Get_langstr(905))
	EndIf




	$res = _ArraySearch($Datei_pfad, $Pfad)
	If $res <> -1 Then
		$alreadyopen = $res
	Else
		$alreadyopen = -1
	EndIf
	If $alreadyopen = -1 Then
		If StringReplace(StringTrimLeft(_GUICtrlTreeView_GetTree($Treeview, _GUICtrlTreeView_GetSelection($Treeview)), StringInStr(_GUICtrlTreeView_GetTree($Treeview, _GUICtrlTreeView_GetSelection($Treeview)), "|")), $Delim1, $Delim) = IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "name", "#ERROR#") Then Return ;cannot delete root
		GUICtrlSetData($datei_loeschen_text, _ISN_Pfad_durch_Variablen_ersetzen($Pfad) & " " & _Get_langstr(62))
		GUICtrlSetState($datei_loeschen_include_checkbox, $GUI_ENABLE)
		If StringInStr($Pfad, $Autoitextension) Or StringInStr($Pfad, ".isf") Then
			GUICtrlSetState($datei_loeschen_include_checkbox, $GUI_CHECKED)
		Else
			GUICtrlSetState($datei_loeschen_include_checkbox, $GUI_UNCHECKED)
		EndIf
		If $Studiomodus = 2 Or _IsDir($Pfad) = True Or StringInStr($Pfad, _ISN_Variablen_aufloesen($FavoritesSubfolder)) Then
			GUICtrlSetState($datei_loeschen_include_checkbox, $GUI_UNCHECKED)
			GUICtrlSetState($datei_loeschen_include_checkbox, $GUI_DISABLE)
		EndIf
		GUICtrlSetState($DeleteFileGUI_OKButton, $GUI_FOCUS)
		GUISetState(@SW_SHOW, $Datei_loeschen_GUI)
		GUISetState(@SW_DISABLE, $StudioFenster)
	Else
		MsgBox(262144 + 16, _Get_langstr(25), StringTrimLeft($Pfad, StringInStr($Pfad, "\", 0, -1)) & " " & _Get_langstr(78), 0, $OwnerWindow)
	EndIf
EndFunc   ;==>_Show_Delete_file_GUI

Func _Hide_Delete_file_GUI()
	GUISetState(@SW_ENABLE, $StudioFenster)
	GUISetState(@SW_HIDE, $Datei_loeschen_GUI)
EndFunc   ;==>_Hide_Delete_file_GUI


Func _Try_to_delete_file()
	Local $Treeview = $Current_TVExplorer_TreeView
	If _GUICtrlTreeView_GetSelection($Treeview) = 0 Then Return
	If _GUICtrlTVExplorer_GetSelected($Treeview) = $Offenes_Projekt Then Return
	If _WinAPI_PathIsRoot(_GUICtrlTVExplorer_GetSelected($Treeview)) Then Return
	$Pfad = _GUICtrlTVExplorer_GetSelected($Treeview)
	If _Schuetze_Wichtige_daten($Pfad) = False Then Return
	$Projektbaum_ist_bereit = 0 ;Sperre Projektbaum
	Local $PathToSelectAfterDelete = _ISN_TreeViewSelectNextItemAtLevelAndGetPath($Treeview)
	_Hide_Delete_file_GUI()
	_Write_log(StringTrimLeft($Pfad, StringInStr($Pfad, "\", 0, -1)) & " " & _Get_langstr(64))
	If _IsDir($Pfad) = True Then
		DirRemove($Pfad, 1)
	Else
		FileDelete($Pfad)
	EndIf
	If GUICtrlRead($datei_loeschen_include_checkbox) = $GUI_CHECKED Then _Exclude_IT(StringTrimLeft($Pfad, StringInStr($Pfad, "\", 0, -1)))
	;_Update_Treeview()
	$Porjecttree_FileToSelect_after_Update = $PathToSelectAfterDelete
	If $Studiomodus = 2 Then AdlibRegister("_Update_Treeview") ;Trigger Treeview Refresh in Editormode

	$Projektbaum_ist_bereit = 1
EndFunc   ;==>_Try_to_delete_file


Func _Splitterwerte_speichern()
	If BitAND(WinGetState($Studiofenster, ""), 16) Then Return ;Nicht wenn Minimiert
	;Speichere Prozentwerde der Splitter
	$Studiopos = _WinGetClientSize($Studiofenster)
	If Not IsArray($Studiopos) Then Return
	$Pos_Splitter1 = _ControlGetPos($StudioFenster, "", $Left_Splitter_X) ;Zwischen projektbaum und Sci
	$Pos_Splitter2 = _ControlGetPos($StudioFenster, "", $Right_Splitter_X) ;Zwischen Sci und Skriptbaum
	$Pos_Splitter3 = _ControlGetPos($StudioFenster, "", $Middle_Splitter_Y) ;Scintilla output
	$Pos_Splitter4 = _ControlGetPos($StudioFenster, "", $Left_Splitter_Y) ;Splitter bei Projektbaum
	$Pos_Splitter5 = _ControlGetPos($StudioFenster, "", $Splitter_DualEditor) ;Dual Editor Splitter
	;ConsoleWrite((100* $Pos_Splitter1[0])/$Studiopos[0]) &@crlf)
	If $Toggle_Leftside = 0 Then _Write_in_Config("Left_Splitter_X", Round((100 * $Pos_Splitter1[0]) / $Studiopos[0], 2))

	If $hidefunctionstree = "false" And $IS_HIDDEN_RECHTS = 0 And $Toggle_rightside = 0 Then _Write_in_Config("Right_Splitter_X", Round((100 * $Pos_Splitter2[0]) / $Studiopos[0], 2))

	If $hidedebug = "false" And $IS_HIDDEN_UNTEN = 0 Then _Write_in_Config("Middle_Splitter_Y", Round((100 * $Pos_Splitter3[1]) / $Studiopos[1], 2))
	If $hideprogramlog = "false" Then _Write_in_Config("Left_Splitter_Y", Round((100 * $Pos_Splitter4[1]) / $Studiopos[1], 2))

	If $Scripteditor_EnableDualEditor = "true" Then
		If $Scripteditor_DualEditorView = "vertical" Then
			_Write_in_Config("Dual_Splitter_Vertical", Round((100 * $Pos_Splitter5[0]) / $Studiopos[0], 2))
		Else
			_Write_in_Config("Dual_Splitter_Horizontal", Round((100 * $Pos_Splitter5[1]) / $Studiopos[1], 2))
		EndIf
	EndIf

EndFunc   ;==>_Splitterwerte_speichern



Func _Redraw_Window($GUI = $StudioFenster)
	_Splitterwerte_speichern()


;~ 	For $i = $Offene_tabs To 1 Step -1
;~ 		If $ISN_Tabs_Additional_Infos_Array[$i - 1][1] = "1" Then ContinueLoop
;~ 		WinMove($SCE_EDITOR[$i - 1], "", -9000, -9000, Default, Default)
;~ 	Next



	_Show_Tab(_GUICtrlTab_GetCurFocus($htab))

	_Rezize()

EndFunc   ;==>_Redraw_Window

Func _Repos_HD_Logo()
	If Not IsDeclared("htab") Then Exit
	If _GUICtrlTab_GetItemCount($htab) > 0 Then Return
	$tabsize = _ControlGetPos($StudioFenster, "", $htab)
	GUICtrlSetPos($HD_Logo, ($tabsize[0] + ($tabsize[2]) / 2) - (400 / 2), ($tabsize[1] + ($tabsize[3]) / 2) - (400 / 2), 400, 400)
EndFunc   ;==>_Repos_HD_Logo

Func _Status_bar_aktualisiere_Parts()
	Local $size_StudioFenster = _WinGetClientSize($StudioFenster)
	If Not IsArray($size_StudioFenster) Then Return
	If BitAND(WinGetState($StudioFenster, ""), 32) Then ;When GUI is not maximized, we need a little bit more space
		Local $aParts[2] = [$size_StudioFenster[0] - 25 * $DPI, -1]
	Else
		Local $aParts[2] = [$size_StudioFenster[0] - 32 * $DPI, -1]
	EndIf
	_GUICtrlStatusBar_SetParts($Status_bar, $aParts)
	_GUICtrlStatusBar_SetTipText($Status_bar, 1, _Get_langstr(1141))
EndFunc   ;==>_Status_bar_aktualisiere_Parts

Func _Resize_with_no_tabrefresh_Adlib()
	AdlibRegister("_Resize_with_no_tabrefresh", 20)
EndFunc   ;==>_Resize_with_no_tabrefresh_Adlib

Func _Resize_with_no_tabrefresh()
	AdlibUnRegister("_Resize_with_no_tabrefresh")

	_ISN_Studiofenster_SetClipchildren("set") ;To prevent flickering in the main GUI
	GUISetState(@SW_LOCK, $Studiofenster)

	_Rezize(1, 0)

	_ISN_UnlockGUIWithoutFlickering($Studiofenster)
	_WinAPI_RedrawWindow($Studiofenster, 0, 0, BitOR($RDW_ERASE, $RDW_INVALIDATE, $RDW_ALLCHILDREN)) ;Redraw the main GUI
	_ISN_Studiofenster_SetClipchildren("remove") ;To prevent flickering in the main GUI
EndFunc   ;==>_Resize_with_no_tabrefresh



Func _Resize_with_no_tabrefresh_and_noRedraw()
	AdlibUnRegister("_Resize_with_no_tabrefresh_and_noRedraw")
	_Rezize(1, 0)
EndFunc   ;==>_Resize_with_no_tabrefresh_and_noRedraw

Func _Rezize($no_tabrefresh = 0, $RedrawStudioGUI = 0)


	;Falls gui verkleinert wurde passe Elemente an Fenstergröße an
	_Resize_Elements_to_Window($no_tabrefresh)

	;Falls der Scriptbaum gerade versteckt ist..
	If $Toggle_rightside = 1 And $hidefunctionstree = "false" Then
		$Pos_VSplitter_2 = _ControlGetPos($StudioFenster, "", $Right_Splitter_X)
		$winpos = _WinGetClientSize($studiofenster)
		GUICtrlSetPos($Right_Splitter_X, $winpos[0] - (30 * $DPI), $Pos_VSplitter_2[1])
		GUICtrlSetPos($Scripttree_title, $winpos[0] - (28 * $DPI), $Pos_VSplitter_2[1], 20 * $DPI, 150 * $DPI)

	EndIf
	;Aktualisiere die Splitter
	_Aktualisiere_Splittercontrols()
	If $Scripteditor_EnableDualEditor = "true" Then _ISN_DualEditor_ResizeWindows()

	;Aktualisiere das Logo
	_Repos_HD_Logo()


;~ 	If _GUICtrlTab_GetItemCount($htab) > 0 Then _ISN_Call_Async_Function_in_Plugin($ISN_Helper_Threads[$ISN_Helper_Scripttree][$ISN_Helper_Handle], "_Scripttree_Redraw")

	_QuickView_GUI_Resize() ;Repos Quickview


	;Aktualisiere die Statusbar
	_GUICtrlStatusBar_Resize($Status_bar)
	_Status_bar_aktualisiere_Parts()


	If $RedrawStudioGUI = 1 Then
		_WinAPI_RedrawWindow($Studiofenster, 0, 0, BitOR($RDW_ERASE, $RDW_INVALIDATE, $RDW_ALLCHILDREN))
	EndIf


	_ISN_RedrawFixRedrawGlitches()

;~ 	If $NoRedraw = 0 Then
;~ 		if IsDeclared("ISN_Thread_Scripttree_GUI") Then
;~ 			Local $ISN_Thread_Scripttree_GUI_Handle = HWnd(eval("ISN_Thread_Scripttree_GUI"))
;~ 			if IsHWnd($ISN_Thread_Scripttree_GUI_Handle) then _WinAPI_RedrawWindow($ISN_Thread_Scripttree_GUI_Handle, 0, 0, BitOR($RDW_ERASE, $RDW_INVALIDATE, $RDW_ALLCHILDREN))
;~ 		EndIf
;~ 	EndIf

	;Aktualisiere Tab
;~ 	If $no_tabrefresh = 0 Then _Show_Tab(_GUICtrlTab_GetCurFocus($htab))
EndFunc   ;==>_Rezize


Func _Toggle_Fenster_unten()
	If $Offenes_Projekt = "" Then Return
	If _GUICtrlTab_GetItemCount($htab) = 0 Then Return
	_ISN_Studiofenster_SetClipchildren("set") ;To prevent flickering in the main GUI

	If $IS_HIDDEN_UNTEN = 1 Then
		If StringTrimLeft($Datei_pfad[_GUICtrlTab_GetCurFocus($htab)], StringInStr($Datei_pfad[_GUICtrlTab_GetCurFocus($htab)], ".", 0, -1)) <> $Autoitextension Then Return
		If $hidedebug = "true" Then Return
		_HIDE_FENSTER_UNTEN("false")
		$Fenster_unten_durch_toggle_versteckt = 0
	Else
		_HIDE_FENSTER_UNTEN("true")
		$Fenster_unten_durch_toggle_versteckt = 1
	EndIf

	_ISN_Studiofenster_SetClipchildren("remove") ;To prevent flickering in the main GUI
	_Rezize()
EndFunc   ;==>_Toggle_Fenster_unten



Func _WINDOW_REBUILD()
;~ 	Sleep(300)
;~ 	GUISetState(@SW_SHOW, $Studiofenster)
;~ 	WinSetOnTop($Studiofenster, "", 1)
;~ 	WinSetOnTop($Studiofenster, "", 0)
	_Rezize(0)
EndFunc   ;==>_WINDOW_REBUILD

Func _HIDE_FENSTER_RECHTS($state = "", $NoResize = 0)
	If $state = "" Then $state = $hidefunctionstree
	If $hidefunctionstree = "true" Then $state = $hidefunctionstree
	$winpos = _WinGetPos($studiofenster)
	$winpos_client = _WinGetClientSize($studiofenster)
	$Pos_VSplitter_2 = _ControlGetPos($StudioFenster, "", $Right_Splitter_X)
	If Not IsArray($Pos_VSplitter_2) Then Return
	If $state = "true" Then ;hide
		If $IS_HIDDEN_RECHTS = 1 Then Return
		If $IS_HIDDEN_RECHTS = 0 Then
			$OLD_X = (100 * $Pos_VSplitter_2[0]) / $winpos_client[0]
			$IS_HIDDEN_RECHTS = 1
		EndIf
		GUICtrlSetPos($Right_Splitter_X, $winpos_client[0] - 2, $Pos_VSplitter_2[1], $Splitter_Breite)
		GUICtrlSetState($Right_Splitter_X, $GUI_HIDE)
		GUICtrlSetState($Scripttree_title, $GUI_HIDE)
		GUICtrlSetState($hTreeview2_searchinput, $GUI_HIDE)
		_ISN_Call_Async_Function_in_Plugin($ISN_Helper_Threads[$ISN_Helper_Scripttree][$ISN_Helper_Handle], "_Scripttree_Redraw")
	Else
		If $IS_HIDDEN_RECHTS = 0 Then Return
		If $Toggle_rightside = 1 Then
			$Toggle_rightside = 0
			_Toggle_hide_rightbar()
			GUICtrlSetState($Scripttree_title, $GUI_SHOW)
			GUICtrlSetState($hTreeview2_searchinput, $GUI_SHOW)
			$IS_HIDDEN_RECHTS = 0
		Else
			If _GUICtrlTab_GetItemCount($htab) = 0 Then Return
			GUICtrlSetPos($Right_Splitter_X, ($winpos_client[0] / 100) * $OLD_X, $Pos_VSplitter_2[1], $Splitter_Breite)
			GUICtrlSetState($Right_Splitter_X, $GUI_SHOW)
			GUICtrlSetState($Scripttree_title, $GUI_SHOW)
			GUICtrlSetState($hTreeview2_searchinput, $GUI_SHOW)
;~ 			_WinAPI_RedrawWindow($ISN_Helper_Threads[$ISN_Helper_Scripttree][$ISN_Helper_Handle])
			$IS_HIDDEN_RECHTS = 0
		EndIf
	EndIf

	If $NoResize = 0 Then _Aktualisiere_Splittercontrols() ;Aktuallisiere alle Controls die mit Splittern verbunden sind
	_Repos_HD_Logo() ;aktualisiere Logo
EndFunc   ;==>_HIDE_FENSTER_RECHTS



Func _HIDE_FENSTER_UNTEN($state = "", $NoResize = 0)
	If $state = "" Then $state = $hidedebug
	If $hidedebug = "true" Then $state = $hidedebug
	$winpos = _WinGetPos($studiofenster)
	$winpos_clientsize = _WinGetClientSize($studiofenster)
	$Pos_HSplitter_1 = _ControlGetPos($StudioFenster, "", $Middle_Splitter_Y)
	$Pos_Splitter1 = _ControlGetPos($StudioFenster, "", $Left_Splitter_X)
	If Not IsArray($Pos_HSplitter_1) Then Return
	If $state = "true" Then ;hide
;~ if $IS_HIDDEN_UNTEN=1 then return
		If $IS_HIDDEN_UNTEN = 0 Then
			$OLD_Y = (100 * ($Pos_HSplitter_1[1]) / $winpos_clientsize[1])
			$IS_HIDDEN_UNTEN = 1
		EndIf
		GUICtrlSetPos($Middle_Splitter_Y, $Pos_HSplitter_1[0], $winpos_clientsize[1] - 24)
		GUICtrlSetState($Middle_Splitter_Y, $GUI_HIDE)
		GUICtrlSetState($Debug_log, $GUI_HIDE)
		GUICtrlSetState($Debug_Log_Undo_Button, $GUI_HIDE)
		GUICtrlSetState($Debug_Log_Redo_Button, $GUI_HIDE)
		GUICtrlSetState($Debug_Log_Zwischenablage_Button, $GUI_HIDE)
	Else
		If $IS_HIDDEN_UNTEN = 0 Then Return
		;$OLD_Y = int(($winpos_clientsize[1] / 100) * Number(_Config_Read("Middle_Splitter_Y", $Mittlerer_Splitter_Y_default)))
		If _GUICtrlTab_GetItemCount($htab) = 0 Then Return
		GUICtrlSetPos($Middle_Splitter_Y, $Pos_HSplitter_1[0], ($winpos_clientsize[1] / 100) * $OLD_Y)
		GUICtrlSetState($Middle_Splitter_Y, $GUI_SHOW)
		GUICtrlSetState($Debug_log, $GUI_SHOW)
		If $Zeige_Buttons_neben_Debug_Fenster = "true" Then
			GUICtrlSetState($Debug_Log_Undo_Button, $GUI_SHOW)
			GUICtrlSetState($Debug_Log_Redo_Button, $GUI_SHOW)
			GUICtrlSetState($Debug_Log_Zwischenablage_Button, $GUI_SHOW)
		Else
			GUICtrlSetState($Debug_Log_Undo_Button, $GUI_HIDE)
			GUICtrlSetState($Debug_Log_Redo_Button, $GUI_HIDE)
			GUICtrlSetState($Debug_Log_Zwischenablage_Button, $GUI_HIDE)
		EndIf
		$IS_HIDDEN_UNTEN = 0
	EndIf

	If $NoResize = 0 Then _Aktualisiere_Splittercontrols() ;Aktuallisiere alle Controls die mit Splittern verbunden sind
	_Repos_HD_Logo() ;aktualisiere Logo

EndFunc   ;==>_HIDE_FENSTER_UNTEN

Func _Imagelist_replace_icon($hWnd, $toreplace, $sFile, $iIndex = 0)
	Local $pIcon, $tIcon, $hIcon

	$tIcon = DllStructCreate("int Icon")
	$pIcon = DllStructGetPtr($tIcon)
	_WinAPI_ExtractIconEx($sFile, $iIndex, 0, $pIcon, 1)
	$hIcon = DllStructGetData($tIcon, "Icon")
	_GUIImageList_ReplaceIcon($hWnd, $toreplace, $hIcon)
	_WinAPI_DestroyIcon($hIcon)
EndFunc   ;==>_Imagelist_replace_icon

Func _Macroslot_get_name($Slot_id = 0)
	If $Slot_id = 0 Then Return ""
	If Not UBound($Macroslot_InfoArray) = 10 Then Return
	Return $Macroslot_InfoArray[$Slot_id - 1][1]
EndFunc   ;==>_Macroslot_get_name


Func _Reload_Ruleslots()
	Local $sections_ProjectISN
	Local $sections_ProjectISN_error
	Local $sections_GlobalMacros
	Local $sections_GlobalMacros_error
	Local $MacroSlot_TriggerSection
	Local $MacroSlot_ToolsMenueItemHandle
	Local $MacroSlot_ToolbarItemHandle
	Local $MacroSlot_Name
	Local $MacroSlot_DefaultName
	Local $MacroSlot_HotkeyKeycode
	Local $MacroSlot_IconIndexInSmallIconsdll
	Local $MacroSlot_IconIndexInToolBarImageList
	Local $MacroSlot_IconINISection
	Local $MacroSlot_INISection
	Local $MacroSlot_Name_tmp
	Local $MacrosInTriggerArray
	Local $MultiTrigger ;Used if multiple macros are assigned to the same macroslot
	Local $MacroSlot_Status ;active or inactive
	Local $MacroSlot_Status_tmp
	Local $readen_icon
	Local $MacroSlot_ShowInTreeViewContext
	Local $MacroSlot_ProjecttreecontextSection
	Local $MacroSlotINISection = "ISNAUTOITSTUDIO"
	Local $MacroINIs_Array = $Leeres_Array
	_ArrayAdd($MacroINIs_Array, $GlobalMacrosINIPath)
	_ArrayAdd($MacroINIs_Array, $Pfad_zur_Project_ISN)

	;Write Log
	_Write_ISN_Debug_Console("Loading macros...", $ISN_Debug_Console_Errorlevel_Info, $ISN_Debug_Console_No_Linebreak)

	GUISetState(@SW_LOCK, $StudioFenster) ;prevent flickering of the menu bar
	$Macroslot_InfoArray = $Macroslot_InfoArray_Leer ;Reset our Info Array

	For $MacroSlotCnt = 1 To 10

		;Setup variables for macroslots
		$MultiTrigger = 0
		Switch $MacroSlotCnt

			Case 1
				$MacroSlot_TriggerSection = $Section_Trigger_MacroSlot1
				$MacroSlot_ToolsMenueItemHandle = $ISN_ToolsMenu_MacroSlot1
				$MacroSlot_ToolbarItemHandle = $ISN_Toolbar_MacroSlot1
				$MacroSlot_DefaultName = _Get_langstr(1501) & " 01"
				$MacroSlot_HotkeyKeycode = _Keycode_zu_Text($Hotkey_Keycode_Makroslot1)
				$MacroSlot_IconIndexInSmallIconsdll = 0
				$MacroSlot_IconIndexInToolBarImageList = 24
				$MacroSlot_IconINISection = "icon_ruleslot1"
				$MacroSlot_ProjecttreecontextSection = "ruleslot1_projecttreecontext"

			Case 2
				$MacroSlot_TriggerSection = $Section_Trigger_MacroSlot2
				$MacroSlot_ToolsMenueItemHandle = $ISN_ToolsMenu_MacroSlot2
				$MacroSlot_ToolbarItemHandle = $ISN_Toolbar_MacroSlot2
				$MacroSlot_DefaultName = _Get_langstr(1501) & " 02"
				$MacroSlot_HotkeyKeycode = _Keycode_zu_Text($Hotkey_Keycode_Makroslot2)
				$MacroSlot_IconIndexInSmallIconsdll = 908
				$MacroSlot_IconIndexInToolBarImageList = 25
				$MacroSlot_IconINISection = "icon_ruleslot2"
				$MacroSlot_ProjecttreecontextSection = "ruleslot2_projecttreecontext"

			Case 3
				$MacroSlot_TriggerSection = $Section_Trigger_MacroSlot3
				$MacroSlot_ToolsMenueItemHandle = $ISN_ToolsMenu_MacroSlot3
				$MacroSlot_ToolbarItemHandle = $ISN_Toolbar_MacroSlot3
				$MacroSlot_DefaultName = _Get_langstr(1501) & " 03"
				$MacroSlot_HotkeyKeycode = _Keycode_zu_Text($Hotkey_Keycode_Makroslot3)
				$MacroSlot_IconIndexInSmallIconsdll = 1019
				$MacroSlot_IconIndexInToolBarImageList = 26
				$MacroSlot_IconINISection = "icon_ruleslot3"
				$MacroSlot_ProjecttreecontextSection = "ruleslot3_projecttreecontext"

			Case 4
				$MacroSlot_TriggerSection = $Section_Trigger_MacroSlot4
				$MacroSlot_ToolsMenueItemHandle = $ISN_ToolsMenu_MacroSlot4
				$MacroSlot_ToolbarItemHandle = $ISN_Toolbar_MacroSlot4
				$MacroSlot_DefaultName = _Get_langstr(1501) & " 04"
				$MacroSlot_HotkeyKeycode = _Keycode_zu_Text($Hotkey_Keycode_Makroslot4)
				$MacroSlot_IconIndexInSmallIconsdll = 1129
				$MacroSlot_IconIndexInToolBarImageList = 27
				$MacroSlot_IconINISection = "icon_ruleslot4"
				$MacroSlot_ProjecttreecontextSection = "ruleslot4_projecttreecontext"

			Case 5
				$MacroSlot_TriggerSection = $Section_Trigger_MacroSlot5
				$MacroSlot_ToolsMenueItemHandle = $ISN_ToolsMenu_MacroSlot5
				$MacroSlot_ToolbarItemHandle = $ISN_Toolbar_MacroSlot5
				$MacroSlot_DefaultName = _Get_langstr(1501) & " 05"
				$MacroSlot_HotkeyKeycode = _Keycode_zu_Text($Hotkey_Keycode_Makroslot5)
				$MacroSlot_IconIndexInSmallIconsdll = 1240
				$MacroSlot_IconIndexInToolBarImageList = 28
				$MacroSlot_IconINISection = "icon_ruleslot5"
				$MacroSlot_ProjecttreecontextSection = "ruleslot5_projecttreecontext"

			Case 6
				$MacroSlot_TriggerSection = $Section_Trigger_MacroSlot6
				$MacroSlot_ToolsMenueItemHandle = $ISN_ToolsMenu_MacroSlot6
				$MacroSlot_ToolbarItemHandle = $ISN_Toolbar_MacroSlot6
				$MacroSlot_DefaultName = _Get_langstr(1501) & " 06"
				$MacroSlot_HotkeyKeycode = _Keycode_zu_Text($Hotkey_Keycode_Makroslot6)
				$MacroSlot_IconIndexInSmallIconsdll = 1344
				$MacroSlot_IconIndexInToolBarImageList = 30
				$MacroSlot_IconINISection = "icon_ruleslot6"
				$MacroSlot_ProjecttreecontextSection = "ruleslot6_projecttreecontext"

			Case 7
				$MacroSlot_TriggerSection = $Section_Trigger_MacroSlot7
				$MacroSlot_ToolsMenueItemHandle = $ISN_ToolsMenu_MacroSlot7
				$MacroSlot_ToolbarItemHandle = $ISN_Toolbar_MacroSlot7
				$MacroSlot_DefaultName = _Get_langstr(1501) & " 07"
				$MacroSlot_HotkeyKeycode = _Keycode_zu_Text($Hotkey_Keycode_Makroslot7)
				$MacroSlot_IconIndexInSmallIconsdll = 1455
				$MacroSlot_IconIndexInToolBarImageList = 31
				$MacroSlot_IconINISection = "icon_ruleslot7"
				$MacroSlot_ProjecttreecontextSection = "ruleslot7_projecttreecontext"

			Case 8
				$MacroSlot_TriggerSection = $Section_Trigger_MacroSlot8
				$MacroSlot_ToolsMenueItemHandle = $ISN_ToolsMenu_MacroSlot8
				$MacroSlot_ToolbarItemHandle = $ISN_Toolbar_MacroSlot8
				$MacroSlot_DefaultName = _Get_langstr(1501) & " 08"
				$MacroSlot_HotkeyKeycode = _Keycode_zu_Text($Hotkey_Keycode_Makroslot8)
				$MacroSlot_IconIndexInSmallIconsdll = 1566
				$MacroSlot_IconIndexInToolBarImageList = 43
				$MacroSlot_IconINISection = "icon_ruleslot8"
				$MacroSlot_ProjecttreecontextSection = "ruleslot8_projecttreecontext"

			Case 9
				$MacroSlot_TriggerSection = $Section_Trigger_MacroSlot9
				$MacroSlot_ToolsMenueItemHandle = $ISN_ToolsMenu_MacroSlot9
				$MacroSlot_ToolbarItemHandle = $ISN_Toolbar_MacroSlot9
				$MacroSlot_DefaultName = _Get_langstr(1501) & " 09"
				$MacroSlot_HotkeyKeycode = _Keycode_zu_Text($Hotkey_Keycode_Makroslot9)
				$MacroSlot_IconIndexInSmallIconsdll = 1673
				$MacroSlot_IconIndexInToolBarImageList = 44
				$MacroSlot_IconINISection = "icon_ruleslot9"
				$MacroSlot_ProjecttreecontextSection = "ruleslot9_projecttreecontext"

			Case 10
				$MacroSlot_TriggerSection = $Section_Trigger_MacroSlot10
				$MacroSlot_ToolsMenueItemHandle = $ISN_ToolsMenu_MacroSlot10
				$MacroSlot_ToolbarItemHandle = $ISN_Toolbar_MacroSlot10
				$MacroSlot_DefaultName = _Get_langstr(1501) & " 10"
				$MacroSlot_HotkeyKeycode = _Keycode_zu_Text($Hotkey_Keycode_Makroslot10)
				$MacroSlot_IconIndexInSmallIconsdll = 1938
				$MacroSlot_IconIndexInToolBarImageList = 45
				$MacroSlot_IconINISection = "icon_ruleslot10"
				$MacroSlot_ProjecttreecontextSection = "ruleslot10_projecttreecontext"

		EndSwitch


		$sections_ProjectISN = IniReadSection($Pfad_zur_Project_ISN, $MacroSlot_TriggerSection)
		$sections_ProjectISN_error = @error
		$sections_GlobalMacros = IniReadSection($GlobalMacrosINIPath, $MacroSlot_TriggerSection)
		$sections_GlobalMacros_error = @error

		If $sections_ProjectISN_error And $sections_GlobalMacros_error Then
			;Macroslot does NOT exist in global AND project macro ini
			If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $MacroSlot_ToolsMenueItemHandle, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $MacroSlot_ToolsMenueItemHandle, $MFS_DISABLED, True, False) ;Disable
			If Not BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $MacroSlot_ToolbarItemHandle), $TBSTATE_HIDDEN) Then _GUICtrlToolbar_SetButtonState($hToolbar, $MacroSlot_ToolbarItemHandle, _GUICtrlToolbar_GetButtonState($hToolbar, $MacroSlot_ToolbarItemHandle) + $TBSTATE_HIDDEN)
			_GUICtrlODMenuItemSetText($MacroSlot_ToolsMenueItemHandle, $MacroSlot_DefaultName & @TAB & $MacroSlot_HotkeyKeycode)
			_GUICtrlODMenuItemSetIcon($MacroSlot_ToolsMenueItemHandle, $smallIconsdll, $MacroSlot_IconIndexInSmallIconsdll)
			_Imagelist_replace_icon($hToolBarImageListNorm, $MacroSlot_IconIndexInToolBarImageList, $smallIconsdll, $MacroSlot_IconIndexInSmallIconsdll + 1)
			_GUICtrlToolbar_SetButtonBitMap($hToolbar, $MacroSlot_ToolbarItemHandle, $MacroSlot_IconIndexInToolBarImageList)
			$readen_icon = $MacroSlot_IconIndexInSmallIconsdll
			$MacroSlot_Name = $MacroSlot_DefaultName
			$MacroSlot_ShowInTreeViewContext = 0
		Else

			$MacroSlot_Name = "" ;Clear the macro name, so we can read out from the ini(s)
			$MacroSlot_Status = "" ;Clear macro status
			$MacroSlotINISection = "ISNAUTOITSTUDIO"
			$MacroSlot_ShowInTreeViewContext = 0

			;Loop through Macro INIs
			For $INIsCnt = 0 To UBound($MacroINIs_Array) - 1

				;Verify if there is a macro on this trigger
				If $MacroINIs_Array[$INIsCnt] = $Pfad_zur_Project_ISN And $sections_ProjectISN_error Then ContinueLoop
				If $MacroINIs_Array[$INIsCnt] = $GlobalMacrosINIPath And $sections_GlobalMacros_error Then ContinueLoop


				;Load all listet macros assigned to a trigger and loop through
				If $MacroINIs_Array[$INIsCnt] = $Pfad_zur_Project_ISN Then
					$MacrosInTriggerArray = $sections_ProjectISN
					$MacroSlotINISection = "ISNAUTOITSTUDIO"
				EndIf
				If $MacroINIs_Array[$INIsCnt] = $GlobalMacrosINIPath Then
					$MacrosInTriggerArray = $sections_GlobalMacros
					$MacroSlotINISection = "config"
				EndIf
				If Not IsArray($MacrosInTriggerArray) Then ContinueLoop

				;Loop through macros in this trigger
				For $MacrosInTriggerCnt = 0 To UBound($MacrosInTriggerArray) - 1
					If $MacrosInTriggerCnt = 0 Then ContinueLoop ;Ignore index

					;Set INI Section
					$MacroSlot_INISection = $MacrosInTriggerArray[$MacrosInTriggerCnt][0]
					$MacroSlot_Status_tmp = IniRead($MacroINIs_Array[$INIsCnt], $MacroSlot_INISection, "status", "active")
					If $MacroSlot_Status_tmp = "" Then $MacroSlot_Status = $MacroSlot_Status_tmp
					If $MacroSlot_Status_tmp = "active" Then $MacroSlot_Status = $MacroSlot_Status_tmp
					If $MacroSlot_Status_tmp <> "active" Then ContinueLoop ;Ignore deactivated macros


					;Generate Macro Name (if there are multiple macros per slot, combine the names)
					$MacroSlot_Name_tmp = IniRead($MacroINIs_Array[$INIsCnt], $MacroSlot_INISection, "name", "")
					If $MacroSlot_Name = "" Then
						$MacroSlot_Name = $MacroSlot_Name_tmp
					Else
						$MacroSlot_Name = $MacroSlot_Name & ", " & $MacroSlot_Name_tmp
						$MultiTrigger = 1 ;Global macro has priority!
					EndIf

					;Set menu text and icons and verify that the macro is active
					_GUICtrlODMenuItemSetText($MacroSlot_ToolsMenueItemHandle, $MacroSlot_Name & @TAB & $MacroSlot_HotkeyKeycode)
					If $MultiTrigger = 0 Then
						$MacroSlot_ShowInTreeViewContext = IniRead($MacroINIs_Array[$INIsCnt], $MacroSlotINISection, $MacroSlot_ProjecttreecontextSection, 0)
						$readen_icon = IniRead($MacroINIs_Array[$INIsCnt], $MacroSlotINISection, $MacroSlot_IconINISection, $MacroSlot_IconIndexInSmallIconsdll + 1)
						$readen_icon = Number($readen_icon)
						If $readen_icon > 1 Then
							$readen_icon = $readen_icon - 1
						Else
							$readen_icon = 0
						EndIf
						_Imagelist_replace_icon($hToolBarImageListNorm, $MacroSlot_IconIndexInToolBarImageList, $smallIconsdll, $readen_icon)
						_GUICtrlToolbar_SetButtonBitMap($hToolbar, $MacroSlot_ToolbarItemHandle, $MacroSlot_IconIndexInToolBarImageList)
						_GUICtrlODMenuItemSetIcon($MacroSlot_ToolsMenueItemHandle, $smallIconsdll, $readen_icon + 1)
					EndIf
				Next

				;Enable/Disable the MacroSlot in the tools menu & toolbar
				If $MacroSlot_Status = "active" Then
					If BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $MacroSlot_ToolbarItemHandle), $TBSTATE_HIDDEN) Then _GUICtrlToolbar_SetButtonState($hToolbar, $MacroSlot_ToolbarItemHandle, _GUICtrlToolbar_GetButtonState($hToolbar, $MacroSlot_ToolbarItemHandle) - $TBSTATE_HIDDEN)
					If Not BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $MacroSlot_ToolbarItemHandle), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $MacroSlot_ToolbarItemHandle, _GUICtrlToolbar_GetButtonState($hToolbar, $MacroSlot_ToolbarItemHandle) + $TBSTATE_ENABLED)
					If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $MacroSlot_ToolsMenueItemHandle, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $MacroSlot_ToolsMenueItemHandle, $MFS_DISABLED, False, False) ;Enable
				Else
					If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $MacroSlot_ToolsMenueItemHandle, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $MacroSlot_ToolsMenueItemHandle, $MFS_DISABLED, True, False) ;Disable
					If Not BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $MacroSlot_ToolbarItemHandle), $TBSTATE_HIDDEN) Then _GUICtrlToolbar_SetButtonState($hToolbar, $MacroSlot_ToolbarItemHandle, _GUICtrlToolbar_GetButtonState($hToolbar, $MacroSlot_ToolbarItemHandle) + $TBSTATE_HIDDEN)
					_GUICtrlODMenuItemSetText($MacroSlot_ToolsMenueItemHandle, $MacroSlot_DefaultName & @TAB & $MacroSlot_HotkeyKeycode)
					_GUICtrlODMenuItemSetIcon($MacroSlot_ToolsMenueItemHandle, $smallIconsdll, $MacroSlot_IconIndexInSmallIconsdll)
					_Imagelist_replace_icon($hToolBarImageListNorm, $MacroSlot_IconIndexInToolBarImageList, $smallIconsdll, $MacroSlot_IconIndexInSmallIconsdll + 1)
					_GUICtrlToolbar_SetButtonBitMap($hToolbar, $MacroSlot_ToolbarItemHandle, $MacroSlot_IconIndexInToolBarImageList)
				EndIf

			Next
		EndIf
		_ArrayAdd($Macroslot_InfoArray, $MacroSlotCnt & "|" & $MacroSlot_Name & "|" & $readen_icon & "|" & $MacroSlot_ShowInTreeViewContext) ;Add some Infos to our Info Array
	Next


	_ISN_Toolbar_Set_IconSize()
	_Erstelle_Kontextmenu_fuer_Projektbaum() ;Aktualisiere Kontextmenü des Projektbaumes
	_Write_ISN_Debug_Console("done", $ISN_Debug_Console_Errorlevel_Info, $ISN_Debug_Console_Linebreak, 1, 1) ;Write log

	;Unlock Gui and avoid flickering
	_ISN_UnlockGUIWithoutFlickering($Studiofenster)

EndFunc   ;==>_Reload_Ruleslots




Func _deaktiviere_Buttons_fuer_Editormodus()
	Local $GUICtrlTab_GetCurFocus = _GUICtrlTab_GetCurFocus($htab)
	;Deaktiviere einige Optionen im Editormodus
	If $Studiomodus = 2 Then

		;Disable
		If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_ProjectSettings, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_ProjectSettings, $MFS_DISABLED, True, False)
		If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_ExportFile, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_ExportFile, $MFS_DISABLED, True, False)
		If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $TreeviewContextMenu_temp_au3_file, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $TreeviewContextMenu_temp_au3_file, $MFS_DISABLED, True, False)
		If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_TestProject, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_TestProject, $MFS_DISABLED, True, False)
		If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_TestProjectWithoutParameters, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_TestProjectWithoutParameters, $MFS_DISABLED, True, False)
		If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_Compile, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_Compile, $MFS_DISABLED, True, False)
		If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_CompileSettings, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_CompileSettings, $MFS_DISABLED, True, False)
		If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_NewTempAu3File, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_NewTempAu3File, $MFS_DISABLED, True, False)
		If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_SelectFilesForCompile, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_SelectFilesForCompile, $MFS_DISABLED, True, False)
		If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_HelpMenu_Trophies, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_HelpMenu_Trophies, $MFS_DISABLED, True, False)

		;Enable
		If Not _GUICtrlTab_GetItemCount($htab) = 0 And $GUICtrlTab_GetCurFocus <> -1 Then
			If StringTrimLeft($Datei_pfad[$GUICtrlTab_GetCurFocus], StringInStr($Datei_pfad[$GUICtrlTab_GetCurFocus], ".", 0, -1)) = $Autoitextension Then
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_Compile, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_Compile, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_CompileSettings, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_CompileSettings, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_TestProject, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_TestProject, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_TestProjectWithoutParameters, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_TestProjectWithoutParameters, $MFS_DISABLED, False, False)
				If Not BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_CommentOut), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_CommentOut, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_CommentOut) + $TBSTATE_ENABLED)
			EndIf
		EndIf
		If BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_ProjectProperties), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_ProjectProperties, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_ProjectProperties) - $TBSTATE_ENABLED)
		If BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_ExportFile), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_ExportFile, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_ExportFile) - $TBSTATE_ENABLED)
		If BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_ProjectSettings), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_ProjectSettings, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_ProjectSettings) - $TBSTATE_ENABLED)
		_GUICtrlODMenuItemSetText($ISN_ProjectMenu_TestProjectMenu, _Get_langstr(82))
		_GUICtrlODMenuItemSetText($ISN_ProjectMenu_CloseProject, _Get_langstr(665) & @TAB & _Keycode_zu_Text($Hotkey_Keycode_Close_project))
		_GUICtrlToolbar_SetButtonText($hToolbar, $ISN_Toolbar_CloseProject, _Get_langstr(665))
		_GUICtrlODMenuItemSetText($ISN_ProjectMenu_TestProject, _Get_langstr(668) & @TAB & _Keycode_zu_Text($Hotkey_Keycode_Testprojekt))
		_GUICtrlODMenuItemSetText($ISN_ProjectMenu_CompileMenu, _Get_langstr(601))
		_GUICtrlODMenuItemSetText($ISN_ProjectMenu_Compile, _Get_langstr(601) & @TAB & _Keycode_zu_Text($Hotkey_Keycode_compile))
		_GUICtrlODMenuItemSetText($ISN_ProjectMenu_TestProjectWithoutParameters, _Get_langstr(669) & @TAB & _Keycode_zu_Text($Hotkey_Keycode_Testprojekt_ohne_Parameter))


	Else
		If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_Compile, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_Compile, $MFS_DISABLED, False, False)
		If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_CompileSettings, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_CompileSettings, $MFS_DISABLED, False, False)
		If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_NewTempAu3File, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_NewTempAu3File, $MFS_DISABLED, False, False)
		If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $TreeviewContextMenu_temp_au3_file, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $TreeviewContextMenu_temp_au3_file, $MFS_DISABLED, False, False)
		If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_SelectFilesForCompile, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_SelectFilesForCompile, $MFS_DISABLED, False, False)
		If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_ProjectSettings, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_ProjectSettings, $MFS_DISABLED, False, False)
		If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_ExportFile, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_ExportFile, $MFS_DISABLED, False, False)
		If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_TestProjectMenu, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_TestProjectMenu, $MFS_DISABLED, False, False)
		If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_TestProjectWithoutParameters, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_TestProjectWithoutParameters, $MFS_DISABLED, False, False)
		If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_HelpMenu_Trophies, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_HelpMenu_Trophies, $MFS_DISABLED, False, False)

		If Not BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_ProjectProperties), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_ProjectProperties, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_ProjectProperties) + $TBSTATE_ENABLED)
		If Not BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_ExportFile), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_ExportFile, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_ExportFile) + $TBSTATE_ENABLED)
		If Not BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_ProjectSettings), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_ProjectSettings, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_ProjectSettings) + $TBSTATE_ENABLED)
		_GUICtrlToolbar_SetButtonText($hToolbar, $ISN_Toolbar_CloseProject, _Get_langstr(41))
		_GUICtrlODMenuItemSetText($ISN_ProjectMenu_CloseProject, _Get_langstr(41) & @TAB & _Keycode_zu_Text($Hotkey_Keycode_Close_project))
		_GUICtrlODMenuItemSetText($ISN_ProjectMenu_TestProjectMenu, _Get_langstr(489))
		_GUICtrlODMenuItemSetText($ISN_ProjectMenu_TestProject, _Get_langstr(50) & @TAB & _Keycode_zu_Text($Hotkey_Keycode_Testprojekt))
		_GUICtrlODMenuItemSetText($ISN_ProjectMenu_TestProjectWithoutParameters, _Get_langstr(488) & @TAB & _Keycode_zu_Text($Hotkey_Keycode_Testprojekt_ohne_Parameter))
		_GUICtrlODMenuItemSetText($ISN_ProjectMenu_CompileMenu, _Get_langstr(52))
		_GUICtrlODMenuItemSetText($ISN_ProjectMenu_Compile, _Get_langstr(52) & @TAB & _Keycode_zu_Text($Hotkey_Keycode_compile))
	EndIf

EndFunc   ;==>_deaktiviere_Buttons_fuer_Editormodus







Func _Toolbars_Layout_erkennen()
	If _GUICtrlTab_GetItemCount($htab) = 0 Then Return "none"
	Local $GUICtrlTab_GetCurFocus = _GUICtrlTab_GetCurFocus($htab)
	If $GUICtrlTab_GetCurFocus = -1 Then Return "none"
	If StringTrimLeft($Datei_pfad[$GUICtrlTab_GetCurFocus], StringInStr($Datei_pfad[$GUICtrlTab_GetCurFocus], ".", 0, -1)) = $Autoitextension Then Return "au3"
	If $Plugin_Handle[$GUICtrlTab_GetCurFocus] <> "-1" Then Return "plugin"
	If $Plugin_Handle[$GUICtrlTab_GetCurFocus] = "-1" Then Return "text"
	Return "none"
EndFunc   ;==>_Toolbars_Layout_erkennen




Func _Check_Buttons($buildtree = 1)
	AdlibUnRegister("_Check_Buttons")


	_Studiofenster_Refresh_Menu_Checkboxes()

	$Automatische_Speicherung_eingabecounter = 0 ;Eingabecounter resetten

	;Benötigtes Layout ermitteln (zb. werden bei Plugins diverse Buttons deaktiviert)
	;Ist das benötigte Layout <> $Toolbars_Aktuelles_Layout werden die Buttons aktuallisiert (flackern in der GUI)
	;none = Layout wenn keine Tabs geöffnet sind
	;au3 = Layout wenn eine AutoIt Datei geöffnet ist
	;text = Layout wenn eine text Datei geöffnet ist
	;plugin = Layout wenn ein Plugin geöffnet ist
	$benoetigtes_Layout = _Toolbars_Layout_erkennen()
	If $benoetigtes_Layout <> $Toolbars_Aktuelles_Layout Then ;Layout nur refreshen wenn nötig

		Switch $benoetigtes_Layout

			Case "none"
				$Toolbars_Aktuelles_Layout = $benoetigtes_Layout

				;menu (Disable)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_UndockTab, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_UndockTab, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_SelectAll, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_SelectAll, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_SaveAllTabs, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_SaveAllTabs, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_CloseAllTabs, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_CloseAllTabs, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_SaveAs, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_SaveAs, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_Save, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_Save, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_Print, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_Print, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_ReloadFilecontent, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_ReloadFilecontent, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ToggleBottomArea, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ToggleBottomArea, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ToggleRightArea, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ToggleRightArea, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_CloseTab, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_CloseTab, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_TestScript, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_TestScript, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_SearchAndReplace, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_SearchAndReplace, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Undo, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Undo, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Redo, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Redo, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Cut, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Cut, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Copy, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Copy, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Paste, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Paste, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Delete, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Delete, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_SearchAndReplace, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_SearchAndReplace, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_Au3SyntaxCheck, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_Au3SyntaxCheck, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_GoToLine, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_GoToLine, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_TidySource, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_TidySource, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_CommentOut, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_CommentOut, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_ShowCallTip, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_ShowCallTip, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_TestSelectedCode, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_TestSelectedCode, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_HideComments, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_HideComments, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ContractCodesegments, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ContractCodesegments, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ExpandCodesegments, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ExpandCodesegments, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ExpandRegions, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ExpandRegions, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ContractRegions, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ContractRegions, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_MoveRowsUp, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_MoveRowsUp, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_MoveRowsDown, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_MoveRowsDown, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Duplicate, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Duplicate, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_JumpToFunc, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_JumpToFunc, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_AddAllMachtingWordToSelection, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_AddAllMachtingWordToSelection, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_AddPrevMachtingWordToSelection, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_AddPrevMachtingWordToSelection, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_AddNextMachtingWordToSelection, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_AddNextMachtingWordToSelection, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_MsgBoxGenerator, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_MsgBoxGenerator, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_DebuggingMenu, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_DebuggingMenu, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_CreateUDFHeader, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_CreateUDFHeader, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_AutoIt3Wrapper, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_AutoIt3Wrapper, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_ParameterEditor, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_ParameterEditor, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_BookmarksMenu, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_BookmarksMenu, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayIndentationGuides, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayIndentationGuides, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ShowLineNumbers, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ShowLineNumbers, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ShowFoldMargin, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ShowFoldMargin, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ShowBookmarkMargin, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ShowBookmarkMargin, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayWhitespaces, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayWhitespaces, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayEndofLine, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayEndofLine, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayQuickSearchBar, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayQuickSearchBar, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_UseTabInDualMode, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_UseTabInDualMode, $MFS_DISABLED, True, False)

				;Context Menu (disable)
				If Not BitAND(_GUICtrlMenu_GetItemState(GUICtrlGetHandle($TabContextMenu), $TabContextMenu_UndockTab, False), 4) Then _GUICtrlMenu_SetItemState(GUICtrlGetHandle($TabContextMenu), $TabContextMenu_UndockTab, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState(GUICtrlGetHandle($TabContextMenu), $TabContextMenu_UseTabInDualMode, False), 4) Then _GUICtrlMenu_SetItemState(GUICtrlGetHandle($TabContextMenu), $TabContextMenu_UseTabInDualMode, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState(GUICtrlGetHandle($TabContextMenu), $TabContextMenu_Item1, False), 4) Then _GUICtrlMenu_SetItemState(GUICtrlGetHandle($TabContextMenu), $TabContextMenu_Item1, $MFS_DISABLED, True, False)


				;toolbar (Disable)
				If BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_Redo), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_Redo, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_Redo) - $TBSTATE_ENABLED)
				If BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_TestScript), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_TestScript, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_TestScript) - $TBSTATE_ENABLED)
				If BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_StopScript), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_StopScript, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_StopScript) - $TBSTATE_ENABLED)
				If BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_Undo), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_Undo, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_Undo) - $TBSTATE_ENABLED)
				If BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_ToggleSearch), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_ToggleSearch, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_ToggleSearch) - $TBSTATE_ENABLED)
				If BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_Au3SyntaxCheck), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_Au3SyntaxCheck, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_Au3SyntaxCheck) - $TBSTATE_ENABLED)
				If BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_TidySource), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_TidySource, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_TidySource) - $TBSTATE_ENABLED)
				If BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_CommentOut), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_CommentOut, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_CommentOut) - $TBSTATE_ENABLED)
				If BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_SaveAllTabs), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_SaveAllTabs, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_SaveAllTabs) - $TBSTATE_ENABLED)
				If BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_Save), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_Save, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_Save) - $TBSTATE_ENABLED)
				If BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_CloseTab), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_CloseTab, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_CloseTab) - $TBSTATE_ENABLED)


			Case "text"
				$Toolbars_Aktuelles_Layout = $benoetigtes_Layout

				;deactivate (menu)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_UndockTab, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_UndockTab, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_JumpToFunc, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_JumpToFunc, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_AddAllMachtingWordToSelection, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_AddAllMachtingWordToSelection, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_AddPrevMachtingWordToSelection, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_AddPrevMachtingWordToSelection, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_AddNextMachtingWordToSelection, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_AddNextMachtingWordToSelection, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_CommentOut, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_CommentOut, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ContractCodesegments, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ContractCodesegments, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ExpandCodesegments, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ExpandCodesegments, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ContractRegions, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ContractRegions, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ExpandRegions, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ExpandRegions, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_Au3SyntaxCheck, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_Au3SyntaxCheck, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_TidySource, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_TidySource, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_DebugToMSGBox, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_DebugToMSGBox, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_DebugToConsole, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_DebugToConsole, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_MsgBoxGenerator, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_MsgBoxGenerator, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_CreateUDFHeader, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_CreateUDFHeader, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_AutoIt3Wrapper, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_AutoIt3Wrapper, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_ParameterEditor, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_ParameterEditor, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_TestScript, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_TestScript, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_ShowCallTip, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_ShowCallTip, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_TestSelectedCode, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_TestSelectedCode, $MFS_DISABLED, True, False)

				;deactivate (context menu)
				If Not BitAND(_GUICtrlMenu_GetItemState(GUICtrlGetHandle($TabContextMenu), $TabContextMenu_UndockTab, False), 4) Then _GUICtrlMenu_SetItemState(GUICtrlGetHandle($TabContextMenu), $TabContextMenu_UndockTab, $MFS_DISABLED, True, False)

				;activate (menu)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_Print, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_Print, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_ReloadFilecontent, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_ReloadFilecontent, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_SaveAs, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_SaveAs, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Cut, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Cut, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Copy, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Copy, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Paste, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Paste, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Delete, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Delete, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_SearchAndReplace, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_SearchAndReplace, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_Au3SyntaxCheck, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_Au3SyntaxCheck, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_GoToLine, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_GoToLine, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_SelectAll, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_SelectAll, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Duplicate, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Duplicate, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_CloseTab, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_CloseTab, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_CloseAllTabs, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_CloseAllTabs, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_Save, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_Save, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_SaveAllTabs, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_SaveAllTabs, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_BookmarksMenu, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_BookmarksMenu, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ShowLineNumbers, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ShowLineNumbers, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayIndentationGuides, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayIndentationGuides, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ShowFoldMargin, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ShowFoldMargin, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayWhitespaces, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayWhitespaces, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayEndofLine, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayEndofLine, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_TidySource, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_TidySource, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ShowBookmarkMargin, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ShowBookmarkMargin, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayQuickSearchBar, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayQuickSearchBar, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_UseTabInDualMode, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_UseTabInDualMode, $MFS_DISABLED, False, False)

				;activate (context menu)
				If BitAND(_GUICtrlMenu_GetItemState(GUICtrlGetHandle($TabContextMenu), $TabContextMenu_Item1, False), 4) Then _GUICtrlMenu_SetItemState(GUICtrlGetHandle($TabContextMenu), $TabContextMenu_Item1, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState(GUICtrlGetHandle($TabContextMenu), $TabContextMenu_UseTabInDualMode, False), 4) Then _GUICtrlMenu_SetItemState(GUICtrlGetHandle($TabContextMenu), $TabContextMenu_UseTabInDualMode, $MFS_DISABLED, False, False)

				;activate (toolbar)
				If Not BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_Save), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_Save, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_Save) + $TBSTATE_ENABLED)
				If Not BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_ToggleSearch), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_ToggleSearch, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_ToggleSearch) + $TBSTATE_ENABLED)
				If Not BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_SaveAllTabs), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_SaveAllTabs, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_SaveAllTabs) + $TBSTATE_ENABLED)
				If Not BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_CloseTab), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_CloseTab, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_CloseTab) + $TBSTATE_ENABLED)

				;deactivate (toolbar)
				If BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_TestScript), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_TestScript, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_TestScript) - $TBSTATE_ENABLED)
				If BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_Au3SyntaxCheck), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_Au3SyntaxCheck, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_Au3SyntaxCheck) - $TBSTATE_ENABLED)
				If BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_TidySource), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_TidySource, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_TidySource) - $TBSTATE_ENABLED)
				If BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_CommentOut), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_CommentOut, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_CommentOut) - $TBSTATE_ENABLED)


			Case "au3"
				$Toolbars_Aktuelles_Layout = $benoetigtes_Layout

				;deactivate (context menu)
				If Not BitAND(_GUICtrlMenu_GetItemState(GUICtrlGetHandle($TabContextMenu), $TabContextMenu_UndockTab, False), 4) Then _GUICtrlMenu_SetItemState(GUICtrlGetHandle($TabContextMenu), $TabContextMenu_UndockTab, $MFS_DISABLED, True, False)

				;deactivate (menu)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_UndockTab, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_UndockTab, $MFS_DISABLED, True, False)

				;activate (menu)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_SelectAll, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_SelectAll, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_SaveAllTabs, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_SaveAllTabs, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_CloseAllTabs, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_CloseAllTabs, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_SaveAs, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_SaveAs, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_Save, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_Save, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_CloseTab, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_CloseTab, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_TestScript, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_TestScript, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_DebugToMSGBox, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_DebugToMSGBox, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_DebugToConsole, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_DebugToConsole, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_TidySource, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_TidySource, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_CommentOut, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_CommentOut, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ContractCodesegments, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ContractCodesegments, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ExpandRegions, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ExpandRegions, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ContractRegions, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ContractRegions, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ExpandCodesegments, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ExpandCodesegments, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_JumpToFunc, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_JumpToFunc, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_AddAllMachtingWordToSelection, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_AddAllMachtingWordToSelection, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_AddPrevMachtingWordToSelection, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_AddPrevMachtingWordToSelection, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_AddNextMachtingWordToSelection, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_AddNextMachtingWordToSelection, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_MsgBoxGenerator, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_MsgBoxGenerator, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_DebuggingMenu, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_DebuggingMenu, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_CreateUDFHeader, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_CreateUDFHeader, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_AutoIt3Wrapper, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_AutoIt3Wrapper, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_ParameterEditor, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_ParameterEditor, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Duplicate, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Duplicate, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_Print, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_Print, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_ReloadFilecontent, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_ReloadFilecontent, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Cut, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Cut, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Copy, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Copy, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Paste, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Paste, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Delete, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Delete, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_SearchAndReplace, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_SearchAndReplace, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_Au3SyntaxCheck, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_Au3SyntaxCheck, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_GoToLine, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_GoToLine, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_ShowCallTip, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_ShowCallTip, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_TestSelectedCode, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_TestSelectedCode, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_CommentOut, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_CommentOut, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_SaveAs, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_SaveAs, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_HideComments, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_HideComments, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_MoveRowsUp, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_MoveRowsUp, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_MoveRowsDown, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_MoveRowsDown, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_BookmarksMenu, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_BookmarksMenu, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayIndentationGuides, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayIndentationGuides, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ShowLineNumbers, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ShowLineNumbers, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ShowFoldMargin, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ShowFoldMargin, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ShowBookmarkMargin, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ShowBookmarkMargin, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayWhitespaces, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayWhitespaces, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayEndofLine, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayEndofLine, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayQuickSearchBar, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayQuickSearchBar, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_UseTabInDualMode, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_UseTabInDualMode, $MFS_DISABLED, False, False)

				If $hidedebug = "false" Then
					If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ToggleBottomArea, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ToggleBottomArea, $MFS_DISABLED, False, False)
				EndIf
				If $hidefunctionstree = "false" Then
					If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ToggleRightArea, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ToggleRightArea, $MFS_DISABLED, False, False)
				EndIf

				;activate (context menu)
				If BitAND(_GUICtrlMenu_GetItemState(GUICtrlGetHandle($TabContextMenu), $TabContextMenu_Item1, False), 4) Then _GUICtrlMenu_SetItemState(GUICtrlGetHandle($TabContextMenu), $TabContextMenu_Item1, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState(GUICtrlGetHandle($TabContextMenu), $TabContextMenu_UseTabInDualMode, False), 4) Then _GUICtrlMenu_SetItemState(GUICtrlGetHandle($TabContextMenu), $TabContextMenu_UseTabInDualMode, $MFS_DISABLED, False, False)

				;activate (toolbar)
				If Not BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_ToggleSearch), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_ToggleSearch, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_ToggleSearch) + $TBSTATE_ENABLED)
				If Not BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_Save), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_Save, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_Save) + $TBSTATE_ENABLED)
				If Not BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_SaveAllTabs), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_SaveAllTabs, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_SaveAllTabs) + $TBSTATE_ENABLED)
				If Not BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_CloseTab), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_CloseTab, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_CloseTab) + $TBSTATE_ENABLED)
				If Not BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_CommentOut), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_CommentOut, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_CommentOut) + $TBSTATE_ENABLED)
				If Not BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_Au3SyntaxCheck), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_Au3SyntaxCheck, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_Au3SyntaxCheck) + $TBSTATE_ENABLED)
				If Not BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_TidySource), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_TidySource, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_TidySource) + $TBSTATE_ENABLED)



			Case "plugin"
				$Toolbars_Aktuelles_Layout = $benoetigtes_Layout

				;deactivate (menu)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_JumpToFunc, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_JumpToFunc, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_AddAllMachtingWordToSelection, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_AddAllMachtingWordToSelection, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_AddPrevMachtingWordToSelection, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_AddPrevMachtingWordToSelection, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_AddNextMachtingWordToSelection, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_AddNextMachtingWordToSelection, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_CommentOut, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_CommentOut, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ContractCodesegments, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ContractCodesegments, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ContractRegions, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ContractRegions, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ExpandRegions, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ExpandRegions, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ExpandCodesegments, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ExpandCodesegments, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_Au3SyntaxCheck, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_Au3SyntaxCheck, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_TidySource, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_TidySource, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_DebugToMSGBox, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_DebugToMSGBox, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_DebugToConsole, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_DebugToConsole, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_MsgBoxGenerator, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_MsgBoxGenerator, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_CreateUDFHeader, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_CreateUDFHeader, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_AutoIt3Wrapper, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_AutoIt3Wrapper, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_ParameterEditor, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_ParameterEditor, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_SearchAndReplace, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_SearchAndReplace, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_GoToLine, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_GoToLine, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Duplicate, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Duplicate, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_Print, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_Print, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_ReloadFilecontent, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_ReloadFilecontent, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Cut, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Cut, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Copy, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Copy, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Paste, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Paste, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Delete, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_Delete, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_SearchAndReplace, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_SearchAndReplace, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_Au3SyntaxCheck, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_Au3SyntaxCheck, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_GoToLine, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_GoToLine, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_CommentOut, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_CommentOut, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_SaveAs, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_SaveAs, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_TestScript, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_TestScript, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_HideComments, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_HideComments, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_MoveRowsUp, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_MoveRowsUp, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_MoveRowsDown, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_MoveRowsDown, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_BookmarksMenu, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_SearchMenu_BookmarksMenu, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_SelectAll, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_SelectAll, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayIndentationGuides, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayIndentationGuides, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ShowLineNumbers, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ShowLineNumbers, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ShowFoldMargin, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ShowFoldMargin, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ShowBookmarkMargin, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_ShowBookmarkMargin, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayWhitespaces, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayWhitespaces, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayEndofLine, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayEndofLine, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_ShowCallTip, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_ShowCallTip, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_TestSelectedCode, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_EditMenu_TestSelectedCode, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayQuickSearchBar, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DisplayQuickSearchBar, $MFS_DISABLED, True, False)
				If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_UseTabInDualMode, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_UseTabInDualMode, $MFS_DISABLED, True, False)

				;activate (menu)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_SaveAllTabs, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_SaveAllTabs, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_CloseTab, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_CloseTab, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_CloseAllTabs, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_CloseAllTabs, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_Save, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_Save, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_UndockTab, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_FileMenu_UndockTab, $MFS_DISABLED, False, False)

				;deactivate (context menu)
				If Not BitAND(_GUICtrlMenu_GetItemState(GUICtrlGetHandle($TabContextMenu), $TabContextMenu_UseTabInDualMode, False), 4) Then _GUICtrlMenu_SetItemState(GUICtrlGetHandle($TabContextMenu), $TabContextMenu_UseTabInDualMode, $MFS_DISABLED, True, False)

				;activate (context menu)
				If BitAND(_GUICtrlMenu_GetItemState(GUICtrlGetHandle($TabContextMenu), $TabContextMenu_Item1, False), 4) Then _GUICtrlMenu_SetItemState(GUICtrlGetHandle($TabContextMenu), $TabContextMenu_Item1, $MFS_DISABLED, False, False)
				If BitAND(_GUICtrlMenu_GetItemState(GUICtrlGetHandle($TabContextMenu), $TabContextMenu_UndockTab, False), 4) Then _GUICtrlMenu_SetItemState(GUICtrlGetHandle($TabContextMenu), $TabContextMenu_UndockTab, $MFS_DISABLED, False, False)


				;activate (toolbar)
				If Not BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_Save), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_Save, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_Save) + $TBSTATE_ENABLED)
				If Not BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_SaveAllTabs), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_SaveAllTabs, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_SaveAllTabs) + $TBSTATE_ENABLED)
				If Not BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_CloseTab), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_CloseTab, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_CloseTab) + $TBSTATE_ENABLED)

				;deactivate (toolbar)
				If BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_ToggleSearch), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_ToggleSearch, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_ToggleSearch) - $TBSTATE_ENABLED)
				If BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_TestScript), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_TestScript, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_TestScript) - $TBSTATE_ENABLED)
				If BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_Au3SyntaxCheck), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_Au3SyntaxCheck, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_Au3SyntaxCheck) - $TBSTATE_ENABLED)
				If BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_TidySource), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_TidySource, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_TidySource) - $TBSTATE_ENABLED)
				If BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_CommentOut), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_CommentOut, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_CommentOut) - $TBSTATE_ENABLED)

		EndSwitch

	EndIf

	_Check_tabs_for_changes()

	If $Scripteditor_EnableDualEditor = "true" Then
		If BitAND(_GUICtrlMenu_GetItemState(GUICtrlGetHandle($TabContextMenu), $TabContextMenu_ExitDualMode, False), 4) Then _GUICtrlMenu_SetItemState(GUICtrlGetHandle($TabContextMenu), $TabContextMenu_ExitDualMode, $MFS_DISABLED, False, False)
		If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DualEditor_ExitDualMode, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DualEditor_ExitDualMode, $MFS_DISABLED, False, False)
	Else
		If Not BitAND(_GUICtrlMenu_GetItemState(GUICtrlGetHandle($TabContextMenu), $TabContextMenu_ExitDualMode, False), 4) Then _GUICtrlMenu_SetItemState(GUICtrlGetHandle($TabContextMenu), $TabContextMenu_ExitDualMode, $MFS_DISABLED, True, False)
		If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DualEditor_ExitDualMode, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DualEditor_ExitDualMode, $MFS_DISABLED, True, False)
	EndIf

	If $SKRIPT_LAUEFT = 1 Then
		If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_StopScript, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_StopScript, $MFS_DISABLED, False, False) ;Enable
		If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_TestProjectMenu, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_TestProjectMenu, $MFS_DISABLED, True, False) ;Disable

		If $Toolbars_Aktuelles_Layout = "au3" Then
			If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_TestScript, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_TestScript, $MFS_DISABLED, True, False) ;Disable
			If BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_TestScript), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_TestScript, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_TestScript) - $TBSTATE_ENABLED)
		EndIf

		If Not BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_StopScript), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_StopScript, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_StopScript) + $TBSTATE_ENABLED)
		If BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_Testproject), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_Testproject, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_Testproject) - $TBSTATE_ENABLED)


	Else
		If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_StopScript, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_StopScript, $MFS_DISABLED, True, False) ;Disable
		If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_TestProjectMenu, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_TestProjectMenu, $MFS_DISABLED, False, False) ;Enable

		If $Toolbars_Aktuelles_Layout = "au3" Then
			If BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_TestScript, False), 4) Then _GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ProjectMenu_TestScript, $MFS_DISABLED, False, False) ;Enable
			If Not BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_TestScript), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_TestScript, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_TestScript) + $TBSTATE_ENABLED)
		EndIf

		If BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_StopScript), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_StopScript, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_StopScript) - $TBSTATE_ENABLED)
		If Not BitAND(_GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_Testproject), $TBSTATE_ENABLED) Then _GUICtrlToolbar_SetButtonState($hToolbar, $ISN_Toolbar_Testproject, _GUICtrlToolbar_GetButtonState($hToolbar, $ISN_Toolbar_Testproject) + $TBSTATE_ENABLED)
	EndIf



	If _GUICtrlTab_GetCurFocus($htab) = -1 Or _GUICtrlTab_GetItemCount($htab) = 0 Then
		_deaktiviere_Buttons_fuer_Editormodus()
		Return
	EndIf


	If _GUICtrlTab_GetItemCount($htab) < 1 Then Return
	If Not IsDeclared("buildtree") Then $buildtree = 1

;~ 	If $buildtree = 1 Then _Skriptbaum_aktualisieren()
EndFunc   ;==>_Check_Buttons

Func _Schuetze_Wichtige_daten($file)
	If $file = @DesktopDir Then Return False
	If $file = @MyDocumentsDir Then Return False
	If $file = _ISN_Variablen_aufloesen($Projectfolder) Then Return False
	If $file = _ISN_Variablen_aufloesen($FavoritesSubfolder) Then Return False
	If $file = _ISN_Variablen_aufloesen($UDFs_Folder) Then Return False
	If $file = $PathToAutoItIncludes Then Return False

	If $file = $Offenes_Projekt & "\" & IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "mainfile", "#ERROR#") Then
		MsgBox(262144 + 16, _Get_langstr(25), StringTrimLeft($file, StringInStr($file, "\", 0, -1)) & " " & _Get_langstr(119), 0, $StudioFenster)
		Return False
	EndIf

	If $file = $Pfad_zur_Project_ISN Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(120), 0, $StudioFenster)
		Return False
	EndIf
	Return True
EndFunc   ;==>_Schuetze_Wichtige_daten

Func _Try_to_move_file()
	If $Offenes_Projekt = "" Then Return -1
	If Not IsHWnd($Current_TVExplorer_TreeView) Then Return -1
	Local $Treeview = $Current_TVExplorer_TreeView
	Local $ImportTo_Root = _GUICtrlTVExplorer_GetRootPath($Current_TVExplorer_TreeView)
	Local $OwnerWindow = _WinAPI_GetAncestor($Current_TVExplorer_TreeView, $GA_PARENT)
	If _GUICtrlTreeView_GetSelection($Treeview) = 0 Then Return
	If _WinAPI_PathIsRoot(_GUICtrlTVExplorer_GetSelected($Treeview)) Then Return
	Local $file = _GUICtrlTVExplorer_GetSelected($Treeview)
	Local $sDrive = "", $sDir = "", $sFileName = "", $sExtension = ""
	$Projektbaum_ist_bereit = 0
	$res = _ArraySearch($Datei_pfad, $file)
	If $res <> -1 Then
		$alreadyopen = $res
	Else
		$alreadyopen = -1
	EndIf

	If $alreadyopen = -1 Then
		$sourcefile = _GUICtrlTVExplorer_GetSelected($Treeview)
		If _Schuetze_Wichtige_daten($sourcefile) = False Then
			$Projektbaum_ist_bereit = 1
			Return
		EndIf
		If _FileInUse($sourcefile) = 1 Then
			MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(951), 0, $StudioFenster)
			$Projektbaum_ist_bereit = 1
			Return
		EndIf
		If _GUICtrlTVExplorer_GetSelected($Treeview) = $Offenes_Projekt Then
			$Projektbaum_ist_bereit = 1
			Return
		EndIf
		Local $aPathSplit = _PathSplit($sourcefile, $sDrive, $sDir, $sFileName, $sExtension)
		$PauseRDCEvents = 1
		$destenationfolder = _WinAPI_BrowseForFolderDlg($ImportTo_Root, _Get_langstr(152), $BIF_NEWDIALOGSTYLE + $BIF_RETURNONLYFSDIRS, 0, 0, $OwnerWindow)
		If @error Or $destenationfolder = "" Then
			$PauseRDCEvents = 0
			$Projektbaum_ist_bereit = 1
			Return
		Else


			$PauseRDCEvents = 0
			If StringInStr(FileGetAttrib($sourcefile), "D") Then
				DirMove($sourcefile, $destenationfolder & "\", 1)
				$Porjecttree_FileToSelect_after_Update = $destenationfolder & "\" & $sFileName
			Else
				FileMove($sourcefile, $destenationfolder, 0)
				If $ShowFavoritesInProjecttree = "true" Then _ISN_Favorites_RefreshFilePath($sourcefile, $destenationfolder)
				$Porjecttree_FileToSelect_after_Update = $destenationfolder & "\" & $sFileName & $sExtension
			EndIf
		EndIf


	Else
		MsgBox(262144 + 16, _Get_langstr(25), StringTrimLeft($file, StringInStr($file, "\", 0, -1)) & " " & _Get_langstr(78), 0, $OwnerWindow)
	EndIf
	$Projektbaum_ist_bereit = 1
	If $Studiomodus = 2 Then AdlibRegister("_Update_Treeview") ;Trigger Treeview Refresh in Editormode
EndFunc   ;==>_Try_to_move_file

Func _Projektdatei_umbenennen()
	$Dateiname = StringTrimLeft($Pfad_zur_Project_ISN, StringInStr($Pfad_zur_Project_ISN, "\", 0, -1))
	$neuer_Dateiname = InputBox(_Get_langstr(1117), _Get_langstr(1117), StringReplace($Dateiname, ".isn", ""), "", 200 * $DPI, 150 * $DPI, Default, Default, -1, $StudioFenster)
	If $neuer_Dateiname = "" Then Return
	If @error > 0 Then Return
	$neuer_Dateiname = StringReplace($neuer_Dateiname, ".", "")
	$neuer_Dateiname = StringReplace($neuer_Dateiname, ".isn", "")
	FileMove($Pfad_zur_Project_ISN, $Offenes_Projekt & "\" & $neuer_Dateiname & ".isn", 0)
	If @error Then Return
	$Projektbaum_ist_bereit = 0 ;Sperre Projektbaum
	If $ShowFavoritesInProjecttree = "true" Then _ISN_Favorites_RefreshFilePath($Pfad_zur_Project_ISN, $Offenes_Projekt & "\" & $neuer_Dateiname & ".isn")
	$Pfad_zur_Project_ISN = $Offenes_Projekt & "\" & $neuer_Dateiname & ".isn"
	;_Update_Treeview()
	Sleep(250)
	$Projektbaum_ist_bereit = 1 ;Sperre Projektbaum
EndFunc   ;==>_Projektdatei_umbenennen


Func _ISN_TreeViewRename_EndEdit()
	HotKeySet("{ENTER}")
	HotKeySet("{ESC}")
	GUICtrlSetStyle($Current_Renamed_TreeView, BitXOR(_WinAPI_GetWindowLong(GUICtrlGetHandle($Current_Renamed_TreeView), $GWL_STYLE), $TVS_EDITLABELS)) ;Remove $TVS_EDITLABELS after Edit
	If $Renamed_TreeViewItem_Text = "" Then
		Sleep(250)
		$Projektbaum_ist_bereit = 1
	Else
		_ISN_TreeViewRename_SelectedEntry()
	EndIf
	MouseUp($MOUSE_CLICK_PRIMARY) ;Fix for pressed mouse button in the script editor, after rename end
	If $Studiomodus = 2 Then AdlibRegister("_Update_Treeview") ;Trigger Update in Editormode
EndFunc   ;==>_ISN_TreeViewRename_EndEdit

Func _ISN_TreeViewRename_Cancel()
	HotKeySet("{ENTER}")
	HotKeySet("{ESC}")
	$Renamed_TreeViewItem_Text = ""
	_GUICtrlTreeView_EndEdit($Current_Renamed_TreeView, False)
EndFunc   ;==>_ISN_TreeViewRename_Cancel

Func _ISN_TreeViewRename_OK()
	HotKeySet("{ENTER}")
	HotKeySet("{ESC}")
	$Renamed_TreeViewItem_Text = _GUICtrlEdit_GetText(_GUICtrlTreeView_GetEditControl($Current_Renamed_TreeView))
	_GUICtrlTreeView_EndEdit($Current_Renamed_TreeView)
EndFunc   ;==>_ISN_TreeViewRename_OK

Func _ISN_TreeViewRename_SelectedEntry()
	If $Renamed_TreeViewItem_Text = "" Or $Current_Renamed_TreeView = "" Then
		$Projektbaum_ist_bereit = 1
		Return
	EndIf

	;Check forbidden Chars in the new name
	If StringInStr($Renamed_TreeViewItem_Text, "<") Or StringInStr($Renamed_TreeViewItem_Text, ">") Or StringInStr($Renamed_TreeViewItem_Text, "?") Or StringInStr($Renamed_TreeViewItem_Text, '"') Or _
			StringInStr($Renamed_TreeViewItem_Text, ':') Or StringInStr($Renamed_TreeViewItem_Text, "|") Or StringInStr($Renamed_TreeViewItem_Text, "\") Or StringInStr($Renamed_TreeViewItem_Text, "/") Or StringInStr($Renamed_TreeViewItem_Text, "*") Then
		Sleep(250)
		$Projektbaum_ist_bereit = 1
		Return
	EndIf


	;Prepare paths
	Local $SelectedFile = _GUICtrlTVExplorer_GetSelected($Current_Renamed_TreeView)
	If Not FileExists($SelectedFile) Then
		$Projektbaum_ist_bereit = 1
		Return
	EndIf

	Local $ActiveWindow = WinGetHandle("[ACTIVE]")
	If Not IsHWnd($ActiveWindow) Then $ActiveWindow = $Studiofenster
	Local $SelectedFile_PathSplitDrive = "", $SelectedFile_PathSplitDir = "", $SelectedFile_PathSplitFileName = "", $SelectedFile_PathSplitExtension = ""
	Local $NewFullFilePath_SplitDrive = "", $NewFullFilePath_SplitDir = "", $NewFullFilePath_SplitFileName = "", $NewFullFilePath_SplitExtension = ""
	Local $result = 0
	Local $SelectedFile_PathSplit = _PathSplit($SelectedFile, $SelectedFile_PathSplitDrive, $SelectedFile_PathSplitDir, $SelectedFile_PathSplitFileName, $SelectedFile_PathSplitExtension)
	Local $NewFullFilePath = $SelectedFile_PathSplitDrive & $SelectedFile_PathSplitDir & $Renamed_TreeViewItem_Text
	Local $NewFullFilePath_Split = _PathSplit($NewFullFilePath, $NewFullFilePath_SplitDrive, $NewFullFilePath_SplitDir, $NewFullFilePath_SplitFileName, $NewFullFilePath_SplitExtension)
	If $NewFullFilePath_SplitExtension = "" Then
		$NewFullFilePath = $NewFullFilePath & $SelectedFile_PathSplitExtension
	EndIf

	;Check if file is a shortcut
	Local $ShortcutSufix = ""
	If StringRight($SelectedFile, 4) = ".lnk" And StringInStr($NewFullFilePath_SplitFileName & $NewFullFilePath_SplitExtension, ".") Then $ShortcutSufix = ".lnk" ;Do not add .lnk if the new file has ONLY the .lnk extension
	If StringRight($SelectedFile, 4) = ".lnk" And Not StringInStr($SelectedFile_PathSplitFileName & $SelectedFile_PathSplitExtension, ".") Then $ShortcutSufix = ".lnk" ;Add .lnk if old file name does not contain any extension

	;Check old vs. new name
	If $SelectedFile = $NewFullFilePath & $ShortcutSufix Then
		Sleep(250)
		$Projektbaum_ist_bereit = 1
		Return ;Noting has changed
	EndIf


	;Check if there is already a file with this name
	If FileExists($NewFullFilePath & $ShortcutSufix) Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1409), 0, $ActiveWindow)
		Sleep(250)
		$Projektbaum_ist_bereit = 1
		Return
	EndIf



	;Rename the Treeview-Text (dummy)
	_GUICtrlTreeView_SetText($Current_Renamed_TreeView, _GUICtrlTreeView_GetSelection($Current_Renamed_TreeView), $Renamed_TreeViewItem_Text)

	;Rename stuff
	If StringInStr(FileGetAttrib($SelectedFile), "D") Then
		_Write_ISN_Debug_Console("Try to rename a folder from a treeview...", $ISN_Debug_Console_Errorlevel_Info, $ISN_Debug_Console_Linebreak, $ISN_Debug_Console_Insert_Time, $ISN_Debug_Console_Insert_Title)
		_Write_ISN_Debug_Console("|--> OLD NAME: " & _ISN_Pfad_durch_Variablen_ersetzen($SelectedFile), $ISN_Debug_Console_Errorlevel_Info, $ISN_Debug_Console_Linebreak, $ISN_Debug_Console_Insert_Time, $ISN_Debug_Console_Insert_Title)
		_Write_ISN_Debug_Console("|--> NEW NAME: " & _ISN_Pfad_durch_Variablen_ersetzen($NewFullFilePath), $ISN_Debug_Console_Errorlevel_Info, $ISN_Debug_Console_Linebreak, $ISN_Debug_Console_Insert_Time, $ISN_Debug_Console_Insert_Title)
		_Write_ISN_Debug_Console("|--> RESULT:", $ISN_Debug_Console_Errorlevel_Info, $ISN_Debug_Console_No_Linebreak, $ISN_Debug_Console_Insert_Time, $ISN_Debug_Console_Insert_Title)
		If DirMove($SelectedFile, $NewFullFilePath, 1) Then
			_Write_ISN_Debug_Console("OK", $ISN_Debug_Console_Errorlevel_Info, $ISN_Debug_Console_Linebreak, $ISN_Debug_Console_No_Time, $ISN_Debug_Console_No_Title)
			$Porjecttree_FileToSelect_after_Update = $NewFullFilePath
		Else
			_Write_ISN_Debug_Console("ERROR", $ISN_Debug_Console_Errorlevel_Critical, $ISN_Debug_Console_Linebreak, $ISN_Debug_Console_No_Time, $ISN_Debug_Console_No_Title)
			MsgBox(262144 + 16, _Get_langstr(75), _Get_langstr(1331), 0, $ActiveWindow)
			_Update_Treeview()
		EndIf
	Else
		_Write_ISN_Debug_Console("Try to rename a file from a treeview...", $ISN_Debug_Console_Errorlevel_Info, $ISN_Debug_Console_Linebreak, $ISN_Debug_Console_Insert_Time, $ISN_Debug_Console_Insert_Title)
		_Write_ISN_Debug_Console("|--> OLD NAME: " & _ISN_Pfad_durch_Variablen_ersetzen($SelectedFile), $ISN_Debug_Console_Errorlevel_Info, $ISN_Debug_Console_Linebreak, $ISN_Debug_Console_Insert_Time, $ISN_Debug_Console_Insert_Title)
		_Write_ISN_Debug_Console("|--> NEW NAME: " & _ISN_Pfad_durch_Variablen_ersetzen($NewFullFilePath), $ISN_Debug_Console_Errorlevel_Info, $ISN_Debug_Console_Linebreak, $ISN_Debug_Console_Insert_Time, $ISN_Debug_Console_Insert_Title)
		_Write_ISN_Debug_Console("|--> RESULT:", $ISN_Debug_Console_Errorlevel_Info, $ISN_Debug_Console_No_Linebreak, $ISN_Debug_Console_Insert_Time, $ISN_Debug_Console_Insert_Title)
		If FileMove($SelectedFile, $NewFullFilePath & $ShortcutSufix, 0) Then
			_Write_ISN_Debug_Console("OK", $ISN_Debug_Console_Errorlevel_Info, $ISN_Debug_Console_Linebreak, $ISN_Debug_Console_No_Time, $ISN_Debug_Console_No_Title)
			If $ShowFavoritesInProjecttree = "true" Then _ISN_Favorites_RefreshFilePath($SelectedFile, $NewFullFilePath & $ShortcutSufix)
			$Porjecttree_FileToSelect_after_Update = $NewFullFilePath & $ShortcutSufix
		Else
			_Write_ISN_Debug_Console("ERROR", $ISN_Debug_Console_Errorlevel_Critical, $ISN_Debug_Console_Linebreak, $ISN_Debug_Console_No_Time, $ISN_Debug_Console_No_Title)
			MsgBox(262144 + 16, _Get_langstr(75), _Get_langstr(1331), 0, $ActiveWindow)
			_Update_Treeview()
		EndIf
	EndIf

	;Unlock treeview
	_WinAPI_RedrawWindow(GUICtrlGetHandle($Current_Renamed_TreeView))
	FileChangeDir(@ScriptDir)
	Sleep(250)
	$Projektbaum_ist_bereit = 1

EndFunc   ;==>_ISN_TreeViewRename_SelectedEntry

Func _Rename_File_in_Projecttree()

	If $Offenes_Projekt = "" Then Return
	Local $TreeviewToUse = $Current_TVExplorer_TreeView
	If GUICtrlGetHandle(_GuiCtrlGetFocus(WinGetHandle("[ACTIVE]"))) <> $TreeviewToUse Then Return ;Prüfe ob Projektbaum überhaupt den Fokus besitzt
	If _GUICtrlTreeView_GetSelection($TreeviewToUse) = 0 Then Return
	If _WinAPI_PathIsRoot(_GUICtrlTVExplorer_GetSelected($TreeviewToUse)) Then Return
	Local $OwnerWindow = _WinAPI_GetAncestor($TreeviewToUse, $GA_PARENT)
;~ 	if StringReplace(StringTrimLeft(_GUICtrlTreeView_GetTree($hTreeview, _GUICtrlTreeView_GetSelection($hTreeview)), StringInStr(_GUICtrlTreeView_GetTree($hTreeview, _GUICtrlTreeView_GetSelection($hTreeview)), "|")), $Delim1, $Delim) = iniread($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "name", "#ERROR#") then
	If $Offenes_Projekt = _GUICtrlTVExplorer_GetSelected($TreeviewToUse) Then
		_Zeige_Projekteinstellungen("projectproperties")
		_Rename_Project()
		Return ;cannot rename root
	EndIf

	Local $file = _GUICtrlTVExplorer_GetSelected($TreeviewToUse)
	Local $FileAttributes = FileGetAttrib($file)
	If $file = $Pfad_zur_Project_ISN Then
		_Projektdatei_umbenennen()
		Return
	EndIf

	$oldname = StringTrimLeft($file, StringInStr($file, "\", 0, -1))
	If _Schuetze_Wichtige_daten($file) = False Then Return
	If _FileInUse($file) = 1 Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(951), 0, $OwnerWindow)
		Return
	EndIf



	$res = _ArraySearch($Datei_pfad, $file)
	If $res <> -1 Then
		$alreadyopen = $res
	Else
		$alreadyopen = -1
	EndIf


	If $alreadyopen = -1 Then
;~ 	    _ISN_Studiofenster_SetClipchildren("set") ;To prevent flickering in the main GUI
		$Projektbaum_ist_bereit = 0 ;Sperre Projektbaum
		$Current_Renamed_TreeView = _WinAPI_GetDlgCtrlID($TreeviewToUse)
		GUICtrlSetStyle($Current_Renamed_TreeView, BitOR(_WinAPI_GetWindowLong(GUICtrlGetHandle($Current_Renamed_TreeView), $GWL_STYLE), $TVS_EDITLABELS)) ;Add $TVS_EDITLABELS for Edit
		$Renamed_TreeViewItem_Text = ""
		Local $TreeViewEditControl = _GUICtrlTreeView_EditText($Current_Renamed_TreeView, _GUICtrlTreeView_GetSelection($Current_Renamed_TreeView))
		If Not StringInStr($FileAttributes, "D") Then
			Local $sDrive = "", $sDir = "", $sFileName = "", $sExtension = ""
			Local $aPathSplit = _PathSplit(StringReplace($file, ".lnk", ""), $sDrive, $sDir, $sFileName, $sExtension)
			_GUICtrlEdit_SetSel($TreeViewEditControl, 0, StringLen($sFileName)) ;on files, only select the filename, not the extension
		EndIf



;~ 	_SendMessage(guictrlgethandle($Current_Renamed_TreeView), $WM_SETREDRAW, True)
;~ 	  _ISN_Studiofenster_SetClipchildren("remove") ;To prevent flickering in the main GUI
;~ 	  _GUICtrlTreeView_EndUpdate(guictrlgethandle($Current_Renamed_TreeView))
;~ 		_WinAPI_RedrawWindow(guictrlgethandle($Current_Renamed_TreeView))



		HotKeySet("{ENTER}", "_ISN_TreeViewRename_OK")
		HotKeySet("{ESC}", "_ISN_TreeViewRename_Cancel")

	Else
		MsgBox(262144 + 16, _Get_langstr(25), StringTrimLeft($file, StringInStr($file, "\", 0, -1)) & " " & _Get_langstr(78), 0, $OwnerWindow)
	EndIf
EndFunc   ;==>_Rename_File_in_Projecttree

Func _Export_File()
	Local $Treeview = $Current_TVExplorer_TreeView
	If _GUICtrlTreeView_GetSelection($Treeview) = 0 Then Return
	If $Studiomodus = 2 Then Return
	Local $OwnerWindow = _WinAPI_GetAncestor($Treeview, $GA_PARENT)
	If _GUICtrlTVExplorer_GetSelected($Treeview) = $Offenes_Projekt Then Return
	$file = _GUICtrlTVExplorer_GetSelected($Treeview)

	;If it´s a favorite, then resolve lnk
	Local $FavoritesPath = _ISN_Variablen_aufloesen($FavoritesSubfolder)
	If StringRight($file, 4) = ".lnk" And StringInStr($file, $FavoritesPath) Then
		$file = _ISN_Variablen_aufloesen(_ISN_Favorites_ShortGetCommentPath($file))
	EndIf

	$filename = StringTrimLeft($file, StringInStr($file, "\", 0, -1))
	If StringInStr(FileGetAttrib($file), "D") Then
		_Lock_Plugintabs("lock")
		If $Skin_is_used = "true" Then
			$line = _WinAPI_SaveFileDlg(_Get_langstr(146), "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}", "All (*.*)", 0, $filename, '', BitOR($OFN_PATHMUSTEXIST, $OFN_FILEMUSTEXIST, $OFN_HIDEREADONLY), $OFN_EX_NOPLACESBAR, 0, 0, $OwnerWindow)
		Else
			$line = FileSaveDialog(_Get_langstr(146), "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}", "All (*.*)", 18, $filename, $OwnerWindow)
		EndIf
		_Lock_Plugintabs("unlock")
		If $line = "" Then Return
		If @error > 0 Then Return
		;dircopy($file,$line,1)
		_FileOperationProgress($file & "\*.*", $line, 1, $FO_COPY, $FOF_SIMPLEPROGRESS + $FOF_NOCONFIRMATION)
		If @extended == 1 Then ;ERROR
			Return
		EndIf
	Else
		_Lock_Plugintabs("lock")
		If $Skin_is_used = "true" Then
			$line = _WinAPI_SaveFileDlg(_Get_langstr(73), "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}", "All (*.*)", 0, $filename, '', BitOR($OFN_PATHMUSTEXIST, $OFN_FILEMUSTEXIST, $OFN_HIDEREADONLY), $OFN_EX_NOPLACESBAR, 0, 0, $OwnerWindow)
		Else
			$line = FileSaveDialog(_Get_langstr(73), "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}", "All (*.*)", 18, $filename, $OwnerWindow)
		EndIf
		_Lock_Plugintabs("unlock")
		If $line = "" Then Return
		If @error > 0 Then Return
		;filecopy($file,$line,1)
		$line = StringTrimRight($line, StringLen($line) - StringInStr($line, "\", 0, -1))
		_FileOperationProgress($file, $line, 1, $FO_COPY, $FOF_SIMPLEPROGRESS + $FOF_NOCONFIRMATION)
		If @extended == 1 Then ;ERROR
			Return
		EndIf

	EndIf
	_Write_log($filename & " " & _Get_langstr(147))
	MsgBox(262144 + 64, _Get_langstr(61), _Get_langstr(164), 0, $OwnerWindow)
	FileChangeDir(@ScriptDir)
EndFunc   ;==>_Export_File

Func _Add_File_to_Backuplist($str = "")
	If $str = "" Then Return "0"
	_ArraySearch($FilesToBackup_Array, $str)
	If @error Then ;Path is not found...let´s add them
		_ArrayAdd($FilesToBackup_Array, $str)
		Return "1"
	EndIf
	Return "0"
EndFunc   ;==>_Add_File_to_Backuplist

Func _ISN_Reset_Backuplist()
	$FilesToBackup_Array = $Leeres_Array
EndFunc   ;==>_ISN_Reset_Backuplist


Func _Backup_Files()
	If $Offenes_Projekt = "" Then Return
	If $Can_open_new_tab = 0 And $Regel_lauft = 0 Then Return
	If _Pruefe_auf_Type3_Plugin($Plugin_Platzhalter_BackupErstellen) <> -1 Then Return ;Platzhalter für Plugin

	_Write_ISN_Debug_Console("Backup function initiated!", $ISN_Debug_Console_Errorlevel_Info, $ISN_Debug_Console_Linebreak, $ISN_Debug_Console_Insert_Time, $ISN_Debug_Console_Insert_Title)
	_Write_log(_Get_langstr(122), "368DB6")

	If Not IsArray($FilesToBackup_Array) Then Return
	GUISetCursor(1, 0, $studiofenster)
	Local $Ordnerstruktur = ""
	$Ordnerstruktur = $Autobackup_Ordnerstruktur
	$Anzahl_Dateien = 0

	If $backupmode = 1 Then
		$Ordnerstruktur = _ISN_Variablen_aufloesen($Ordnerstruktur)
		$Desfolder = _ISN_Variablen_aufloesen($Backupfolder & "\" & $Ordnerstruktur & "\*.*")
		If Not FileExists(_ISN_Variablen_aufloesen($Backupfolder)) Then
			If DirCreate(_ISN_Variablen_aufloesen($Backupfolder)) = 0 Then
				_Write_ISN_Debug_Console("|--> ERROR: Backupfolder not found! (" & _ISN_Variablen_aufloesen($Backupfolder) & ")", $ISN_Debug_Console_Errorlevel_Critical, $ISN_Debug_Console_Linebreak, $ISN_Debug_Console_Insert_Time, $ISN_Debug_Console_Insert_Title)
				MsgBox(262144 + 16, _Get_langstr(206) & " - " & _Get_langstr(25), _ISN_Variablen_aufloesen($Backupfolder) & " " & _Get_langstr(332), 0, $Studiofenster)
				Return
			EndIf
		EndIf
	EndIf
	If $backupmode = 2 Then
		$Ordnerstruktur = StringReplace($Ordnerstruktur, "%projectname%", "")
		If StringLeft($Ordnerstruktur, 1) = "\" Then $Ordnerstruktur = StringTrimLeft($Ordnerstruktur, 1)
		$Desfolder = $Offenes_Projekt & "\" & $Backupfolder & "\" & _ISN_Variablen_aufloesen($Ordnerstruktur) & "\*.*"
	EndIf

	For $cnt = 0 To UBound($FilesToBackup_Array) - 1
		If Not FileExists($FilesToBackup_Array[$cnt]) Then ContinueLoop
		_Write_ISN_Debug_Console("|--> Backup file", $ISN_Debug_Console_Errorlevel_Info, $ISN_Debug_Console_Linebreak, $ISN_Debug_Console_Insert_Time, $ISN_Debug_Console_Insert_Title)
		_Write_ISN_Debug_Console("|--> FROM: " & $FilesToBackup_Array[$cnt], $ISN_Debug_Console_Errorlevel_Info, $ISN_Debug_Console_Linebreak, $ISN_Debug_Console_Insert_Time, $ISN_Debug_Console_Insert_Title)
		_Write_ISN_Debug_Console("|--> TO: " & $Desfolder, $ISN_Debug_Console_Errorlevel_Info, $ISN_Debug_Console_Linebreak, $ISN_Debug_Console_Insert_Time, $ISN_Debug_Console_Insert_Title)
		_Write_ISN_Debug_Console("|--> RESULT:", $ISN_Debug_Console_Errorlevel_Info, $ISN_Debug_Console_No_Linebreak, $ISN_Debug_Console_Insert_Time, $ISN_Debug_Console_Insert_Title)
		If FileCopy($FilesToBackup_Array[$cnt], $Desfolder, 9) Then
			$Anzahl_Dateien = $Anzahl_Dateien + 1
			_Write_ISN_Debug_Console("OK", $ISN_Debug_Console_Errorlevel_Info, $ISN_Debug_Console_Linebreak, $ISN_Debug_Console_No_Time, $ISN_Debug_Console_No_Title)
		Else
			_Write_ISN_Debug_Console("ERROR", $ISN_Debug_Console_Errorlevel_Critical, $ISN_Debug_Console_Linebreak, $ISN_Debug_Console_No_Time, $ISN_Debug_Console_No_Title)
		EndIf
	Next

	FileSetTime($Desfolder, @YEAR & @MON & @MDAY & @HOUR & @MIN & @SEC, 0, 1) ;Aktualisiere Zeitstempel der neuen Dateien
	If $enabledeleteoldbackups = "true" Then
		_Write_ISN_Debug_Console("|--> Removing Backups older than " & $deleteoldbackupsafter & " days...", $ISN_Debug_Console_Errorlevel_Info, $ISN_Debug_Console_No_Linebreak, $ISN_Debug_Console_Insert_Time, $ISN_Debug_Console_Insert_Title)
		If $backupmode = 1 Then
			_FileDeleteAfterXDays(_ISN_Variablen_aufloesen($Backupfolder & "\"), $deleteoldbackupsafter, True, True, True, False)
		EndIf
		If $backupmode = 2 Then _FileDeleteAfterXDays($Offenes_Projekt & "\" & $Backupfolder & "\", $deleteoldbackupsafter, True, True, True, False)
		_Write_ISN_Debug_Console("OK", $ISN_Debug_Console_Errorlevel_Info, $ISN_Debug_Console_Linebreak, $ISN_Debug_Console_No_Time, $ISN_Debug_Console_No_Title)
	EndIf
	GUISetCursor(2, 0, $StudioFenster)
	_Write_log(StringReplace(_Get_langstr(899), "%1", $Anzahl_Dateien), "368DB6")
	_Write_ISN_Debug_Console("|--> Backup function finished! (" & $Anzahl_Dateien & " file(s) copied)", $ISN_Debug_Console_Errorlevel_Info, $ISN_Debug_Console_Linebreak, $ISN_Debug_Console_Insert_Time, $ISN_Debug_Console_Insert_Title)
EndFunc   ;==>_Backup_Files



Func _Rename_Project()
	If $Templatemode = 1 Then Return
	If $Tempmode = 1 Then Return
	$i = MsgBox(262144 + 48 + 4, _Get_langstr(61), _Get_langstr(227), 0, $Projekteinstellungen_GUI)
	If $i = 6 Then
		$var = InputBox(_Get_langstr(226), _Get_langstr(226), IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "name", ""), "", 200 * $DPI, 150 * $DPI, Default, Default, -1, $Projekteinstellungen_GUI)
		If $var = "" Then Return
		If $var = IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "name", "") Then Return
		If @error Then Return
		$var = StringReplace($var, "|", "")
		$var = StringReplace($var, "?", "")
		$var = StringReplace($var, "*", "")
		$var = StringReplace($var, "\", "")
		$var = StringReplace($var, "/", "")
		$var = StringReplace($var, '"', "")
		$var = StringReplace($var, "'", "")
		If $var = "" Then Return
		IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "name", $var)
		$var2 = MsgBox(262144 + 32 + 4, _Get_langstr(48), _Get_langstr(804), 0, $Projekteinstellungen_GUI)

		$Offenes_Projekt_backup = $Offenes_Projekt
		$Offenes_Projekt_Ordner = StringTrimRight($Offenes_Projekt, StringLen($Offenes_Projekt) - StringInStr($Offenes_Projekt, "\", 0, -1))
		_Hide_projectproperties()
		_Close_Project("false")
		If $var2 = 6 Then
			;Projektordner umbenennen
			If FileExists($Offenes_Projekt_Ordner & $var) Then
				If $Offenes_Projekt_Ordner & $var <> $Offenes_Projekt_backup Then MsgBox(262144 + 48, _Get_langstr(25), _Get_langstr(805), 0, $Studiofenster)
			Else
				DirMove($Offenes_Projekt_backup, $Offenes_Projekt_Ordner & $var, 0)
				$Offenes_Projekt_backup = $Offenes_Projekt_Ordner & $var
			EndIf
		EndIf
		_Load_Project_by_Foldername($Offenes_Projekt_backup)
		MsgBox(262144 + 64, _Get_langstr(61), _Get_langstr(392), 0, $Studiofenster)
	EndIf
EndFunc   ;==>_Rename_Project

Func _Rename_Author()
	$var = InputBox(_Get_langstr(229), _Get_langstr(229), IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "author", ""), "", 200 * $DPI, 150 * $DPI, Default, Default, -1, $Projekteinstellungen_GUI)
	If @error = 0 Then
		If $var = IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "author", "") Then Return
		IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "author", $var)
		MsgBox(262144 + 64, _Get_langstr(61), _Get_langstr(230), 0, $Projekteinstellungen_GUI)
		_Zeige_Projekteinstellungen("projectproperties")
	EndIf
EndFunc   ;==>_Rename_Author

Func _Rename_Comment()
	$var = InputBox(_Get_langstr(231), _Get_langstr(231), IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "comment", ""), "", 200 * $DPI, 150 * $DPI, Default, Default, -1, $Projekteinstellungen_GUI)
	If @error = 0 Then
		If $var = IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "comment", "") Then Return
		IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "comment", $var)
		MsgBox(262144 + 64, _Get_langstr(61), _Get_langstr(232), 0, $Projekteinstellungen_GUI)
		_Zeige_Projekteinstellungen("projectproperties")
	EndIf

EndFunc   ;==>_Rename_Comment

Func _chance_Version()
	$var = InputBox(_Get_langstr(233), _Get_langstr(233), IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "version", ""), "", 200 * $DPI, 150 * $DPI, Default, Default, -1, $Projekteinstellungen_GUI)
	If @error = 0 Then
		If $var = IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "version", "") Then Return
		IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "version", $var)
		MsgBox(262144 + 64, _Get_langstr(61), _Get_langstr(234), 0, $Projekteinstellungen_GUI)
		_Zeige_Projekteinstellungen("projectproperties")
	EndIf
EndFunc   ;==>_chance_Version

Func _Hide_projectproperties()
	GUISetState(@SW_ENABLE, $StudioFenster)
	GUISetState(@SW_HIDE, $Projekteinstellungen_GUI)
EndFunc   ;==>_Hide_projectproperties



Func _Projekt_timer_Pausieren()
	If $Projekt_Timer_pausiert = 1 Then Return ;Bereits pausiert
	If $Offenes_Projekt = "" Then Return
	If $Studiomodus = 2 Then Return
	If $Templatemode = 1 Then Return
	_Write_ISN_Debug_Console("Project timer for the project '" & $Offenes_Projekt_name & "' changed status to paused.", 1)
;~ ConsoleWrite("Timer pausiert!"&@crlf)
	$Pause_time = $Pause_time + Int(TimerDiff($Project_timer))
	$Projekt_Timer_pausiert = 1
	_GUICtrlStatusBar_SetIcon($Status_bar, 1, _WinAPI_ShellExtractIcon($smallIconsdll, 913, 16, 16))
EndFunc   ;==>_Projekt_timer_Pausieren

Func _Projekt_Timer_fortsetzen()
	If $Projekt_Timer_pausiert = 0 Then Return ;Läuft bereits
	If $Offenes_Projekt = "" Then Return
	If $Studiomodus = 2 Then Return
	If $Templatemode = 1 Then Return
	_Write_ISN_Debug_Console("Project timer for the project '" & $Offenes_Projekt_name & "' changed status to resumed.", 1)
;~ ConsoleWrite("Timer gestartet!"&@crlf)
	$Project_timer = TimerInit()
	$Projekt_Timer_pausiert = 0
	_GUICtrlStatusBar_SetIcon($Status_bar, 1, _WinAPI_ShellExtractIcon($smallIconsdll, 911, 16, 16))
	_ISN_SetFocusToLastUsedScintillaControl()
EndFunc   ;==>_Projekt_Timer_fortsetzen


Func _stop_Project_timer()
	Local $timer, $Secs, $Mins, $Hour, $time
	Local $timer1, $Secs1, $Mins1, $Hour1, $Time1
	Local $timer2, $Secs2, $Mins2, $Hour2, $Time2
	If $Offenes_Projekt = "" Then Return
	If $Studiomodus = 2 Then Return
	If $Templatemode = 1 Then Return
	$dif = TimerDiff($Project_timer)
	$dif = Int($dif)
	$time = $dif + $Pause_time + IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "time", 0)
	_TicksToTime(IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "time", 0), $Hour, $Mins, $Secs)
	_TicksToTime($dif + $Pause_time, $Hour1, $Mins1, $Secs1)
	_TicksToTime($time, $Hour2, $Mins2, $Secs2)
	_Write_ISN_Debug_Console("Project timer for the project '" & $Offenes_Projekt_name & "' stopped.", 1)
;~ 	msgbox(0,"info","Timer Stopped!"&@crlf&"Alte Zeit: "&$Hour&"h "&$Mins&"m "&$Secs&" s ("&iniread($Offenes_Projekt&"\project.isn","ISNAUTOITSTUDIO","time","0")&")"&@crlf&"Vergangene Zeit:"&$Hour1&"h "&$Mins1&"m "&$Secs1&"s ("&$dif&")"&@crlf&"Neue Zeit:"&$Hour2&"h "&$Mins2&"m "&$Secs2&"s ("&$time&")")
	IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "time", $time)
	_GUICtrlStatusBar_SetIcon($Status_bar, 1, _WinAPI_ShellExtractIcon($smallIconsdll, 913, 16, 16))
	Return $dif + $Pause_time ;Rückgabe der aktuell benötigten Zeit (seit das Projekt geöffnet wurde)
EndFunc   ;==>_stop_Project_timer

Func _Start_Project_timer()
	If $Studiomodus = 2 Then Return
	If $Templatemode = 1 Then Return
	Local $timer, $Secs, $Mins, $Hour, $time
	$time = IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "time", 0)
	_TicksToTime($time, $Hour, $Mins, $Secs)
	If $Hour > 9 Then _Earn_trophy(10, 3)
	If $Hour > 0 Or $Mins > 29 Then _Earn_trophy(6, 1)
	$Pause_time = 0 ;Pause Timer zurücksetzen
	$Project_timer = TimerInit()
	_Write_ISN_Debug_Console("Project timer for the project '" & $Offenes_Projekt_name & "' started.", 1)
	_GUICtrlStatusBar_SetIcon($Status_bar, 1, _WinAPI_ShellExtractIcon($smallIconsdll, 911, 16, 16))
EndFunc   ;==>_Start_Project_timer

Func _topSec()
	$Geheimcount = $Geheimcount + 1
	If $Geheimcount > 2 Then _Earn_trophy(11, 3)
EndFunc   ;==>_topSec

Func _Load_Languages()
	GUICtrlSetData($Combo_Sprachen[0], "", "")
	$Search = FileFindFirstFile(@ScriptDir & "\data\language\*.lng")
	If $Search = -1 Then
		GUICtrlSetData($Combo_Sprachen[0], "", "ERROR")
		FileClose($Search)
		Return
	EndIf
	$filetypes = ""
	$i = 1
	While 1
		$file = FileFindNextFile($Search)
		If @error Then ExitLoop
		If $file = "." Or $file = ".." Then ContinueLoop
		$filetypes = $filetypes & _IniReadEx(@ScriptDir & "\data\language\" & $file, "ISNAUTOITSTUDIO", "language", "ERROR") & "|"
		$Combo_Sprachen[$i] = $file
		$i = $i + 1
	WEnd
	FileClose($Search)
	GUICtrlSetData($Combo_Sprachen[0], $filetypes, _IniReadEx(@ScriptDir & "\data\language\" & $Languagefile, "ISNAUTOITSTUDIO", "language", "ERROR"))
	GUICtrlSetData($langchooser, $filetypes, _IniReadEx(@ScriptDir & "\data\language\" & $Languagefile, "ISNAUTOITSTUDIO", "language", "ERROR"))

EndFunc   ;==>_Load_Languages

Func _Select_Language()
	GUICtrlSetData($Sprachen_Label_Version, _Get_langstr(619) & " " & _IniReadEx(@ScriptDir & "\data\language\" & $Combo_Sprachen[_GUICtrlComboBox_GetCurSel($Combo_Sprachen[0]) + 1], "ISNAUTOITSTUDIO", "version", ""))
	GUICtrlSetData($Sprachen_Label_Kommentar, _Get_langstr(133) & " " & _IniReadEx(@ScriptDir & "\data\language\" & $Combo_Sprachen[_GUICtrlComboBox_GetCurSel($Combo_Sprachen[0]) + 1], "ISNAUTOITSTUDIO", "comment", ""))
	GUICtrlSetData($Sprachen_Label_Author, _Get_langstr(132) & " " & _IniReadEx(@ScriptDir & "\data\language\" & $Combo_Sprachen[_GUICtrlComboBox_GetCurSel($Combo_Sprachen[0]) + 1], "ISNAUTOITSTUDIO", "author", ""))
EndFunc   ;==>_Select_Language


;********************************************************************************
;Recursive search for filemask
;********************************************************************************

Func _GetFileList($T_DIR, $T_MASK)
	Dim $N_DIRNAMES[200000] ; max number of directories that can be scanned
	Local $N_DIRCOUNT = 0
	Local $N_FILE
	Local $N_SEARCH
	Local $N_TFILE
	Local $N_OFILE
	Local $T_FILENAMES
	Local $T_FILECOUNT
	Local $T_DIRCOUNT = 1
	; remove the end \ If specified
	If StringRight($T_DIR, 1) = "\" Then $T_DIR = StringTrimRight($T_DIR, 1)
	$N_DIRNAMES[$T_DIRCOUNT] = $T_DIR
	; Exit if base dir doesn't exists
	If Not FileExists($T_DIR) Then Return 0
	; keep on looping until all directories are scanned
	While $T_DIRCOUNT > $N_DIRCOUNT
		$N_DIRCOUNT = $N_DIRCOUNT + 1
		; find all subdirs in this directory and save them in a array
		$N_SEARCH = FileFindFirstFile($N_DIRNAMES[$N_DIRCOUNT] & "\*.*")
		While 1
			$N_FILE = FileFindNextFile($N_SEARCH)
			If @error Then ExitLoop
			; skip these references
			If $N_FILE = "." Or $N_FILE = ".." Then ContinueLoop
			$N_TFILE = $N_DIRNAMES[$N_DIRCOUNT] & "\" & $N_FILE
			; if Directory than add to the list of directories to be processed
			If StringInStr(FileGetAttrib($N_TFILE), "D") > 0 Then
				$T_DIRCOUNT = $T_DIRCOUNT + 1
				$N_DIRNAMES[$T_DIRCOUNT] = $N_TFILE
			EndIf
		WEnd
		FileClose($N_SEARCH)
		; find all Files that mtach the MASK
		$N_SEARCH = FileFindFirstFile($N_DIRNAMES[$N_DIRCOUNT] & "\" & $T_MASK)
		If $N_SEARCH = -1 Then ContinueLoop
		While 1
			$N_FILE = FileFindNextFile($N_SEARCH)
			If @error Then ExitLoop
			; skip these references
			If $N_FILE = "." Or $N_FILE = ".." Then ContinueLoop
			$N_TFILE = $N_DIRNAMES[$N_DIRCOUNT] & "\" & $N_FILE
			; if Directory than add to the list of directories to be processed
			If StringInStr(FileGetAttrib($N_TFILE), "D") = 0 Then
				$T_FILENAMES = $T_FILENAMES & $N_TFILE & @CR
				$T_FILECOUNT = $T_FILECOUNT + 1
				;MsgBox(0,'filecount ' & $T_FILECOUNT ,$N_TFILE)
			EndIf
		WEnd
		FileClose($N_SEARCH)
	WEnd
	$T_FILENAMES = StringTrimRight($T_FILENAMES, 1)
	$N_OFILE = StringSplit($T_FILENAMES, @CR)
	Return ($N_OFILE)
EndFunc   ;==>_GetFileList



Func _ISN_ShowCreateNewShortcutGUI($FilePath = "")

	If $FilePath = "" Then
		If $Studiomodus = "1" Then
			GUICtrlSetData($NewShortcutGUI_FolderPath_Input, "%ProjectDir%")
		Else
			Local $TreeviewFile = _GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView)
			If Not FileExists($TreeviewFile) Then $TreeviewFile = "C:\"
			Local $FileAttributes = FileGetAttrib($TreeviewFile)
			If StringInStr($FileAttributes, "D") Then
				GUICtrlSetData($NewShortcutGUI_FolderPath_Input, _ISN_Pfad_durch_Variablen_ersetzen($TreeviewFile))
			Else
				GUICtrlSetData($NewShortcutGUI_FolderPath_Input, _ISN_Pfad_durch_Variablen_ersetzen(_WinAPI_PathRemoveFileSpec($TreeviewFile)))
			EndIf
		EndIf
	Else
		If Not FileExists($FilePath) Then $FilePath = "%ProjectDir%"
		Local $FileAttributes = FileGetAttrib($FilePath)
		If StringInStr($FileAttributes, "D") Then
			GUICtrlSetData($NewShortcutGUI_FolderPath_Input, _ISN_Pfad_durch_Variablen_ersetzen($FilePath))
		Else
			GUICtrlSetData($NewShortcutGUI_FolderPath_Input, _ISN_Pfad_durch_Variablen_ersetzen(_WinAPI_PathRemoveFileSpec($FilePath)))
		EndIf
	EndIf

	GUICtrlSetData($NewShortcutGUI_LinkTo_Input, "")
	GUICtrlSetData($NewShortcutGUI_ShortcutName_Input, "")
	GUICtrlSetState($NewShortcutGUI_LinkTo_Input, $GUI_FOCUS)

	;Set the owner of the last used treeview as parnet for the GUI
	$OwnerWindow = _WinAPI_GetAncestor($Current_TVExplorer_TreeView, $GA_PARENT)
	_WinAPI_SetWindowLong($NewShortcutGUI, $GWL_HWNDPARENT, $OwnerWindow)

	GUISetState(@SW_SHOW, $NewShortcutGUI)
	GUISetState(@SW_DISABLE, $OwnerWindow)
	GUISetState(@SW_DISABLE, $Studiofenster)
EndFunc

Func _ISN_HideNewShortcutGUI()
	;Set the owner of the last used treeview as parnet for the GUI
	$OwnerWindow = _WinAPI_GetAncestor($Current_TVExplorer_TreeView, $GA_PARENT)

	GUISetState(@SW_ENABLE, $OwnerWindow)
	GUISetState(@SW_ENABLE, $StudioFenster)
	GUISetState(@SW_HIDE, $NewShortcutGUI)
EndFunc  
	
Func _ISN_NewShortcutGUI_OK()

	If GUICtrlRead($NewShortcutGUI_FolderPath_Input) = "" Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1411), 0, $NewShortcutGUI)
		_Input_Error_FX($NewShortcutGUI_FolderPath_Input)
		Return
	EndIf

	If GUICtrlRead($NewShortcutGUI_LinkTo_Input) = "" OR NOT FileExists(GUICtrlRead($NewShortcutGUI_LinkTo_Input)) OR _IsDir(GUICtrlRead($NewShortcutGUI_LinkTo_Input)) Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1562), 0, $NewShortcutGUI)
		_Input_Error_FX($NewShortcutGUI_LinkTo_Input)
		Return
	EndIf
	
	
	Local $Filename = GUICtrlRead($NewShortcutGUI_ShortcutName_Input)
	Local $FolderPath = _ISN_Variablen_aufloesen(GUICtrlRead($NewShortcutGUI_FolderPath_Input))
	Local $LinkToPath = GUICtrlRead($NewShortcutGUI_LinkTo_Input)

	;Filter umlauts
	$Filename = StringReplace($Filename, "\", "")
	$Filename = StringReplace($Filename, "/", "")
	$Filename = StringReplace($Filename, "?", "")
	$Filename = StringReplace($Filename, "*", "")
	$Filename = StringReplace($Filename, "|", "")
	$Filename = StringReplace($Filename, ":", "")
	$Filename = StringReplace($Filename, "<", "")
	$Filename = StringReplace($Filename, ">", "")
	$Filename = StringReplace($Filename, "'", "")
	$Filename = StringReplace($Filename, '"', "")
	GUICtrlSetData($NewShortcutGUI_ShortcutName_Input, $Filename)

	If GUICtrlRead($NewShortcutGUI_ShortcutName_Input) = "" Then
		_Input_Error_FX($NewShortcutGUI_ShortcutName_Input)
		Return
	EndIf

	;Check, if the folder already exists
	If FileExists($FolderPath & "\" & $Filename) Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1409), 0, $NewShortcutGUI)
		Return
	EndIf

	_ISN_HideNewShortcutGUI()

	If FileCreateShortcut ($LinkToPath, $FolderPath & "\" & $Filename& ".lnk") = 0 Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1331), 0, $StudioFenster)
		Return
	EndIf

	_Write_log(_Get_langstr(1563) & " (" & _ISN_Pfad_durch_Variablen_ersetzen($FolderPath & "\" & $Filename& ".lnk") & ")")
	$Porjecttree_FileToSelect_after_Update = $FolderPath & "\" & $Filename & ".lnk" ;Select new shortcut in Treeview
	If $Studiomodus = "2" Then AdlibRegister("_Update_Treeview")

EndFunc 

Func _ISN_NewShortcutGUI_BrowseFolder()
	Local $SelectedFolder
	Local $ImportTo_Root = _GUICtrlTVExplorer_GetRootPath($Current_TVExplorer_TreeView)
	$PauseRDCEvents = 1
	$SelectedFolder = _WinAPI_BrowseForFolderDlg($ImportTo_Root, _Get_langstr(160), $BIF_NEWDIALOGSTYLE + $BIF_RETURNONLYFSDIRS, 0, 0, $NewShortcutGUI)
	If @error Or $SelectedFolder = "" Then
		$PauseRDCEvents = 0
		Return
	Else
		$PauseRDCEvents = 0
		GUICtrlSetData($NewShortcutGUI_FolderPath_Input, _ISN_Pfad_durch_Variablen_ersetzen($SelectedFolder))
	EndIf

EndFunc 
	
Func _ISN_NewShortcutGUI_BrowseTargetFile()
	If $Skin_is_used = "true" Then
		$var = _WinAPI_OpenFileDlg(_Get_langstr(57), "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}", _Get_langstr(58) & " (*.*)", 0, '', '', BitOR($OFN_PATHMUSTEXIST, $OFN_FILEMUSTEXIST, $OFN_HIDEREADONLY, $OFN_EXPLORER, $OFN_DONTADDTORECENT), $OFN_EX_NOPLACESBAR, 0, 0, $StudioFenster)
	Else
		$var = FileOpenDialog(_Get_langstr(57), "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}", _Get_langstr(58) & " (*.*)", 1 + 2 + 4, "", $StudioFenster)
	EndIf
	if $var = "" or @error then return
	Local $Filename = StringTrimLeft($var, StringInStr($var, "\", 0, -1))
	GUICtrlSetData($NewShortcutGUI_ShortcutName_Input, $Filename)
	GUICtrlSetData($NewShortcutGUI_LinkTo_Input, $var)
EndFunc 
		
	
	

Func _ISN_HideNewFolderGUI()
	;Set the owner of the last used treeview as parnet for the newfolderGUI
	$OwnerWindow = _WinAPI_GetAncestor($Current_TVExplorer_TreeView, $GA_PARENT)

	GUISetState(@SW_ENABLE, $OwnerWindow)
	GUISetState(@SW_ENABLE, $StudioFenster)
	GUISetState(@SW_HIDE, $NewFolderGUI)
EndFunc   ;==>_ISN_HideNewFolderGUI


Func _ISN_ShowNewFolderGUI($FilePath = "")

	If $FilePath = "" Then
		If $Studiomodus = "1" Then
			GUICtrlSetData($NewFolderGUI_FolderPath_Input, "%ProjectDir%")
		Else
			Local $TreeviewFile = _GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView)
			If Not FileExists($TreeviewFile) Then $TreeviewFile = "C:\"
			Local $FileAttributes = FileGetAttrib($TreeviewFile)
			If StringInStr($FileAttributes, "D") Then
				GUICtrlSetData($NewFolderGUI_FolderPath_Input, _ISN_Pfad_durch_Variablen_ersetzen($TreeviewFile))
			Else
				GUICtrlSetData($NewFolderGUI_FolderPath_Input, _ISN_Pfad_durch_Variablen_ersetzen(_WinAPI_PathRemoveFileSpec($TreeviewFile)))
			EndIf
		EndIf
	Else
		If Not FileExists($FilePath) Then $FilePath = "%ProjectDir%"
		Local $FileAttributes = FileGetAttrib($FilePath)
		If StringInStr($FileAttributes, "D") Then
			GUICtrlSetData($NewFolderGUI_FolderPath_Input, _ISN_Pfad_durch_Variablen_ersetzen($FilePath))
		Else
			GUICtrlSetData($NewFolderGUI_FolderPath_Input, _ISN_Pfad_durch_Variablen_ersetzen(_WinAPI_PathRemoveFileSpec($FilePath)))
		EndIf
	EndIf

	GUICtrlSetData($NewFolderGUI_FolderName_Input, "")
	GUICtrlSetState($NewFolderGUI_FolderName_Input, $GUI_FOCUS)

	;Set the owner of the last used treeview as parnet for the newfolderGUI
	$OwnerWindow = _WinAPI_GetAncestor($Current_TVExplorer_TreeView, $GA_PARENT)
	_WinAPI_SetWindowLong($NewFolderGUI, $GWL_HWNDPARENT, $OwnerWindow)

	GUISetState(@SW_SHOW, $NewFolderGUI)
	GUISetState(@SW_DISABLE, $OwnerWindow)
	GUISetState(@SW_DISABLE, $Studiofenster)
EndFunc   ;==>_ISN_ShowNewFolderGUI

Func _ISN_NewFolderGUI_OK()

	If GUICtrlRead($NewFolderGUI_FolderPath_Input) = "" Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1411), 0, $NewFolderGUI)
		_Input_Error_FX($NewFolderGUI_FolderPath_Input)
		Return
	EndIf

	Local $Foldername = GUICtrlRead($NewFolderGUI_FolderName_Input)
	Local $FolderPath = _ISN_Variablen_aufloesen(GUICtrlRead($NewFolderGUI_FolderPath_Input))


	;Filter umlauts
	$Foldername = StringReplace($Foldername, "\", "")
	$Foldername = StringReplace($Foldername, "/", "")
	$Foldername = StringReplace($Foldername, "?", "")
	$Foldername = StringReplace($Foldername, "*", "")
	$Foldername = StringReplace($Foldername, "|", "")
	$Foldername = StringReplace($Foldername, ":", "")
	$Foldername = StringReplace($Foldername, "<", "")
	$Foldername = StringReplace($Foldername, ">", "")
	$Foldername = StringReplace($Foldername, "'", "")
	$Foldername = StringReplace($Foldername, '"', "")
	GUICtrlSetData($NewFolderGUI_FolderName_Input, $Foldername)

	If GUICtrlRead($NewFolderGUI_FolderName_Input) = "" Then
		_Input_Error_FX($NewFolderGUI_FolderName_Input)
		Return
	EndIf

	;Check, if the folder already exists
	If FileExists($FolderPath & "\" & $Foldername) Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1409), 0, $NewFolderGUI)
		Return
	EndIf

	_ISN_HideNewFolderGUI()

	If DirCreate($FolderPath & "\" & $Foldername) = 0 Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1331), 0, $StudioFenster)
		Return
	EndIf

	_Write_log(_Get_langstr(150) & " (" & _ISN_Pfad_durch_Variablen_ersetzen($FolderPath & "\" & $Foldername) & ")")
	$Porjecttree_FileToSelect_after_Update = $FolderPath & "\" & $Foldername ;Select new folder. in Treeview
	If $Studiomodus = "2" Then AdlibRegister("_Update_Treeview")

EndFunc   ;==>_ISN_NewFolderGUI_OK


Func _ISN_NewFolderGUI_BrowseFolder()
	Local $SelectedFolder
	Local $ImportTo_Root = _GUICtrlTVExplorer_GetRootPath($Current_TVExplorer_TreeView)
	$PauseRDCEvents = 1
	$SelectedFolder = _WinAPI_BrowseForFolderDlg($ImportTo_Root, _Get_langstr(160), $BIF_NEWDIALOGSTYLE + $BIF_RETURNONLYFSDIRS, 0, 0, $NewFolderGUI)
	If @error Or $SelectedFolder = "" Then
		$PauseRDCEvents = 0
		Return
	Else
		$PauseRDCEvents = 0
		GUICtrlSetData($NewFolderGUI_FolderPath_Input, _ISN_Pfad_durch_Variablen_ersetzen($SelectedFolder))
	EndIf

EndFunc   ;==>_ISN_NewFolderGUI_BrowseFolder

Func _ISN_NewFileGUI_BrowseFolder()
	Local $SelectedFolder
	Local $ImportTo_Root = _GUICtrlTVExplorer_GetRootPath($Current_TVExplorer_TreeView)
	$PauseRDCEvents = 1
	$SelectedFolder = _WinAPI_BrowseForFolderDlg($ImportTo_Root, _Get_langstr(160), $BIF_NEWDIALOGSTYLE + $BIF_RETURNONLYFSDIRS, 0, 0, $New_file_GUI)
	If @error Or $SelectedFolder = "" Then
		$PauseRDCEvents = 0
		Return
	Else
		$PauseRDCEvents = 0
		GUICtrlSetData($newfile_folderpath, _ISN_Pfad_durch_Variablen_ersetzen($SelectedFolder))
	EndIf

EndFunc   ;==>_ISN_NewFileGUI_BrowseFolder


Func _Make_New_File()
	If GUICtrlRead($newfile_filename) = "" Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(159), 0, $New_file_GUI)
		_Input_Error_FX($newfile_filename)
		Return
	EndIf

	If GUICtrlRead($neue_datei_vorlagen_datei_combo) = "" And GUICtrlRead($neue_datei_radio2) = $GUI_CHECKED Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(746), 0, $New_file_GUI)
		_Input_Error_FX($neue_datei_vorlagen_datei_combo)
		Return
	EndIf

	If GUICtrlRead($newfile_folderpath) = "" Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1411), 0, $New_file_GUI)
		_Input_Error_FX($newfile_folderpath)
		Return
	EndIf

	;Filter Umlauts and prepare Paths
	Local $NewFileName = GUICtrlRead($newfile_filename)
	$NewFileName = _Umlaute_Filtern($NewFileName)
	If StringRight($NewFileName, 4) = GUICtrlRead($combo_fileformat) Then $NewFileName = StringTrimRight($NewFileName, 4)
	GUICtrlSetData($newfile_filename, $NewFileName)


	Local $NewFileFullPath = _ISN_Variablen_aufloesen(GUICtrlRead($newfile_folderpath))
	If Not _WinAPI_PathIsRoot($newfile_folderpath) And StringRight($newfile_folderpath, 1) = "\" Then $NewFileFullPath = StringTrimRight($NewFileFullPath, 1)
	$NewFileFullPath = $NewFileFullPath & "\" & $NewFileName & GUICtrlRead($combo_fileformat)


	;Check, if the file already exists
	If FileExists($NewFileFullPath) Then
		$ExistsMsgResult = MsgBox(262144 + 48 + 4, _Get_langstr(394), StringReplace(_Get_langstr(1412), "%1", $NewFileFullPath), 0, $New_file_GUI)
		If @error Or $ExistsMsgResult = 7 Then Return
	EndIf


	;Set the owner of the last used treeview as parnet for the newfolderGUI
	$OwnerWindow = _WinAPI_GetAncestor($Current_TVExplorer_TreeView, $GA_PARENT)

	GUISetState(@SW_ENABLE, $OwnerWindow)
	GUISetState(@SW_ENABLE, $StudioFenster)
	GUISetState(@SW_HIDE, $New_file_GUI)



	Local $filename = $NewFileName & GUICtrlRead($combo_fileformat)

	If GUICtrlRead($neue_datei_radio1) = $GUI_CHECKED Then

		If $autoit_editor_encoding = "2" Then
			Local $file = FileOpen($NewFileFullPath, 2 + $FO_UTF8_NOBOM)
		Else
			Local $file = FileOpen($NewFileFullPath, 2)
		EndIf

		; Check if file opened for writing OK
		If $file = -1 Then
			FileClose($file)
			MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1331), 0, $StudioFenster)
			Return
		EndIf
		If GUICtrlRead($combo_newfile) = _Get_langstr(154) Then
			FileWriteLine($file, ";" & $filename)
		EndIf

		If GUICtrlRead($combo_newfile) = _Get_langstr(1452) Then
			Local $UDFTemplateRead = FileRead(@ScriptDir & "\Data\UDF_Template.au3")
			If $UDFTemplateRead <> "" And Not @error Then FileWriteLine($file, _ISN_Variablen_aufloesen($UDFTemplateRead, $NewFileFullPath, $filename))
		EndIf



		If GUICtrlRead($combo_newfile) = _Get_langstr(153) Then
			FileWriteLine($file, "#cs")
			FileWriteLine($file, "[gui]")
			FileWriteLine($file, "title=" & GUICtrlRead($newfile_filename))
			FileWriteLine($file, "breite=350")
			FileWriteLine($file, "hoehe=350")
			FileWriteLine($file, "style=-1")
			FileWriteLine($file, "exstyle=-1")
			FileWriteLine($file, "bgcolour=0xF0F0F0")
			FileWriteLine($file, "bgimage=none")
			FileWriteLine($file, "handle=" & StringReplace(GUICtrlRead($newfile_filename), " ", "_"))
			FileWriteLine($file, "#ce")
		EndIf

		FileWriteLine($file, "")
		FileClose($file)
	Else ;Datei aus vorlage
		If IsArray($neue_Datei_erstellen_Vorlagendatei_combo_ARRAY) Then
			If GUICtrlRead($combo_newfile) = _Get_langstr(154) Or GUICtrlRead($combo_newfile) = _Get_langstr(1452) Then
				Local $TemplateFileRead = FileRead($neue_Datei_erstellen_Vorlagendatei_combo_ARRAY[_GUICtrlComboBox_GetCurSel($neue_datei_vorlagen_datei_combo)])
				If $TemplateFileRead <> "" And Not @error Then
					;Alte Variablen (für Kompatibilität)
					$TemplateFileRead = StringReplace($TemplateFileRead, "$FILENAME", $filename)
					$TemplateFileRead = StringReplace($TemplateFileRead, "$AUTHOR", IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "author", ""))
					$TemplateFileRead = StringReplace($TemplateFileRead, "$PROGRAMMVERSION", $Studioversion)
					$TemplateFileRead = StringReplace($TemplateFileRead, "$STR30", _Get_langstr(30))
					$TemplateFileRead = StringReplace($TemplateFileRead, "$COMMENT", IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "comment", ""))

					;Neue Variablen
					$TemplateFileRead = _ISN_Variablen_aufloesen($TemplateFileRead, $NewFileFullPath, $filename)


					If FileWrite($NewFileFullPath, _ISN_Variablen_aufloesen($TemplateFileRead, $NewFileFullPath, $filename)) = 0 Then
						MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1331), 0, $StudioFenster)
						Return
					EndIf

				EndIf
			Else
				If FileCopy($neue_Datei_erstellen_Vorlagendatei_combo_ARRAY[_GUICtrlComboBox_GetCurSel($neue_datei_vorlagen_datei_combo)], $NewFileFullPath, 9) = 0 Then
					MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1331), 0, $StudioFenster)
					Return
				EndIf
			EndIf


		EndIf
	EndIf

	_Write_log(_ISN_Pfad_durch_Variablen_ersetzen($NewFileFullPath) & " " & _Get_langstr(161))

	If GUICtrlRead($new_file_include_checkbox) = $GUI_CHECKED Then _Include_IT($NewFileFullPath)
	Local $ISN_UDFManager_WinState = WinGetState($ISN_UDF_Manager_GUI, "")
	If BitAND($ISN_UDFManager_WinState, 2) Then _ISN_UDF_Manager_Inspect_UDF($NewFileFullPath)
	If GUICtrlRead($new_file_open_checkbox) = $GUI_CHECKED And Not BitAND($ISN_UDFManager_WinState, 2) Then Try_to_opten_file($NewFileFullPath)
	$Porjecttree_FileToSelect_after_Update = $NewFileFullPath ;Select new file in Treeview
	If $Studiomodus = "2" Then AdlibRegister("_Update_Treeview")




EndFunc   ;==>_Make_New_File

Func _Include_IT($FilePath = "")
	If $FilePath = "" Then Return
	If $Studiomodus = "2" Then Return
	$FilePath = _ISN_Variablen_aufloesen($FilePath)
	Try_to_opten_file($Offenes_Projekt & "\" & IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "mainfile", "#ERROR#"))
	Sleep(200)
	$wrapFind = False
	$pos = FindInTarget("#include", StringLen("#include"), SendMessage($SCE_EDITOR[_GUICtrlTab_GetCurFocus($htab)], $SCI_GETLENGTH, 0, 0), 0)
	If $pos = -1 Then $pos = SendMessage($SCE_EDITOR[_GUICtrlTab_GetCurFocus($htab)], $SCI_GETLENGTH, 0, 0)
	$line = Sci_GetLineFromPos($SCE_EDITOR[_GUICtrlTab_GetCurFocus($htab)], $pos) + 1
	$posFind = -1
	If $pos = -1 Then Return
	If _ISN_IsPathInAnManagedIncludeDirectory($FilePath) Then
		Sci_AddLines($SCE_EDITOR[_GUICtrlTab_GetCurFocus($htab)], '#include <' & _ISN_FileInManagedIncludeDirectory_TrimIncludeDir($FilePath) & '>' & @CRLF, $line + 1)
	Else
		Sci_AddLines($SCE_EDITOR[_GUICtrlTab_GetCurFocus($htab)], '#include "' & StringReplace($FilePath, _WinAPI_PathAddBackslash($Offenes_Projekt), "") & '"' & @CRLF, $line + 1)
	EndIf
EndFunc   ;==>_Include_IT

Func _Exclude_IT($file = "")
	If $file = "" Then Return
	Try_to_opten_file($Offenes_Projekt & "\" & IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "mainfile", "#ERROR#"))
	Sleep(200)

	For $x = 1 To Sci_GetLineCount($SCE_EDITOR[_GUICtrlTab_GetCurFocus($htab)])
		$Zeilentext = Sci_GetLine($SCE_EDITOR[_GUICtrlTab_GetCurFocus($htab)], $x)
		If StringInStr($Zeilentext, "#include") And StringInStr($Zeilentext, $file) Then
			$start = Sci_GetLineStartPos($SCE_EDITOR[_GUICtrlTab_GetCurFocus($htab)], $x)
			$end = Sci_GetLineEndPos($SCE_EDITOR[_GUICtrlTab_GetCurFocus($htab)], $x)
			Sci_SetSelection($SCE_EDITOR[_GUICtrlTab_GetCurFocus($htab)], $start, $end)
			SendMessageString($SCE_EDITOR[_GUICtrlTab_GetCurFocus($htab)], $SCI_REPLACESEL, 0, "")
			_Check_tabs_for_changes()
		EndIf
	Next
EndFunc   ;==>_Exclude_IT



Func _Show_New_Filegui($FilePath = "")

	If $FilePath = "" Then
		If $Studiomodus = "1" Then
			GUICtrlSetData($newfile_folderpath, "%ProjectDir%")
		Else
			Local $TreeviewFile = _GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView)
			If Not FileExists($TreeviewFile) Then $TreeviewFile = "C:\"
			Local $FileAttributes = FileGetAttrib($TreeviewFile)
			If StringInStr($FileAttributes, "D") Then
				GUICtrlSetData($newfile_folderpath, _ISN_Pfad_durch_Variablen_ersetzen($TreeviewFile))
			Else
				GUICtrlSetData($newfile_folderpath, _ISN_Pfad_durch_Variablen_ersetzen(_WinAPI_PathRemoveFileSpec($TreeviewFile)))
			EndIf
		EndIf
	Else
		If Not FileExists($FilePath) Then $FilePath = "%ProjectDir%"
		Local $FileAttributes = FileGetAttrib($FilePath)
		If StringInStr($FileAttributes, "D") Then
			GUICtrlSetData($newfile_folderpath, _ISN_Pfad_durch_Variablen_ersetzen($FilePath))
		Else
			GUICtrlSetData($newfile_folderpath, _ISN_Pfad_durch_Variablen_ersetzen(_WinAPI_PathRemoveFileSpec($FilePath)))
		EndIf
	EndIf

	GUICtrlSetData($newfile_filename, "")
	GUICtrlSetState($newfile_filename, $GUI_FOCUS)
	GUICtrlSetState($new_file_open_checkbox, $GUI_CHECKED)
	GUICtrlSetState($neue_datei_radio1, $GUI_CHECKED)
	_read_combo_new_file()
	_New_Filegui_Radio_event()

	;Set the owner of the last used treeview as parnet for the newfileGUI
	$OwnerWindow = _WinAPI_GetAncestor($Current_TVExplorer_TreeView, $GA_PARENT)
	_WinAPI_SetWindowLong($New_file_GUI, $GWL_HWNDPARENT, $OwnerWindow)

	GUISetState(@SW_DISABLE, $OwnerWindow)
	GUISetState(@SW_DISABLE, $StudioFenster)
	GUISetState(@SW_SHOW, $New_file_GUI)

EndFunc   ;==>_Show_New_Filegui

Func _New_Filegui_Radio_event()
	If GUICtrlRead($neue_datei_radio1) = $GUI_CHECKED Then
		GUICtrlSetState($neue_datei_radiolabel1, $GUI_DISABLE)
		GUICtrlSetState($neue_datei_radiolabel2, $GUI_DISABLE)
		GUICtrlSetState($neue_datei_vorlagen_combo, $GUI_DISABLE)
		GUICtrlSetState($neue_datei_vorlagen_datei_combo, $GUI_DISABLE)
		GUICtrlSetData($neue_datei_vorlagen_combo, "", "")
		GUICtrlSetData($neue_datei_vorlagen_datei_combo, "", "")
	Else
		GUICtrlSetState($neue_datei_radiolabel1, $GUI_ENABLE)
		GUICtrlSetState($neue_datei_radiolabel2, $GUI_ENABLE)
		GUICtrlSetState($neue_datei_vorlagen_combo, $GUI_ENABLE)
		GUICtrlSetState($neue_datei_vorlagen_datei_combo, $GUI_ENABLE)
		ScanforTemplates_Combo()
		_Show_New_Filegui_Scan_for_files()
	EndIf
EndFunc   ;==>_New_Filegui_Radio_event

Func _Show_New_Filegui_Scan_for_files()
	If GUICtrlRead($neue_datei_radio1) = $GUI_CHECKED Then Return
	Local $array
	Local $first_item
	Local $files_string
	$array = _GetFileList($new_projectvorlage_combo_ARRAY[_GUICtrlComboBox_GetCurSel($neue_datei_vorlagen_combo) + 1], "*" & GUICtrlRead($combo_fileformat))
	GUICtrlSetData($neue_datei_vorlagen_datei_combo, "", "")
	If Not IsArray($array) Then Return
	$files_string = ""
	$first_item = ""
	_ArrayDelete($array, 0)
	For $x = 0 To UBound($array) - 1
		If $x = 0 Then $first_item = StringTrimLeft($array[$x], StringInStr($array[$x], "\", 0, -1))
		$files_string = $files_string & StringTrimLeft($array[$x], StringInStr($array[$x], "\", 0, -1)) & "|"
	Next
	$neue_Datei_erstellen_Vorlagendatei_combo_ARRAY = $array
	GUICtrlSetData($neue_datei_vorlagen_datei_combo, $files_string, $first_item)
EndFunc   ;==>_Show_New_Filegui_Scan_for_files

;Suche nach Vrolagen

Func ScanforVorlagen_neue_Datei_erstellen($SourceFolder)
	Local $Search
	Local $file
	Local $FileAttributes
	Local $FullFilePath
	$Count = 0
	$Search = FileFindFirstFile($SourceFolder & "\*.*")
	_GUICtrlListView_DeleteAllItems(GUICtrlGetHandle($vorlagen_Listview_projectman))
	_GUICtrlListView_BeginUpdate($vorlagen_Listview_projectman)
	While 1
		If $Search = -1 Then
			ExitLoop
		EndIf
		$file = FileFindNextFile($Search)
		If @error Then ExitLoop
		If $file = "." Or $file = ".." Then ContinueLoop
		$FullFilePath = $SourceFolder & "\" & $file
		$FileAttributes = FileGetAttrib($FullFilePath)
		If StringInStr($FileAttributes, "D") Then
			If FileExists(_Finde_Projektdatei($FullFilePath)) Then
				$Count = $Count + 1
				$tmp_isn_file = _Finde_Projektdatei($FullFilePath)
				_GUICtrlListView_AddItem($vorlagen_Listview_projectman, IniRead($tmp_isn_file, "ISNAUTOITSTUDIO", "name", "#ERROR#"), 10)
				$folder = StringTrimLeft($FullFilePath, StringInStr($FullFilePath, "\", 0, -1))
				_GUICtrlListView_AddSubItem($vorlagen_Listview_projectman, _GUICtrlListView_GetItemCount($vorlagen_Listview_projectman) - 1, IniRead($tmp_isn_file, "ISNAUTOITSTUDIO", "author", ""), 1)
				_GUICtrlListView_AddSubItem($vorlagen_Listview_projectman, _GUICtrlListView_GetItemCount($vorlagen_Listview_projectman) - 1, $folder, 2)
			EndIf
		EndIf
	WEnd
	FileClose($Search)
	$Descending = False
	_GUICtrlListView_SimpleSort($vorlagen_Listview_projectman, $Descending, 0)
	_GUICtrlListView_SetItemSelected($vorlagen_Listview_projectman, -1, False, False)
	_GUICtrlListView_EndUpdate($vorlagen_Listview_projectman)
	GUICtrlSetData($Found_Vorlagen, $Count & " " & _Get_langstr(377))
EndFunc   ;==>ScanforVorlagen_neue_Datei_erstellen

Func _HIDE_New_Filegui()
	$OwnerWindow = _WinAPI_GetAncestor($Current_TVExplorer_TreeView, $GA_PARENT)
	GUISetState(@SW_ENABLE, $OwnerWindow)
	GUISetState(@SW_ENABLE, $StudioFenster)
	GUISetState(@SW_HIDE, $New_file_GUI)
EndFunc   ;==>_HIDE_New_Filegui

Func _read_combo_new_file()
	GUICtrlSetState($new_file_include_checkbox, $GUI_ENABLE)
	GUICtrlSetState($new_file_include_checkbox, $GUI_UNCHECKED)
	If GUICtrlRead($combo_newfile) = _Get_langstr(154) Or GUICtrlRead($combo_newfile) = _Get_langstr(1452) Then ;au3
		_GUISetIcon($New_file_GUI, $smallIconsdll, 1788)
		_SetIconAlpha($NewFileGUI_BigIcon, @ScriptDir & "\Data\au3_icon.ico", 0, 32, 32)
		GUICtrlSetState($NewFileGUI_BigIcon, $GUI_SHOW) ;Redraw
		GUICtrlSetData($combo_fileformat, ".au3")
;~ 		GUICtrlSetData($combo_beschreibung, _Get_langstr(154))
	EndIf

	If GUICtrlRead($combo_newfile) = _Get_langstr(153) Then ;isf
		_GUISetIcon($New_file_GUI, $smallIconsdll, 780)
		_SetIconAlpha($NewFileGUI_BigIcon, $bigiconsdll, 262 + 1, 32, 32)
		GUICtrlSetState($NewFileGUI_BigIcon, $GUI_SHOW) ;Redraw
;~ 		GUICtrlSetData($combo_beschreibung, _Get_langstr(153))
		GUICtrlSetData($combo_fileformat, ".isf")
		GUICtrlSetState($new_file_include_checkbox, $GUI_CHECKED)
		GUICtrlSetState($neue_datei_radio1, $GUI_CHECKED)
	EndIf
	If GUICtrlRead($combo_newfile) = _Get_langstr(155) Then ;ini
;~ 		GUICtrlSetData($combo_beschreibung, _Get_langstr(155))
		_GUISetIcon($New_file_GUI, $smallIconsdll, 1176)
		_SetIconAlpha($NewFileGUI_BigIcon, $bigiconsdll, 181 + 1, 32, 32)
		GUICtrlSetData($combo_fileformat, ".ini")
		GUICtrlSetState($NewFileGUI_BigIcon, $GUI_SHOW) ;Redraw
	EndIf

	If GUICtrlRead($combo_newfile) = _Get_langstr(156) Then ;txt
;~ 		GUICtrlSetData($combo_beschreibung, _Get_langstr(156))
		_GUISetIcon($New_file_GUI, $smallIconsdll, 1177)
		_SetIconAlpha($NewFileGUI_BigIcon, $bigiconsdll, 441 + 1, 32, 32)
		GUICtrlSetData($combo_fileformat, ".txt")
		GUICtrlSetState($NewFileGUI_BigIcon, $GUI_SHOW) ;Redraw
	EndIf

	If $Studiomodus = 2 Then
		GUICtrlSetState($new_file_include_checkbox, $GUI_UNCHECKED)
		GUICtrlSetState($new_file_include_checkbox, $GUI_DISABLE)
	EndIf
	_New_Filegui_Radio_event()
	_Show_New_Filegui_Scan_for_files()
EndFunc   ;==>_read_combo_new_file

Func _ISN_ShowNewFileGUI_Hotkey()
	;Used for Hotkey, if a file in the Treeview is selected, set the folderpath of the new file to the current seletcted in the treeview
	Local $TreeviewFile = _GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView)
	If Not FileExists($TreeviewFile) Then
		_ISN_ShowNewFileGUI(_Get_langstr(154), "")
	Else
		_ISN_ShowNewFileGUI(_Get_langstr(154), $TreeviewFile)
	EndIf
EndFunc   ;==>_ISN_ShowNewFileGUI_Hotkey

Func _ISN_ShowNewFolderGUI_Hotkey()
	;Used for Hotkey, if a file in the Treeview is selected, set the folderpath of the new file to the current seletcted in the treeview
	Local $TreeviewFile = _GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView)
	If Not FileExists($TreeviewFile) Then
		_ISN_ShowNewFolderGUI()	
	Else
		_ISN_ShowNewFolderGUI(_GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView))	
	EndIf
EndFunc

Func _ISN_ShowNewShortcutGUI_Hotkey()
	;Used for Hotkey, if a file in the Treeview is selected, set the folderpath of the new file to the current seletcted in the treeview
	Local $TreeviewFile = _GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView)
	If Not FileExists($TreeviewFile) Then
		_ISN_ShowCreateNewShortcutGUI()	
	Else
		_ISN_ShowCreateNewShortcutGUI(_GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView))	
	EndIf
EndFunc

Func _ISN_ShowNewFileGUI($StartFileType = _Get_langstr(154), $UseFileFromTreeview = "")
	If $Offenes_Projekt = "" Then Return
	GUICtrlSetData($combo_newfile, "")
	GUICtrlSetData($combo_newfile, _Get_langstr(154) & "|" & _Get_langstr(1452) & "|" & _Get_langstr(153) & "|" & _Get_langstr(155) & "|" & _Get_langstr(156), $StartFileType)
	_Show_New_Filegui($UseFileFromTreeview)
EndFunc   ;==>_ISN_ShowNewFileGUI


Dim $Direction[7]

Func _HeaderSort(ByRef $GUIList, $column)

	If $Direction[$column] = 'Ascending' Then
		Dim $v_sort = False ;Dim $v_sort = _GUICtrlListView_GetColumnCount ($GUIList)
	Else
		Dim $v_sort = True ;Dim $v_sort[_GUICtrlListView_GetColumnCount ($GUIList) ]
	EndIf
	If $Direction[$column] = 'Ascending' Then
		$Direction[$column] = 'Decending'
	Else
		$Direction[$column] = 'Ascending'
	EndIf
	_GUICtrlListView_SimpleSort($GUIList, $v_sort, $column)

EndFunc   ;==>_HeaderSort


Func _datei_oeffnen_mit_Skript_Editor()
	Local $Treeview = $Current_TVExplorer_TreeView
	If _GUICtrlTVExplorer_GetSelected($Treeview) = $Offenes_Projekt Then
		Return
	EndIf
	$file = _GUICtrlTVExplorer_GetSelected($Treeview)
	_ISN_OpenFilewithScripteditor($file)
EndFunc   ;==>_datei_oeffnen_mit_Skript_Editor

Func _ISN_OpenFilewithScripteditor($file = "")
	If $file = "" Then Return -1

	$res = _ArraySearch($Datei_pfad, $file)
	If $res <> -1 Then
		$alreadyopen = $res
	Else
		$alreadyopen = -1
	EndIf

	If $alreadyopen = -1 Then
		_openscriptfile($file)
		_Add_File_to_Backuplist($file)
		If $Offene_tabs > 14 Then _Earn_trophy(9, 2)
		_Fuege_Datei_zu_Zuletzt_Verwendete_Dateien($file)
	Else
		_GUICtrlTab_ActivateTabX($htab, $alreadyopen)
		_Show_Tab($alreadyopen)
	EndIf
EndFunc   ;==>_ISN_OpenFilewithScripteditor


Func _datei_oeffnen_mit_Windows()
	Local $Treeview = $Current_TVExplorer_TreeView
	If _GUICtrlTVExplorer_GetSelected($Treeview) = $Offenes_Projekt Then
		Return
	EndIf
	_Write_log(StringTrimLeft(_GUICtrlTVExplorer_GetSelected($Treeview), StringInStr(_GUICtrlTVExplorer_GetSelected($Treeview), "\", 0, -1)) & " " & _Get_langstr(673), "000000", "false")
	ShellExecute(_GUICtrlTVExplorer_GetSelected($Treeview))
EndFunc   ;==>_datei_oeffnen_mit_Windows

Func _datei_eigenschaften()
	If $Offenes_Projekt = "" Then Return -1
	If Not IsHWnd($Current_TVExplorer_TreeView) Then Return -1
	If _GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView) = $Offenes_Projekt Then
		_Zeige_Projekteinstellungen("projectproperties")
		Return
	EndIf
	_ShowFileProperties(_GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView), "properties", $StudioFenster)
	Return 1
EndFunc   ;==>_datei_eigenschaften

Func _datei_eigenschaften_tab()
	If _GUICtrlTab_GetItemCount($htab) = 0 Then Return
	If $SCE_EDITOR[_GUICtrlTab_GetCurFocus($htab)] = 0 Then Return
	$Pfad = $Datei_pfad[_GUICtrlTab_GetCurFocus($htab)]
	If Not FileExists($Pfad) Then $Pfad = StringReplace($Pfad, ".exe", "." & $Autoitextension)
	If Not FileExists($Pfad) Then Return
	_ShowFileProperties($Pfad, "properties", $StudioFenster)
EndFunc   ;==>_datei_eigenschaften_tab



Func _Info_GUI_Check_Hyperlinks()
	$CursorInfo = GUIGetCursorInfo($ISN_Ueber_GUI)
	If Not IsArray($CursorInfo) Then Return
	If $Hyperlink_Old_Control = $CursorInfo[4] Then Return
	$Hyperlink_Old_Control = $CursorInfo[4]
	Switch $CursorInfo[4]

		Case $info_gui_website_hayperlink_label
			_Hyperlink_Label_Hover($info_gui_website_hayperlink_label)
			Return

	EndSwitch
	_Hyperlink_Label_Hover_Reset()
EndFunc   ;==>_Info_GUI_Check_Hyperlinks


Func _Show_Info()
	GUICtrlSetData($ueber_txt, _Get_langstr(179) & " " & $ERSTELLUNGSTAG & @CRLF & _Get_langstr(219) & " Christian Faderl (ISI360)")
	GUISetState(@SW_DISABLE, $StudioFenster)
	GUISetState(@SW_SHOW, $ISN_Ueber_GUI)
EndFunc   ;==>_Show_Info

Func _hide_Info()
	GUISetState(@SW_ENABLE, $StudioFenster)
	GUISetState(@SW_HIDE, $ISN_Ueber_GUI)
EndFunc   ;==>_hide_Info

Func _close_func()
	GUISetState(@SW_ENABLE, $StudioFenster)
	GUISetState(@SW_HIDE, $Funclist_GUI)
	If _GUICtrlTab_GetItemCount($htab) > 0 Then WinSetState($Plugin_Handle[_GUICtrlTab_GetCurFocus($htab)], "", @SW_ENABLE)
	If _GUICtrlTab_GetItemCount($htab) > 0 Then _ISN_Send_Message_to_Plugin($Plugin_Handle[_GUICtrlTab_GetCurFocus($htab)], "listfuncsok")
	_GUICtrlListView_DeleteAllItems(GUICtrlGetHandle($FuncListview))
EndFunc   ;==>_close_func

Func _func_select_ok()
	If GUICtrlRead($Funcinput) = "" Then Return
	GUISetState(@SW_ENABLE, $StudioFenster)
	GUISetState(@SW_HIDE, $Funclist_GUI)
	If _GUICtrlTab_GetItemCount($htab) > 0 Then WinSetState($Plugin_Handle[_GUICtrlTab_GetCurFocus($htab)], "", @SW_ENABLE)
	_ISN_Send_Message_to_Plugin($Plugin_Handle[_GUICtrlTab_GetCurFocus($htab)], "listfuncsok" & $Plugin_System_Delimiter & GUICtrlRead($Funcinput))
EndFunc   ;==>_func_select_ok

Func _List_Funcs()
	If $Studiomodus = 2 Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(670), 0, $studiofenster)
		If _GUICtrlTab_GetItemCount($htab) > 0 Then _ISN_Send_Message_to_Plugin($Plugin_Handle[_GUICtrlTab_GetCurFocus($htab)], "listfuncsok")

		Return
	EndIf
	GUICtrlSetState($FuncListview, $GUI_DISABLE)
	_GUICtrlListView_DeleteAllItems(GUICtrlGetHandle($FuncListview))
	_GUICtrlListView_AddItem($FuncListview, _Get_langstr(1034), 0)
	_GUICtrlListView_AddItem($FuncListview, _Get_langstr(23), 1)
	GUICtrlSetData($FuncText, _Get_langstr(185))
	GUICtrlSetData($Funcinput, "")
	WinSetTitle($Funclist_GUI, "", _Get_langstr(185))
	GUISetState(@SW_DISABLE, $StudioFenster)
	WinSetState($Plugin_Handle[_GUICtrlTab_GetCurFocus($htab)], "", @SW_DISABLE)
	GUISetState(@SW_SHOW, $Funclist_GUI)
	WinSetOnTop($Funclist_GUI, "", 1)
	WinActivate($Funclist_GUI)

	Local $List_tempdir = _ISN_Variablen_aufloesen(_ProjectISN_Config_Read("temp_script_path", "?"))
	Local $List_backupdir = _ISN_Variablen_aufloesen("%backupdir%")
	Local $List_releasedir = _ISN_Variablen_aufloesen("%compileddir%")
	If _ProjectISN_Config_Read("compile_mode", "2") = "1" Then $List_releasedir = "?"
	Local $aList

	;List all functions in the project
	Dim $ALL_CODE
	Dim $tmp_CODE
	Dim $aRecords
	Dim $str
	$files = _GetFileList($Offenes_Projekt, "*.au3")
	For $x = 0 To UBound($files) - 1
		If FileExists($files[$x]) Then
			If StringInStr($files[$x], $List_tempdir) Or StringInStr($files[$x], $List_backupdir) Or StringInStr($files[$x], $List_releasedir) Then ContinueLoop ;Ignore Backup, Release and Temp dir
			$source = StringTrimLeft($files[$x], StringInStr($files[$x], "\", -1, -1))
			_FileReadToArray($files[$x], $tmp_CODE)
			$new = _ArrayToString($tmp_CODE, @CRLF)
			$str = $str & $new
		EndIf
	Next

	$aList = StringRegExp(StringRegExpReplace($str, '(?ims)#c[^#]+#c', ''), '(?ims)^\s*Func\s*([^(]*)', 3)
	If IsArray($aList) Then
		$aList = _ArrayUnique($aList)
		_ArrayDelete($aList, 0)
	EndIf
	If IsArray($aList) Then _ArraySort($aList)
	_GUICtrlListView_BeginUpdate($FuncListview)
	_GUICtrlListView_DeleteAllItems(GUICtrlGetHandle($FuncListview))
	For $i = 0 To UBound($aList) - 1
		_GUICtrlListView_AddItem($FuncListview, $aList[$i], _GUICtrlListView_GetItemCount($FuncListview) - 1)
	Next

	_GUICtrlListView_EndUpdate($FuncListview)
	GUICtrlSetState($FuncListview, $GUI_ENABLE)
EndFunc   ;==>_List_Funcs

Func _List_Guis()
	If $Studiomodus = 2 Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(670), 0, $studiofenster)
		_ISN_Send_Message_to_Plugin($Plugin_Handle[_GUICtrlTab_GetCurFocus($htab)], "listguisok")
		Return
	EndIf

	GUICtrlSetState($FuncListview, $GUI_DISABLE)
	_GUICtrlListView_DeleteAllItems(GUICtrlGetHandle($FuncListview))
	_GUICtrlListView_AddItem($FuncListview, _Get_langstr(1034), 0)
	_GUICtrlListView_AddItem($FuncListview, _Get_langstr(23), 1)
	GUICtrlSetData($FuncText, _Get_langstr(400))
	GUICtrlSetData($Funcinput, "")
	WinSetTitle($Funclist_GUI, "", _Get_langstr(400))
	GUISetState(@SW_DISABLE, $StudioFenster)
	WinSetState($Plugin_Handle[_GUICtrlTab_GetCurFocus($htab)], "", @SW_DISABLE)
	GUISetState(@SW_SHOW, $Funclist_GUI)
	WinSetOnTop($Funclist_GUI, "", 1)
	WinActivate($Funclist_GUI)
	;List all functions in the project
	Dim $ALL_CODE
	Dim $tmp_CODE
	Dim $aRecords
	Dim $str
	Local $Fertiges_Array[1] = [0]

	$files = _GetFileList($Offenes_Projekt, "*.isf")
	$Array2 = _GetFileList($Offenes_Projekt, "*.au3")
	_ArrayConcatenate($files, $Array2)
	For $x = 0 To UBound($files) - 1
		If FileExists($files[$x]) Then
			$source = StringTrimLeft($files[$x], StringInStr($files[$x], "\", -1, -1))
			_FileReadToArray($files[$x], $tmp_CODE)
			If @error Then ContinueLoop
			$new = _ArrayToString($tmp_CODE, @CRLF)
			$str = $str & $new
		EndIf
	Next

	$aList = StringRegExp(StringRegExpReplace($str, '(?ims)#c[^#]+#c', ''), '(?ims)^\s*$\s*([^' & @CRLF & '|(]*)', 3)

	If IsArray($aList) Then
		For $i = 0 To UBound($aList) - 1
			$wert = $aList[$i]
			If Not StringInStr($wert, "guicreate") Then ContinueLoop
			If Not StringInStr($wert, "$") Then ContinueLoop
			$wert = StringTrimRight($wert, StringLen($wert) - StringInStr($wert, "=") + 1)
			$wert = StringReplace($wert, " ", "")
			_ArrayAdd($Fertiges_Array, StringStripWS($wert, 3))
		Next
	EndIf

	;Doppelte Einträge entfernen
	If IsArray($Fertiges_Array) Then _ArrayDelete($Fertiges_Array, 0)
	If IsArray($Fertiges_Array) Then
		$Fertiges_Array = _ArrayUnique($Fertiges_Array)
		_ArrayDelete($Fertiges_Array, 0)
	EndIf
	If IsArray($Fertiges_Array) Then _ArraySort($Fertiges_Array)
	_GUICtrlListView_BeginUpdate($FuncListview)
	_GUICtrlListView_DeleteAllItems(GUICtrlGetHandle($FuncListview))
	For $t = 0 To UBound($Fertiges_Array) - 1
		_GUICtrlListView_AddItem($FuncListview, $Fertiges_Array[$t], _GUICtrlListView_GetItemCount($FuncListview) - 1)
	Next
	_GUICtrlListView_EndUpdate($FuncListview)
	GUICtrlSetState($FuncListview, $GUI_ENABLE)
EndFunc   ;==>_List_Guis

Func _Select_folder_plugin()
	If $Studiomodus = 1 Then
		$result = _WinAPI_BrowseForFolderDlg($Offenes_Projekt, _Get_langstr(313), $BIF_NEWDIALOGSTYLE + $BIF_RETURNONLYFSDIRS, 0, 0, $Studiofenster)
	Else
		$result = _WinAPI_BrowseForFolderDlg("", _Get_langstr(313), $BIF_NEWDIALOGSTYLE + $BIF_RETURNONLYFSDIRS, 0, 0, $Studiofenster)
	EndIf
	If @error Or $result = "" Then
		_ISN_Send_Message_to_Plugin($Plugin_Handle[_GUICtrlTab_GetCurFocus($htab)], "selectfolderok")
		Return
	EndIf
	_ISN_Send_Message_to_Plugin($Plugin_Handle[_GUICtrlTab_GetCurFocus($htab)], "selectfolderok" & $Plugin_System_Delimiter & $result)
EndFunc   ;==>_Select_folder_plugin

Func _Weitere_Dateien_zum_Kompilieren_waehlen_Abbrechen()
	GUISetState(@SW_ENABLE, $Studiofenster)
	GUISetState(@SW_HIDE, $Weitere_Dateien_Kompilieren_GUI)
	_GUICtrlTVExplorer_Destroy($Weitere_Dateien_Kompilieren_GUI_hTreeview, 1) ;Zerstöre Treeview
EndFunc   ;==>_Weitere_Dateien_zum_Kompilieren_waehlen_Abbrechen



Func _Weitere_Dateien_zum_Kompilieren_Lade_Treeview_aus_Listview()

	$Dateien = IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "additional_files_to_compile", "")
	$files_array = StringSplit($Dateien, "|", 2)

	;Hauptdatei sperren
	$Treeview_Checkboxen_Gesperrte_Elemente = $Offenes_Projekt & "\" & IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "mainfile", "")
	$handle = _GUICtrlTVExplorer_Expand($Weitere_Dateien_Kompilieren_GUI_hTreeview, $Offenes_Projekt & "\" & IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "mainfile", ""), 1, 1)
	MyCtrlSetItemState($Weitere_Dateien_Kompilieren_GUI_hTreeview, $handle, $GUI_CHECKED + $GUI_DISABLE)


	_GUICtrlListView_DeleteAllItems(GUICtrlGetHandle($Weitere_Dateien_Kompilieren_GUI_Listview))
	_GUICtrlListView_BeginUpdate($Weitere_Dateien_Kompilieren_GUI_Listview)
	_GUICtrlTreeView_BeginUpdate($Weitere_Dateien_Kompilieren_GUI_hTreeview)
	If IsArray($files_array) Then
		For $y = 0 To UBound($files_array) - 1
			If $files_array[$y] = "" Then ContinueLoop
			If $files_array[$y] = "|" Then ContinueLoop
			If Not FileExists(_ISN_Variablen_aufloesen($files_array[$y])) Then ContinueLoop
			_GUICtrlListView_AddItem($Weitere_Dateien_Kompilieren_GUI_Listview, $files_array[$y], 10)
			_GUICtrlTVExplorer_Expand($Weitere_Dateien_Kompilieren_GUI_hTreeview, _ISN_Variablen_aufloesen($files_array[$y]))
			If Not BitAND( MyCtrlGetItemState($Weitere_Dateien_Kompilieren_GUI_hTreeview, _GUICtrlTreeView_GetSelection($Weitere_Dateien_Kompilieren_GUI_hTreeview)), $GUI_DISABLE) = $GUI_DISABLE Then
				MyCtrlSetItemState($Weitere_Dateien_Kompilieren_GUI_hTreeview, _GUICtrlTreeView_GetSelection($Weitere_Dateien_Kompilieren_GUI_hTreeview), $GUI_CHECKED)
			EndIf
		Next
	EndIf
	_GUICtrlListView_EndUpdate($Weitere_Dateien_Kompilieren_GUI_Listview)
	_GUICtrlTreeView_EndUpdate($Weitere_Dateien_Kompilieren_GUI_hTreeview)
EndFunc   ;==>_Weitere_Dateien_zum_Kompilieren_Lade_Treeview_aus_Listview


Func _Weitere_Dateien_zum_Kompilieren_waehlen_OK()
	$Fertige_String = ""
	For $x = 0 To _GUICtrlListView_GetItemCount($Weitere_Dateien_Kompilieren_GUI_Listview) - 1
		$Datei = _GUICtrlListView_GetItemText($Weitere_Dateien_Kompilieren_GUI_Listview, $x)
		If $Datei = "" Then ContinueLoop
		$Fertige_String = $Fertige_String & $Datei & "|"
	Next
	If StringRight($Fertige_String, 1) = "|" Then $Fertige_String = StringTrimRight($Fertige_String, 1)
	IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "additional_files_to_compile", $Fertige_String)
	_Weitere_Dateien_zum_Kompilieren_waehlen_Abbrechen() ;Hide
EndFunc   ;==>_Weitere_Dateien_zum_Kompilieren_waehlen_OK

Func _Weitere_Dateien_zum_Kompilieren_waehlen()
	$Filter = "*.au3"
	GUISetState(@SW_SHOW, $Weitere_Dateien_Kompilieren_GUI)
	GUISetState(@SW_DISABLE, $Studiofenster)
	$Weitere_Dateien_Kompilieren_GUI_Treeview_dummy_pos = _ControlGetPos($Weitere_Dateien_Kompilieren_GUI, "", $Weitere_Dateien_Kompilieren_GUI_Treeview_dummy)
	If IsArray($Weitere_Dateien_Kompilieren_GUI_Treeview_dummy_pos) Then
		GUISwitch($Weitere_Dateien_Kompilieren_GUI)
		$Weitere_Dateien_Kompilieren_GUI_Treeview = _GUICtrlTVExplorer_Create($Offenes_Projekt, $Weitere_Dateien_Kompilieren_GUI_Treeview_dummy_pos[0], $Weitere_Dateien_Kompilieren_GUI_Treeview_dummy_pos[1], $Weitere_Dateien_Kompilieren_GUI_Treeview_dummy_pos[2], $Weitere_Dateien_Kompilieren_GUI_Treeview_dummy_pos[3], -1, $WS_EX_CLIENTEDGE, $TV_FLAG_SHOWFILESEXTENSION + $TV_FLAG_SHOWFILES + $TV_FLAG_SHOWFOLDERICON + $TV_FLAG_SHOWFILEICON + $TV_FLAG_SHOWLIKEEXPLORER, "_Projecttree_event", $Filter, "", 1)
		LoadStateImage($Weitere_Dateien_Kompilieren_GUI_Treeview) ;Icons in den Treeview laden (TristateTreeViewLib.au3)
		GUICtrlSetResizing($Weitere_Dateien_Kompilieren_GUI_Treeview, 354)
		$Weitere_Dateien_Kompilieren_GUI_hTreeview = GUICtrlGetHandle($Weitere_Dateien_Kompilieren_GUI_Treeview)
		GUICtrlSetFont($Weitere_Dateien_Kompilieren_GUI_hTreeview, $treefont_size, 400, 0, $treefont_font) ;Schrift
		GUICtrlSetColor($Weitere_Dateien_Kompilieren_GUI_hTreeview, $treefont_colour) ;Farbe
		_GUICtrlTVExplorer_Expand($Weitere_Dateien_Kompilieren_GUI_Treeview)
	EndIf
	_Weitere_Dateien_zum_Kompilieren_Lade_Treeview_aus_Listview()
	_Weitere_Dateien_Kompilieren_Treeview_Event()
EndFunc   ;==>_Weitere_Dateien_zum_Kompilieren_waehlen

Func _Weitere_Dateien_Kompilieren_Treeview_Event()
	$hSelected = _GUICtrlTreeView_GetSelection($Weitere_Dateien_Kompilieren_GUI_hTreeview)
	;Markiertes Element in Listview eintragen/austragen
	_GUICtrlListView_BeginUpdate($Weitere_Dateien_Kompilieren_GUI_Listview)
;~ 	_GUICtrlListView_DeleteAllItems(GUICtrlGetHandle($Weitere_Dateien_Kompilieren_GUI_Listview))
	_Weitere_Dateien_Kompilieren_Lade_Listview_aus_Treeview(_GUICtrlTreeView_GetFirstItem($Weitere_Dateien_Kompilieren_GUI_hTreeview), $Weitere_Dateien_Kompilieren_GUI_hTreeview)
	_GUICtrlListView_EndUpdate($Weitere_Dateien_Kompilieren_GUI_Listview)
EndFunc   ;==>_Weitere_Dateien_Kompilieren_Treeview_Event

Func _Weitere_Dateien_Kompilieren_Listview_aktualisieren($hinzufuegen = 1, $ItemText = "")
	If $hinzufuegen = 1 Then
		;Prüfen ob Element in der Liste ist. Wenn nein -> hinzufügen
		If _GUICtrlListView_FindText($Weitere_Dateien_Kompilieren_GUI_Listview, $ItemText) = -1 Then _GUICtrlListView_AddItem($Weitere_Dateien_Kompilieren_GUI_Listview, $ItemText, 10)
	Else
		;Prüfen ob Element in der Liste ist. Wenn ja -> löschen
		$find_result = _GUICtrlListView_FindText($Weitere_Dateien_Kompilieren_GUI_Listview, $ItemText)
		If $find_result <> -1 Then _GUICtrlListView_DeleteItem($Weitere_Dateien_Kompilieren_GUI_Listview, $find_result)
	EndIf
EndFunc   ;==>_Weitere_Dateien_Kompilieren_Listview_aktualisieren


Func _Weitere_Dateien_Kompilieren_Eintrag_nach_unten_verschieben()

	If _GUICtrlListView_GetSelectionMark($Weitere_Dateien_Kompilieren_GUI_Listview) = -1 Then Return
	If _GUICtrlListView_GetItemCount($Weitere_Dateien_Kompilieren_GUI_Listview) = 0 Then Return
	_GUICtrlListView_MoveItems($Weitere_Dateien_Kompilieren_GUI_Listview, 1)
	_GUICtrlListView_EnsureVisible($Weitere_Dateien_Kompilieren_GUI_Listview, _GUICtrlListView_GetSelectionMark($Weitere_Dateien_Kompilieren_GUI_Listview))
	_GUICtrlListView_SetItemSelected($Weitere_Dateien_Kompilieren_GUI_Listview, _GUICtrlListView_GetSelectionMark($Weitere_Dateien_Kompilieren_GUI_Listview), True, True)
EndFunc   ;==>_Weitere_Dateien_Kompilieren_Eintrag_nach_unten_verschieben

Func _Weitere_Dateien_Kompilieren_Eintrag_nach_oben_verschieben()

	If _GUICtrlListView_GetSelectionMark($Weitere_Dateien_Kompilieren_GUI_Listview) = -1 Then Return
	If _GUICtrlListView_GetItemCount($Weitere_Dateien_Kompilieren_GUI_Listview) = 0 Then Return
	_GUICtrlListView_MoveItems($Weitere_Dateien_Kompilieren_GUI_Listview, -1)
	_GUICtrlListView_EnsureVisible($Weitere_Dateien_Kompilieren_GUI_Listview, _GUICtrlListView_GetSelectionMark($Weitere_Dateien_Kompilieren_GUI_Listview))
	_GUICtrlListView_SetItemSelected($Weitere_Dateien_Kompilieren_GUI_Listview, _GUICtrlListView_GetSelectionMark($Weitere_Dateien_Kompilieren_GUI_Listview), True, True)
EndFunc   ;==>_Weitere_Dateien_Kompilieren_Eintrag_nach_oben_verschieben

Func _Weitere_Dateien_Kompilieren_Lade_Listview_aus_Treeview($hHandle, $Treeview = "")

	; Get the handle of the first child
	$hChild = _GUICtrlTreeView_GetFirstChild($Treeview, $hHandle)
	; If there is no child
	If $hChild = 0 Then
		Return
	EndIf

	; check the child
	If StringInStr(_GUICtrlTreeView_GetText($Treeview, $hChild), $Autoitextension) Then
		If BitAND( MyCtrlGetItemState($Weitere_Dateien_Kompilieren_GUI_hTreeview, $hChild), $GUI_CHECKED) = $GUI_CHECKED Then
			_Weitere_Dateien_Kompilieren_Listview_aktualisieren(1, _ISN_Pfad_durch_Variablen_ersetzen(_GUICtrlTVExplorer_GetPathFromItem($Treeview, $hChild)))
		Else
			_Weitere_Dateien_Kompilieren_Listview_aktualisieren(0, _ISN_Pfad_durch_Variablen_ersetzen(_GUICtrlTVExplorer_GetPathFromItem($Treeview, $hChild)))
		EndIf
	EndIf

;~     _GUICtrlTreeView_SetChecked($Treeview, $hChild, False)

	; Check for children
	_Weitere_Dateien_Kompilieren_Lade_Listview_aus_Treeview($hChild, $Treeview)

	; Now look for all grandchildren
	While 1
		; Look for next child
		$hChild = _GUICtrlTreeView_GetNextChild($Treeview, $hChild)
		; Exit the loop if none found
		If $hChild = 0 Then
			ExitLoop
		EndIf
		; check the child
		If StringInStr(_GUICtrlTreeView_GetText($Treeview, $hChild), $Autoitextension) Then
			If BitAND( MyCtrlGetItemState($Weitere_Dateien_Kompilieren_GUI_hTreeview, $hChild), $GUI_CHECKED) = $GUI_CHECKED Then
				_Weitere_Dateien_Kompilieren_Listview_aktualisieren(1, _ISN_Pfad_durch_Variablen_ersetzen(_GUICtrlTVExplorer_GetPathFromItem($Treeview, $hChild)))
			Else
				_Weitere_Dateien_Kompilieren_Listview_aktualisieren(0, _ISN_Pfad_durch_Variablen_ersetzen(_GUICtrlTVExplorer_GetPathFromItem($Treeview, $hChild)))
			EndIf
		EndIf

		; Check for children
		_Weitere_Dateien_Kompilieren_Lade_Listview_aus_Treeview($hChild, $Treeview)
		; And then look for the next child
	WEnd

EndFunc   ;==>_Weitere_Dateien_Kompilieren_Lade_Listview_aus_Treeview

Func _Treeview_Check_Parents($hHandle, $Treeview = "")

	; Get the handle of the parent
	$hParent = _GUICtrlTreeView_GetParentHandle($Treeview, $hHandle)
	; If there is no parent
	If $hParent = 0 Then
		Return
	EndIf
	; Check the parent
	_GUICtrlTreeView_SetChecked($Treeview, $hParent)

	; And look for the grandparent and so on
	_Treeview_Check_Parents($hParent, $Treeview)
EndFunc   ;==>_Treeview_Check_Parents


Func _Treeview_Uncheck_Children($hHandle, $Treeview = "")

	; Get the handle of the first child
	$hChild = _GUICtrlTreeView_GetFirstChild($Treeview, $hHandle)
	; If there is no child
	If $hChild = 0 Then
		Return
	EndIf
	; Uncheck the child
	_GUICtrlTreeView_SetChecked($Treeview, $hChild, False)

	; Check for children
	_Treeview_Uncheck_Children($hChild, $Treeview)

	; Now look for all grandchildren
	While 1
		; Look for next child
		$hChild = _GUICtrlTreeView_GetNextChild($Treeview, $hChild)
		; Exit the loop if none found
		If $hChild = 0 Then
			ExitLoop
		EndIf
		; Uncheck the child
		_GUICtrlTreeView_SetChecked($Treeview, $hChild, False)

		; Check for children
		_Treeview_Uncheck_Children($hChild, $Treeview)
		; And then look for the next child
	WEnd

EndFunc   ;==>_Treeview_Uncheck_Children


Func _Choose_File($Filter = "")
	$FilechooseFilter = $Filter
	Local $root = ""
	GUISetState(@SW_DISABLE, $StudioFenster)
	GUICtrlSetState($Choose_File_GUI_Mehr, $GUI_SHOW)
	GUICtrlSetOnEvent($Choose_File_GUI_OK, "_Choose_File_OK")
	GUICtrlSetOnEvent($Choose_File_GUI_Abbrechen, "_close_Choose_File")
	GUISetOnEvent($GUI_EVENT_CLOSE, "_close_Choose_File", $Choose_File_GUI)
	GUICtrlSetData($Choose_File_GUI_Label, _Get_langstr(187) & " (" & StringReplace(StringReplace($Filter, ";", ","), "*.", "") & ")")
	If _GUICtrlTab_GetItemCount($htab) > 0 Then WinSetState($Plugin_Handle[_GUICtrlTab_GetCurFocus($htab)], "", @SW_DISABLE)
	GUISwitch($Choose_File_GUI)
	If $Studiomodus = 1 Then
		Global $Choose_File_Treeview = _GUICtrlTVExplorer_Create($Offenes_Projekt, 10 * $DPI, 40 * $DPI, 480 * $DPI, 355 * $DPI, -1, $WS_EX_CLIENTEDGE, $TV_FLAG_SHOWFILESEXTENSION + $TV_FLAG_SHOWFILES + $TV_FLAG_SHOWFOLDERICON + $TV_FLAG_SHOWFILEICON + $TV_FLAG_SHOWLIKEEXPLORER, "_Projecttree_event", $Filter)
	Else
		Global $Choose_File_Treeview = _GUICtrlTVExplorer_Create("", 10 * $DPI, 40 * $DPI, 480 * $DPI, 355 * $DPI, -1, $WS_EX_CLIENTEDGE, $TV_FLAG_SHOWFILESEXTENSION + $TV_FLAG_SHOWFILES + $TV_FLAG_SHOWFOLDERICON + $TV_FLAG_SHOWFILEICON + $TV_FLAG_SHOWLIKEEXPLORER, "_Projecttree_event", $Filter)
	EndIf
	Global $Choose_File_hTreeview = GUICtrlGetHandle($Choose_File_Treeview)
	GUICtrlSetFont($Choose_File_Treeview, $treefont_size, 400, 0, $treefont_font) ;Schrift
	GUICtrlSetColor($Choose_File_Treeview, $treefont_colour) ;Farbe
	_GUICtrlTVExplorer_Expand($Choose_File_hTreeview)
	GUISetState(@SW_SHOW, $Choose_File_GUI)
	WinSetOnTop($Choose_File_GUI, "", 1)
EndFunc   ;==>_Choose_File

Func _Choose_external_file()
	_Lock_Plugintabs("lock")
	If $Skin_is_used = "true" Then
		$Datei = _WinAPI_OpenFileDlg(_Get_langstr(969), $Offenes_Projekt, "Files (" & $FilechooseFilter & ")", 0, '', '', BitOR($OFN_PATHMUSTEXIST, $OFN_FILEMUSTEXIST, $OFN_HIDEREADONLY), $OFN_EX_NOPLACESBAR, 0, 0, $Choose_File_GUI)
	Else
		$Datei = FileOpenDialog(_Get_langstr(969), $Offenes_Projekt, "Files (" & $FilechooseFilter & ")", 1 + 2, "", $Choose_File_GUI)
	EndIf
	_Lock_Plugintabs("unlock")
	FileChangeDir(@ScriptDir)
	If @error Then Return
	If $Datei = "" Then Return
	GUISetState(@SW_ENABLE, $StudioFenster)
	GUISetState(@SW_HIDE, $Choose_File_GUI)
	If _GUICtrlTab_GetItemCount($htab) > 0 Then WinSetState($Plugin_Handle[_GUICtrlTab_GetCurFocus($htab)], "", @SW_ENABLE)
	$gelesener_pfad = $Datei
	If $Studiomodus = 1 Then ;Relative Pfade im Projektmodus
		$gelesener_pfad = StringReplace($gelesener_pfad, $Offenes_Projekt & "\", "")
	EndIf
	If _GUICtrlTab_GetItemCount($htab) > 0 Then _ISN_Send_Message_to_Plugin($Plugin_Handle[_GUICtrlTab_GetCurFocus($htab)], "listpicturesok" & $Plugin_System_Delimiter & $gelesener_pfad)
	_GUICtrlTVExplorer_Destroy($Choose_File_hTreeview, 1) ;Zerstöre Treeview
EndFunc   ;==>_Choose_external_file


Func _close_Choose_File()
	GUISetState(@SW_ENABLE, $StudioFenster)
	GUISetState(@SW_HIDE, $Choose_File_GUI)
	If _GUICtrlTab_GetItemCount($htab) > 0 Then WinSetState($Plugin_Handle[_GUICtrlTab_GetCurFocus($htab)], "", @SW_ENABLE)
	If _GUICtrlTab_GetItemCount($htab) > 0 Then _ISN_Send_Message_to_Plugin($Plugin_Handle[_GUICtrlTab_GetCurFocus($htab)], "listpicturesok")
	_GUICtrlTVExplorer_Destroy($Choose_File_hTreeview, 1) ;Zerstöre Treeview
EndFunc   ;==>_close_Choose_File

Func _Choose_File_OK()
	Local $gelesener_pfad
	If _GUICtrlTreeView_GetSelection($Choose_File_Treeview) = 0 Then Return
	If StringInStr(_GUICtrlTreeView_GetTree($Choose_File_Treeview, _GUICtrlTreeView_GetSelection($Choose_File_Treeview)), ".", 1, -1) = 0 Then Return
	GUISetState(@SW_ENABLE, $StudioFenster)
	GUISetState(@SW_HIDE, $Choose_File_GUI)
	If _GUICtrlTab_GetItemCount($htab) > 0 Then WinSetState($Plugin_Handle[_GUICtrlTab_GetCurFocus($htab)], "", @SW_ENABLE)
	$gelesener_pfad = _GUICtrlTVExplorer_GetSelected($Choose_File_Treeview)
;~ 	$data = _GUICtrlTreeView_GetTree($Choose_File_Treeview, _GUICtrlTreeView_GetSelection($Choose_File_Treeview))
;~ 	$data = stringtrimleft($data, stringlen($Offenes_Projekt_name) + 1)
;~ 	$data = stringreplace($data, "|", "\")
	If $Studiomodus = 1 Then ;Relative Pfade im Projektmodus
		$gelesener_pfad = StringReplace($gelesener_pfad, $Offenes_Projekt & "\", "")
	EndIf
	If _GUICtrlTab_GetItemCount($htab) > 0 Then _ISN_Send_Message_to_Plugin($Plugin_Handle[_GUICtrlTab_GetCurFocus($htab)], "listpicturesok" & $Plugin_System_Delimiter & $gelesener_pfad)
	_GUICtrlTVExplorer_Destroy($Choose_File_hTreeview, 1) ;Zerstöre Treeview
EndFunc   ;==>_Choose_File_OK

;===============================================================================
;
; Description:      Verknüpft Dateierweiterung mit Anwendung
; Parameter(s):     $sFileType    = Dateierweiterung
;                   $sDescription = Beschreibung für die Datei
;                   (optional) $sAppName = Anwendung für die Registriert werden
;                                          soll, wird keine Anwendung angegeben
;                                          wird die aktuelle Anwendung eingetragen
; Requirement(s):   keine
; Return Value(s):  bei Erfolg: 1
;                   bei Fehler: 0 und @error = 1
; Author(s):        bernd670
;
;===============================================================================

Func _RegisterFileType($sFileType, $sDescription, $sAppName = "", $pIcon = "")
	Dim $sTypeName
	If $pIcon = "" Then
		$icon = @ScriptDir & "\autoitstudioicon.ico"
	Else
		$icon = $pIcon
	EndIf
	If $sFileType = "" Or $sDescription = "" Then
		SetError(1)
		Return 0
	EndIf



	$sFileType = StringLower($sFileType)

	If StringLeft($sFileType, 1) <> "." Then
		$sTypeName = $sFileType
		$sFileType = "." & $sFileType
	Else
		$sTypeName = StringRight($sFileType, StringLen($sFileType) - 1)
	EndIf

	$sTypeName = $sTypeName & "file"

;~ 	;Lösche alte Methode mit AllUsers
;~ 	RegDelete("HKEY_CLASSES_ROOT\" & $sFileType)
;~ 	RegDelete("HKEY_CLASSES_ROOT\" & $sTypeName)

	;Check, if there is already a assocc
	If $CheckFiletypesBeforeRegister = "true" Then
		Local $Assoc_Read = RegRead("HKEY_CURRENT_USER\SOFTWARE\Classes\" & $sTypeName & "\shell\open\command", "")
		Local $Assoc_Read_Explorer = RegRead("HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\" & $sFileType & "\UserChoice", "ProgId")
		Local $String_to_check1 = ""
		Local $String_to_check2 = ""
		If $Assoc_Read <> "" Then
			If @Compiled Then
				$String_to_check1 = '"' & @AutoItExe & '"' & ' "%1"'
				$String_to_check2 = $autoitexe & ' "' & @ScriptDir & "\" & 'Autoit_Studio.au3"' & ' "%1"'
			Else
				$String_to_check1 = '"' & @ScriptDir & "\" & 'Autoit_Studio.exe"' & ' "%1"'
				$String_to_check2 = $autoitexe & ' "' & @ScriptDir & "\" & 'Autoit_Studio.au3"' & ' "%1"'
			EndIf

			If ($Assoc_Read <> $String_to_check1 And $Assoc_Read <> $String_to_check2 And StringInStr($Assoc_Read, "Autoit_Studio.") = 0) Or ($Assoc_Read_Explorer <> "" And $Assoc_Read_Explorer <> $sTypeName) Then
				$Warning_Text = _Get_langstr(1405)
				$Warning_Text = StringReplace($Warning_Text, "%1", $sFileType)
				If $Assoc_Read_Explorer <> "" Then
					$Warning_Text = StringReplace($Warning_Text, "%2", $Assoc_Read_Explorer)
				Else
					$Warning_Text = StringReplace($Warning_Text, "%2", $Assoc_Read)
				EndIf
				$Assoc_Warning_Res = MsgBox($MB_TOPMOST + $MB_YESNOCANCEL + $MB_ICONWARNING, _Get_langstr(394), $Warning_Text)
				If $Assoc_Warning_Res = 2 Or @error Then Return
				If $Assoc_Warning_Res = 6 Then RegDelete("HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\FileExts\" & $sFileType)
				If $Assoc_Warning_Res = 7 Then

					Switch $sFileType

						Case ".icp"
							$registericpfiles = "false"
							_Write_in_Config("registericpfiles", "false")

						Case ".isp"
							$registerispfiles = "false"
							_Write_in_Config("registerispfiles", "false")

						Case ".isn"
							$registerisnfiles = "false"
							_Write_in_Config("registerisnfiles", "false")

					EndSwitch
					Return
				EndIf
			EndIf
		EndIf
	EndIf

	RegWrite("HKEY_CURRENT_USER\SOFTWARE\Classes\" & $sFileType, "", "REG_SZ", $sTypeName)
	RegWrite("HKEY_CURRENT_USER\SOFTWARE\Classes\" & $sTypeName, "", "REG_SZ", $sDescription)
	RegWrite("HKEY_CURRENT_USER\SOFTWARE\Classes\" & $sTypeName & "\shell\open\command", "", "REG_SZ", _ISN_Get_MainExecutable_Path_for_Windows() & ' "%1"')
	RegWrite("HKEY_CURRENT_USER\SOFTWARE\Classes\" & $sTypeName & "\DefaultIcon", "", "REG_SZ", $icon & ",0")


;~ 	RegWrite("HKCR\" & $sFileType, "", "REG_SZ", $sTypeName)
;~ 	RegWrite("HKCR\" & $sTypeName, "", "REG_SZ", $sDescription)
;~ 	RegWrite("HKCR\" & $sTypeName & "\shell\open\command", "", "REG_SZ", $sAppName & " %1")
;~ 	RegWrite("HKCR\" & $sTypeName & "\DefaultIcon", "", "REG_SZ", $icon & ",0")

	SetError(0)
	Return 1
EndFunc   ;==>_RegisterFileType

;===============================================================================
;
; Description:      Hebt Verknüpfung einer Dateierweiterung mit Anwendung auf
; Parameter(s):     $sFileType    = Dateierweiterung
; Requirement(s):   keine
; Return Value(s):  bei Erfolg: 1
;                   bei Fehler: 0 und @error = 1
; Author(s):        bernd670
;
;===============================================================================

Func _UnRegisterFileType($sFileType)
	Dim $sTypeName

	If $sFileType = "" Then
		SetError(1)
		Return 0
	EndIf

	$sFileType = StringLower($sFileType)

	If StringLeft($sFileType, 1) <> "." Then
		$sTypeName = $sFileType
		$sFileType = "." & $sFileType
	Else
		$sTypeName = StringRight($sFileType, StringLen($sFileType) - 1)
	EndIf

	$sTypeName = $sTypeName & "file"

	;If fileassoc is not the ISN, do not remove it!
	If Not StringInStr(RegRead("HKEY_CURRENT_USER\SOFTWARE\Classes\" & $sTypeName & "\shell\open\command", ""), "Autoit_Studio.") Then Return


	RegDelete("HKEY_CLASSES_ROOT\" & $sFileType)
	RegDelete("HKEY_CURRENT_USER\SOFTWARE\Classes\" & $sFileType)
	RegDelete("HKEY_CLASSES_ROOT\" & $sTypeName)
	RegDelete("HKEY_CURRENT_USER\SOFTWARE\Classes\" & $sTypeName)

	SetError(0)
	Return 1
EndFunc   ;==>_UnRegisterFileType


;===============================================================================
; Function Name:   _FileDeleteAfterXDays($sPath, $iDays[, $bForceDel][, $bRek][, $bDirDel][, $bLog])
; Description::    löscht Dateien in einem ausgewähltem Verzeichnis (rekursiv)
;                  nach einer angegebenen Anzahl von Tagen
; Parameter(s):    $sPath = Verzeichnis, aus dem die Dateien gelöscht werden sollen.
;                  $iDays = Dateien, die älter als $iDays (in Tagen) sind, löschen.
;                  $bForceDel = wenn "True" werden auch Dateien/Verzeichnisse gelöscht,
;                               die gegen löschen geschützt sind ("R"-Attribut)
;                  $bRek = wenn "True" wird das Verzeichnis rekursiv (inkl. Unter-
;                          verzeichnisse) durchsucht.
;                  $bDirDel = wenn "True" wird das Unterverzeichnis gelöscht, wenn
;                             es (aufgrund der Löschaktion) leer ist.
;                  $bLog = wenn "True" wird das Ergebnis der Löschaktion in die
;                          Console geschrieben.
; Requirement(s):  AutoIt-Version min. v3.3.2.0
;                  #include <Date.au3>
; Return Value(s): bei Erfolg Rückgabe = 1
;                  bei Fehler Rückgabe = 0
;                  und @error:
;                  1 = $iDays ist keine oder eine negative Zahl
;                  2 = Das übergebene Verzeichnis existiert nicht oder ist leer.
; Author(s):       Oscar (www.autoit.de)
;                  Micha_he (www.autoit.de)
;===============================================================================

Func _FileDeleteAfterXDays($sPath, $iDays, $bForceDel = False, $bRek = True, $bDirDel = True, $bLog = False)
	Local $hSearchm, $hEmpty, $sFile, $sDate, $iRet
	;   If (Not IsNumber($iDays)) Or ($iDays < 0) Then Return SetError(1, 0, 0)
	If StringRight($sPath, 1) <> '\' Then $sPath &= '\'
	$hSearch = FileFindFirstFile($sPath & '*.*')
	If @error Then Return SetError(2, 0, 0)
	While 1
		$sFile = FileFindNextFile($hSearch)
		If @error Then ExitLoop
		If $sFile = "." Or $sFile = ".." Then ContinueLoop
		If @extended Then
			If $bRek Then
				_FileDeleteAfterXDays($sPath & $sFile, $iDays, $bForceDel, $bRek, $bDirDel, $bLog)
				If $bDirDel Then
					$hEmpty = FileFindFirstFile($sPath & $sFile & '\*.*')
					If @error Then
						If $bForceDel Then FileSetAttrib($sPath & $sFile, '-R')
						$iRet = DirRemove($sPath & $sFile)
						If $bLog Then ConsoleWrite('Delete Folder "' & $sPath & $sFile & '" = ' & StringMid('No Yes', $iRet * 3 + 1, 3) & @CR)
					EndIf
					FileClose($hEmpty)
				EndIf
			EndIf
		Else
			$sDate = StringRegExpReplace(FileGetTime($sPath & $sFile, 0, 1), '(\d{4})(\d{2})(\d{2})(.*)', '$1/$2/$3')
			If _DateDiff('D', $sDate, _NowCalc()) > $iDays Then
				If $bForceDel Then FileSetAttrib($sPath & $sFile, '-R')
				$iRet = FileDelete($sPath & $sFile)
				If $bLog Then ConsoleWrite('Delete File "' & $sPath & $sFile & '" = ' & StringMid('No Yes', $iRet * 3 + 1, 3) & @CR)
			EndIf
		EndIf
	WEnd
	FileClose($hSearch)
	Return 1
EndFunc   ;==>_FileDeleteAfterXDays



Func _Load_Compiler_settings()
	GUICtrlSetData($compile_compression_combo, "")
	$readen_compress = IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_compression", "normal")
	If $readen_compress = "lowest" Then $tmp = _Get_langstr(565)
	If $readen_compress = "low" Then $tmp = _Get_langstr(566)
	If $readen_compress = "normal" Then $tmp = _Get_langstr(567)
	If $readen_compress = "high" Then $tmp = _Get_langstr(568)
	If $readen_compress = "highest" Then $tmp = _Get_langstr(569)
	GUICtrlSetData($compile_compression_combo, _Get_langstr(569) & "|" & _Get_langstr(568) & "|" & _Get_langstr(567) & "|" & _Get_langstr(566) & "|" & _Get_langstr(565), $tmp)

	$mainfile = IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "mainfile", "file")
	$Default_Name = StringTrimRight($mainfile, StringLen($mainfile) - StringInStr($mainfile, ".", 0, -1) + 1)
	$exename = IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_exename", $Default_Name)
	If Not StringInStr($exename, ".exe") And Not StringInStr($exename, ".a3x") Then $exename = $exename & ".exe"
	GUICtrlSetData($Compile_filenameinput, $exename)

	GUICtrlSetData($Compile_Iconpath, IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_exeicon", "%isnstudiodir%\autoitstudioicon.ico"))
	_SetImage($Compile_vorschauicon, _ISN_Variablen_aufloesen(GUICtrlRead($Compile_Iconpath)))

	If IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_mode", "2") = "1" Then
		GUICtrlSetState($Kompilieren_Einstellungen_direktimProjektordnerKompilieren_Checkbox, $GUI_CHECKED)
		GUICtrlSetState($Kompilieren_Einstellungen_Projekt_in_Ordner_Bereitstellen_Checkbox, $GUI_UNCHECKED)
	Else
		GUICtrlSetState($Kompilieren_Einstellungen_direktimProjektordnerKompilieren_Checkbox, $GUI_UNCHECKED)
		GUICtrlSetState($Kompilieren_Einstellungen_Projekt_in_Ordner_Bereitstellen_Checkbox, $GUI_CHECKED)
	EndIf


	If IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_runaftercompile", "false") = "true" Then
		GUICtrlSetState($compile_chckboxrun, $GUI_CHECKED)
	Else
		GUICtrlSetState($compile_chckboxrun, $GUI_UNCHECKED)
	EndIf

	If IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_openaftercompile", "true") = "true" Then
		GUICtrlSetState($compile_chckboxopen, $GUI_CHECKED)
	Else
		GUICtrlSetState($compile_chckboxopen, $GUI_UNCHECKED)
	EndIf

	If IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_x64", "false") = "true" Then
		GUICtrlSetState($compile_x64_checkbox, $GUI_CHECKED)
	Else
		GUICtrlSetState($compile_x64_checkbox, $GUI_UNCHECKED)
	EndIf

	If IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_source", "false") = "true" Then
		GUICtrlSetState($compile_source, $GUI_CHECKED)
	Else
		GUICtrlSetState($compile_source, $GUI_UNCHECKED)
	EndIf

	If IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_useupx", "false") = "true" Then
		GUICtrlSetState($compile_upx_checkbox, $GUI_CHECKED)
	Else
		GUICtrlSetState($compile_upx_checkbox, $GUI_UNCHECKED)
	EndIf

	If IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_console", "false") = "true" Then
		GUICtrlSetState($compile_chckboxconsole, $GUI_CHECKED)
	Else
		GUICtrlSetState($compile_chckboxconsole, $GUI_UNCHECKED)
	EndIf

	If IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_delete_empty_folders", "true") = "true" Then
		GUICtrlSetState($kompilieren_einstellungen_leere_ordner_entfernen_checkbox, $GUI_CHECKED)
	Else
		GUICtrlSetState($kompilieren_einstellungen_leere_ordner_entfernen_checkbox, $GUI_UNCHECKED)
	EndIf

	If IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_copy_project_resources", "true") = "true" Then
		GUICtrlSetState($kompilieren_einstellungen_projektressourcen_kopieren_checkbox, $GUI_CHECKED)
	Else
		GUICtrlSetState($kompilieren_einstellungen_projektressourcen_kopieren_checkbox, $GUI_UNCHECKED)
	EndIf


	_Kompilieren_Einstellungen_Radio_Events()
EndFunc   ;==>_Load_Compiler_settings

Func _Kompilieren_Einstellungen_Radio_Events()

	If GUICtrlRead($Kompilieren_Einstellungen_direktimProjektordnerKompilieren_Checkbox) = $GUI_CHECKED Then
		GUICtrlSetState($compile_source, $GUI_DISABLE)
		GUICtrlSetState($compile_chckboxopen, $GUI_DISABLE)
		GUICtrlSetState($projekteinstellungen_kompilieren_Ordnerpfad_button, $GUI_DISABLE)
		GUICtrlSetState($projekteinstellungen_kompilieren_Ordnerpfad_input, $GUI_DISABLE)
		GUICtrlSetState($projekteinstellungen_kompilieren_Ordnerpfad_vorschau_label, $GUI_DISABLE)
		GUICtrlSetState($projekteinstellungen_kompilieren_Ordnerpfad_label, $GUI_DISABLE)
		GUICtrlSetState($kompilieren_einstellungen_leere_ordner_entfernen_checkbox, $GUI_DISABLE)
		GUICtrlSetState($kompilieren_einstellungen_projektressourcen_kopieren_checkbox, $GUI_DISABLE)
	Else
		GUICtrlSetState($compile_source, $GUI_ENABLE)
		GUICtrlSetState($compile_chckboxopen, $GUI_ENABLE)
		GUICtrlSetState($projekteinstellungen_kompilieren_Ordnerpfad_button, $GUI_ENABLE)
		GUICtrlSetState($projekteinstellungen_kompilieren_Ordnerpfad_input, $GUI_ENABLE)
		GUICtrlSetState($projekteinstellungen_kompilieren_Ordnerpfad_vorschau_label, $GUI_ENABLE)
		GUICtrlSetState($projekteinstellungen_kompilieren_Ordnerpfad_label, $GUI_ENABLE)
		GUICtrlSetState($kompilieren_einstellungen_leere_ordner_entfernen_checkbox, $GUI_ENABLE)
		GUICtrlSetState($kompilieren_einstellungen_projektressourcen_kopieren_checkbox, $GUI_ENABLE)
		If GUICtrlRead($kompilieren_einstellungen_projektressourcen_kopieren_checkbox) = $GUI_CHECKED Then
			GUICtrlSetState($compile_source, $GUI_ENABLE)
		Else
			GUICtrlSetState($compile_source, $GUI_DISABLE)
			GUICtrlSetState($compile_source, $GUI_UNCHECKED)
		EndIf

	EndIf

EndFunc   ;==>_Kompilieren_Einstellungen_Radio_Events

Func _save_Compiler_settings()
	IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_exeicon", GUICtrlRead($Compile_Iconpath))

	Local $exename = GUICtrlRead($Compile_filenameinput)
	$exename = StringReplace($exename, "<", "")
	$exename = StringReplace($exename, ">", "")
	$exename = StringReplace($exename, "?", "")
	$exename = StringReplace($exename, "!", "")
	$exename = StringReplace($exename, "\", "")
	$exename = StringReplace($exename, "/", "")
	$exename = StringReplace($exename, "*", "")
	$exename = StringReplace($exename, "|", "")
	$exename = StringReplace($exename, '"', "")
	$exename = StringReplace($exename, ':', "")
	If Not StringInStr($exename, ".exe") And Not StringInStr($exename, ".a3x") Then $exename = $exename & ".exe"
	IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_exename", $exename)

	If GUICtrlRead($Kompilieren_Einstellungen_direktimProjektordnerKompilieren_Checkbox) = $GUI_CHECKED Then
		IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_mode", "1")
	Else
		IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_mode", "2")
	EndIf

	If GUICtrlRead($kompilieren_einstellungen_leere_ordner_entfernen_checkbox) = $GUI_CHECKED Then
		IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_delete_empty_folders", "true")
	Else
		IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_delete_empty_folders", "false")
	EndIf


	If GUICtrlRead($compile_source) = $GUI_CHECKED Then
		IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_source", "true")
	Else
		IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_source", "false")
	EndIf

	If GUICtrlRead($compile_x64_checkbox) = $GUI_CHECKED Then
		IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_x64", "true")
	Else
		IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_x64", "false")
	EndIf

	If GUICtrlRead($compile_chckboxopen) = $GUI_CHECKED Then
		IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_openaftercompile", "true")
	Else
		IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_openaftercompile", "false")
	EndIf

	If GUICtrlRead($compile_chckboxrun) = $GUI_CHECKED Then
		IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_runaftercompile", "true")
	Else
		IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_runaftercompile", "false")
	EndIf

	If GUICtrlRead($compile_upx_checkbox) = $GUI_CHECKED Then
		IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_useupx", "true")
	Else
		IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_useupx", "false")
	EndIf

	If GUICtrlRead($compile_chckboxconsole) = $GUI_CHECKED Then
		IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_console", "true")
	Else
		IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_console", "false")
	EndIf

	If GUICtrlRead($kompilieren_einstellungen_projektressourcen_kopieren_checkbox) = $GUI_CHECKED Then
		IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_copy_project_resources", "true")
	Else
		IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_copy_project_resources", "false")
	EndIf

	$tmp = GUICtrlRead($compile_compression_combo)
	If $tmp = _Get_langstr(565) Then $readen_compress = "lowest"
	If $tmp = _Get_langstr(566) Then $readen_compress = "low"
	If $tmp = _Get_langstr(567) Then $readen_compress = "normal"
	If $tmp = _Get_langstr(568) Then $readen_compress = "high"
	If $tmp = _Get_langstr(569) Then $readen_compress = "highest"
	IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_compression", $readen_compress)

EndFunc   ;==>_save_Compiler_settings

Func _Show_Compile()
	If $Offenes_Projekt = "" Then Return
	If _Pruefe_auf_Type3_Plugin($Plugin_Platzhalter_KompilierenEinstellungen) <> -1 Then Return ;Platzhalter für Plugin
	If $Studiomodus = 2 Then
		_Zeige_AutoIt3Wrapper_GUI()
		Return
	EndIf

	If FileExists($autoit2exe) = 0 Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(299), 0, $studiofenster)
		Return
	EndIf

	_Zeige_Projekteinstellungen("compile")
EndFunc   ;==>_Show_Compile



Func _GetShortName($sPath)
	If FileExists($sPath) Then Return FileGetShortName($sPath, 1)

	Local $RetPath = ""
	Local $TailingSlashs = StringRegExpReplace($sPath, '(?i)^.*[^\\]', '')

	If StringInStr($sPath, "\") Then
		Local $sPathArr = StringSplit($sPath, "\")
		For $i = 1 To UBound($sPathArr) - 1
			If StringLen($sPathArr[$i]) > 8 Then
				$RetPath &= StringLeft(StringStripWS($sPathArr[$i], 8), 6) & "~1\"
			Else
				$RetPath &= $sPathArr[$i] & "\"
			EndIf
		Next
		$RetPath = StringRegExpReplace($RetPath, '\\+\z', '')
		$RetPath &= $TailingSlashs
	Else
		If StringLen($sPath) > 8 Then
			$RetPath = StringLeft(StringStripWS($sPath, 8), 6) & "~1"
		Else
			$RetPath = $sPath
		EndIf
	EndIf
	Return StringUpper($RetPath)
EndFunc   ;==>_GetShortName

Func _Start_Compiling_Adlib()
	AdlibRegister("_Start_Compiling", 250)
	Return $compilingGUI
EndFunc   ;==>_Start_Compiling_Adlib


Func _Start_Compiling()
	AdlibUnRegister("_Start_Compiling")
	If $Offenes_Projekt = "" Then Return
	If $SKRIPT_LAUEFT = 1 And $Erweitertes_debugging = "true" Then Return
	If _Pruefe_auf_Type3_Plugin($Plugin_Platzhalter_ProjektKompilieren) <> -1 Then Return ;Platzhalter für Plugin
	If $Studiomodus = 2 Then
		_Kompilieren_Editormodus()
		Return
	EndIf



	_STOPSCRIPT() ;Wenn noch ein Skript läuft -> Stoppen!

	_Load_Compiler_settings()

	If $Templatemode = 1 Then
		If _Check_ISN_Error_Behavior(_Get_langstr(386)) = 0 Then MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(386), 0, $studiofenster)
		Return
	EndIf

	If FileExists($autoit2exe) = 0 Then
		If _Check_ISN_Error_Behavior(_Get_langstr(299)) = 0 Then MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(299), 0, $studiofenster)
		Return
	EndIf

	If Not FileExists(_ISN_Variablen_aufloesen(GUICtrlRead($Compile_Iconpath))) Then
		If _Check_ISN_Error_Behavior(_Get_langstr(664)) = 0 Then MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(664), 0, $studiofenster)
		Return
	EndIf

	If Not FileExists($AutoIt3Wrapper_exe_path) Then
		If _Check_ISN_Error_Behavior(_Get_langstr(1032)) = 0 Then MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1032), 0, $studiofenster)
		Return
	EndIf

	GUICtrlSetData($Statuscompile, _Get_langstr(244))
	GUISetState(@SW_SHOW, $compilingGUI)
	GUISetState(@SW_DISABLE, $StudioFenster)
	_Save_All_only_script_tabs() ;Speichern aller Skintilla Tabs
	Sleep(500)



	$Compile_Mode = IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_mode", "2")
	$Kompilieren_laeuft = 1
	If $Compile_Mode = "2" Then
		;Projekt in neuem Ordner bereitstellen
		GUICtrlSetData($Statuscompile, _Get_langstr(243))

		If $releasemode = 1 Then
			$zielpfad = _ISN_Variablen_aufloesen($releasefolder)
			DirCreate($zielpfad)
			DirRemove($zielpfad & "\" & _ISN_Variablen_aufloesen(_ProjectISN_Config_Read("compile_finished_project_dir", "%projectname%")), 1)
			DirCreate($zielpfad & "\" & _ISN_Variablen_aufloesen(_ProjectISN_Config_Read("compile_finished_project_dir", "%projectname%")))
			$zielpfad = $zielpfad & "\" & _ISN_Variablen_aufloesen(_ProjectISN_Config_Read("compile_finished_project_dir", "%projectname%"))
		EndIf

		If $releasemode = 2 Then
			DirRemove($Arbeitsverzeichnis & "\data\cache\tempcompile", 1)
			$directory = _ProjectISN_Config_Read("compile_finished_project_dir", "%projectname%")
			$directory = StringReplace($directory, "%projectname%", "")
			$directory = StringReplace($directory, "\\", "")
			If StringLeft($directory, 1) = "\" Then $directory = StringTrimLeft($directory, 1)
			$directory = _ISN_Variablen_aufloesen($directory)
			If $directory <> "" Then $directory = "\" & $directory
			$zielpfad = $Offenes_Projekt & "\" & _ISN_Variablen_aufloesen($releasefolder) & $directory
			DirCreate($zielpfad)
			DirRemove($zielpfad, 1)
			DirCreate($zielpfad)
			$zielpfad = $Arbeitsverzeichnis & "\data\cache\tempcompile"
			DirCreate($zielpfad)
		EndIf
	Else
		;Projekt in Projektordner Kompilieren
		$zielpfad = $Offenes_Projekt
	EndIf



	Sleep(500)


	$mainfile = IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "mainfile", "")
	$Default_Name = StringTrimRight($mainfile, StringLen($mainfile) - StringInStr($mainfile, ".", 0, -1) + 1)

	Local $exename = IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_exename", $Default_Name)
	$exename = StringReplace($exename, "?", "")
	$exename = StringReplace($exename, "=", "")
	$exename = StringReplace($exename, ",", "")
	$exename = StringReplace($exename, "\", "")
	$exename = StringReplace($exename, "/", "")
	$exename = StringReplace($exename, '"', "")
	$exename = StringReplace($exename, "<", "")
	$exename = StringReplace($exename, ">", "")
	$exename = StringReplace($exename, "*", "")
	$exename = StringReplace($exename, "|", "")
	If Not StringInStr($exename, ".exe") And Not StringInStr($exename, ".a3x") Then $exename = $exename & ".exe"
	_Clear_Debuglog()


	$Adittional_Prams = ""
	If GUICtrlRead($compile_x64_checkbox) = $GUI_CHECKED Then $Adittional_Prams = $Adittional_Prams & "/x64 "
	If GUICtrlRead($compile_upx_checkbox) = $GUI_UNCHECKED Then $Adittional_Prams = $Adittional_Prams & "/nopack "
;~ 	if GuiCtrlRead($compile_compression_combo) = $GUI_UNCHECKED Then $Adittional_Prams = $Adittional_Prams & "/nopack "
	If GUICtrlRead($compile_chckboxconsole) = $GUI_CHECKED Then $Adittional_Prams = $Adittional_Prams & "/console "
	$readen_compress = IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "compile_compression", "normal")
	If $readen_compress = "lowest" Then $Adittional_Prams = $Adittional_Prams & "/comp 0 "
	If $readen_compress = "low" Then $Adittional_Prams = $Adittional_Prams & "/comp 1 "
	If $readen_compress = "normal" Then $Adittional_Prams = $Adittional_Prams & "/comp 2 "
	If $readen_compress = "high" Then $Adittional_Prams = $Adittional_Prams & "/comp 3 "
	If $readen_compress = "highest" Then $Adittional_Prams = $Adittional_Prams & "/comp 4 "

	$iconpath = _ISN_Variablen_aufloesen(GUICtrlRead($Compile_Iconpath))
	$iconpath = _ISN_Variablen_aufloesen($iconpath)

	;Makro "vor Projekt kompilieren"
	GUICtrlSetData($Statuscompile, _Get_langstr(879))
	_run_rule($Section_Trigger_BeforeProjectCompile)
	Sleep(200)

	;Zusätzliche Dateien & Hauptdatei kompilieren
	$Dateien = IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "additional_files_to_compile", "")
	If Not StringInStr($Dateien, _ISN_Pfad_durch_Variablen_ersetzen($Offenes_Projekt & "\" & IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "mainfile", ""))) Then $Dateien = _ISN_Pfad_durch_Variablen_ersetzen($Offenes_Projekt & "\" & IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "mainfile", "")) & "|" & $Dateien
	If StringRight($Dateien, 1) = "|" Then $Dateien = StringTrimRight($Dateien, 1)
	$additional_files_array = StringSplit($Dateien, "|", 2)
	If IsArray($additional_files_array) Then
		For $y = 0 To UBound($additional_files_array) - 1
			If $Kompilieren_laeuft = 0 Then ExitLoop
			If $additional_files_array[$y] = "" Then ContinueLoop
			If $additional_files_array[$y] = "|" Then ContinueLoop
			If Not FileExists(_ISN_Variablen_aufloesen($additional_files_array[$y])) Then ContinueLoop
			If _ISN_Variablen_aufloesen($additional_files_array[$y]) = $Offenes_Projekt & "\" & $mainfile Then
				;Hauptdatei


;~ 				$Console_Bluemode = 1
				GUICtrlSetData($Statuscompile, _Get_langstr(245))
				$Zuletzt_Kompilierte_Datei_Pfad_au3 = $Offenes_Projekt & "\" & IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "mainfile", "") ;Dateipfad der zuletzt kompilierten Datei (.au3 Datei)

				;Dateiinhalt vor dem Kompilieren einlesen (sichern)
				Local $hFile = FileOpen($Zuletzt_Kompilierte_Datei_Pfad_au3, $FO_READ + FileGetEncoding($Zuletzt_Kompilierte_Datei_Pfad_au3))
				Local $Hauptdateiinhalt_vor_dem_Kompilieren = FileRead($hFile, FileGetSize($Zuletzt_Kompilierte_Datei_Pfad_au3))
				FileClose($hFile)
				If Not _System_benoetigt_double_byte_character_Support() Then $Hauptdateiinhalt_vor_dem_Kompilieren = _ANSI2UNICODE($Hauptdateiinhalt_vor_dem_Kompilieren)


				_run_rule($Section_Trigger_BeforeFileCompile) ;Makro "Vor datei kompilieren"
				$data = _RunReadStd('"' & FileGetShortName($autoitexe) & '" "' & FileGetShortName($AutoIt3Wrapper_exe_path) & '" /in "' & $Offenes_Projekt & "\" & IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "mainfile", "") & '" /out "' & $zielpfad & "\" & $exename & '" ' & $Adittional_Prams & ' /icon "' & $iconpath & '"', 0, $Offenes_Projekt, @SW_HIDE, 1, @TAB, 65001)
				$Zuletzt_Kompilierte_Datei_Pfad_exe = $zielpfad & "\" & $exename ;Dateipfad der zuletzt kompilierten Datei (.exe Datei)
				Dim $szDrive, $szDir, $szFName, $szExt
				$path = _PathSplit(IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "mainfile", ""), $szDrive, $szDir, $szFName, $szExt)
				If FileExists($Offenes_Projekt & "\" & _GetShortName($szFName) & "_Obfuscated" & $szExt) Then FileDelete($Offenes_Projekt & "\" & _GetShortName($szFName) & "_Obfuscated" & $szExt)
;~ 				If FileExists($Offenes_Projekt & "\" & _GetShortName($szFName) & "_stripped" & $szExt) Then FileDelete($Offenes_Projekt & "\" & _GetShortName($szFName) & "_stripped" & $szExt)
				If FileExists($Offenes_Projekt & "\" & $szFName & "_Obfuscated" & $szExt) Then FileDelete($Offenes_Projekt & "\" & $szFName & "_Obfuscated" & $szExt)
;~ 				If FileExists($Offenes_Projekt & "\" & $szFName & "_stripped" & $szExt) Then FileDelete($Offenes_Projekt & "\" & $szFName & "_stripped" & $szExt)
				If FileExists($Offenes_Projekt & "\" & _GetShortName(IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "mainfile", "")) & ".tbl") Then FileDelete($Offenes_Projekt & "\" & _GetShortName(IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "mainfile", "")) & ".tbl")
				If FileExists($Offenes_Projekt & "\" & IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "mainfile", "") & ".tbl") Then FileDelete($Offenes_Projekt & "\" & IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "mainfile", "") & ".tbl")
;~ 				$Console_Bluemode = 0
				_run_rule($Section_Trigger_AfterFileCompile) ;Makro "Nach datei kompilieren"
				Sleep(500)

				;Exit Codes Analysieren und ggf. Änderungen vornehmen
				If IsArray($data) Then
					If $data[1] <> 0 Then
						Switch _Check_ISN_Error_Behavior(StringReplace(_Get_langstr(1138), "%1", $szFName & $szExt))

							Case 0
								$result = MsgBox(262196, _Get_langstr(394), StringReplace(_Get_langstr(1138), "%1", $szFName & $szExt) & @CRLF & @CRLF & _Get_langstr(1140), 0, $compilingRule)
								If $result = 7 Then $Kompilieren_laeuft = 0 ;Stoppe weitere ausführung

							Case 1, 2
								$Kompilieren_laeuft = 0

						EndSwitch
					EndIf
				EndIf


			Else
				GUICtrlSetData($Statuscompile, StringReplace(_Get_langstr(1069), "%1", $additional_files_array[$y]))
				_AU3_aus_Projektbaum_Direkt_Kompilieren(_ISN_Variablen_aufloesen($additional_files_array[$y]), 1)
			EndIf
		Next
	EndIf




	If $Kompilieren_laeuft = 0 Then
		GUISetState(@SW_ENABLE, $StudioFenster)
		GUISetState(@SW_HIDE, $compilingGUI)
		Return
	EndIf

	Sleep(500)
	If $Compile_Mode = "2" Then
		;Projekt in neuem Ordner bereitstellen

		If GUICtrlRead($kompilieren_einstellungen_projektressourcen_kopieren_checkbox) = $GUI_CHECKED Then
			GUICtrlSetData($Statuscompile, _Get_langstr(246))
			_FileOperationProgress($Offenes_Projekt & "\*.*", $zielpfad, 1, $FO_COPY, $FOF_SIMPLEPROGRESS + $FOF_NOCONFIRMATION)
			DirRemove(_ISN_Variablen_aufloesen($zielpfad & "\" & $releasefolder), 1) ;Damit der Relase Ordner nicht nochmals im Release Ordner landet
		EndIf

		If GUICtrlRead($compile_source) = $GUI_UNCHECKED Then
			_File_Delete_Wild($zielpfad, ".isn")
			_File_Delete_Wild($zielpfad, ".au3")
			_File_Delete_Wild($zielpfad, ".isf")
		EndIf
	EndIf


	Sleep(1000)
	GUICtrlSetData($Statuscompile, _Get_langstr(247))

	If $Compile_Mode = "2" Then
		;Projekt in neuem Ordner bereitstellen

		;Leere Ordner löschen
		If GUICtrlRead($kompilieren_einstellungen_leere_ordner_entfernen_checkbox) = $GUI_CHECKED Then _delEmpty($zielpfad)
		If $releasemode = 2 Then
			$directory = _ProjectISN_Config_Read("compile_finished_project_dir", "%projectname%")
			$directory = StringReplace($directory, "%projectname%", "")
			$directory = StringReplace($directory, "\\", "")
			If StringLeft($directory, 1) = "\" Then $directory = StringTrimLeft($directory, 1)
			$directory = _ISN_Variablen_aufloesen($directory)
			If $directory <> "" Then $directory = "\" & $directory
			_FileOperationProgress($Arbeitsverzeichnis & "\data\cache\tempcompile\*.*", $Offenes_Projekt & "\" & _ISN_Variablen_aufloesen($releasefolder) & $directory, 1, $FO_MOVE, $FOF_SIMPLEPROGRESS + $FOF_NOCONFIRMATION)
			$zielpfad = $Offenes_Projekt & "\" & _ISN_Variablen_aufloesen($releasefolder)
		EndIf
	EndIf



	;Makro "Nach Projekt kompilieren"
	GUICtrlSetData($Statuscompile, _Get_langstr(879))
	_run_rule($Section_Trigger_AfterProjectCompile)
	Sleep(200)


	GUISetState(@SW_ENABLE, $StudioFenster)
	GUISetState(@SW_HIDE, $compilingGUI)
	_WinFlash($Studiofenster)
	_Earn_trophy(4, 1)

	If GUICtrlRead($compile_chckboxopen) = $GUI_CHECKED And $Compile_Mode = "2" Then ShellExecute($zielpfad)
	If GUICtrlRead($compile_chckboxrun) = $GUI_CHECKED Then
		Run(FileGetShortName($zielpfad & "\" & $exename))
	EndIf

	If _Pruefe_ob_Datei_geoeffnet($Offenes_Projekt & "\" & $mainfile) = "true" Then ;Lese Mainfile neu ein

		;Dateiinhalt nach dem Kompilieren einlesen, und falls sich etwas verändert hat -> Datei neu einlesen
		Local $hFile = FileOpen($Offenes_Projekt & "\" & $mainfile, $FO_READ + FileGetEncoding($Offenes_Projekt & "\" & $mainfile))
		Local $Hauptdateiinhalt_nach_dem_Kompilieren = FileRead($hFile, FileGetSize($Offenes_Projekt & "\" & $mainfile))
		FileClose($hFile)
		If Not _System_benoetigt_double_byte_character_Support() Then $Hauptdateiinhalt_nach_dem_Kompilieren = _ANSI2UNICODE($Hauptdateiinhalt_nach_dem_Kompilieren)

		If $Hauptdateiinhalt_nach_dem_Kompilieren <> $Hauptdateiinhalt_vor_dem_Kompilieren Then
			$tabpage = _GUICtrlTab_FindTab($htab, StringTrimLeft($Offenes_Projekt & "\" & $mainfile, StringInStr($Offenes_Projekt & "\" & $mainfile, "\", 0, -1)))
			If $tabpage <> -1 Then
				$res = _ArraySearch($Datei_pfad, $Offenes_Projekt & "\" & $mainfile)
				If $res <> -1 Then
					$tabpage = $res
				Else
					$tabpage = -1
				EndIf
			EndIf
			$old_cur_pos = Sci_GetCurrentPos($SCE_EDITOR[$tabpage])
			LoadEditorFile($SCE_EDITOR[$tabpage], $Offenes_Projekt & "\" & $mainfile)
			$FILE_CACHE[$tabpage] = Sci_GetLines($SCE_EDITOR[$tabpage])
			_Editor_Restore_Fold()
			Sci_SetCurrentPos($SCE_EDITOR[$tabpage], $old_cur_pos)
		EndIf
	EndIf
	$Kompilieren_laeuft = 0
	;_Update_Treeview() ;Zum Abschluss noch den Projektbaum aktualisieren
EndFunc   ;==>_Start_Compiling

Func _WinFlash($hGUI = "")
	If $hGUI = "" Then Return
	If Not WinActive($hGUI) Then WinFlash($hGUI)
EndFunc   ;==>_WinFlash

Func _delEmpty($dir)
	$folderList = _FileListToArray($dir, "*", 2)
	If @error <> 4 Then
		For $i = 1 To $folderList[0]
			_delEmpty($dir & "\" & $folderList[$i])
		Next
	EndIf
	$filelist = _FileListToArray($dir, -1, 0)
	If @error = 4 Then DirRemove($dir)
EndFunc   ;==>_delEmpty

Func _File_Delete_Wild($path, $filetype)
	$Search = FileFindFirstFile($path & "\*.*")
	If $Search <> -1 Then
		While 1
			$file = FileFindNextFile($Search)
			If @error Then ExitLoop
			If $file = "." Or $file = ".." Then ContinueLoop
			If StringInStr(FileGetAttrib($path & "\" & $file), "D") Then
				_File_Delete_Wild($path & "\" & $file, $filetype)
			Else
				If StringInStr($path & "\" & $file, $filetype) Then FileDelete($path & "\" & $file)
			EndIf
		WEnd
	EndIf
	FileClose($Search)

EndFunc   ;==>_File_Delete_Wild

Func _runhelp()
	If FileExists($helpfile) = 0 Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(301), 0, $studiofenster)
		Return
	EndIf
	ShellExecute($helpfile)

EndFunc   ;==>_runhelp


Func _Show_FormStudio_Generate_Code_Info()
	_Show_Warning("formstudio_confirmgeneratecodeinfo", 308, _Get_langstr(61), _Get_langstr(1012), _Get_langstr(7))
EndFunc   ;==>_Show_FormStudio_Generate_Code_Info

Func _Show_Warning($warningID, $icon, $titel = "", $text = "", $bt1_text = "", $bt2_text = "")
	if $warningID = "confirmexe" AND IniRead($Configfile, "warnings", $warningID, "0") = 1 then
		return IniRead($Configfile, "warnings", "confirmexe_choice", "yes")
	EndIf
	If IniRead($Configfile, "warnings", $warningID, "0") = 1 Then Return 0
	While 1
		If _IsPressed("01", $user32) = 0 Then ExitLoop
		Sleep(50)
	WEnd
	$text = StringReplace($text, "[BREAK]", @CRLF)

	_SetIconAlpha($Warnmeldung_ico, $bigiconsdll, $icon, 32, 32)

	GUICtrlSetData($Warnmeldung_titel, $titel)
	GUICtrlSetData($Warnmeldung_text, $text)
	WinSetTitle($warn, "", $titel)
	GUICtrlSetData($Warnmeldung_Button1, $bt1_text)
	GUICtrlSetData($Warnmeldung_Button2, $bt2_text)
	GUICtrlSetState($Warnmeldung_checkbox, $GUI_UNCHECKED)
	If $bt2_text = "" Then
		GUICtrlSetState($Warnmeldung_Button2, $GUI_HIDE)
	Else
		GUICtrlSetState($Warnmeldung_Button2, $GUI_SHOW)
	EndIf
	$return = 0
	GUISetState(@SW_SHOW, $warn)
	GUISetState(@SW_DISABLE, $StudioFenster)
	WinSetOnTop($warn, "", 1)
	While 1
		Sleep(50)
		If _WinAPI_GetFocus() = $warn Then
			If _IsPressed("20", $user32) Or _IsPressed("0D", $user32) Then
				$return = 1
				ExitLoop
			EndIf

			If _IsPressed("1B", $user32) Then
				$return = 2
				ExitLoop
			EndIf
		EndIf

		$a = GUIGetCursorInfo($warn)
		If Not IsArray($a) Then Return
		If $a[2] = 1 Then
			If $a[4] = $Warnmeldung_Button1 Then
				$return = 1
				if $warningID = "confirmexe" Then
					$return = "yes"
					IniWrite($Configfile, "warnings", "confirmexe_choice", "yes")
				EndIf
				ExitLoop
			EndIf
			If $a[4] = $Warnmeldung_Button2 Then
				$return = 2
				if $warningID = "confirmexe" Then
					$return = "no"
					IniWrite($Configfile, "warnings", "confirmexe_choice", "no")
				EndIf
				ExitLoop
			EndIf
		EndIf
	WEnd
	GUISetState(@SW_ENABLE, $StudioFenster)
	GUISetState(@SW_HIDE, $warn)
	If GUICtrlRead($Warnmeldung_checkbox) = $GUI_CHECKED Then IniWrite($Configfile, "warnings", $warningID, "1")
	Return $return
EndFunc   ;==>_Show_Warning

Func _In_Datei_suchen_Eintrag_oeffnen()
	If _GUICtrlListView_GetItemCount($in_dateien_suchen_gefundene_elemente_listview) = 0 Then Return
	$line = _GUICtrlListView_GetItemText($in_dateien_suchen_gefundene_elemente_listview, _GUICtrlListView_GetSelectionMark($in_dateien_suchen_gefundene_elemente_listview), 1)
	$line = $line - 1
	If $line < 1 Then $line = 1
	$Pfad = _GUICtrlListView_GetItemText($in_dateien_suchen_gefundene_elemente_listview, _GUICtrlListView_GetSelectionMark($in_dateien_suchen_gefundene_elemente_listview), 2)
	$Pfad = _ISN_Variablen_aufloesen($Pfad)


	$res = _ArraySearch($Datei_pfad, $Pfad)
	If $res <> -1 Then
		$alreadyopen = $res
	Else
		$alreadyopen = -1
	EndIf

	If $alreadyopen = -1 Then
		_openscriptfile($Pfad)
		_Add_File_to_Backuplist($Pfad)
		If $Offene_tabs > 14 Then _Earn_trophy(9, 2)
		_Fuege_Datei_zu_Zuletzt_Verwendete_Dateien($Pfad)
	Else
		If _GUICtrlTab_GetCurFocus($htab) <> $alreadyopen Then
			_GUICtrlTab_ActivateTabX($htab, $alreadyopen)
			_Show_Tab($alreadyopen)
		EndIf
	EndIf

	Local $SCE_Handle = $SCE_EDITOR[_GUICtrlTab_GetCurFocus($htab)]
	Local $findWhat = GUICtrlRead($in_dateien_suchen_suchtext_input)
	SendMessage($SCE_Handle, $SCI_SETSEARCHFLAGS, 0, 0)
	If $autoit_editor_encoding = "2" Then $findWhat = _UNICODE2ANSI($findWhat)
	$res = Sci_Search($SCE_Handle, $findWhat, Sci_GetLineStartPos($SCE_Handle, $line), 0) ;and mark finded stuff
	If $res = -1 Then Return
	$start = SendMessage($SCE_Handle, $SCI_GETTARGETSTART, 0, 0) ;
	$end = SendMessage($SCE_Handle, $SCI_GETTARGETEND, 0, 0)

	SendMessage($SCE_Handle, $SCI_SETYCARETPOLICY, $CARET_EVEN + $CARET_STRICT, 0)
	SendMessage($SCE_Handle, $SCI_SETXCARETPOLICY, $CARET_EVEN + $CARET_STRICT, 0)
	SendMessage($SCE_Handle, $SCI_ENSUREVISIBLEENFORCEPOLICY, $line, 0) ;
	SendMessage($SCE_Handle, $SCI_GOTOLINE, $line, 0)
	SendMessage($SCE_Handle, $SCI_SETYCARETPOLICY, $CARET_EVEN, 0)
	SendMessage($SCE_Handle, $SCI_SETXCARETPOLICY, $CARET_SLOP + $CARET_EVEN, 50)

	SetSelection($start, $end)


EndFunc   ;==>_In_Datei_suchen_Eintrag_oeffnen

Func _In_Dateien_Suchen_exportiere_Liste_als_csv()
	If _GUICtrlListView_GetItemCount($in_dateien_suchen_gefundene_elemente_listview) = 0 Then Return
	_Lock_Plugintabs("lock")
	If $Skin_is_used = "true" Then
		$line = _WinAPI_SaveFileDlg(_Get_langstr(740), "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}", "csv (*.csv)", 0, "export.csv", '', BitOR($OFN_PATHMUSTEXIST, $OFN_FILEMUSTEXIST, $OFN_HIDEREADONLY), $OFN_EX_NOPLACESBAR, 0, 0, $in_ordner_nach_text_suchen_gui)
	Else
		$line = FileSaveDialog(_Get_langstr(740), "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}", "csv (*.csv)", 18, "export.csv", $in_ordner_nach_text_suchen_gui)
	EndIf
	_Lock_Plugintabs("unlock")
	If $line = "" Then Return
	If @error > 0 Then Return
	FileChangeDir(@ScriptDir)
	_GUICtrlListView_SaveCSV($in_dateien_suchen_gefundene_elemente_listview, $line)
	MsgBox(262144 + 64, _Get_langstr(61), _Get_langstr(164), 0, $in_ordner_nach_text_suchen_gui)
EndFunc   ;==>_In_Dateien_Suchen_exportiere_Liste_als_csv

Func _In_Dateien_Suchen_Datei_auswaehlen()
	_Lock_Plugintabs("lock")
	If $Skin_is_used = "true" Then
		$var = _WinAPI_OpenFileDlg(_Get_langstr(187), $Offenes_Projekt, "All (*.*)", 0, '', '', BitOR($OFN_PATHMUSTEXIST, $OFN_FILEMUSTEXIST, $OFN_HIDEREADONLY), $OFN_EX_NOPLACESBAR, 0, 0, $in_ordner_nach_text_suchen_gui)
	Else
		$var = FileOpenDialog(_Get_langstr(187), $Offenes_Projekt, "All (*.*)", 1 + 2, "", $in_ordner_nach_text_suchen_gui)
	EndIf

	_Lock_Plugintabs("unlock")
	FileChangeDir(@ScriptDir)
	If @error Then Return
	If $var = "" Then Return
	$var = _ISN_Pfad_durch_Variablen_ersetzen($var)
	GUICtrlSetData($in_dateien_suchen_ordner_input, $var)
EndFunc   ;==>_In_Dateien_Suchen_Datei_auswaehlen

Func _Toggle_In_Dateien_Suchen()
	If $Offenes_Projekt = "" Then Return
	$state = WinGetState($in_ordner_nach_text_suchen_gui, "")
	If BitAND($state, 2) Then
		GUISetState(@SW_HIDE, $in_ordner_nach_text_suchen_gui)
	Else
		GUISetState(@SW_SHOW, $in_ordner_nach_text_suchen_gui)
		_WinAPI_SetFocus(ControlGetHandle($in_ordner_nach_text_suchen_gui, "", $in_dateien_suchen_suchtext_input))
	EndIf
EndFunc   ;==>_Toggle_In_Dateien_Suchen

Func _ISN_SCI_Search_switch_to_Search_in_Files()
	If $Offenes_Projekt = "" Then Return
	GUISetState(@SW_HIDE, $fFind1)
	GUISetState(@SW_SHOW, $in_ordner_nach_text_suchen_gui)
	_WinAPI_SetFocus(ControlGetHandle($in_ordner_nach_text_suchen_gui, "", $in_dateien_suchen_suchtext_input))
EndFunc   ;==>_ISN_SCI_Search_switch_to_Search_in_Files

; #FUNCTION# ====================================================================================================================
; Name ..........: _FindInFile
; Description ...: Search for a string within files located in a specific directory.
; Syntax ........: _FindInFile($sSearch, $sFilePath[, $sMask = '*'[, $fRecursive = True[, $fLiteral = Default[,
;                  $fCaseSensitive = Default[, $fDetail = Default]]]]])
; Parameters ....: $sSearch             - The keyword to search for.
;                  $sFilePath           - The folder location of where to search.
;                  $sMask               - [optional] A list of filetype extensions separated with ';' e.g. '*.au3;*.txt'. Default is all files.
;                  $fRecursive          - [optional] Search within subfolders. Default is True.
;                  $fLiteral            - [optional] Use the string as a literal search string. Default is False.
;                  $fCaseSensitive      - [optional] Use Search is case-sensitive searching. Default is False.
;                  $fDetail             - [optional] Show filenames only. Default is False.
;                  $regex          		- [optional] Search as regex
; Return values .: Success - Returns a one-dimensional and is made up as follows:
;                            $aArray[0] = Number of rows
;                            $aArray[1] = 1st file
;                            $aArray[n] = nth file
;                  Failure - Returns an empty array and sets @error to non-zero
; Author ........: guinness
; Remarks .......: For more details: http://ss64.com/nt/findstr.html
; Example .......: Yes
; ===============================================================================================================================
Func _FindInFile($sSearch, $sFilePath, $sMask = '*', $fRecursive = True, $fLiteral = Default, $fCaseSensitive = Default, $fDetail = Default, $regex = False)
	If $NewFindInStrInstancesAllowed = 0 Then Return
	Local $sCaseSensitive = $fCaseSensitive ? '' : '/i', $sDetail = $fDetail ? '/n' : '/m', $sRecursive = ($fRecursive Or $fRecursive = Default) ? '/s' : ''
	$fLiteral_str = " "
	If $fLiteral Then
		$fLiteral_str = ' /c:'
	EndIf

	If $sMask = Default Then
		$sMask = '*'
	EndIf
	Local $Weitere_Optionen = "/P "
	If $regex = True Then $Weitere_Optionen = $Weitere_Optionen & "/R "
	$Weitere_Optionen = StringStripWS($Weitere_Optionen, 3)
	$FileAttrib = FileGetAttrib($sFilePath)
	$sFilePath = StringRegExpReplace($sFilePath, '[\\/]+$', '')
	If StringInStr($FileAttrib, "D", 1) Then $sFilePath = $sFilePath & '\'
	Local Const $aMask = StringSplit($sMask, ';')
	Local $sOutput = ''
	For $i = 1 To $aMask[0]
		If StringInStr($FileAttrib, "D", 1) Then
			$FindInFile_iPID = Run(@ComSpec & ' /c ' & 'findstr ' & $Weitere_Optionen & ' ' & $sCaseSensitive & ' ' & $sDetail & ' ' & $sRecursive & $fLiteral_str & '"' & $sSearch & '" "' & $sFilePath & $aMask[$i] & '"', @SystemDir, @SW_HIDE, $STDOUT_CHILD)
		Else
			$FindInFile_iPID = Run(@ComSpec & ' /c ' & 'findstr ' & $Weitere_Optionen & ' ' & $sCaseSensitive & ' ' & $sDetail & ' ' & $fLiteral_str & '"' & $sSearch & '" "' & $sFilePath & '"', @SystemDir, @SW_HIDE, $STDOUT_CHILD)
		EndIf

		While 1
			If Not ProcessExists($FindInFile_iPID) Then ExitLoop
			;Sleep(100)
		WEnd
		$sOutput &= StdoutRead($FindInFile_iPID)

	Next
	$sOutput = _WinAPI_MultiByteToWideChar($sOutput, 1, 0, True) ;Convert Multibyte Chars
	Return StringSplit(StringStripWS(StringStripCR($sOutput), BitOR($STR_STRIPLEADING, $STR_STRIPTRAILING)), @LF, 2)
EndFunc   ;==>_FindInFile

Func _In_Dateien_suchen_Suche_starten()
	If GUICtrlRead($in_dateien_suchen_suchtext_input) = "" Then
		_Input_Error_FX($in_dateien_suchen_suchtext_input)
		Return
	EndIf

	If GUICtrlRead($in_dateien_suchen_ordner_input) = "" Then
		_Input_Error_FX($in_dateien_suchen_ordner_input)
		Return
	EndIf

	If GUICtrlRead($in_dateien_suchen_dateitypen_input) = "" Then GUICtrlSetData($in_dateien_suchen_dateitypen_input, "*")

	$Ordner = GUICtrlRead($in_dateien_suchen_ordner_input)
	$Ordner = _ISN_Variablen_aufloesen($Ordner) ;Varaiblen auflösen

	GUICtrlSetData($in_dateien_suchen_suchtext_input, GUICtrlRead($in_dateien_suchen_suchtext_input), GUICtrlRead($in_dateien_suchen_suchtext_input))

	$CaseSensitive = False
	If GUICtrlRead($in_dateien_suchen_grosskleinschreibung_checkbox) = $GUI_CHECKED Then $CaseSensitive = True

	$Recursive = True
	If GUICtrlRead($in_dateien_suchen_unterordner_checkbox) = $GUI_UNCHECKED Then $Recursive = False

	$regex = False
	If GUICtrlRead($in_dateien_suchen_regex_checkbox) = $GUI_CHECKED Then $regex = True

	$wholeword = True
	If GUICtrlRead($in_dateien_suchen_ganzewoerter_checkbox) = $GUI_UNCHECKED Then $wholeword = False

	$NewFindInStrInstancesAllowed = 1
	WinSetTitle($ISN_In_Ordner_nach_Text_Suchen_Suche_laeuft_gui, "", _Get_langstr(1189))
	_WinAPI_SetWindowLong($ISN_In_Ordner_nach_Text_Suchen_Suche_laeuft_gui, $GWL_HWNDPARENT, $in_ordner_nach_text_suchen_gui)
	GUISetState(@SW_SHOW, $ISN_In_Ordner_nach_Text_Suchen_Suche_laeuft_gui)
	GUISetState(@SW_DISABLE, $in_ordner_nach_text_suchen_gui)
	Local $Gefundene_Elemente_Array = _FindInFile(GUICtrlRead($in_dateien_suchen_suchtext_input), $Ordner, GUICtrlRead($in_dateien_suchen_dateitypen_input), $Recursive, $wholeword, $CaseSensitive, True, $regex) ; Search for 'findinfile' within the @ScripDir and only in .au3 & .txt files.
	_GUICtrlListView_DeleteAllItems(GUICtrlGetHandle($in_dateien_suchen_gefundene_elemente_listview))
	If Not IsArray($Gefundene_Elemente_Array) Then
		GUISetState(@SW_ENABLE, $in_ordner_nach_text_suchen_gui)
		GUISetState(@SW_HIDE, $ISN_In_Ordner_nach_Text_Suchen_Suche_laeuft_gui)
		Return
	EndIf
	_GUICtrlListView_BeginUpdate($in_dateien_suchen_gefundene_elemente_listview)

	$FileAttrib = FileGetAttrib($Ordner)

	For $Count = 0 To UBound($Gefundene_Elemente_Array) - 1
		$String = $Gefundene_Elemente_Array[$Count]

		;Ausgabe aufbereiten
		If StringInStr($FileAttrib, "D", 1) Then
			$String = StringReplace($String, ":", "[SYS]", 1)
			$String = StringReplace($String, ":", "[STRBREAK]", 1)
			$String = StringReplace($String, ":", "[STRBREAK]", 1)
			$String = StringReplace($String, "[SYS]", ":")
		Else
			$String = StringReplace($String, ":", "[STRBREAK]", 1)
		EndIf

		;Und splitten
		$string_splitted = StringSplit($String, "[STRBREAK]", 3)
		;ConsoleWrite($string&@crlf)

		If StringInStr($FileAttrib, "D", 1) Then
			If Not IsArray($string_splitted) Or UBound($string_splitted) < 3 Then ContinueLoop

			$Dateiname = $string_splitted[0]
			$Dateiname = _ISN_Pfad_durch_Variablen_ersetzen($Dateiname)

			$Gefundener_Text_Zeile = $string_splitted[1]
			$Gefundener_Text = $string_splitted[2]
		Else
			If Not IsArray($string_splitted) Or UBound($string_splitted) < 2 Then ContinueLoop

			$Dateiname = $Ordner
			$Dateiname = _ISN_Pfad_durch_Variablen_ersetzen($Dateiname)

			$Gefundener_Text_Zeile = $string_splitted[0]
			$Gefundener_Text = $string_splitted[1]

		EndIf

		_GUICtrlListView_AddItem($in_dateien_suchen_gefundene_elemente_listview, $Gefundener_Text)
		_GUICtrlListView_AddSubItem($in_dateien_suchen_gefundene_elemente_listview, _GUICtrlListView_GetItemCount($in_dateien_suchen_gefundene_elemente_listview) - 1, $Gefundener_Text_Zeile, 1)
		_GUICtrlListView_AddSubItem($in_dateien_suchen_gefundene_elemente_listview, _GUICtrlListView_GetItemCount($in_dateien_suchen_gefundene_elemente_listview) - 1, $Dateiname, 2)
	Next


	_GUICtrlListView_EndUpdate($in_dateien_suchen_gefundene_elemente_listview)
	GUISetState(@SW_ENABLE, $in_ordner_nach_text_suchen_gui)
	GUISetState(@SW_HIDE, $ISN_In_Ordner_nach_Text_Suchen_Suche_laeuft_gui)
EndFunc   ;==>_In_Dateien_suchen_Suche_starten


;-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------





;Eine der wichtigsten Funktionen
;Ohne diese würden Kontextmenüs, Toolbarbuttons und weitere Dinge ohne Funktion bleiben

Func _InputCheck($hWndGUI, $MsgID, $wParam, $lParam)
	;Erkenne Scintilla Control
	If _WinAPI_GetClassName($lParam) = "Scintilla" Then Return 'GUI_RUNDEFMSG'

	$nID = BitAND($wParam, 0x0000FFFF)
	;-----

	If WinActive($New_file_GUI) And _IsPressed("0D", $user32) And $wParam = 1 Then _Make_New_File() ;enter in new file
;~ 	If WinActive($New_file_GUI) And _IsPressed("1B", $user32) And $wParam = 2 Then _HIDE_New_Filegui() ;esc in new file


;~ 	If $nID = $hTreeview2_searchinput Then
;~ 		If GUICtrlRead($hTreeview2_searchinput) = "" Then GUICtrlSetBkColor($hTreeview2_searchinput, $Skriptbaum_Suchfeld_Hintergrundfarbe)
;~ 	EndIf


;~ 	$Class = ControlGetFocus($Studiofenster)
;~ 	If ControlGetHandle($Studiofenster, "", "[CLASSNN:" & $Class & "]") = GUICtrlGetHandle($hTreeview2_searchinput) And $wParam = 1 Then
;~ 		If GUICtrlRead($hTreeview2_searchinput) <> "" Then _search_in_Scripttree()
;~ 		Return
;~ 	EndIf

	Switch $nID
		Case $ISN_In_Ordner_nach_Text_Suchen_Suche_laeuft_abbrechen_button
			If ProcessExists($FindInFile_iPID) Then
				Run(@ComSpec & " /c taskkill /F /PID " & $FindInFile_iPID, @SystemDir, @SW_HIDE)
				$NewFindInStrInstancesAllowed = 0
				$FindInFile_iPID = ""
			EndIf

		Case $SCI_EDITOR_CONTEXT_speichern
			_try_to_save_file(_GUICtrlTab_GetCurFocus($htab))
;~ 		Case $Skriptbaum_SetupMenu_Skriptbaum_konfigrieren
;~ 			_Zeige_Skriptbaum_Einstellungen()
;~ 		Case $Skriptbaum_SetupMenu_Filter
;~ 			_Zeige_Skriptbaum_FilterGUI()
		Case $SCI_EDITOR_CONTEXT_oeffneHilfe
			_open_helpfile_keyword()
		Case $SCI_EDITOR_CONTEXT_rueckgaengig, $ScripteditorDefaultContextMenu_undo
			_try_undo()
		Case $TabContextMenu_UseTabInDualMode, $ISN_FileMenu_UseTabInDualMode
			_ISN_DualEditor_SetTabForDualEditorMode(_GUICtrlTab_GetCurFocus($htab))
		Case $TabContextMenu_UndockTab, $ISN_FileMenu_UndockTab
			_ISN_Undock_Tab(_GUICtrlTab_GetCurFocus($htab))
		Case $SCI_EDITOR_CONTEXT_select_all, $ScripteditorDefaultContextMenu_select_all, $ISN_EditMenu_SelectAll
			_Scripteditor_Select_all()
		Case $SCI_EDITOR_CONTEXT_wiederholen, $ScripteditorDefaultContextMenu_redo
			_try_redo()
		Case $SCI_EDITOR_CONTEXT_kopieren, $ScripteditorDefaultContextMenu_copy
			_trytocopy()
		Case $SCI_EDITOR_CONTEXT_einfuegen, $ScripteditorDefaultContextMenu_paste
			_trytopaste()
		Case $SCI_EDITOR_CONTEXT_loeschen, $ScripteditorDefaultContextMenu_delete
			_trytodelete()
		Case $SCI_EDITOR_CONTEXT_suche
			_Toggle_Search()
		Case $SCI_EDITOR_CONTEXT_Auskommentieren
			_comment_out()
		Case $SCI_EDITOR_CONTEXT_ausschneiden, $ScripteditorDefaultContextMenu_cut
			_trytocut()
		Case $ISN_SearchMenu_SearchInFiles
			_Toggle_In_Dateien_Suchen()
		Case $ISN_HelpMenu_Donate
			_ISN_AutoIt_Studio_Spenden()
		Case $TabContextMenu_Item1
			_try_to_save_file(_GUICtrlTab_GetCurFocus($htab))
		Case $ISN_Toolbar_Save
			_try_to_save_file(_GUICtrlTab_GetCurFocus($htab))
		Case $ISN_FileMenu_OpenExternalFile, $ISN_Toolbar_OpenExternalFile
			_Try_to_open_external_file()
		Case $ISN_Toolbar_WindowInfoTool
			_open_windowinfotool()
		Case $SCI_EDITOR_CONTEXT_testselectedcode, $ISN_EditMenu_TestSelectedCode
			_Scintilla_Test_Selected_Codelines()
		Case $SCI_EDITOR_CONTEXT_debugtoMsgBox
			_Debug_to_msgbox()
		Case $SCI_EDITOR_CONTEXT_debugtoConsole
			_Debug_to_console()
		Case $ISN_ToolsMenu_DebugToMSGBox
			_Debug_to_msgbox()
		Case $ISN_ToolsMenu_DebugToConsole
			_Debug_to_console()
		Case $ISN_ToolsMenu_WindowInfoTool
			_open_windowinfotool()
		Case $ISN_FileMenu_LastUsedFiles_Slot1
			Call("_Oeffne_Zuletzt_Verwendete_Dateie", 0) ;Call muss verwendet werden da direkter aufruf einen Fehler in der GUI erzeugt (Fenster wird verschoben?!?=
		Case $ISN_FileMenu_LastUsedFiles_Slot2
			Call("_Oeffne_Zuletzt_Verwendete_Dateie", 1)
		Case $ISN_FileMenu_LastUsedFiles_Slot3
			Call("_Oeffne_Zuletzt_Verwendete_Dateie", 2)
		Case $ISN_FileMenu_LastUsedFiles_Slot4
			Call("_Oeffne_Zuletzt_Verwendete_Dateie", 3)
		Case $ISN_FileMenu_LastUsedFiles_Slot4
			Call("_Oeffne_Zuletzt_Verwendete_Dateie", 3)
		Case $ISN_FileMenu_LastUsedFiles_Slot5
			Call("_Oeffne_Zuletzt_Verwendete_Dateie", 4)
		Case $ISN_FileMenu_LastUsedFiles_Slot6
			Call("_Oeffne_Zuletzt_Verwendete_Dateie", 5)
		Case $ISN_FileMenu_LastUsedFiles_Slot7
			Call("_Oeffne_Zuletzt_Verwendete_Dateie", 6)
		Case $ISN_FileMenu_LastUsedFiles_Slot8
			Call("_Oeffne_Zuletzt_Verwendete_Dateie", 7)
		Case $ISN_FileMenu_LastUsedFiles_Slot9
			Call("_Oeffne_Zuletzt_Verwendete_Dateie", 8)
		Case $ISN_FileMenu_LastUsedFiles_Slot10
			Call("_Oeffne_Zuletzt_Verwendete_Dateie", 9)
		Case $ISN_FileMenu_Save
			_try_to_save_file(_GUICtrlTab_GetCurFocus($htab))
		Case $ISN_FileMenu_SaveAs
			_Speichern_unter()
		Case $TreeviewContextMenu_makroslot1
			If $TreeviewContextMenu_makroslot1 <> "" Then _ISN_execute_macroslot_01()
		Case $TreeviewContextMenu_makroslot2
			If $TreeviewContextMenu_makroslot2 <> "" Then _ISN_execute_macroslot_02()
		Case $TreeviewContextMenu_makroslot3
			If $TreeviewContextMenu_makroslot3 <> "" Then _ISN_execute_macroslot_03()
		Case $TreeviewContextMenu_makroslot4
			If $TreeviewContextMenu_makroslot4 <> "" Then _ISN_execute_macroslot_04()
		Case $TreeviewContextMenu_makroslot5
			If $TreeviewContextMenu_makroslot5 <> "" Then _ISN_execute_macroslot_05()
		Case $TreeviewContextMenu_makroslot6
			If $TreeviewContextMenu_makroslot6 <> "" Then _ISN_execute_macroslot_06()
		Case $TreeviewContextMenu_makroslot7
			If $TreeviewContextMenu_makroslot7 <> "" Then _ISN_execute_macroslot_07()
		Case $TreeviewContextMenu_makroslot8
			If $TreeviewContextMenu_makroslot8 <> "" Then _ISN_execute_macroslot_08()
		Case $TreeviewContextMenu_makroslot9
			If $TreeviewContextMenu_makroslot9 <> "" Then _ISN_execute_macroslot_09()
		Case $TreeviewContextMenu_makroslot10
			If $TreeviewContextMenu_makroslot10 <> "" Then _ISN_execute_macroslot_10()
		Case $ISN_Toolbar_MacroSlot1
			_ISN_execute_macroslot_01()
		Case $ISN_Toolbar_MacroSlot2
			_ISN_execute_macroslot_02()
		Case $ISN_Toolbar_MacroSlot3
			_ISN_execute_macroslot_03()
		Case $ISN_Toolbar_MacroSlot4
			_ISN_execute_macroslot_04()
		Case $ISN_Toolbar_MacroSlot5
			_ISN_execute_macroslot_05()
		Case $ISN_Toolbar_MacroSlot6
			_ISN_execute_macroslot_06()
		Case $ISN_Toolbar_MacroSlot7
			_ISN_execute_macroslot_07()
		Case $ISN_Toolbar_MacroSlot8
			_ISN_execute_macroslot_08()
		Case $ISN_Toolbar_MacroSlot9
			_ISN_execute_macroslot_09()
		Case $ISN_Toolbar_MacroSlot10
			_ISN_execute_macroslot_10()
		Case $ISN_ToolsMenu_MacroSlot1
			_ISN_execute_macroslot_01()
		Case $ISN_ToolsMenu_MacroSlot2
			_ISN_execute_macroslot_02()
		Case $ISN_ToolsMenu_MacroSlot3
			_ISN_execute_macroslot_03()
		Case $ISN_ToolsMenu_MacroSlot4
			_ISN_execute_macroslot_04()
		Case $ISN_ToolsMenu_MacroSlot5
			_ISN_execute_macroslot_05()
		Case $ISN_ToolsMenu_MacroSlot6
			_ISN_execute_macroslot_06()
		Case $ISN_ToolsMenu_MacroSlot7
			_ISN_execute_macroslot_07()
		Case $ISN_ToolsMenu_MacroSlot8
			_ISN_execute_macroslot_08()
		Case $ISN_ToolsMenu_MacroSlot9
			_ISN_execute_macroslot_09()
		Case $ISN_ToolsMenu_MacroSlot10
			_ISN_execute_macroslot_10()
		Case $ISN_HelpMenu_ShowISNHelp
			_Oeffne_ISN_hilfe()
		Case $ISN_HelpMenu_ShowAutoItHelp
			_runhelp()
		Case $ISN_Toolbar_SaveAllTabs
			_Save_All_tabs()
		Case $ISN_FileMenu_SaveAllTabs
			_Save_All_tabs()
		Case $ISN_ViewMenu_ToggleLeftArea
			_Toggle_hide_leftbar()
		Case $ISN_ViewMenu_ToggleRightArea
			_Toggle_hide_rightbar()
		Case $ISN_ViewMenu_ResetISNViews
			_Fenstergroessen_zuruecksetzen()
		Case $ISN_ViewMenu_ToggleBottomArea
			_Toggle_Fenster_unten()
		Case $ISN_HelpMenu_Trophies
			_Showtrophies()
		Case $ISN_ToolsMenu_MsgBoxGenerator
			_Toggle_msgboxcreator()
		Case $ISN_HelpMenu_Credits
			_Show_Credits()
		Case $ISN_HelpMenu_Info
			_Show_Info()
		Case $ISN_HelpMenu_Forum
			_Open_Forum()
		Case $ISN_HelpMenu_Bugtracker
			_Show_Bugtracker()
		Case $ISN_HelpMenu_SearchForUpdates
			_ISN_AutoIt_Studio_nach_updates_Suchen()
		Case $ISN_ProjectMenu_Compile
			_Start_Compiling()
		Case $ISN_ProjectMenu_CompileSettings
			_Show_Compile()
		Case $ISN_ProjectMenu_NewProject
			If MsgBox(262144 + 48 + 4, _Get_langstr(394), _Get_langstr(393), 0, $Studiofenster) = 6 Then
				_Close_Project()
				_Show_New_Project()
			EndIf
		Case $ISN_Toolbar_CloseProject
			_Close_Project()
		Case $ISN_ProjectMenu_CloseProject
			_Close_Project()
		Case $ISN_ProjectMenu_SelectFilesForCompile
			_Weitere_Dateien_zum_Kompilieren_waehlen()
		Case $ISN_EditMenu_Undo
			_try_undo()
		Case $ISN_EditMenu_Redo
			_try_redo()
		Case $ISN_Toolbar_Undo
			_try_undo()
		Case $ISN_Toolbar_Redo
			_try_redo()
		Case $ISN_EditMenu_Duplicate
			_Zeile_Duplizieren()
		Case $ISN_SearchMenu_AddAllMachtingWordToSelection
			_Scintilla_AddAllMatchingWordToSelection()
		Case $ISN_SearchMenu_AddPrevMachtingWordToSelection
			_Scintilla_AddPrevMatchingWordToSelection()
		Case $ISN_SearchMenu_AddNextMachtingWordToSelection
			_Scintilla_AddNextMatchingWordToSelection()
		Case $ISN_SearchMenu_JumpToFunc, $SCI_EDITOR_CONTEXT_JumpToFunc
			_Springe_zu_Func()
		Case $ISN_Toolbar_PluginSlot1
			If $ISN_Toolbar_PluginSlot1 <> "" Then
				If $Can_open_new_tab = 0 Then Return
				$Can_open_new_tab = 0
				Call("_open_plugintab", $Tools_menu_pluginitem1_exe, $Tools_menu_pluginitem1_exe, 1)
			EndIf

		Case $ISN_Toolbar_PluginSlot2
			If $ISN_Toolbar_PluginSlot2 <> "" Then
				If $Can_open_new_tab = 0 Then Return
				$Can_open_new_tab = 0
				Call("_open_plugintab", $Tools_menu_pluginitem2_exe, $Tools_menu_pluginitem2_exe, 1)
			EndIf

		Case $ISN_Toolbar_PluginSlot3
			If $ISN_Toolbar_PluginSlot3 <> "" Then
				If $Can_open_new_tab = 0 Then Return
				$Can_open_new_tab = 0
				Call("_open_plugintab", $Tools_menu_pluginitem3_exe, $Tools_menu_pluginitem3_exe, 1)
			EndIf

		Case $ISN_Toolbar_PluginSlot4
			If $ISN_Toolbar_PluginSlot4 <> "" Then
				If $Can_open_new_tab = 0 Then Return
				$Can_open_new_tab = 0
				Call("_open_plugintab", $Tools_menu_pluginitem4_exe, $Tools_menu_pluginitem4_exe, 1)
			EndIf

		Case $ISN_Toolbar_PluginSlot5
			If $ISN_Toolbar_PluginSlot5 <> "" Then
				If $Can_open_new_tab = 0 Then Return
				$Can_open_new_tab = 0
				Call("_open_plugintab", $Tools_menu_pluginitem5_exe, $Tools_menu_pluginitem5_exe, 1)
			EndIf

		Case $ISN_Toolbar_PluginSlot6
			If $ISN_Toolbar_PluginSlot6 <> "" Then
				If $Can_open_new_tab = 0 Then Return
				$Can_open_new_tab = 0
				Call("_open_plugintab", $Tools_menu_pluginitem6_exe, $Tools_menu_pluginitem6_exe, 1)
			EndIf

		Case $ISN_Toolbar_PluginSlot7
			If $ISN_Toolbar_PluginSlot7 <> "" Then
				If $Can_open_new_tab = 0 Then Return
				$Can_open_new_tab = 0
				Call("_open_plugintab", $Tools_menu_pluginitem7_exe, $Tools_menu_pluginitem7_exe, 1)
			EndIf

		Case $Toolbarmenu_pluginslot8
			If $Toolbarmenu_pluginslot8 <> "" Then
				If $Can_open_new_tab = 0 Then Return
				$Can_open_new_tab = 0
				Call("_open_plugintab", $Tools_menu_pluginitem8_exe, $Tools_menu_pluginitem8_exe, 1)
			EndIf

		Case $Toolbarmenu_pluginslot9
			If $Toolbarmenu_pluginslot9 <> "" Then
				If $Can_open_new_tab = 0 Then Return
				$Can_open_new_tab = 0
				Call("_open_plugintab", $Tools_menu_pluginitem9_exe, $Tools_menu_pluginitem9_exe, 1)
			EndIf

		Case $Toolbarmenu_pluginslot10
			If $Toolbarmenu_pluginslot10 <> "" Then
				If $Can_open_new_tab = 0 Then Return
				$Can_open_new_tab = 0
				Call("_open_plugintab", $Tools_menu_pluginitem10_exe, $Tools_menu_pluginitem10_exe, 1)
			EndIf

		Case $Tools_menu_pluginitem1
			If $Tools_menu_pluginitem1 <> "" Then
				If $Can_open_new_tab = 0 Then Return
				$Can_open_new_tab = 0
				Call("_open_plugintab", $Tools_menu_pluginitem1_exe, $Tools_menu_pluginitem1_exe, 1)
			EndIf

		Case $Tools_menu_pluginitem2
			If $Tools_menu_pluginitem2 <> "" Then
				If $Can_open_new_tab = 0 Then Return
				$Can_open_new_tab = 0
				Call("_open_plugintab", $Tools_menu_pluginitem2_exe, $Tools_menu_pluginitem2_exe, 1)
			EndIf

		Case $Tools_menu_pluginitem3
			If $Tools_menu_pluginitem3 <> "" Then
				If $Can_open_new_tab = 0 Then Return
				$Can_open_new_tab = 0
				Call("_open_plugintab", $Tools_menu_pluginitem3_exe, $Tools_menu_pluginitem3_exe, 1)
			EndIf

		Case $Tools_menu_pluginitem4
			If $Tools_menu_pluginitem4 <> "" Then
				If $Can_open_new_tab = 0 Then Return
				$Can_open_new_tab = 0
				Call("_open_plugintab", $Tools_menu_pluginitem4_exe, $Tools_menu_pluginitem4_exe, 1)
			EndIf

		Case $Tools_menu_pluginitem5
			If $Tools_menu_pluginitem5 <> "" Then
				If $Can_open_new_tab = 0 Then Return
				$Can_open_new_tab = 0
				Call("_open_plugintab", $Tools_menu_pluginitem5_exe, $Tools_menu_pluginitem5_exe, 1)
			EndIf

		Case $Tools_menu_pluginitem6
			If $Tools_menu_pluginitem6 <> "" Then
				If $Can_open_new_tab = 0 Then Return
				$Can_open_new_tab = 0
				Call("_open_plugintab", $Tools_menu_pluginitem6_exe, $Tools_menu_pluginitem6_exe, 1)
			EndIf

		Case $Tools_menu_pluginitem7
			If $Tools_menu_pluginitem7 <> "" Then
				If $Can_open_new_tab = 0 Then Return
				$Can_open_new_tab = 0
				Call("_open_plugintab", $Tools_menu_pluginitem7_exe, $Tools_menu_pluginitem7_exe, 1)
			EndIf

		Case $Tools_menu_pluginitem8
			If $Tools_menu_pluginitem8 <> "" Then
				If $Can_open_new_tab = 0 Then Return
				$Can_open_new_tab = 0
				Call("_open_plugintab", $Tools_menu_pluginitem8_exe, $Tools_menu_pluginitem8_exe, 1)
			EndIf

		Case $Tools_menu_pluginitem9
			If $Tools_menu_pluginitem9 <> "" Then
				If $Can_open_new_tab = 0 Then Return
				$Can_open_new_tab = 0
				Call("_open_plugintab", $Tools_menu_pluginitem9_exe, $Tools_menu_pluginitem9_exe, 1)
			EndIf

		Case $Tools_menu_pluginitem10
			If $Tools_menu_pluginitem10 <> "" Then
				If $Can_open_new_tab = 0 Then Return
				$Can_open_new_tab = 0
				Call("_open_plugintab", $Tools_menu_pluginitem10_exe, $Tools_menu_pluginitem10_exe, 1)
			EndIf

		Case $TreeviewContextMenu_Item_Projektbaum_aktualisieren
			_Update_Treeview()
		Case $ISN_Toolbar_RefreshProjecttree
			_Update_Treeview()
		Case $ISN_ProjectMenu_RefreshProjecttree
			_Update_Treeview()
		Case $ISN_Toolbar_ImportFiles
			_Try_to_import_file()
		Case $ISN_Toolbar_DeleteFile
			_Show_Delete_file_GUI()
		Case $ISN_Toolbar_ToggleSearch
			_Toggle_Search()
		Case $ISN_SearchMenu_SearchAndReplace
			_Show_Search()
		Case $ISN_ViewMenu_ToggleFullscreen
			_Toggle_Fulscreen()
		Case $ISN_FileMenu_ExitISN
			AdlibRegister("_exit", 1)
		Case $ISN_Toolbar_StopScript
			_STOPSCRIPT()
		Case $ISN_ToolsMenu_BitCalculator
			_Toggle_Bitoperation_rechner()
		Case $ISN_ToolsMenu_ParameterEditor
			_Parameter_Editor_Contextmenue()
		Case $ISN_ToolsMenu_PELockObfuscator
			_Toggle_PELock_GUI()
		Case $ISN_Toolbar_TestScript
			_ISN_Skript_Testen()
		Case $ISN_Toolbar_Au3SyntaxCheck
			_ISN_Syntaxcheck_aktuellen_Tab()
		Case $ISN_ToolsMenu_Au3SyntaxCheck
			_ISN_Syntaxcheck_aktuellen_Tab()
		Case $ISN_ProjectMenu_TestProject
			_ISN_Projekt_Testen()
		Case $ISN_ProjectMenu_TestProjectWithoutParameters
			_ISN_Projekt_Testen_ohne_Parameter()
		Case $ISN_ProjectMenu_BackupNow
			_Backup_Files()
		Case $ISN_EditMenu_Cut
			_trytocut()
		Case $ISN_EditMenu_Copy
			_trytocopy()
		Case $ISN_EditMenu_Paste
			_trytopaste()
		Case $ISN_EditMenu_Delete
			_trytodelete()
		Case $ISN_FileMenu_DeleteFile
			_Show_Delete_file_GUI()
		Case $ISN_FileMenu_ImportFiles
			_Try_to_import_file()
		Case $ISN_ToolsMenu_AutoIt3Wrapper
			_Zeige_AutoIt3Wrapper_GUI()
		Case $ISN_ToolsMenu_CreateUDFHeader
			_Erstelle_UDF_Header()
		Case $ISN_FileMenu_ImportFolder
			_Try_to_import_folder()
		Case $ISN_Toolbar_ImportFolder
			_Try_to_import_folder()
		Case $ISN_Toolbar_ToggleFullscreen
			_Toggle_Fulscreen()
		Case $ISN_ProjectMenu_StopScript
			_STOPSCRIPT()
		Case $ISN_ProjectMenu_TestScript
			_ISN_Skript_Testen()
		Case $ISN_SearchMenu_GoToLine
			_Toggle_GoToLine_GUI()
		Case $TreeviewContextMenu_Item1
			Try_to_opten_file(_GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView))
		Case $TreeviewContextMenu_CopyFileToClipboard
			_ISN_TVExplorer_Copy2Clipboard()
		Case $TreeviewContextMenu_CutFileToClipboard
			_ISN_TVExplorer_Cut2Clipboard()
		Case $TreeviewContextMenu_PasteFileFromClipboard
			_ISN_TVExplorer_PasteFromClipboard()
		Case $TreeviewContextMenu_Item10
			_Erstelle_kopie_von_markierter_datei()
		Case $ISN_FileMenu_CreateCopyOfFile
			_Erstelle_kopie_von_markierter_datei()
		Case $TreeviewContextMenu_NewPowerShellWindow
			_OpenNewPowerShellInThisFolder()
		Case $TreeviewContextMenu_NewCMDWindow
			_OpenNewCMDInThisFolder()
		Case $TreeviewContextMenu_CopyFilePathtoClipboard
			_ISN_TreeViewCopyFilePathtoClipboard()
		Case $TreeviewContextMenu_Item9
			_tryotopeninexplorer(_GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView))
		Case $TreeviewContextMenu_Item2, $ISN_FileMenu_RenameFile
			_Rename_File_in_Projecttree()
		Case $TreeviewContextMenu_Item3
			_Show_Delete_file_GUI()
		Case $TreeviewContextMenu_Item4
			_Try_to_move_file()
		Case $ISN_FileMenu_MoveFile
			_Try_to_move_file()
		Case $ISN_FileMenu_ISNSettings
			_Show_Configgui()
		Case $ISN_Toolbar_ISNSettings
			_Show_Configgui()
		Case $ISN_ProjectMenu_Macros
			_Show_Ruleeditor()
		Case $ISN_Toolbar_Macros
			_Show_Ruleeditor()
		Case $ISN_FileMenu_ExportFile
			_Export_File()
		Case $ISN_Toolbar_ExportFile
			_Export_File()
		Case $TreeviewContextMenu_Item7
			_Export_File()
		Case $TreeviewContextMenu_Item6
			_Try_to_import_file()
		Case $ISN_FileMenu_CloseAllTabs
			_Close_All_Tabs()
		Case $ISN_FileMenu_ReloadFilecontent
			_ISN_ReloadFileContentOnCurrentTab()
		Case $TabContextMenu_Item5
			_Close_All_Tabs()
		Case $TreeviewContextMenu_Item6a
			_Try_to_import_folder()
		Case $ISN_ViewMenu_ContractRegions
			_Scintilla_Fold_Contract_all_Regions()
		Case $ISN_ViewMenu_DualEditor_SyncVerticalScrolling
			_ViewMenu_Toggle_SyncVerticalScrolling()
		Case $ISN_ViewMenu_DualEditor_SyncHorizontalScrolling
			_ViewMenu_Toggle_SyncHorizontalScrolling()
		Case $ISN_ViewMenu_DualEditor_ShowEditorTitle
			_ViewMenu_Toggle_DualEditorTitle()
		Case $ISN_ViewMenu_DualEditor_DisplayVertical
			_ViewMenu_Toggle_SetDualEditorVertical()
		Case $ISN_ViewMenu_DualEditor_DisplayHorizontal
			_ViewMenu_Toggle_SetDualEditorHorizontal()
		Case $ISN_ViewMenu_DualEditor_ExitDualMode, $TabContextMenu_ExitDualMode
			_ISN_DualEditor_CloseDualTab()
		Case $ISN_ViewMenu_ExpandRegions
			_Scintilla_Fold_Expand_all_Regions()
		Case $ISN_ViewMenu_ContractCodesegments
			_Scintilla_Fold_Contract_all()
		Case $ISN_ViewMenu_ExpandCodesegments
			_Scintilla_Fold_Expand_all()
		Case $ISN_SearchMenu_BookmarkLine
			_Zeile_Bookmarken()
		Case $ISN_SearchMenu_RemoveAllBookmarks
			_Alle_Bookmarks_entfernen()
		Case $ISN_SearchMenu_JumpToNextBookmark
			_Springe_zum_naechsten_Bookmarks()
		Case $ISN_SearchMenu_JumpToPrevBookmark
			_Springe_zur_vorherigen_Bookmarks()
		Case $ISN_EditMenu_MoveRowsUp
			_Markierte_Zeile_nach_oben_verschieben()
		Case $ISN_EditMenu_MoveRowsDown
			_Markierte_Zeile_nach_unten_verschieben()
		Case $ISN_ViewMenu_ShowFoldMargin
			_ViewMenu_Toggle_FoldMargin()
		Case $ISN_ViewMenu_ShowBookmarkMargin
			_ViewMenu_Toggle_BookmarkMargin()
		Case $ISN_ViewMenu_DisplayWhitespaces
			_ViewMenu_Toggle_DisplayWhitespace()
		Case $ISN_ViewMenu_DisplayEndofLine
			_ViewMenu_Toggle_DisplayEndOfLine()
		Case $ISN_ViewMenu_DisplayIndentationGuides
			_ViewMenu_Toggle_IndentationGuides()
		Case $ISN_ViewMenu_DisplayQuickSearchBar
			_ViewMenu_Toggle_DisplayQuickSearch()
		Case $ISN_ViewMenu_ShowLineNumbers
			_ViewMenu_Toggle_ShowLines()
		Case $ISN_ViewMenu_HideComments
			_SCI_Kommentare_ausblenden_bzw_einblenden()
		Case $ISN_ToolsMenu_EnableAdvancedDebugging
			_Erweitertes_Debugging_aktivieren()
		Case $ISN_ToolsMenu_DisableAdvancedDebugging
			_Erweitertes_Debugging_deaktivieren()
		Case $ISN_Toolbar_NewFolder, $ISN_FileMenu_NewFolder, $TreeviewContextMenu_Item8_Item2
			_ISN_ShowNewFolderGUI(_GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView))			
		Case $TreeviewContextMenu_Item8_NewShortcut, $ISN_FileMenu_NewShortcut, $ISN_Toolbar_NewShortcut
			_ISN_ShowCreateNewShortcutGUI(_GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView))	
		Case $ISN_Toolbar_ProjectSettings
			_Zeige_Projekteinstellungen()
		Case $ISN_ProjectMenu_ProjectSettings
			_Zeige_Projekteinstellungen()
		Case $TreeviewContextMenu_Oeffnen_Mit_Script_Editor
			_datei_oeffnen_mit_Skript_Editor()
		Case $TreeviewContextMenu_Oeffnen_Mit_Windows
			_datei_oeffnen_mit_Windows()
		Case $TreeviewContextMenu_DisplayOpenWithDialog
			_ISN_TVExplorer_DisplayOpenFileDialog()
		Case $ISN_Toolbar_ProjectProperties
			_Zeige_Projekteinstellungen("projectproperties")
		Case $ISN_FileMenu_CloseTab
			_ISN_Aktuellen_Tab_schliessen()
		Case $ISN_Toolbar_CloseTab
			_ISN_Aktuellen_Tab_schliessen()
		Case $TabContextMenu_Item2
			_ISN_Aktuellen_Tab_schliessen()
		Case $TabContextMenu_Item3
			If _GUICtrlTab_GetItemCount($htab) = 0 Then Return
			If $SCE_EDITOR[_GUICtrlTab_GetCurFocus($htab)] = 0 Then Return
			_tryotopeninexplorer($Datei_pfad[_GUICtrlTab_GetCurFocus($htab)])
		Case $TabContextMenu_Item4
			_datei_eigenschaften_tab()
		Case $TreeviewContextMenu_Item5
			If $Offenes_Projekt = _ISN_Variablen_aufloesen($Projectfolder & "\" & _GUICtrlTreeView_GetTree($Current_TVExplorer_TreeView, _GUICtrlTreeView_GetSelection($Current_TVExplorer_TreeView))) Then
				_Zeige_Projekteinstellungen("projectproperties")
			Else
				_datei_eigenschaften()
			EndIf
		Case $TreeviewContextMenu_AddToFavorites
			_ISN_Favorites_AddNewItemFromProjecttree()
		Case $TabContextMenu_AddToFavorites
			_ISN_Favorites_AddNewItemFromTab()
		Case $ISN_ProjectMenu_ChangelogManager
			_Zeige_changelogmanager()
		Case $ISN_ProjectMenu_ToDoList
			_Toggle_ToDo_manager()
		Case $ISN_ToolsMenu_UDFManager, $ISN_Toolbar_UDFManager
			_ISN_Toggle_UDF_Manager()
		Case $TreeviewContextMenu_Item_PELock_Obfuscator
			_Datei_aus_Projektbaum_in_Obfuscator_GUI_Laden()
		Case $TreeviewContextMenu_Item_Makro_kompilieren_bestehend
			_AU3_aus_Projektbaum_mit_vorhandenen_Makro_kompilieren()
		Case $TreeviewContextMenu_Item_Makro_kompilieren_neu
			_AU3_aus_Projektbaum_mit_neuem_Makro_kompilieren()
		Case $TreeviewContextMenu_Item_Jetzt_Kompilieren
			_AU3_aus_Projektbaum_Direkt_Kompilieren()
		Case $ISN_Toolbar_ChangelogManager
			_Zeige_changelogmanager()
		Case $TreeviewContextMenu_Item8_Item1
			_Show_New_Filegui()
		Case $ISN_FileMenu_NewTempAu3File
			_erstelle_neues_temporaeres_skript()
		Case $TreeviewContextMenu_temp_au3_file
			_erstelle_neues_temporaeres_skript()
		Case $ISN_FileMenu_Print
			_ISN_Print_current_file()
		Case $SCI_EDITOR_CONTEXT_drucken
			_ISN_Print_current_file()
		Case $TreeviewContextMenu_NewFile_Au3UDF, $ISN_FileMenu_NewAu3udfFile
			_ISN_ShowNewFileGUI(_Get_langstr(1452), _GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView))
		Case $TreeviewContextMenu_Item8_a, $ISN_FileMenu_NewAu3File
			_ISN_ShowNewFileGUI(_Get_langstr(154), _GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView))
		Case $TreeviewContextMenu_Item8_b, $ISN_FileMenu_NewIsfFile
			_ISN_ShowNewFileGUI(_Get_langstr(153), _GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView))
		Case $TreeviewContextMenu_Item8_c, $ISN_FileMenu_NewIniFile
			_ISN_ShowNewFileGUI( _Get_langstr(155), _GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView))
		Case $TreeviewContextMenu_Item8_d, $ISN_FileMenu_NewTxtFile
			_ISN_ShowNewFileGUI(_Get_langstr(156), _GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView))
		Case $ISN_ToolsMenu_ColorToolbox
			_Toggle_colourpicker()
		Case $ISN_Toolbar_ColorToolbox
			_Toggle_colourpicker()
		Case $ISN_Toolbar_TidySource
			_ISN_Tidy_aktuellen_Tab()
		Case $ISN_ToolsMenu_TidySource
			_ISN_Tidy_aktuellen_Tab()
		Case $ISN_EditMenu_CommentOut
			_comment_out()
		Case $ISN_EditMenu_ShowCallTip
			_Scintilla_Force_Show_CallTip()
		Case $ISN_Toolbar_CommentOut
			_comment_out()
		Case $ISN_ProjectMenu_TestProjectSetupParameters
			_Show_Parameterconfig()
		Case $ISN_ProjectMenu_QuickChangeAutoItArchitecture
			_ISN_ShowQuickChangeAutoItArchitectureGUI()
;~ 		Case $Scripttree_includemenu_menu3
;~ 			_SCI_Zeige_Code_Schnipsel()
;~ 		Case $Scripttree_includemenu_menu0
;~ 			$str = StringTrimLeft(_GUICtrlTreeView_GetTree($hTreeview2, _GUICtrlTreeView_GetSelection($hTreeview2)), StringInStr(_GUICtrlTreeView_GetTree($hTreeview2, _GUICtrlTreeView_GetSelection($hTreeview2)), "|", Default, -1))
;~ 			_Try_to_open_include($str)
;~ 		Case $Scripttree_includemenu_menu1
;~ 			_Scripttree_show_comment()
;~ 		Case $Scripttree_includemenu_menu2
;~ 			_Scripttree_DB_Klick()
		Case $SCI_EDITOR_CONTEXT_oeffneInclude
			$str = Sci_GetLine($SCE_EDITOR[_GUICtrlTab_GetCurFocus($htab)], Sci_GetCurrentLine($SCE_EDITOR[_GUICtrlTab_GetCurFocus($htab)]) - 1)
			_Try_to_open_include($str)
		Case $SCI_EDITOR_CONTEXT_ParameterEditor
			_Parameter_Editor_Contextmenue()
		Case $ISN_ProjectMenu_ProjectManager
			If $Can_open_new_tab = 0 Then Return $GUI_RUNDEFMSG
			_Show_Projectman()					
			
			
	EndSwitch


	;Additional events when a secound while loop is used. For example waiting for plugin start.
	If $ISN_PluginStartupInfo_KillButton <> "" Then
		If $nID = $ISN_PluginStartupInfo_KillButton Then $ISN_PluginStartupTimeout = -1
	EndIf


	Return $GUI_RUNDEFMSG
EndFunc   ;==>_InputCheck

Func _Oeffne_ISN_hilfe()
	If $Languagefile = "german.lng" Then
		ShellExecute(@ScriptDir & "\Data\ISNhelp_ger.chm")
		Return
	EndIf

	If $Languagefile = "english.lng" Then
		ShellExecute(@ScriptDir & "\Data\ISNhelp_en.chm")
		Return
	EndIf


	;Für alle anderen Fallback auf english
	ShellExecute(@ScriptDir & "\Data\ISNhelp_en.chm")
EndFunc   ;==>_Oeffne_ISN_hilfe


Func _Projekt_Eigenschaften_Oeffnen_Projektverwaltung()
	If MsgBox(262144 + 48 + 4, _Get_langstr(394), _Get_langstr(393), 0, $Projekteinstellungen_GUI) = 6 Then
		_Hide_projectproperties()
		_Close_Project("false")
		_Show_Projectman()
	EndIf
EndFunc   ;==>_Projekt_Eigenschaften_Oeffnen_Projektverwaltung



Func _ISN_TryToCloseTabWithMiddleMouseButton()
	If $Can_open_new_tab = 1 Then
		If _GUICtrlTab_GetItemCount($htab) = 0 Then Return 0
		$tPOINT = _WinAPI_GetMousePos(True, $Studiofenster)
		Local $iX = DllStructGetData($tPOINT, "X")
		Local $iY = DllStructGetData($tPOINT, "Y")
		Local $aPos = _ControlGetPos($Studiofenster, "", $htab)
		If Not IsArray($aPos) Then Return 0
		Local $aHit = _GUICtrlTab_HitTest($htab, $iX - $aPos[0], $iY - $aPos[1])
		If Not IsArray($aHit) Then Return 0
		If $aHit[0] <> -1 Then
			If $aHit[0] <> _GUICtrlTab_GetCurFocus($htab) Then _GUICtrlTab_ActivateTabX($htab, $aHit[0], 0)
			try_to_Close_Tab($aHit[0])
		EndIf
	EndIf
	Return 0
EndFunc   ;==>_ISN_TryToCloseTabWithMiddleMouseButton

Func _projectfolder_std()
	GUICtrlSetData($Input_Projekte_Pfad, $Standardordner_Projects)
EndFunc   ;==>_projectfolder_std

Func _backupfolder_std()
	GUICtrlSetData($Input_Backup_Pfad, $Standardordner_Backups)
EndFunc   ;==>_backupfolder_std

Func _releasefolder_std()
	GUICtrlSetData($Input_Release_Pfad, $Standardordner_Release)
EndFunc   ;==>_releasefolder_std

Func _templatefolder_std()
	GUICtrlSetData($Input_template_Pfad, $Standardordner_Templates)
EndFunc   ;==>_templatefolder_std

Func _pluginfolder_std()
	GUICtrlSetData($Einstellungen_Pfade_Pluginpfad_input, $Standardordner_Plugins)
EndFunc   ;==>_pluginfolder_std

Func _ISN_Settings_Paths_SetUDFsFolderToDefault()
	GUICtrlSetData($Settings_Paths_UDFs_input, $Standardordner_UDFs)
EndFunc   ;==>_ISN_Settings_Paths_SetUDFsFolderToDefault

Func _erkenne_au3exe()
	Local $RegKey = 'HKEY_LOCAL_MACHINE64\SOFTWARE\'
	If @OSArch <> 'X86' Then $RegKey &= 'Wow6432Node\'
	Local $InstallPath = RegRead($RegKey & 'AutoIt v3\AutoIt', 'InstallDir')
	Local $Pfad = ""
	If IsDeclared("Input_config_au3exe") Then GUICtrlSetData($Input_config_au3exe, $Pfad)
	;Search AutoIt3.exe
	If DriveStatus("c:\") = "READY" Then
		If FileExists("C:\Programme\AutoIt3\AutoIt3.exe") Then $Pfad = "C:\Programme\AutoIt3\AutoIt3.exe"
		If FileExists("C:\Program Files\AutoIt3\AutoIt3.exe") Then $Pfad = "C:\Program Files\AutoIt3\AutoIt3.exe"
		If FileExists("C:\Program Files (x86)\AutoIt3\AutoIt3.exe") Then $Pfad = "C:\Program Files (x86)\AutoIt3\AutoIt3.exe"
	EndIf

	If DriveStatus("D:\") = "READY" Then
		If FileExists("D:\Programme\AutoIt3\AutoIt3.exe") Then $Pfad = "D:\Programme\AutoIt3\AutoIt3.exe"
		If FileExists("D:\Program Files\AutoIt3\AutoIt3.exe") Then $Pfad = "D:\Program Files\AutoIt3\AutoIt3.exe"
		If FileExists("D:\Program Files (x86)\AutoIt3\AutoIt3.exe") Then $Pfad = "D:\Program Files (x86)\AutoIt3\AutoIt3.exe"
	EndIf
	If FileExists($InstallPath & "\AutoIt3.exe") Then $Pfad = $InstallPath & "\AutoIt3.exe"
	If FileExists(@ScriptDir & "\portable.dat") And FileExists(@ScriptDir & "\autoit\AutoIt3.exe") Then $Pfad = @ScriptDir & "\AutoIt\AutoIt3.exe"
	$Pfad = _ISN_Pfad_durch_Variablen_ersetzen($Pfad)
	If IsDeclared("Input_config_au3exe") Then GUICtrlSetData($Input_config_au3exe, $Pfad)
	GUICtrlSetData($Ersteinrichtung_Programmpfade_Autoit3_exe_input, $Pfad)
EndFunc   ;==>_erkenne_au3exe

Func _erkenne_au3x64exe()
	Local $RegKey = 'HKEY_LOCAL_MACHINE64\SOFTWARE\'
	If @OSArch <> 'X86' Then $RegKey &= 'Wow6432Node\'
	Local $InstallPath = RegRead($RegKey & 'AutoIt v3\AutoIt', 'InstallDir')
	Local $Pfad = ""
	If IsDeclared("Input_config_au3x64exe") Then GUICtrlSetData($Input_config_au3x64exe, $Pfad)
	;Search AutoIt3.exe
	If DriveStatus("c:\") = "READY" Then
		If FileExists("C:\Programme\AutoIt3\AutoIt3_x64.exe") Then $Pfad = "C:\Programme\AutoIt3\AutoIt3_x64.exe"
		If FileExists("C:\Program Files\AutoIt3\AutoIt3_x64.exe") Then $Pfad = "C:\Program Files\AutoIt3\AutoIt3_x64.exe"
		If FileExists("C:\Program Files (x86)\AutoIt3\AutoIt3_x64.exe") Then $Pfad = "C:\Program Files (x86)\AutoIt3\AutoIt3_x64.exe"
	EndIf

	If DriveStatus("D:\") = "READY" Then
		If FileExists("D:\Programme\AutoIt3\AutoIt3_x64.exe") Then $Pfad = "D:\Programme\AutoIt3\AutoIt3_x64.exe"
		If FileExists("D:\Program Files\AutoIt3\AutoIt3_x64.exe") Then $Pfad = "D:\Program Files\AutoIt3\AutoIt3_x64.exe"
		If FileExists("D:\Program Files (x86)\AutoIt3\AutoIt3_x64.exe") Then $Pfad = "D:\Program Files (x86)\AutoIt3\AutoIt3_x64.exe"
	EndIf
	If FileExists($InstallPath & "\AutoIt3_x64.exe") Then $Pfad = $InstallPath & "\AutoIt3_x64.exe"
	If FileExists(@ScriptDir & "\portable.dat") And FileExists(@ScriptDir & "\autoit\AutoIt3_x64.exe") Then $Pfad = @ScriptDir & "\AutoIt\AutoIt3_x64.exe"
	$Pfad = _ISN_Pfad_durch_Variablen_ersetzen($Pfad)
	If IsDeclared("Input_config_au3x64exe") Then GUICtrlSetData($Input_config_au3x64exe, $Pfad)
	GUICtrlSetData($Ersteinrichtung_Programmpfade_Autoit3x64_exe_input, $Pfad)
EndFunc   ;==>_erkenne_au3x64exe

Func _erkenne_au32exe()
	Local $RegKey = 'HKEY_LOCAL_MACHINE64\SOFTWARE\'
	If @OSArch <> 'X86' Then $RegKey &= 'Wow6432Node\'
	Local $InstallPath = RegRead($RegKey & 'AutoIt v3\AutoIt', 'InstallDir')
	Local $Pfad = ""
	If IsDeclared("Input_config_au2exe") Then GUICtrlSetData($Input_config_au2exe, $Pfad)
	If DriveStatus("c:\") = "READY" Then
		If FileExists("C:\Programme\AutoIt3\Aut2Exe\Aut2exe.exe") Then $Pfad = "C:\Programme\AutoIt3\Aut2Exe\Aut2exe.exe"
		If FileExists("C:\Program Files\AutoIt3\Aut2Exe\Aut2exe.exe") Then $Pfad = "C:\Program Files\AutoIt3\Aut2Exe\Aut2exe.exe"
		If FileExists("C:\Program Files (x86)\AutoIt3\Aut2Exe\Aut2exe.exe") Then $Pfad = "C:\Program Files (x86)\AutoIt3\Aut2Exe\Aut2exe.exe"
	EndIf
	If DriveStatus("D:\") = "READY" Then
		If FileExists("D:\Programme\AutoIt3\Aut2Exe\Aut2exe.exe") Then $Pfad = "D:\Programme\AutoIt3\Aut2Exe\Aut2exe.exe"
		If FileExists("D:\Program Files\AutoIt3\Aut2Exe\Aut2exe.exe") Then $Pfad = "D:\Program Files\AutoIt3\Aut2Exe\Aut2exe.exe"
		If FileExists("D:\Program Files (x86)\AutoIt3\Aut2Exe\Aut2exe.exe") Then $Pfad = "D:\Program Files (x86)\AutoIt3\Aut2Exe\Aut2exe.exe"
	EndIf
	If FileExists($InstallPath & "\Aut2Exe\Aut2exe.exe") Then $Pfad = $InstallPath & "\Aut2Exe\Aut2exe.exe"
	If FileExists(@ScriptDir & "\portable.dat") And FileExists(@ScriptDir & "\autoit\Aut2Exe\Aut2exe.exe") Then $Pfad = @ScriptDir & "\AutoIt\Aut2Exe\Aut2exe.exe"
	$Pfad = _ISN_Pfad_durch_Variablen_ersetzen($Pfad)
	If IsDeclared("Input_config_au2exe") Then GUICtrlSetData($Input_config_au2exe, $Pfad)
	GUICtrlSetData($Ersteinrichtung_Programmpfade_Aut2exe_exe_input, $Pfad)
EndFunc   ;==>_erkenne_au32exe

Func _erkenne_helpfile()
	Local $RegKey = 'HKEY_LOCAL_MACHINE64\SOFTWARE\'
	If @OSArch <> 'X86' Then $RegKey &= 'Wow6432Node\'
	Local $InstallPath = RegRead($RegKey & 'AutoIt v3\AutoIt', 'InstallDir')
	Local $Pfad = ""
	If IsDeclared("Input_config_helpfile") Then GUICtrlSetData($Input_config_helpfile, $Pfad)
	If DriveStatus("c:\") = "READY" Then
		If FileExists("C:\Programme\AutoIt3\AutoIt3Help.exe") Then $Pfad = "C:\Programme\AutoIt3\AutoIt3Help.exe"
		If FileExists("C:\Program Files\AutoIt3\AutoIt3Help.exe") Then $Pfad = "C:\Program Files\AutoIt3\AutoIt3Help.exe"
		If FileExists("C:\Program Files (x86)\AutoIt3\AutoIt3Help.exe") Then $Pfad = "C:\Program Files (x86)\AutoIt3\AutoIt3Help.exe"
	EndIf
	If DriveStatus("D:\") = "READY" Then
		If FileExists("D:\Programme\AutoIt3\AutoIt3Help.exe") Then $Pfad = "D:\Programme\AutoIt3\AutoIt3Help.exe"
		If FileExists("D:\Program Files\AutoIt3\AutoIt3Help.exe") Then $Pfad = "D:\Program Files\AutoIt3\AutoIt3Help.exe"
		If FileExists("D:\Program Files (x86)\AutoIt3\AutoIt3Help.exe") Then $Pfad = "D:\Program Files (x86)\AutoIt3\AutoIt3Help.exe"
	EndIf
	If FileExists($InstallPath & "\AutoIt3Help.exe") Then $Pfad = $InstallPath & "\AutoIt3Help.exe"
	If FileExists(@ScriptDir & "\portable.dat") And FileExists(@ScriptDir & "\autoit\AutoIt3Help.exe") Then $Pfad = @ScriptDir & "\AutoIt\AutoIt3Help.exe"
	$Pfad = _ISN_Pfad_durch_Variablen_ersetzen($Pfad)
	If IsDeclared("Input_config_helpfile") Then GUICtrlSetData($Input_config_helpfile, $Pfad)
	GUICtrlSetData($Ersteinrichtung_Programmpfade_AutoIt3Help_exe_input, $Pfad)
EndFunc   ;==>_erkenne_helpfile

Func _erkenne_Au3Infoexe()
	Local $RegKey = 'HKEY_LOCAL_MACHINE64\SOFTWARE\'
	If @OSArch <> 'X86' Then $RegKey &= 'Wow6432Node\'
	Local $InstallPath = RegRead($RegKey & 'AutoIt v3\AutoIt', 'InstallDir')
	Local $Pfad = ""
	If IsDeclared("Input_config_Au3Infoexe") Then GUICtrlSetData($Input_config_Au3Infoexe, $Pfad)
	If DriveStatus("c:\") = "READY" Then
		If FileExists("C:\Programme\AutoIt3\Au3Info.exe") Then $Pfad = "C:\Programme\AutoIt3\Au3Info.exe"
		If FileExists("C:\Program Files\AutoIt3\Au3Info.exe") Then $Pfad = "C:\Program Files\AutoIt3\Au3Info.exe"
		If FileExists("C:\Program Files (x86)\AutoIt3\Au3Info.exe") Then $Pfad = "C:\Program Files (x86)\AutoIt3\Au3Info.exe"
	EndIf
	If DriveStatus("D:\") = "READY" Then
		If FileExists("D:\Programme\AutoIt3\Au3Info.exe") Then $Pfad = "D:\Programme\AutoIt3\Au3Info.exe"
		If FileExists("D:\Program Files\AutoIt3\Au3Info.exe") Then $Pfad = "D:\Program Files\AutoIt3\Au3Info.exe"
		If FileExists("D:\Program Files (x86)\AutoIt3\Au3Info.exe") Then $Pfad = "D:\Program Files (x86)\AutoIt3\Au3Info.exe"
	EndIf
	If FileExists($InstallPath & "\Au3Info.exe") Then $Pfad = $InstallPath & "\Au3Info.exe"
	If FileExists(@ScriptDir & "\portable.dat") And FileExists(@ScriptDir & "\autoit\Au3Info.exe") Then $Pfad = @ScriptDir & "\AutoIt\Au3Info.exe"
	$Pfad = _ISN_Pfad_durch_Variablen_ersetzen($Pfad)
	If IsDeclared("Input_config_Au3Infoexe") Then GUICtrlSetData($Input_config_Au3Infoexe, $Pfad)
	GUICtrlSetData($Ersteinrichtung_Programmpfade_Au3Info_exe_input, $Pfad)
EndFunc   ;==>_erkenne_Au3Infoexe

Func _erkenne_Au3Checkexe()
	Local $RegKey = 'HKEY_LOCAL_MACHINE64\SOFTWARE\'
	If @OSArch <> 'X86' Then $RegKey &= 'Wow6432Node\'
	Local $InstallPath = RegRead($RegKey & 'AutoIt v3\AutoIt', 'InstallDir')
	Local $Pfad = ""
	If IsDeclared("Input_config_Au3Checkexe") Then GUICtrlSetData($Input_config_Au3Checkexe, $Pfad)
	If DriveStatus("c:\") = "READY" Then
		If FileExists("C:\Programme\AutoIt3\Au3Check.exe") Then $Pfad = "C:\Programme\AutoIt3\Au3Check.exe"
		If FileExists("C:\Program Files\AutoIt3\Au3Check.exe") Then $Pfad = "C:\Program Files\AutoIt3\Au3Check.exe"
		If FileExists("C:\Program Files (x86)\AutoIt3\Au3Check.exe") Then $Pfad = "C:\Program Files (x86)\AutoIt3\Au3Check.exe"
	EndIf
	If DriveStatus("D:\") = "READY" Then
		If FileExists("D:\Programme\AutoIt3\Au3Check.exe") Then $Pfad = "D:\Programme\AutoIt3\Au3Check.exe"
		If FileExists("D:\Program Files\AutoIt3\Au3Check.exe") Then $Pfad = "D:\Program Files\AutoIt3\Au3Check.exe"
		If FileExists("D:\Program Files (x86)\AutoIt3\Au3Check.exe") Then $Pfad = "D:\Program Files (x86)\AutoIt3\Au3Check.exe"
	EndIf
	If FileExists($InstallPath & "\Au3Check.exe") Then $Pfad = $InstallPath & "\Au3Check.exe"
	If FileExists(@ScriptDir & "\portable.dat") And FileExists(@ScriptDir & "\autoit\Au3Check.exe") Then $Pfad = @ScriptDir & "\AutoIt\Au3Check.exe"
	$Pfad = _ISN_Pfad_durch_Variablen_ersetzen($Pfad)
	If IsDeclared("Input_config_Au3Checkexe") Then GUICtrlSetData($Input_config_Au3Checkexe, $Pfad)
	GUICtrlSetData($Ersteinrichtung_Programmpfade_Au3Check_exe_input, $Pfad)
EndFunc   ;==>_erkenne_Au3Checkexe

Func _erkenne_Au3Stripperexe()
	Local $RegKey = 'HKEY_LOCAL_MACHINE64\SOFTWARE\'
	If @OSArch <> 'X86' Then $RegKey &= 'Wow6432Node\'
	Local $InstallPath = RegRead($RegKey & 'AutoIt v3\AutoIt', 'InstallDir')
	Local $Pfad = ""
	If IsDeclared("Input_config_Au3Stripperexe") Then GUICtrlSetData($Input_config_Au3Stripperexe, $Pfad)
	If DriveStatus("c:\") = "READY" Then
		If FileExists("C:\Programme\AutoIt3\Au3Stripper\AU3Stripper.exe") Then $Pfad = "C:\Programme\AutoIt3\Au3Stripper\AU3Stripper.exe"
		If FileExists("C:\Program Files\AutoIt3\Au3Stripper\AU3Stripper.exe") Then $Pfad = "C:\Program Files\AutoIt3\Au3Stripper\AU3Stripper.exe"
		If FileExists("C:\Program Files (x86)\AutoIt3\Au3Stripper\AU3Stripper.exe") Then $Pfad = "C:\Program Files (x86)\AutoIt3\Au3Stripper\AU3Stripper.exe"
	EndIf
	If DriveStatus("D:\") = "READY" Then
		If FileExists("D:\Programme\AutoIt3\Au3Stripper\AU3Stripper.exe") Then $Pfad = "D:\Programme\AutoIt3\Au3Stripper\AU3Stripper.exe"
		If FileExists("D:\Program Files\AutoIt3\Au3Stripper\AU3Stripper.exe") Then $Pfad = "D:\Program Files\AutoIt3\Au3Stripper\AU3Stripper.exe"
		If FileExists("D:\Program Files (x86)\AutoIt3\Au3Stripper\AU3Stripper.exe") Then $Pfad = "D:\Program Files (x86)\AutoIt3\Au3Stripper\AU3Stripper.exe"
	EndIf
	If FileExists($InstallPath & "\Au3Stripper\AU3Stripper.exe") Then $Pfad = $InstallPath & "\Au3Stripper\AU3Stripper.exe"
	If FileExists($InstallPath & "\SciTE\au3Stripper\AU3Stripper.exe") Then $Pfad = $InstallPath & "\SciTE\au3Stripper\AU3Stripper.exe"
	If FileExists(@ScriptDir & "\portable.dat") And FileExists(@ScriptDir & "\autoit\Au3Stripper\AU3Stripper.exe") Then $Pfad = @ScriptDir & "\AutoIt\Au3Stripper\AU3Stripper.exe"
	If FileExists(@ScriptDir & "\portable.dat") And FileExists(@ScriptDir & "\autoit\SciTE\au3Stripper\AU3Stripper.exe") Then $Pfad = @ScriptDir & "\AutoIt\SciTE\au3Stripper\AU3Stripper.exe"
	$Pfad = _ISN_Pfad_durch_Variablen_ersetzen($Pfad)
	If IsDeclared("Input_config_Au3Stripperexe") Then GUICtrlSetData($Input_config_Au3Stripperexe, $Pfad)
	GUICtrlSetData($Ersteinrichtung_Programmpfade_au3stripperexe_input, $Pfad)
EndFunc   ;==>_erkenne_Au3Stripperexe

Func _erkenne_Tidyexe()
	Local $RegKey = 'HKEY_LOCAL_MACHINE64\SOFTWARE\'
	If @OSArch <> 'X86' Then $RegKey &= 'Wow6432Node\'
	Local $InstallPath = RegRead($RegKey & 'AutoIt v3\AutoIt', 'InstallDir')
	Local $Pfad = ""
	If IsDeclared("Input_config_Tidyexe") Then GUICtrlSetData($Input_config_Tidyexe, $Pfad)
	If DriveStatus("c:\") = "READY" Then
		If FileExists("C:\Programme\AutoIt3\Tidy\Tidy.exe") Then $Pfad = "C:\Programme\AutoIt3\Tidy\Tidy.exe"
		If FileExists("C:\Program Files\AutoIt3\Tidy\Tidy.exe") Then $Pfad = "C:\Program Files\AutoIt3\Tidy\Tidy.exe"
		If FileExists("C:\Program Files (x86)\AutoIt3\Tidy\Tidy.exe") Then $Pfad = "C:\Program Files (x86)\AutoIt3\Tidy\Tidy.exe"
	EndIf
	If DriveStatus("D:\") = "READY" Then
		If FileExists("D:\Programme\AutoIt3\Tidy\Tidy.exe") Then $Pfad = "D:\Programme\AutoIt3\Tidy\Tidy.exe"
		If FileExists("D:\Program Files\AutoIt3\Tidy\Tidy.exe") Then $Pfad = "D:\Program Files\AutoIt3\Tidy\Tidy.exe"
		If FileExists("D:\Program Files (x86)\AutoIt3\Tidy\Tidy.exe") Then $Pfad = "D:\Program Files (x86)\AutoIt3\Tidy\Tidy.exe"
	EndIf
	If FileExists($InstallPath & "\Tidy\Tidy.exe") Then $Pfad = $InstallPath & "\Tidy\Tidy.exe"
	If FileExists($InstallPath & "\SciTE\Tidy\Tidy.exe") Then $Pfad = $InstallPath & "\SciTE\Tidy\Tidy.exe"
	If FileExists(@ScriptDir & "\portable.dat") And FileExists(@ScriptDir & "\autoit\Tidy\Tidy.exe") Then $Pfad = @ScriptDir & "\AutoIt\Tidy\Tidy.exe"
	If FileExists(@ScriptDir & "\portable.dat") And FileExists(@ScriptDir & "\autoit\SciTE\Tidy\Tidy.exe") Then $Pfad = @ScriptDir & "\AutoIt\SciTE\Tidy\Tidy.exe"
	$Pfad = _ISN_Pfad_durch_Variablen_ersetzen($Pfad)
	If IsDeclared("Input_config_Tidyexe") Then GUICtrlSetData($Input_config_Tidyexe, $Pfad)
	GUICtrlSetData($Ersteinrichtung_Programmpfade_Tidyexe_input, $Pfad)
EndFunc   ;==>_erkenne_Tidyexe

Func _Automatische_Suche_der_AutoIt_Ordner()
	;Automatische Suche der Pfade FALLS die in der config.ini nicht existieren sollten
	If Not FileExists($autoitexe) Then
		_erkenne_au3exe()
		If GUICtrlRead($Input_config_au3exe) <> "" Then
			_Write_in_Config("autoitexe", GUICtrlRead($Input_config_au3exe))
			$autoitexe = _ISN_Variablen_aufloesen(GUICtrlRead($Input_config_au3exe))
		EndIf
	EndIf

	If Not FileExists($autoitx64exe) Then
		_erkenne_au3x64exe()
		If GUICtrlRead($Input_config_au3x64exe) <> "" Then
			_Write_in_Config("autoitx64exe", GUICtrlRead($Input_config_au3x64exe))
			$autoitx64exe = _ISN_Variablen_aufloesen(GUICtrlRead($Input_config_au3x64exe))
		EndIf
	EndIf

	If Not FileExists($autoit2exe) Then
		_erkenne_au32exe()
		If GUICtrlRead($Input_config_au2exe) <> "" Then
			_Write_in_Config("autoit2exe", GUICtrlRead($Input_config_au2exe))
			$autoit2exe = _ISN_Variablen_aufloesen(GUICtrlRead($Input_config_au2exe))
		EndIf
	EndIf

	If Not FileExists($helpfile) Then
		_erkenne_helpfile()
		If GUICtrlRead($Input_config_helpfile) <> "" Then
			_Write_in_Config("helpfileexe", GUICtrlRead($Input_config_helpfile))
			$helpfile = _ISN_Variablen_aufloesen(GUICtrlRead($Input_config_helpfile))
		EndIf
	EndIf

	If Not FileExists($Au3Infoexe) Then
		_erkenne_Au3Infoexe()
		If GUICtrlRead($Input_config_Au3Infoexe) <> "" Then
			_Write_in_Config("au3infoexe", GUICtrlRead($Input_config_Au3Infoexe))
			$Au3Infoexe = _ISN_Variablen_aufloesen(GUICtrlRead($Input_config_Au3Infoexe))
		EndIf
	EndIf

	If Not FileExists($Au3Checkexe) Then
		_erkenne_Au3Checkexe()
		If GUICtrlRead($Input_config_Au3Checkexe) <> "" Then
			_Write_in_Config("au3checkexe", GUICtrlRead($Input_config_Au3Checkexe))
			$Au3Checkexe = _ISN_Variablen_aufloesen(GUICtrlRead($Input_config_Au3Checkexe))
		EndIf
	EndIf

	;Priorität lokale Datei
	If Not FileExists($Au3Stripperexe) Then
		_erkenne_Au3Stripperexe()
		If GUICtrlRead($Input_config_Au3Stripperexe) <> "" Then
			_Write_in_Config("au3stripperexe", GUICtrlRead($Input_config_Au3Stripperexe))
			$Au3Stripperexe = _ISN_Variablen_aufloesen(GUICtrlRead($Input_config_Au3Stripperexe))
		EndIf
	EndIf

	;Priorität lokale Datei
	If Not FileExists($Tidyexe) Then
		_erkenne_Tidyexe()
		If GUICtrlRead($Input_config_Tidyexe) <> "" Then
			_Write_in_Config("tidyexe", GUICtrlRead($Input_config_Tidyexe))
			$Tidyexe = _ISN_Variablen_aufloesen(GUICtrlRead($Input_config_Tidyexe))
			$Pfad_zur_TidyINI = StringTrimRight($Tidyexe, StringLen($Tidyexe) - StringInStr($Tidyexe, "\", 0, -1)) & "Tidy.ini"
		EndIf
	EndIf

EndFunc   ;==>_Automatische_Suche_der_AutoIt_Ordner



Func _Programmeinstellungen_AutoIt_Ordner_jetzt_erkennen()
	;Erzwinge erkennung für die Programmeinstellungen
	_erkenne_au3exe()
	If GUICtrlRead($Input_config_au3exe) <> "" Then
		_Write_in_Config("autoitexe", GUICtrlRead($Input_config_au3exe))
		$autoitexe = _ISN_Variablen_aufloesen(GUICtrlRead($Input_config_au3exe))
	EndIf

	_erkenne_au3x64exe()
	If GUICtrlRead($Input_config_au3x64exe) <> "" Then
		_Write_in_Config("autoitx64exe", GUICtrlRead($Input_config_au3x64exe))
		$autoitx64exe = _ISN_Variablen_aufloesen(GUICtrlRead($Input_config_au3x64exe))
	EndIf

	_erkenne_au32exe()
	If GUICtrlRead($Input_config_au2exe) <> "" Then
		_Write_in_Config("autoit2exe", GUICtrlRead($Input_config_au2exe))
		$autoit2exe = _ISN_Variablen_aufloesen(GUICtrlRead($Input_config_au2exe))
	EndIf


	_erkenne_helpfile()
	If GUICtrlRead($Input_config_helpfile) <> "" Then
		_Write_in_Config("helpfileexe", GUICtrlRead($Input_config_helpfile))
		$helpfile = _ISN_Variablen_aufloesen(GUICtrlRead($Input_config_helpfile))
	EndIf


	_erkenne_Au3Infoexe()
	If GUICtrlRead($Input_config_Au3Infoexe) <> "" Then
		_Write_in_Config("au3infoexe", GUICtrlRead($Input_config_Au3Infoexe))
		$Au3Infoexe = _ISN_Variablen_aufloesen(GUICtrlRead($Input_config_Au3Infoexe))
	EndIf


	_erkenne_Au3Checkexe()
	If GUICtrlRead($Input_config_Au3Checkexe) <> "" Then
		_Write_in_Config("au3checkexe", GUICtrlRead($Input_config_Au3Checkexe))
		$Au3Checkexe = _ISN_Variablen_aufloesen(GUICtrlRead($Input_config_Au3Checkexe))
	EndIf


	_erkenne_Au3Stripperexe()
	If GUICtrlRead($Input_config_Au3Stripperexe) <> "" Then
		_Write_in_Config("au3stripperexe", GUICtrlRead($Input_config_Au3Stripperexe))
		$Au3Stripperexe = _ISN_Variablen_aufloesen(GUICtrlRead($Input_config_Au3Stripperexe))
	EndIf


	_erkenne_Tidyexe()
	If GUICtrlRead($Input_config_Tidyexe) <> "" Then
		_Write_in_Config("tidyexe", GUICtrlRead($Input_config_Tidyexe))
		$Tidyexe = _ISN_Variablen_aufloesen(GUICtrlRead($Input_config_Tidyexe))
		$Pfad_zur_TidyINI = StringTrimRight($Tidyexe, StringLen($Tidyexe) - StringInStr($Tidyexe, "\", 0, -1)) & "Tidy.ini"
	EndIf

EndFunc   ;==>_Programmeinstellungen_AutoIt_Ordner_jetzt_erkennen



Func _check_fonts()
	If FileExists(@WindowsDir & "\fonts\segoeui.ttf") = 0 Then
		$i = MsgBox(262144 + 32 + 4, _Get_langstr(48), _Get_langstr(304), 0, $Sprache_Ersteinrichtung_GUI)
		If $i = 6 Then _install_fonts()
	EndIf

EndFunc   ;==>_check_fonts

Func _install_fonts()
	installfont(@ScriptDir & "\Data\Fonts\segoeui.ttf")
	installfont(@ScriptDir & "\Data\Fonts\segoeuib.ttf")
	installfont(@ScriptDir & "\Data\Fonts\segoeuii.ttf")
	installfont(@ScriptDir & "\Data\Fonts\segoeuil.ttf")
	installfont(@ScriptDir & "\Data\Fonts\segoeuiz.ttf")
	installfont(@ScriptDir & "\Data\Fonts\seguisb.ttf")
	MsgBox(262144 + 64, _Get_langstr(61), _Get_langstr(305), 0, $Sprache_Ersteinrichtung_GUI)
EndFunc   ;==>_install_fonts

Func installfont($file)
	If FileCopy($file, @WindowsDir & '\Fonts', 1) Then
		DllCall('gdi32', 'long', "AddFontResourceA", 'String', @WindowsDir & '\Fonts\' & $file)
	EndIf
EndFunc   ;==>installfont

Func _Choose_Compileicon()
	_Lock_Plugintabs("lock")
	If $Skin_is_used = "true" Then
		$var = _WinAPI_OpenFileDlg(_Get_langstr(187), $Offenes_Projekt, "Icon (*.ico)", 0, '', '', BitOR($OFN_PATHMUSTEXIST, $OFN_FILEMUSTEXIST, $OFN_HIDEREADONLY), $OFN_EX_NOPLACESBAR, 0, 0, $Projekteinstellungen_GUI)
	Else
		$var = FileOpenDialog(_Get_langstr(187), $Offenes_Projekt, "Icon (*.ico)", 1 + 2, "", $Projekteinstellungen_GUI)
	EndIf
	_Lock_Plugintabs("unlock")
	FileChangeDir(@ScriptDir)
	If @error Then Return
	If $var = "" Then Return
	_SetImage($Compile_vorschauicon, $var)
	$var = _ISN_Pfad_durch_Variablen_ersetzen($var)
	GUICtrlSetData($Compile_Iconpath, $var)
EndFunc   ;==>_Choose_Compileicon

Func _MOVE_TO_CENTER()
	$w = _WinGetPos($Studiofenster, "")
	If $w[1] < -10 Then
		WinMove($Studiofenster, "", Default, 0)
	EndIf
	_WINDOW_REBUILD()
EndFunc   ;==>_MOVE_TO_CENTER



Func _ISN_NewProjectDialog_InteliwriteSubClass($hWnd, $iMsg, $wParam, $lParam)
	Local $SelectedControl = _WinAPI_GetDlgCtrlID($hWnd)
	Local $TextToInsert

	;Collect inserted text of WM_Paste and WM_Char and replace some inserted chars of inputs
	Switch $iMsg

		Case $WM_PASTE
			$TextToInsert = ClipGet()
			$InteliwriteSubcalssTextBackup = GUICtrlRead($SelectedControl)

		Case $WM_CHAR
			$TextToInsert = ChrW($wParam)
			$InteliwriteSubcalssTextBackup = GUICtrlRead($SelectedControl)

		Case $WM_KEYUP
			;Replace some input
			Local $InputText = GUICtrlRead($SelectedControl)
			Local $ReplacementWasDone = False
			Local $TextWasAdded = False

			Switch $SelectedControl

				Case $new_projectname, $neues_projekt_projektdatei_name, $new_projectmainfile
					$InputText = StringReplace($InputText, "ß", "ss")
					If Not @extended = 0 Then $ReplacementWasDone = True
					$InputText = StringReplace($InputText, "ä", "ae", 0, 1)
					If Not @extended = 0 Then $ReplacementWasDone = True
					$InputText = StringReplace($InputText, "Ä", "Ae", 0, 1)
					If Not @extended = 0 Then $ReplacementWasDone = True
					$InputText = StringReplace($InputText, "ö", "oe", 0, 1)
					If Not @extended = 0 Then $ReplacementWasDone = True
					$InputText = StringReplace($InputText, "Ö", "Oe", 0, 1)
					If Not @extended = 0 Then $ReplacementWasDone = True
					$InputText = StringReplace($InputText, "ü", "ue", 0, 1)
					If Not @extended = 0 Then $ReplacementWasDone = True
					$InputText = StringReplace($InputText, "Ü", "Ue", 0, 1)
					If Not @extended = 0 Then $ReplacementWasDone = True

			EndSwitch

			;Check if new text was inserted
			If StringLen($InteliwriteSubcalssTextBackup) <> StringLen($InputText) Then $TextWasAdded = True

			;Only update the input, if something has changed
			If $ReplacementWasDone Then
				Local $Selection = _GUICtrlEdit_GetSel($SelectedControl)
				Local $Offset = 0
				If $TextWasAdded Then $Offset = StringLen($InputText) - StringLen(GUICtrlRead($SelectedControl))
				GUICtrlSetData($SelectedControl, $InputText)
				If IsArray($Selection) Then _GUICtrlEdit_SetSel($SelectedControl, $Selection[0] + $Offset, $Selection[1] + $Offset) ;Restore selection
			EndIf

			;Update other input controls with content of this control
			If $TextWasAdded Then

				Switch $SelectedControl

					Case $new_projectname
						;Update project mainfile and .isn filename
						Local $New_Filename = $InputText
						$New_Filename = StringStripWS($New_Filename, 3)
						$New_Filename = StringReplace($New_Filename, " ", "_")
						GUICtrlSetData($neues_projekt_projektdatei_name, $New_Filename)
						GUICtrlSetData($new_projectmainfile, $New_Filename)
						_ISN_NewProjectDialog_InteliwriteSubClass_RefreshProjectPath()


				EndSwitch

			EndIf

			Return $GUI_RUNDEFMSG
	EndSwitch


	;Test controls, and stop input if char is forbidden (return 1)
	Switch $SelectedControl

		Case $new_projectname, $neues_projekt_projektdatei_name, $new_projectmainfile
			;Forbidden chars
			If StringInStr($TextToInsert, ".") Then Return 1 ;do not allow this char
			If StringInStr($TextToInsert, "!") Then Return 1 ;do not allow this char
			If StringInStr($TextToInsert, "?") Then Return 1 ;do not allow this char
			If StringInStr($TextToInsert, "°") Then Return 1 ;do not allow this char
			If StringInStr($TextToInsert, ",") Then Return 1 ;do not allow this char
			If StringInStr($TextToInsert, '"') Then Return 1 ;do not allow this char
			If StringInStr($TextToInsert, "'") Then Return 1 ;do not allow this char
			If StringInStr($TextToInsert, "*") Then Return 1 ;do not allow this char
			If StringInStr($TextToInsert, "^") Then Return 1 ;do not allow this char
			If StringInStr($TextToInsert, ":") Then Return 1 ;do not allow this char
			If StringInStr($TextToInsert, "/") Then Return 1 ;do not allow this char
			If StringInStr($TextToInsert, "\") Then Return 1 ;do not allow this char
			If StringInStr($TextToInsert, "|") Then Return 1 ;do not allow this char
			If StringInStr($TextToInsert, "%") Then Return 1 ;do not allow this char
			If StringInStr($TextToInsert, "<") Then Return 1 ;do not allow this char
			If StringInStr($TextToInsert, ">") Then Return 1 ;do not allow this char
			If StringInStr($TextToInsert, "~") Then Return 1 ;do not allow this char

;~ 		;Do not allow spaces in these two controls
;~ 		if $SelectedControl =  $neues_projekt_projektdatei_name OR $SelectedControl =  $new_projectmainfile Then
;~ 			 if StringInStr($TextToInsert, " ") then return 1 ;do not allow this char
;~ 		EndIf

	EndSwitch

	Return $GUI_RUNDEFMSG
EndFunc   ;==>_ISN_NewProjectDialog_InteliwriteSubClass

Func _ISN_NewProjectDialog_InteliwriteSubClass_RefreshProjectPath()
	Local $NewProjectName_Input = GUICtrlRead($new_projectname)

	If GUICtrlRead($new_projectstammordner_checkbox) = $GUI_UNCHECKED Then
		If $NewProjectName_Input <> "" Then GUICtrlSetData($new_projectmainfile_create_in_folder, _ISN_Variablen_aufloesen($Projectfolder & "\" & $NewProjectName_Input))
	Else
		If GUICtrlRead($new_projectmainfile_create_in_folder) <> "" Then GUICtrlSetData($new_projectmainfile_create_in_folder, "")
		If GUICtrlRead($new_projectusefollowingmainfile_input) <> "" Then GUICtrlSetData($new_projectmainfile_create_in_folder, StringTrimRight(GUICtrlRead($new_projectusefollowingmainfile_input), StringLen(GUICtrlRead($new_projectusefollowingmainfile_input)) - StringInStr(GUICtrlRead($new_projectusefollowingmainfile_input), "\", 0, -1) + 1))
	EndIf
EndFunc   ;==>_ISN_NewProjectDialog_InteliwriteSubClass_RefreshProjectPath


Func _ISN_NewProjectDialog_InteliwriteSubClass_RadioEvent()
	If GUICtrlRead($new_project_aenderungsprotokolle_checkbox) = $GUI_CHECKED Then
		GUICtrlSetState($new_project_aenderungsprotokolle_author_checkbox, $GUI_ENABLE)
	Else
		GUICtrlSetState($new_project_aenderungsprotokolle_author_checkbox, $GUI_DISABLE)
	EndIf

	If GUICtrlRead($new_projectvorlage_radio0) = $GUI_CHECKED Then
		GUICtrlSetState($new_projectstammordner_checkbox, $GUI_UNCHECKED)
		_ISN_NewProjectDialog_InteliwriteSubClass_CheckboxChangeSwitchProjectRoot()
		GUICtrlSetState($new_projectvorlage_label, $GUI_DISABLE)
		GUICtrlSetState($new_projectmainfile_label, $GUI_ENABLE)
		GUICtrlSetState($new_projectvorlage_combo, $GUI_DISABLE)
		GUICtrlSetState($new_projectmainfile, $GUI_ENABLE)

		GUICtrlSetState($new_projectusefollowingmainfile_label, $GUI_DISABLE)
		GUICtrlSetState($new_projectusefollowingmainfile_input, $GUI_DISABLE)
		GUICtrlSetState($new_projectusefollowingmainfile_search, $GUI_DISABLE)
		GUICtrlSetState($new_projectstammordner_checkbox, $GUI_DISABLE)

		GUICtrlSetState($new_project_ordnerinhaltkopieren_checkbox, $GUI_DISABLE)
		GUICtrlSetState($new_project_ordnerinhaltkopieren_checkbox, $GUI_UNCHECKED)
	EndIf

	If GUICtrlRead($new_projectvorlage_radio1) = $GUI_CHECKED Then
		GUICtrlSetState($new_projectstammordner_checkbox, $GUI_UNCHECKED)
		_ISN_NewProjectDialog_InteliwriteSubClass_CheckboxChangeSwitchProjectRoot()
		GUICtrlSetState($new_projectvorlage_label, $GUI_ENABLE)
		GUICtrlSetState($new_projectmainfile_label, $GUI_ENABLE)
		GUICtrlSetState($new_projectvorlage_combo, $GUI_ENABLE)
		GUICtrlSetState($new_projectmainfile, $GUI_ENABLE)

		GUICtrlSetState($new_projectusefollowingmainfile_label, $GUI_DISABLE)
		GUICtrlSetState($new_projectusefollowingmainfile_input, $GUI_DISABLE)
		GUICtrlSetState($new_projectusefollowingmainfile_search, $GUI_DISABLE)
		GUICtrlSetState($new_projectstammordner_checkbox, $GUI_DISABLE)
		GUICtrlSetState($new_project_ordnerinhaltkopieren_checkbox, $GUI_DISABLE)
		GUICtrlSetState($new_project_ordnerinhaltkopieren_checkbox, $GUI_UNCHECKED)
	EndIf

	If GUICtrlRead($new_projectvorlage_radio2) = $GUI_CHECKED Then
		GUICtrlSetState($new_projectvorlage_label, $GUI_DISABLE)
		GUICtrlSetState($new_projectmainfile_label, $GUI_DISABLE)
		GUICtrlSetState($new_projectvorlage_combo, $GUI_DISABLE)
		GUICtrlSetState($new_projectmainfile, $GUI_DISABLE)

		GUICtrlSetState($new_projectusefollowingmainfile_label, $GUI_ENABLE)
		GUICtrlSetState($new_projectusefollowingmainfile_input, $GUI_ENABLE)
		GUICtrlSetState($new_projectusefollowingmainfile_search, $GUI_ENABLE)
		GUICtrlSetState($new_projectstammordner_checkbox, $GUI_ENABLE)
		GUICtrlSetState($new_project_ordnerinhaltkopieren_checkbox, $GUI_ENABLE)
	EndIf

EndFunc   ;==>_ISN_NewProjectDialog_InteliwriteSubClass_RadioEvent


Func _ISN_NewProjectDialog_InteliwriteSubClass_CheckboxChangeSwitchProjectRoot()
	If GUICtrlRead($new_projectstammordner_checkbox) = $GUI_CHECKED Then
		GUICtrlSetState($new_project_ordnerinhaltkopieren_checkbox, $GUI_DISABLE)
		GUICtrlSetState($new_project_ordnerinhaltkopieren_checkbox, $GUI_UNCHECKED)
		GUICtrlSetState($new_projectmainfile_create_in_folder_search_button, $GUI_DISABLE)
		GUICtrlSetStyle($new_projectmainfile_create_in_folder, $ES_AUTOHSCROLL + $ES_READONLY)
		_ISN_NewProjectDialog_InteliwriteSubClass_RefreshProjectPath()
	Else
		GUICtrlSetState($new_project_ordnerinhaltkopieren_checkbox, $GUI_ENABLE)
		GUICtrlSetState($new_projectmainfile_create_in_folder_search_button, $GUI_ENABLE)
		GUICtrlSetStyle($new_projectmainfile_create_in_folder, $ES_AUTOHSCROLL)
		_ISN_NewProjectDialog_InteliwriteSubClass_RefreshProjectPath()
	EndIf
EndFunc   ;==>_ISN_NewProjectDialog_InteliwriteSubClass_CheckboxChangeSwitchProjectRoot

Func _ISN_NewProjectDialog_ChooseNewProjectFolder()
	$SelectedFolder = _WinAPI_BrowseForFolderDlg("", _Get_langstr(298), $BIF_NEWDIALOGSTYLE + $BIF_RETURNONLYFSDIRS, 0, 0, $NEW_PROJECT_GUI)
	If @error Or $SelectedFolder = "" Then Return
	GUICtrlSetData($new_projectmainfile_create_in_folder, $SelectedFolder & "\" & GUICtrlRead($new_projectname))
EndFunc   ;==>_ISN_NewProjectDialog_ChooseNewProjectFolder


Func _Show_New_Project()
	GUICtrlSetData($new_projectname, "")
	GUICtrlSetData($new_projectusefollowingmainfile_input, "")
	If _Config_Read("new_project_author", "") = "" Then
		GUICtrlSetData($new_projectauthor, @UserName)
	Else
		GUICtrlSetData($new_projectauthor, _Config_Read("new_project_author", @UserName))
	EndIf
	GUICtrlSetData($new_projectcomment, "")
	GUICtrlSetData($new_projectversion, "1.0")
	GUICtrlSetData($new_projectmainfile, "")
	GUICtrlSetData($new_projectmainfile_create_in_folder, "")
	GUICtrlSetData($neues_projekt_projektdatei_name, "")
	GUICtrlSetState($new_projectvorlage_radio0, $GUI_UNCHECKED)
	GUICtrlSetState($new_projectvorlage_radio1, $GUI_CHECKED)
	GUICtrlSetState($new_projectvorlage_radio2, $GUI_UNCHECKED)
	GUICtrlSetState($new_projectstammordner_checkbox, $GUI_UNCHECKED)
	GUICtrlSetState($new_project_aenderungsprotokolle_checkbox, $GUI_UNCHECKED)
	GUICtrlSetState($new_project_HighDPIProject_checkbox, $GUI_CHECKED)

	;Enable Subclassing for some controls (for inteliwrite)
	GUIRegisterMsg20($new_projectname, $WM_PASTE, _ISN_NewProjectDialog_InteliwriteSubClass)
	GUIRegisterMsg20($new_projectname, $WM_CHAR, _ISN_NewProjectDialog_InteliwriteSubClass)
	GUIRegisterMsg20($new_projectname, $WM_KEYUP, _ISN_NewProjectDialog_InteliwriteSubClass)

	GUIRegisterMsg20($new_projectmainfile, $WM_PASTE, _ISN_NewProjectDialog_InteliwriteSubClass)
	GUIRegisterMsg20($new_projectmainfile, $WM_CHAR, _ISN_NewProjectDialog_InteliwriteSubClass)
	GUIRegisterMsg20($new_projectmainfile, $WM_KEYUP, _ISN_NewProjectDialog_InteliwriteSubClass)

	GUIRegisterMsg20($neues_projekt_projektdatei_name, $WM_PASTE, _ISN_NewProjectDialog_InteliwriteSubClass)
	GUIRegisterMsg20($neues_projekt_projektdatei_name, $WM_CHAR, _ISN_NewProjectDialog_InteliwriteSubClass)
	GUIRegisterMsg20($neues_projekt_projektdatei_name, $WM_KEYUP, _ISN_NewProjectDialog_InteliwriteSubClass)


	$state = WinGetState($projectmanager, "")
	If BitAND($state, 2) Then
		GUISetState(@SW_SHOW, $NEW_PROJECT_GUI)
		GUISetState(@SW_DISABLE, $projectmanager)
	Else
		GUISetState(@SW_SHOW, $NEW_PROJECT_GUI)
		GUISetState(@SW_HIDE, $Welcome_GUI)
	EndIf

	ScanforTemplates_Combo()
	_ISN_NewProjectDialog_InteliwriteSubClass_CheckboxChangeSwitchProjectRoot()
	_ISN_NewProjectDialog_InteliwriteSubClass_RadioEvent()

EndFunc   ;==>_Show_New_Project

Func _Search_for_mainfile()
	If $Skin_is_used = "true" Then
		$var = _WinAPI_OpenFileDlg(_Get_langstr(187), "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}", "AutoIt 3 Skript (*.au3)", 0, '', '', BitOR($OFN_PATHMUSTEXIST, $OFN_FILEMUSTEXIST, $OFN_HIDEREADONLY), $OFN_EX_NOPLACESBAR, 0, 0, $NEW_PROJECT_GUI)
	Else
		$var = FileOpenDialog(_Get_langstr(187), "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}", "AutoIt 3 Skript (*.au3)", 1 + 2, "", $NEW_PROJECT_GUI)
	EndIf
	FileChangeDir(@ScriptDir)
	If @error Then Return
	If $var = "" Then Return
	GUICtrlSetData($new_projectusefollowingmainfile_input, $var)
	If GUICtrlRead($new_projectstammordner_checkbox) = $GUI_CHECKED Then _ISN_NewProjectDialog_InteliwriteSubClass_RefreshProjectPath()
EndFunc   ;==>_Search_for_mainfile



Func _hide_NEW_Project()
	;Disable Subclassing for some controls (for inteliwrite)
	GUIUnRegisterMsg20($new_projectname, $WM_PASTE, _ISN_NewProjectDialog_InteliwriteSubClass)
	GUIUnRegisterMsg20($new_projectname, $WM_CHAR, _ISN_NewProjectDialog_InteliwriteSubClass)
	GUIUnRegisterMsg20($new_projectname, $WM_KEYUP, _ISN_NewProjectDialog_InteliwriteSubClass)

	GUIUnRegisterMsg20($new_projectmainfile, $WM_PASTE, _ISN_NewProjectDialog_InteliwriteSubClass)
	GUIUnRegisterMsg20($new_projectmainfile, $WM_CHAR, _ISN_NewProjectDialog_InteliwriteSubClass)
	GUIUnRegisterMsg20($new_projectmainfile, $WM_KEYUP, _ISN_NewProjectDialog_InteliwriteSubClass)

	GUIUnRegisterMsg20($neues_projekt_projektdatei_name, $WM_PASTE, _ISN_NewProjectDialog_InteliwriteSubClass)
	GUIUnRegisterMsg20($neues_projekt_projektdatei_name, $WM_CHAR, _ISN_NewProjectDialog_InteliwriteSubClass)
	GUIUnRegisterMsg20($neues_projekt_projektdatei_name, $WM_KEYUP, _ISN_NewProjectDialog_InteliwriteSubClass)



	$state = WinGetState($projectmanager, "")
	If BitAND($state, 2) Then
		GUISetState(@SW_ENABLE, $projectmanager)
		GUISetState(@SW_HIDE, $NEW_PROJECT_GUI)
	Else
		GUISetState(@SW_SHOW, $Welcome_GUI)
		GUISetState(@SW_HIDE, $NEW_PROJECT_GUI)
	EndIf
EndFunc   ;==>_hide_NEW_Project

Func ScanforTemplates_Combo()
	GUICtrlSetData($new_projectvorlage_combo, "", "")
	GUICtrlSetData($neue_datei_vorlagen_combo, "", "")
	Local $Search
	Local $file
	Local $FileAttributes
	Local $FullFilePath
	$Count = 0
	$Search = FileFindFirstFile(_ISN_Variablen_aufloesen($templatefolder & "\*.*"))
	$Combostring = ""
	While 1
		If $Search = -1 Then
			ExitLoop
		EndIf
		$file = FileFindNextFile($Search)
		If @error Then ExitLoop
		If $file = "." Or $file = ".." Then ContinueLoop
		$FullFilePath = _ISN_Variablen_aufloesen($templatefolder & "\" & $file)
		$FileAttributes = FileGetAttrib($FullFilePath)
		If StringInStr($FileAttributes, "D") Then
			If FileExists(_Finde_Projektdatei($FullFilePath)) Then
				$Count = $Count + 1
				$folder = $FullFilePath
				$new_projectvorlage_combo_ARRAY[$Count] = $folder
				$Combostring = $Combostring & IniRead(_Finde_Projektdatei($FullFilePath), "ISNAUTOITSTUDIO", "name", "#ERROR#") & "|"
			EndIf
		EndIf
	WEnd
	FileClose($Search)
	GUICtrlSetData($new_projectvorlage_combo, $Combostring, "Default Template")
	GUICtrlSetData($neue_datei_vorlagen_combo, $Combostring, "Default Template")
EndFunc   ;==>ScanforTemplates_Combo

Func _tryotopeninexplorer($file)
	If $file = $Offenes_Projekt & "\" & IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "name", "#ERROR#") Then
		Run("explorer.exe /e,/select, " & FileGetShortName($Offenes_Projekt))
	Else
		Run("explorer.exe /e,/select, " & FileGetShortName($file))
	EndIf
EndFunc   ;==>_tryotopeninexplorer

Func _Make_Temp_project()
	$Tempmode = 1
	$randommode = Int(Random(0, 400, 1))
	DirCreate(_ISN_Variablen_aufloesen($Projectfolder & "\temp" & $randommode))
	_Leere_UTF16_Datei_erstellen(_ISN_Variablen_aufloesen($Projectfolder & "\temp" & $randommode & "\project.isn"))
	IniWrite(_ISN_Variablen_aufloesen($Projectfolder & "\temp" & $randommode & "\project.isn"), "ISNAUTOITSTUDIO", "name", "temp")
	IniWrite(_ISN_Variablen_aufloesen($Projectfolder & "\temp" & $randommode & "\project.isn"), "ISNAUTOITSTUDIO", "author", "")
	IniWrite(_ISN_Variablen_aufloesen($Projectfolder & "\temp" & $randommode & "\project.isn"), "ISNAUTOITSTUDIO", "mainfile", "temp.au3")
	_FileCreate(_ISN_Variablen_aufloesen($Projectfolder & "\temp" & $randommode & "\temp.au3"))
	_Load_Project_by_Foldername(_ISN_Variablen_aufloesen($Projectfolder & "\temp" & $randommode))
	Sleep(200)
	_Show_Warning("confirmtempproject", 513, _Get_langstr(394), _Get_langstr(399), _Get_langstr(7))
EndFunc   ;==>_Make_Temp_project

Func _Run_Beforstart()
	WinSetTitle($waiter_GUI, "", _Get_langstr(403))
	GUICtrlSetData($waiter_GUI_str1, _Get_langstr(403))
	GUICtrlSetData($waiter_GUI_str2, _Get_langstr(404))
	GUISetState(@SW_SHOW, $waiter_GUI)
	RunWait($runbefore)
	GUISetState(@SW_HIDE, $waiter_GUI)
EndFunc   ;==>_Run_Beforstart

Func _Run_Beforexit()
	WinSetTitle($waiter_GUI, "", _Get_langstr(405))
	GUICtrlSetData($waiter_GUI_str1, _Get_langstr(405))
	GUICtrlSetData($waiter_GUI_str2, _Get_langstr(406))
	GUISetState(@SW_SHOW, $waiter_GUI)
	RunWait($runafter)
	GUISetState(@SW_HIDE, $waiter_GUI)
EndFunc   ;==>_Run_Beforexit





Func _Select_next_tab()
	If $Offenes_Projekt = "" Then Return
	If _GUICtrlTab_GetItemCount($htab) = 0 Then Return
	$current_tab = _GUICtrlTab_GetCurFocus($htab)
	$to_select = _GUICtrlTab_GetCurFocus($htab) + 1
	If $to_select > _GUICtrlTab_GetItemCount($htab) - 1 Then $to_select = 0
	Sleep(150)
	If Not _IsPressed('11', $user32) Then $to_select = $Tabswitch_last_Tab
	_GUICtrlTab_ActivateTabX($htab, $to_select)
	_Show_Tab($to_select)
	$Tabswitch_last_Tab = $current_tab
EndFunc   ;==>_Select_next_tab



Func _Select_previous_tab()
	If $Offenes_Projekt = "" Then Return
	If _GUICtrlTab_GetItemCount($htab) = 0 Then Return
	$to_select = _GUICtrlTab_GetCurFocus($htab) - 1
	If $to_select < 0 Then $to_select = _GUICtrlTab_GetItemCount($htab) - 1
	_GUICtrlTab_ActivateTabX($htab, $to_select)
	_Show_Tab($to_select)
EndFunc   ;==>_Select_previous_tab

Func _minimize_studio()
	GUISetState(@SW_MINIMIZE, $Studiofenster)
EndFunc   ;==>_minimize_studio

Func _Toggle_Fullscreen() ;for typo
	Return _Toggle_Fulscreen()
EndFunc   ;==>_Toggle_Fullscreen





Func _Toggle_Fulscreen()
	If $Fulscreen_Mode = 0 Then
		$Fulscreen_Mode = 1
		$WM_ENTERSIZEMOVE_StudiofensterWinPos = _WinGetPos($Studiofenster)
		GUISetStyle(BitOR($WS_CLIPCHILDREN, $WS_POPUP), $WS_EX_ACCEPTFILES, $Studiofenster)
		_WinAPI_SetClassLongEx($Studiofenster, $GCL_STYLE, BitAND(_WinAPI_GetClassLongEx($Studiofenster, $GCL_STYLE), BitNOT(1), BitNOT(2))) ;unset CS_HREDRAW and CS_VREDRAW flags. Prevent flickering on resite. thx to binhnx!
		;_MaxOnMonitor($Studiofenster, "", $Runonmonitor)
		WinSetState($Studiofenster, "", @SW_MAXIMIZE)
	Else
		$Fulscreen_Mode = 0
		$WM_ENTERSIZEMOVE_StudiofensterWinPos = _WinGetPos($Studiofenster)
		GUISetStyle(BitOR($WS_CAPTION, $WS_POPUP, $WS_SYSMENU, $WS_DLGFRAME, $WS_SIZEBOX, $WS_MINIMIZEBOX, $WS_MAXIMIZEBOX, $WS_CLIPCHILDREN), $WS_EX_ACCEPTFILES, $Studiofenster)
		_WinAPI_SetClassLongEx($Studiofenster, $GCL_STYLE, BitAND(_WinAPI_GetClassLongEx($Studiofenster, $GCL_STYLE), BitNOT(1), BitNOT(2))) ;unset CS_HREDRAW and CS_VREDRAW flags. Prevent flickering on resite. thx to binhnx!
		;_CenterOnMonitor($Studiofenster, "", $Runonmonitor)
		WinSetState($Studiofenster, "", @SW_MAXIMIZE)
	EndIf
	_GUICtrlStatusBar_Resize($Status_bar)
	_Rezize(1, 1)
EndFunc   ;==>_Toggle_Fulscreen






Func _monitore_identifizieren()
	GUICtrlSetState($darstellung_identify, $GUI_DISABLE)
	Global $identifizieren_Guis[20]
	For $Count = 1 To $__MonitorList[0][0]
		$identifizieren_Guis[$Count] = GUICreate("", 800, 700, -1, -1, $WS_POPUP, $WS_EX_LAYERED + $WS_EX_TOPMOST + $WS_EX_TOOLWINDOW)
		_CenterOnMonitor($identifizieren_Guis[$Count], "", $Count, 1)
		GUICtrlCreateLabel($Count, 0, 0, 800, 800, $SS_CENTER)
		GUICtrlSetBkColor(-1, -2)
		GUICtrlSetFont(-1, 400, 400, 0, "Arial")
		GUISetBkColor(0xABCDEF, $identifizieren_Guis[$Count])
		_WinAPI_SetLayeredWindowAttributes($identifizieren_Guis[$Count], 0xABCDEF, 255)
		GUISetState(@SW_SHOW, $identifizieren_Guis[$Count])
	Next
	Sleep(2500) ;wait 2,5 secounds
	For $Count = 1 To $__MonitorList[0][0]
		GUIDelete($identifizieren_Guis[$Count])
	Next
	GUICtrlSetState($darstellung_identify, $GUI_ENABLE)
EndFunc   ;==>_monitore_identifizieren

Func _ColourInvert($iRGB = "")
	If BitShift(BitAND($iRGB, 0xFF0000), 16) + BitShift(BitAND($iRGB, 0x00FF00), 8) + BitAND($iRGB, 0x0000FF) < 3 * 255 / 2 Then
		Return 0xFFFFFF
	Else
		Return 0x000000
	EndIf
EndFunc   ;==>_ColourInvert

Func _Drag_and_drop_import_file($Count, $files)
	WinActivate($Studiofenster)
	Local $Datei
	$PauseRDCEvents = 1
	If $Studiomodus = 1 Then
		$res = _WinAPI_BrowseForFolderDlg($Offenes_Projekt, _Get_langstr(59), $BIF_NEWDIALOGSTYLE + $BIF_RETURNONLYFSDIRS, 0, 0, $Studiofenster)
	Else
		$res = _WinAPI_BrowseForFolderDlg("", _Get_langstr(59), $BIF_NEWDIALOGSTYLE + $BIF_RETURNONLYFSDIRS, 0, 0, $Studiofenster)
	EndIf
	If @error Or $res = "" Then
		$PauseRDCEvents = 0
		Return
	Else
		$PauseRDCEvents = 0
		For $x = 0 To $Count - 1
			$Datei = StringTrimLeft($files[$x], StringInStr($files[$x], "\", 0, -1))
			$Porjecttree_FileToSelect_after_Update = $res & "\" & $Datei
			_FileOperationProgress($files[$x], $res, 1, $FO_COPY, $FOF_SIMPLEPROGRESS + $FOF_NOCONFIRMATION)
			If @extended == 1 Then ;ERROR
				Return
			EndIf
			_Write_log($files[$x] & " " & _Get_langstr(63))
		Next
		FileChangeDir(@ScriptDir)
		;_Update_Treeview()
		MsgBox(262144 + 64, _Get_langstr(61), _Get_langstr(60), 0, $Studiofenster)
		If $Count > 14 Then _Earn_trophy(7, 2)
	EndIf
EndFunc   ;==>_Drag_and_drop_import_file

Func _GetToolbarButtonScreenPos($hWnd, $hTb, $iCmdID, $iOffset = 0, $iIndex = 0, $hRbar = -1)
	; Author: rover 04/08/2008
	; this UDF integrates _WinAPI_ClientToScreen() from WinAPI.au3 include.
	; _GUICtrlMenu_TrackPopupMenu() uses screen coordinates to place dropdown menu.
	; button client coordinates must be converted to screen coordinates.
	; $hRbar and $iIndex is for optional Rebar hwnd and band index
	; $iOffset sets menu Y position below button
	; Update: 06/27/2009 added offset for menu position below button, corrected left off-screen menu positioning.
	; Update: 07/13/2009 added compensation for CCS_NORESIZE and RBS_BANDBORDERS style alignment problems. cleaned up error handling.
	Local $aBorders, $aBandRect, $aRect, $tPOINT, $pPoint, $aRet[2]
	Local $aRect = _GUICtrlToolbar_GetButtonRect($hTb, $iCmdID)
	If @error Then Return SetError(@error, 0, $aRet)
	$tPOINT = DllStructCreate("int X;int Y")
	DllStructSetData($tPOINT, "X", $aRect[0])
	DllStructSetData($tPOINT, "Y", $aRect[3])
	$pPoint = DllStructGetPtr($tPOINT)
	DllCall("User32.dll", "int", "ClientToScreen", "hwnd", $hWnd, "ptr", $pPoint)
	If @error Then Return SetError(@error, 0, $aRet)
	; X screen coordinate of dropdown button left corner
	$aRet[0] = DllStructGetData($tPOINT, "X")
	;limit X coordinate to 0 if button partially off-screen
;~         If $aRet[0] < 0 Then $aRet[0] = 0 ;bugfix for MultiMonitor Support
	; Y screen coordinate of dropdown button left corner
	$aRet[1] = DllStructGetData($tPOINT, "Y") + Number($iOffset)
	;#cs  comment out if not using rebars
	If $hRbar <> -1 And IsHWnd($hRbar) And IsNumber($iIndex) Then
		If BitAND(_SendMessage($hTb, $TB_GETSTYLE), $CCS_NORESIZE) = $CCS_NORESIZE Then
			$aBorders = _GUICtrlRebar_GetBandBorders($hRbar, $iIndex)
			If @error Then Return SetError(@error, 0, $aRet)
			$aBandRect = _GUICtrlRebar_GetBandRect($hRbar, $iIndex)
			If @error Then Return SetError(@error, 0, $aRet)
			; X screen coordinate of dropdown button left corner
			; add or subtract 2 pixel border of bounding rectangle for band in rebar control
			If BitAND(_WinAPI_GetWindowLong($hReBar, $GWL_STYLE), $RBS_BANDBORDERS) = 0 Then $aBandRect[0] = -$aBandRect[0]
			If $aRet[0] <> 0 Then $aRet[0] += ($aBorders[0] - $aBandRect[0])
		EndIf
	EndIf
	;#ce
	Return $aRet ; return X,Y screen coordinates of toolbar dropdown button lower left corner
EndFunc   ;==>_GetToolbarButtonScreenPos




Func _Fadeout_logo()
	If $enablelogo = "true" Then
		$Alpha = 255
		While 1
			Sleep(1)
			$Alpha = $Alpha - 20
			If $Alpha < 0 Then $Alpha = 0
			If $Alpha = 0 Then ExitLoop
			WinSetTrans($ISN_StartupLogoGUI, "", $Alpha)
		WEnd
		WinSetTrans($ISN_StartupLogoGUI, "", 0)
		GUISetState(@SW_HIDE, $ISN_StartupLogoGUI)
	Else
		GUISetState(@SW_HIDE, $ISN_StartupLogoGUI)
	EndIf
EndFunc   ;==>_Fadeout_logo

Func _ISN_Hide_StartupLogo()
	GUISetState(@SW_HIDE, $ISN_StartupLogoGUI)
EndFunc   ;==>_ISN_Hide_StartupLogo

Func _Show_Parameterconfig()
	Local $array_params
	$Params = _IniReadRaw($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "testparam", "")
	GUICtrlSetData($startparameter_input, StringReplace($Params, "#BREAK#", @CRLF))
	GUISetState(@SW_SHOW, $parameter_GUI)
	GUISetState(@SW_DISABLE, $Studiofenster)
	_GUICtrlEdit_SetSel($startparameter_input, -1, -1)
EndFunc   ;==>_Show_Parameterconfig

Func _HIDE_Parameterconfig()
	$Param_String = GUICtrlRead($startparameter_input)
	$Param_String = StringReplace($Param_String, @CRLF, "#BREAK#")
	IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "testparam", $Param_String)
	GUISetState(@SW_ENABLE, $Studiofenster)
	GUISetState(@SW_HIDE, $parameter_GUI)
EndFunc   ;==>_HIDE_Parameterconfig

Func _HIDE_Parameterconfig_without_save()
	GUISetState(@SW_ENABLE, $Studiofenster)
	GUISetState(@SW_HIDE, $parameter_GUI)
EndFunc   ;==>_HIDE_Parameterconfig_without_save

Func _Open_Homepage()
	ShellExecute("https://www.isnetwork.at")
EndFunc   ;==>_Open_Homepage

Func _Open_Weitere_Plugins_Downloaden()
	ShellExecute("https://www.isnetwork.at/isn-plugins/")
EndFunc   ;==>_Open_Weitere_Plugins_Downloaden

Func _Open_Forum()
	ShellExecute("https://www.isnetwork.at/forum")
EndFunc   ;==>_Open_Forum

Func _ISN_AutoIt_Studio_Spenden()
	ShellExecute("https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=S94VE64V6HYP2&lc=AT&item_name=Spende%20fuer%20ISN%20AutoIt%20Studio&currency_code=EUR&bn=PP%2dDonationsBF%3abtn_donateCC_LG%2egif%3aNonHosted")
EndFunc   ;==>_ISN_AutoIt_Studio_Spenden

Func _WillkommenGUI_Wechsle_Nich_mehr_anzeigen_Checkbox()
	If GUICtrlRead($Willkommen_autoloadcheckbox) = $GUI_UNCHECKED Then
		GUICtrlSetState($Willkommen_autoloadcheckbox, $GUI_CHECKED)
	Else
		GUICtrlSetState($Willkommen_autoloadcheckbox, $GUI_UNCHECKED)
	EndIf
	_toggle_Willkommen_Autoload()
EndFunc   ;==>_WillkommenGUI_Wechsle_Nich_mehr_anzeigen_Checkbox

Func _IniReadRaw($inifile, $header, $key, $defval = "")
	Local $arr = IniReadSection($inifile, $header)
	If @error Or Not IsArray($arr) Then Return SetError(1, 0, $defval)

	For $i = 1 To $arr[0][0]
		If $arr[$i][0] == $key Then Return $arr[$i][1]
	Next

	Return SetError(1, 1, $defval)
EndFunc   ;==>_IniReadRaw


Func _Resize_Elements_to_Window($no_tabrefresh = 0)

	$size_new_resize = _WinGetClientSize($Studiofenster, "")
	If BitAND(WinGetState($Studiofenster, ""), 16) Then Return
	If Not IsArray($size_before_resize) Then Return
	If Not IsArray($size_new_resize) Then Return
	If $size_new_resize[0] < 0 Then Return
	If $size_new_resize[1] < 0 Then Return
	If $size_new_resize[0] = 0 Then Return ;Fenster ist Minimiert
	If $size_new_resize[1] = 0 Then Return ;Fenster ist Minimiert
	If $size_before_resize[0] = 0 Then Return ;Fenster ist Minimiert
	If $size_before_resize[1] = 0 Then Return ;Fenster ist Minimiert
	$dif0 = $size_before_resize[0] - $size_new_resize[0]
	$dif1 = $size_before_resize[1] - $size_new_resize[1]
	If $dif0 = 0 And $dif1 = 0 Then Return

	;Abgrenzung setzen
	GUICtrlSetPos($Abgrenzung_vor_statusbar, -10, $size_new_resize[1] - (_GUICtrlStatusBar_GetHeight($Status_bar)) - $Splitter_Rand - $Splitter_Rand - 2, 9999, 2)

	;Sci Debug Output
	If $IS_HIDDEN_UNTEN = 1 Or $hidedebug = "true" Then
	Else
		GUICtrlSetPos($Middle_Splitter_Y, Default, ($size_new_resize[1] / 100) * Number(_Config_Read("Middle_Splitter_Y", $Mittlerer_Splitter_Y_default)))
	EndIf

	;Splitter zwischen Projektbaum und QuickView
	GUICtrlSetPos($Left_Splitter_Y, 2, ($size_new_resize[1] / 100) * Number(_Config_Read("Left_Splitter_Y", $Linker_Splitter_Y_default)))

	;Splitter zwischen projektbaum und Sci
	If $Toggle_Leftside = 0 Then GUICtrlSetPos($Left_Splitter_X, ($size_new_resize[0] / 100) * Number(_Config_Read("Left_Splitter_X", $Linker_Splitter_X_default)))

	;Splitter zwischen Skriptbaum und Sci
	If $hidefunctionstree = "true" Or $IS_HIDDEN_RECHTS = 1 Or $Toggle_rightside = 1 Then
		GUICtrlSetPos($Right_Splitter_X, $size_new_resize[0] - 2, 25, $Splitter_Breite, $size_new_resize[1] - 80)
	Else
		GUICtrlSetPos($Right_Splitter_X, ($size_new_resize[0] / 100) * Number(_Config_Read("Right_Splitter_X", $Rechter_Splitter_X_default)))
	EndIf

	;Dual Editor Splitter
	If $Scripteditor_EnableDualEditor = "true" Then
		If $Scripteditor_DualEditorView = "vertical" Then
			GUICtrlSetPos($Splitter_DualEditor, ($size_new_resize[0] / 100) * Number(_Config_Read("Dual_Splitter_Vertical", $Splitter_DualEditor_DefaultVertical)))
		Else
			GUICtrlSetPos($Splitter_DualEditor, 2, ($size_new_resize[1] / 100) * Number(_Config_Read("Dual_Splitter_Horizontal", $Splitter_DualEditor_DefaultHorizontal)))
		EndIf
	EndIf
	$size_before_resize = "" ;invalidate the old array
	If $no_tabrefresh = 0 Then _Show_Tab(_GUICtrlTab_GetCurFocus($htab))
EndFunc   ;==>_Resize_Elements_to_Window

Func _Try_to_open_external_file()
	If $Offenes_Projekt = "" Then Return
	_Lock_Plugintabs("lock")
	Local $InitDir = "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}"

	If $Studiomodus = 1 Then
		$InitDir = "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}"
	Else
		Local $Selected_Path = _GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView)
		If FileExists($Selected_Path) Then
			Local $FileAttributes = FileGetAttrib($Selected_Path)
			If Not StringInStr($FileAttributes, "D") And StringInStr($Selected_Path, ".") Then $Selected_Path = StringTrimRight($Selected_Path, StringLen($Selected_Path) - StringInStr($Selected_Path, "\", 0, -1))
			If StringRight($Selected_Path, 1) = "\" And Not _WinAPI_PathIsRoot($Selected_Path) Then $Selected_Path = StringTrimRight($Selected_Path, 1)
			$InitDir = $Selected_Path
		EndIf
	EndIf

	If $Skin_is_used = "true" Then
		$Dateipfad = _WinAPI_OpenFileDlg(_Get_langstr(509), $InitDir, _Get_langstr(58) & " (*.*)", 0, '', '', BitOR($OFN_PATHMUSTEXIST, $OFN_FILEMUSTEXIST, $OFN_HIDEREADONLY), $OFN_EX_NOPLACESBAR, 0, 0, $Studiofenster)
	Else
		$Dateipfad = FileOpenDialog(_Get_langstr(509), $InitDir, _Get_langstr(58) & " (*.*)", 1 + 2, "", $Studiofenster)
	EndIf
	_Lock_Plugintabs("unlock")
	FileChangeDir(@ScriptDir)
	WinActivate($Studiofenster)
	GUISwitch($Studiofenster)
	If $Dateipfad = "" Then Return
	If @error Then
		Return
	Else

		Try_to_opten_file($Dateipfad)
	EndIf
EndFunc   ;==>_Try_to_open_external_file

Func _GUISetIcon($hHandle, $sFile, $iName)
	;Edit by isi360
	Return _SendMessage($hHandle, $WM_SETICON, 1, _WinAPI_ShellExtractIcon($sFile, $iName, 16, 16))
EndFunc   ;==>_GUISetIcon



Func _open_windowinfotool()
	If $Offenes_Projekt = "" Then Return
	If Not FileExists($Au3Infoexe) Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1168), 0, $Studiofenster)
		Return
	EndIf

	If ProcessExists(StringTrimLeft($Au3Infoexe, StringInStr($Au3Infoexe, "\", 0, -1))) Then
		ProcessClose(StringTrimLeft($Au3Infoexe, StringInStr($Au3Infoexe, "\", 0, -1)))
	Else
		ShellExecute($Au3Infoexe)
	EndIf
EndFunc   ;==>_open_windowinfotool

Func _Toggle_msgboxcreator()
	If $Offenes_Projekt = "" Then Return
	If _Pruefe_auf_Type3_Plugin($Plugin_Platzhalter_MSGBoxGenerator) <> -1 Then Return ;Platzhalter für Plugin
	$state = WinGetState($msgboxcreator, "")
	If BitAND($state, 2) Then
		GUISetState(@SW_HIDE, $msgboxcreator)
	Else
		If _GUICtrlTab_GetItemCount($htab) = 0 Then Return
		If $Plugin_Handle[_GUICtrlTab_GetCurFocus($htab)] <> -1 Then Return
		If $Offenes_Projekt = "" Then Return
		GUISetState(@SW_SHOW, $msgboxcreator)
	EndIf
	_Msgbox_generator_set_state()
EndFunc   ;==>_Toggle_msgboxcreator

Func _Zeichen_fuer_Handle_ersetzen($handle = "")
	If $handle = "" Then Return $handle
	$handle = StringReplace($handle, "=", "")
	$handle = StringReplace($handle, "?", "")
	$handle = StringReplace($handle, "!", "")
	$handle = StringReplace($handle, "+", "")
	$handle = StringReplace($handle, "\", "")
	$handle = StringReplace($handle, "/", "")
	$handle = StringReplace($handle, "%", "")
	$handle = StringReplace($handle, "ö", "")
	$handle = StringReplace($handle, "ä", "")
	$handle = StringReplace($handle, "ü", "")
	$handle = StringReplace($handle, "#", "")
	$handle = StringReplace($handle, "(", "")
	$handle = StringReplace($handle, ")", "")
	$handle = StringReplace($handle, " ", "")
	Return $handle
EndFunc   ;==>_Zeichen_fuer_Handle_ersetzen

Func _Msgbox_generator_set_state()
	$buttons = 0

	If GUICtrlRead($msgbox_creator_radio_buttons1) = $GUI_CHECKED Then $buttons = 0
	If GUICtrlRead($msgbox_creator_radio_buttons2) = $GUI_CHECKED Then $buttons = 2
	If GUICtrlRead($msgbox_creator_radio_buttons3) = $GUI_CHECKED Then $buttons = 2
	If GUICtrlRead($msgbox_creator_radio_buttons4) = $GUI_CHECKED Then $buttons = 3
	If GUICtrlRead($msgbox_creator_radio_buttons5) = $GUI_CHECKED Then $buttons = 3
	If GUICtrlRead($msgbox_creator_radio_buttons6) = $GUI_CHECKED Then $buttons = 2
	If GUICtrlRead($msgbox_creator_radio_buttons7) = $GUI_CHECKED Then $buttons = 3

	GUICtrlSetState($msgbox_creator_radio_defbutton1, $GUI_CHECKED)
	GUICtrlSetState($msgbox_creator_radio_defbutton1, $GUI_DISABLE)
	GUICtrlSetState($msgbox_creator_radio_defbutton2, $GUI_DISABLE)
	GUICtrlSetState($msgbox_creator_radio_defbutton3, $GUI_DISABLE)
	If $buttons > 0.9 Then GUICtrlSetState($msgbox_creator_radio_defbutton1, $GUI_ENABLE)
	If $buttons > 1.9 Then GUICtrlSetState($msgbox_creator_radio_defbutton2, $GUI_ENABLE)
	If $buttons > 2.9 Then GUICtrlSetState($msgbox_creator_radio_defbutton3, $GUI_ENABLE)
EndFunc   ;==>_Msgbox_generator_set_state

Func _msgboxcreator_vorschau()

	$flags = 0
	$text = StringReplace(GUICtrlRead($msgbox_creator_edit), '"', "'")
	If GUICtrlRead($msgbox_creator_icon1) = $GUI_CHECKED Then $flags = $flags + 0
	If GUICtrlRead($msgbox_creator_icon2) = $GUI_CHECKED Then $flags = $flags + 16
	If GUICtrlRead($msgbox_creator_icon3) = $GUI_CHECKED Then $flags = $flags + 48
	If GUICtrlRead($msgbox_creator_icon4) = $GUI_CHECKED Then $flags = $flags + 64
	If GUICtrlRead($msgbox_creator_icon5) = $GUI_CHECKED Then $flags = $flags + 32

	If GUICtrlRead($msgbox_creator_vordergrund_checkbox) = $GUI_CHECKED Then $flags = $flags + 262144
	If GUICtrlRead($msgbox_creator_text_rechts_checkbox) = $GUI_CHECKED Then $flags = $flags + 524288
	If GUICtrlRead($msgbox_creator_hasicon_checkbox) = $GUI_CHECKED Then $flags = $flags + 4096

	If GUICtrlRead($msgbox_creator_radio_buttons1) = $GUI_CHECKED Then $flags = $flags + 0
	If GUICtrlRead($msgbox_creator_radio_buttons2) = $GUI_CHECKED Then $flags = $flags + 1
	If GUICtrlRead($msgbox_creator_radio_buttons3) = $GUI_CHECKED Then $flags = $flags + 4
	If GUICtrlRead($msgbox_creator_radio_buttons4) = $GUI_CHECKED Then $flags = $flags + 3
	If GUICtrlRead($msgbox_creator_radio_buttons5) = $GUI_CHECKED Then $flags = $flags + 2
	If GUICtrlRead($msgbox_creator_radio_buttons6) = $GUI_CHECKED Then $flags = $flags + 5
	If GUICtrlRead($msgbox_creator_radio_buttons7) = $GUI_CHECKED Then $flags = $flags + 6

	If GUICtrlRead($msgbox_creator_radio_defbutton1) = $GUI_CHECKED Then $flags = $flags + 0
	If GUICtrlRead($msgbox_creator_radio_defbutton2) = $GUI_CHECKED Then $flags = $flags + 256
	If GUICtrlRead($msgbox_creator_radio_defbutton3) = $GUI_CHECKED Then $flags = $flags + 512
	MsgBox($flags, GUICtrlRead($msgbox_creator_title), $text, GUICtrlRead($msgbox_creator_timeout), $msgboxcreator)
EndFunc   ;==>_msgboxcreator_vorschau



Func _Insert_msgboxcode()
	If $Offenes_Projekt = "" Then Return
	If GUICtrlRead($msgbox_creator_handle) = "" And GUICtrlRead($msgbox_creator_radio_buttons1) <> $GUI_CHECKED Then
		_Input_Error_FX($msgbox_creator_handle)
		Return
	EndIf
	Local $SCI_to_use = $SCE_EDITOR[_GUICtrlTab_GetCurFocus($htab)]
	If Not StringInStr(GUICtrlRead($msgbox_creator_handle), "$") And GUICtrlRead($msgbox_creator_handle) <> "" Then GUICtrlSetData($msgbox_creator_handle, "$" & GUICtrlRead($msgbox_creator_handle))
	If Not StringInStr(GUICtrlRead($msgbox_creator_parent), "$") And GUICtrlRead($msgbox_creator_parent) <> "" Then GUICtrlSetData($msgbox_creator_parent, "$" & GUICtrlRead($msgbox_creator_parent))
	If _GUICtrlTab_GetItemCount($htab) > 0 Then
		If $Plugin_Handle[_GUICtrlTab_GetCurFocus($htab)] = -1 Then
			$flags = 0

			$parent = ""
			$CODE = ""
			$text = StringReplace(GUICtrlRead($msgbox_creator_edit), '"', "'")
			$asMsgText = StringSplit($text, @CRLF, 1)
			If $asMsgText[0] = 1 Then
				$text = $text
			Else
				$text = $asMsgText[1]
				For $iCtr = 2 To $asMsgText[0]
					$text = $text & Chr(34) & " & @CRLF & " & Chr(34) & $asMsgText[$iCtr]
				Next

			EndIf

			$handle = GUICtrlRead($msgbox_creator_handle)
			$handle = _Zeichen_fuer_Handle_ersetzen($handle)
			GUICtrlSetData($msgbox_creator_handle, $handle)

			$parent = GUICtrlRead($msgbox_creator_parent)
			$parent = _Zeichen_fuer_Handle_ersetzen($parent)
			GUICtrlSetData($msgbox_creator_parent, $parent)

			If GUICtrlRead($msgbox_creator_icon1) = $GUI_CHECKED Then $flags = $flags + 0
			If GUICtrlRead($msgbox_creator_icon2) = $GUI_CHECKED Then $flags = $flags + 16
			If GUICtrlRead($msgbox_creator_icon3) = $GUI_CHECKED Then $flags = $flags + 48
			If GUICtrlRead($msgbox_creator_icon4) = $GUI_CHECKED Then $flags = $flags + 64
			If GUICtrlRead($msgbox_creator_icon5) = $GUI_CHECKED Then $flags = $flags + 32

			If GUICtrlRead($msgbox_creator_vordergrund_checkbox) = $GUI_CHECKED Then $flags = $flags + 262144
			If GUICtrlRead($msgbox_creator_text_rechts_checkbox) = $GUI_CHECKED Then $flags = $flags + 524288
			If GUICtrlRead($msgbox_creator_hasicon_checkbox) = $GUI_CHECKED Then $flags = $flags + 4096

			If GUICtrlRead($msgbox_creator_radio_buttons1) = $GUI_CHECKED Then $flags = $flags + 0
			If GUICtrlRead($msgbox_creator_radio_buttons2) = $GUI_CHECKED Then $flags = $flags + 1
			If GUICtrlRead($msgbox_creator_radio_buttons3) = $GUI_CHECKED Then $flags = $flags + 4
			If GUICtrlRead($msgbox_creator_radio_buttons4) = $GUI_CHECKED Then $flags = $flags + 3
			If GUICtrlRead($msgbox_creator_radio_buttons5) = $GUI_CHECKED Then $flags = $flags + 2
			If GUICtrlRead($msgbox_creator_radio_buttons6) = $GUI_CHECKED Then $flags = $flags + 5
			If GUICtrlRead($msgbox_creator_radio_buttons7) = $GUI_CHECKED Then $flags = $flags + 6

			If GUICtrlRead($msgbox_creator_radio_defbutton1) = $GUI_CHECKED Then $flags = $flags + 0
			If GUICtrlRead($msgbox_creator_radio_defbutton2) = $GUI_CHECKED Then $flags = $flags + 256
			If GUICtrlRead($msgbox_creator_radio_defbutton3) = $GUI_CHECKED Then $flags = $flags + 512

			If GUICtrlRead($msgbox_creator_parent) <> "" Then $parent = ", " & GUICtrlRead($msgbox_creator_parent)

			$Istgleich = ""
			If $handle <> "" Then $Istgleich = " = "

			$CODE = @CRLF & $handle & $Istgleich & "MsgBox(" & $flags & ',"' & GUICtrlRead($msgbox_creator_title) & '","' & $text & '",' & GUICtrlRead($msgbox_creator_timeout) & $parent & ")" & @CRLF

			If GUICtrlRead($msgbox_creator_radio_buttons1) = $GUI_UNCHECKED Then
				$CODE = $CODE & "switch " & GUICtrlRead($msgbox_creator_handle) & @CRLF & @CRLF

				If GUICtrlRead($msgbox_creator_radio_buttons2) = $GUI_CHECKED Then
					$CODE = $CODE & @TAB & "case 1 ;OK" & @CRLF & @TAB & ";Your code here..." & @CRLF & @CRLF
					$CODE = $CODE & @TAB & "case 2 ;CANCEL" & @CRLF & @TAB & ";Your code here..." & @CRLF & @CRLF
				EndIf

				If GUICtrlRead($msgbox_creator_radio_buttons3) = $GUI_CHECKED Then
					$CODE = $CODE & @TAB & "case 6 ;YES" & @CRLF & @TAB & ";Your code here..." & @CRLF & @CRLF
					$CODE = $CODE & @TAB & "case 7 ;NO" & @CRLF & @TAB & ";Your code here..." & @CRLF & @CRLF
				EndIf

				If GUICtrlRead($msgbox_creator_radio_buttons4) = $GUI_CHECKED Then
					$CODE = $CODE & @TAB & "case 6 ;YES" & @CRLF & @TAB & ";Your code here..." & @CRLF & @CRLF
					$CODE = $CODE & @TAB & "case 7 ;NO" & @CRLF & @TAB & ";Your code here..." & @CRLF & @CRLF
					$CODE = $CODE & @TAB & "case 2 ;CANCEL" & @CRLF & @TAB & ";Your code here..." & @CRLF & @CRLF
				EndIf

				If GUICtrlRead($msgbox_creator_radio_buttons5) = $GUI_CHECKED Then
					$CODE = $CODE & @TAB & "case 2 ;CANCEL" & @CRLF & @TAB & ";Your code here..." & @CRLF & @CRLF
					$CODE = $CODE & @TAB & "case 4 ;RETRY" & @CRLF & @TAB & ";Your code here..." & @CRLF & @CRLF
					$CODE = $CODE & @TAB & "case 5 ;IGNORE" & @CRLF & @TAB & ";Your code here..." & @CRLF & @CRLF
				EndIf

				If GUICtrlRead($msgbox_creator_radio_buttons6) = $GUI_CHECKED Then
					$CODE = $CODE & @TAB & "case 5 ;RETRY" & @CRLF & @TAB & ";Your code here..." & @CRLF & @CRLF
					$CODE = $CODE & @TAB & "case 2 ;CANCEL" & @CRLF & @TAB & ";Your code here..." & @CRLF & @CRLF
				EndIf

				If GUICtrlRead($msgbox_creator_radio_buttons7) = $GUI_CHECKED Then
					$CODE = $CODE & @TAB & "case 2 ;CANCEL" & @CRLF & @TAB & ";Your code here..." & @CRLF & @CRLF
					$CODE = $CODE & @TAB & "case 10 ;TRY AGAIN" & @CRLF & @TAB & ";Your code here..." & @CRLF & @CRLF
					$CODE = $CODE & @TAB & "case 11 ;CONTINUE" & @CRLF & @TAB & ";Your code here..." & @CRLF & @CRLF
				EndIf

				$CODE = $CODE & "endswitch" & @CRLF
			EndIf

			If $autoit_editor_encoding = "2" Then
				Sci_InsertText($SCI_to_use, Sci_GetCurrentPos($SCI_to_use), _UNICODE2ANSI($CODE))
			Else
				Sci_InsertText($SCI_to_use, Sci_GetCurrentPos($SCI_to_use), $CODE)
			EndIf
			_Check_Buttons(0)
		EndIf
	EndIf
EndFunc   ;==>_Insert_msgboxcode

Func _colourpicker_pick_colour()
	GUISetState(@SW_DISABLE, $Studiofenster)
	$Farbe = _ColorChooserDialog(GUICtrlGetBkColor($colour_vorschau), $colour_picker)
	GUISetState(@SW_ENABLE, $Studiofenster)
	If $Farbe > -1 Then
		GUICtrlSetBkColor($colour_vorschau, $Farbe)
		GUICtrlSetData($colour_hex, "0x" & Hex($Farbe, 6))
		GUICtrlSetData($colour_red, _ColorGetRed($Farbe))
		GUICtrlSetData($colour_green, _ColorGetGreen($Farbe))
		GUICtrlSetData($colour_blue, _ColorGetBlue($Farbe))
	EndIf
EndFunc   ;==>_colourpicker_pick_colour

Func _colourpicker_insert_hex_in_code()
	If $Offenes_Projekt = "" Then Return
	If _GUICtrlTab_GetItemCount($htab) > 0 Then
		Sci_InsertText($SCE_EDITOR[_GUICtrlTab_GetCurFocus($htab)], Sci_GetCurrentPos($SCE_EDITOR[_GUICtrlTab_GetCurFocus($htab)]), GUICtrlRead($colour_hex))
	EndIf
EndFunc   ;==>_colourpicker_insert_hex_in_code

Func _Toggle_colourpicker()
	If $Offenes_Projekt = "" Then Return
	If _Pruefe_auf_Type3_Plugin($Plugin_Platzhalter_Farbtoolbox) <> -1 Then Return ;Platzhalter für Plugin
	$state = WinGetState($colour_picker, "")
	If BitAND($state, 2) Then
		GUISetState(@SW_HIDE, $colour_picker)
	Else
		GUISetState(@SW_SHOW, $colour_picker)
	EndIf
EndFunc   ;==>_Toggle_colourpicker

; #FUNCTION# ;===============================================================================
;
; Name...........: _Aktualisiere_Splittercontrols
; Description ...: Wird verwendet um die Position der Controls und die Splitter zu aktualisieren
; Syntax.........: _Aktualisiere_Splittercontrols()
; Parameters ....: Keine
; Return values .: Keine
; Author ........: ISI360
; Modified.......:
; Remarks .......: Wird zb. auch in der Funktion _move_Splitter() aufgerufen
;                  Alle Controls die im Splittersystem verwendet werden sollen MÜSSEN hier aufgeführt sein!
; Related .......:
; Link ..........; http://www.isnetwork.at
; Example .......; No
;
; ;==========================================================================================

Func _Aktualisiere_Splittercontrols()

	;Hole windowclientsize
	$windowsize = _WinGetClientSize($Studiofenster)
	If Not IsArray($windowsize) Then Return
	GUICtrlSetPos($Abgrenzung_vor_statusbar, -10, $windowsize[1] - (_GUICtrlStatusBar_GetHeight($Status_bar)) - $Splitter_Rand - $Splitter_Rand - 2, 9999, 2)

	;Prüfe ob Programmlog aktiviert ist und aktiveiere/deaktiviere es
	If $hideprogramlog = "true" Then
		$position_Abgrenzung_vor_statusbar = _ControlGetPos($Studiofenster, "", $Abgrenzung_vor_statusbar)
		If Not IsArray($position_Abgrenzung_vor_statusbar) Then Return
		GUICtrlSetState($QuickView_title, $GUI_HIDE)
		GUICtrlSetState($Left_Splitter_Y, $GUI_HIDE)
		GUISetState(@SW_HIDE, $QuickView_GUI)
		GUICtrlSetPos($Left_Splitter_Y, $position_Abgrenzung_vor_statusbar[0], $position_Abgrenzung_vor_statusbar[1])
	EndIf

	If $hidedebug = "false" And $IS_HIDDEN_UNTEN = 0 Then

		GUICtrlSetState($Middle_Splitter_Y, $GUI_SHOW)
		GUICtrlSetState($Debug_log, $GUI_SHOW)

		If $Zeige_Buttons_neben_Debug_Fenster = "true" Then
			GUICtrlSetState($Debug_Log_Undo_Button, $GUI_SHOW)
			GUICtrlSetState($Debug_Log_Redo_Button, $GUI_SHOW)
			GUICtrlSetState($Debug_Log_Zwischenablage_Button, $GUI_SHOW)
		Else
			GUICtrlSetState($Debug_Log_Undo_Button, $GUI_HIDE)
			GUICtrlSetState($Debug_Log_Redo_Button, $GUI_HIDE)
			GUICtrlSetState($Debug_Log_Zwischenablage_Button, $GUI_HIDE)
		EndIf
	Else
		$position_Abgrenzung_vor_statusbar = _ControlGetPos($Studiofenster, "", $Abgrenzung_vor_statusbar)
		If Not IsArray($position_Abgrenzung_vor_statusbar) Then Return
		GUICtrlSetState($Middle_Splitter_Y, $GUI_HIDE)
		GUICtrlSetState($Debug_log, $GUI_HIDE)
		GUICtrlSetState($Debug_Log_Undo_Button, $GUI_HIDE)
		GUICtrlSetState($Debug_Log_Redo_Button, $GUI_HIDE)
		GUICtrlSetState($Debug_Log_Zwischenablage_Button, $GUI_HIDE)
		GUICtrlSetPos($Middle_Splitter_Y, $position_Abgrenzung_vor_statusbar[0], $position_Abgrenzung_vor_statusbar[1])
	EndIf

	;Weise zuerst (!!) die Controls den Splittern zu...
	If $Toggle_Leftside = 0 Then _Add_control_to_Splitter($Studiofenster, $Projecttree_title, -1, $Left_Splitter_X, $Abgrenzung_nach_toolbar, "#" & 19 * $DPI)
	If $Toggle_Leftside = 0 Then _Add_control_to_Splitter($Studiofenster, $Projecttree_Searchbar, -1, $Left_Splitter_X, $Projecttree_title, "#" & 23 * $DPI)
	If $Toggle_Leftside = 0 Then
		If $Studiomodus = 1 Then
			_ISN_ReposClearButton_in_Input($Projecttree_Searchbar, $Projecttree_Searchbar_ClearButton)
			_Add_control_to_Splitter($Studiofenster, $hTreeView, -1, $Left_Splitter_X, $Projecttree_Searchbar, $Left_Splitter_Y)
		Else
			_Add_control_to_Splitter($Studiofenster, $hTreeView, -1, $Left_Splitter_X, $Projecttree_title, $Left_Splitter_Y)
		EndIf
	EndIf
	If $Toggle_Leftside = 0 Then _Add_control_to_Splitter($Studiofenster, $QuickView_title, -1, $Left_Splitter_X, $Left_Splitter_Y, "#" & 19 * $DPI)
	If $Toggle_Leftside = 0 Then _Add_control_to_Splitter($Studiofenster, $QuickView_Dummy_Control, -1, $Left_Splitter_X, $QuickView_title, $Abgrenzung_vor_statusbar)
	_Add_control_to_Splitter($Studiofenster, $htab, $Left_Splitter_X, $Right_Splitter_X, $Abgrenzung_nach_toolbar, $Middle_Splitter_Y)
	_Add_control_to_Splitter($Studiofenster, $Debug_Log_Undo_Button, $Left_Splitter_X, "#" & 25 * $DPI, $Middle_Splitter_Y, "#" & 25 * $DPI)
	If $Zeige_Buttons_neben_Debug_Fenster = "true" Then
		_Add_control_to_Splitter($Studiofenster, $Debug_log, $Debug_Log_Undo_Button, $Right_Splitter_X, $Middle_Splitter_Y, $Abgrenzung_vor_statusbar)
	Else
		_Add_control_to_Splitter($Studiofenster, $Debug_log, $Left_Splitter_X, $Right_Splitter_X, $Middle_Splitter_Y, $Abgrenzung_vor_statusbar)
	EndIf
	_Add_control_to_Splitter($Studiofenster, $Debug_Log_Redo_Button, $Left_Splitter_X, "#" & 25 * $DPI, $Debug_Log_Undo_Button, "#" & 25 * $DPI)
	_Add_control_to_Splitter($Studiofenster, $Debug_Log_Zwischenablage_Button, $Left_Splitter_X, "#" & 25 * $DPI, $Debug_Log_Redo_Button, "#" & 25 * $DPI)


	If $Toggle_rightside = 0 Then _Add_control_to_Splitter($Studiofenster, $Scripttree_title, $Right_Splitter_X, -1, $Abgrenzung_nach_toolbar, "#" & 19 * $DPI)
;~ 	If $Toggle_rightside = 0 Then GUICtrlSetPos($Skriptbaum_Einstellungen_Button, "#" & $windowsize[0] - ((25 * $DPI) + $Titel_DPI_Dif), 0, 0, 0)
;~ 	If $Toggle_rightside = 0 Then GUICtrlSetPos($Skriptbaum_Aktualisieren_Button, "#" & $windowsize[0] - ((50 * $DPI) + $Titel_DPI_Dif + $Titel_DPI_Dif), 0, 0, 0)


	If $Toggle_rightside = 0 Then _Add_control_to_Splitter($Studiofenster, $hTreeview2_searchinput, $Right_Splitter_X, -1, $Scripttree_title, "#" & 23 * $DPI)
;~ 	If $Toggle_rightside = 0 Then _Add_control_to_Splitter($Studiofenster, $Skriptbaum_Aktualisieren_Button, $hTreeview2_searchinput, $Skriptbaum_Einstellungen_Button, $Scripttree_title, $hTreeview2)
;~ 	If $Toggle_rightside = 0 Then _Add_control_to_Splitter($Studiofenster, $Skriptbaum_Einstellungen_Button, $Skriptbaum_Aktualisieren_Button, -1, $Scripttree_title, $hTreeview2)

	If $Toggle_rightside = 0 Then _Add_control_to_Splitter($Studiofenster, $hTreeview2, $Right_Splitter_X, -1, $hTreeview2_searchinput, $Abgrenzung_vor_statusbar)
	;...und lasse danach die Splitter selbst Teil des Systems sein (Wichtig!)
	If $Toggle_Leftside = 0 Then _Add_control_to_Splitter($Studiofenster, $Left_Splitter_Y, -1, $Left_Splitter_X, $hTreeView, $QuickView_title)
	If $Toggle_Leftside = 0 Then _Add_control_to_Splitter($Studiofenster, $Left_Splitter_X, $Projecttree_title, $htab, $Abgrenzung_nach_toolbar, $Abgrenzung_vor_statusbar)
	_Add_control_to_Splitter($Studiofenster, $Middle_Splitter_Y, $Left_Splitter_X, $Right_Splitter_X, $htab, $Debug_log)
	If $Toggle_rightside = 0 Then _Add_control_to_Splitter($Studiofenster, $Right_Splitter_X, $htab, $Scripttree_title, $Abgrenzung_nach_toolbar, $Abgrenzung_vor_statusbar)


	_QuickView_GUI_nach_Dummycontrol_ausrichten()
	_ISN_Undocked_Tab_Info_Set_State("repos")

	Local $tabsize = _ControlGetPos($Studiofenster, "", $htab)
	If Not IsArray($tabsize) Then Return

	;Calculate height for Scintilla Controls
	Local $TabTopAdjust = $Tabseite_hoehe

	_Add_control_to_Splitter($Studiofenster, $ISN_QuickSearchbar_ShowFullSearchGUIButton, "#" & $tabsize[0] + $tabsize[2] - (23 * $DPI) - ($Splitter_Rand * 2), "#" & 23 * $DPI, "#" & $tabsize[1] + $Tabseite_hoehe, "#" & 23 * $DPI)
	_Add_control_to_Splitter($Studiofenster, $ISN_QuickSearchbar_NextButton, "#" & $tabsize[0] + $tabsize[2] - ((23 * $DPI) * 2) - ($Splitter_Rand * 3), $ISN_QuickSearchbar_ShowFullSearchGUIButton, "#" & $tabsize[1] + $Tabseite_hoehe, "#" & 23 * $DPI)
	_Add_control_to_Splitter($Studiofenster, $ISN_QuickSearchbar_BackButton, "#" & $tabsize[0] + $tabsize[2] - ((23 * $DPI) * 3) - ($Splitter_Rand * 4), $ISN_QuickSearchbar_NextButton, "#" & $tabsize[1] + $Tabseite_hoehe, "#" & 23 * $DPI)
	_Add_control_to_Splitter($Studiofenster, $ISN_QuickSearchbar_Input, "#" & $tabsize[0] + 4, $ISN_QuickSearchbar_BackButton, "#" & $tabsize[1] + $Tabseite_hoehe, "#" & 23 * $DPI)
	_ISN_ReposClearButton_in_Input($ISN_QuickSearchbar_Input, $ISN_QuickSearchbar_InputClearButton)

	If $Scripteditor_EnableDualEditor = "true" Then
		If $Scripteditor_DualEditorView = "vertical" Then
			If $Scripteditor_EnableQuickSearchBar = "true" Then
				If $Scripteditor_DualEditor_ShowEditorTitle = "true" Then
					_Add_control_to_Splitter($Studiofenster, $Scripteditor_DualEditorView_PrimaryTitle, $Left_Splitter_X, $Splitter_DualEditor, $ISN_QuickSearchbar_Input, "#" & 19 * $DPI, 4, 0, 0, -5)
					_Add_control_to_Splitter($Studiofenster, $ISN_ScintillaEditor1_Dummy_Control, $Left_Splitter_X, $Splitter_DualEditor, $Scripteditor_DualEditorView_PrimaryTitle, $Middle_Splitter_Y, 4, 0, 0, -5)
					_Add_control_to_Splitter($Studiofenster, $Scripteditor_DualEditorView_SecondaryTitle, $Splitter_DualEditor, $Right_Splitter_X, $ISN_QuickSearchbar_Input, "#" & 19 * $DPI, 0, -5, 0, -5)
					_Add_control_to_Splitter($Studiofenster, $ISN_ScintillaEditor2_Dummy_Control, $Splitter_DualEditor, $Right_Splitter_X, $Scripteditor_DualEditorView_SecondaryTitle, $Middle_Splitter_Y, 0, -5, 0, -5)
				Else
					_Add_control_to_Splitter($Studiofenster, $ISN_ScintillaEditor1_Dummy_Control, $Left_Splitter_X, $Splitter_DualEditor, $ISN_QuickSearchbar_Input, $Middle_Splitter_Y, 4, 0, 0, -5)
					_Add_control_to_Splitter($Studiofenster, $ISN_ScintillaEditor2_Dummy_Control, $Splitter_DualEditor, $Right_Splitter_X, $ISN_QuickSearchbar_Input, $Middle_Splitter_Y, 0, -5, 0, -5)
				EndIf
				_Add_control_to_Splitter($Studiofenster, $Splitter_DualEditor, $ISN_ScintillaEditor1_Dummy_Control, $ISN_ScintillaEditor2_Dummy_Control, $ISN_QuickSearchbar_Input, $Middle_Splitter_Y, 0, 0, 0, -5)
			Else
				If $Scripteditor_DualEditor_ShowEditorTitle = "true" Then
					_Add_control_to_Splitter($Studiofenster, $Scripteditor_DualEditorView_PrimaryTitle, $Left_Splitter_X, $Splitter_DualEditor, $Abgrenzung_nach_toolbar, "#" & 19 * $DPI, 4, 0, $TabTopAdjust, -5)
					_Add_control_to_Splitter($Studiofenster, $ISN_ScintillaEditor1_Dummy_Control, $Left_Splitter_X, $Splitter_DualEditor, $Scripteditor_DualEditorView_PrimaryTitle, $Middle_Splitter_Y, 4, 0, 0, -5)
					_Add_control_to_Splitter($Studiofenster, $Scripteditor_DualEditorView_SecondaryTitle, $Splitter_DualEditor, $Right_Splitter_X, $Abgrenzung_nach_toolbar, "#" & 19 * $DPI, 0, -5, $TabTopAdjust, -5)
					_Add_control_to_Splitter($Studiofenster, $ISN_ScintillaEditor2_Dummy_Control, $Splitter_DualEditor, $Right_Splitter_X, $Scripteditor_DualEditorView_SecondaryTitle, $Middle_Splitter_Y, 0, -5, 0, -5)
				Else
					_Add_control_to_Splitter($Studiofenster, $ISN_ScintillaEditor1_Dummy_Control, $Left_Splitter_X, $Splitter_DualEditor, $Abgrenzung_nach_toolbar, $Middle_Splitter_Y, 4, 0, $TabTopAdjust, -5)
					_Add_control_to_Splitter($Studiofenster, $ISN_ScintillaEditor2_Dummy_Control, $Splitter_DualEditor, $Right_Splitter_X, $Abgrenzung_nach_toolbar, $Middle_Splitter_Y, 0, -5, $TabTopAdjust, -5)
				EndIf
				_Add_control_to_Splitter($Studiofenster, $Splitter_DualEditor, $ISN_ScintillaEditor1_Dummy_Control, $ISN_ScintillaEditor2_Dummy_Control, $Abgrenzung_nach_toolbar, $Middle_Splitter_Y, 0, 0, $TabTopAdjust, -5)
			EndIf
		Else ;horizontal
			If $Scripteditor_EnableQuickSearchBar = "true" Then
				If $Scripteditor_DualEditor_ShowEditorTitle = "true" Then
					_Add_control_to_Splitter($Studiofenster, $Scripteditor_DualEditorView_PrimaryTitle, $Left_Splitter_X, $Right_Splitter_X, $ISN_QuickSearchbar_Input, "#" & 19 * $DPI, 4, -5, 0)
					_Add_control_to_Splitter($Studiofenster, $ISN_ScintillaEditor1_Dummy_Control, $Left_Splitter_X, $Right_Splitter_X, $Scripteditor_DualEditorView_PrimaryTitle, $Splitter_DualEditor, 4, -5, 0)
				Else
					_Add_control_to_Splitter($Studiofenster, $ISN_ScintillaEditor1_Dummy_Control, $Left_Splitter_X, $Right_Splitter_X, $ISN_QuickSearchbar_Input, $Splitter_DualEditor, 4, -5, 0)
				EndIf
			Else
				If $Scripteditor_DualEditor_ShowEditorTitle = "true" Then
					_Add_control_to_Splitter($Studiofenster, $Scripteditor_DualEditorView_PrimaryTitle, $Left_Splitter_X, $Right_Splitter_X, $Abgrenzung_nach_toolbar, "#" & 19 * $DPI, 4, -5, $TabTopAdjust)
					_Add_control_to_Splitter($Studiofenster, $ISN_ScintillaEditor1_Dummy_Control, $Left_Splitter_X, $Right_Splitter_X, $Scripteditor_DualEditorView_PrimaryTitle, $Splitter_DualEditor, 4, -5, 0)
				Else
					_Add_control_to_Splitter($Studiofenster, $ISN_ScintillaEditor1_Dummy_Control, $Left_Splitter_X, $Right_Splitter_X, $Abgrenzung_nach_toolbar, $Splitter_DualEditor, 4, -5, $TabTopAdjust)
				EndIf
			EndIf
			If $Scripteditor_DualEditor_ShowEditorTitle = "true" Then
				_Add_control_to_Splitter($Studiofenster, $Scripteditor_DualEditorView_SecondaryTitle, $Left_Splitter_X, $Right_Splitter_X, $Splitter_DualEditor, "#" & 19 * $DPI, 4, -5, 0, -4)
				_Add_control_to_Splitter($Studiofenster, $ISN_ScintillaEditor2_Dummy_Control, $Left_Splitter_X, $Right_Splitter_X, $Scripteditor_DualEditorView_SecondaryTitle, $Middle_Splitter_Y, 4, -5, 0, -4)
			Else
				_Add_control_to_Splitter($Studiofenster, $ISN_ScintillaEditor2_Dummy_Control, $Left_Splitter_X, $Right_Splitter_X, $Splitter_DualEditor, $Middle_Splitter_Y, 4, -5, 0, -4)
			EndIf
			_Add_control_to_Splitter($Studiofenster, $Splitter_DualEditor, $Left_Splitter_X, $Right_Splitter_X, $ISN_ScintillaEditor1_Dummy_Control, "#" & $Splitter_Breite, 4, -5)
		EndIf
	Else
		If $Scripteditor_EnableQuickSearchBar = "true" Then
			_Add_control_to_Splitter($Studiofenster, $ISN_ScintillaEditor1_Dummy_Control, $Left_Splitter_X, $Right_Splitter_X, $ISN_QuickSearchbar_Input, $Middle_Splitter_Y, 4, -5, 0, -4)
		Else
			_Add_control_to_Splitter($Studiofenster, $ISN_ScintillaEditor1_Dummy_Control, $Left_Splitter_X, $Right_Splitter_X, $Abgrenzung_nach_toolbar, $Middle_Splitter_Y, 4, -5, $TabTopAdjust, -4)
		EndIf
	EndIf

	;Das Plugin bzw. den Skripteditor an die Fenstergröße anpassen
	Local $CurrentTab = _GUICtrlTab_GetCurFocus($htab)
	If $CurrentTab = -1 Then Return
	If $ISN_Tabs_Additional_Infos_Array[$CurrentTab][1] = "1" Then Return
	If Not $Offenes_Projekt = "" And _GUICtrlTab_GetItemCount($htab) > 0 And $Can_switch_tabs <> 0 Then


		If $Plugin_Handle[$CurrentTab] = -1 Then

			;Scintilla Tab with dual mode support
			Local $ISN_ScintillaEditor1_Dummy_Control_Pos = _ControlGetPos($Studiofenster, "", $ISN_ScintillaEditor1_Dummy_Control)
			Local $ISN_ScintillaEditor2_Dummy_Control_Pos = _ControlGetPos($Studiofenster, "", $ISN_ScintillaEditor2_Dummy_Control)
			If IsArray($ISN_ScintillaEditor1_Dummy_Control_Pos) And IsArray($ISN_ScintillaEditor2_Dummy_Control_Pos) Then

				If $SCE_EDITOR[$CurrentTab] <> $Scripteditor_DualEditor_Handle Then
					WinMove($SCE_EDITOR[$CurrentTab], "", $ISN_ScintillaEditor1_Dummy_Control_Pos[0], $ISN_ScintillaEditor1_Dummy_Control_Pos[1], $ISN_ScintillaEditor1_Dummy_Control_Pos[2], $ISN_ScintillaEditor1_Dummy_Control_Pos[3])
				Else
					WinMove($Scripteditor_DualEditor_MainTabHandle, "", $ISN_ScintillaEditor1_Dummy_Control_Pos[0], $ISN_ScintillaEditor1_Dummy_Control_Pos[1], $ISN_ScintillaEditor1_Dummy_Control_Pos[2], $ISN_ScintillaEditor1_Dummy_Control_Pos[3])
				EndIf
				If $Scripteditor_DualEditor_Handle <> "" And $Scripteditor_EnableDualEditor = "true" Then WinMove($Scripteditor_DualEditor_Handle, "", $ISN_ScintillaEditor2_Dummy_Control_Pos[0], $ISN_ScintillaEditor2_Dummy_Control_Pos[1], $ISN_ScintillaEditor2_Dummy_Control_Pos[2], $ISN_ScintillaEditor2_Dummy_Control_Pos[3])

			EndIf

		Else

			;Plugin (Whole tab without splitter)
			$htab__WinGetPos_array = _WinGetPos(GUICtrlGetHandle($htab))

			$y = $tabsize[1] + $Tabseite_hoehe
			$x = $tabsize[0] + 4
			$heigth = $tabsize[3] - $Tabseite_hoehe - 4

			If $Scripteditor_EnableQuickSearchBar = "true" And $Plugin_Handle[$CurrentTab] = -1 Then
				$y = $y + $QuickSearchBar_Height
				$heigth = $heigth - $QuickSearchBar_Height
			EndIf


			WinMove($SCE_EDITOR[$CurrentTab], "", $x, $y, $tabsize[2] - 10, $heigth)
			$plugsize = _WinGetPos($SCE_EDITOR[$CurrentTab])
			_SendMessage($SCE_EDITOR[$CurrentTab], $WM_ENTERSIZEMOVE)
			_SendMessage($SCE_EDITOR[$CurrentTab], $WM_EXITSIZEMOVE)
			If IsArray($plugsize) And $Plugin_Handle[$CurrentTab] <> -1 Then
				WinMove($Plugin_Handle[$CurrentTab], "", 0, 0, $plugsize[2], $plugsize[3])
				_ISN_Send_Message_to_Plugin($Plugin_Handle[$CurrentTab], "resize") ;Resize an Plugin senden
				_SendMessage($Plugin_Handle[$CurrentTab], $WM_ENTERSIZEMOVE)
				_SendMessage($Plugin_Handle[$CurrentTab], $WM_EXITSIZEMOVE)
			EndIf



		EndIf

	EndIf


EndFunc   ;==>_Aktualisiere_Splittercontrols


; #FUNCTION# ;===============================================================================
;
; Name...........: _Add_control_to_Splitter
; Description ...: Fügt ein beliebiges Control in ein Splittersystem ein. Dabei müssen jeweils die Handles der Splitter angegeben werden
; Syntax.........: _Add_control_to_Splitter($control, $splitter_left, $splitter_right, $splitter_top, $splitter_down)
; Parameters ....: $hgui				- Handle zum GUI Fenster in dem sich die Controls und Splitter befinden
;                  $control				- Handle zum Control welches in das Splittersystem eingefügt werden soll
;                  $splitter_left		- Handle zum nächstgelegenen linken Splitter (Bei -1 wird der linke GUI-Rand verwendet)
;                  $splitter_right		- Handle zum nächstgelegenen rechten Splitter (Bei -1 wird der rechte GUI-Rand verwendet)
;                  $splitter_top		- Handle zum nächstgelegenen Splitter über dem Control (Bei -1 wird der obere GUI-Rand verwendet)
;                  $splitter_down		- Handle zum nächstgelegenen Splitter unter dem Control (Bei -1 wird der untere GUI-Rand verwendet)
;                  $Adjust_left			- Pixel to adjuste
;                  $Adjust_right		- Pixel to adjuste
;                  $Adjust_top			- Pixel to adjuste
;                  $Adjust_down			- Pixel to adjuste
; Return values .: 1 - Erfolg
;                  0 - Control konnte nicht in das Splittersystem integriert werden
; Author ........: ISI360
; Modified.......:
; Remarks .......: Kann auch zum Aktualisieren der Positionen eines Controls genutzt werden (zb. durch _move_Splitter())
;				   Um fixe Werte zb. für eien höhe zu setzen ist vor der nummer ein # nötig. (zb. #16)
; Related .......:
; Link ..........: https://www.isnetwork.at
; Example .......: No
;
; ;==========================================================================================

Func _Add_control_to_Splitter($hGUI = "", $control = "", $splitter_left = -1, $splitter_right = -1, $splitter_top = -1, $splitter_down = -1, $Adjust_left = 0, $Adjust_right = 0, $Adjust_top = 0, $Adjust_down = 0)
	If $hGUI = "" Then Return 0 ;error
	If $control = "" Then Return 0 ;error

	;Definiere verwendete Variablen
	Local $position_splitter_links
	Local $position_splitter_rechts
	Local $position_splitter_unten
	Local $position_splitter_oben
	Local $x
	Local $y
	Local $breite
	Local $hoehe


	;Hole Positionen von den angegebenen Splittern und der GUI
	;splitter/guirand links
	If $splitter_left <> -1 Then
		$position_splitter_links = _ControlGetPos($hGUI, "", $splitter_left)
	Else
		$position_splitter_links = _WinGetClientSize($hGUI, "")
	EndIf

	;splitter/guirand rechts
	If $splitter_right <> -1 Then
		$position_splitter_rechts = _ControlGetPos($hGUI, "", $splitter_right)
	Else
		$position_splitter_rechts = _WinGetClientSize($hGUI, "")
	EndIf

	;splitter/guirand oben
	If $splitter_top <> -1 Then
		$position_splitter_oben = _ControlGetPos($hGUI, "", $splitter_top)
	Else
		$position_splitter_oben = _WinGetClientSize($hGUI, "")
	EndIf

	;splitter/guirand unten
	If $splitter_down <> -1 Then
		$position_splitter_unten = _ControlGetPos($hGUI, "", $splitter_down)
	Else
		$position_splitter_unten = _WinGetClientSize($hGUI, "")
	EndIf

	;Berechene Positionen
	;x
	If IsArray($position_splitter_links) Then
		If $splitter_left <> -1 Then
			$x = $position_splitter_links[0] + $position_splitter_links[2] + $Splitter_Rand + $Adjust_left
		Else
			If $ISN_Use_Vertical_Toolbar = "true" Then
				$x = $Toolbar_Size[0] + $Splitter_Breite + $Splitter_Rand + $Adjust_left
			Else
				$x = $Splitter_Rand
			EndIf
		EndIf
	Else
		If StringInStr($splitter_left, "#") Then
			$x = Number(StringReplace($splitter_left, "#", ""))
		EndIf
	EndIf

	;y
	If IsArray($position_splitter_oben) Then
		If $splitter_top <> -1 Then
			$y = $position_splitter_oben[1] + $position_splitter_oben[3] + $Splitter_Rand + $Adjust_top
		Else
			$y = $Splitter_Rand
		EndIf
	Else
		If StringInStr($splitter_top, "#") Then
			$y = Number(StringReplace($splitter_top, "#", ""))
		EndIf
	EndIf

	;breite
	If IsArray($position_splitter_rechts) Then
		$breite = ($position_splitter_rechts[0] - $x) - $Splitter_Rand + $Adjust_right
	Else
		If $splitter_right <> -1 Then $breite = Number(StringReplace($splitter_right, "#", ""))
	EndIf

	;höhe
	If IsArray($position_splitter_unten) Then
		$hoehe = ($position_splitter_unten[1] - $y) - $Splitter_Rand + $Adjust_down
	Else
		If $splitter_down <> -1 Then $hoehe = Number(StringReplace($splitter_down, "#", ""))
	EndIf


	;Setze neue Positionen für das Control
	If IsHWnd($control) Then
		; _WinAPI_MoveWindow($control,$x, $y, $breite, $hoehe, True)
		WinMove($control, "", $x, $y, $breite, $hoehe)
	Else
		;_WinAPI_MoveWindow (guictrlgethandle($control),$x, $y, $breite, $hoehe, True)
		GUICtrlSetPos($control, $x, $y, $breite, $hoehe)
	EndIf




	;Fertig ;)
	Return 1
EndFunc   ;==>_Add_control_to_Splitter

; #FUNCTION# ;===============================================================================
;
; Name...........: _move_Splitter
; Description ...: Verschiebt durch gedrückthalten der linken Maustaste einen Splitter
; Syntax.........: _move_Splitter()
; Parameters ....: Keine
; Return values .: 1 - Erfolg
;                  0 - Fehler
; Author ........: ISI360
; Modified.......:
; Remarks .......: Muss durch eine GUICtrlSetOnEvent funktion aufgerufen werden
;                  Erkennt automatisch ob es sich bei dem Splitter um einen Horizontalen oder Vertikalen Splitter handelt
;                  Erkennt automatisch die Controls (dank dllcall) die den Splitter betreffen und achtet auf die Minimalgröße ($Splitter_Minimale_Groesse)
; Related .......:
; Link ..........: https://www.isnetwork.at
; Example .......: No
;
; ;==========================================================================================

Func _move_Splitter()
	If @GUI_CtrlId = "" Then Return 0
	If @GUI_WinHandle = "" Then Return 0
	_Write_ISN_Debug_Console("Moving a GUI splitter...", 1, 0)

	;Setup
	Local $ClickedSplitter = @GUI_CtrlId
	Local $ClickedSplitterGUI = @GUI_WinHandle
	Local $ClientScreentPoint = DllStructCreate("int X;int Y")
	Local $GUIClientsize = _WinGetClientSize($ClickedSplitterGUI)
	Local $ClickedSplitter_Pos = _ControlGetPos($ClickedSplitterGUI, "", $ClickedSplitter)
	Local $MousePosition1 = MouseGetPos()
	Local $MousePosition2
	Local $FinalX
	Local $FinalY
	Local $X_Diff = $MousePosition1[0] - $ClickedSplitter_Pos[0] ;x diff from the control to the mouse position
	Local $Y_Diff = $MousePosition1[1] - $ClickedSplitter_Pos[1] ;y diff from the control to the mouse position
	Local $SplitterBorderX = 150
	Local $SplitterBorderY = 130
	Local $SplitterHasMoved = False

	If Not IsArray($ClickedSplitter_Pos) Then Return
	If Not IsArray($MousePosition1) Then Return
	If Not IsArray($GUIClientsize) Then Return




	;Create dummy GUI for moving splitter
	$SplitterDummyMoveGUI = GUICreate("splitterGUI", 100, 100, -1, -1, $WS_POPUP, $WS_EX_TOOLWINDOW)
	GUISetBkColor($Schriftfarbe, $SplitterDummyMoveGUI)
	WinSetOnTop($SplitterDummyMoveGUI, "", 1)


	;Set Initial Pos and show the dummy splitter
	$FinalX = $ClickedSplitter_Pos[0]
	$FinalY = $ClickedSplitter_Pos[1]
	DllStructSetData($ClientScreentPoint, "X", $FinalX)
	DllStructSetData($ClientScreentPoint, "Y", $FinalY)
	_WinAPI_ClientToScreen($Studiofenster, $ClientScreentPoint)
	_WinAPI_SetWindowPos($SplitterDummyMoveGUI, $HWND_TOP, DllStructGetData($ClientScreentPoint, "X"), DllStructGetData($ClientScreentPoint, "Y"), $ClickedSplitter_Pos[2], $ClickedSplitter_Pos[3], $SWP_NOACTIVATE + $SWP_NOZORDER)
	If $ClickedSplitter_Pos[3] > $ClickedSplitter_Pos[2] Then
		;vertical Cursor
		GUISetCursor(13, 1, $SplitterDummyMoveGUI)
	Else
		;horizontal Cursor
		GUISetCursor(11, 1, $SplitterDummyMoveGUI)
	EndIf
	GUISetState(@SW_SHOWNOACTIVATE, $SplitterDummyMoveGUI) ;Show the dummy splitter


	;check, if its a horizontal or a vertical splitter
	If $ClickedSplitter_Pos[3] > $ClickedSplitter_Pos[2] Then
		;vertical
		While _IsPressed('01', $user32)
			$MousePosition1 = MouseGetPos()
			Sleep(10) ;wait to compare
			$MousePosition2 = MouseGetPos()

			If Not IsArray($MousePosition1) Then ExitLoop
			If Not IsArray($MousePosition2) Then ExitLoop

			;only if mouse has moved
			If ($MousePosition1[0] <> $MousePosition2[0]) Or ($MousePosition1[1] <> $MousePosition2[1]) Then
				$SplitterHasMoved = True
				$FinalX = $MousePosition1[0] - $X_Diff
				$FinalY = $ClickedSplitter_Pos[1]
				If $FinalX < $SplitterBorderX Then $FinalX = $SplitterBorderX
				If $FinalX > $GUIClientsize[0] - $SplitterBorderX Then $FinalX = $GUIClientsize[0] - $SplitterBorderX

				DllStructSetData($ClientScreentPoint, "X", $FinalX)
				DllStructSetData($ClientScreentPoint, "Y", $FinalY)
				_WinAPI_ClientToScreen($Studiofenster, $ClientScreentPoint)
				_WinAPI_SetWindowPos($SplitterDummyMoveGUI, $HWND_TOP, DllStructGetData($ClientScreentPoint, "X"), DllStructGetData($ClientScreentPoint, "Y"), $ClickedSplitter_Pos[2], $ClickedSplitter_Pos[3], $SWP_NOACTIVATE + $SWP_NOZORDER + $SWP_NOSENDCHANGING)
			EndIf
		WEnd
	Else
		;horizontal
		While _IsPressed('01', $user32)
			$MousePosition1 = MouseGetPos()
			Sleep(10) ;wait to compare
			$MousePosition2 = MouseGetPos()

			If Not IsArray($MousePosition1) Then ExitLoop
			If Not IsArray($MousePosition2) Then ExitLoop

			;only if mouse has moved
			If ($MousePosition1[0] <> $MousePosition2[0]) Or ($MousePosition1[1] <> $MousePosition2[1]) Then
				$SplitterHasMoved = True
				$FinalX = $ClickedSplitter_Pos[0]
				$FinalY = $MousePosition1[1] - $Y_Diff
				If $FinalY < $SplitterBorderY Then $FinalY = $SplitterBorderY
				If $FinalY > $GUIClientsize[1] - $SplitterBorderY Then $FinalY = $GUIClientsize[1] - $SplitterBorderY

				DllStructSetData($ClientScreentPoint, "X", $FinalX)
				DllStructSetData($ClientScreentPoint, "Y", $FinalY)
				_WinAPI_ClientToScreen($Studiofenster, $ClientScreentPoint)
				_WinAPI_SetWindowPos($SplitterDummyMoveGUI, $HWND_TOP, DllStructGetData($ClientScreentPoint, "X"), DllStructGetData($ClientScreentPoint, "Y"), $ClickedSplitter_Pos[2], $ClickedSplitter_Pos[3], $SWP_NOACTIVATE + $SWP_NOZORDER + $SWP_NOSENDCHANGING)
			EndIf
		WEnd
	EndIf

	;Delete dummyGUI
	GUIDelete($SplitterDummyMoveGUI)
	GUISwitch($Studiofenster)

	If Not $SplitterHasMoved Then Return ;No splitter has ben moved

	;Move the final splitter (if checks are ok), and redraw stuff
	If _move_Splitter_checkOverlaps($FinalX, $FinalY, $ClickedSplitter, $ClickedSplitterGUI) Then
		_ISN_Studiofenster_SetClipchildren("set") ;To prevent flickering in the main GUI
		_WinAPI_SetWindowPos(GUICtrlGetHandle($ClickedSplitter), 0, $FinalX, $FinalY, 0, 0, $SWP_NOACTIVATE + $SWP_NOZORDER + $SWP_NOSIZE)
		_Aktualisiere_Splittercontrols() ;Finale aktualisierung
		_Redraw_Window() ;Speichern der aktellen Werte der Splitter
		_ISN_Studiofenster_SetClipchildren("remove") ;remove clipchildren style
	Else
		_WinAPI_MessageBeep(4) ;play Exclamation-"error" sound
	EndIf

	_Write_ISN_Debug_Console("done", 1, 1, 1, 1)
	Return 1 ;Fertig
EndFunc   ;==>_move_Splitter




Func _ISN_RedrawFixRedrawGlitches()



	;Fix some resize glitches (caused by $WS_CLIPCHILDREN
	_WinAPI_RedrawWindow($htoolbar)
	_WinAPI_RedrawWindow(GUICtrlGetHandle($Projecttree_title))
	_WinAPI_RedrawWindow(GUICtrlGetHandle($Scripttree_title))
	_WinAPI_RedrawWindow(GUICtrlGetHandle($QuickView_title))
	_WinAPI_RedrawWindow(GUICtrlGetHandle($Projecttree_Searchbar))
	_WinAPI_RedrawWindow(GUICtrlGetHandle($Projecttree_Searchbar_ClearButton))

	If $Scripteditor_EnableQuickSearchBar = "true" Then
		_WinAPI_RedrawWindow(GUICtrlGetHandle($ISN_QuickSearchbar_Input))
		_WinAPI_RedrawWindow(GUICtrlGetHandle($ISN_QuickSearchbar_BackButton))
		_WinAPI_RedrawWindow(GUICtrlGetHandle($ISN_QuickSearchbar_NextButton))
		_WinAPI_RedrawWindow(GUICtrlGetHandle($ISN_QuickSearchbar_InputClearButton))
		_WinAPI_RedrawWindow(GUICtrlGetHandle($ISN_QuickSearchbar_ShowFullSearchGUIButton))
	EndIf

	If $Scripteditor_EnableDualEditor = "true" And $Scripteditor_DualEditor_ShowEditorTitle = "true" Then
		_WinAPI_RedrawWindow(GUICtrlGetHandle($Scripteditor_DualEditorView_PrimaryTitle))
		_WinAPI_RedrawWindow(GUICtrlGetHandle($Scripteditor_DualEditorView_SecondaryTitle))
	EndIf


	If $Zeige_Buttons_neben_Debug_Fenster = "true" Then
		_WinAPI_RedrawWindow(GUICtrlGetHandle($Debug_Log_Undo_Button))
		_WinAPI_RedrawWindow(GUICtrlGetHandle($Debug_Log_Redo_Button))
		_WinAPI_RedrawWindow(GUICtrlGetHandle($Debug_Log_Zwischenablage_Button))
	EndIf

	;_SendMessage(GUICtrlGetHandle($hTreeview), $WM_SETREDRAW, False)
	;GUISetState(@SW_LOCK, $Studiofenster)
	;_SendMessage(GUICtrlGetHandle($ISN_VariablesSelector_Title), $WM_SETREDRAW, True)

;~     Local $tRect = DllStructCreate($tagRECT)
;~     DllStructSetData($tRect, "Left", 0)
;~     DllStructSetData($tRect, "Top", 0)
;~     DllStructSetData($tRect, "Right", 2000)
;~     DllStructSetData($tRect, "Bottom", 2000)

;~     _WinAPI_InvalidateRect($Studiofenster, $tRect, True)

;~ _WinAPI_UpdateWindow($Studiofenster)

	; _GUICtrlTreeView_BeginUpdate ( $hTreeview )
	;_WinAPI_RedrawWindow($Studiofenster, 0, 0, BitOR($RDW_ERASE, $RDW_INVALIDATE, $RDW_ALLCHILDREN)) ;Redraw the main GUI
	;_ISN_UnlockGUIWithoutFlickering($Studiofenster)
EndFunc   ;==>_ISN_RedrawFixRedrawGlitches

Func _move_Splitter_checkOverlaps($NewX = 0, $NewY = 0, $control = "", $GUI = "")
	If $control = "" Or $GUI = "" Then Return False
	Local $PosTest
	Local $OverlapBorder = 25

	Switch $control

		Case $Left_Splitter_X
			If $hidefunctionstree = "false" And $IS_HIDDEN_RECHTS = 0 And $Toggle_rightside = 0 Then
				$PosTest = _ControlGetPos($GUI, "", $Right_Splitter_X)
				If Not IsArray($PosTest) Then Return False
				If $NewX > ($PosTest[0] - $OverlapBorder) Then Return False ;left splitter was moved over the right splitter
			EndIf

		Case $Right_Splitter_X
			If $Toggle_Leftside = 0 Then
				$PosTest = _ControlGetPos($GUI, "", $Left_Splitter_X)
				If Not IsArray($PosTest) Then Return False
				If $NewX < ($PosTest[0] + $OverlapBorder) Then Return False ;right splitter was moved over the left splitter
			EndIf

		Case $Middle_Splitter_Y
			If $Scripteditor_EnableDualEditor = "true" And $Scripteditor_DualEditorView <> "vertical" Then
				$PosTest = _ControlGetPos($GUI, "", $Splitter_DualEditor)
				If Not IsArray($PosTest) Then Return False
				If $NewY < ($PosTest[1] + $OverlapBorder) Then Return False ;bottom splitter was moved over the horizontal middle splitter
			EndIf

		Case $Splitter_DualEditor
			If $Scripteditor_EnableDualEditor = "true" Then
				If $Scripteditor_DualEditorView = "vertical" Then
					$PosTest = _ControlGetPos($GUI, "", $Left_Splitter_X)
					If Not IsArray($PosTest) Then Return False
					If $NewX < ($PosTest[0] + $OverlapBorder) Then Return False ;vertical middle splitter was moved over the left splitter
					$PosTest = _ControlGetPos($GUI, "", $Right_Splitter_X)
					If Not IsArray($PosTest) Then Return False
					If $NewX > ($PosTest[0] - $OverlapBorder) Then Return False ;vertical middle splitter was moved over the right splitter
				Else
					$PosTest = _ControlGetPos($GUI, "", $Middle_Splitter_Y)
					If Not IsArray($PosTest) Then Return False
					If $NewY > ($PosTest[1] - $OverlapBorder) Then Return False ;horizontal middle splitter was moved over the bottom splitter

				EndIf

			EndIf




	EndSwitch




	Return True
EndFunc   ;==>_move_Splitter_checkOverlaps

Func _Colour_Calltipp_Set_State($state = "show", $Sci_editor = "")
	If $state = "show" Then
		Local $OwnerWindow = _WinAPI_GetAncestor($Sci_editor, $GA_PARENT)
		_WinAPI_SetWindowLong($mini_farb_picker_GUI, $GWL_HWNDPARENT, $OwnerWindow)
		$SCE_Colour_Calltipp_Last_Scintilla_Window = $Sci_editor
		$aktuelle_pos_SCE_Window = _WinGetPos($Sci_editor)
		$aktuelle_pos = Sci_GetCurrentPos($Sci_editor)
		Local $x = SendMessage($Sci_editor, $SCI_POINTXFROMPOSITION, 0, $aktuelle_pos) + $aktuelle_pos_SCE_Window[0]
		Local $y = SendMessage($Sci_editor, $SCI_POINTYFROMPOSITION, 0, $aktuelle_pos) + $aktuelle_pos_SCE_Window[1] + 50
		If WinExists("ACallTip") Then
			Local $CallTipGUI_POS = _WinGetPos("ACallTip")
			If IsArray($CallTipGUI_POS) Then
				$x = $CallTipGUI_POS[0] + $CallTipGUI_POS[2] + 10
				$y = $CallTipGUI_POS[1]
			EndIf
		EndIf
		WinMove($mini_farb_picker_GUI, "", $x, $y) ;bewege den colour picker an die cursor stelle
		GUISetState(@SW_SHOWNOACTIVATE, $mini_farb_picker_GUI)
	Else
		Local $farb_picker_GUIstate = WinGetState($mini_farb_picker_GUI, "")
		If BitAND($farb_picker_GUIstate, 2) Then GUISetState(@SW_HIDE, $mini_farb_picker_GUI)
	EndIf
EndFunc   ;==>_Colour_Calltipp_Set_State



Func _Detailinfos_ausblenden()
	$Detailinfos_GUIstate = WinGetState($Detailinfos_zu_aktuellem_Wort_GUI, "")
	If BitAND($Detailinfos_GUIstate, 2) Then
		GUISetState(@SW_HIDE, $Detailinfos_zu_aktuellem_Wort_GUI)
		_Colour_Calltipp_Set_State("hide")
	EndIf
EndFunc   ;==>_Detailinfos_ausblenden



Func _Zeige_Detailinfos_zu_aktuellem_Wort($wort = "", $Sci_editor = "")
	If $wort <> "" Then
		If StringInStr($wort, "0x") And StringLen($wort) = 8 Then ;Courser ist in einem Farbwert
			Local $OwnerWindow = _WinAPI_GetAncestor($Sci_editor, $GA_PARENT)
			_WinAPI_SetWindowLong($Detailinfos_zu_aktuellem_Wort_GUI, $GWL_HWNDPARENT, $OwnerWindow)
			$SCE_Detailinfos_Last_Scintilla_Window = $Sci_editor
			$aktuelle_pos_SCE_Window = _WinGetPos($Sci_editor)
			$aktuelle_pos = Sci_GetCurrentPos($Sci_editor)
			$x = SendMessage($Sci_editor, $SCI_POINTXFROMPOSITION, 0, $aktuelle_pos) + $aktuelle_pos_SCE_Window[0] - 70
			$y = SendMessage($Sci_editor, $SCI_POINTYFROMPOSITION, 0, $aktuelle_pos) + $aktuelle_pos_SCE_Window[1] - 20
			If WinExists("ACallTip") Then
				Local $CallTipGUI_POS = _WinGetPos("ACallTip")
				If IsArray($CallTipGUI_POS) Then
					$x = $CallTipGUI_POS[0] + $CallTipGUI_POS[2] + 10
					$y = $CallTipGUI_POS[1]
				EndIf
			EndIf
			GUICtrlSetData($Detailinfos_zu_aktuellem_Wort_Label, $wort)
			GUICtrlSetBkColor($Detailinfos_zu_aktuellem_Wort_Label, $wort)
			GUICtrlSetColor($Detailinfos_zu_aktuellem_Wort_Label, _ColourInvert(Execute($wort)))
			WinMove($Detailinfos_zu_aktuellem_Wort_GUI, "", $x, $y) ;bewege den colour picker an die cursor stelle
			GUISetState(@SW_SHOWNOACTIVATE, $Detailinfos_zu_aktuellem_Wort_GUI)
			Return
		EndIf
	EndIf
	_Detailinfos_ausblenden()
EndFunc   ;==>_Zeige_Detailinfos_zu_aktuellem_Wort



Func _Sci_show_last_Calltipp($Sci_editor = "")
	_Scintilla_CallTip_ShowHide_Check($Sci_editor, 1)
EndFunc   ;==>_Sci_show_last_Calltipp

Func _Mini_Farbpicker_waehle_farbe()
	Sci_InsertText($SCE_Colour_Calltipp_Last_Scintilla_Window, Sci_GetCurrentPos($SCE_Colour_Calltipp_Last_Scintilla_Window), "0x" & Hex(GUICtrlGetBkColor(@GUI_CtrlId), 6))
	_Colour_Calltipp_Set_State("hide")
	_WinAPI_SetFocus($SCE_Colour_Calltipp_Last_Scintilla_Window)
	Sci_SetCurrentPos($SCE_Colour_Calltipp_Last_Scintilla_Window, Sci_GetCurrentPos($SCE_Colour_Calltipp_Last_Scintilla_Window) + 8)
	_Sci_show_last_Calltipp($SCE_Colour_Calltipp_Last_Scintilla_Window)
EndFunc   ;==>_Mini_Farbpicker_waehle_farbe

Func _Mini_Farbpicker_waehle_eigene_farbe()
	$Farbe = _ColorChooserDialog(0xFFFFFF, $Studiofenster)
	If $Farbe > -1 Then
		Sci_InsertText($SCE_Colour_Calltipp_Last_Scintilla_Window, Sci_GetCurrentPos($SCE_Colour_Calltipp_Last_Scintilla_Window), "0x" & Hex($Farbe, 6))
		Sci_SetCurrentPos($SCE_Colour_Calltipp_Last_Scintilla_Window, Sci_GetCurrentPos($SCE_Colour_Calltipp_Last_Scintilla_Window) + 8)
		_WinAPI_SetFocus($SCE_Colour_Calltipp_Last_Scintilla_Window)
		_Sci_show_last_Calltipp($SCE_Colour_Calltipp_Last_Scintilla_Window)
	EndIf
EndFunc   ;==>_Mini_Farbpicker_waehle_eigene_farbe



Func _CreateBitmapFromIcon($iBackground, $sIcon, $iIndex, $iWidth, $iHeight)
	Local $hDC = _WinAPI_GetDC(0)
	Local $hBackDC = _WinAPI_CreateCompatibleDC($hDC)
	$iBackground = BitAND(BitShift($iBackground, -16) + BitAND($iBackground, 0xFF00) + BitShift($iBackground, 16), 0xFFFFFF)
	Local $hBitmap = _WinAPI_CreateSolidBitmap(0, $iBackground, $iWidth, $iHeight)
	Local $hBackSv = _WinAPI_SelectObject($hBackDC, $hBitmap)
	Local $hIcon = _WinAPI_ShellExtractIcon($sIcon, $iIndex, $iWidth, $iHeight)
	If Not @error Then
		_WinAPI_DrawIconEx($hBackDC, 0, 0, $hIcon, 0, 0, 0, 0, 0x0003)
		_WinAPI_DestroyIcon($hIcon)
	EndIf
	_WinAPI_SelectObject($hBackDC, $hBackSv)
	_WinAPI_ReleaseDC(0, $hDC)
	_WinAPI_DeleteDC($hBackDC)
	Return $hBitmap
EndFunc   ;==>_CreateBitmapFromIcon

; Diese Funktion u¨berschreibt das Standart Kontextmenu¨ mit unserm Dummy Menu¨ (Quelle US Autoit Forum)





Func Show_KontextMenuAdlib()
	AdlibUnRegister("Show_KontextMenuAdlib")
	Local $hMenu = GUICtrlGetHandle($Show_KontextMenu_nContextID)
	$arPos = MouseGetPos()
	If Not IsArray($arPos) Then Return
	Local $x = $arPos[0]
	Local $y = $arPos[1]
;~ 	If $Y > 740 Then $Y = 730
	DllCall("user32.dll", "int", "TrackPopupMenuEx", "hwnd", $hMenu, "int", 0, "int", $x, "int", $y, "hwnd", $Show_KontextMenu_hWnd, "ptr", 0)

EndFunc   ;==>Show_KontextMenuAdlib

Func Show_KontextMenu($hWnd, $nContextID)
	$Show_KontextMenu_hWnd = $hWnd
	$Show_KontextMenu_nContextID = $nContextID
	AdlibRegister("Show_KontextMenuAdlib", 1)
EndFunc   ;==>Show_KontextMenu


; #FUNCTION# ;===============================================================================
;
; Name...........: _Pruefe_Hotkey
; Description ...: Prüft ob eine oder mehrere Tasten gedrückt sind oder nicht
; Syntax.........: _Pruefe_Hotkey($keycode)
; Parameters ....: $keycode			- Welche Tasten sollen geprüft werden (Für mehrere Tsten zb: 11+58+22)
; Return values .: true				- Taste/Tasten ist/sind gedrückt
;                  False			- Taste/Tasten ist/sind nicht gedrückt
; Author ........: ISI360
; Modified.......:
; Remarks .......: Eine kleine erweiterte _ispressed-Funktion die es erlaubt via Keycode (zb: 11+58+22) mehrere Tastenkombinationen (bis zu 4 Tasten) abzufragen
;                  Wird benötigt da ab ISN AutoIt Studio 0.9 BETA der User selbst die Hotkeys definieren kann
;                  Werden mehr als 4 Tasten angegeben wird automatisch "false" zurückgegeben
; Related .......:
; Link ..........: https://www.isnetwork.at
; Example .......: No
;
; ;==========================================================================================

Func _Pruefe_Hotkey($keyCode = "")
	If $keyCode = "" Then Return False
	$array = StringSplit($keyCode, "+", 2)
	If Not IsArray($array) Then Return False

	;Alt Gr/STRG Bugfix
	If Not StringInStr($keyCode, "11") And _IsPressed("11", $user32) Then Return False
	If Not StringInStr($keyCode, "12") And _IsPressed("12", $user32) Then Return False

	;Shift Bugfix
	If Not StringInStr($keyCode, "10") And _IsPressed("10", $user32) Then Return False

	;Windows Keys Bugfix
	If Not StringInStr($keyCode, "5B") And _IsPressed("5B", $user32) Then Return False
	If Not StringInStr($keyCode, "5C") And _IsPressed("5C", $user32) Then Return False

	;Eine Taste
	If UBound($array) - 1 = 0 Then
		If _IsPressed($array[0], $user32) Then
			$Letzter_Hotkey = $keyCode
			Return True
		Else
			Return False
		EndIf
	EndIf

	;Zwei Tasten
	If UBound($array) - 1 = 1 Then
		If _IsPressed($array[0], $user32) And _IsPressed($array[1], $user32) Then
			$Letzter_Hotkey = $keyCode
			Return True
		Else
			Return False
		EndIf
	EndIf

	;Drei Tasten
	If UBound($array) - 1 = 2 Then
		If _IsPressed($array[0], $user32) And _IsPressed($array[1], $user32) And _IsPressed($array[2], $user32) Then
			$Letzter_Hotkey = $keyCode
			Return True
		Else
			Return False
		EndIf
	EndIf

	;Vier Tasten
	If UBound($array) - 1 = 3 Then
		If _IsPressed($array[0], $user32) And _IsPressed($array[1], $user32) And _IsPressed($array[2], $user32) And _IsPressed($array[3], $user32) Then
			$Letzter_Hotkey = $keyCode
			Return True
		Else
			Return False
		EndIf
	EndIf

	;Alles darüber -> return false
	Return False
EndFunc   ;==>_Pruefe_Hotkey


; #FUNCTION# ;===============================================================================
;
; Name...........: _ISN_aktualisiere_Hotkeys
; Description ...: Registriert alle im ISN verwendeten Hotkeys mit der Hotkey UDF von Yashied
; Syntax.........:  none
; Return values .: none
; Author ........: ISI360
; Modified.......:
; Remarks .......: Beim aufruf werden alle bereits registrierten Hotkeys entfernt und neu registriert. (zb. beim Speichern der Programmeinstellungen)
; Related .......:
; Link ..........: https://www.isnetwork.at
; Example .......: No
;
; ;==========================================================================================
Func _ISN_aktualisiere_Hotkeys()
	_EasyHotKey_Reset() ;Reset all hotkeys

	Local $ISN_HotkeyDefaultFlags = $EasyHotKey_AllowHotkeyForChildGUIs

	;Normal ISN hotkeys
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_vollbild, "_Toggle_Fulscreen", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Toggle Full screen
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Testprojekt, "_ISN_Projekt_Testen", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Test project
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Testprojekt_ohne_Parameter, "_ISN_Projekt_Testen_ohne_Parameter", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Test project (without parameters)
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Suche, "_Show_Search", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Toggle search gui
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Neue_Datei, "_ISN_ShowNewFileGUI_Hotkey", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Create new file
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Create_New_Folder, "_ISN_ShowNewFolderGUI_Hotkey", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Create new folder
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Create_New_Shortcut, "_ISN_ShowNewShortcutGUI_Hotkey", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Create new shortcut
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Oeffnen, "_Try_to_open_external_file", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Open file
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Farbtoolbox, "_Toggle_colourpicker", $ISN_HotkeyDefaultFlags, $Studiofenster) ;toggle colorpicker
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Speichern, "_ISN_aktuellen_Tab_speichern", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Save
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Speichern_unter, "_Speichern_unter", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Save as
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Speichern_Alle_Tabs, "_Save_All_tabs", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Save (all tabs)
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Fensterinfotool, "_open_windowinfotool", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Window info tool
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Bitrechner, "_Toggle_Bitoperation_rechner", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Toggle bit calculator
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Automatisches_Backup, "_Backup_Files", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Auto backup
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Aenderungsprotokolle, "_Zeige_changelogmanager", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Changelog manager
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_In_Dateien_Suchen, "_Toggle_In_Dateien_Suchen", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Search in files
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_compile, "_Start_Compiling", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Compile project
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_compile_Settings, "_Show_Compile", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Compile settings
	_EasyHotKey_AssignNewHotkey($Hotkey_PElock_Obfuscator, "_Toggle_PELock_GUI", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Toggle PELock
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_AutoIt3WrapperGUI, "_Zeige_AutoIt3Wrapper_GUI", $ISN_HotkeyDefaultFlags, $Studiofenster) ;AutoIt3WrapperGUI
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_vorheriger_tab, "_Select_previous_tab", $ISN_HotkeyDefaultFlags, $Studiofenster) ;previous tab
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_naechster_tab, "_Select_next_tab", $ISN_HotkeyDefaultFlags, $Studiofenster) ;next tab
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_befehlhilfe, "_open_helpfile_keyword", $ISN_HotkeyDefaultFlags, $Studiofenster, "scintilla") ;show command help
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_springezuzeile, "_Toggle_GoToLine_GUI", $ISN_HotkeyDefaultFlags, $Studiofenster) ;jump to line
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_msgBoxGenerator, "_Toggle_msgboxcreator", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Msgbox generator
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_debugtomsgbox, "_Debug_to_msgbox", $ISN_HotkeyDefaultFlags, $Studiofenster, "scintilla") ;Debug to MsgBox
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_debugtoconsole, "_Debug_to_console", $ISN_HotkeyDefaultFlags, $Studiofenster, "scintilla") ;Debug to console
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_erstelleUDFheader, "_Erstelle_UDF_Header", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Generate UDF Header
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_unteres_fenster_umschalten, "_Toggle_Fenster_unten", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Toggle bottom window
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_linkes_fenster_umschalten, "_Toggle_hide_leftbar", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Toggle left window
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_rechtes_fenster_umschalten, "_Toggle_hide_rightbar", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Toggle right window
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Springe_zu_Func, "_Springe_zu_Func", $ISN_HotkeyDefaultFlags, $Studiofenster, "scintilla") ;Jump to func
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Springe_zu_Func_zurueck, "_Springe_zu_Func_zurueck", $ISN_HotkeyDefaultFlags, $Studiofenster, "scintilla") ;Jump to func (Jump back to prev pos)
	_EasyHotKey_AssignNewHotkey($Hotkey_SCI_Kommentare_ausblenden_bzw_einblenden, "_SCI_Kommentare_ausblenden_bzw_einblenden", $ISN_HotkeyDefaultFlags, $Studiofenster, "scintilla") ;Toggle comments
	_EasyHotKey_AssignNewHotkey($Hotkey_Zeile_Bookmarken, "_Zeile_Bookmarken", $ISN_HotkeyDefaultFlags, $Studiofenster, "scintilla") ;Bookmark line
	_EasyHotKey_AssignNewHotkey($Hotkey_Zeile_Bookmarken_Naechstes_Bookmark, "_Springe_zum_naechsten_Bookmarks", $ISN_HotkeyDefaultFlags, $Studiofenster, "scintilla") ;Jump to next bookmark
	_EasyHotKey_AssignNewHotkey($Hotkey_Zeile_Bookmarken_Vorheriges_Bookmark, "_Springe_zur_vorherigen_Bookmarks", $ISN_HotkeyDefaultFlags, $Studiofenster, "scintilla") ;Jump to prev bookmark
	_EasyHotKey_AssignNewHotkey($Hotkey_Zeile_Bookmarken_alle_loeschen, "_Alle_Bookmarks_entfernen", $ISN_HotkeyDefaultFlags, $Studiofenster, "scintilla") ;Remove all bookmarks
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Show_CallTip, "_Scintilla_Force_Show_CallTip", $ISN_HotkeyDefaultFlags, $Studiofenster, "scintilla") ;Force show calltip
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_zeigefehler, "_Find_Error_F4", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Find error
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_testeskript, "_ISN_Skript_Testen", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Test current opened script
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Oeffne_Include, "_Try_to_open_include_hotkey", $ISN_HotkeyDefaultFlags, $Studiofenster, "scintilla") ;Open selected include
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Weitersuchen, "_Hotkey_vorwaerts_suchen", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Search next result
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Rueckwaerts_Weitersuchen, "_Hotkey_Rueckwaerts_suchen", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Search prev result
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_tab_schliessen, "_ISN_Aktuellen_Tab_schliessen", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Close tab
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Tidy, "_ISN_Tidy_aktuellen_Tab", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Tidy Source
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Makroslot1, "_ISN_execute_macroslot_01", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Macroslot 1
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Makroslot2, "_ISN_execute_macroslot_02", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Macroslot 2
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Makroslot3, "_ISN_execute_macroslot_03", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Macroslot 3
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Makroslot4, "_ISN_execute_macroslot_04", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Macroslot 4
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Makroslot5, "_ISN_execute_macroslot_05", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Macroslot 5
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Makroslot6, "_ISN_execute_macroslot_06", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Macroslot 6
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Makroslot7, "_ISN_execute_macroslot_07", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Macroslot 7
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Makroslot8, "_ISN_execute_macroslot_08", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Macroslot 8
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Makroslot9, "_ISN_execute_macroslot_09", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Macroslot 9
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Makroslot10, "_ISN_execute_macroslot_10", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Macroslot 10
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_syntaxcheck, "_ISN_Syntaxcheck_aktuellen_Tab", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Syntaxcheck
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Create_Temp_Au3_Script, "_erstelle_neues_temporaeres_skript", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Create temp au3 script
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Contract_AllCodesegments, "_Scintilla_Fold_Contract_all", $ISN_HotkeyDefaultFlags, $Studiofenster, "scintilla") ;Contract all code segmnts
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Expand_AllCodesegments, "_Scintilla_Fold_Expand_all", $ISN_HotkeyDefaultFlags, $Studiofenster, "scintilla") ;Expand all code segmnts
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Contract_Regions, "_Scintilla_Fold_Contract_all_Regions", $ISN_HotkeyDefaultFlags, $Studiofenster, "scintilla") ;Contract all regions
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Expand_Regions, "_Scintilla_Fold_Expand_all_Regions", $ISN_HotkeyDefaultFlags, $Studiofenster, "scintilla") ;Expand all regions
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Close_project, "_Close_Project_Adlib", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Close Project
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Test_selected_Code, "_Scintilla_Test_Selected_Codelines", $ISN_HotkeyDefaultFlags, $Studiofenster, "scintilla") ;Test selected code
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_UDF_Manager, "_ISN_Toggle_UDF_Manager", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Toggle UDF Manager
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_ReloadFileContent, "_ISN_ReloadFileContentOnCurrentTab", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Reload File Content
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_AddPrevMachtingWordToSelection, "_Scintilla_AddPrevMatchingWordToSelection", $ISN_HotkeyDefaultFlags, $Studiofenster, "scintilla") ;Add Prev Matching Word To Selection
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_AddNextMachtingWordToSelection, "_Scintilla_AddNextMatchingWordToSelection", $ISN_HotkeyDefaultFlags, $Studiofenster, "scintilla") ;Add Next Matching Word To Selection
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_AddAllMachtingWordToSelection, "_Scintilla_AddAllMatchingWordToSelection", $ISN_HotkeyDefaultFlags, $Studiofenster, "scintilla") ;Add All Matching Word To Selection
	_EasyHotKey_AssignNewHotkey("04", "_ISN_TryToCloseTabWithMiddleMouseButton", $EasyHotKey_NoHotkeyBlock, $Studiofenster) ;Close tabs with middle mouse key


	;Hotkeys for the parameter editor
	If $Tools_Parameter_Editor_aktiviert = "true" Then
		_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Parameter_Editor, "_Parameter_Editor_Contextmenue", $ISN_HotkeyDefaultFlags, $Studiofenster) ;Show parameter Editor

		_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Parameter_Editor_alle_Parameter_leeren, "_Parameter_Editor_Alle_Parameter_leeren", $EasyHotKey_DefaultFlags, $ParameterEditor_GUI) ;Clear all parameters
		_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Parameter_Editor_markierten_Parameter_leeren, "_Parameter_Editor_Markierten_Parameter_leeren", $EasyHotKey_DefaultFlags, $ParameterEditor_GUI) ;Clear selected parameter
		_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Parameter_Editor_naechster_Parameter, "_Parameter_Editor_Listview_select_nextrow", $EasyHotKey_DefaultFlags, $ParameterEditor_GUI) ;Select next parameter
		_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Parameter_Editor_neuer_Parameter, "_Parameter_Editor_Parameter_hinzufuegen", $EasyHotKey_DefaultFlags, $ParameterEditor_GUI) ;Add new parameter
		_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Parameter_Editor_markierten_Parameter_loeschen, "_Parameter_Editor_Parameter_entfernen", $EasyHotKey_DefaultFlags, $ParameterEditor_GUI) ;Remove selected parameter
	EndIf


	;Special hotkeys for the Scintilla Editor
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Zeile_nach_oben_verschieben, "_Markierte_Zeile_nach_oben_verschieben", $EasyHotKey_AllowHotkeyForChildGUIs + $EasyHotKey_AllowHoldDown, $Studiofenster, "scintilla") ;move row up
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_Zeile_nach_unten_verschieben, "_Markierte_Zeile_nach_unten_verschieben", $EasyHotKey_AllowHotkeyForChildGUIs + $EasyHotKey_AllowHoldDown, $Studiofenster, "scintilla") ;move row down
	_EasyHotKey_AssignNewHotkey("11+56", "_Hotkey_Scintilla_Paste_func", $EasyHotKey_AllowHotkeyForChildGUIs + $EasyHotKey_AllowHoldDown + $EasyHotKey_NoHotkeyBlock, $Studiofenster, "scintilla") ;Paste func for scintilla controls
	_EasyHotKey_AssignNewHotkey("09", "_Hotkey_Scintilla_Tab_func", $EasyHotKey_AllowHotkeyForChildGUIs + $EasyHotKey_AllowHoldDown + $EasyHotKey_NoHotkeyBlock, $Studiofenster, "scintilla") ;Tab func for scintilla controls
	_EasyHotKey_AssignNewHotkey("10+09", "_Hotkey_Scintilla_BackTab_func", $EasyHotKey_AllowHotkeyForChildGUIs + $EasyHotKey_AllowHoldDown + $EasyHotKey_NoHotkeyBlock, $Studiofenster, "scintilla") ;Tab func for scintilla controls
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_zeile_duplizieren, "_Zeile_Duplizieren", $EasyHotKey_AllowHotkeyForChildGUIs + $EasyHotKey_AllowHoldDown, $Studiofenster, "scintilla") ;Dublicate Row
	_EasyHotKey_AssignNewHotkey($Hotkey_Keycode_auskommentieren, "_comment_out", $EasyHotKey_DefaultFlags, $Studiofenster, "scintilla") ;comment_out
	If $allowcommentout = "true" Then
		_EasyHotKey_AssignNewHotkey("6D", "_comment_out", $EasyHotKey_DefaultFlags, $Studiofenster, "scintilla") ;comment_out (on num pad)
		_EasyHotKey_AssignNewHotkey("6D", "_comment_out", $EasyHotKey_DefaultFlags, $QuickView_GUI, "scintilla") ;comment_out (on num pad)
		_EasyHotKey_AssignNewHotkey("6D", "_comment_out", $EasyHotKey_DefaultFlags, $Codeausschnitt_GUI, "scintilla") ;comment_out (on num pad)
		_EasyHotKey_AssignNewHotkey("6D", "_comment_out", $EasyHotKey_DefaultFlags, $Makro_Codeausschnitt_GUI, "scintilla") ;comment_out (on num pad)
	EndIf


	;Hotkeys for various controls in the ISN window
	_EasyHotKey_AssignNewHotkey("0D", "_ISN_QuickSearchBar_FindNextButton", $EasyHotKey_NoHotkeyBlock, $Studiofenster, $ISN_QuickSearchbar_Input) ;enter (in quick search input)


	;Hotkeys for TVExplorer controls
	Local $GuisWithTVExplorer = $Studiofenster & "|" & $ISN_UDF_Manager_GUI & "|" & $QuickView_GUI
	_EasyHotKey_AssignNewHotkey("2E", "_Show_Delete_file_GUI", $EasyHotKey_NoHotkeyBlock, $GuisWithTVExplorer, "treeview") ;Delete file in project tree
	_EasyHotKey_AssignNewHotkey("71", "_Rename_File_in_Projecttree", $EasyHotKey_NoHotkeyBlock, $GuisWithTVExplorer, "treeview") ;F2 Rename file in project tree
	_EasyHotKey_AssignNewHotkey("11+43", "_ISN_TVExplorer_Copy2Clipboard", $EasyHotKey_DefaultFlags, $GuisWithTVExplorer, "treeview") ;ctrl+C copy file to clipboard
	_EasyHotKey_AssignNewHotkey("11+56", "_ISN_TVExplorer_PasteFromClipboard", $EasyHotKey_DefaultFlags, $GuisWithTVExplorer, "treeview") ;ctrl+V copy file to clipboard
	_EasyHotKey_AssignNewHotkey("11+58", "_ISN_TVExplorer_Cut2Clipboard", $EasyHotKey_DefaultFlags, $GuisWithTVExplorer, "treeview") ;ctrl+X cut file to clipboard
	_EasyHotKey_AssignNewHotkey("0D", "_ISN_TVExplorer_GlobalEnterFunc", $EasyHotKey_DefaultFlags, $GuisWithTVExplorer, "treeview") ;enter in treeview


	;Hotkeys for the debug console
	If $SHOW_DEBUG_CONSOLE = "true" Then
		_EasyHotKey_AssignNewHotkey("0D", "_Send_consolCommand", $EasyHotKey_DefaultFlags, $console_GUI) ;enter (in debug console)
		_EasyHotKey_AssignNewHotkey("26", "_ISN_DebugConsole_ArrowUpEvent", $EasyHotKey_DefaultFlags, $console_GUI) ;arrow up (in debug console)
		_EasyHotKey_AssignNewHotkey("28", "_ISN_DebugConsole_ArrowDownEvent", $EasyHotKey_DefaultFlags, $console_GUI) ;arrow down (in debug console)
	EndIf

	_Aktualisiere_Texte_in_Contextmenues_wegen_Hotkeys()
	$ISN_Hotkey_Hook_aktiv = 1
EndFunc   ;==>_ISN_aktualisiere_Hotkeys



; #FUNCTION# ;===============================================================================
;
; Name...........: _Keycode_zu_Text
; Description ...: Wandelt einen Keycode (zb. 11+58) in einen für den User leicht lesbaren Text um -> zb. "STRG+X"
; Syntax.........: _Keycode_zu_Text($keycode)
; Parameters ....: $keycode			- Welcher Keycode soll umgewandelt werden
; Return values .: none
; Author ........: ISI360
; Modified.......:
; Remarks .......: Wird in den Programmeinstellungen benötigt
; Related .......:
; Link ..........: https://www.isnetwork.at
; Example .......: No
;
; ;==========================================================================================

Func _Keycode_zu_Text($keyCode = "")
	If $keyCode = "" Then Return ""
	$array = StringSplit($keyCode, "+", 2)
	For $Index = 0 To UBound($array) - 1
		$text = Chr(Dec($array[$Index]))
		If $array[$Index] = "11" Then $text = "Ctrl"
		If $array[$Index] = "12" Then $text = "Alt"
		If $array[$Index] = "10" Then $text = "Shift"
		If $array[$Index] = "DC" Then $text = _Get_langstr(1021) ;"Zirkumflex"
		If $array[$Index] = "09" Then $text = "TAB"
		If $array[$Index] = "70" Then $text = "F1"
		If $array[$Index] = "71" Then $text = "F2"
		If $array[$Index] = "72" Then $text = "F3"
		If $array[$Index] = "73" Then $text = "F4"
		If $array[$Index] = "74" Then $text = "F5"
		If $array[$Index] = "75" Then $text = "F6"
		If $array[$Index] = "76" Then $text = "F7"
		If $array[$Index] = "77" Then $text = "F8"
		If $array[$Index] = "78" Then $text = "F9"
		If $array[$Index] = "79" Then $text = "F10"
		If $array[$Index] = "7A" Then $text = "F11"
		If $array[$Index] = "7B" Then $text = "F12"
		If $array[$Index] = "2E" Then $text = "Del"
		If $array[$Index] = "23" Then $text = "End"
		If $array[$Index] = "24" Then $text = "Home"
		If $array[$Index] = "0D" Then $text = "Enter"
		If $array[$Index] = "20" Then $text = "Space"
		If $array[$Index] = "2C" Then $text = _Get_langstr(882) ;Drucken
		If $array[$Index] = "6D" Then $text = _Get_langstr(1022) ;"Minus am Nummernblock"
		If $array[$Index] = "6F" Then $text = _Get_langstr(1023) ;"Dividieren am Nummernblock"
		If $array[$Index] = "6A" Then $text = _Get_langstr(1024) ;"Multiplizieren am Nummernblock"
		If $array[$Index] = "6B" Then $text = _Get_langstr(1025) ;"Plus am Nummernblock"
		If $array[$Index] = "60" Then $text = "0 " & _Get_langstr(1026)
		If $array[$Index] = "61" Then $text = "1 " & _Get_langstr(1026)
		If $array[$Index] = "62" Then $text = "2 " & _Get_langstr(1026)
		If $array[$Index] = "63" Then $text = "3 " & _Get_langstr(1026)
		If $array[$Index] = "64" Then $text = "4 " & _Get_langstr(1026)
		If $array[$Index] = "65" Then $text = "5 " & _Get_langstr(1026)
		If $array[$Index] = "66" Then $text = "6 " & _Get_langstr(1026)
		If $array[$Index] = "67" Then $text = "7 " & _Get_langstr(1026)
		If $array[$Index] = "68" Then $text = "8 " & _Get_langstr(1026)
		If $array[$Index] = "69" Then $text = "9 " & _Get_langstr(1026)
		If $array[$Index] = "21" Then $text = _Get_langstr(1027) ;"Seite nach oben"
		If $array[$Index] = "22" Then $text = _Get_langstr(1028) ;"Seite nach unten"
		If $array[$Index] = "26" Then $text = _Get_langstr(1017) ;Pfeil oben
		If $array[$Index] = "28" Then $text = _Get_langstr(1018) ;Pfeil unten
		If $array[$Index] = "25" Then $text = _Get_langstr(1019) ;Pfeil links
		If $array[$Index] = "27" Then $text = _Get_langstr(1020) ;Pfeil rechts
		If $array[$Index] = "2D" Then $text = _Get_langstr(112) ;Einfügen (Einfg)
		If $array[$Index] = "5B" Or $array[$Index] = "5C" Then $text = _Get_langstr(1300) ;Windows Logo Taste
		$array[$Index] = $text
	Next
	Return _ArrayToString($array, "+")
EndFunc   ;==>_Keycode_zu_Text

;-----------------------------------------------------------------------------------------------------------------
;    Function       _getKeyKombi()
;
;    Description    Gibt die gedrückte Taste(nkombination) zurück, die gedrückt wurde.
;                    Die Funktion wartet solang, bis mind. eine Taste gedrückt und losgelassen wurde.
;
;    Return         Array mit n Elementen
;                    Array[0]    Anzahl der gedrückten Tasten
;                    Array[1..n]    gedrückte Taste(n) als Hex-Wert (Hex-Werte in Hilfe von _IsPressed() aufgelistet)
;
;     Version        0.1
;
;    Author         zemkedesign (http://www.autoit.de/index.php?page=User&userID=200384)
;-----------------------------------------------------------------------------------------------------------------

Func _getKeyKombi()

	Local $i_keys_pressed_count = 0
	Local $s_keys_pressed = ""
	Local $as_return[1]
	$ISN_Hotkey_Hook_aktiv = 0 ;Disable ISN hotkeys
	Sleep(300)
	While 1
		;Anzahl und Tasten ermitteln
		$as_array = _getKey($s_keys_pressed)
;~         ConsoleWrite($s_keys_pressed & @CR)
		;neue Taste gedrückt
		If $as_array[0] > $i_keys_pressed_count Then $s_keys_pressed &= $as_array[1]
		;aktuell weniger gedrückt, als im Durchlauf zuvor
		If $as_array[0] < $i_keys_pressed_count Then ExitLoop
		;aktuell gedrückte Tasten zwischenspeichern
		$i_keys_pressed_count = $as_array[0]
	WEnd

	;Rückgabe
	$as_return[0] = $i_keys_pressed_count ;Anzahl gedrückter Tasten
	For $i = 1 To StringLen($s_keys_pressed) Step 2
		_ArrayAdd($as_return, StringMid($s_keys_pressed, $i, 2)) ;Tasten teilen
	Next
	_ArrayDelete($as_return, 0)
	$ISN_Hotkey_Hook_aktiv = 1 ;Re-enable ISN hotkeys
	Return $as_return

EndFunc   ;==>_getKeyKombi

;-----------------------------------------------------------------------------------------------------------------
;    Function       _getKey([$s_ignored_keys = ""])
;
;    Description    Gibt die gedrückte Taste zurück, die momentan gedrückt ist.
;                    Ignoriert werden Tasten, die im Parameter gespeichert sind.
;
;    Parameter      optional    $s_ignored_keys: zu ignorierende Tasten
;
;    Return         Erfolg        Array mit zwei Elementen
;                                Array[0]    Anzahl der gedrückten Tasten (ignorierte Tasten werden mitgezählt)
;                                Array[1]    gedrückte Taste (ignorierte Tasten werden nicht zurückgegeben)
;                    Fehler        keine Taste wurde gedrückt
;                                Array[0]    0
;                                Array[1]    Leerstring
;
;     Version        0.1
;
;    Author         zemkedesign (http://www.autoit.de/index.php?page=User&userID=200384)
;-----------------------------------------------------------------------------------------------------------------

Func _getKey($s_ignored_keys = "")

	Local $as_return[2]
	Local $as_keys[81]
	$as_return[0] = 0
	$as_return[1] = ""

	#Region keys
		$as_keys[0] = "10" ;SHIFT
		$as_keys[1] = "11" ;STRG
		$as_keys[2] = "12" ;ALT
		$as_keys[3] = "30" ;0
		$as_keys[4] = "31" ;1
		$as_keys[5] = "32" ;2
		$as_keys[6] = "33" ;3
		$as_keys[7] = "34" ;4
		$as_keys[8] = "35" ;5
		$as_keys[9] = "36" ;6
		$as_keys[10] = "37" ;7
		$as_keys[11] = "38" ;8
		$as_keys[12] = "39" ;9
		$as_keys[13] = "41" ;A
		$as_keys[14] = "42" ;B
		$as_keys[15] = "43" ;C
		$as_keys[16] = "44" ;D
		$as_keys[17] = "45" ;E
		$as_keys[18] = "46" ;F
		$as_keys[19] = "47" ;G
		$as_keys[20] = "48" ;H
		$as_keys[21] = "49" ;I
		$as_keys[22] = "4A" ;J
		$as_keys[23] = "4B" ;K
		$as_keys[24] = "4C" ;L
		$as_keys[25] = "4D" ;M
		$as_keys[26] = "4E" ;N
		$as_keys[27] = "4F" ;O
		$as_keys[28] = "50" ;P
		$as_keys[29] = "51" ;Q
		$as_keys[30] = "52" ;R
		$as_keys[31] = "53" ;S
		$as_keys[32] = "54" ;T
		$as_keys[33] = "55" ;U
		$as_keys[34] = "56" ;V
		$as_keys[35] = "57" ;W
		$as_keys[36] = "58" ;X
		$as_keys[37] = "59" ;Y
		$as_keys[38] = "5A" ;Z
		$as_keys[39] = "09" ;Tab
		$as_keys[40] = "70" ;F1
		$as_keys[41] = "71" ;F2
		$as_keys[42] = "72" ;F3
		$as_keys[43] = "73" ;F4
		$as_keys[44] = "74" ;F5
		$as_keys[45] = "75" ;F6
		$as_keys[46] = "76" ;F7
		$as_keys[47] = "77" ;F8
		$as_keys[48] = "78" ;F9
		$as_keys[49] = "79" ;F9
		$as_keys[50] = "7A" ;F9
		$as_keys[51] = "7B" ;F9
		$as_keys[52] = "6D" ;Minus am Nummernblock
		$as_keys[53] = "6F" ;Dividieren am Nummernblock
		$as_keys[54] = "6A" ;Multiplizieren am Nummernblock
		$as_keys[55] = "6B" ;Plus am Nummernblock
		$as_keys[56] = "60" ;0 am Nummernblock
		$as_keys[57] = "61" ;1 am Nummernblock
		$as_keys[58] = "62" ;2 am Nummernblock
		$as_keys[59] = "63" ;3 am Nummernblock
		$as_keys[60] = "64" ;4 am Nummernblock
		$as_keys[61] = "65" ;5 am Nummernblock
		$as_keys[62] = "66" ;6 am Nummernblock
		$as_keys[63] = "67" ;7 am Nummernblock
		$as_keys[64] = "68" ;8 am Nummernblock
		$as_keys[65] = "69" ;9 am Nummernblock
		$as_keys[66] = "21" ;Page up
		$as_keys[67] = "22" ;Page down
		$as_keys[68] = "DC" ;zirkumflex
		$as_keys[69] = "26" ;Pfeil oben
		$as_keys[70] = "28" ;Pfeil unten
		$as_keys[71] = "25" ;Pfeil links
		$as_keys[72] = "27" ;Pfeil rechts
		$as_keys[73] = "5C" ;Windows Logo Taste Rechts
		$as_keys[74] = "5B" ;Windows Logo Taste Links
		$as_keys[75] = "2E" ;Del (Entf)
		$as_keys[76] = "2D" ;Einfg (Insert)
		$as_keys[77] = "23" ;Ende
		$as_keys[78] = "2C" ;Print
		$as_keys[79] = "24" ;Pos1 (Home)
		$as_keys[80] = "0D" ;Enter
		$as_keys[80] = "20" ;SPACE
	#EndRegion keys

	For $i = 0 To UBound($as_keys) - 1
		If _IsPressed($as_keys[$i], $user32) Then
			;Anzahl gedrückter Tasten erhöhen
			$as_return[0] += 1
			;Taste wurde noch nicht schon einmal gedrückt
			If StringInStr($s_ignored_keys, $as_keys[$i]) = 0 Then $as_return[1] &= $as_keys[$i]
		EndIf
	Next

	Return $as_return

EndFunc   ;==>_getKey

; #FUNCTION# ;===============================================================================
;
; Name...........: _Erstelle_kopie_von_markierter_datei
; Description ...: Erstellt eine Kopie des Markierten Elementes im Projektbaum
; Syntax.........: _Erstelle_kopie_von_markierter_datei()
; Parameters ....: none
; Return values .: none
; Author ........: ISI360
; Modified.......:
; Remarks .......: Kann zb. im Kontextmenü des Projektbaumes aufgerufen werden
; Related .......:
; Link ..........: https://www.isnetwork.at
; Example .......: No
;
; ;==========================================================================================

Func _Erstelle_kopie_von_markierter_datei()
	If $Offenes_Projekt = "" Then Return -1
	If Not IsHWnd($Current_TVExplorer_TreeView) Then Return -1
	Local $Treeview = $Current_TVExplorer_TreeView
	If _GUICtrlTreeView_GetSelection($Treeview) = 0 Then Return
	If _WinAPI_PathIsRoot(_GUICtrlTVExplorer_GetSelected($Treeview)) Then Return
	If _GUICtrlTVExplorer_GetSelected($Treeview) = -1 Then Return
	If _GUICtrlTVExplorer_GetSelected($Treeview) = $Offenes_Projekt Then Return
	$Pfad = _GUICtrlTVExplorer_GetSelected($Treeview)
	Dim $szDrive, $szDir, $szFName, $szExt
	$TestPath = _PathSplit($Pfad, $szDrive, $szDir, $szFName, $szExt)
	$Projektbaum_ist_bereit = 0
	$OwnerWindow = _WinAPI_GetAncestor($Current_TVExplorer_TreeView, $GA_PARENT)
	$answer = InputBox(_Get_langstr(371), _Get_langstr(693), $szFName & " (" & _Get_langstr(373) & ")" & $szExt, "", Default, Default, Default, Default, 0, $OwnerWindow)
	If @error Then
		$Projektbaum_ist_bereit = 1
		Return
	EndIf
	If _IsDir($Pfad) Then
		DirCopy($Pfad, $szDrive & $szDir & $answer)
	Else
		FileCopy($Pfad, $szDrive & $szDir & $answer)
	EndIf
	Sleep(250)
	$Projektbaum_ist_bereit = 1
EndFunc   ;==>_Erstelle_kopie_von_markierter_datei

; #FUNCTION# ;===============================================================================
;
; Name...........: _Pruefe_nach_Onlineupdates_AUTO
; Description ...: Prüft im Hintergrund nach Updates und zeigt ggf. eine Meldung an
; Syntax.........: _Pruefe_nach_Onlineupdates_AUTO($hWnd, $Msg, $iIDTimer, $dwTime)
; Return values .: none
; Author ........: ISI360
; Modified.......:
; Remarks .......: Wird durch einen Timer aufgerufen
; Related .......:
; Link ..........: https://www.isnetwork.at
; Example .......: No
;
; ;==========================================================================================

Func _Pruefe_nach_Onlineupdates_AUTO($hWnd, $msg, $iIDTimer, $dwTime)
	If $enable_autoupdate = "false" Then Return ;Autoupdate deaktiviert
	If ProcessExists($ISN_Helper_Threads[$ISN_Helper_Updater][$ISN_Helper_PID]) Then Return ;Läuft bereits
	If Not @Compiled Then Return ;No Autoupdate in source version!
	;Nur falls das Zeitlimit in Tagen bereits überschritten ist
	$Differenz = _DateDiff('D', IniRead($Configfile, "config", "autoupdate_lastdate", "2012/01/01"), _NowCalcDate())
	_Timer_KillTimer($Studiofenster, $Auto_Update_Timer_Handle) ;Stoppe Timer damit Meldung nicht nocheinmal erscheint
	If $Differenz > $autoupdate_searchtimer Then _ISN_AutoIt_Studio_nach_updates_Suchen_Silent()
EndFunc   ;==>_Pruefe_nach_Onlineupdates_AUTO



; #FUNCTION# ;===============================================================================
;
; Name...........: _Fuege_Datei_zu_Zuletzt_Verwendete_Dateien
; Description ...: Fügt eine Datei in das Menü Datei -> Zuletzt verwendete Dateien hinzu.
; Syntax.........: _Fuege_Datei_zu_Zuletzt_Verwendete_Dateien($Pfad)
; Parameters ....: $Pfad			- Pfad zur Datei
; Return values .: Array mit allen Pfaden und Dateien
; Author ........: ISI360
; Modified.......:
; Remarks .......: List wird in der project.isn im key "lastusedfiles" gespeichert
; Related .......:
; Link ..........: https://www.isnetwork.at
; Example .......: No
;
; ;==========================================================================================

Func _Fuege_Datei_zu_Zuletzt_Verwendete_Dateien($Pfad = "")

	If $Pfad = "" Then Return
	If Not IsArray($Zuletzt_Verwendete_Dateien_Temp_Array) Then Return
	$Pfad = _ISN_Pfad_durch_Variablen_ersetzen(FileGetLongName($Pfad))

	;prüfe ob Eintrag schon in der Liste ist
	If _ArraySearch($Zuletzt_Verwendete_Dateien_Temp_Array, $Pfad) = -1 Then
		;noch nicht in der Liste

		;Rücke alle Einträge 1 nach unten
		For $y = UBound($Zuletzt_Verwendete_Dateien_Temp_Array) - 1 To 1 Step -1
			$Zuletzt_Verwendete_Dateien_Temp_Array[$y] = $Zuletzt_Verwendete_Dateien_Temp_Array[$y - 1]
		Next
		;Füge neues Element ein
		$Zuletzt_Verwendete_Dateien_Temp_Array[0] = $Pfad

	Else
		;bereits in der Liste

		;Lösche das Element aus der Liste...
		_ArrayDelete($Zuletzt_Verwendete_Dateien_Temp_Array, _ArraySearch($Zuletzt_Verwendete_Dateien_Temp_Array, $Pfad))
		_ArrayAdd($Zuletzt_Verwendete_Dateien_Temp_Array, "")
		;..und füge es neu ein:
		$Zuletzt_Verwendete_Dateien_Temp_Array = _Fuege_Datei_zu_Zuletzt_Verwendete_Dateien($Pfad)

	EndIf

	;Schreibe das Array in die project.isn und aktualisiere die Einträge im Datei Menü
	$lastusedfiles_String = ""
	_SendMessage($Studiofenster, $WM_SETREDRAW, False) ;prevent flickering of the menu bar
	For $x = 0 To UBound($Zuletzt_Verwendete_Dateien_Temp_Array) - 1
		$lastusedfiles_String = $lastusedfiles_String & $Zuletzt_Verwendete_Dateien_Temp_Array[$x] & "|"

		If $x = 0 Then _GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot1, _Zuletzt_Verwendete_Dateien_pruefe_ob_leer($ISN_FileMenu_LastUsedFiles_Slot1, $Zuletzt_Verwendete_Dateien_Temp_Array[$x]))
		If $x = 1 Then _GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot2, _Zuletzt_Verwendete_Dateien_pruefe_ob_leer($ISN_FileMenu_LastUsedFiles_Slot2, $Zuletzt_Verwendete_Dateien_Temp_Array[$x]))
		If $x = 2 Then _GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot3, _Zuletzt_Verwendete_Dateien_pruefe_ob_leer($ISN_FileMenu_LastUsedFiles_Slot3, $Zuletzt_Verwendete_Dateien_Temp_Array[$x]))
		If $x = 3 Then _GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot4, _Zuletzt_Verwendete_Dateien_pruefe_ob_leer($ISN_FileMenu_LastUsedFiles_Slot4, $Zuletzt_Verwendete_Dateien_Temp_Array[$x]))
		If $x = 4 Then _GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot5, _Zuletzt_Verwendete_Dateien_pruefe_ob_leer($ISN_FileMenu_LastUsedFiles_Slot5, $Zuletzt_Verwendete_Dateien_Temp_Array[$x]))
		If $x = 5 Then _GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot6, _Zuletzt_Verwendete_Dateien_pruefe_ob_leer($ISN_FileMenu_LastUsedFiles_Slot6, $Zuletzt_Verwendete_Dateien_Temp_Array[$x]))
		If $x = 6 Then _GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot7, _Zuletzt_Verwendete_Dateien_pruefe_ob_leer($ISN_FileMenu_LastUsedFiles_Slot7, $Zuletzt_Verwendete_Dateien_Temp_Array[$x]))
		If $x = 7 Then _GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot8, _Zuletzt_Verwendete_Dateien_pruefe_ob_leer($ISN_FileMenu_LastUsedFiles_Slot8, $Zuletzt_Verwendete_Dateien_Temp_Array[$x]))
		If $x = 8 Then _GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot9, _Zuletzt_Verwendete_Dateien_pruefe_ob_leer($ISN_FileMenu_LastUsedFiles_Slot9, $Zuletzt_Verwendete_Dateien_Temp_Array[$x]))
		If $x = 9 Then _GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot10, _Zuletzt_Verwendete_Dateien_pruefe_ob_leer($ISN_FileMenu_LastUsedFiles_Slot10, $Zuletzt_Verwendete_Dateien_Temp_Array[$x]))

	Next
	_SendMessage($Studiofenster, $WM_SETREDRAW, True)
	If StringLen($lastusedfiles_String) > 1 Then $lastusedfiles_String = StringTrimRight($lastusedfiles_String, 1)
	IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "lastusedfiles", $lastusedfiles_String)

	Return $Zuletzt_Verwendete_Dateien_Temp_Array
EndFunc   ;==>_Fuege_Datei_zu_Zuletzt_Verwendete_Dateien

; #FUNCTION# ;===============================================================================
;
; Name...........: _Lade_Zuletzt_Verwendete_Dateien_aus_projectISN
; Description ...: Lädt die Liste der Zuletzt Verwendete Dateien aus der project.isn des jewailigen Projektes (KEY: lastusedfiles)
; Syntax.........: _Lade_Zuletzt_Verwendete_Dateien_aus_projectISN()
; Parameters ....: None
; Return values .: None
; Author ........: ISI360
; Modified.......:
; Remarks .......: $Offenes_Projekt darf nicht leer sein!
; Related .......:
; Link ..........: https://www.isnetwork.at
; Example .......: No
;
; ;==========================================================================================

Func _Lade_Zuletzt_Verwendete_Dateien_aus_projectISN()
	If $Offenes_Projekt = "" Then Return
	$ini = IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "lastusedfiles", "||||||||||")
	If $ini = "" Then $ini = "||||||||||"
	$array = StringSplit($ini, "|", 2)

	If IsArray($array) Then
		If UBound($array) - 1 > 10 Then Return ;Error

		;Resete alle Slots
		$Zuletzt_Verwendete_Dateien_Temp_Array = $array
		_GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot1, _Get_langstr(722))
		_GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot2, _Get_langstr(722))
		_GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot3, _Get_langstr(722))
		_GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot4, _Get_langstr(722))
		_GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot5, _Get_langstr(722))
		_GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot6, _Get_langstr(722))
		_GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot7, _Get_langstr(722))
		_GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot8, _Get_langstr(722))
		_GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot9, _Get_langstr(722))
		_GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot10, _Get_langstr(722))

		GUICtrlSetState($ISN_FileMenu_LastUsedFiles_Slot1, $GUI_DISABLE)
		GUICtrlSetState($ISN_FileMenu_LastUsedFiles_Slot2, $GUI_DISABLE)
		GUICtrlSetState($ISN_FileMenu_LastUsedFiles_Slot3, $GUI_DISABLE)
		GUICtrlSetState($ISN_FileMenu_LastUsedFiles_Slot4, $GUI_DISABLE)
		GUICtrlSetState($ISN_FileMenu_LastUsedFiles_Slot5, $GUI_DISABLE)
		GUICtrlSetState($ISN_FileMenu_LastUsedFiles_Slot6, $GUI_DISABLE)
		GUICtrlSetState($ISN_FileMenu_LastUsedFiles_Slot7, $GUI_DISABLE)
		GUICtrlSetState($ISN_FileMenu_LastUsedFiles_Slot8, $GUI_DISABLE)
		GUICtrlSetState($ISN_FileMenu_LastUsedFiles_Slot9, $GUI_DISABLE)
		GUICtrlSetState($ISN_FileMenu_LastUsedFiles_Slot10, $GUI_DISABLE)

		;Setze Texte
		For $x = 0 To UBound($Zuletzt_Verwendete_Dateien_Temp_Array) - 1
			If $x = 0 Then _GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot1, _Zuletzt_Verwendete_Dateien_pruefe_ob_leer($ISN_FileMenu_LastUsedFiles_Slot1, $Zuletzt_Verwendete_Dateien_Temp_Array[$x]))
			If $x = 1 Then _GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot2, _Zuletzt_Verwendete_Dateien_pruefe_ob_leer($ISN_FileMenu_LastUsedFiles_Slot2, $Zuletzt_Verwendete_Dateien_Temp_Array[$x]))
			If $x = 2 Then _GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot3, _Zuletzt_Verwendete_Dateien_pruefe_ob_leer($ISN_FileMenu_LastUsedFiles_Slot3, $Zuletzt_Verwendete_Dateien_Temp_Array[$x]))
			If $x = 3 Then _GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot4, _Zuletzt_Verwendete_Dateien_pruefe_ob_leer($ISN_FileMenu_LastUsedFiles_Slot4, $Zuletzt_Verwendete_Dateien_Temp_Array[$x]))
			If $x = 4 Then _GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot5, _Zuletzt_Verwendete_Dateien_pruefe_ob_leer($ISN_FileMenu_LastUsedFiles_Slot5, $Zuletzt_Verwendete_Dateien_Temp_Array[$x]))
			If $x = 5 Then _GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot6, _Zuletzt_Verwendete_Dateien_pruefe_ob_leer($ISN_FileMenu_LastUsedFiles_Slot6, $Zuletzt_Verwendete_Dateien_Temp_Array[$x]))
			If $x = 6 Then _GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot7, _Zuletzt_Verwendete_Dateien_pruefe_ob_leer($ISN_FileMenu_LastUsedFiles_Slot7, $Zuletzt_Verwendete_Dateien_Temp_Array[$x]))
			If $x = 7 Then _GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot8, _Zuletzt_Verwendete_Dateien_pruefe_ob_leer($ISN_FileMenu_LastUsedFiles_Slot8, $Zuletzt_Verwendete_Dateien_Temp_Array[$x]))
			If $x = 8 Then _GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot9, _Zuletzt_Verwendete_Dateien_pruefe_ob_leer($ISN_FileMenu_LastUsedFiles_Slot9, $Zuletzt_Verwendete_Dateien_Temp_Array[$x]))
			If $x = 9 Then _GUICtrlODMenuItemSetText($ISN_FileMenu_LastUsedFiles_Slot10, _Zuletzt_Verwendete_Dateien_pruefe_ob_leer($ISN_FileMenu_LastUsedFiles_Slot10, $Zuletzt_Verwendete_Dateien_Temp_Array[$x]))

		Next
	EndIf

EndFunc   ;==>_Lade_Zuletzt_Verwendete_Dateien_aus_projectISN

Func _kuerze_Dateinamen($String)
	If StringLen($String) > 45 Then
		$String = "..." & StringTrimLeft($String, StringLen($String) - 45)
	EndIf
	Return $String
EndFunc   ;==>_kuerze_Dateinamen

Func _Zuletzt_Verwendete_Dateien_pruefe_ob_leer($item, $text)
	If $text = "" Then
		GUICtrlSetState($item, $GUI_DISABLE)
		Return _Get_langstr(722)
	EndIf
	$text = _ISN_Variablen_aufloesen($text)
	GUICtrlSetState($item, $GUI_ENABLE)
	Return _kuerze_Dateinamen($text)
EndFunc   ;==>_Zuletzt_Verwendete_Dateien_pruefe_ob_leer

; #FUNCTION# ;===============================================================================
;
; Name...........: _Oeffne_Zuletzt_Verwendete_Dateie
; Description ...: Lädt eine Datei aus der Liste der Zuletzt Verwendete Dateien in das ISN AutoIt Studio. (Erster Slot ist 0!!)
; Syntax.........: _Oeffne_Zuletzt_Verwendete_Dateie($SlotNr)
; Parameters ....: None
; Return values .: None
; Author ........: ISI360
; Modified.......:
; Remarks .......: Dabei wird auch überprüft ob die Datei überhaupt noch existiert
; Related .......:
; Link ..........: https://www.isnetwork.at
; Example .......: No
;
; ;==========================================================================================

Func _Oeffne_Zuletzt_Verwendete_Dateie($SlotNr = -1)
	If $SlotNr = -1 Then Return
	If $SlotNr > 9 Then Return
	If Not IsArray($Zuletzt_Verwendete_Dateien_Temp_Array) Then Return
	$file = $Zuletzt_Verwendete_Dateien_Temp_Array[Number($SlotNr)]
	If $file = "" Then Return
	If $file = _Get_langstr(722) Then Return
	$file = _ISN_Variablen_aufloesen($file)
	Sleep(100)
	If FileExists($file) Then
		Try_to_opten_file($file)
	Else
		;Falls Fehler versuche noch mit relativen Pfaden
		If FileExists($Offenes_Projekt & $file) Then
			Try_to_opten_file($Offenes_Projekt & $file)
		Else
			;Falls das auch nicht fnktioniert -> Fehlermeldung
			MsgBox(262144 + 16, _Get_langstr(25), StringReplace(_Get_langstr(724), "%1", $file), 0, $Studiofenster)
		EndIf
	EndIf
EndFunc   ;==>_Oeffne_Zuletzt_Verwendete_Dateie

Func _Speichern_unter()
	If $Offenes_Projekt = "" Then Return
	If _GUICtrlTab_GetItemCount($htab) = 0 Then Return
	Dim $szDrive, $szDir, $szFName, $szExt
	If $Plugin_Handle[_GUICtrlTab_GetCurFocus($htab)] <> "-1" Then Return ;KEIN SPEICHERN UNTER FÜR PLUGINS!
	$Geoeffnete_Datei = $Datei_pfad[_GUICtrlTab_GetCurFocus($htab)]
	$TestPath = _PathSplit($Geoeffnete_Datei, $szDrive, $szDir, $szFName, $szExt)
	Local $Extension_Backup = $szExt
	_Lock_Plugintabs("lock")
	If $Skin_is_used = "true" Then
		$line = _WinAPI_SaveFileDlg(_Get_langstr(725), $szDrive & $szDir, "All (*.*)", 0, $szFName & $szExt, '', BitOR($OFN_PATHMUSTEXIST, $OFN_FILEMUSTEXIST, $OFN_HIDEREADONLY), $OFN_EX_NOPLACESBAR, 0, 0, $Studiofenster)
	Else
		$line = FileSaveDialog(_Get_langstr(725), $szDrive & $szDir, "All (*.*)", 18, $szFName & $szExt, $Studiofenster)
	EndIf
	If $line = "" Then Return
	If @error > 0 Then Return
	_Lock_Plugintabs("unlock")
	$TestPath = _PathSplit($line, $szDrive, $szDir, $szFName, $szExt)
	If $szExt = "" Then
		$line = $line & $Extension_Backup
		$TestPath = _PathSplit($line, $szDrive, $szDir, $szFName, $szExt)
	EndIf
	FileChangeDir(@ScriptDir)
	FileCopy($Geoeffnete_Datei, $line, 9)
	$Datei_pfad[_GUICtrlTab_GetCurFocus($htab)] = $line
	_GUICtrlTab_SetItemText($htab, _GUICtrlTab_GetCurFocus($htab), $szFName & $szExt)
	_Redraw_Window($Studiofenster)
EndFunc   ;==>_Speichern_unter

Func _exportiere_Projekteigenschaften_als_csv()
	If $Skin_is_used = "true" Then
		$line = _WinAPI_SaveFileDlg(_Get_langstr(740), "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}", "csv (*.csv)", 0, "export.csv", '', BitOR($OFN_PATHMUSTEXIST, $OFN_FILEMUSTEXIST, $OFN_HIDEREADONLY), $OFN_EX_NOPLACESBAR, 0, 0, $Projekteinstellungen_GUI)
	Else
		$line = FileSaveDialog(_Get_langstr(740), "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}", "csv (*.csv)", 18, "export.csv", $Projekteinstellungen_GUI)
	EndIf
	If $line = "" Then Return
	If @error > 0 Then Return
	FileChangeDir(@ScriptDir)
	_GUICtrlListView_SaveCSV($Project_Properties_listview, $line)
	MsgBox(262144 + 64, _Get_langstr(61), _Get_langstr(164), 0, $Studiofenster)
EndFunc   ;==>_exportiere_Projekteigenschaften_als_csv

; #AutoIt3Wrapper_Au3Check_Parameters=-d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
; #FUNCTION# =========================================================================================================
; Name...........: _GUICtrlListView_SaveCSV()
; Description ...: Exports the details of a ListView to a .csv file.
; Syntax.........: _GUICtrlListView_SaveCSV($hListView, $sFile, [$sDelimiter = ",", $sQuote = '"']])
; Parameters ....: $hListView - Handle of the ListView.
;                  $sFile - FilePath, this should ideally use the filetype .csv e.g. @ScriptDir & "\Example.csv"
;                  $sDelimiter - [Optional] Delimiter to be used for the csv file. [Default = ,]
;                  $sQuote - [Optional] Style of quotes to be used for the csv file. [Default = "]
; Requirement(s).: v3.2.12.1 or higher
; Return values .: Success - Returns filepath.
;                  Failure - Returns filepath & sets @error = 1
; Author ........: guinness & ProgAndy for the csv idea.
; Example........; Yes
;=====================================================================================================================

Func _GUICtrlListView_SaveCSV($hListView, $sFile, $sDelimiter = ",", $sQuote = '"')
	Local $hFileOpen, $iError = 0, $sItem, $sString
	Local $iColumnCount = _GUICtrlListView_GetColumnCount($hListView)
	Local $iItemCount = _GUICtrlListView_GetItemCount($hListView)

	For $a = 0 To $iItemCount - 1
		For $b = 0 To $iColumnCount - 1
			$sItem = _GUICtrlListView_GetItemText($hListView, $a, $b)
			$sString &= $sQuote & StringReplace($sItem, $sQuote, $sQuote & $sQuote, 0, 1) & $sQuote
			If $b < $iColumnCount - 1 Then
				$sString &= $sDelimiter
			EndIf
		Next
		$sString &= @CRLF
	Next
	$hFileOpen = FileOpen($sFile, 2 + $FO_ANSI)
	FileWrite($hFileOpen, $sString)
	FileClose($hFileOpen)
	If @error Then
		$iError = 1
	EndIf
	Return SetError($iError, 0, $sFile)
EndFunc   ;==>_GUICtrlListView_SaveCSV

; #FUNCTION# ====================================================================================================================
; Name...........: _ArrayUnique
; Description ...: Returns the Unique Elements of a 1-dimensional array.
; Syntax.........: _ArrayUnique($aArray[, $iDimension = 1[, $iIdx = 0[, $iCase = 0[, $iFlags = 1]]]])
; Parameters ....: $aArray    - Input array (1D or 2D only)
;                 $iDimension  - [optional] The dimension of the array to process (only valid for 2D arrays)
;                 $iIdx     - [optional] Index at which to start scanning the input array
;                 $iCase       - [optional] Flag to indicate if string comparisons should be case sensitive
;                                | 0 - case insensitive
;                                | 1 - case sensitive
;                 $iFlags     - [optional] Set of flags, added together
;                                | 1 - Return the array count in element [0]
; Return values .: Success    - Returns a 1-dimensional array containing only the unique elements of the input array / dimension
;                 Failure     - Returns 0 and sets @error:
;                                | 1 - Input is not an array
;                                | 2 - Arrays greater than 2 dimensions are not supported
;                                | 3 - $iDimension is out of range
;                                | 4 - $iIdx is out of range
; Author ........: SmOke_N
; Modified.......: litlmike, Erik Pilsits
; Remarks .......:
; Related .......: _ArrayMax, _ArrayMin
; Link ..........:
; Example .......: Yes
; ===============================================================================================================================

Func __ArrayUnique(Const ByRef $aArray, $iDimension = 1, $iIdx = 0, $iCase = 0, $iFlags = 0)
	; Check to see if it is valid array
	If Not IsArray($aArray) Then Return SetError(1, 0, 0)
	Local $iDims = UBound($aArray, 0)
	If $iDims > 2 Then Return SetError(2, 0, 0)
	;
	; checks the given dimension is valid
	If ($iDimension <= 0) Or (($iDims = 1) And ($iDimension > 1)) Or (($iDims = 2) And ($iDimension > UBound($aArray, 2))) Then Return SetError(3, 0, 0)
	; make $iDimension an array index, note this is ignored for 1D arrays
	$iDimension -= 1
	;
	; check $iIdx
	If ($iIdx < 0) Or ($iIdx >= UBound($aArray)) Then Return SetError(4, 0, 0)
	;
	; create dictionary
	Local $oD = ObjCreate("Scripting.Dictionary")
	; compare mode for strings
	; 0 = binary, which is case sensitive
	; 1 = text, which is case insensitive
	; this expression forces either 1 or 0
	$oD.CompareMode = Number(Not $iCase)
	;
	Local $vElem
	; walk the input array
	For $i = $iIdx To UBound($aArray) - 1
		If $iDims = 1 Then
			; 1D array
			$vElem = $aArray[$i]
		Else
			; 2D array
			$vElem = $aArray[$i][$iDimension]
		EndIf
		; add key to dictionary
		; NOTE: accessing the value (.Item property) of a key that doesn't exist creates the key :)
		; keys are guaranteed to be unique
		$oD.Item($vElem)
	Next
	;
	; return the array of unique keys
	If BitAND($iFlags, 1) = 1 Then
		Local $aTemp = $oD.Keys()
		_ArrayInsert($aTemp, 0, $oD.Count)
		Return $aTemp
	Else
		Return $oD.Keys()
	EndIf
EndFunc   ;==>__ArrayUnique

Func _Scanne_array_nach_Variablen(Const ByRef $avArray, $vValue, $iStart = 0, $iEnd = 0, $iCase = 0, $iCompare = 0, $iSubItem = 0)
	$iStart = _ArraySearch($avArray, $vValue, $iStart, $iEnd, $iCase, $iCompare, 1, $iSubItem)
	If @error Then Return SetError(@error, 0, -1)
	Local $Letzer_fortschritt = 0
	Local $String = _Get_langstr(747)
	Local $iIndex = 0, $avResult[UBound($avArray)]
	Do
		$globale_variablen_einlesen_fortschritt = Int(($iStart / (UBound($avArray) - 1)) * 100)
		If $globale_variablen_einlesen_fortschritt <> $Letzer_fortschritt Then _GUICtrlStatusBar_SetText_ISN($Status_bar, StringReplace($String, "%1", $globale_variablen_einlesen_fortschritt))
		$to_add = $avArray[$iStart]
		If StringLeft($to_add, 1) = "$" Then
			$to_add = StringReplace($to_add, "'", "")
			$to_add = StringReplace($to_add, '"', "")
			If $to_add <> "$" Then
				$avResult[$iIndex] = $to_add
				$iIndex += 1
			EndIf
		EndIf
		$iStart = _ArraySearch($avArray, $vValue, $iStart + 1, $iEnd, $iCase, $iCompare, 1, $iSubItem)
		$Letzer_fortschritt = $globale_variablen_einlesen_fortschritt
	Until @error

	ReDim $avResult[$iIndex]
	Return $avResult
EndFunc   ;==>_Scanne_array_nach_Variablen






; #FUNCTION# ;===============================================================================
; Name...........: _Fenstergroessen_zuruecksetzen
; Description ...: Setzt die Fenstergrößen des Projektbaumes usw. auf standard zurück
; Syntax.........: _Fenstergroessen_zuruecksetzen()
; Parameters ....: None
; Return values .: None
; Author ........: ISI360
; Modified.......:
; Remarks .......: Wird aus den Programmeinstellungen aufgerufen
; Related .......:
; Link ..........: https://www.isnetwork.at
; Example .......: No
; ;==========================================================================================

Func _Fenstergroessen_zuruecksetzen()
	IniDelete($configfile, "config", "debugguiX")
	IniDelete($configfile, "config", "debugguiY")
	IniDelete($configfile, "config", "Left_Splitter_Y")
	IniDelete($configfile, "config", "Left_Splitter_X")
	IniDelete($configfile, "config", "Middle_Splitter_Y")
	IniDelete($configfile, "config", "Right_Splitter_X")
	IniDelete($configfile, "config", "Dual_Splitter_Vertical")
	IniDelete($configfile, "config", "Dual_Splitter_Horizontal")
;~ 	if $Toggle_rightside = 0 AND $Offenes_Projekt <> "" then GUICtrlSetPos($Right_Splitter_X, _Config_Read("Right_Splitter_X", $size[2] - 268), 30, $Splitter_Breite, $size[3] - 80)

	$size1 = _WinGetClientSize($Studiofenster, "")
	$size = _WinGetPos($Studiofenster)

	If $Toggle_rightside = 0 And _GUICtrlTab_GetItemCount($htab) > 0 And $Offenes_Projekt <> "" Then
		$ext = StringTrimLeft($Datei_pfad[_GUICtrlTab_GetCurFocus($htab)], StringInStr($Datei_pfad[_GUICtrlTab_GetCurFocus($htab)], ".", 1, -1))
		If $ext = $Autoitextension Then GUICtrlSetPos($Right_Splitter_X, ($size1[0] / 100) * Number(_Config_Read("Right_Splitter_X", $Rechter_Splitter_X_default)), 30, $Splitter_Breite, $size[3] - 80)
	EndIf


	If $hidefunctionstree = "true" Then GUICtrlSetPos($Right_Splitter_X, $size1[0] - 2, 25, $Splitter_Breite, $size1[1] - 80)


	If $Toggle_Leftside = 0 Then GUICtrlSetPos($Left_Splitter_X, ($size1[0] / 100) * Number(_Config_Read("Left_Splitter_X", $Linker_Splitter_X_default)), 30, $Splitter_Breite, $size[3] - 80)



	GUICtrlSetPos($Middle_Splitter_Y, 268, ($size1[1] / 100) * Number(_Config_Read("Left_Splitter_Y", $Mittlerer_Splitter_Y_default)), 200, $Splitter_Breite)
	If $hidedebug = "true" Then GUICtrlSetPos($Middle_Splitter_Y, 268, $size1[1] - 20, 200, 5)
	GUICtrlSetPos($Left_Splitter_Y, 2, ($size1[1] / 100) * Number(_Config_Read("Middle_Splitter_Y", $Linker_Splitter_Y_default)), 200, $Splitter_Breite)
	If $hideprogramlog = "true" Then
		GUICtrlSetPos($Left_Splitter_Y, 2, $size1[1] - 45, 200, 5)
		GUICtrlSetState($Left_Splitter_Y, $GUI_HIDE)
		GUICtrlSetState($QuickView_title, $GUI_HIDE)
		GUISetState(@SW_HIDE, $QuickView_GUI)
	EndIf


	If $Scripteditor_DualEditorView = "vertical" Then
		GUICtrlSetPos($Splitter_DualEditor, ($size1[0] / 100) * Number(_Config_Read("Dual_Splitter_Vertical", $Splitter_DualEditor_DefaultVertical)))
	Else
		GUICtrlSetPos($Splitter_DualEditor, 2, ($size1[1] / 100) * Number(_Config_Read("Dual_Splitter_Horizontal", $Splitter_DualEditor_DefaultHorizontal)))
	EndIf

	;Aktualisiere die Splitter
	_Aktualisiere_Splittercontrols()
	_QuickView_GUI_Resize()
;~ 	msgbox(262144 + 64, _Get_langstr(61), _Get_langstr(750), 0, $StudioFenster) ;Nervt nur ^^
EndFunc   ;==>_Fenstergroessen_zuruecksetzen

; #FUNCTION# ;===============================================================================
; Name...........: _Zeige_AutoIt3Wrapper_GUI
; Description ...: Zeigt die AutoIt3Wrapper GUI in verbindung mit dem aktuellen Skript
; Syntax.........: _Zeige_AutoIt3Wrapper_GUI()
; Parameters ....: None
; Return values .: None
; Author ........: ISI360
; Modified.......:
; Remarks .......: Wird aus dem "Tools" Menü aufgerufen
; Related .......:
; Link ..........: https://www.isnetwork.at
; Example .......: No
; ;==========================================================================================

Func _Zeige_AutoIt3Wrapper_GUI()
	If $Offenes_Projekt = "" Then Return
	If _GUICtrlTab_GetItemCount($htab) = 0 Then Return
	If StringTrimLeft($Datei_pfad[_GUICtrlTab_GetCurFocus($htab)], StringInStr($Datei_pfad[_GUICtrlTab_GetCurFocus($htab)], ".", 0, -1)) <> $Autoitextension Then Return
	_try_to_save_file(_GUICtrlTab_GetCurFocus($htab))
	GUICtrlSetData($warte_auf_wrapper_GUI_text, _Get_langstr(752))
	GUISetState(@SW_SHOW, $warte_auf_wrapper_GUI)
	GUISetState(@SW_DISABLE, $Studiofenster)
	_Clear_Debuglog()
	$data = _RunReadStd('"' & FileGetShortName($autoitexe) & '" "' & FileGetShortName($AutoIt3Wrapper_exe_path) & '" /in "' & $Datei_pfad[_GUICtrlTab_GetCurFocus($htab)] & '" /showgui', 0, $Offenes_Projekt, @SW_SHOW, 1, @TAB, 65001)
	LoadEditorFile($SCE_EDITOR[_GUICtrlTab_GetCurFocus($htab)], $Datei_pfad[_GUICtrlTab_GetCurFocus($htab)])
	$FILE_CACHE[_GUICtrlTab_GetCurFocus($htab)] = Sci_GetLines($SCE_EDITOR[_GUICtrlTab_GetCurFocus($htab)])
	_Check_Buttons(0)
	;_Update_Treeview()
	GUISetState(@SW_ENABLE, $Studiofenster)
	GUISetState(@SW_HIDE, $warte_auf_wrapper_GUI)
EndFunc   ;==>_Zeige_AutoIt3Wrapper_GUI



; #FUNCTION# ;===============================================================================
; Name...........: _Kompilieren_Editormodus
; Description ...: Kompiliert eine au3 Datei im Editormodus mit dem AutoIt3Wrapper
; Syntax.........: _Kompilieren_Editormodus()
; Parameters ....: None
; Return values .: None
; Author ........: ISI360
; Modified.......:
; Remarks .......: Wird im Editormodus verwendet
; Related .......:
; Link ..........: https://www.isnetwork.at
; Example .......: No
; ;==========================================================================================

Func _Kompilieren_Editormodus()
	If _GUICtrlTab_GetItemCount($htab) = 0 Then Return
	If $Plugin_Handle[_GUICtrlTab_GetCurFocus($htab)] <> -1 Then Return
	If $Offenes_Projekt = "" Then Return
	If StringTrimLeft($Datei_pfad[_GUICtrlTab_GetCurFocus($htab)], StringInStr($Datei_pfad[_GUICtrlTab_GetCurFocus($htab)], ".", 0, -1)) <> $Autoitextension Then Return
	GUISetState(@SW_SHOW, $warte_auf_wrapper_GUI)
	GUISetState(@SW_DISABLE, $Studiofenster)
	_Clear_Debuglog()
	$data = _RunReadStd('"' & FileGetShortName($autoitexe) & '" "' & FileGetShortName($AutoIt3Wrapper_exe_path) & '" /in "' & $Datei_pfad[_GUICtrlTab_GetCurFocus($htab)] & '"', 0, $Offenes_Projekt, @SW_SHOW, 1, @TAB, 65001)
	_Update_Treeview()
	GUISetState(@SW_ENABLE, $Studiofenster)
	GUISetState(@SW_HIDE, $warte_auf_wrapper_GUI)
EndFunc   ;==>_Kompilieren_Editormodus

; #FUNCTION# ;===============================================================================
; Name...........: _Ersteinrichtungsassistenten_wiederherstellen
; Description ...: Entfernt den Pfad zur config.ini und lässt ISN so glauben er würde das erste mal gestartet
; Syntax.........: _Ersteinrichtungsassistenten_wiederherstellen()
; Parameters ....: None
; Return values .: None
; Author ........: ISI360
; Modified.......:
; Remarks .......: Kann aus den Programmeinstellungen -> Erweitert ausgeführt werden
; Related .......:
; Link ..........: https://www.isnetwork.at
; Example .......: No
; ;==========================================================================================

Func _Ersteinrichtungsassistenten_wiederherstellen()
	$result = MsgBox(262144 + 48 + 4, _Get_langstr(394), _Get_langstr(789), 0, $Config_GUI)
	If $result = 6 Then
		RegDelete("HKEY_CURRENT_USER\Software\ISN AutoIt Studio", "Configfile")
		FileDelete(@ScriptDir & "\portable.dat")
		MsgBox(262144 + 64, _Get_langstr(61), _Get_langstr(790), 0, $Config_GUI)
		AdlibRegister("_exit", 1)
	EndIf
EndFunc   ;==>_Ersteinrichtungsassistenten_wiederherstellen

; #FUNCTION# ;===============================================================================
; Name...........: _Testprojekt_anlegen
; Description ...: Entpackt den inhalt der testprojekt.zip in den Projekte-Ordner
; Syntax.........: _Testprojekt_anlegen()
; Parameters ....: None
; Return values .: None
; Author ........: ISI360
; Modified.......:
; Remarks .......: Kann aus den Programmeinstellungen -> Erweitert ausgeführt werden
; Related .......:
; Link ..........: https://www.isnetwork.at
; Example .......: No
; ;==========================================================================================

Func _Testprojekt_anlegen()
	$result = MsgBox(262144 + 32 + 4, _Get_langstr(61), _Get_langstr(791), 0, $Config_GUI)
	If $result = 6 Then
		_UnZip_Init("_UnZIP_PrintFunc", "UnZIP_ReplaceFunc", "_UnZIP_PasswordFunc", "_UnZIP_SendAppMsgFunc", "_UnZIP_ServiceFunc")
		_UnZIP_SetOptions()
		$result = _UnZIP_Unzip(@ScriptDir & "\Data\Packages\testprojekt.zip", _ISN_Variablen_aufloesen($Projectfolder))
		_GUICtrlStatusBar_SetText_ISN($Status_bar, "")
		MsgBox(262144 + 64, _Get_langstr(61), _Get_langstr(792), 0, $Config_GUI)
	EndIf
EndFunc   ;==>_Testprojekt_anlegen

Func _Erweitertes_Debugging_aktivieren()
	$Erweitertes_debugging = "true"
	_Write_in_Config("enhanced_debugging", $Erweitertes_debugging)
	_Studiofenster_Refresh_Menu_Checkboxes()
	_Show_Warning("confirmdebugging", 308, _Get_langstr(61), _Get_langstr(803), _Get_langstr(7))
EndFunc   ;==>_Erweitertes_Debugging_aktivieren

Func _Erweitertes_Debugging_deaktivieren()
	$Erweitertes_debugging = "false"
	_Write_in_Config("enhanced_debugging", $Erweitertes_debugging)
	_Studiofenster_Refresh_Menu_Checkboxes()
EndFunc   ;==>_Erweitertes_Debugging_deaktivieren


; #FUNCTION# ;===============================================================================
; Name...........: _Pruefe_ob_Datei_geoeffnet
; Description ...: Entpackt den inhalt der testprojekt.zip in den Projekte-Ordner
; Syntax.........: _Pruefe_ob_Datei_geoeffnet($Pfad)
; Parameters ....: $Pfad	- Pfad zur Datei die geprüft werden soll
; Return values .: true		- Datei ist geöffnet
;                  false	- Datei ist nicht geöffnet
; Author ........: ISI360
; Modified.......:
; Remarks .......:
; Related .......:
; Link ..........: https://www.isnetwork.at
; Example .......: No
; ;==========================================================================================

Func _Pruefe_ob_Datei_geoeffnet($Pfad = "")
	If $Pfad = "" Then Return "false"
	If _ArraySearch($Datei_pfad, $Pfad) > -1 Then Return "true"
	Return "false"
EndFunc   ;==>_Pruefe_ob_Datei_geoeffnet

; #FUNCTION# ========================================================================================================
; Name.............:    _ArraySort_MultiColumn
; Description ...:      sorts an array at given colums (multi colum sort)
; Syntax...........:    _ArraySort_MultiColumn(ByRef $aSort, ByRef $aIndices)
; Parameters ...:       $aSort - array to sort
;                       $aIndices - array with colum indices which should be sorted in specified order - zero based
;                       $dir - sort direction - if set to 1, sort descendingly
; Author .........:     UEZ
; Version ........:     v0.60 build 2011-04-19 Beta
; ===================================================================================================================
Func _ArraySort_MultiColumn(ByRef $aSort, ByRef $aIndices, $oDir = 0, $iDir = 0)
	Local $1st, $2nd
	If Not IsArray($aIndices) Or Not IsArray($aSort) Then Return SetError(1, 0, 0) ;checks if $aIndices is an array
	If UBound($aIndices) > UBound($aSort, 2) Then Return SetError(2, 0, 0) ;check if $aIndices array is greater the $aSort array
	Local $x
	For $x = 0 To UBound($aIndices) - 1 ;check if array content makes sense
		If Not IsInt($aIndices[$x]) Then Return SetError(3, 0, 0) ;array content is not numeric
	Next
	If UBound($aIndices) = 1 Then Return _ArraySort($aSort, $oDir, 0, 0, $aIndices[0]) ;check if only one index is given
	Local $j, $k, $l = 0
	_ArraySort($aSort, $oDir, 0, 0, $aIndices[0])
	Do
		$1st = $aIndices[$l]
		$2nd = $aIndices[$l + 1]
		$j = 0
		$k = 1
		While $k < UBound($aSort)
			If $aSort[$j][$1st] <> $aSort[$k][$1st] Then
				If $k - $j > 1 Then
					_ArraySort($aSort, $iDir, $j, $k - 1, $2nd)
					$j = $k
				Else
					$j = $k
				EndIf
			EndIf
			$k += 1
		WEnd
		If $k - $j > 1 Then _ArraySort($aSort, $oDir, $j, $k, $2nd)
		$l += 1
	Until $l = UBound($aIndices) - 1
	Return 1
EndFunc   ;==>_ArraySort_MultiColumn



Func Codeausschnitt_GUI_Resize()
	$Codeausschnitt_clientsize = _WinGetClientSize($Codeausschnitt_GUI)
	If IsArray($Codeausschnitt_clientsize) Then
		If BitAND(GUICtrlGetState($Codeausschnitt_GUI_titel2), $GUI_SHOW) Then
			WinMove($scintilla_Codeausschnitt, "", 10 * $DPI, 93 * $DPI, $Codeausschnitt_clientsize[0] - ((12 + 10) * $DPI), $Codeausschnitt_clientsize[1] - ((60 + 93) * $DPI))
		Else
			WinMove($scintilla_Codeausschnitt, "", 10 * $DPI, 50 * $DPI, $Codeausschnitt_clientsize[0] - ((12 + 10) * $DPI), $Codeausschnitt_clientsize[1] - ((17 + 93) * $DPI))
		EndIf
	EndIf
EndFunc   ;==>Codeausschnitt_GUI_Resize



Func _AU3_aus_Projektbaum_mit_neuem_Makro_kompilieren()
	$Markierte_Datei_im_Projektbaum = _GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView)
	If $Markierte_Datei_im_Projektbaum = "" Then Return

	;If it´s a favorite, then resolve lnk
	Local $FavoritesPath = _ISN_Variablen_aufloesen($FavoritesSubfolder)
	If StringRight($Markierte_Datei_im_Projektbaum, 4) = ".lnk" And StringInStr($Markierte_Datei_im_Projektbaum, $FavoritesPath) Then
		$Markierte_Datei_im_Projektbaum = _ISN_Variablen_aufloesen(_ISN_Favorites_ShortGetCommentPath($Markierte_Datei_im_Projektbaum))
	EndIf

	$Macro_FuncToCallAfterNewMacroIsCreated = "_AU3_aus_Projektbaum_mit_neuem_Makro_kompilieren_Part2"

	_Show_Ruleeditor()
	_ISN_Macros_ShowNewMacroGUI()
EndFunc   ;==>_AU3_aus_Projektbaum_mit_neuem_Makro_kompilieren

Func _AU3_aus_Projektbaum_mit_neuem_Makro_kompilieren_Part2()
	$Markierte_Datei_im_Projektbaum = _GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView)
	If $Markierte_Datei_im_Projektbaum = "" Then Return

	;If it´s a favorite, then resolve lnk
	Local $FavoritesPath = _ISN_Variablen_aufloesen($FavoritesSubfolder)
	If StringRight($Markierte_Datei_im_Projektbaum, 4) = ".lnk" And StringInStr($Markierte_Datei_im_Projektbaum, $FavoritesPath) Then
		$Markierte_Datei_im_Projektbaum = _ISN_Variablen_aufloesen(_ISN_Favorites_ShortGetCommentPath($Markierte_Datei_im_Projektbaum))
	EndIf

	_Add_action_to_list($Key_Action6)
	Dim $szDrive, $szDir, $szFName, $szExt
	$path = _PathSplit($Markierte_Datei_im_Projektbaum, $szDrive, $szDir, $szFName, $szExt)
	GUICtrlSetData($rule_compile_exename, $szFName & ".exe")

	$Markierte_Datei_im_Projektbaum = _ISN_Pfad_durch_Variablen_ersetzen($Markierte_Datei_im_Projektbaum)
	GUICtrlSetData($compile_rule_inputfile, $Markierte_Datei_im_Projektbaum)
EndFunc   ;==>_AU3_aus_Projektbaum_mit_neuem_Makro_kompilieren_Part2

Func _GUICtrlListView_CopyAllItems($hWnd_Source, $hWnd_Destination, $bDelFlag = False)
	Local $a_Indices, $tItem = DllStructCreate($tagLVITEM), $iIndex
	Local $iCols = _GUICtrlListView_GetColumnCount($hWnd_Source)

	Local $iItems = _GUICtrlListView_GetItemCount($hWnd_Source)
	_GUICtrlListView_BeginUpdate($hWnd_Source)
	_GUICtrlListView_BeginUpdate($hWnd_Destination)
	_GUICtrlListView_DeleteAllItems($hWnd_Destination)
	If BitAND(_GUICtrlListView_GetExtendedListViewStyle($hWnd_Source), $LVS_EX_CHECKBOXES) == $LVS_EX_CHECKBOXES Then
		For $i = 0 To $iItems - 1
			If (_GUICtrlListView_GetItemChecked($hWnd_Source, $i)) Then
				If IsArray($a_Indices) Then
					ReDim $a_Indices[UBound($a_Indices) + 1]
				Else
					Local $a_Indices[2]
				EndIf
				$a_Indices[0] = $a_Indices[0] + 1
				$a_Indices[UBound($a_Indices) - 1] = $i
			EndIf
		Next

		If (IsArray($a_Indices)) Then
			For $i = 1 To $a_Indices[0]
				DllStructSetData($tItem, "Mask", BitOR($LVIF_GROUPID, $LVIF_IMAGE, $LVIF_INDENT, $LVIF_PARAM, $LVIF_STATE))
				DllStructSetData($tItem, "Item", $a_Indices[$i])
				DllStructSetData($tItem, "SubItem", 0)
				DllStructSetData($tItem, "StateMask", -1)
				_GUICtrlListView_GetItemEx($hWnd_Source, $tItem)
				$iIndex = _GUICtrlListView_AddItem($hWnd_Destination, _GUICtrlListView_GetItemText($hWnd_Source, $a_Indices[$i], 0), DllStructGetData($tItem, "Image"))
				_GUICtrlListView_SetItemChecked($hWnd_Destination, $iIndex)
				For $x = 1 To $iCols - 1
					DllStructSetData($tItem, "Item", $a_Indices[$i])
					DllStructSetData($tItem, "SubItem", $x)
					_GUICtrlListView_GetItemEx($hWnd_Source, $tItem)
					_GUICtrlListView_AddSubItem($hWnd_Destination, $iIndex, _GUICtrlListView_GetItemText($hWnd_Source, $a_Indices[$i], $x), $x, DllStructGetData($tItem, "Image"))
				Next
				;_GUICtrlListView_SetItemChecked($hWnd_Source, $a_Indices[$i], False)
			Next
			If $bDelFlag Then
				For $i = $a_Indices[0] To 1 Step -1
					_GUICtrlListView_DeleteItem($hWnd_Source, $a_Indices[$i])
				Next
			EndIf
		EndIf
	EndIf

	$a_Indices = _GUICtrlListView_GetSelectedIndices($hWnd_Source, 1)
	For $i = 1 To _GUICtrlListView_GetItemCount($hWnd_Source)
		DllStructSetData($tItem, "Mask", BitOR($LVIF_GROUPID, $LVIF_IMAGE, $LVIF_INDENT, $LVIF_PARAM, $LVIF_STATE))
		DllStructSetData($tItem, "Item", $i - 1)
		DllStructSetData($tItem, "SubItem", 0)
		DllStructSetData($tItem, "StateMask", -1)
		_GUICtrlListView_GetItemEx($hWnd_Source, $tItem)
		$iIndex = _GUICtrlListView_AddItem($hWnd_Destination, _GUICtrlListView_GetItemText($hWnd_Source, $i - 1, 0), DllStructGetData($tItem, "Image"))
		For $x = 1 To $iCols - 1
			DllStructSetData($tItem, "Item", $i - 1)
			DllStructSetData($tItem, "SubItem", $x)
			_GUICtrlListView_GetItemEx($hWnd_Source, $tItem)
			_GUICtrlListView_AddSubItem($hWnd_Destination, $iIndex, _GUICtrlListView_GetItemText($hWnd_Source, $i - 1, $x), $x, DllStructGetData($tItem, "Image"))
		Next
	Next
	_GUICtrlListView_SetItemSelected($hWnd_Source, -1, False)
	If $bDelFlag Then
		For $i = $a_Indices[0] To 1 Step -1
			_GUICtrlListView_DeleteItem($hWnd_Source, $a_Indices[$i])
		Next
	EndIf

	_GUICtrlListView_EndUpdate($hWnd_Source)
	_GUICtrlListView_EndUpdate($hWnd_Destination)
EndFunc   ;==>_GUICtrlListView_CopyAllItems

Func _AU3_aus_Projektbaum_mit_vorhandenen_Makro_kompilieren()
	$Markierte_Datei_im_Projektbaum = _GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView)
	If $Markierte_Datei_im_Projektbaum = "" Then Return
	_Build_Rulelist()
	GUISetState(@SW_SHOW, $Makro_auswaehlen_GUI)
	GUISetState(@SW_DISABLE, $Studiofenster)
EndFunc   ;==>_AU3_aus_Projektbaum_mit_vorhandenen_Makro_kompilieren

Func _AU3_mit_vorhandenen_Makro_kompilieren_Makro_auswaehlen()
	If _GUICtrlListView_GetSelectionMark($makro_auswaehlen_listview) = -1 Then Return
	If _GUICtrlListView_GetItemCount($makro_auswaehlen_listview) = 0 Then Return
	GUISetState(@SW_ENABLE, $Studiofenster)
	GUISetState(@SW_HIDE, $Makro_auswaehlen_GUI)
	$Markierte_Datei_im_Projektbaum = _GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView)
	If $Markierte_Datei_im_Projektbaum = "" Then Return

	;If it´s a favorite, then resolve lnk
	Local $FavoritesPath = _ISN_Variablen_aufloesen($FavoritesSubfolder)
	If StringRight($Markierte_Datei_im_Projektbaum, 4) = ".lnk" And StringInStr($Markierte_Datei_im_Projektbaum, $FavoritesPath) Then
		$Markierte_Datei_im_Projektbaum = _ISN_Variablen_aufloesen(_ISN_Favorites_ShortGetCommentPath($Markierte_Datei_im_Projektbaum))
	EndIf

	Local $RuleID = _GUICtrlListView_GetItemText($makro_auswaehlen_listview, _GUICtrlListView_GetSelectionMark($makro_auswaehlen_listview), 3)
	Local $RuleType = _GUICtrlListView_GetItemText($makro_auswaehlen_listview, _GUICtrlListView_GetSelectionMark($makro_auswaehlen_listview), 4)
	_Show_new_rule_form($RuleID, $RuleType)
	_Add_action_to_list($Key_Action6)
	Dim $szDrive, $szDir, $szFName, $szExt
	$path = _PathSplit($Markierte_Datei_im_Projektbaum, $szDrive, $szDir, $szFName, $szExt)
	GUICtrlSetData($rule_compile_exename, $szFName & ".exe")

	$Markierte_Datei_im_Projektbaum = _ISN_Pfad_durch_Variablen_ersetzen($Markierte_Datei_im_Projektbaum)
	GUICtrlSetData($compile_rule_inputfile, $Markierte_Datei_im_Projektbaum)
EndFunc   ;==>_AU3_mit_vorhandenen_Makro_kompilieren_Makro_auswaehlen

Func _Hide_AU3_aus_Projektbaum_mit_vorhandenen_Makro_kompilieren()
	GUISetState(@SW_ENABLE, $Studiofenster)
	GUISetState(@SW_HIDE, $Makro_auswaehlen_GUI)
EndFunc   ;==>_Hide_AU3_aus_Projektbaum_mit_vorhandenen_Makro_kompilieren

Func _AU3_aus_Projektbaum_Direkt_Kompilieren($Markierte_Datei_im_Projektbaum = "", $Silent = 0)
	If $Markierte_Datei_im_Projektbaum = "" Then
		$Markierte_Datei_im_Projektbaum = _GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView)
	EndIf
	If $Markierte_Datei_im_Projektbaum = "" Then Return

	If Not FileExists($AutoIt3Wrapper_exe_path) Then
		If _Check_ISN_Error_Behavior(_Get_langstr(1032)) = 0 Then MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1032), 0, $Studiofenster)
		Return
	EndIf

	_STOPSCRIPT() ;Wenn noch ein Skript läuft -> Stoppen!


	;If it´s a favorite, then resolve lnk
	Local $FavoritesPath = _ISN_Variablen_aufloesen($FavoritesSubfolder)
	If StringRight($Markierte_Datei_im_Projektbaum, 4) = ".lnk" And StringInStr($Markierte_Datei_im_Projektbaum, $FavoritesPath) Then
		$Markierte_Datei_im_Projektbaum = _ISN_Variablen_aufloesen(_ISN_Favorites_ShortGetCommentPath($Markierte_Datei_im_Projektbaum))
	EndIf

	If $Silent = 0 Then
		GUISetState(@SW_SHOW, $compilingRule)
		GUISetState(@SW_DISABLE, $Studiofenster)
	EndIf

	;Prüfe ob datei geöffnet ist und speichere diese vor dem Kompilieren
	$res = _ArraySearch($Datei_pfad, $Markierte_Datei_im_Projektbaum)
	If $res <> -1 Then
		_try_to_save_file($res)
	EndIf



	;Dateiinhalt vor dem Kompilieren einlesen (sichern)
	Local $hFile = FileOpen($Markierte_Datei_im_Projektbaum, $FO_READ + FileGetEncoding($Markierte_Datei_im_Projektbaum))
	Local $Dateiinhalt_vor_dem_Kompilieren = FileRead($hFile, FileGetSize($Markierte_Datei_im_Projektbaum))
	FileClose($hFile)
	If Not _System_benoetigt_double_byte_character_Support() Then $Dateiinhalt_vor_dem_Kompilieren = _ANSI2UNICODE($Dateiinhalt_vor_dem_Kompilieren)


	$source = $Markierte_Datei_im_Projektbaum

	$target = StringReplace($Markierte_Datei_im_Projektbaum, "." & $Autoitextension, ".exe")

	_Clear_Debuglog()
	;$Console_Bluemode = 1
	$fertiger_zielpfad = $target
	$Pfadaenderung_durch_Wrapper = _Kompilieren_Datei_Analysieren_und_Zielpfade_herausfinden($source)
	If $Pfadaenderung_durch_Wrapper <> "" Then $fertiger_zielpfad = $Pfadaenderung_durch_Wrapper

	GUICtrlSetData($rulecompile_label1, _Get_langstr(602) & " " & $source)
	GUICtrlSetData($rulecompile_label2, _Get_langstr(583) & " " & $fertiger_zielpfad)

	$Zuletzt_Kompilierte_Datei_Pfad_au3 = $source ;Dateipfad der zuletzt kompilierten Datei (.au3 Datei)

	Local $CompileWorkingDir = StringTrimRight ($source, stringlen($source) - StringInStr($source, "\", 0, -1) + 1)	

	_run_rule($Section_Trigger_BeforeFileCompile) ;Makro "vor Datei kompilieren"
	$data = _RunReadStd('"' & FileGetShortName($autoitexe) & '" "' & FileGetShortName($AutoIt3Wrapper_exe_path) & '" /in "' & $source & '"', 0, $CompileWorkingDir, @SW_HIDE, 1, @TAB, 65001)
	$Zuletzt_Kompilierte_Datei_Pfad_exe = $fertiger_zielpfad ;Dateipfad der zuletzt kompilierten Datei (.exe Datei)
	Dim $szDrive, $szDir, $szFName, $szExt
	$path = _PathSplit($source, $szDrive, $szDir, $szFName, $szExt)
	If FileExists($szDrive & $szDir & $szFName & "_Obfuscated" & $szExt) Then FileDelete(FileGetShortName($szDrive & $szDir & $szFName) & "_Obfuscated" & $szExt)
	If FileExists($szDrive & $szDir & _GetShortName($szFName) & "_Obfuscated" & $szExt) Then FileDelete($szDrive & $szDir & _GetShortName($szFName) & "_Obfuscated" & $szExt)
	If FileExists($szDrive & $szDir & $szFName & ".tbl") Then FileDelete(FileGetShortName($szDrive & $szDir & $szFName) & ".tbl")
	If FileExists($szDrive & $szDir & _GetShortName($szFName) & ".tbl") Then FileDelete($szDrive & $szDir & _GetShortName($szFName) & ".tbl")


	;Exit Codes Analysieren und ggf. Änderungen vornehmen
	If IsArray($data) Then
		If $data[1] <> 0 Then

			Switch _Check_ISN_Error_Behavior(StringReplace(_Get_langstr(1138), "%1", $szFName & $szExt))
				Case 0
					$result = MsgBox(262196, _Get_langstr(394), StringReplace(_Get_langstr(1138), "%1", $szFName & $szExt) & @CRLF & @CRLF & _Get_langstr(1139), 0, $compilingRule)
					If $result = 7 Then
						$Kompilieren_laeuft = 0 ;Stoppe weitere ausführung
						GUISetState(@SW_ENABLE, $Studiofenster)
						GUISetState(@SW_HIDE, $compilingRule)
						Return
					EndIf

				Case 1, 2
					$Kompilieren_laeuft = 0 ;Stoppe weitere ausführung
					GUISetState(@SW_ENABLE, $Studiofenster)
					GUISetState(@SW_HIDE, $compilingRule)
					Return

			EndSwitch
		EndIf
	EndIf

	_run_rule($Section_Trigger_AfterFileCompile) ;Makro "Nach Datei kompilieren"


	If _Pruefe_ob_Datei_geoeffnet($source) = "true" Then ;Lese Datei neu ein (falls geöffnet)
		;Dateiinhalt nach dem Kompilieren einlesen, und falls sich etwas verändert hat -> Datei neu einlesen
		Local $hFile = FileOpen($source, $FO_READ + FileGetEncoding($source))
		Local $Dateiinhalt_nach_dem_Kompilieren = FileRead($hFile, FileGetSize($source))
		FileClose($hFile)
		If Not _System_benoetigt_double_byte_character_Support() Then $Dateiinhalt_nach_dem_Kompilieren = _ANSI2UNICODE($Dateiinhalt_nach_dem_Kompilieren)

		If $Dateiinhalt_nach_dem_Kompilieren <> $Dateiinhalt_vor_dem_Kompilieren Then
			$tabpage = _GUICtrlTab_FindTab($htab, StringTrimLeft($source, StringInStr($source, "\", 0, -1)))
			$old_cur_pos = Sci_GetCurrentPos($SCE_EDITOR[$tabpage])
			LoadEditorFile($SCE_EDITOR[$tabpage], $source)
			$FILE_CACHE[$tabpage] = Sci_GetLines($SCE_EDITOR[$tabpage])
			_Editor_Restore_Fold()
			Sci_SetCurrentPos($SCE_EDITOR[$tabpage], $old_cur_pos)
		EndIf
	EndIf

	If $Silent = 0 Then
		;_Update_Treeview() ;Zum Abschluss noch den Projektbaum aktualisieren
		GUISetState(@SW_ENABLE, $Studiofenster)
		GUISetState(@SW_HIDE, $compilingRule)
	EndIf
EndFunc   ;==>_AU3_aus_Projektbaum_Direkt_Kompilieren


Func _Erstelle_Kontextmenu_fuer_Projektbaum()

	;Projektbaum Kontextmenü
	GUISwitch($Studiofenster)
	GUICtrlDelete($TreeviewContextMenu)
	Global $TreeviewContextMenu_dummy = GUICtrlCreateDummy()
	Global $TreeviewContextMenu = GUICtrlCreateContextMenu($TreeviewContextMenu_dummy)

	Global $TreeviewContextMenu_Item1 = _GUICtrlCreateODMenuItem(_Get_langstr(65) & @TAB & "Enter", $TreeviewContextMenu, $smallIconsdll, 1287) ;open



	Global $TreeviewContextMenu_Item8 = _GUICtrlCreateODMenu(_Get_langstr(70), $TreeviewContextMenu, $smallIconsdll, 1283) ;neu
	Global $TreeviewContextMenu_Item8_a = _GUICtrlCreateODMenuItem(_Get_langstr(154), $TreeviewContextMenu_Item8, $smallIconsdll, 1788, 1) ;au3 file
	Global $TreeviewContextMenu_temp_au3_file = _GUICtrlCreateODMenuItem(_Get_langstr(1094) & @TAB & _Keycode_zu_Text($Hotkey_Keycode_Create_Temp_Au3_Script), $TreeviewContextMenu_Item8, $smallIconsdll, 1788, 1) ;temp au3 file
	Global $TreeviewContextMenu_NewFile_Au3UDF = _GUICtrlCreateODMenuItem(_Get_langstr(1452), $TreeviewContextMenu_Item8, $smallIconsdll, 1788, 1) ;au3 udf file
	Global $TreeviewContextMenu_Item8_b = _GUICtrlCreateODMenuItem(_Get_langstr(153), $TreeviewContextMenu_Item8, $smallIconsdll, 781, 1) ;isf file
	Global $TreeviewContextMenu_Item8_c = _GUICtrlCreateODMenuItem(_Get_langstr(155), $TreeviewContextMenu_Item8, $smallIconsdll, 1177, 1) ;ini file
	Global $TreeviewContextMenu_Item8_d = _GUICtrlCreateODMenuItem(_Get_langstr(156), $TreeviewContextMenu_Item8, $smallIconsdll, 1178, 1) ;txt file
	Global $TreeviewContextMenu_Item8_Item2 = _GUICtrlCreateODMenuItem(_Get_langstr(71) & @TAB & _Keycode_zu_Text($Hotkey_Keycode_Create_New_Folder), $TreeviewContextMenu, $smallIconsdll, 1344, 1) ;folder
	Global $TreeviewContextMenu_Item8_NewShortcut = _GUICtrlCreateODMenuItem(_Get_langstr(1560) & @TAB & _Keycode_zu_Text($Hotkey_Keycode_Create_New_Shortcut), $TreeviewContextMenu, $smallIconsdll, 144, 1) ;New shortcut


	_GUICtrlCreateODMenuItem("", $TreeviewContextMenu)
	Global $TreeviewContextMenu_Oeffnen_Mit = _GUICtrlCreateODMenu(_Get_langstr(1107), $TreeviewContextMenu, $smallIconsdll, 1287) ;Öffnen mit
	Global $TreeviewContextMenu_Oeffnen_Mit_Script_Editor = _GUICtrlCreateODMenuItem(_Get_langstr(196), $TreeviewContextMenu_Oeffnen_Mit, $smallIconsdll, 1786) ;Öffnen mit Scintilla
	Global $TreeviewContextMenu_Oeffnen_Mit_Windows = _GUICtrlCreateODMenuItem(_Get_langstr(1108), $TreeviewContextMenu_Oeffnen_Mit, $smallIconsdll, 193) ;An Windows übergeben
	_GUICtrlCreateODMenuItem("", $TreeviewContextMenu_Oeffnen_Mit)
	Global $TreeviewContextMenu_DisplayOpenWithDialog = _GUICtrlCreateODMenuItem(_Get_langstr(1410), $TreeviewContextMenu_Oeffnen_Mit, $smallIconsdll, 273) ;Display open with...

	Global $TreeviewContextMenu_Item_Projektbaum_aktualisieren = _GUICtrlCreateODMenuItem(_Get_langstr(1414), $TreeviewContextMenu, $smallIconsdll, 998) ;Projektbaum aktualisieren
	Global $TreeviewContextMenu_CutFileToClipboard = _GUICtrlCreateODMenuItem(_Get_langstr(110) & @TAB & "Ctrl+X", $TreeviewContextMenu, $smallIconsdll, 1129) ;Cut2Clipboard
	Global $TreeviewContextMenu_CopyFileToClipboard = _GUICtrlCreateODMenuItem(_Get_langstr(111) & @TAB & "Ctrl+C", $TreeviewContextMenu, $smallIconsdll, 1088) ;Copy File2Clipboard


	Global $TreeviewContextMenu_Item10 = _GUICtrlCreateODMenuItem(_Get_langstr(371), $TreeviewContextMenu, $smallIconsdll, 512) ;kopie erstellen
	Global $TreeviewContextMenu_PasteFileFromClipboard = _GUICtrlCreateODMenuItem(_Get_langstr(112) & @TAB & "Ctrl+V", $TreeviewContextMenu, $smallIconsdll, 9) ;Paste From Clipboard
	Global $TreeviewContextMenu_Item3 = _GUICtrlCreateODMenuItem(_Get_langstr(67) & @TAB & "Del", $TreeviewContextMenu, $smallIconsdll, 1174) ;delete
	Global $TreeviewContextMenu_Item2 = _GUICtrlCreateODMenuItem(_Get_langstr(66) & @TAB & "F2", $TreeviewContextMenu, $smallIconsdll, 824) ;Rename
	Global $TreeviewContextMenu_Item4 = _GUICtrlCreateODMenuItem(_Get_langstr(121), $TreeviewContextMenu, $smallIconsdll, 1090) ;move
	Global $TreeviewContextMenu_Item9 = _GUICtrlCreateODMenuItem(_Get_langstr(398), $TreeviewContextMenu, $smallIconsdll, 1265) ;showinexplorer
	Global $TreeviewContextMenu_Item5 = _GUICtrlCreateODMenuItem(_Get_langstr(68), $TreeviewContextMenu, $smallIconsdll, 11) ;eigenschaften


	_GUICtrlCreateODMenuItem("", $TreeviewContextMenu)

	Global $TreeviewContextMenu_Item_Kompilieren = _GUICtrlCreateODMenu(_Get_langstr(235), $TreeviewContextMenu, $smallIconsdll, 1786) ;Kompilieren
	Global $TreeviewContextMenu_Item_Jetzt_Kompilieren = _GUICtrlCreateODMenuItem(_Get_langstr(1050), $TreeviewContextMenu_Item_Kompilieren, $smallIconsdll, 1786) ;Jetzt kompilieren
	_GUICtrlCreateODMenuItem("", $TreeviewContextMenu_Item_Kompilieren)
	Global $TreeviewContextMenu_Item_Makro_kompilieren_neu = _GUICtrlCreateODMenuItem(_Get_langstr(1051), $TreeviewContextMenu_Item_Kompilieren, $smallIconsdll, 338) ;Makro kompilieren (neu)
	Global $TreeviewContextMenu_Item_Makro_kompilieren_bestehend = _GUICtrlCreateODMenuItem(_Get_langstr(1052), $TreeviewContextMenu_Item_Kompilieren, $smallIconsdll, 338) ;Makro kompilieren (bestehend)
	_GUICtrlCreateODMenuItem("", $TreeviewContextMenu)
	Global $TreeviewContextMenu_CopyFilePathtoClipboard = _GUICtrlCreateODMenuItem(_Get_langstr(1415), $TreeviewContextMenu, $smallIconsdll, 415) ;CopyFilePathtoClipboard
	Global $TreeviewContextMenu_NewPowerShellWindow = _GUICtrlCreateODMenuItem(_Get_langstr(1499), $TreeviewContextMenu, $smallIconsdll, 1943 + 1) ;New PowerShell window
	Global $TreeviewContextMenu_NewCMDWindow = _GUICtrlCreateODMenuItem(_Get_langstr(1498), $TreeviewContextMenu, $smallIconsdll, 1942 + 1) ;New CMD window

	If $ShowFavoritesInProjecttree = "true" Then
		Global $TreeviewContextMenu_AddToFavorites = _GUICtrlCreateODMenuItem(_Get_langstr(1516), $TreeviewContextMenu, $smallIconsdll, 1127 + 1) ;add to favorites
	Else
		Global $TreeviewContextMenu_AddToFavorites = ""
	EndIf

	_GUICtrlCreateODMenuItem("", $TreeviewContextMenu)
	Global $TreeviewContextMenu_ImportExportMain = _GUICtrlCreateODMenu(_Get_langstr(1413), $TreeviewContextMenu, $smallIconsdll, 1936) ;import/export
	Global $TreeviewContextMenu_Item6 = _GUICtrlCreateODMenuItem(_Get_langstr(72), $TreeviewContextMenu_ImportExportMain, $smallIconsdll, 378) ;import
	Global $TreeviewContextMenu_Item6a = _GUICtrlCreateODMenuItem(_Get_langstr(455), $TreeviewContextMenu_ImportExportMain, $smallIconsdll, 1090) ;importfolder
	_GUICtrlCreateODMenuItem("", $TreeviewContextMenu_ImportExportMain)
	Global $TreeviewContextMenu_Item7 = _GUICtrlCreateODMenuItem(_Get_langstr(73), $TreeviewContextMenu_ImportExportMain, $smallIconsdll, 416) ;export

	If $Tools_PELock_Obfuscator_aktiviert = "true" Then
		Global $TreeviewContextMenu_Item_PELock_Obfuscator = _GUICtrlCreateODMenuItem(_Get_langstr(1214), $TreeviewContextMenu, $smallIconsdll, 1926) ;PELock Obfuscator
	Else
		Global $TreeviewContextMenu_Item_PELock_Obfuscator = "" ;PELock Obfuscator
	EndIf



	Local $LineNeeded = -1
	$TreeviewContextMenu_makroslot1 = ""
	$TreeviewContextMenu_makroslot2 = ""
	$TreeviewContextMenu_makroslot3 = ""
	$TreeviewContextMenu_makroslot4 = ""
	$TreeviewContextMenu_makroslot5 = ""
	$TreeviewContextMenu_makroslot6 = ""
	$TreeviewContextMenu_makroslot7 = ""
	$TreeviewContextMenu_makroslot8 = ""
	$TreeviewContextMenu_makroslot9 = ""
	$TreeviewContextMenu_makroslot10 = ""
	If $Offenes_Projekt <> "" Then



		;macroslot1
		If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_MacroSlot1, False), 4) And UBound($Macroslot_InfoArray) = 10 Then
			If String($Macroslot_InfoArray[0][3]) = "1" Then ;Show in context must be active
				$name = _GUICtrlMenu_GetItemText($StudioFenster_MenuHandle, $ISN_ToolsMenu_MacroSlot1, False)
				$readen_icon = $Macroslot_InfoArray[0][2]
				$readen_icon = Number($readen_icon)
				If $readen_icon = 0 Then $readen_icon = $readen_icon - 1
				If $LineNeeded = -1 Then $LineNeeded = _GUICtrlCreateODMenuItem("", $TreeviewContextMenu)
				$TreeviewContextMenu_makroslot1 = _GUICtrlCreateODMenuItem($name & @TAB & _Keycode_zu_Text($Hotkey_Keycode_Makroslot1), $TreeviewContextMenu, $smallIconsdll, $readen_icon + 1)
			EndIf
		EndIf


		;macroslot2
		If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_MacroSlot2, False), 4) And UBound($Macroslot_InfoArray) = 10 Then
			If String($Macroslot_InfoArray[1][3]) = "1" Then ;Show in context must be active
				$name = _GUICtrlMenu_GetItemText($StudioFenster_MenuHandle, $ISN_ToolsMenu_MacroSlot2, False)
				$readen_icon = $Macroslot_InfoArray[1][2]
				$readen_icon = Number($readen_icon)
				If $readen_icon = 0 Then $readen_icon = $readen_icon - 1
				If $LineNeeded = -1 Then $LineNeeded = _GUICtrlCreateODMenuItem("", $TreeviewContextMenu)
				$TreeviewContextMenu_makroslot2 = _GUICtrlCreateODMenuItem($name & @TAB & _Keycode_zu_Text($Hotkey_Keycode_Makroslot2), $TreeviewContextMenu, $smallIconsdll, $readen_icon + 1)
			EndIf
		EndIf

		;macroslot3
		If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_MacroSlot3, False), 4) And UBound($Macroslot_InfoArray) = 10 Then
			If String($Macroslot_InfoArray[2][3]) = "1" Then ;Show in context must be active
				$name = _GUICtrlMenu_GetItemText($StudioFenster_MenuHandle, $ISN_ToolsMenu_MacroSlot3, False)
				$readen_icon = $Macroslot_InfoArray[2][2]
				$readen_icon = Number($readen_icon)
				If $readen_icon = 0 Then $readen_icon = $readen_icon - 1
				If $LineNeeded = -1 Then $LineNeeded = _GUICtrlCreateODMenuItem("", $TreeviewContextMenu)
				$TreeviewContextMenu_makroslot3 = _GUICtrlCreateODMenuItem($name & @TAB & _Keycode_zu_Text($Hotkey_Keycode_Makroslot3), $TreeviewContextMenu, $smallIconsdll, $readen_icon + 1)
			EndIf
		EndIf

		;macroslot4
		If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_MacroSlot4, False), 4) And UBound($Macroslot_InfoArray) = 10 Then
			If String($Macroslot_InfoArray[3][3]) = "1" Then ;Show in context must be active
				$name = _GUICtrlMenu_GetItemText($StudioFenster_MenuHandle, $ISN_ToolsMenu_MacroSlot4, False)
				$readen_icon = $Macroslot_InfoArray[3][2]
				$readen_icon = Number($readen_icon)
				If $readen_icon = 0 Then $readen_icon = $readen_icon - 1
				If $LineNeeded = -1 Then $LineNeeded = _GUICtrlCreateODMenuItem("", $TreeviewContextMenu)
				$TreeviewContextMenu_makroslot4 = _GUICtrlCreateODMenuItem($name & @TAB & _Keycode_zu_Text($Hotkey_Keycode_Makroslot4), $TreeviewContextMenu, $smallIconsdll, $readen_icon + 1)
			EndIf
		EndIf

		;macroslot5
		If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_MacroSlot5, False), 4) And UBound($Macroslot_InfoArray) = 10 Then
			If String($Macroslot_InfoArray[4][3]) = "1" Then ;Show in context must be active
				$name = _GUICtrlMenu_GetItemText($StudioFenster_MenuHandle, $ISN_ToolsMenu_MacroSlot5, False)
				$readen_icon = $Macroslot_InfoArray[4][2]
				$readen_icon = Number($readen_icon)
				If $readen_icon = 0 Then $readen_icon = $readen_icon - 1
				If $LineNeeded = -1 Then $LineNeeded = _GUICtrlCreateODMenuItem("", $TreeviewContextMenu)
				$TreeviewContextMenu_makroslot5 = _GUICtrlCreateODMenuItem($name & @TAB & _Keycode_zu_Text($Hotkey_Keycode_Makroslot5), $TreeviewContextMenu, $smallIconsdll, $readen_icon + 1)
			EndIf
		EndIf

		;macroslot6
		If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_MacroSlot6, False), 4) And UBound($Macroslot_InfoArray) = 10 Then
			If String($Macroslot_InfoArray[5][3]) = "1" Then ;Show in context must be active
				$name = _GUICtrlMenu_GetItemText($StudioFenster_MenuHandle, $ISN_ToolsMenu_MacroSlot6, False)
				$readen_icon = $Macroslot_InfoArray[5][2]
				$readen_icon = Number($readen_icon)
				If $readen_icon = 0 Then $readen_icon = $readen_icon - 1
				If $LineNeeded = -1 Then $LineNeeded = _GUICtrlCreateODMenuItem("", $TreeviewContextMenu)
				$TreeviewContextMenu_makroslot6 = _GUICtrlCreateODMenuItem($name & @TAB & _Keycode_zu_Text($Hotkey_Keycode_Makroslot6), $TreeviewContextMenu, $smallIconsdll, $readen_icon + 1)
			EndIf
		EndIf

		;macroslot7
		If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_MacroSlot7, False), 4) And UBound($Macroslot_InfoArray) = 10 Then
			If String($Macroslot_InfoArray[6][3]) = "1" Then ;Show in context must be active
				$name = _GUICtrlMenu_GetItemText($StudioFenster_MenuHandle, $ISN_ToolsMenu_MacroSlot7, False)
				$readen_icon = $Macroslot_InfoArray[6][2]
				$readen_icon = Number($readen_icon)
				If $readen_icon = 0 Then $readen_icon = $readen_icon - 1
				If $LineNeeded = -1 Then $LineNeeded = _GUICtrlCreateODMenuItem("", $TreeviewContextMenu)
				$TreeviewContextMenu_makroslot7 = _GUICtrlCreateODMenuItem($name & @TAB & _Keycode_zu_Text($Hotkey_Keycode_Makroslot7), $TreeviewContextMenu, $smallIconsdll, $readen_icon + 1)
			EndIf
		EndIf

		;macroslot8
		If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_MacroSlot8, False), 4) And UBound($Macroslot_InfoArray) = 10 Then
			If String($Macroslot_InfoArray[7][3]) = "1" Then ;Show in context must be active
				$name = _GUICtrlMenu_GetItemText($StudioFenster_MenuHandle, $ISN_ToolsMenu_MacroSlot8, False)
				$readen_icon = $Macroslot_InfoArray[7][2]
				$readen_icon = Number($readen_icon)
				If $readen_icon = 0 Then $readen_icon = $readen_icon - 1
				If $LineNeeded = -1 Then $LineNeeded = _GUICtrlCreateODMenuItem("", $TreeviewContextMenu)
				$TreeviewContextMenu_makroslot8 = _GUICtrlCreateODMenuItem($name & @TAB & _Keycode_zu_Text($Hotkey_Keycode_Makroslot8), $TreeviewContextMenu, $smallIconsdll, $readen_icon + 1)
			EndIf
		EndIf

		;macroslot9
		If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_MacroSlot9, False), 4) And UBound($Macroslot_InfoArray) = 10 Then
			If String($Macroslot_InfoArray[8][3]) = "1" Then ;Show in context must be active
				$name = _GUICtrlMenu_GetItemText($StudioFenster_MenuHandle, $ISN_ToolsMenu_MacroSlot9, False)
				$readen_icon = $Macroslot_InfoArray[8][2]
				$readen_icon = Number($readen_icon)
				If $readen_icon = 0 Then $readen_icon = $readen_icon - 1
				If $LineNeeded = -1 Then $LineNeeded = _GUICtrlCreateODMenuItem("", $TreeviewContextMenu)
				$TreeviewContextMenu_makroslot9 = _GUICtrlCreateODMenuItem($name & @TAB & _Keycode_zu_Text($Hotkey_Keycode_Makroslot9), $TreeviewContextMenu, $smallIconsdll, $readen_icon + 1)
			EndIf
		EndIf

		;macroslot10
		If Not BitAND(_GUICtrlMenu_GetItemState($StudioFenster_MenuHandle, $ISN_ToolsMenu_MacroSlot10, False), 4) And UBound($Macroslot_InfoArray) = 10 Then
			If String($Macroslot_InfoArray[9][3]) = "1" Then ;Show in context must be active
				$name = _GUICtrlMenu_GetItemText($StudioFenster_MenuHandle, $ISN_ToolsMenu_MacroSlot10, False)
				$readen_icon = $Macroslot_InfoArray[9][2]
				$readen_icon = Number($readen_icon)
				If $readen_icon = 0 Then $readen_icon = $readen_icon - 1
				If $LineNeeded = -1 Then $LineNeeded = _GUICtrlCreateODMenuItem("", $TreeviewContextMenu)
				$TreeviewContextMenu_makroslot10 = _GUICtrlCreateODMenuItem($name & @TAB & _Keycode_zu_Text($Hotkey_Keycode_Makroslot10), $TreeviewContextMenu, $smallIconsdll, $readen_icon + 1)
			EndIf
		EndIf


	EndIf


	;If $TreeviewContextMenu_makroslot1 <> "" Or $TreeviewContextMenu_makroslot2 <> "" Or $TreeviewContextMenu_makroslot3 <> "" Or $TreeviewContextMenu_makroslot4 <> "" Or $TreeviewContextMenu_makroslot5 <> "" Or $TreeviewContextMenu_makroslot6 <> "" Or $TreeviewContextMenu_makroslot7 <> "" Then _GUICtrlCreateODMenuItem("", $TreeviewContextMenu)




EndFunc   ;==>_Erstelle_Kontextmenu_fuer_Projektbaum

Func _neuer_changelog_eintrag_Radio_Toggle()
	If GUICtrlRead($neuer_changelog_eintrag_radio1) = $GUI_CHECKED Then
		GUICtrlSetState($neuer_changelog_eintrag_bearbeiter_input, $GUI_DISABLE)
		GUICtrlSetState($neuer_changelog_eintrag_bearbeiter_label, $GUI_DISABLE)
		GUICtrlSetState($neuer_changelog_eintrag_datum_input, $GUI_DISABLE)
		GUICtrlSetState($neuer_changelog_eintrag_datum_label, $GUI_DISABLE)
		GUICtrlSetState($neuer_changelog_eintrag_version_checkbox, $GUI_DISABLE)
		GUICtrlSetState($neuer_changelog_eintrag_version_input, $GUI_DISABLE)
		GUICtrlSetState($neuer_changelog_eintrag_betreff_input, $GUI_DISABLE)
		GUICtrlSetState($neuer_changelog_eintrag_betreff_label, $GUI_DISABLE)
		GUICtrlSetState($neuer_changelog_eintrag_edit, $GUI_DISABLE)
	Else
		GUICtrlSetState($neuer_changelog_eintrag_bearbeiter_input, $GUI_ENABLE)
		GUICtrlSetState($neuer_changelog_eintrag_bearbeiter_label, $GUI_ENABLE)
		GUICtrlSetState($neuer_changelog_eintrag_datum_input, $GUI_ENABLE)
		GUICtrlSetState($neuer_changelog_eintrag_datum_label, $GUI_ENABLE)
		GUICtrlSetState($neuer_changelog_eintrag_version_checkbox, $GUI_ENABLE)
		GUICtrlSetState($neuer_changelog_eintrag_version_input, $GUI_ENABLE)
		GUICtrlSetState($neuer_changelog_eintrag_betreff_input, $GUI_ENABLE)
		GUICtrlSetState($neuer_changelog_eintrag_betreff_label, $GUI_ENABLE)
		GUICtrlSetState($neuer_changelog_eintrag_edit, $GUI_ENABLE)
	EndIf
EndFunc   ;==>_neuer_changelog_eintrag_Radio_Toggle


Func _Zeige_neuer_changelog_eintrag_GUI()
	If IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "use_changelog_manager", "false") = "false" Then Return
	GUICtrlSetState($neuer_changelog_eintrag_radio1, $GUI_CHECKED)
	GUICtrlSetState($neuer_changelog_eintrag_version_checkbox, $GUI_UNCHECKED)

	If _ProjectISN_Config_Read("changelog_use_author_from_project", "false") = "true" Then
		GUICtrlSetData($neuer_changelog_eintrag_bearbeiter_input, _ProjectISN_Config_Read("author", ""))
	Else
		GUICtrlSetData($neuer_changelog_eintrag_bearbeiter_input, @UserName)
	EndIf

	GUICtrlSetData($neuer_changelog_eintrag_datum_input, @YEAR & "/" & @MON & "/" & @MDAY)
	GUICtrlSetData($neuer_changelog_eintrag_betreff_input, "")
	GUICtrlSetData($neuer_changelog_eintrag_edit, "")
	GUICtrlSetData($neuer_changelog_eintrag_version_input, IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "version", ""))
	_neuer_changelog_eintrag_Radio_Toggle()
	_CenterOnMonitor($neuer_changelog_eintrag_GUI, "", $Runonmonitor)
	WinSetOnTop($neuer_changelog_eintrag_GUI, "", 1)
	GUISetState(@SW_SHOW, $neuer_changelog_eintrag_GUI)
	GUISetState(@SW_DISABLE, $Studiofenster)

	While 1
		$neuer_changelog_eintrag_GUI_state = WinGetState($neuer_changelog_eintrag_GUI, "")
		If Not BitAND($neuer_changelog_eintrag_GUI_state, 2) Then ExitLoop
		Sleep(100)
	WEnd
EndFunc   ;==>_Zeige_neuer_changelog_eintrag_GUI

Func _neuer_changelog_eintrag_OK()
	If GUICtrlRead($neuer_changelog_eintrag_radio2) = $GUI_CHECKED Then
		If GUICtrlRead($neuer_changelog_eintrag_edit) = "" Then
			_Input_Error_FX($neuer_changelog_eintrag_edit)
			Return
		EndIf
	EndIf
	GUISetState(@SW_ENABLE, $Studiofenster)
	GUISetState(@SW_HIDE, $neuer_changelog_eintrag_GUI)
	If GUICtrlRead($neuer_changelog_eintrag_radio2) = $GUI_CHECKED Then _Changelogeintrag_hinzufuegen()
EndFunc   ;==>_neuer_changelog_eintrag_OK


Func Date_AutoIt_2_German($conv_date)
	$String = ""
	If $conv_date = "" Then Return
	$conv_parts = StringSplit($conv_date, "/", 2)
	If IsArray($conv_parts) Then
		$String = $conv_parts[2] & "." & $conv_parts[1] & "." & $conv_parts[0]
	EndIf
	Return $String
EndFunc   ;==>Date_AutoIt_2_German




Func _Changelogeintrag_hinzufuegen()
	$Project_ISN = $Pfad_zur_Project_ISN
	$NewitemID = @MDAY & @MON & @YEAR & @HOUR & @MIN & @SEC & Random(0, 100, 1)
	$Items_String = IniRead($Pfad_zur_Project_ISN, $Changelog_Section, "items", "")
	$Items_String = $Items_String & $NewitemID & "|"
	IniWrite($Pfad_zur_Project_ISN, $Changelog_Section, "items", $Items_String)

	IniWrite($Pfad_zur_Project_ISN, $Changelog_Section, "text[" & $NewitemID & "]", StringReplace(GUICtrlRead($neuer_changelog_eintrag_edit), @CRLF, "[BREAK]"))
	If GUICtrlRead($neuer_changelog_eintrag_betreff_input) <> "" Then IniWrite($Pfad_zur_Project_ISN, $Changelog_Section, "subject[" & $NewitemID & "]", GUICtrlRead($neuer_changelog_eintrag_betreff_input))
	If GUICtrlRead($neuer_changelog_eintrag_bearbeiter_input) <> "" Then IniWrite($Pfad_zur_Project_ISN, $Changelog_Section, "editor[" & $NewitemID & "]", GUICtrlRead($neuer_changelog_eintrag_bearbeiter_input))
	If $Benoetigte_Zeit <> 0 Then IniWrite($Pfad_zur_Project_ISN, $Changelog_Section, "time[" & $NewitemID & "]", $Benoetigte_Zeit)
	$Datum_Array = _GUICtrlDTP_GetSystemTime(GUICtrlGetHandle($neuer_changelog_eintrag_datum_input))
	If IsArray($Datum_Array) Then
		IniWrite($Pfad_zur_Project_ISN, $Changelog_Section, "date[" & $NewitemID & "]", StringFormat("%04d/%02d/%02d", $Datum_Array[0], $Datum_Array[1], $Datum_Array[2]))
	EndIf
	If GUICtrlRead($neuer_changelog_eintrag_version_checkbox) = $GUI_CHECKED Then
		IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "version", GUICtrlRead($neuer_changelog_eintrag_version_input))
		IniWrite($Pfad_zur_Project_ISN, $Changelog_Section, "version[" & $NewitemID & "]", GUICtrlRead($neuer_changelog_eintrag_version_input))
	Else
		IniWrite($Pfad_zur_Project_ISN, $Changelog_Section, "version[" & $NewitemID & "]", IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "version", ""))
	EndIf
EndFunc   ;==>_Changelogeintrag_hinzufuegen

Func _sort_changelogmanager_listview()
	_Sortiere_Listview($changelogmanager_listview)
EndFunc   ;==>_sort_changelogmanager_listview

Func _sort_berichtgenerieren_listview()
	_Sortiere_Listview($changelogenerieren_listview)
EndFunc   ;==>_sort_berichtgenerieren_listview

Func _Sortiere_Listview($Listview = "", $Colum = "-1", $Direction = "-1")
	If $Listview = "" Then Return
	If $Colum = "-1" Then $Colum = GUICtrlGetState($Listview)
	If $Direction <> "-1" Then
		_GUICtrlListView_UnRegisterSortCallBack($Listview)
		_Sortiere_Listview($Listview, $Colum)
	EndIf
	_GUICtrlListView_RegisterSortCallBack($Listview)
	_GUICtrlListView_SortItems($Listview, $Colum)
EndFunc   ;==>_Sortiere_Listview


Func _Aenderungsmanager_Aktualisiere_Liste($handle = $changelogmanager_listview)
	If $Offenes_Projekt = "" Then Return
	Local $Gesamtzeit = 0
	Local $Geladene_Objekte = 0
	Local $Secs, $Mins, $Hour
	$ISN_Datei = $Pfad_zur_Project_ISN
	$Items_String = IniRead($Pfad_zur_Project_ISN, $Changelog_Section, "items", "")
	_GUICtrlListView_DeleteAllItems(GUICtrlGetHandle($handle))
	_GUICtrlListView_BeginUpdate($handle)
	$Item_Array = StringSplit($Items_String, "|", 2)
	If IsArray($Item_Array) Then
		For $x = 0 To UBound($Item_Array) - 1
			If $Item_Array[$x] = "|" Then ContinueLoop
			If $Item_Array[$x] = "" Then ContinueLoop
			If $Item_Array[$x] = " " Then ContinueLoop
			$Geladene_Objekte = $Geladene_Objekte + 1
			_GUICtrlListView_AddItem($handle, IniRead($ISN_Datei, $Changelog_Section, "date[" & $Item_Array[$x] & "]", ""), -1, _GUICtrlListView_GetItemCount($handle) + 9999) ;Fix für Sortierung
			_GUICtrlListView_AddSubItem($handle, _GUICtrlListView_GetItemCount($handle) - 1, IniRead($ISN_Datei, $Changelog_Section, "subject[" & $Item_Array[$x] & "]", ""), 1)
			_GUICtrlListView_AddSubItem($handle, _GUICtrlListView_GetItemCount($handle) - 1, StringReplace(IniRead($ISN_Datei, $Changelog_Section, "text[" & $Item_Array[$x] & "]", ""), "[BREAK]", " "), 2)
			_GUICtrlListView_AddSubItem($handle, _GUICtrlListView_GetItemCount($handle) - 1, IniRead($ISN_Datei, $Changelog_Section, "version[" & $Item_Array[$x] & "]", ""), 3)
			$Zeitms = IniRead($ISN_Datei, $Changelog_Section, "time[" & $Item_Array[$x] & "]", 0)
			$Gesamtzeit = $Gesamtzeit + $Zeitms
			_TicksToTime($Zeitms, $Hour, $Mins, $Secs)
			_GUICtrlListView_AddSubItem($handle, _GUICtrlListView_GetItemCount($handle) - 1, $Hour & "h " & $Mins & "m " & $Secs & "s", 4)
			_GUICtrlListView_AddSubItem($handle, _GUICtrlListView_GetItemCount($handle) - 1, IniRead($ISN_Datei, $Changelog_Section, "editor[" & $Item_Array[$x] & "]", ""), 5)
			_GUICtrlListView_AddSubItem($handle, _GUICtrlListView_GetItemCount($handle) - 1, $Item_Array[$x], 6) ;ID
			_Sortiere_Listview($handle, 0, 1) ;Sortiere nach englischem Datum
		Next
		;Ersetze Englisches Datum durch Deutsches
		If $Languagefile = "german.lng" Then
			For $y = 0 To _GUICtrlListView_GetItemCount($handle) - 1
				$Datum = _GUICtrlListView_GetItemText($handle, $y, 0)
				$Datum = Date_AutoIt_2_German($Datum)
				_GUICtrlListView_SetItemText($handle, $y, $Datum, 0)
			Next
		EndIf
	EndIf
	_GUICtrlListView_EndUpdate($handle)
	GUICtrlSetData($changelogmanager_geladene_Objekte_label, $Geladene_Objekte & " " & _Get_langstr(924))
	_TicksToTime($Gesamtzeit, $Hour, $Mins, $Secs)
	GUICtrlSetData($changelogmanager_gesamtzeit_label, _Get_langstr(923) & " " & $Hour & "h " & $Mins & "m " & $Secs & "s")
EndFunc   ;==>_Aenderungsmanager_Aktualisiere_Liste

Func _changelogmanager_lade_eintrag()
	AdlibUnRegister("_changelogmanager_lade_eintrag")
	Local $Secs, $Mins, $Hour
	$ISN_Datei = $Pfad_zur_Project_ISN
	If _GUICtrlListView_GetSelectionMark($changelogmanager_listview) = -1 Then
		GUICtrlSetState($changelogmanager_datum_input, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_bearbeiter_input, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_betreff_input, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_zeit_input, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_version_input, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_text_input, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_uebernehmen_button, $GUI_DISABLE)
		GUICtrlSetData($changelogmanager_datum_input, "")
		GUICtrlSetData($changelogmanager_bearbeiter_input, "")
		GUICtrlSetData($changelogmanager_betreff_input, "")
		GUICtrlSetData($changelogmanager_zeit_input, "")
		GUICtrlSetData($changelogmanager_version_input, "")
		GUICtrlSetData($changelogmanager_text_input, "")
		GUICtrlSetData($changelogmanager_zeit_h, "")
		GUICtrlSetData($changelogmanager_zeit_m, "")
		GUICtrlSetData($changelogmanager_zeit_s, "")
		GUICtrlSetState($changelogmanager_version_label, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_datum_label, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_betreff_label, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_bearbeiter_label, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_zeit_label, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_zeit_h, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_zeit_m, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_zeit_s, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_zeit_h_label, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_zeit_m_label, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_zeit_s_label, $GUI_DISABLE)
		Return
	Else
		$Section_ID = _GUICtrlListView_GetItemText($changelogmanager_listview, _GUICtrlListView_GetSelectionMark($changelogmanager_listview), 6)
		If $Section_ID = "" Then Return
		GUICtrlSetState($changelogmanager_datum_input, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_bearbeiter_input, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_betreff_input, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_zeit_input, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_version_input, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_text_input, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_uebernehmen_button, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_version_label, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_datum_label, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_betreff_label, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_bearbeiter_label, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_zeit_label, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_zeit_h, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_zeit_m, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_zeit_s, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_zeit_h_label, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_zeit_m_label, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_zeit_s_label, $GUI_ENABLE)
		GUICtrlSetData($changelogmanager_datum_input, IniRead($ISN_Datei, $Changelog_Section, "date[" & $Section_ID & "]", ""))
		GUICtrlSetData($changelogmanager_bearbeiter_input, IniRead($ISN_Datei, $Changelog_Section, "editor[" & $Section_ID & "]", ""))
		GUICtrlSetData($changelogmanager_betreff_input, IniRead($ISN_Datei, $Changelog_Section, "subject[" & $Section_ID & "]", ""))
		GUICtrlSetData($changelogmanager_zeit_input, IniRead($ISN_Datei, $Changelog_Section, "time[" & $Section_ID & "]", "0"))
		_TicksToTime(GUICtrlRead($changelogmanager_zeit_input), $Hour, $Mins, $Secs)
		GUICtrlSetData($changelogmanager_zeit_h, $Hour)
		GUICtrlSetData($changelogmanager_zeit_m, $Mins)
		GUICtrlSetData($changelogmanager_zeit_s, $Secs)
		GUICtrlSetData($changelogmanager_version_input, IniRead($ISN_Datei, $Changelog_Section, "version[" & $Section_ID & "]", ""))
		GUICtrlSetData($changelogmanager_text_input, StringReplace(IniRead($ISN_Datei, $Changelog_Section, "text[" & $Section_ID & "]", ""), "[BREAK]", @CRLF))

	EndIf

EndFunc   ;==>_changelogmanager_lade_eintrag

Func _changelogmanager_eintrag_loeschen()
	If _GUICtrlListView_GetSelectionMark($changelogmanager_listview) = -1 Then Return
	$Section_ID = _GUICtrlListView_GetItemText($changelogmanager_listview, _GUICtrlListView_GetSelectionMark($changelogmanager_listview), 6)
	If $Section_ID = "" Then Return
	$ISN_Datei = $Pfad_zur_Project_ISN
	$Items_String = IniRead($Pfad_zur_Project_ISN, $Changelog_Section, "items", "")
	$Antwort = MsgBox(262144 + 32 + 4, _Get_langstr(48), _Get_langstr(932), 0, $aenderungs_manager_GUI)
	If $Antwort = 6 Then
		IniDelete($ISN_Datei, $Changelog_Section, "subject[" & $Section_ID & "]")
		IniDelete($ISN_Datei, $Changelog_Section, "text[" & $Section_ID & "]")
		IniDelete($ISN_Datei, $Changelog_Section, "time[" & $Section_ID & "]")
		IniDelete($ISN_Datei, $Changelog_Section, "editor[" & $Section_ID & "]")
		IniDelete($ISN_Datei, $Changelog_Section, "version[" & $Section_ID & "]")
		IniDelete($ISN_Datei, $Changelog_Section, "date[" & $Section_ID & "]")
		$Items_String = StringReplace($Items_String, $Section_ID, "")
		$Items_String = StringReplace($Items_String, "||", "|")
		IniWrite($Pfad_zur_Project_ISN, $Changelog_Section, "items", $Items_String)
		_Aenderungsmanager_Aktualisiere_Liste()
	EndIf
EndFunc   ;==>_changelogmanager_eintrag_loeschen

Func _changelogmanager_alle_eintraege_loeschen()
	$ISN_Datei = $Pfad_zur_Project_ISN
	$Antwort = MsgBox(262144 + 32 + 4, _Get_langstr(48), _Get_langstr(971), 0, $aenderungs_manager_GUI)
	If $Antwort = 6 Then
		IniDelete($ISN_Datei, $Changelog_Section)
		_Aenderungsmanager_Aktualisiere_Liste()
	EndIf
EndFunc   ;==>_changelogmanager_alle_eintraege_loeschen

Func _changelogmanager_eintrag_aendern()
	If _GUICtrlListView_GetSelectionMark($changelogmanager_listview) = -1 Then Return
	$Section_ID = _GUICtrlListView_GetItemText($changelogmanager_listview, _GUICtrlListView_GetSelectionMark($changelogmanager_listview), 6)
	If $Section_ID = "" Then Return
	$Alte_Selection = _GUICtrlListView_GetSelectionMark($changelogmanager_listview)
	$ISN_Datei = $Pfad_zur_Project_ISN
	GUICtrlSetData($changelogmanager_zeit_input, _TimeToTicks(GUICtrlRead($changelogmanager_zeit_h), GUICtrlRead($changelogmanager_zeit_m), GUICtrlRead($changelogmanager_zeit_s)))
	IniWrite($ISN_Datei, $Changelog_Section, "text[" & $Section_ID & "]", StringReplace(GUICtrlRead($changelogmanager_text_input), @CRLF, "[BREAK]"))
	IniWrite($ISN_Datei, $Changelog_Section, "subject[" & $Section_ID & "]", GUICtrlRead($changelogmanager_betreff_input))
	IniWrite($ISN_Datei, $Changelog_Section, "editor[" & $Section_ID & "]", GUICtrlRead($changelogmanager_bearbeiter_input))
	IniWrite($ISN_Datei, $Changelog_Section, "time[" & $Section_ID & "]", GUICtrlRead($changelogmanager_zeit_input))
	IniWrite($ISN_Datei, $Changelog_Section, "version[" & $Section_ID & "]", GUICtrlRead($changelogmanager_version_input))
	$Datum_Array = _GUICtrlDTP_GetSystemTime(GUICtrlGetHandle($changelogmanager_datum_input))
	If IsArray($Datum_Array) Then
		IniWrite($ISN_Datei, $Changelog_Section, "date[" & $Section_ID & "]", StringFormat("%04d/%02d/%02d", $Datum_Array[0], $Datum_Array[1], $Datum_Array[2]))
	EndIf
	_Aenderungsmanager_Aktualisiere_Liste()
	_GUICtrlListView_SetItemSelected($changelogmanager_listview, $Alte_Selection, True, True)
	_changelogmanager_lade_eintrag()
EndFunc   ;==>_changelogmanager_eintrag_aendern

Func _changelogmanager_resize()
	$Fixe_Breiten = 70 + 150 + 60 + 90 + 110
	$Listview_groesse = _ControlGetPos($aenderungs_manager_GUI, "", $changelogmanager_listview)
	If Not IsArray($Listview_groesse) Then Return
	$Neue_Textbreite = $Listview_groesse[2] - $Fixe_Breiten - 40
	_GUICtrlListView_SetColumnWidth($changelogmanager_listview, 2, $Neue_Textbreite)
EndFunc   ;==>_changelogmanager_resize

Func _Toggle_Changelogmanager()
	If GUICtrlRead($changelogmanager_protokolle_verwenden_checkbox) = $GUI_CHECKED Then
		GUICtrlSetState($changelogmanager_listview, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_neu_button, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_loeschen_button, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_gesamtzeit_label, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_geladene_Objekte_label, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_export_button, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_import_button, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_uebernehmen_button, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_version_label, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_datum_label, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_betreff_label, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_bearbeiter_label, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_zeit_label, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_zeit_h_label, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_zeit_m_label, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_zeit_s_label, $GUI_ENABLE)
		GUICtrlSetState($changelogmanager_allesloeschen_button, $GUI_ENABLE)
		IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "use_changelog_manager", "true")
	Else
		GUICtrlSetState($changelogmanager_datum_input, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_bearbeiter_input, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_betreff_input, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_zeit_input, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_version_input, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_text_input, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_listview, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_neu_button, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_loeschen_button, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_gesamtzeit_label, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_geladene_Objekte_label, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_export_button, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_import_button, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_uebernehmen_button, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_version_label, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_datum_label, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_betreff_label, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_bearbeiter_label, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_zeit_label, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_zeit_h_label, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_zeit_m_label, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_zeit_s_label, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_zeit_h, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_zeit_m, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_zeit_s, $GUI_DISABLE)
		GUICtrlSetState($changelogmanager_allesloeschen_button, $GUI_DISABLE)
		IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "use_changelog_manager", "false")
	EndIf

EndFunc   ;==>_Toggle_Changelogmanager


Func _Zeige_changelogmanager()
	If $Offenes_Projekt = "" Then Return
	If $Studiomodus = 2 Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(670), 0, $Studiofenster)
		Return
	EndIf
	GUISetState(@SW_DISABLE, $Studiofenster)
	_Aenderungsmanager_Aktualisiere_Liste()
	_changelogmanager_lade_eintrag()
	If IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "use_changelog_manager", "false") = "true" Then
		GUICtrlSetState($changelogmanager_protokolle_verwenden_checkbox, $GUI_CHECKED)
	Else
		GUICtrlSetState($changelogmanager_protokolle_verwenden_checkbox, $GUI_UNCHECKED)
	EndIf
	_Toggle_Changelogmanager()
	GUISetState(@SW_ENABLE, $aenderungs_manager_GUI)
	GUISetState(@SW_SHOW, $aenderungs_manager_GUI)
EndFunc   ;==>_Zeige_changelogmanager

Func _HIDE_changelogmanager()
	GUISetState(@SW_ENABLE, $Studiofenster)
	GUISetState(@SW_HIDE, $aenderungs_manager_GUI)
EndFunc   ;==>_HIDE_changelogmanager

Func _Bericht_standardlayout_wiederherstellen()
	$text = _Hole_Standardvorlage_fuer_bericht()
	$text = StringReplace($text, "[BREAK]", @CRLF)
	GUICtrlSetData($berichtgenerieren_aufbauedit, $text)
EndFunc   ;==>_Bericht_standardlayout_wiederherstellen

Func _SHOW_bericht_generieren_GUI()
	GUISetState(@SW_SHOW, $changelog_generieren_GUI)
	GUISetState(@SW_DISABLE, $aenderungs_manager_GUI)
	GUICtrlSetData($berichtgenerieren_vorschaufenster, "")
	GUICtrlSetData($berichtgenerieren_aufbauedit, "")
	$text = IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "changelog_manager_report_layout", _Hole_Standardvorlage_fuer_bericht())
	$text = StringReplace($text, "[BREAK]", @CRLF)
	GUICtrlSetData($berichtgenerieren_aufbauedit, $text)
	_Aenderungsmanager_Aktualisiere_Liste($changelogenerieren_listview)
	_Bericht_generieren_dropdowns_befuellen()
EndFunc   ;==>_SHOW_bericht_generieren_GUI

Func _HIDE_bericht_generieren_GUI()
	GUISetState(@SW_ENABLE, $aenderungs_manager_GUI)
	GUISetState(@SW_HIDE, $changelog_generieren_GUI)
	;Sepeichere Layout
	$text = StringReplace(GUICtrlRead($berichtgenerieren_aufbauedit), @CRLF, "[BREAK]")
	IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "changelog_manager_report_layout", $text)
	_Bericht_verstecke_hilfe()
EndFunc   ;==>_HIDE_bericht_generieren_GUI

Func _Bericht_generieren_alles_makieren()
	If _GUICtrlListView_GetItemCount($changelogenerieren_listview) = 0 Then Return
	For $y = 0 To _GUICtrlListView_GetItemCount($changelogenerieren_listview) - 1
		_GUICtrlListView_SetItemChecked($changelogenerieren_listview, $y, True)
	Next
EndFunc   ;==>_Bericht_generieren_alles_makieren

Func _Bericht_generieren_alles_abmakieren()
	If _GUICtrlListView_GetItemCount($changelogenerieren_listview) = 0 Then Return
	For $y = 0 To _GUICtrlListView_GetItemCount($changelogenerieren_listview) - 1
		_GUICtrlListView_SetItemChecked($changelogenerieren_listview, $y, False)
	Next
EndFunc   ;==>_Bericht_generieren_alles_abmakieren

Func _Bericht_generieren_dropdowns_befuellen()
	GUICtrlSetData($berichtgenerieren_bearbeiter_combo, "", "")
	GUICtrlSetData($berichtgenerieren_version_combo, "", "")
	If _GUICtrlListView_GetItemCount($changelogenerieren_listview) = 0 Then Return
	Dim $Eintraege_Version[1]
	Dim $Eintraege_Bearbeiter[1]
	For $y = 0 To _GUICtrlListView_GetItemCount($changelogenerieren_listview) - 1
		_ArrayAdd($Eintraege_Version, _GUICtrlListView_GetItemText($changelogenerieren_listview, $y, 3))
		_ArrayAdd($Eintraege_Bearbeiter, _GUICtrlListView_GetItemText($changelogenerieren_listview, $y, 5))
	Next
	_ArrayDelete($Eintraege_Version, 0)
	_ArrayDelete($Eintraege_Bearbeiter, 0)
	$Eintraege_Version = _ArrayUnique($Eintraege_Version)
	$Eintraege_Bearbeiter = _ArrayUnique($Eintraege_Bearbeiter)
	_ArrayDelete($Eintraege_Version, 0)
	_ArrayDelete($Eintraege_Bearbeiter, 0)

	If IsArray($Eintraege_Version) Then
		$Datenstring = _ArrayToString($Eintraege_Version, "|")
		GUICtrlSetData($berichtgenerieren_version_combo, $Datenstring, "")
	EndIf

	If IsArray($Eintraege_Bearbeiter) Then
		$Datenstring = _ArrayToString($Eintraege_Bearbeiter, "|")
		GUICtrlSetData($berichtgenerieren_bearbeiter_combo, $Datenstring, "")
	EndIf
EndFunc   ;==>_Bericht_generieren_dropdowns_befuellen

Func _Bericht_generieren_makiere_elemente_nach_vorgabe($Spalte = 0, $text = "")
	If _GUICtrlListView_GetItemCount($changelogenerieren_listview) = 0 Then Return
	For $y = 0 To _GUICtrlListView_GetItemCount($changelogenerieren_listview) - 1
		If StringInStr(_GUICtrlListView_GetItemText($changelogenerieren_listview, $y, $Spalte), $text) Or _GUICtrlListView_GetItemText($changelogenerieren_listview, $y, $Spalte) = $text Then
			_GUICtrlListView_SetItemChecked($changelogenerieren_listview, $y, True)
		Else
			_GUICtrlListView_SetItemChecked($changelogenerieren_listview, $y, False)
		EndIf
	Next
EndFunc   ;==>_Bericht_generieren_makiere_elemente_nach_vorgabe

Func _Bericht_generieren_versioncombo_select()
	_Bericht_generieren_makiere_elemente_nach_vorgabe(3, GUICtrlRead($berichtgenerieren_version_combo))
EndFunc   ;==>_Bericht_generieren_versioncombo_select

Func _Bericht_generieren_bearbeitercombo_select()
	_Bericht_generieren_makiere_elemente_nach_vorgabe(5, GUICtrlRead($berichtgenerieren_bearbeiter_combo))
EndFunc   ;==>_Bericht_generieren_bearbeitercombo_select

Func _Bericht_generieren_datum_select()
	$Datum_Array = _GUICtrlDTP_GetSystemTime(GUICtrlGetHandle($berichtgenerieren_datum))
	If IsArray($Datum_Array) Then
		If $Languagefile = "german.lng" Then
			_Bericht_generieren_makiere_elemente_nach_vorgabe(0, StringFormat("%02d.%02d.%04d", $Datum_Array[2], $Datum_Array[1], $Datum_Array[0]))
		Else
			_Bericht_generieren_makiere_elemente_nach_vorgabe(0, StringFormat("%04d/%02d/%02d", $Datum_Array[0], $Datum_Array[1], $Datum_Array[2]))
		EndIf
	EndIf
EndFunc   ;==>_Bericht_generieren_datum_select

Func _Bericht_generieren()
	GUICtrlSetData($berichtgenerieren_vorschaufenster, "")
	If _GUICtrlListView_GetItemCount($changelogenerieren_listview) = 0 Then Return
	$ISN_Datei = $Pfad_zur_Project_ISN
	$Rohe_Vorlage = GUICtrlRead($berichtgenerieren_aufbauedit)
	$Rohe_Vorlage = StringReplace($Rohe_Vorlage, @CRLF, "[BREAK]")
	$Vorlage_Itemsbereich = ""
	$Fertiger_Itemsbereich = ""
	$Itemsbereich_Array = _StringBetween($Rohe_Vorlage, "<items>", "</items>")
	If IsArray($Itemsbereich_Array) Then
		$Vorlage_Itemsbereich = $Itemsbereich_Array[0]
		$Rohe_Vorlage = StringReplace($Rohe_Vorlage, $Itemsbereich_Array[0], "#ITEMSHERE#")

		For $y = 0 To _GUICtrlListView_GetItemCount($changelogenerieren_listview) - 1
			If _GUICtrlListView_GetItemChecked($changelogenerieren_listview, $y) = True Then
				$Section_ID = _GUICtrlListView_GetItemText($changelogenerieren_listview, $y, 6)
				$Bereich = $Vorlage_Itemsbereich
				$Bereich = StringReplace($Bereich, "%version%", _GUICtrlListView_GetItemText($changelogenerieren_listview, $y, 3))
				$Bereich = StringReplace($Bereich, "%id%", _GUICtrlListView_GetItemText($changelogenerieren_listview, $y, 6))
				$Bereich = StringReplace($Bereich, "%editor%", _GUICtrlListView_GetItemText($changelogenerieren_listview, $y, 5))
				$Bereich = StringReplace($Bereich, "%time%", _GUICtrlListView_GetItemText($changelogenerieren_listview, $y, 4))
				$Bereich = StringReplace($Bereich, "%date%", _GUICtrlListView_GetItemText($changelogenerieren_listview, $y, 0))
				$Bereich = StringReplace($Bereich, "%subject%", _GUICtrlListView_GetItemText($changelogenerieren_listview, $y, 1))
				$Bereich = StringReplace($Bereich, "%text%", IniRead($ISN_Datei, $Changelog_Section, "text[" & $Section_ID & "]", ""))
				$Bereich = _ISN_Variablen_aufloesen($Bereich)
				$Fertiger_Itemsbereich = $Fertiger_Itemsbereich & $Bereich
			EndIf
		Next
	EndIf




	$Rohe_Vorlage = StringReplace($Rohe_Vorlage, "#ITEMSHERE#", $Fertiger_Itemsbereich)
	$Rohe_Vorlage = StringReplace($Rohe_Vorlage, "%projectname%", IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "name", ""))
	$Rohe_Vorlage = StringReplace($Rohe_Vorlage, "%studioversion%", $Studioversion)
	$Rohe_Vorlage = StringReplace($Rohe_Vorlage, "%projectversion%", IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "version", ""))
	$Rohe_Vorlage = _ISN_Variablen_aufloesen($Rohe_Vorlage)


	$Rohe_Vorlage = StringReplace($Rohe_Vorlage, "<items>", "")
	$Rohe_Vorlage = StringReplace($Rohe_Vorlage, "</items>", "")
	$Rohe_Vorlage = StringReplace($Rohe_Vorlage, "[BREAK]", @CRLF)
	GUICtrlSetData($berichtgenerieren_vorschaufenster, $Rohe_Vorlage)
EndFunc   ;==>_Bericht_generieren


Func _Hole_Standardvorlage_fuer_bericht()
	$String = ""
	$String = $String & "%ProjectName% v. %ProjectVersion% - %LangString(939)%" & @CRLF
	$String = $String & "------------------------------------------------------------------" & @CRLF
	$String = $String & "<items>" & @CRLF
	$String = $String & "/////////////////////////////////////////" & @CRLF
	$String = $String & "/// %LangString(921)% %Date%" & @CRLF
	$String = $String & "/// %LangString(918)% %Subject%" & @CRLF
	$String = $String & "/// %LangString(920)% %Editor%" & @CRLF
	$String = $String & "/////////////////////////////////////////" & @CRLF
	$String = $String & "%Text%" & @CRLF
	$String = $String & "</items>" & @CRLF
	$String = $String & "------------------------------------------------------------------" & @CRLF
	$String = $String & "%LangString(30)% %StudioVersion%"
	Return $String
EndFunc   ;==>_Hole_Standardvorlage_fuer_bericht

Func _Bericht_generieren_speichern_unter()
	_Bericht_generieren()
	If GUICtrlRead($berichtgenerieren_vorschaufenster) = "" Then Return
	_Lock_Plugintabs("lock")
	If $Skin_is_used = "true" Then
		$line = _WinAPI_SaveFileDlg(_Get_langstr(313), $Offenes_Projekt, "Textfile (*.txt)", 0, "report.txt", '', BitOR($OFN_PATHMUSTEXIST, $OFN_FILEMUSTEXIST, $OFN_HIDEREADONLY), $OFN_EX_NOPLACESBAR, 0, 0, $changelog_generieren_GUI)
	Else
		$line = FileSaveDialog(_Get_langstr(313), $Offenes_Projekt, "Textfile (*.txt)", 18, "report.txt", $changelog_generieren_GUI)
	EndIf
	_Lock_Plugintabs("unlock")
	FileChangeDir(@ScriptDir)
	If $line = "" Then Return
	If @error > 0 Then Return
	$file = FileOpen($line, 2 + $FO_ANSI)
	If $file = -1 Then Return
	FileWrite($file, GUICtrlRead($berichtgenerieren_vorschaufenster))
	FileClose($file)
	MsgBox(262144 + 64, _Get_langstr(61), StringTrimLeft($line, StringInStr($line, "\", 0, -1)) & " " & _Get_langstr(691), 0, $changelog_generieren_GUI)
	;_Update_Treeview()
EndFunc   ;==>_Bericht_generieren_speichern_unter

Func _aenderungsprotokolle_exportieren()
	$ISN_Datei = $Pfad_zur_Project_ISN
	_Lock_Plugintabs("lock")
	If $Skin_is_used = "true" Then
		$line = _WinAPI_SaveFileDlg(_Get_langstr(313), $Offenes_Projekt, "INI File (*.ini)", 0, "export.ini", '', BitOR($OFN_PATHMUSTEXIST, $OFN_FILEMUSTEXIST, $OFN_HIDEREADONLY), $OFN_EX_NOPLACESBAR, 0, 0, $aenderungs_manager_GUI)
	Else
		$line = FileSaveDialog(_Get_langstr(313), $Offenes_Projekt, "INI File (*.ini)", 18, "export.ini", $aenderungs_manager_GUI)
	EndIf
	_Lock_Plugintabs("unlock")
	FileChangeDir(@ScriptDir)
	If $line = "" Then Return
	If @error > 0 Then Return

	$section = IniReadSection($ISN_Datei, $Changelog_Section)
	If @error > 0 Then Return
	IniWriteSection($line, $Changelog_Section, $section)
	MsgBox(262144 + 64, _Get_langstr(61), StringTrimLeft($line, StringInStr($line, "\", 0, -1)) & " " & _Get_langstr(691), 0, $aenderungs_manager_GUI)
	;_Update_Treeview()
EndFunc   ;==>_aenderungsprotokolle_exportieren

Func _Bericht_zeige_hilfe()
	GUISetState(@SW_SHOW, $aenderungsbericht_hilfeGUI)
EndFunc   ;==>_Bericht_zeige_hilfe

Func _Bericht_verstecke_hilfe()
	GUISetState(@SW_HIDE, $aenderungsbericht_hilfeGUI)
EndFunc   ;==>_Bericht_verstecke_hilfe

Func _aenderungsprotokolle_importieren()
	$ISN_Datei = $Pfad_zur_Project_ISN
	$Antwort = MsgBox(262144 + 4 + 48, _Get_langstr(394), _Get_langstr(949), 0, $aenderungs_manager_GUI)
	If $Antwort = 6 Then
		_Lock_Plugintabs("lock")
		If $Skin_is_used = "true" Then
			$line = _WinAPI_OpenFileDlg(_Get_langstr(313), $Offenes_Projekt, "INI File (*.ini)", 0, '', '', BitOR($OFN_PATHMUSTEXIST, $OFN_FILEMUSTEXIST, $OFN_HIDEREADONLY), $OFN_EX_NOPLACESBAR, 0, 0, $aenderungs_manager_GUI)
		Else
			$line = FileOpenDialog(_Get_langstr(313), $Offenes_Projekt, "INI File (*.ini)", 1 + 2, "", $aenderungs_manager_GUI)
		EndIf
		_Lock_Plugintabs("unlock")
		FileChangeDir(@ScriptDir)
		If $line = "" Then Return
		If @error > 0 Then Return

		$section = IniReadSection($line, $Changelog_Section)
		If @error > 0 Then Return
		IniDelete($ISN_Datei, $Changelog_Section)
		IniWriteSection($ISN_Datei, $Changelog_Section, $section)
		_Zeige_changelogmanager()
		MsgBox(262144 + 64, _Get_langstr(61), _Get_langstr(591), 0, $aenderungs_manager_GUI)
	EndIf
EndFunc   ;==>_aenderungsprotokolle_importieren

Func _Neuen_Changelogeintrag_erstellen()
	$Project_ISN = $Pfad_zur_Project_ISN
	$NewitemID = @MDAY & @MON & @YEAR & @HOUR & @MIN & @SEC & Random(0, 100, 1)
	$Items_String = IniRead($Pfad_zur_Project_ISN, $Changelog_Section, "items", "")
	$Items_String = $Items_String & $NewitemID & "|"
	IniWrite($Pfad_zur_Project_ISN, $Changelog_Section, "items", $Items_String)
	IniWrite($Pfad_zur_Project_ISN, $Changelog_Section, "text[" & $NewitemID & "]", "")
	IniWrite($Pfad_zur_Project_ISN, $Changelog_Section, "date[" & $NewitemID & "]", @YEAR & "/" & @MON & "/" & @MDAY)
	IniWrite($Pfad_zur_Project_ISN, $Changelog_Section, "version[" & $NewitemID & "]", IniRead($Project_ISN, "ISNAUTOITSTUDIO", "version", ""))

	If _ProjectISN_Config_Read("changelog_use_author_from_project", "false") = "true" Then
		IniWrite($Pfad_zur_Project_ISN, $Changelog_Section, "editor[" & $NewitemID & "]", _ProjectISN_Config_Read("author", ""))
	Else
		IniWrite($Pfad_zur_Project_ISN, $Changelog_Section, "editor[" & $NewitemID & "]", @UserName)
	EndIf

	_Aenderungsmanager_Aktualisiere_Liste()
	If _GUICtrlListView_GetItemCount($changelogmanager_listview) = 0 Then Return
	For $y = 0 To _GUICtrlListView_GetItemCount($changelogmanager_listview) - 1
		$Section_ID = _GUICtrlListView_GetItemText($changelogmanager_listview, $y, 6)
		If $Section_ID = $NewitemID Then
			_GUICtrlListView_SetItemSelected($changelogmanager_listview, $y, True, True)
			ExitLoop
		EndIf
	Next
	_changelogmanager_lade_eintrag()
	GUICtrlSetState($changelogmanager_betreff_input, $GUI_FOCUS)
EndFunc   ;==>_Neuen_Changelogeintrag_erstellen


Func _ProcessSuspend($Process)
	$processid = ProcessExists($Process)
	If $processid Then
		$ai_Handle = DllCall("kernel32.dll", 'int', 'OpenProcess', 'int', 0x1f0fff, 'int', False, 'int', $processid)
		$i_sucess = DllCall("ntdll.dll", "int", "NtSuspendProcess", "int", $ai_Handle[0])
		DllCall('kernel32.dll', 'ptr', 'CloseHandle', 'ptr', $ai_Handle)
		If IsArray($i_sucess) Then
			Return 1
		Else
			SetError(1)
			Return 0
		EndIf
	Else
		SetError(2)
		Return 0
	EndIf
EndFunc   ;==>_ProcessSuspend

Func _ProcessResume($Process)
	$processid = ProcessExists($Process)
	If $processid Then
		$ai_Handle = DllCall("kernel32.dll", 'int', 'OpenProcess', 'int', 0x1f0fff, 'int', False, 'int', $processid)
		$i_sucess = DllCall("ntdll.dll", "int", "NtResumeProcess", "int", $ai_Handle[0])
		DllCall('kernel32.dll', 'ptr', 'CloseHandle', 'ptr', $ai_Handle)
		If IsArray($i_sucess) Then
			Return 1
		Else
			SetError(1)
			Return 0
		EndIf
	Else
		SetError(2)
		Return 0
	EndIf
EndFunc   ;==>_ProcessResume

;===============================================================================
;
; Function Name:    _FileInUse()
; Description:      Checks if file is in use
; Syntax.........: _FileInUse($sFilename, $iAccess = 1)
; Parameter(s):     $sFilename = File name
; Parameter(s):     $iAccess = 0 = GENERIC_READ - other apps can have file open in readonly mode
;                   $iAccess = 1 = GENERIC_READ|GENERIC_WRITE - exclusive access to file,
;                   fails if file open in readonly mode by app
; Return Value(s):  1 - file in use (@error contains system error code)
;                   0 - file not in use
;                   -1 dllcall error (@error contains dllcall error code)
; Author:           Siao
; Modified          rover - added some additional error handling, access mode
; Remarks           _WinAPI_CreateFile() WinAPI.au3
;===============================================================================
Func _FileInUse($sFileName, $iAccess = 0)
	If _IsDir($sFileName) Then Return 0
	$sFileName = FileGetShortName($sFileName)
	Local $aRet, $hFile, $iError, $iDA
	Local Const $GENERIC_WRITE = 0x40000000
	Local Const $GENERIC_READ = 0x80000000
	Local Const $FILE_ATTRIBUTE_NORMAL = 0x80
	Local Const $OPEN_EXISTING = 3
	$iDA = $GENERIC_READ
	If BitAND($iAccess, 1) <> 0 Then $iDA = BitOR($GENERIC_READ, $GENERIC_WRITE)
	$aRet = DllCall("Kernel32.dll", "hwnd", "CreateFile", _
			"str", $sFileName, _ ;lpFileName
			"dword", $iDA, _ ;dwDesiredAccess
			"dword", 0x00000000, _ ;dwShareMode = DO NOT SHARE
			"dword", 0x00000000, _ ;lpSecurityAttributes = NULL
			"dword", $OPEN_EXISTING, _ ;dwCreationDisposition = OPEN_EXISTING
			"dword", $FILE_ATTRIBUTE_NORMAL, _ ;dwFlagsAndAttributes = FILE_ATTRIBUTE_NORMAL
			"hwnd", 0) ;hTemplateFile = NULL
	$iError = @error
	If @error Or IsArray($aRet) = 0 Then Return SetError($iError, 0, -1)
	$hFile = $aRet[0]
	If $hFile = -1 Then ;INVALID_HANDLE_VALUE = -1
		$aRet = DllCall("Kernel32.dll", "int", "GetLastError")
		;ERROR_SHARING_VIOLATION = 32 0x20
		;The process cannot access the file because it is being used by another process.
		If @error Or IsArray($aRet) = 0 Then Return SetError($iError, 0, 1)
		Return SetError($aRet[0], 0, 1)
	Else
		;close file handle
		DllCall("Kernel32.dll", "int", "CloseHandle", "hwnd", $hFile)
		Return SetError(@error, 0, 0)
	EndIf
EndFunc   ;==>_FileInUse









; #FUNCTION# ====================================================================================================================
; Name ..........: _GUICtrlListView_CreateArray
; Description ...: Creates a 2-dimensional array from a listview.
; Syntax ........: _GUICtrlListView_CreateArray($hListView[, $sDelimeter = '|'])
; Parameters ....: $hListView           - Control ID/Handle to the control
;                  $sDelimeter          - [optional] One or more characters to use as delimiters (case sensitive). Default is '|'.
; Return values .: Success - The array returned is two-dimensional and is made up of the following:
;                                $aArray[0][0] = Number of rows
;                                $aArray[0][1] = Number of columns

;                                $aArray[1][0] = 1st row, 1st column
;                                $aArray[1][1] = 1st row, 2nd column
;                                $aArray[1][2] = 1st row, 3rd column
;                                $aArray[n][0] = nth row, 1st column
;                                $aArray[n][1] = nth row, 2nd column
;                                $aArray[n][2] = nth row, 3rd column
; Author ........: guinness
; Remarks .......: GUICtrlListView.au3 should be included.
; Example .......: Yes
; ===============================================================================================================================
Func _GUICtrlListView_CreateArray($hListView, $sDelimeter = '|')
	If _GUICtrlListView_GetItemCount($hListView) = 0 Then Return
	Local $iColumnCount = _GUICtrlListView_GetColumnCount($hListView), $iDim = 0, $iItemCount = _GUICtrlListView_GetItemCount($hListView)
	If $sDelimeter = Default Then
		$sDelimeter = '|'
	EndIf

	Local $aColumns = 0, $aReturn[$iItemCount][$iColumnCount]

	For $i = 0 To $iItemCount - 1
		For $j = 0 To $iColumnCount - 1
			$aReturn[$i][$j] = _GUICtrlListView_GetItemText($hListView, $i, $j)
		Next
	Next
	Return SetError(Number($aReturn[0][0] = 0), 0, $aReturn)
EndFunc   ;==>_GUICtrlListView_CreateArray



Func _Erweiterte_Plugins_Erstelle_Menue($Liste = "")
	_GUICtrlODMenuItemDelete($Tools_menu_seperator)
	_GUICtrlODMenuItemDelete($Tools_menu_pluginitem1)
	_GUICtrlODMenuItemDelete($Tools_menu_pluginitem2)
	_GUICtrlODMenuItemDelete($Tools_menu_pluginitem3)
	_GUICtrlODMenuItemDelete($Tools_menu_pluginitem4)
	_GUICtrlODMenuItemDelete($Tools_menu_pluginitem5)
	_GUICtrlODMenuItemDelete($Tools_menu_pluginitem6)
	_GUICtrlODMenuItemDelete($Tools_menu_pluginitem7)
	_GUICtrlODMenuItemDelete($Tools_menu_pluginitem8)
	_GUICtrlODMenuItemDelete($Tools_menu_pluginitem9)
	_GUICtrlODMenuItemDelete($Tools_menu_pluginitem10)
	$Tools_menu_pluginitem1 = ""
	$Tools_menu_pluginitem2 = ""
	$Tools_menu_pluginitem3 = ""
	$Tools_menu_pluginitem4 = ""
	$Tools_menu_pluginitem5 = ""
	$Tools_menu_pluginitem6 = ""
	$Tools_menu_pluginitem7 = ""
	$Tools_menu_pluginitem8 = ""
	$Tools_menu_pluginitem9 = ""
	$Tools_menu_pluginitem10 = ""
	$Tools_menu_pluginitem1_exe = ""
	$Tools_menu_pluginitem2_exe = ""
	$Tools_menu_pluginitem3_exe = ""
	$Tools_menu_pluginitem4_exe = ""
	$Tools_menu_pluginitem5_exe = ""
	$Tools_menu_pluginitem6_exe = ""
	$Tools_menu_pluginitem7_exe = ""
	$Tools_menu_pluginitem8_exe = ""
	$Tools_menu_pluginitem9_exe = ""
	$Tools_menu_pluginitem10_exe = ""
	If $Liste = "" Then Return
	$Erweiterte_Plugins_Pfade = StringSplit($Liste, "|", 2)
	If Not IsArray($Erweiterte_Plugins_Pfade) Then Return
	If UBound($Erweiterte_Plugins_Pfade) - 1 > 0 Then $Tools_menu_seperator = _GUICtrlCreateODMenuItem("", $ISN_ToolsMenu)
	For $x = 0 To UBound($Erweiterte_Plugins_Pfade) - 1
		If $x > 9 Then ExitLoop ;Nur max 10 Advanced Plugins (Zero based)
		If $Erweiterte_Plugins_Pfade[$x] = "|" Then ContinueLoop
		If $Erweiterte_Plugins_Pfade[$x] = "" Then ContinueLoop
		$Pfad = StringTrimRight($Erweiterte_Plugins_Pfade[$x], StringLen($Erweiterte_Plugins_Pfade[$x]) - StringInStr($Erweiterte_Plugins_Pfade[$x], "\", 0, -1))
		Assign("Tools_menu_pluginitem" & Number($x + 1), _GUICtrlCreateODMenuItem(IniRead($Pfad & "plugin.ini", "plugin", "toolsmenudescription", IniRead($Pfad & "plugin.ini", "plugin", "name", _Get_langstr(962))), $ISN_ToolsMenu))
		Assign("Tools_menu_pluginitem" & Number($x + 1) & "_exe", $Erweiterte_Plugins_Pfade[$x])
		$icon = IniRead($Pfad & "plugin.ini", "plugin", "toolsmenuiconid", "193")
		If StringInStr($icon, ".ico") Then
			_GUICtrlODMenuItemSetIcon(Execute("$Tools_menu_pluginitem" & Number($x + 1)), $Pfad & $icon, 0)
		Else
			_GUICtrlODMenuItemSetIcon(Execute("$Tools_menu_pluginitem" & Number($x + 1)), $smallIconsdll, $icon)
		EndIf
	Next
EndFunc   ;==>_Erweiterte_Plugins_Erstelle_Menue





Func _RetrieveDirectoryChanges()

	AdlibUnRegister('_RetrieveDirectoryChanges')

	Local $aData, $aText, $aPrev[2] = [0, ''], $sPrev = ''

	$aData = StringSplit($RDC_sEvents, '|', 2)
	$RDC_sEvents = ''
	If Not IsArray($aData) Then
		Return
	EndIf
	For $i = 0 To UBound($aData)
		If $i < UBound($aData) Then
			If $aData[$i] = $sPrev Then
				ContinueLoop
			EndIf
			$sPrev = $aData[$i]
			$aText = StringSplit($aData[$i], '?', 2)
			If IsArray($aText) Then
;~				ConsoleWrite($aText[0] & ' - ' & $aText[1] & @CR)
				$LastRDCEventFilePath = $aText[1]

;~				ContinueLoop
				Switch Number($aText[0])
					Case 1 ; FILE_ACTION_ADDED
						AdlibRegister("_Update_Treeview")

;~ 					ConsoleWrite('DIRECTORY OR FILE MOVED' & @CR)

					Case 2 ; FILE_ACTION_REMOVED
						; Nothing
						AdlibRegister("_Update_Treeview")

;~ 					ConsoleWrite('FILE OR FOLDER removed' & @CR)

					Case 3 ; FILE_ACTION_MODIFIED
						; Nothing
					Case 4 ; FILE_ACTION_RENAMED_OLD_NAME
						; Nothing
					Case 5 ; FILE_ACTION_RENAMED_NEW_NAME
						AdlibRegister("_Update_Treeview")

;~ 					ConsoleWrite('FILE OR DIRECTORY RENAMED' & @CR)

				EndSwitch
			EndIf
		EndIf

		$aPrev = $aText
	Next

EndFunc   ;==>_RetrieveDirectoryChanges




Func _Is_GUI_in_Studiofenster($GUI_to_check = "")
	If $GUI_to_check = "" Then Return 0
	If $GUI_to_check = $Studiofenster Then Return 1

	$GUI_to_check_pos_Array = _WinGetPos($GUI_to_check)
	$Studiofenster_pos_Array = _WinGetPos($Studiofenster)
	If Not IsArray($GUI_to_check_pos_Array) Then Return
	If Not IsArray($Studiofenster_pos_Array) Then Return

	If $GUI_to_check_pos_Array[0] > $Studiofenster_pos_Array[0] And $GUI_to_check_pos_Array[1] > $Studiofenster_pos_Array[1] And ($GUI_to_check_pos_Array[0] + $GUI_to_check_pos_Array[2]) < ($Studiofenster_pos_Array[0] + $Studiofenster_pos_Array[2]) And ($GUI_to_check_pos_Array[1] + $GUI_to_check_pos_Array[3]) < ($Studiofenster_pos_Array[1] + $Studiofenster_pos_Array[3]) Then
		Return 1
	Else
		Return 0
	EndIf
EndFunc   ;==>_Is_GUI_in_Studiofenster





Func Listview_ColorConvert($iColor)
	Return BitOR(BitAND($iColor, 0x00FF00), BitShift(BitAND($iColor, 0x0000FF), -16), BitShift(BitAND($iColor, 0xFF0000), 16))
EndFunc   ;==>Listview_ColorConvert

Func _Pruefe_Ob_Drag_and_Drop_erlaubt_ist($Quelle = "", $Ziel = "", $copy_mode = 0)
	If $Quelle = "" Then Return 0
	If $Ziel = "" Then Return 0
	If $copy_mode = 1 Then Return 1
	If $Quelle = $Pfad_zur_Project_ISN Then Return 0
	If Not _WinAPI_PathIsDirectory($Ziel) Then Return 0
	If $Ziel = _ISN_Variablen_aufloesen($Projectfolder) Then Return 0
	If $Quelle = $Offenes_Projekt & "\" & IniRead($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "mainfile", "") Then Return 0

	Return 1
EndFunc   ;==>_Pruefe_Ob_Drag_and_Drop_erlaubt_ist


Func _Try_to_move_file_drag_and_Drop($Quelle = "", $Ziel = "", $copy_mode = 0)
	If _Pruefe_Ob_Drag_and_Drop_erlaubt_ist($Quelle, $Ziel, $copy_mode) = 0 Then Return
	Local $sDrive = "", $sDir = "", $sFileName = "", $sExtension = ""
	$Projektbaum_ist_bereit = 0 ;Sperre Projektbaum
	If $copy_mode = 1 Then
		$Dateiname = StringTrimLeft($Quelle, StringInStr($Quelle, "\", 0, -1))
		While FileExists($Ziel & "\" & $Dateiname)
			$aPathSplit = _PathSplit($Ziel & "\" & $Dateiname, $sDrive, $sDir, $sFileName, $sExtension)
			$Dateiname = $sFileName & " (" & _Get_langstr(373) & ")" & $sExtension
			If Not FileExists($Ziel & "\" & $Dateiname) Then ExitLoop
			Sleep(100)
		WEnd
		FileCopy($Quelle, $Ziel & "\" & $Dateiname)
		$Porjecttree_FileToSelect_after_Update = $Ziel & "\" & $Dateiname

	Else
		$aPathSplit = _PathSplit($Quelle, $sDrive, $sDir, $sFileName, $sExtension)

		$res = _ArraySearch($Datei_pfad, $Quelle)
		If $res <> -1 Then
			$alreadyopen = $res
		Else
			$alreadyopen = -1
		EndIf

		If $alreadyopen = -1 Then

			If _WinAPI_PathIsDirectory($Quelle) Then
				If $copy_mode = 0 Then
					DirMove($Quelle, $Ziel & "\", 1)
					$Porjecttree_FileToSelect_after_Update = $Ziel & "\" & $sFileName
				Else

				EndIf
			Else
				If $copy_mode = 0 Then
					FileMove($Quelle, $Ziel, 0)
					If $ShowFavoritesInProjecttree = "true" Then _ISN_Favorites_RefreshFilePath($Quelle, $Ziel)
					$Porjecttree_FileToSelect_after_Update = $Ziel & "\" & $sFileName & $sExtension
				Else

				EndIf
			EndIf
			$Projektbaum_ist_bereit = 1
		Else
			MsgBox(262144 + 16, _Get_langstr(25), StringTrimLeft($Quelle, StringInStr($Quelle, "\", 0, -1)) & " " & _Get_langstr(78), 0, $Studiofenster)
		EndIf
	EndIf
	$Projektbaum_ist_bereit = 1
	If $Studiomodus = 2 Then AdlibRegister("_Update_Treeview") ;Trigger Treeview Refresh in Editormode
EndFunc   ;==>_Try_to_move_file_drag_and_Drop



Func TreeCreateDragImage($hWnd, $hItem)
	If _GUICtrlTreeView_GetNormalImageList($hWnd) <> 0 Then Return _GUICtrlTreeView_CreateDragImage($hWnd, $hItem)
	Local $aItemRect = _GUICtrlTreeView_DisplayRect($hWnd, $hItem, True)
	Local $iImgW = $aItemRect[2] - $aItemRect[0]
	Local $iImgH = $aItemRect[3] - $aItemRect[1]
;~ 	ConsoleWrite($iImgW & " " & $iImgH & @CRLF)
	Local $hTreeDC = _WinAPI_GetDC($hWnd)
	Local $hMemDC = _WinAPI_CreateCompatibleDC($hTreeDC)
	Local $hMemBmp = _WinAPI_CreateCompatibleBitmap($hTreeDC, $iImgW, $iImgH)
	Local $hMemBmpOld = _WinAPI_SelectObject($hMemDC, $hMemBmp)
	_WinAPI_BitBlt($hMemDC, 0, 0, $iImgW, $iImgH, $hTreeDC, $aItemRect[0], $aItemRect[1], $SRCCOPY)
	_WinAPI_SelectObject($hMemDC, $hMemBmpOld)
	_WinAPI_ReleaseDC($hWnd, $hTreeDC)
	_WinAPI_DeleteDC($hMemDC)
	Local $hImgList = _GUIImageList_Create($iImgW, $iImgH, 6)
	_GUIImageList_Add($hImgList, $hMemBmp)
	_WinAPI_DeleteObject($hMemBmp)
	Return $hImgList
EndFunc   ;==>TreeCreateDragImage

Func DrawDragImage(ByRef $hControl, ByRef $aDrag)
	Local $tPOINT, $hDC
	$hDC = _WinAPI_GetWindowDC($hControl)
	$tPOINT = _WinAPI_GetMousePos(True, $hControl)
	_WinAPI_InvalidateRect($hControl)
	_GUIImageList_Draw($aDrag, 0, $hDC, DllStructGetData($tPOINT, "X") - 10, DllStructGetData($tPOINT, "Y") - 8)
	_WinAPI_ReleaseDC($hControl, $hDC)
EndFunc   ;==>DrawDragImage

Func TreeItemFromPoint($hWnd)
	Local $tMPos = _WinAPI_GetMousePos(True, $hWnd)
	Return _GUICtrlTreeView_HitTestItem($hWnd, DllStructGetData($tMPos, 1), DllStructGetData($tMPos, 2))
EndFunc   ;==>TreeItemFromPoint






Func _ISN_AutoIt_Studio_Dateien_und_Ordner_reorganisieren()
	;Dateien Reorganisieern
	;Unnötige Dateien sauber umsortieren bzw. löschen.
	;Falls dies aus berechtigungsgründen nicht möglich ist herscht halt Chaos im Data Ordner :P (Is aber auch kein Problem da die neuen Ordner und Daten eh über Updates eingespielt werden)

	;Alte Einträge aus der config.ini löschen
	If FileExists($Configfile) Then
		IniDelete($Configfile, "config", "VSplitter1X")
		IniDelete($Configfile, "config", "VSplitter2X")
		IniDelete($Configfile, "config", "HSplitter1Y")
		IniDelete($Configfile, "config", "HSplitter2Y")
		IniDelete($Configfile, "config", "isn_save_window_position")
		IniDelete($Configfile, "config", "studio_maximized")
		IniDelete($Configfile, "config", "studio_x")
		IniDelete($Configfile, "config", "studio_y")
		IniDelete($Configfile, "config", "studio_width")
		IniDelete($Configfile, "config", "studio_height")
	EndIf


	If _Directory_Is_Accessible(@ScriptDir & "\Data") Then

		;Update ISN Version to the windows registry (if the ISN was updated via the integrated updater) (admin required!)
		If IsAdmin() Then
			RegRead("HKEY_LOCAL_MACHINE\SOFTWARE\WOW6432Node\Microsoft\Windows\CurrentVersion\Uninstall\{7AAAE763-9EE4-448D-994F-94B52EEAA180}_is1", "DisplayVersion")
			If Not @error Then RegWrite("HKEY_LOCAL_MACHINE\SOFTWARE\WOW6432Node\Microsoft\Windows\CurrentVersion\Uninstall\{7AAAE763-9EE4-448D-994F-94B52EEAA180}_is1", "DisplayVersion", "REG_SZ", $Studioversion)

			RegRead("HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{7AAAE763-9EE4-448D-994F-94B52EEAA180}_is1", "DisplayVersion")
			If Not @error Then RegWrite("HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\{7AAAE763-9EE4-448D-994F-94B52EEAA180}_is1", "DisplayVersion", "REG_SZ", $Studioversion)
		EndIf
		;Datenübernaheme für den alten Au3Defs Ordner
		If FileExists(@ScriptDir & "\Data\Au3Defs") Then
			DirCreate(@ScriptDir & "\Data\Api\")
			FileMove(@ScriptDir & "\Data\Au3Defs\*.api", @ScriptDir & "\Data\Api\")
			If @error Then MsgBox(0, "Error", "Error while moving .api files from \Data\Au3Defs to \Data\Api!")
			DirCreate(@ScriptDir & "\Data\Properties\")
			FileMove(@ScriptDir & "\Data\Au3Defs\*.properties", @ScriptDir & "\Data\Properties\")
			If @error Then MsgBox(0, "Error", "Error while moving *.properties files from \Data\Au3Defs to \Data\Properties!")
			FileRecycle(@ScriptDir & "\Data\Au3Defs")
			If @error Then MsgBox(0, "Error", "Error while removing the \Data\Au3Defs folder!")
		EndIf

		;Obfuscator löschen -> Gibt es nicht mehr (wurde durch Au3Stripper ersetzt)
		If FileExists(@ScriptDir & "\Data\Obfuscator") Then
			FileRecycle(@ScriptDir & "\Data\Obfuscator")
			If @error Then MsgBox(0, "Error", "Error while removing the \Data\Obfuscator folder!")
		EndIf

		;Dbug Images
		If FileExists(@ScriptDir & "\Data\Dbug\IMAGES") Then
			FileRecycle(@ScriptDir & "\Data\Dbug\IMAGES")
			If @error Then MsgBox(0, "Error", "Error while removing the \Data\Dbug\IMAGES folder!")
		EndIf


		;Alte Hilfe löschen
		If FileExists(@ScriptDir & "\Data\ISNAutoitStudiHilfe.chm") Then
			FileRecycle(@ScriptDir & "\Data\ISNAutoitStudiHilfe.chm")
			If @error Then MsgBox(0, "Error", "Error while removing the file Data\ISNAutoitStudiHilfe.chm!")
		EndIf

		;Alte Testprojekt.zip löschen
		If FileExists(@ScriptDir & "\Data\testprojekt.zip") Then
			FileRecycle(@ScriptDir & "\Data\testprojekt.zip")
			If @error Then MsgBox(0, "Error", "Error while removing the file Data\testprojekt.zip!")
		EndIf

		;Au3info löschen
		If FileExists(@ScriptDir & "\Data\Au3Info.exe") Then FileRecycle(@ScriptDir & "\Data\Au3Info.exe")

		;alten updater löschen
		If FileExists(@ScriptDir & "\updater.exe") Then FileRecycle(@ScriptDir & "\updater.exe")

		If Not FileExists(@ScriptDir & "\portable.dat") Then
			;Au3 Stripper löschen -> Seit 1.06 nicht mehr im Paket
			If FileExists(@ScriptDir & "\Data\Au3Stripper") Then
				FileRecycle(@ScriptDir & "\Data\Au3Stripper")
				If @error Then MsgBox(0, "Error", "Error while removing the \Data\Au3Stripper folder!")
			EndIf

			;Tidy löschen -> Seit 1.06 nicht mehr im Paket
			If FileExists(@ScriptDir & "\Data\Tidy") Then
				FileRecycle(@ScriptDir & "\Data\Tidy")
				If @error Then MsgBox(0, "Error", "Error while removing the \Data\Tidy folder!")
			EndIf
		EndIf

		;Logo löschen
		If FileExists(@ScriptDir & "\Data\logo.jpg") Then FileRecycle(@ScriptDir & "\Data\logo.jpg")

		;checkboxes.bmp
		If FileExists(@ScriptDir & "\Data\checkboxes.bmp") Then FileRecycle(@ScriptDir & "\Data\checkboxes.bmp")

		;Autoit3Wrapper
		If FileExists(@ScriptDir & "\Data\AutoIt3Wrapper\AutoIt3Wrapper.exe") Then FileRecycle(@ScriptDir & "\Data\AutoIt3Wrapper\AutoIt3Wrapper.exe")
		If FileExists(@ScriptDir & "\Data\AutoIt3Wrapper.exe") Then FileRecycle(@ScriptDir & "\Data\AutoIt3Wrapper.exe")
		If FileExists(@ScriptDir & "\Data\AutoIt3Wrapper.ico") Then FileRecycle(@ScriptDir & "\Data\AutoIt3Wrapper.ico")

		;Test dll löschen
		If FileExists(@ScriptDir & "\Data\test.dll") Then FileRecycle(@ScriptDir & "\Data\test.dll")

		;alte aero_busy_Xl löschen
		If FileExists(@ScriptDir & "\Data\aero_busy_Xl.ani") Then FileRecycle(@ScriptDir & "\Data\aero_busy_Xl.ani")


		;Au3Check löschen
		If FileExists(@ScriptDir & "\Data\Au3Check.exe") Then FileRecycle(@ScriptDir & "\Data\Au3Check.exe")
		If FileExists(@ScriptDir & "\Data\Au3Check.dat") Then FileRecycle(@ScriptDir & "\Data\Au3Check.dat")

		;Alte Bilder löschen
		If FileExists(@ScriptDir & "\Data\Normal.jpg") Then FileRecycle(@ScriptDir & "\Data\Normal.jpg")
		If FileExists(@ScriptDir & "\Data\Press.jpg") Then FileRecycle(@ScriptDir & "\Data\Press.jpg")
		If FileExists(@ScriptDir & "\Data\Over.jpg") Then FileRecycle(@ScriptDir & "\Data\Over.jpg")
		If FileExists(@ScriptDir & "\Data\editormode.jpg") Then FileRecycle(@ScriptDir & "\Data\editormode.jpg")
		If FileExists(@ScriptDir & "\Data\logo.bmp") Then FileRecycle(@ScriptDir & "\Data\logo.bmp")
		If FileExists(@ScriptDir & "\Data\logoHD.jpg") Then FileRecycle(@ScriptDir & "\Data\logoHD.jpg")
		If FileExists(@ScriptDir & "\Data\isi360.bmp") Then FileRecycle(@ScriptDir & "\Data\isi360.bmp")
		If FileExists(@ScriptDir & "\Data\troph0.jpg") Then FileRecycle(@ScriptDir & "\Data\troph0.jpg")
		If FileExists(@ScriptDir & "\Data\troph1.jpg") Then FileRecycle(@ScriptDir & "\Data\troph1.jpg")
		If FileExists(@ScriptDir & "\Data\troph2.jpg") Then FileRecycle(@ScriptDir & "\Data\troph2.jpg")
		If FileExists(@ScriptDir & "\Data\troph3.jpg") Then FileRecycle(@ScriptDir & "\Data\troph3.jpg")
		If FileExists(@ScriptDir & "\Data\troph1a.jpg") Then FileRecycle(@ScriptDir & "\Data\troph1a.jpg")
		If FileExists(@ScriptDir & "\Data\troph2a.jpg") Then FileRecycle(@ScriptDir & "\Data\troph2a.jpg")
		If FileExists(@ScriptDir & "\Data\troph3a.jpg") Then FileRecycle(@ScriptDir & "\Data\troph3a.jpg")
		If FileExists(@ScriptDir & "\Data\plugin.jpg") Then FileRecycle(@ScriptDir & "\Data\plugin.jpg")
		If FileExists(@ScriptDir & "\Data\Plugins\formstudio2\plugin.jpg") Then FileRecycle(@ScriptDir & "\Data\Plugins\formstudio2\plugin.jpg")
		If FileExists(@ScriptDir & "\Data\Plugins\fileviewer\plugin.jpg") Then FileRecycle(@ScriptDir & "\Data\Plugins\fileviewer\plugin.jpg")
		If FileExists(@ScriptDir & "\Data\plugin.png") Then FileRecycle(@ScriptDir & "\Data\plugin.png")
		If FileExists(@ScriptDir & "\Data\windown.jpg") Then FileRecycle(@ScriptDir & "\Data\windown.jpg")
		If FileExists(@ScriptDir & "\Data\wintop.jpg") Then FileRecycle(@ScriptDir & "\Data\wintop.jpg")
		If FileExists(@ScriptDir & "\Data\row_bottom.jpg") Then FileRecycle(@ScriptDir & "\Data\row_bottom.jpg")

		;Plugins bereinigen
		If FileExists(@ScriptDir & "\Data\Plugins\formstudio2\data\smallIcons.dll") Then FileRecycle(@ScriptDir & "\Data\Plugins\formstudio2\data\smallIcons.dll")
		If FileExists(@ScriptDir & "\Data\Plugins\formstudio2\data\control_editor.png") Then FileRecycle(@ScriptDir & "\Data\Plugins\formstudio2\data\control_editor.png")
		If FileExists(@ScriptDir & "\Data\Plugins\formstudio2\data\blue2.jpg") Then FileRecycle(@ScriptDir & "\Data\Plugins\formstudio2\data\blue2.jpg")
		If FileExists(@ScriptDir & "\Data\Plugins\formstudio2\data\left.jpg") Then FileRecycle(@ScriptDir & "\Data\Plugins\formstudio2\data\left.jpg")
		If FileExists(@ScriptDir & "\Data\Plugins\formstudio2\data\top.jpg") Then FileRecycle(@ScriptDir & "\Data\Plugins\formstudio2\data\top.jpg")
		If FileExists(@ScriptDir & "\Data\Plugins\formstudio2\formstudio2.exe") Then FileRecycle(@ScriptDir & "\Data\Plugins\formstudio2\formstudio2.exe")
		If FileExists(@ScriptDir & "\Data\Plugins\fileviewer\fileviewer.exe") Then FileRecycle(@ScriptDir & "\Data\Plugins\fileviewer\fileviewer.exe")

		;Temp AutoIt3.exe from Updater
		If FileExists($Arbeitsverzeichnis & "\Data\Cache\AutoIt3.exe") Then FileDelete($Arbeitsverzeichnis & "\Data\Cache\AutoIt3.exe")

		;Old .exe files (were repleced with .a3x files)
		If FileExists(@ScriptDir & "\Autoit_Studio_Helper.exe") Then FileRecycle(@ScriptDir & "\Autoit_Studio_Helper.exe")
		If FileExists(@ScriptDir & "\update_installer.exe") Then FileRecycle(@ScriptDir & "\update_installer.exe")
		If FileExists(@ScriptDir & "\Data\ISN_Adme.exe") Then FileRecycle(@ScriptDir & "\Data\ISN_Adme.exe")
		If FileExists(@ScriptDir & "\Data\ISN_cmd.exe") Then FileRecycle(@ScriptDir & "\Data\ISN_cmd.exe")

		;MFC71.dll
		If FileExists(@ScriptDir & "\MFC71.dll") Then FileRecycle(@ScriptDir & "\MFC71.dll")

		;Delete possible source files, if compiled
		If not FileExists(@ScriptDir & "\Autoit_Studio.au3") Then
			If FileExists(@ScriptDir & "\Data\EasyHotKey.cpp") Then FileRecycle(@ScriptDir & "\Data\EasyHotKey.cpp")
			If FileExists(@ScriptDir & "\Data\Plugins\formstudio2\Forms") Then FileRecycle(@ScriptDir & "\Data\Plugins\formstudio2\Forms")
			If FileExists(@ScriptDir & "\Data\Plugins\formstudio2\Includes") Then FileRecycle(@ScriptDir & "\Data\Plugins\formstudio2\Includes")
			If FileExists(@ScriptDir & "\Data\Plugins\fileviewer\Includes") Then FileRecycle(@ScriptDir & "\Data\Plugins\fileviewer\Includes")
		EndIf


	EndIf
	Return 1
EndFunc   ;==>_ISN_AutoIt_Studio_Dateien_und_Ordner_reorganisieren

Func _ISN_Pfeil_ID_aus_smallicons_DLL()
	If $ISN_Dark_Mode = "true" Or $WindowBackgroundIsDark Then
		Return 1922
	Else
		Return 1910
	EndIf
EndFunc   ;==>_ISN_Pfeil_ID_aus_smallicons_DLL

Func _GUICtrlStatusBar_SetColor($hWnd, $sText = "", $iPart = 0, $iColor = 0, $iBkColor = -1)
	;Author: rover - modified ownerdraw version of _GUICtrlStatusBar_SetText_ISN() from GuiStatusBar.au3
	;Includes RGB2BGR() - Author: Siao - <a href='http://www.autoitscript.com/forum/index.php?s=&showtopic=57161&view=findpost&p=433593' class='bbc_url' title=''>http://www.autoitscript.com/forum/index.php?s=&showtopic=57161&view=findpost&p=433593</a>
	;sets itmData element of statusbar DRAWITEMSTRUCT with pointer to struct with text and colour for part number
;~     If $Debug_SB Then _GUICtrlStatusBar_ValidateClassName($hWnd)
	Local $Ret, $tStruct, $pStruct, $iBuffer
	; In Microsoft Windows XP and earlier, the text for each part is limited to 127 characters.
	; This limitation has been removed in Windows Vista.
	; set sufficiently large buffer for use with Vista (can exceed XP limit of 128 chars)
	$tStruct = DllStructCreate("wchar Text[512];dword Color;dword BkColor;dword Trans")
	Switch $iBkColor
		Case -1
			DllStructSetData($tStruct, "Trans", 1)
		Case Else
			$iBkColor = BitAND(BitShift(String(Binary($iBkColor)), 8), 0xFFFFFF)
			DllStructSetData($tStruct, "Trans", 0)
			DllStructSetData($tStruct, "BkColor", $iBkColor)
	EndSwitch
	$iColor = BitAND(BitShift(String(Binary($iColor)), 8), 0xFFFFFF) ; From RGB2BGR() Author: Siao
	DllStructSetData($tStruct, "Text", $sText)
	DllStructSetData($tStruct, "Color", $iColor)
	$pStruct = DllStructGetPtr($tStruct)
	If _GUICtrlStatusBar_IsSimple($hWnd) Then $iPart = $SB_SIMPLEID
	;FOR INTERNAL STATUSBARS ONLY
;~     If _WinAPI_InProcess($hWnd, $__ghSBLastWnd) Then
	$Ret = _SendMessage($hWnd, $SB_SETTEXTW, BitOR($iPart, $SBT_OWNERDRAW), $pStruct, 0, "wparam", "ptr")
	Return $tStruct ; returns struct to global variable
;~     EndIf
	Return 0
EndFunc   ;==>_GUICtrlStatusBar_SetColor


Func _Show_Bugtracker()
	ShellExecute("https://www.isnetwork.at/bugtracker/index.php?project=0&do=toplevel&switch=1")
EndFunc   ;==>_Show_Bugtracker


Func _ISN_Automatische_Speicherung_Sekundenevent()
	If $Offenes_Projekt = "" Then Return
	If _GUICtrlTab_GetItemCount($htab) = 0 Then Return
	If $Automatische_Speicherung_Aktiv <> "true" Then
		AdlibUnRegister("_ISN_Automatische_Speicherung_Sekundenevent")
		Return
	EndIf

	If $Automatische_Speicherung_eingabecounter = -1 Then Return
	If $Automatische_Speicherung_Modus <> "2" Then
		AdlibUnRegister("_ISN_Automatische_Speicherung_Sekundenevent")
		Return
	EndIf


	$Automatische_Speicherung_eingabecounter = $Automatische_Speicherung_eingabecounter + 1 ;Zähle...

	If $Automatische_Speicherung_eingabecounter * 1000 > _TimeToTicks($Automatische_Speicherung_Eingabe_Stunden, $Automatische_Speicherung_Eingabe_Minuten, $Automatische_Speicherung_Eingabe_Sekunden) Then
		_ISN_Automatische_Speicherung_starten() ;Automatische speicherung ausführen da keine Eingabe erfolgt ist
	EndIf

EndFunc   ;==>_ISN_Automatische_Speicherung_Sekundenevent


Func _ISN_Automatische_Speicherung_starten()
	If $Automatische_Speicherung_Aktiv <> "true" Then
		AdlibUnRegister("_ISN_Automatische_Speicherung_starten")
		Return
	EndIf
	If $Offenes_Projekt = "" Then Return
	If _GUICtrlTab_GetItemCount($htab) = 0 Then Return

	_Write_ISN_Debug_Console("AutoSave initiated [" & $Automatische_Speicherung_eingabecounter & " secounds without an input]...", 1)
	_Write_log(_Get_langstr(1084), "368DB6")

	Local $Nur_Skripttabs_sichern = 0
	If $Automatische_Speicherung_Nur_Skript_Tabs_Sichern = "true" Then $Nur_Skripttabs_sichern = 1

	If $Automatische_Speicherung_Eingabe_Nur_einmal_sichern = "true" Then
		$Automatische_Speicherung_eingabecounter = -1
	Else
		$Automatische_Speicherung_eingabecounter = 0 ;reset
	EndIf

	If $Automatische_Speicherung_Nur_aktuellen_Tabs_Sichern = "true" Then
		_try_to_save_file(_GUICtrlTab_GetCurFocus($htab), 0, $Nur_Skripttabs_sichern)
	Else
		_Save_All_tabs($Nur_Skripttabs_sichern, 0)
	EndIf


EndFunc   ;==>_ISN_Automatische_Speicherung_starten


Func _erstelle_neues_temporaeres_skript($Erweiterung = $Autoitextension)
	If $Offenes_Projekt = "" Then Return
	If $Studiomodus = "2" Then Return
	Local $Pfad = ""
	Local $Dateinummerierung = 1
	Local $Dateiname = ""
	Local $dateihandle
	$Pfad = _ISN_Variablen_aufloesen(_ProjectISN_Config_Read("temp_script_path", "%projectdir%\Temp"))
	$Pfad = _WinAPI_PathRemoveBackslash($Pfad)
	If $Pfad = "" Then Return
	If DirCreate($Pfad) = 0 Then Return ;Fehler -> Return

	$Dateiname = _ProjectISN_Config_Read("temp_script_name", "Tempscript_%count%")
	If Not StringInStr($Dateiname, "%count%") Then Return ;Kein %count% -> Return

	;Zähle nach Daten
	For $Dateinummerierung = 1 To 999 Step +1
		If Not FileExists($Pfad & "\" & StringReplace($Dateiname, "%count%", $Dateinummerierung) & "." & $Erweiterung) Then ExitLoop
	Next

	;Skript erstellen
	$Pfad = $Pfad & "\" & StringReplace($Dateiname, "%count%", $Dateinummerierung) & "." & $Erweiterung

	If $autoit_editor_encoding = "2" Then
		$dateihandle = FileOpen($Pfad, 2 + $FO_UTF8_NOBOM)
	Else
		$dateihandle = FileOpen($Pfad, 2)
	EndIf

	If $dateihandle = -1 Then
		MsgBox(0, "Error", "Unable to create new file. Maybe you do not have write access to this folder!")
		Return
	EndIf
	FileWriteLine($dateihandle, ";" & StringReplace($Dateiname, "%count%", $Dateinummerierung) & "." & $Erweiterung)
	FileClose($dateihandle)

	;_Update_Treeview()

	Try_to_opten_file($Pfad)
	_GUICtrlTVExplorer_Expand($hWndTreeview, $Pfad)
EndFunc   ;==>_erstelle_neues_temporaeres_skript

Func _Pruefe_ob_sich_Datei_im_Temp_Ordner_befindet($Dateipfad = "")
	If $Studiomodus = "2" Then Return
	Local $Pfad = ""
	$Pfad = _ISN_Variablen_aufloesen(_ProjectISN_Config_Read("temp_script_path", "%projectdir%\Temp"))
	$Pfad = _WinAPI_PathRemoveBackslash($Pfad)
	If Not FileExists($Pfad) Then Return
	If $Pfad = "" Then Return
	If StringInStr($Dateipfad, _WinAPI_PathAddBackslash($Pfad)) Then ;Datei ist im Temp Ordner (Für Temporäre Daten)
		Switch _ProjectISN_Config_Read("temp_script_delete_mode", "2") ;1 lösche, 2 fragen, 3 nichts tun

			Case "1"
				FileDelete($Dateipfad)
				;_Update_Treeview()

			Case "2"
				$Antwort = MsgBox(4 + 32 + 262144, _Get_langstr(48), StringReplace(_Get_langstr(1103), "%1", StringTrimLeft($Dateipfad, StringInStr($Dateipfad, "\", 0, -1))), 0, $Studiofenster)
				If $Antwort = 6 Then
					FileDelete($Dateipfad)
					;_Update_Treeview()
				EndIf
		EndSwitch
	EndIf
EndFunc   ;==>_Pruefe_ob_sich_Datei_im_Temp_Ordner_befindet



Func _Autocomplete_nach_Enter($sci_handle = "")
	If $sci_handle = "" Then Return
	If $AutoEnd_Keywords <> "true" Then Return
	If $sci_handle = $Debug_log Then Return ;In der Console nicht anwenden
	If $Can_open_new_tab = 0 Then Return ;ISN arbeitet gerade

	Local $Regionname = ""

	$Zeile_vor_Enter = Sci_GetLineFromPos($sci_handle, Sci_GetCurrentPos($sci_handle))
	$Line_Text = Sci_GetLine($sci_handle, $Zeile_vor_Enter - 1)
	$Line_Text = StringReplace($Line_Text, @CRLF, "")

	If $Line_Text = "" Then Return

	$Striped_Zeile = StringStripWS(StringLower($Line_Text), 3)

	If $Striped_Zeile = "" Then Return
	$Striped_Zeile_Ohne_Kommentare = $Striped_Zeile
	If StringInStr($Striped_Zeile_Ohne_Kommentare, ";") Then $Striped_Zeile_Ohne_Kommentare = StringStripWS(StringTrimRight($Striped_Zeile_Ohne_Kommentare, (StringLen($Striped_Zeile_Ohne_Kommentare) - StringInStr($Striped_Zeile_Ohne_Kommentare, ";", 0, -1) + 1)), 3)
	$Symbole_in_Zeile = StringRegExp($Striped_Zeile, "^#|^_|^;")
	$erstes_wort = StringMatchAndGet($Striped_Zeile, "^[iI]f|^[eE]lseif|^[fF]unc|^[fF]or|^[wW]hile|^[sS]witch|^[dD]o|^[sS]elect|^[wW]ith|^#[cC]s|^#[rR]egion|^#[cC]omments-start")
	If $erstes_wort = "" Then $erstes_wort = StringTrimRight($Line_Text, StringInStr($Line_Text, " "))
	$Erstes_Wort_col = StringInStr($Line_Text, $erstes_wort)

;~ Sci_Undo($Sci_handle)
;~ $Position_im_Text_vor_Enter = Sci_GetCurrentPos($Sci_handle)
;~ $Col_Position_im_Text_vor_Enter = (Sci_GetCurrentPos($Sci_handle) - Sci_GetLineStartPos($Sci_handle, Sci_GetLineFromPos($Sci_handle, Sci_GetCurrentPos($Sci_handle)))) + 1
;~ Sci_Redo($Sci_handle)

	$Tabs = _ISN_Scintilla_GenerateIndentForNextLine($sci_handle, 0, $Zeile_vor_Enter - 1)

	$keyword_gefunden = 0
	If StringInStr($Striped_Zeile_Ohne_Kommentare, "if ") Then $keyword_gefunden = 1
	If StringInStr($Striped_Zeile_Ohne_Kommentare, "elseif ") Then $keyword_gefunden = 1
	If StringInStr($Striped_Zeile_Ohne_Kommentare, "while ") Then $keyword_gefunden = 1
	If StringLower($Striped_Zeile_Ohne_Kommentare) = "do" Then $keyword_gefunden = 1
	If StringInStr($Striped_Zeile_Ohne_Kommentare, "switch ") Then $keyword_gefunden = 1
	If StringInStr($Striped_Zeile_Ohne_Kommentare, "for ") Then $keyword_gefunden = 1
	If StringLower($Striped_Zeile_Ohne_Kommentare) = "select" Then $keyword_gefunden = 1
	If StringInStr($Striped_Zeile_Ohne_Kommentare, "func ") Then $keyword_gefunden = 1
	If StringInStr($Striped_Zeile_Ohne_Kommentare, "with ") Then $keyword_gefunden = 1
	If StringLower($Striped_Zeile_Ohne_Kommentare) = "#cs" Then $keyword_gefunden = 1
	If StringLower($Striped_Zeile_Ohne_Kommentare) = "#comments-start" Then $keyword_gefunden = 1
	If StringInStr($Striped_Zeile_Ohne_Kommentare, "#region") Then
		$keyword_gefunden = 1
		$Regionname = StringRegExp(StringStripWS($Line_Text, 3), '(?im)^#region ([^\r\n]*)', 3)
		If @error Or Not IsArray($Regionname) Then
			$Regionname = ""
		Else
			$Regionname = " " & $Regionname[0]
		EndIf
	EndIf
	If $keyword_gefunden = 0 Then Return ;Kein gültiges Keywoard für Autocomplete gefunden

	If StringInStr($Striped_Zeile_Ohne_Kommentare, "if ") Then
		If StringInStr($Striped_Zeile_Ohne_Kommentare, "return") Or StringInStr($Striped_Zeile_Ohne_Kommentare, "exit") Or StringInStr($Striped_Zeile_Ohne_Kommentare, "exitloop") Or StringInStr($Striped_Zeile_Ohne_Kommentare, "then ") Then Return ;Bei einzelnen Zeilen überspringen
	EndIf


	_Autoinsertion_Smart_Korrektur($sci_handle, $erstes_wort, $Striped_Zeile_Ohne_Kommentare, $Zeile_vor_Enter, $Tabs)

;~ Sci_AddLines($Sci_handle, @crlf&$Tabs&"EndIf",$Zeile_vor_Enter+1)
	$LineBreak = @LF



	Switch StringLower(StringStripWS($erstes_wort, 3))

		Case "if"
			If _Autoinsertion_nach_Enter_Suche_gueltiges_End_Keywoard($sci_handle, $Zeile_vor_Enter, StringStripWS($erstes_wort, 3), $Erstes_Wort_col) = False Then Sci_InsertText($sci_handle, Sci_GetLineEndPos($sci_handle, $Zeile_vor_Enter), $LineBreak & $Tabs & "EndIf")

		Case "elseif"
			If _Autoinsertion_nach_Enter_Suche_gueltiges_End_Keywoard($sci_handle, $Zeile_vor_Enter, StringStripWS($erstes_wort, 3), $Erstes_Wort_col) = False Then Sci_InsertText($sci_handle, Sci_GetLineEndPos($sci_handle, $Zeile_vor_Enter), $LineBreak & $Tabs & "EndIf")

		Case "while"
			If _Autoinsertion_nach_Enter_Suche_gueltiges_End_Keywoard($sci_handle, $Zeile_vor_Enter, StringStripWS($erstes_wort, 3), $Erstes_Wort_col) = False Then Sci_InsertText($sci_handle, Sci_GetLineEndPos($sci_handle, $Zeile_vor_Enter), $LineBreak & $Tabs & "Wend")

		Case "for"
			If _Autoinsertion_nach_Enter_Suche_gueltiges_End_Keywoard($sci_handle, $Zeile_vor_Enter, StringStripWS($erstes_wort, 3), $Erstes_Wort_col) = False Then Sci_InsertText($sci_handle, Sci_GetLineEndPos($sci_handle, $Zeile_vor_Enter), $LineBreak & $Tabs & "Next")

		Case "switch"
			If _Autoinsertion_nach_Enter_Suche_gueltiges_End_Keywoard($sci_handle, $Zeile_vor_Enter, StringStripWS($erstes_wort, 3), $Erstes_Wort_col) = False Then
				Sci_InsertText($sci_handle, Sci_GetLineEndPos($sci_handle, $Zeile_vor_Enter), $LineBreak & $Tabs & "EndSwitch")
				Sci_InsertText($sci_handle, Sci_GetLineEndPos($sci_handle, $Zeile_vor_Enter), $LineBreak & $Tabs & _ISN_Scintilla_GenerateCustomIndentLine() & "Case " & $LineBreak)
				Sci_SetCurrentPos($sci_handle, Sci_GetLineEndPos($sci_handle, $Zeile_vor_Enter + 1))
			EndIf

		Case "select"
			If _Autoinsertion_nach_Enter_Suche_gueltiges_End_Keywoard($sci_handle, $Zeile_vor_Enter, StringStripWS($erstes_wort, 3), $Erstes_Wort_col) = False Then
				Sci_InsertText($sci_handle, Sci_GetLineEndPos($sci_handle, $Zeile_vor_Enter), $LineBreak & $Tabs & "EndSelect")
				Sci_InsertText($sci_handle, Sci_GetLineEndPos($sci_handle, $Zeile_vor_Enter), $LineBreak & $Tabs & _ISN_Scintilla_GenerateCustomIndentLine() & "Case " & $LineBreak)
				Sci_SetCurrentPos($sci_handle, Sci_GetLineEndPos($sci_handle, $Zeile_vor_Enter + 1))
			EndIf

		Case "do"
			If _Autoinsertion_nach_Enter_Suche_gueltiges_End_Keywoard($sci_handle, $Zeile_vor_Enter, StringStripWS($erstes_wort, 3), $Erstes_Wort_col) = False Then Sci_InsertText($sci_handle, Sci_GetLineEndPos($sci_handle, $Zeile_vor_Enter), $LineBreak & $Tabs & "Until")

		Case "func"
			If _Autoinsertion_nach_Enter_Suche_gueltiges_End_Keywoard($sci_handle, $Zeile_vor_Enter, StringStripWS($erstes_wort, 3), $Erstes_Wort_col) = False Then Sci_InsertText($sci_handle, Sci_GetLineEndPos($sci_handle, $Zeile_vor_Enter), $LineBreak & $Tabs & "EndFunc")

		Case "with"
			If _Autoinsertion_nach_Enter_Suche_gueltiges_End_Keywoard($sci_handle, $Zeile_vor_Enter, StringStripWS($erstes_wort, 3), $Erstes_Wort_col) = False Then Sci_InsertText($sci_handle, Sci_GetLineEndPos($sci_handle, $Zeile_vor_Enter), $LineBreak & $Tabs & "EndWith")

		Case "#cs"
			If _Autoinsertion_nach_Enter_Suche_gueltiges_End_Keywoard($sci_handle, $Zeile_vor_Enter, StringStripWS($erstes_wort, 3), $Erstes_Wort_col) = False Then Sci_InsertText($sci_handle, Sci_GetLineEndPos($sci_handle, $Zeile_vor_Enter), $LineBreak & $Tabs & "#ce")

		Case "#comments-start"
			If _Autoinsertion_nach_Enter_Suche_gueltiges_End_Keywoard($sci_handle, $Zeile_vor_Enter, StringStripWS($erstes_wort, 3), $Erstes_Wort_col) = False Then Sci_InsertText($sci_handle, Sci_GetLineEndPos($sci_handle, $Zeile_vor_Enter), $LineBreak & $Tabs & "#comments-end")

		Case "#region"
			If _Autoinsertion_nach_Enter_Suche_gueltiges_End_Keywoard($sci_handle, $Zeile_vor_Enter, StringStripWS($erstes_wort, 3), $Erstes_Wort_col) = False Then Sci_InsertText($sci_handle, Sci_GetLineEndPos($sci_handle, $Zeile_vor_Enter), $LineBreak & $Tabs & "#EndRegion" & $Regionname)

	EndSwitch

EndFunc   ;==>_Autocomplete_nach_Enter


Func _Autoinsertion_Funktion_besitzt_Klammern($func = "", $Striped_Zeile_Ohne_Kommentare = "")
	If StringInStr($func, "(") Then $func = StringTrimRight($func, StringLen($func) - StringInStr($func, "(") + 1)
	If StringInStr($func, "=") Then $func = StringTrimRight($func, StringLen($func) - StringInStr($func, "=") + 1)
	$func = StringStripWS($func, 3)
	If $func = "if" And StringInStr($Striped_Zeile_Ohne_Kommentare, "(") Then Return True
	If $func = "elseif" And StringInStr($Striped_Zeile_Ohne_Kommentare, "(") Then Return True
	If $func = "while" And StringInStr($Striped_Zeile_Ohne_Kommentare, "(") Then Return True
	If $func = "for" And StringInStr($Striped_Zeile_Ohne_Kommentare, "(") Then Return True
	If $func = "switch" And StringInStr($Striped_Zeile_Ohne_Kommentare, "(") Then Return True
	If $func = "select" And StringInStr($Striped_Zeile_Ohne_Kommentare, "(") Then Return True
	If $func = "" Then Return False
	$SCI_sCallTipFoundIndices_km = ArraySearchAll($SCI_sCallTip_Array, $func, 0, 0, 1)
	If IsArray($SCI_sCallTipFoundIndices_km) Then
		$str = $SCI_sCallTip_Array[$SCI_sCallTipFoundIndices_km[0]]
		If StringInStr($str, "(") And StringInStr($str, ")") Then Return True
	EndIf
	Return False
EndFunc   ;==>_Autoinsertion_Funktion_besitzt_Klammern


Func _Autoinsertion_Smart_Korrektur($sci_handle = "", $erstes_wort = "", $Striped_Zeile_Ohne_Kommentare = "", $Zeile_vor_Enter = 0, $Tabs = 0)
	$Then_gefunden = StringMatchAndGet($Striped_Zeile_Ohne_Kommentare, "then$")
	$Then_gefunden = StringLower($Then_gefunden)
	If StringRight(StringStripWS($Striped_Zeile_Ohne_Kommentare, 8), 1) = "_" Then $Then_gefunden = 1
	$Korrekturwert = 0


	Switch StringLower($erstes_wort)

		Case "if"
			If StringLower($Striped_Zeile_Ohne_Kommentare) = "if" Then
				Sci_InsertText($sci_handle, Sci_GetLineStartPos($sci_handle, $Zeile_vor_Enter - 1) + StringLen($Tabs) + StringLen($Striped_Zeile_Ohne_Kommentare) + $Korrekturwert, " 1")
				$Korrekturwert = $Korrekturwert + StringLen(" 1")
			EndIf
			If $Then_gefunden = "" Then Sci_InsertText($sci_handle, Sci_GetLineStartPos($sci_handle, $Zeile_vor_Enter - 1) + StringLen($Tabs) + StringLen($Striped_Zeile_Ohne_Kommentare) + $Korrekturwert, " Then")
			If $Korrekturwert <> 0 Then Return

		Case "elseif"
			If StringLower($Striped_Zeile_Ohne_Kommentare) = "elseif" Then
				Sci_InsertText($sci_handle, Sci_GetLineStartPos($sci_handle, $Zeile_vor_Enter - 1) + StringLen($Tabs) + StringLen($Striped_Zeile_Ohne_Kommentare) + $Korrekturwert, " 1")
				$Korrekturwert = $Korrekturwert + StringLen(" 1")
			EndIf
			If $Then_gefunden = "" Then Sci_InsertText($sci_handle, Sci_GetLineStartPos($sci_handle, $Zeile_vor_Enter - 1) + StringLen($Tabs) + StringLen($Striped_Zeile_Ohne_Kommentare) + $Korrekturwert, " Then")
			If $Korrekturwert <> 0 Then Return


		Case "while"
			If StringLower($Striped_Zeile_Ohne_Kommentare) = "while" Then
				Sci_InsertText($sci_handle, Sci_GetLineStartPos($sci_handle, $Zeile_vor_Enter - 1) + StringLen($Tabs) + StringLen($Striped_Zeile_Ohne_Kommentare), " 1")
				Return
			EndIf


		Case "func" ;Auto Klammern auf bzw. zu
			If Not StringInStr(Sci_GetLine($sci_handle, $Zeile_vor_Enter - 1), "(") And Not StringInStr(Sci_GetLine($sci_handle, $Zeile_vor_Enter - 1), ")") Then
				Sci_InsertText($sci_handle, Sci_GetLineStartPos($sci_handle, $Zeile_vor_Enter - 1) + StringLen($Tabs) + StringLen($Striped_Zeile_Ohne_Kommentare) + $Korrekturwert, "(")
				$Korrekturwert = $Korrekturwert + StringLen("(")
			EndIf

			If Not StringInStr(Sci_GetLine($sci_handle, $Zeile_vor_Enter - 1), ")") Then
				Sci_InsertText($sci_handle, Sci_GetLineStartPos($sci_handle, $Zeile_vor_Enter - 1) + StringLen($Tabs) + StringLen($Striped_Zeile_Ohne_Kommentare) + $Korrekturwert, ")")
				$Korrekturwert = $Korrekturwert + StringLen(")")
			EndIf


	EndSwitch



	If _Autoinsertion_Funktion_besitzt_Klammern(StringLower($erstes_wort), $Striped_Zeile_Ohne_Kommentare) = True Then ;Auto Klammern auf bzw. zu
		If Not StringInStr(Sci_GetLine($sci_handle, $Zeile_vor_Enter - 1), "(") And Not StringInStr(Sci_GetLine($sci_handle, $Zeile_vor_Enter - 1), ")") Then
			Sci_InsertText($sci_handle, Sci_GetLineStartPos($sci_handle, $Zeile_vor_Enter - 1) + StringLen($Tabs) + StringLen($Striped_Zeile_Ohne_Kommentare) + $Korrekturwert, "(")
			$Korrekturwert = $Korrekturwert + StringLen("(")
		EndIf

		If Not StringInStr(Sci_GetLine($sci_handle, $Zeile_vor_Enter - 1), ")") Then
			Sci_InsertText($sci_handle, Sci_GetLineStartPos($sci_handle, $Zeile_vor_Enter - 1) + StringLen($Tabs) + StringLen($Striped_Zeile_Ohne_Kommentare) + $Korrekturwert, ")")
			$Korrekturwert = $Korrekturwert + StringLen(")")
		EndIf
	EndIf

EndFunc   ;==>_Autoinsertion_Smart_Korrektur


Func _Autoinsertion_nach_Enter_Suche_gueltiges_End_Keywoard($sci_handle = "", $Startline = 0, $erstes_wort = "if", $Erstes_Wort_col = 0)
	If $sci_handle = "" Then Return True
	Local $End_Word = ""


	For $zeile = $Startline To Sci_GetLineCount($sci_handle)
		$textline = Sci_GetLine($sci_handle, $zeile)

;~ for $x=0 to ubound($KeyWordList)-1
		Switch StringLower($erstes_wort)

			Case "if"
				$End_Word = "endif"
				If StringInStr($textline, "if ") And StringInStr($textline, "if ") = $Erstes_Wort_col Then Return False
				If StringInStr($textline, "endif") And StringInStr($textline, "endif") = $Erstes_Wort_col Then Return True
				If StringInStr($textline, "endfunc") Then Return False ;Nur bis zum Ende einer Funktion suchen

			Case "elseif"
				$End_Word = "endif"
				If StringInStr($textline, "elseif ") And StringInStr($textline, "elseif ") = $Erstes_Wort_col Then Return False
				If StringInStr($textline, "endif") And StringInStr($textline, "endif") = $Erstes_Wort_col Then Return True
				If StringInStr($textline, "endfunc") Then Return False ;Nur bis zum Ende einer Funktion suchen

			Case "while"
				$End_Word = "wend"
				If StringInStr($textline, "while ") And StringInStr($textline, "while ") = $Erstes_Wort_col Then Return False
				If StringInStr($textline, "wend") And StringInStr($textline, "wend") = $Erstes_Wort_col Then Return True
				If StringInStr($textline, "endfunc") Then Return False ;Nur bis zum Ende einer Funktion suchen

			Case "with"
				$End_Word = "endwith"
				If StringInStr($textline, "with ") And StringInStr($textline, "with ") = $Erstes_Wort_col Then Return False
				If StringInStr($textline, "endwith") And StringInStr($textline, "endwith") = $Erstes_Wort_col Then Return True
				If StringInStr($textline, "endfunc") Then Return False ;Nur bis zum Ende einer Funktion suchen

			Case "switch"
				$End_Word = "endswitch"
				If StringInStr($textline, "switch ") And StringInStr($textline, "switch ") = $Erstes_Wort_col Then Return False
				If StringInStr($textline, "endswitch") And StringInStr($textline, "endswitch") = $Erstes_Wort_col Then Return True
				If StringInStr($textline, "endfunc") Then Return False ;Nur bis zum Ende einer Funktion suchen

			Case "for"
				$End_Word = "next"
				If StringInStr($textline, "for ") And StringInStr($textline, "for ") = $Erstes_Wort_col Then Return False
				If StringInStr($textline, "next") And StringInStr($textline, "next") = $Erstes_Wort_col Then Return True
				If StringInStr($textline, "endfunc") Then Return False ;Nur bis zum Ende einer Funktion suchen

			Case "do"
				$End_Word = "until"
				If StringInStr($textline, "do") And StringInStr($textline, "do") = $Erstes_Wort_col Then Return False
				If StringInStr($textline, "until") And StringInStr($textline, "until") = $Erstes_Wort_col Then Return True
				If StringInStr($textline, "endfunc") Then Return False ;Nur bis zum Ende einer Funktion suchen

			Case "select"
				$End_Word = "endselect"
				If StringInStr($textline, "select") And StringInStr($textline, "select") = $Erstes_Wort_col Then Return False
				If StringInStr($textline, "endselect") And StringInStr($textline, "endselect") = $Erstes_Wort_col Then Return True
				If StringInStr($textline, "endfunc") Then Return False ;Nur bis zum Ende einer Funktion suchen

			Case "func"
				$End_Word = "endfunc"
				If StringInStr($textline, "endfunc") Then Return True
				If StringInStr($textline, "func ") Then Return False

			Case "#comments-start"
				$End_Word = "#comments-end"
				If StringInStr($textline, "#comments-end") And StringInStr($textline, "#comments-end") = $Erstes_Wort_col Then Return True
				If StringInStr($textline, "#comments-start") Then Return False

			Case "#cs"
				$End_Word = "#ce"
				If StringInStr($textline, "#ce") And StringInStr($textline, "#ce") = $Erstes_Wort_col Then Return True
				If StringInStr($textline, "#cs") Then Return False

			Case "#region"
				$End_Word = "#endregion"
				If StringInStr($textline, "#endregion") And StringInStr($textline, "#endregion") = $Erstes_Wort_col Then Return True
				If StringInStr($textline, "#region") Then Return False


		EndSwitch
;~    if ubound($KeyWordList)-1 <> "func" AND StringInStr($textline,"endfunc") then return false
		If StringInStr($textline, $End_Word) Then
			If StringInStr($textline, $End_Word) < $Erstes_Wort_col Then Return False
		EndIf

;~ next


	Next
	Return False ;Wenn letzte Zeile erreicht wurde
EndFunc   ;==>_Autoinsertion_nach_Enter_Suche_gueltiges_End_Keywoard



; #FUNCTION# ====================================================================================================================
; Name ..........: StringMatchAndGet
; Description ...: A simple function for finding words with regular expression
; Syntax ........: StringMatchAndGet($String, $Pattern)
; Parameters ....: $String              - A string to use
;                  $Pattern             - A pattern to find any word.
; Return values .: None
; Author ........: kcvinu
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func StringMatchAndGet($String, $Pattern)
	Local $result
	Local $MatchArray = StringRegExp($String, $Pattern, 1)
	If @error Then
		$MatchArray = " "
	Else
		$result = $MatchArray[0]
	EndIf
	Return $result
EndFunc   ;==>StringMatchAndGet



Func _Adlib_ISN_Ram_bereinigen()
	_ReduceMemory(@AutoItPID) ;Ram sparen ;)
EndFunc   ;==>_Adlib_ISN_Ram_bereinigen

Func _GuiCtrlGetFocus($GuiRef)
	Local $hWnd = ControlGetHandle($GuiRef, "", ControlGetFocus($GuiRef))
	Local $result = DllCall("user32.dll", "int", "GetDlgCtrlID", "hwnd", $hWnd)
	Return $result[0]
EndFunc   ;==>_GuiCtrlGetFocus

Func _QuickView_GUI_nach_Dummycontrol_ausrichten()
	$QuickView_Dummy_Control_pos_Array = _ControlGetPos($Studiofenster, "", $QuickView_Dummy_Control)
	If Not IsArray($QuickView_Dummy_Control_pos_Array) Then Return
	_WinAPI_SetWindowPos($QuickView_GUI, $HWND_TOP, $QuickView_Dummy_Control_pos_Array[0], $QuickView_Dummy_Control_pos_Array[1], $QuickView_Dummy_Control_pos_Array[2], $QuickView_Dummy_Control_pos_Array[3], $SWP_NOACTIVATE + $SWP_NOOWNERZORDER)
EndFunc   ;==>_QuickView_GUI_nach_Dummycontrol_ausrichten



Func _QuickView_GUI_Resize()
	$QuickView_GUI_client_array = _WinGetClientSize($QuickView_GUI)
	If Not IsArray($QuickView_GUI_client_array) Then Return

	_SendMessage($QuickView_GUI, $WM_SETREDRAW, False)

	ControlMove($QuickView_GUI, "", $quickview_tab_dummy, 0, 0, $QuickView_GUI_client_array[0], ($QuickView_Tab_height * 1)) ;In the first try, do it with one row, to pretict the row count for the control
	ControlMove($QuickView_GUI, "", $quickview_tab_dummy, 0, 0, $QuickView_GUI_client_array[0], ($QuickView_Tab_height * _GUICtrlTab_GetRowCount($quickview_tab_dummy)))
	$quickview_tab_DisplayRect = _GUICtrlTab_GetDisplayRect($quickview_tab_dummy)
	If Not IsArray($quickview_tab_DisplayRect) Then
		If $Toggle_Leftside = 0 Then
			_SendMessage($QuickView_GUI, $WM_SETREDRAW, True)
			_WinAPI_RedrawWindow($QuickView_GUI) ;Redraw the main GUI
		EndIf
		Return
	EndIf
	Local $Y_after_tab_dummy = $quickview_tab_DisplayRect[3] + $Splitter_Rand + $Splitter_Rand
	_WinAPI_SetWindowPos($Programm_log, $HWND_TOP, 0, $Y_after_tab_dummy, $QuickView_GUI_client_array[0], $QuickView_GUI_client_array[1] - ($quickview_tab_DisplayRect[3] + $Splitter_Rand), $SWP_NOACTIVATE)
	_WinAPI_SetWindowPos($QuickView_Notes_Scintilla, $HWND_TOP, 0, $Y_after_tab_dummy, $QuickView_GUI_client_array[0], $QuickView_GUI_client_array[1] - ($quickview_tab_DisplayRect[3] + $Splitter_Rand), $SWP_NOACTIVATE)


	;ToDoListe Elemente resizen
	GUICtrlSetPos($quickview_todolist_new_button, Default, $Y_after_tab_dummy, Default, Default)
	$quickview_todolist_new_button_pos = _ControlGetPos($QuickView_GUI, "", $quickview_todolist_new_button)
	If Not IsArray($quickview_todolist_new_button_pos) Then Return
	GUICtrlSetPos($quickview_todolist_finish_button, Default, $Y_after_tab_dummy, Default, Default)
	GUICtrlSetPos($quickview_todolist_reset_button, Default, $Y_after_tab_dummy, Default, Default)
	GUICtrlSetPos($quickview_todolist_sep1, Default, $Y_after_tab_dummy - 2, Default, Default)
	GUICtrlSetPos($quickview_todolist_sep2, Default, $Y_after_tab_dummy - 2, Default, Default)
	GUICtrlSetPos($quickview_todolist_down_button, Default, $Y_after_tab_dummy, Default, Default)
	GUICtrlSetPos($quickview_todolist_up_button, Default, $Y_after_tab_dummy, Default, Default)
	GUICtrlSetPos($quickview_todolist_delete_button, Default, $Y_after_tab_dummy, Default, Default)
	GUICtrlSetPos($quickview_todolist_fullmode_button, $QuickView_GUI_client_array[0] - ($quickview_todolist_new_button_pos[2] + $Splitter_Rand), $Y_after_tab_dummy, Default, Default)


	GUICtrlSetPos($quick_view_ToDoList_Listview, Default, $quickview_todolist_new_button_pos[1] + $quickview_todolist_new_button_pos[3] + $Splitter_Rand, $QuickView_GUI_client_array[0] - 6, $QuickView_GUI_client_array[1] - ($quickview_todolist_new_button_pos[1] + $quickview_todolist_new_button_pos[3] + $Splitter_Rand))
	$quick_view_ToDoList_Listview_Pos_Array = _ControlGetPos($QuickView_GUI, "", $quick_view_ToDoList_Listview)
	If Not IsArray($quick_view_ToDoList_Listview_Pos_Array) Then
		If $Toggle_Leftside = 0 Then
			_SendMessage($QuickView_GUI, $WM_SETREDRAW, True)
			_WinAPI_RedrawWindow($QuickView_GUI) ;Redraw the main GUI
		EndIf
		Return
	EndIf
	_GUICtrlListView_BeginUpdate($quick_view_ToDoList_Listview)
	_GUICtrlListView_SetColumnWidth($quick_view_ToDoList_Listview, 2, ($quick_view_ToDoList_Listview_Pos_Array[2] / 100) * 65)
	_GUICtrlListView_SetColumnWidth($quick_view_ToDoList_Listview, 4, ($quick_view_ToDoList_Listview_Pos_Array[2] / 100) * 25)
	_GUICtrlListView_EndUpdate($quick_view_ToDoList_Listview)

	;UDF-Manager
	GUICtrlSetPos($quick_view_udfexplorer_searchbar, 3, $Y_after_tab_dummy + $Splitter_Rand, $QuickView_GUI_client_array[0] - 9 - (25 * $DPI), 23 * $DPI)
	GUICtrlSetPos($quick_view_udfexplorer_ManagerButton, $QuickView_GUI_client_array[0] - ($quickview_todolist_new_button_pos[2] + $Splitter_Rand), $Y_after_tab_dummy + $Splitter_Rand - 1, Default, Default)
	$quick_view_udfexplorer_searchbar_pos = _ControlGetPos($QuickView_GUI, "", $quick_view_udfexplorer_searchbar)
	If Not IsArray($quick_view_udfexplorer_searchbar_pos) Then
		If $Toggle_Leftside = 0 Then
			_SendMessage($QuickView_GUI, $WM_SETREDRAW, True)
			_WinAPI_RedrawWindow($QuickView_GUI) ;Redraw the main GUI
		EndIf
		Return
	EndIf
	GUICtrlSetPos($quick_view_udfexplorer_treeview, 0, $quick_view_udfexplorer_searchbar_pos[1] + $quick_view_udfexplorer_searchbar_pos[3] + $Splitter_Rand, $QuickView_GUI_client_array[0], $QuickView_GUI_client_array[1] - ($quick_view_udfexplorer_searchbar_pos[1] + $quick_view_udfexplorer_searchbar_pos[3] + $Splitter_Rand))
	_ISN_ReposClearButton_in_Input($quick_view_udfexplorer_searchbar, $quick_view_udfexplorer_searchbar_ClearButton)

	;QuickViewPlugin
	Local $PluginIndex = _Type3_Plugin_Find_Window($Plugin_Placeholder_QuickView)
	If $PluginIndex <> -1 Then
		_WinAPI_SetWindowPos($Type3_Plugin_Handles[$PluginIndex][0], $HWND_TOP, 0, $Y_after_tab_dummy, $QuickView_GUI_client_array[0], $QuickView_GUI_client_array[1] - ($quickview_tab_DisplayRect[3] + $Splitter_Rand), $SWP_NOACTIVATE)
		_SendMessage($Type3_Plugin_Handles[$PluginIndex][0], $WM_ENTERSIZEMOVE)
		_SendMessage($Type3_Plugin_Handles[$PluginIndex][0], $WM_EXITSIZEMOVE)
		_WinAPI_RedrawWindow($Type3_Plugin_Handles[$PluginIndex][0])
	EndIf

	;Unlock GUI
	If $Toggle_Leftside = 0 Then
		_SendMessage($QuickView_GUI, $WM_SETREDRAW, True)
		_WinAPI_RedrawWindow($QuickView_GUI) ;Redraw the main GUI
	EndIf

EndFunc   ;==>_QuickView_GUI_Resize



Func _ToDo_Manager_GUI_Resize()
	;ToDoListe Spalten resize
	$ToDoList_Listview_Pos_Array = _ControlGetPos($ToDoList_Manager, "", $ToDoList_Listview)
	If Not IsArray($ToDoList_Listview_Pos_Array) Then Return
	_GUICtrlListView_BeginUpdate($ToDoList_Listview)
	_GUICtrlListView_SetColumnWidth($ToDoList_Listview, 2, ($ToDoList_Listview_Pos_Array[2] / 100) * 40)
	_GUICtrlListView_SetColumnWidth($ToDoList_Listview, 3, ($ToDoList_Listview_Pos_Array[2] / 100) * 35)
	_GUICtrlListView_SetColumnWidth($ToDoList_Listview, 4, ($ToDoList_Listview_Pos_Array[2] / 100) * 20)
	_GUICtrlListView_EndUpdate($ToDoList_Listview)
EndFunc   ;==>_ToDo_Manager_GUI_Resize


Func _QuickView_Save_Notes()
	_Write_ISN_Debug_Console("Saving QuickView Notes...", $ISN_Debug_Console_Errorlevel_Info, $ISN_Debug_Console_No_Linebreak)
	$Notes_Text = Sci_GetText($QuickView_Notes_Scintilla)
	If $Notes_Text <> "" Then
		$Notes_Text = StringReplace($Notes_Text, @CRLF, "[BREAK]")
		$Notes_Text = _ANSI2UNICODE($Notes_Text)
		IniWrite($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "quickview_notes", $Notes_Text)
		If Not @error Then
			_Write_ISN_Debug_Console("done", $ISN_Debug_Console_Errorlevel_Info, $ISN_Debug_Console_Linebreak, $ISN_Debug_Console_No_Title, $ISN_Debug_Console_No_Time)
		Else
			_Write_ISN_Debug_Console("ERROR", $ISN_Debug_Console_Errorlevel_Critical, $ISN_Debug_Console_Linebreak, $ISN_Debug_Console_No_Title, $ISN_Debug_Console_No_Time)
		EndIf
	EndIf
EndFunc   ;==>_QuickView_Save_Notes

Func _QuickView_Load_Notes_from_ISN()
	_Write_ISN_Debug_Console("Loading QuickView Notes...", $ISN_Debug_Console_Errorlevel_Info, $ISN_Debug_Console_No_Linebreak)
	$Notes_Text = _IniReadRaw($Pfad_zur_Project_ISN, "ISNAUTOITSTUDIO", "quickview_notes", "")
	If $Notes_Text <> "" Then
		$Notes_Text = StringReplace($Notes_Text, "[BREAK]", @CRLF)
		SCI_SetTextEx($QuickView_Notes_Scintilla, $Notes_Text)
	Else
		Sci_DelLines($QuickView_Notes_Scintilla)
	EndIf
	_Write_ISN_Debug_Console("done", $ISN_Debug_Console_Errorlevel_Info, $ISN_Debug_Console_Linebreak, 1, 1)
EndFunc   ;==>_QuickView_Load_Notes_from_ISN


Func _QuickView_Tab_Event()

	Local $QuickView_Selected_Tab = _GUICtrlTab_GetCurSel($quickview_tab_dummy)
	If $QuickView_Selected_Tab = -1 Then Return
	If $QuickView_Current_Tab = $QuickView_Selected_Tab Then Return

	$QuickView_Plugin = _Type3_Plugin_Find_Window($Plugin_Placeholder_QuickView)

	If $Toggle_Leftside = 0 Then _SendMessage($QuickView_GUI, $WM_SETREDRAW, False)

	Switch $QuickView_Selected_Tab

		Case $QuickView_Log_Tab_Button ;Log
			GUICtrlSetState($quickview_log_tabitem, $GUI_SHOW)
			ControlHide($QuickView_GUI, "", $QuickView_Notes_Scintilla)
			ControlShow($QuickView_GUI, "", $Programm_log)
			If $QuickView_Plugin <> -1 Then _WinAPI_SetWindowPos($Type3_Plugin_Handles[$QuickView_Plugin][0], 0, 0, 0, 0, 0, $SWP_NOACTIVATE + $SWP_NOZORDER + $SWP_NOREDRAW + $SWP_HIDEWINDOW + $SWP_NOMOVE + $SWP_NOREPOSITION)
			_GUICtrlRichEdit_SetSel($Programm_log, -1, -1, True)
			$QuickView_Current_Tab = $QuickView_Log_Tab_Button


		Case $QuickView_Code_Tab_Button ;Notes
			GUICtrlSetState($quickview_code_tabitem, $GUI_SHOW)
			ControlHide($QuickView_GUI, "", $Programm_log)
			ControlShow($QuickView_GUI, "", $QuickView_Notes_Scintilla)
			If $QuickView_Plugin <> -1 Then _WinAPI_SetWindowPos($Type3_Plugin_Handles[$QuickView_Plugin][0], 0, 0, 0, 0, 0, $SWP_NOACTIVATE + $SWP_NOZORDER + $SWP_NOREDRAW + $SWP_HIDEWINDOW + $SWP_NOMOVE + $SWP_NOREPOSITION)
			$QuickView_Current_Tab = $QuickView_Code_Tab_Button
			Sci_SetCurrentPos($QuickView_Notes_Scintilla, 0)


		Case $QuickView_ToDoList_Tab_Button ;ToDo List
			GUICtrlSetState($quickview_TodoList_tabitem, $GUI_SHOW)
			ControlHide($QuickView_GUI, "", $Programm_log)
			ControlHide($QuickView_GUI, "", $QuickView_Notes_Scintilla)
			If $QuickView_Plugin <> -1 Then _WinAPI_SetWindowPos($Type3_Plugin_Handles[$QuickView_Plugin][0], 0, 0, 0, 0, 0, $SWP_NOACTIVATE + $SWP_NOZORDER + $SWP_NOREDRAW + $SWP_HIDEWINDOW + $SWP_NOMOVE + $SWP_NOREPOSITION)
			$QuickView_Current_Tab = $QuickView_ToDoList_Tab_Button

		Case $QuickView_UDFExplorer_Tab_Button ;UDF Explorer
;~ 		   if $quick_view_udfexplorer_treeview = "" then
;~ 			   GUISwitch($QuickView_GUI,_GUICtrlTab_SetCurFocus($quickview_tab,3)&GUICtrlRead ($quickview_tab, 1))
;~ 			   $quick_view_udfexplorer_treeview = _GUICtrlTVExplorer_Create(_ISN_Variablen_aufloesen($UDFs_Folder), 3, 50, 293, 247, BitOR($TVS_HASBUTTONS, $TVS_HASLINES, $TVS_LINESATROOT, $TVS_SHOWSELALWAYS), $WS_EX_CLIENTEDGE, $TV_FLAG_SHOWFILESEXTENSION + $TV_FLAG_SHOWFILES + $TV_FLAG_SHOWFOLDERICON + $TV_FLAG_SHOWFILEICON + $TV_FLAG_SHOWLIKEEXPLORER, "_Projecttree_event", "", "", 0)
;~ 			   GUICtrlSetResizing($quick_view_udfexplorer_treeview, 354)
;~ 			   $quick_view_udfexplorer_htreeview = GUICtrlGetHandle($quick_view_udfexplorer_treeview)
;~ 			   GUICtrlSetFont($quick_view_udfexplorer_treeview, $treefont_size, 400, 0, $treefont_font) ;Schrift
;~ 			   GUICtrlSetColor($quick_view_udfexplorer_treeview, $treefont_colour) ;Farbe
;~ 			   GUICtrlSetState($quick_view_udfexplorer_treeview, $GUI_DROPACCEPTED)
;~ 			   if $Tools_UDFManager_ShowAutoItIncludes = "true" then _TV_AddVirtualDrive(_TV_Index($quick_view_udfexplorer_treeview), _ISN_Variablen_aufloesen($PathToAutoItIncludes), _Get_langstr(1074))
;~ 			   _GUICtrlTVExplorer_Expand($quick_view_udfexplorer_treeview)
;~ 			   $RDC_UDFs_Thread = _RDC_Create(_ISN_Variablen_aufloesen($UDFs_Folder), 1, BitOR($FILE_NOTIFY_CHANGE_FILE_NAME, $FILE_NOTIFY_CHANGE_DIR_NAME), 0, $Studiofenster)
;~ 			   AdlibRegister("_ISN_UDFManager_BackgroundScanForAcInput", 1)
;~ 			Endif

			GUICtrlSetState($quickview_udfexplorer_tabitem, $GUI_SHOW)
			ControlHide($QuickView_GUI, "", $Programm_log)
			ControlHide($QuickView_GUI, "", $QuickView_Notes_Scintilla)
			If $QuickView_Plugin <> -1 Then _WinAPI_SetWindowPos($Type3_Plugin_Handles[$QuickView_Plugin][0], 0, 0, 0, 0, 0, $SWP_NOACTIVATE + $SWP_NOZORDER + $SWP_NOREDRAW + $SWP_HIDEWINDOW + $SWP_NOMOVE + $SWP_NOREPOSITION)
			$QuickView_Current_Tab = $QuickView_UDFExplorer_Tab_Button
			AdlibRegister("_ISN_UDFManager_BackgroundScanForAcInput", 1)


		Case $QuickView_Plugin_Button
			GUICtrlSetState($quickview_code_tabitem, $GUI_SHOW)
			ControlHide($QuickView_GUI, "", $Programm_log)
			ControlHide($QuickView_GUI, "", $QuickView_Notes_Scintilla)
			If $Offenes_Projekt = "" Then ContinueCase
			$QuickView_Current_Tab = $QuickView_Plugin_Button

			If _Type3_Plugin_Find_Window($Plugin_Placeholder_QuickView) = -1 Then
				If _Pruefe_auf_Type3_Plugin($Plugin_Placeholder_QuickView) <> -1 Then Return ;Platzhalter für Plugin
			Else
				;Exists
				_QuickView_GUI_Resize()
				_WinAPI_SetWindowPos($Type3_Plugin_Handles[$QuickView_Plugin][0], 0, 0, 0, 0, 0, $SWP_NOACTIVATE + $SWP_NOZORDER + $SWP_NOMOVE + $SWP_NOREPOSITION + $SWP_NOOWNERZORDER + $SWP_SHOWWINDOW)
			EndIf



	EndSwitch
	_QuickView_GUI_Resize()

	;Unlock GUI (if quickview is visible)
	If $Toggle_Leftside = 0 Then
		_SendMessage($QuickView_GUI, $WM_SETREDRAW, True)
		_WinAPI_RedrawWindow($QuickView_GUI) ;Redraw the main GUI
	EndIf


EndFunc   ;==>_QuickView_Tab_Event

Func _QuickView_Refresh_Layout()
	_QuickView_Refresh_Tab_Buttons()
	$QuickView_Current_Tab = -1
	_QuickView_Tab_Event()
EndFunc   ;==>_QuickView_Refresh_Layout

Func _QuickView_Refresh_Tab_Buttons()

	;First reset all
	Local $Tabname = ""
	$QuickView_Log_Tab_Button = -1
	$QuickView_Code_Tab_Button = -1
	$QuickView_ToDoList_Tab_Button = -1
	_GUICtrlTab_DeleteAllItems($quickview_tab_dummy)
	If $QuickView_Layout = "" Then $QuickView_Layout = $QuickView_Default_Layout
	$QuickView_Layout_array = StringSplit($QuickView_Layout, "|", 2)
	If IsArray($QuickView_Layout_array) Then

		;Create needed Buttons
		For $Count = 0 To UBound($QuickView_Layout_array) - 1
			If $QuickView_Layout_array[$Count] = "" Then ContinueLoop
			Switch $QuickView_Layout_array[$Count]

				Case "#qv_log#"
					$Tabname = ""
					If $QuickView_NoTextinTabs <> "true" Then $Tabname = _Get_langstr(1263)
					$QuickView_Log_Tab_Button = _GUICtrlTab_InsertItem($quickview_tab_dummy, _GUICtrlTab_GetItemCount($quickview_tab_dummy), $Tabname, 118)

				Case "#qv_notes#"
					$Tabname = ""
					If $QuickView_NoTextinTabs <> "true" Then $Tabname = _Get_langstr(1390)
					$QuickView_Code_Tab_Button = _GUICtrlTab_InsertItem($quickview_tab_dummy, _GUICtrlTab_GetItemCount($quickview_tab_dummy), $Tabname, 117)

				Case "#qv_todo#"
					$Tabname = ""
					If $QuickView_NoTextinTabs <> "true" Then $Tabname = _Get_langstr(1262)
					$QuickView_ToDoList_Tab_Button = _GUICtrlTab_InsertItem($quickview_tab_dummy, _GUICtrlTab_GetItemCount($quickview_tab_dummy), $Tabname, 116)

				Case "#qv_udfexplorer#"
					$Tabname = ""
					If $QuickView_NoTextinTabs <> "true" Then $Tabname = _Get_langstr(1404)
					$QuickView_UDFExplorer_Tab_Button = _GUICtrlTab_InsertItem($quickview_tab_dummy, _GUICtrlTab_GetItemCount($quickview_tab_dummy), $Tabname, 124)



				Case "#qv_pluginslot1#"
					$Plugin_EXE = _IniVirtual_Read($Type3_Plugins_Virtual_INI, $Plugin_Placeholder_QuickView, "exe", "")
					If $Plugin_EXE <> "" Then
						$Plugin_Root = StringTrimRight($Plugin_EXE, StringLen($Plugin_EXE) - StringInStr($Plugin_EXE, "\", 0, -1) + 1)
						$Plugin_INI_Pfad = $Plugin_Root & "\plugin.ini"
						$Tabname = IniRead($Plugin_INI_Pfad, "plugin", "tabdescription", "")
						If $Tabname = "" Then $Tabname = IniRead($Plugin_INI_Pfad, "plugin", "name", _Get_langstr(1389))
						If $QuickView_NoTextinTabs = "true" Then $Tabname = ""
						$icon = IniRead($Plugin_INI_Pfad, "plugin", "toolsmenuiconid", "193")
						$QuickView_Plugin_Button = _GUICtrlTab_InsertItem($quickview_tab_dummy, _GUICtrlTab_GetItemCount($quickview_tab_dummy), $Tabname, 0)
						If StringInStr($icon, ".ico") Then
							_GUICtrlTab_SetItemImage($quickview_tab_dummy, $QuickView_Plugin_Button, _GUIImageList_AddIcon($hImage, $Plugin_Root & "\" & $icon, 0))
						Else
							_GUICtrlTab_SetItemImage($quickview_tab_dummy, $QuickView_Plugin_Button, _GUIImageList_AddIcon($hImage, $smallIconsdll, $icon - 1))
						EndIf
					EndIf



			EndSwitch
		Next
	EndIf

	If $QuickView_NoTextinTabs = "true" Then
		_GUICtrlTab_SetMinTabWidth($quickview_tab_dummy, 15 * $DPI)
	Else
		_GUICtrlTab_SetMinTabWidth($quickview_tab_dummy, -1)
	EndIf


EndFunc   ;==>_QuickView_Refresh_Tab_Buttons









Func HttpPost($sURL, $sData = "")
	Local $oHTTP = ObjCreate("WinHttp.WinHttpRequest.5.1")

	$oHTTP.Open("POST", $sURL, False)
	If (@error) Then Return SetError(1, 0, 0)

	$oHTTP.SetRequestHeader("Content-Type", "application/x-www-form-urlencoded")

	$oHTTP.Send($sData)
	If (@error) Then Return SetError(2, 0, 0)

	If ($oHTTP.Status <> $HTTP_STATUS_OK) Then Return SetError(3, 0, 0)

	Return SetError(0, 0, $oHTTP.ResponseText)
EndFunc   ;==>HttpPost

Func HttpGet($sURL, $sData = "")
	Local $oHTTP = ObjCreate("WinHttp.WinHttpRequest.5.1")

	$oHTTP.Open("GET", $sURL & "?" & $sData, False)
	If (@error) Then Return SetError(1, 0, 0)

	$oHTTP.Send()
	If (@error) Then Return SetError(2, 0, 0)

	If ($oHTTP.Status <> $HTTP_STATUS_OK) Then Return SetError(3, 0, 0)

	Return SetError(0, 0, $oHTTP.ResponseText)
EndFunc   ;==>HttpGet


Func _ToDo_Liste_Kategoriefarbe_nach_Item_herausfinden($Listview = "", $item = "")
	If $Offenes_Projekt = "" Then Return $Fenster_Hintergrundfarbe
	If Not _ist_windows_vista_oder_hoeher() Then Return $Fenster_Hintergrundfarbe
	$group_index = _GUICtrlListView_GetItemGroupID($Listview, $item)
	$ToDo_List_categories = _IniReadRaw($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", "categories", "")
	If $ToDo_List_categories = "" Then Return $Fenster_Hintergrundfarbe ;Wenn keine Kategorien, dann stopp
	$ToDo_List_categories_split = StringSplit($ToDo_List_categories, "|", 2)
	If Not IsArray($ToDo_List_categories_split) Then Return $Fenster_Hintergrundfarbe
	Return _IniReadRaw($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $ToDo_List_categories_split[$group_index] & "_color", "")
EndFunc   ;==>_ToDo_Liste_Kategoriefarbe_nach_Item_herausfinden

Func _ToDo_Liste_leeren()
	_GUICtrlListView_BeginUpdate($ToDoList_Listview)
	_GUICtrlListView_BeginUpdate($quick_view_ToDoList_Listview)
	_GUICtrlListView_RemoveAllGroups($quick_view_ToDoList_Listview)
	_GUICtrlListView_DeleteAllItems(GUICtrlGetHandle($quick_view_ToDoList_Listview))
	_GUICtrlListView_RemoveAllGroups($ToDoList_Listview)
	_GUICtrlListView_DeleteAllItems(GUICtrlGetHandle($ToDoList_Listview))
	_GUICtrlListView_EndUpdate($ToDoList_Listview)
	_GUICtrlListView_EndUpdate($quick_view_ToDoList_Listview)
EndFunc   ;==>_ToDo_Liste_leeren


Func _QuickView_ToDo_Liste_neu_einlesen()
	_ToDo_Liste_leeren()
	If Not _ist_windows_vista_oder_hoeher() Then Return


	;Zuerst Aufgabenkategorien einlesen
	$ToDo_List_categories = IniRead($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", "categories", "")
	If $ToDo_List_categories = "" Then Return ;Wenn keine Kategorien, dann stopp

	$ToDo_List_categories_split = StringSplit($ToDo_List_categories, "|", 2)
	If Not IsArray($ToDo_List_categories_split) Then Return

	Local $Text_der_Kategorie = ""
	Local $Farbe_der_Kategorie = ""
	Local $Items_der_Kategorie = ""
	Local $Item_Betreff = ""
	Local $Item_Datum = ""
	Local $Item_Text = ""

	_GUICtrlListView_BeginUpdate($quick_view_ToDoList_Listview)
	_GUICtrlListView_BeginUpdate($ToDoList_Listview)

	For $Index = 0 To UBound($ToDo_List_categories_split) - 1
		If $ToDo_List_categories_split[$Index] = "" Then ContinueLoop

		;Kategorie erstellen
		$Text_der_Kategorie = _IniReadRaw($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $ToDo_List_categories_split[$Index] & "_text", "")
		$Text_der_Kategorie = _ISN_Variablen_aufloesen($Text_der_Kategorie)
		$Farbe_der_Kategorie = _IniReadRaw($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $ToDo_List_categories_split[$Index] & "_color", "")
		$Items_der_Kategorie = _IniReadRaw($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $ToDo_List_categories_split[$Index] & "_items", "")

		;QuickView
		_GUICtrlListView_InsertGroup($quick_view_ToDoList_Listview, -1, $Index, $Text_der_Kategorie, 1)
		_GUICtrlListView_SetGroupInfo($quick_view_ToDoList_Listview, $Index, $Text_der_Kategorie, 1, $LVGS_COLLAPSIBLE)

		;MainGUI
		_GUICtrlListView_InsertGroup($ToDoList_Listview, -1, $Index, $Text_der_Kategorie, 1)
		_GUICtrlListView_SetGroupInfo($ToDoList_Listview, $Index, $Text_der_Kategorie, 1, $LVGS_COLLAPSIBLE)


		;Items laden
		If $Items_der_Kategorie <> "" Then
			$Items_der_Kategorie_split = StringSplit($Items_der_Kategorie, "|", 2)
			If Not IsArray($Items_der_Kategorie_split) Then ContinueLoop
			For $item_index = 0 To UBound($Items_der_Kategorie_split) - 1
				If $Items_der_Kategorie_split[$item_index] = "" Then ContinueLoop

				;Einträge Laden
				$Item_Betreff = _IniReadRaw($Pfad_zur_Project_ISN, "TODOLIST_ITEM_" & $Items_der_Kategorie_split[$item_index], "subject", "")
				$Item_Text = _IniReadRaw($Pfad_zur_Project_ISN, "TODOLIST_ITEM_" & $Items_der_Kategorie_split[$item_index], "text", "")
				$Item_Text = StringReplace($Item_Text, "[BREAK]", " ")
				$Item_Datum = _IniReadRaw($Pfad_zur_Project_ISN, "TODOLIST_ITEM_" & $Items_der_Kategorie_split[$item_index], "date", "")
;~ 				  If $Languagefile = "german.lng" Then $Item_Datum = Date_AutoIt_2_German($Item_Datum) ;In Deutsches Datum umwandeln


				$new_item = _GUICtrlListView_AddItem($quick_view_ToDoList_Listview, $Items_der_Kategorie_split[$item_index]) ;id
				_GUICtrlListView_AddSubItem($quick_view_ToDoList_Listview, $new_item, $ToDo_List_categories_split[$Index], 1) ;cat
				_GUICtrlListView_AddSubItem($quick_view_ToDoList_Listview, $new_item, $Item_Betreff, 2) ;betreff
				_GUICtrlListView_AddSubItem($quick_view_ToDoList_Listview, $new_item, $Item_Text, 3) ;Text
				_GUICtrlListView_AddSubItem($quick_view_ToDoList_Listview, $new_item, $Item_Datum, 4) ;datum
				_GUICtrlListView_SetItemGroupID($quick_view_ToDoList_Listview, $new_item, $Index)

				$new_item = _GUICtrlListView_AddItem($ToDoList_Listview, $Items_der_Kategorie_split[$item_index]) ;id
				_GUICtrlListView_AddSubItem($ToDoList_Listview, $new_item, $ToDo_List_categories_split[$Index], 1) ;cat
				_GUICtrlListView_AddSubItem($ToDoList_Listview, $new_item, $Item_Betreff, 2) ;betreff
				_GUICtrlListView_AddSubItem($ToDoList_Listview, $new_item, $Item_Text, 3) ;Text
				_GUICtrlListView_AddSubItem($ToDoList_Listview, $new_item, $Item_Datum, 4) ;datum
				_GUICtrlListView_SetItemGroupID($ToDoList_Listview, $new_item, $Index)

			Next
		EndIf
	Next





	_GUICtrlListView_EnableGroupView($quick_view_ToDoList_Listview)
	_GUICtrlListView_EnableGroupView($ToDoList_Listview)


	_Sortiere_Listview($quick_view_ToDoList_Listview, 4, 1) ;Nach Datum Sortieren
	_Sortiere_Listview($ToDoList_Listview, 4, 1) ;Nach Datum Sortieren

	;Ersetze Englisches Datum durch Deutsches
	If $Languagefile = "german.lng" Then
		For $y = 0 To _GUICtrlListView_GetItemCount($quick_view_ToDoList_Listview) - 1
			$Datum = _GUICtrlListView_GetItemText($quick_view_ToDoList_Listview, $y, 4)
			$Datum = Date_AutoIt_2_German($Datum) ;In Deutsches Datum umwandeln
			_GUICtrlListView_SetItemText($quick_view_ToDoList_Listview, $y, $Datum, 4)
			_GUICtrlListView_SetItemText($ToDoList_Listview, $y, $Datum, 4)
		Next
	EndIf

	_GUICtrlListView_EndUpdate($quick_view_ToDoList_Listview)
	_GUICtrlListView_EndUpdate($ToDoList_Listview)

EndFunc   ;==>_QuickView_ToDo_Liste_neu_einlesen




; modified sort call back from include GuiListView.au3
Func __GUICtrlListView_SortItems($hWnd, $iCol, $sort = -1)
	Local $iRet, $iIndex, $pFunction, $hHeader, $iFormat

	If Not IsHWnd($hWnd) Then $hWnd = GUICtrlGetHandle($hWnd)

	For $x = 1 To $__g_aListViewSortInfo[0][0]
		If $hWnd = $__g_aListViewSortInfo[$x][1] Then
			$iIndex = $x
			ExitLoop
		EndIf
	Next

	$pFunction = DllCallbackGetPtr($__g_aListViewSortInfo[$iIndex][2]) ; get pointer to call back
	$__g_aListViewSortInfo[$iIndex][3] = $iCol ; $nColumn = column clicked
	$__g_aListViewSortInfo[$iIndex][7] = 0 ; $bSet
	$__g_aListViewSortInfo[$iIndex][4] = $__g_aListViewSortInfo[$iIndex][6] ; nCurCol = $nCol
	$iRet = _SendMessage($hWnd, $LVM_SORTITEMSEX, $hWnd, $pFunction, 0, "hwnd", "ptr")
	If $iRet <> 0 Then
		If $__g_aListViewSortInfo[$iIndex][9] Then ; Use arrow in header
			$hHeader = $__g_aListViewSortInfo[$iIndex][10]
			For $x = 0 To _GUICtrlHeader_GetItemCount($hHeader) - 1
				$iFormat = _GUICtrlHeader_GetItemFormat($hHeader, $x)
				If BitAND($iFormat, $HDF_SORTDOWN) Then
					_GUICtrlHeader_SetItemFormat($hHeader, $x, BitXOR($iFormat, $HDF_SORTDOWN))
				ElseIf BitAND($iFormat, $HDF_SORTUP) Then
					_GUICtrlHeader_SetItemFormat($hHeader, $x, BitXOR($iFormat, $HDF_SORTUP))
				EndIf
			Next
			$iFormat = _GUICtrlHeader_GetItemFormat($hHeader, $iCol)
			If $sort = -1 Then ; ascending
				_GUICtrlHeader_SetItemFormat($hHeader, $iCol, BitOR($iFormat, $HDF_SORTUP))
			Else ; descending
				_GUICtrlHeader_SetItemFormat($hHeader, $iCol, BitOR($iFormat, $HDF_SORTDOWN))
			EndIf
		EndIf
	EndIf

	Return $iRet <> 0
EndFunc   ;==>__GUICtrlListView_SortItems

Func _Toggle_ToDo_manager()
	If Not _ist_windows_vista_oder_hoeher() Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1294), 0, $Studiofenster)
		Return
	EndIf
	$state = WinGetState($ToDoList_Manager, "")
	If BitAND($state, 2) Then
		GUISetState(@SW_HIDE, $ToDoList_Manager)
	Else
		_ToDo_Manager_GUI_Resize()
		GUISetState(@SW_SHOW, $ToDoList_Manager)
	EndIf
EndFunc   ;==>_Toggle_ToDo_manager


Func _ToDo_Liste_Kategorie_anhand_Item_finden($Listview = "", $item = "")
	If $Listview = "" Then Return
	If $item == "" Then Return
	;Quellkategorie finden
	$tInfo = DllStructCreate($tagLVFINDINFO)
	DllStructSetData($tInfo, "Flags", $LVFI_STRING)
	$return = _GUICtrlListView_FindItem($Listview, -1, $tInfo, $item)
	If $return = -1 Then Return ""
	Return _GUICtrlListView_GetItemText($Listview, $return, 1)
EndFunc   ;==>_ToDo_Liste_Kategorie_anhand_Item_finden

;$Zielitem ist 0 index der Listview
;$Quellitem der text aus der ini
Func _ToDo_Liste_Aufgabe_in_andere_Kategorie_verschieben($Listview = "", $Zielkategorie = "", $Quellitem = "")
	If $Listview = "" Then Return
	If $Zielkategorie == "" Then Return


	If $Quellitem = "" Then ;Bei "" aktuell markiertes Element verwenden
		If _GUICtrlListView_GetSelectionMark($Listview) = -1 Then Return
		$Quellitem = _GUICtrlListView_GetItemText($Listview, _GUICtrlListView_GetSelectionMark($Listview), 0)
	EndIf


	$Quellkategorie = _ToDo_Liste_Kategorie_anhand_Item_finden($Listview, $Quellitem)
	If $Zielkategorie = $Quellkategorie Then Return ;Wenn schon in gewünschter Kategorie, dann Abbruch!


	;Item aus Quellkategorie löschen...
	$Items_der_Quellkategorie = IniRead($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $Quellkategorie & "_items", "")
	If $Items_der_Quellkategorie = "" Then Return ;Wenn keine Kategorien, dann stopp
	$Items_der_Quellkategorie_split = StringSplit($Items_der_Quellkategorie, "|", 2)
	If Not IsArray($Items_der_Quellkategorie_split) Then Return
	$neuer_itemstring = ""
	For $Index = 0 To UBound($Items_der_Quellkategorie_split) - 1
		If $Items_der_Quellkategorie_split[$Index] = $Quellitem Then ContinueLoop
		$neuer_itemstring = $neuer_itemstring & $Items_der_Quellkategorie_split[$Index] & "|"
	Next
	If StringRight($neuer_itemstring, 1) = "|" Then $neuer_itemstring = StringTrimRight($neuer_itemstring, 1) ;Letztes | löschen
	IniWrite($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $Quellkategorie & "_items", $neuer_itemstring)

	;..und in Zielkategorie eintragen
	$Items_der_Zielkategorie = IniRead($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $Zielkategorie & "_items", "")
	$Items_der_Zielkategorie = $Items_der_Zielkategorie & "|" & $Quellitem
	If StringLeft($Items_der_Zielkategorie, 1) = "|" Then $Items_der_Zielkategorie = StringTrimLeft($Items_der_Zielkategorie, 1) ;Erstes | löschen
	If StringRight($Items_der_Zielkategorie, 1) = "|" Then $Items_der_Zielkategorie = StringTrimRight($Items_der_Zielkategorie, 1) ;Letztes | löschen (falls vorhanden...warum auch immer)
	IniWrite($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $Zielkategorie & "_items", $Items_der_Zielkategorie)

	;Listen neu einlesen
	_QuickView_ToDo_Liste_neu_einlesen()
EndFunc   ;==>_ToDo_Liste_Aufgabe_in_andere_Kategorie_verschieben

Func _QuickView_Aufgabe_Zuruecksetzen()
	If Not _ist_windows_vista_oder_hoeher() Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1294), 0, $Studiofenster)
		Return
	EndIf
	If _GUICtrlListView_GetSelectionMark($quick_view_ToDoList_Listview) = -1 Then Return
	_ToDo_Liste_Aufgabe_Zuruecksetzen($quick_view_ToDoList_Listview, _GUICtrlListView_GetItemText($quick_view_ToDoList_Listview, _GUICtrlListView_GetSelectionMark($quick_view_ToDoList_Listview), 0))
EndFunc   ;==>_QuickView_Aufgabe_Zuruecksetzen


Func _QuickView_Aufgabe_Abschliessen()
	If Not _ist_windows_vista_oder_hoeher() Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1294), 0, $Studiofenster)
		Return
	EndIf
	If _GUICtrlListView_GetSelectionMark($quick_view_ToDoList_Listview) = -1 Then Return
	_ToDo_Liste_Aufgabe_Abschliessen($quick_view_ToDoList_Listview, _GUICtrlListView_GetItemText($quick_view_ToDoList_Listview, _GUICtrlListView_GetSelectionMark($quick_view_ToDoList_Listview), 0))
EndFunc   ;==>_QuickView_Aufgabe_Abschliessen

Func _QuickView_Aufgabe_in_naechste_Kategorie_verschieben()
	If Not _ist_windows_vista_oder_hoeher() Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1294), 0, $Studiofenster)
		Return
	EndIf
	If _GUICtrlListView_GetSelectionMark($quick_view_ToDoList_Listview) = -1 Then Return
	_ToDo_Liste_Aufgabe_in_naechste_Kategorie_verschieben($quick_view_ToDoList_Listview, _GUICtrlListView_GetItemText($quick_view_ToDoList_Listview, _GUICtrlListView_GetSelectionMark($quick_view_ToDoList_Listview), 0))
EndFunc   ;==>_QuickView_Aufgabe_in_naechste_Kategorie_verschieben

Func _ToDo_Liste_Aufgabe_in_naechste_Kategorie_verschieben_button()
	If _GUICtrlListView_GetSelectionMark($ToDoList_Listview) = -1 Then Return
	_ToDo_Liste_Aufgabe_in_naechste_Kategorie_verschieben($ToDoList_Listview, _GUICtrlListView_GetItemText($ToDoList_Listview, _GUICtrlListView_GetSelectionMark($ToDoList_Listview), 0))
EndFunc   ;==>_ToDo_Liste_Aufgabe_in_naechste_Kategorie_verschieben_button

Func _ToDo_Liste_Aufgabe_Zuruecksetzen_button()
	If _GUICtrlListView_GetSelectionMark($ToDoList_Listview) = -1 Then Return
	_ToDo_Liste_Aufgabe_Zuruecksetzen($ToDoList_Listview, _GUICtrlListView_GetItemText($ToDoList_Listview, _GUICtrlListView_GetSelectionMark($ToDoList_Listview), 0))
EndFunc   ;==>_ToDo_Liste_Aufgabe_Zuruecksetzen_button


Func _ToDo_Liste_Aufgabe_Abschliessen_button()
	If _GUICtrlListView_GetSelectionMark($ToDoList_Listview) = -1 Then Return
	_ToDo_Liste_Aufgabe_Abschliessen($ToDoList_Listview, _GUICtrlListView_GetItemText($ToDoList_Listview, _GUICtrlListView_GetSelectionMark($ToDoList_Listview), 0))
EndFunc   ;==>_ToDo_Liste_Aufgabe_Abschliessen_button



Func _QuickView_Aufgabe_in_vorherige_Kategorie_verschieben()
	If Not _ist_windows_vista_oder_hoeher() Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1294), 0, $Studiofenster)
		Return
	EndIf
	If _GUICtrlListView_GetSelectionMark($quick_view_ToDoList_Listview) = -1 Then Return
	_ToDo_Liste_Aufgabe_in_vorherige_Kategorie_verschieben($quick_view_ToDoList_Listview, _GUICtrlListView_GetItemText($quick_view_ToDoList_Listview, _GUICtrlListView_GetSelectionMark($quick_view_ToDoList_Listview), 0))
EndFunc   ;==>_QuickView_Aufgabe_in_vorherige_Kategorie_verschieben

Func _ToDo_Liste_Aufgabe_in_vorherige_Kategorie_verschieben_button()
	If _GUICtrlListView_GetSelectionMark($ToDoList_Listview) = -1 Then Return
	_ToDo_Liste_Aufgabe_in_vorherige_Kategorie_verschieben($ToDoList_Listview, _GUICtrlListView_GetItemText($ToDoList_Listview, _GUICtrlListView_GetSelectionMark($ToDoList_Listview), 0))
EndFunc   ;==>_ToDo_Liste_Aufgabe_in_vorherige_Kategorie_verschieben_button


Func _ToDo_Liste_Aufgabe_Zuruecksetzen($Listview = "", $Quellitem = "")
	If _GUICtrlListView_GetSelectionMark($Listview) = -1 Then Return
	If $Listview = "" Then Return
	If $Quellitem = "" Then Return

	$ToDo_List_categories = IniRead($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", "categories", "")
	If $ToDo_List_categories = "" Then Return ;Wenn keine Kategorien, dann stopp

	$ToDo_List_categories_split = StringSplit($ToDo_List_categories, "|", 2)
	If Not IsArray($ToDo_List_categories_split) Then Return


	Local $Quellkategorie = _ToDo_Liste_Kategorie_anhand_Item_finden($Listview, $Quellitem)
	Local $Zielkategorie = $ToDo_List_categories_split[0] ;Erste Kategorie
	If $Quellkategorie = $Zielkategorie Then Return ;Bereits Abgeschlossen


	_ToDo_Liste_Aufgabe_in_andere_Kategorie_verschieben($Listview, $Zielkategorie, $Quellitem)
EndFunc   ;==>_ToDo_Liste_Aufgabe_Zuruecksetzen


Func _ToDo_Liste_Aufgabe_Abschliessen($Listview = "", $Quellitem = "")
	If _GUICtrlListView_GetSelectionMark($Listview) = -1 Then Return
	If $Listview = "" Then Return
	If $Quellitem = "" Then Return

	$ToDo_List_categories = IniRead($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", "categories", "")
	If $ToDo_List_categories = "" Then Return ;Wenn keine Kategorien, dann stopp

	$ToDo_List_categories_split = StringSplit($ToDo_List_categories, "|", 2)
	If Not IsArray($ToDo_List_categories_split) Then Return


	Local $Quellkategorie = _ToDo_Liste_Kategorie_anhand_Item_finden($Listview, $Quellitem)
	Local $Zielkategorie = $ToDo_List_categories_split[UBound($ToDo_List_categories_split) - 1] ;Letzte Kategorie
	If $Quellkategorie = $Zielkategorie Then Return ;Bereits Abgeschlossen


	_ToDo_Liste_Aufgabe_in_andere_Kategorie_verschieben($Listview, $Zielkategorie, $Quellitem)
EndFunc   ;==>_ToDo_Liste_Aufgabe_Abschliessen


Func _ToDo_Liste_Aufgabe_in_naechste_Kategorie_verschieben($Listview = "", $Quellitem = "")
	If _GUICtrlListView_GetSelectionMark($Listview) = -1 Then Return
	If $Listview = "" Then Return
	If $Quellitem = "" Then Return

	$ToDo_List_categories = IniRead($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", "categories", "")
	If $ToDo_List_categories = "" Then Return ;Wenn keine Kategorien, dann stopp

	$ToDo_List_categories_split = StringSplit($ToDo_List_categories, "|", 2)
	If Not IsArray($ToDo_List_categories_split) Then Return

	Local $Quellkategorie = _ToDo_Liste_Kategorie_anhand_Item_finden($Listview, $Quellitem)
	Local $Zielkategorie = ""

	For $Index = 0 To UBound($ToDo_List_categories_split) - 1
		If $ToDo_List_categories_split[$Index] = $Quellkategorie Then
			If $Index + 1 > UBound($ToDo_List_categories_split) - 1 Then Return ;Bereits in letzter Kategorie
			$Zielkategorie = $ToDo_List_categories_split[$Index + 1]
			ExitLoop
		EndIf
	Next

	If $Quellkategorie = $Zielkategorie Then Return
	_ToDo_Liste_Aufgabe_in_andere_Kategorie_verschieben($Listview, $Zielkategorie, $Quellitem)

	;"altes" Item wieder Markieren
	$tInfo = DllStructCreate($tagLVFINDINFO)
	DllStructSetData($tInfo, "Flags", $LVFI_STRING)
	$find = _GUICtrlListView_FindItem($Listview, -1, $tInfo, $Quellitem)
	If $find <> -1 Then
		_GUICtrlListView_SetItemSelected($Listview, $find, True, True)
		_GUICtrlListView_SetItemFocused($Listview, $find, True)
	EndIf

EndFunc   ;==>_ToDo_Liste_Aufgabe_in_naechste_Kategorie_verschieben


Func _ToDo_Liste_Aufgabe_in_vorherige_Kategorie_verschieben($Listview = "", $Quellitem = "")
	If _GUICtrlListView_GetSelectionMark($Listview) = -1 Then Return
	If $Listview = "" Then Return
	If $Quellitem = "" Then Return

	$ToDo_List_categories = IniRead($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", "categories", "")
	If $ToDo_List_categories = "" Then Return ;Wenn keine Kategorien, dann stopp

	$ToDo_List_categories_split = StringSplit($ToDo_List_categories, "|", 2)
	If Not IsArray($ToDo_List_categories_split) Then Return

	Local $Quellkategorie = _ToDo_Liste_Kategorie_anhand_Item_finden($Listview, $Quellitem)
	Local $Zielkategorie = ""

	For $Index = 0 To UBound($ToDo_List_categories_split) - 1
		If $ToDo_List_categories_split[$Index] = $Quellkategorie Then
			If $Index - 1 < 0 Then Return ;Bereits in erster Kategorie
			$Zielkategorie = $ToDo_List_categories_split[$Index - 1]
			ExitLoop
		EndIf
	Next

	If $Quellkategorie = $Zielkategorie Then Return
	_ToDo_Liste_Aufgabe_in_andere_Kategorie_verschieben($Listview, $Zielkategorie, $Quellitem)

	;"altes" Item wieder Markieren
	$tInfo = DllStructCreate($tagLVFINDINFO)
	DllStructSetData($tInfo, "Flags", $LVFI_STRING)
	$find = _GUICtrlListView_FindItem($Listview, -1, $tInfo, $Quellitem)
	If $find <> -1 Then
		_GUICtrlListView_SetItemSelected($Listview, $find, True, True)
		_GUICtrlListView_SetItemFocused($Listview, $find, True)
	EndIf

EndFunc   ;==>_ToDo_Liste_Aufgabe_in_vorherige_Kategorie_verschieben


Func _Toggle_Bitoperation_rechner()
	If $Offenes_Projekt = "" Then Return
	If $Tools_Bitrechner_aktiviert <> "true" Then Return
	$state = WinGetState($bitwise_operations_GUI, "")
	If BitAND($state, 2) Then
		GUISetState(@SW_HIDE, $bitwise_operations_GUI)
	Else
		GUISetState(@SW_SHOW, $bitwise_operations_GUI)
	EndIf
EndFunc   ;==>_Toggle_Bitoperation_rechner


Func _BitWisor()
	Local $sRez = "", $sError = "", $sInput = GUICtrlRead($cInput), $aInput, $sOp, $sCalc, $i = 0, $aTmp, $sTmp
	$aInput = StringRegExp($sInput, '\A[[:blank:]]*([[:alpha:]]+)[[:blank:]]*\((.+)\)', 1)
	If @error Then
		$sError = _Get_langstr(815)
	Else
		$sInput = $aInput[0] & '(' & $aInput[1] & ')'
		GUICtrlSetData($cInput, $sInput)
		$sOp = StringUpper(StringTrimLeft($aInput[0], 3))
		$sRez = Execute($sInput)
		If @error Then
			$sError = _Get_langstr(815)
		Else
			Switch $aInput[0]
				Case "bitand", "bitor", "bitxor"
					$aTmp = _SplitParams($aInput[1])
					For $i = 1 To $aTmp[0]
						$sTmp &= _HexToBinBase(Execute($aTmp[$i])) & @TAB & @TAB & @TAB & @TAB & @TAB & @TAB & '   0x' & Hex(Execute($aTmp[$i])) & @CRLF & Chr(1) & @CRLF
						$sCalc = StringReplace(StringTrimRight($sTmp, 3), Chr(1), $sOp) & _
								"=" & @CRLF & _
								_HexToBinBase($sRez) & @TAB & @TAB & @TAB & @TAB & @TAB & @TAB & '   0x' & Hex($sRez) & @CRLF
					Next
				Case "bitnot"
					$sCalc = _HexToBinBase(Execute($aInput[1])) & '   0x' & Hex(Execute($aInput[1])) & @CRLF & _
							$sOp & @CRLF & _
							"=" & @CRLF & _
							_HexToBinBase($sRez) & @TAB & @TAB & @TAB & @TAB & @TAB & @TAB & '   0x' & Hex($sRez) & @CRLF
				Case "bitshift"
					$aTmp = _SplitParams($aInput[1])
					If Execute($aTmp[2]) > 0 Then
						$sTmp = $sOp & " right by " & Execute($aTmp[2])
					ElseIf Execute($aTmp[2]) < 0 Then
						$sTmp = $sOp & " left by " & Abs(Execute($aTmp[2]))
					Else
						$sTmp = $sOp & " by 0"
					EndIf
					$sCalc = _HexToBinBase(Execute($aTmp[1])) & @TAB & @TAB & @TAB & @TAB & @TAB & @TAB & '   0x' & Hex(Execute($aTmp[1])) & @CRLF & _
							$sTmp & @CRLF & _
							"=" & @CRLF & _
							_HexToBinBase($sRez) & @TAB & @TAB & @TAB & @TAB & @TAB & @TAB & '   0x' & Hex($sRez) & @CRLF
				Case "bitrotate"
					$aTmp = _SplitParams($aInput[1])
					If UBound($aTmp) = 2 Then
						ReDim $aTmp[3]
						$aTmp[2] = 1
					EndIf
					If Execute($aTmp[2]) > 0 Then
						$sTmp = $sOp & " left by " & Execute($aTmp[2])
					ElseIf Execute($aTmp[2]) < 0 Then
						$sTmp = $sOp & " right by " & Abs(Execute($aTmp[2]))
					Else
						$sTmp = $sOp & " by 0"
					EndIf
					If $aTmp[0] < 3 Then $sSize = ' ("W" within 16 bits Default)' ; Default
					If $aTmp[0] = 3 Then
						If $aTmp[3] = '"D"' Then $sSize = ' ("D" within 32 bits)'
						If $aTmp[3] = '"W"' Then $sSize = ' ("W" within 16 bits)'
						If $aTmp[3] = '"B"' Then $sSize = ' ("B" within 8 bits)'
					EndIf
					$sCalc = _HexToBinBase(Execute($aTmp[1])) & @TAB & @TAB & @TAB & @TAB & @TAB & @TAB & '   0x' & Hex(Execute($aTmp[1])) & @CRLF & _
							$sTmp & $sSize & @CRLF & _
							"=" & @CRLF & _
							_HexToBinBase($sRez) & @TAB & @TAB & @TAB & @TAB & @TAB & @TAB & '   0x' & Hex($sRez) & @CRLF
				Case Else
					$sError = _Get_langstr(815)
			EndSwitch
		EndIf
	EndIf
	GUICtrlSetData($cResult, $sRez)
	If $sError <> "" Then
		GUICtrlSetData($cCalc, $sError)
	Else
		GUICtrlSetData($cCalc, $sCalc)
	EndIf
EndFunc   ;==>_BitWisor
#cs _HexToBinBase()
	Converts a number to binary base string
#ce
Func _HexToBinBase($hex)
	Local $b = ""
	For $i = 1 To 32
		$b = BitAND($hex, 1) & $b
		$hex = BitShift($hex, 1)
	Next
	Return $b
EndFunc   ;==>_HexToBinBase
#cs _SplitParams()
	Crappy AutoIt param string parser
	Should choke on quoted commas
	Returns StringSplit-like array
#ce
Func _SplitParams($sParams)
	Local $aParams, $i, $br1, $br2, $aRet[1]
	$aParams = StringSplit($sParams, ",")
	For $i = $aParams[0] To 1 Step -1
		StringReplace($aParams[$i], ")", "")
		$br1 = @extended
		StringReplace($aParams[$i], "(", "")
		$br2 = @extended
		If $br1 <> $br2 Then
			$aParams[$i - 1] &= "," & $aParams[$i]
			$aParams[$i] = ""
		EndIf
	Next
	For $i = 1 To $aParams[0]
		If $aParams[$i] <> "" Then
			ReDim $aRet[UBound($aRet) + 1]
			$aRet[UBound($aRet) - 1] = $aParams[$i]
		EndIf
	Next
	$aRet[0] = UBound($aRet) - 1
	Return $aRet
EndFunc   ;==>_SplitParams
#cs _GraphicDrawLines()
	Draws lines, duh
	Params: $cID - control ID from GuiCtrlCreateGraphic
	$aCoords - 1D array containing coordinate pairs ( $a[0]=x0, $a[1]=y0, $a[2]=x1, $a[3]=y1, etc.)
	$iPenSize, $iColor, $iColorBk - line options
#ce
Func _GraphicDrawLines($cID, $aCoords, $iPenSize = 2, $iColor = 0, $iColorBk = -1)
	GUICtrlSetGraphic($cID, $GUI_GR_PENSIZE, $iPenSize)
	GUICtrlSetGraphic($cID, $GUI_GR_COLOR, $iColor, $iColorBk)
	GUICtrlSetGraphic($cID, $GUI_GR_MOVE, $aCoords[0], $aCoords[1])
	For $i = 2 To UBound($aCoords) - 1 Step 2
		GUICtrlSetGraphic($cID, $GUI_GR_LINE, $aCoords[$i], $aCoords[$i + 1])
	Next
EndFunc   ;==>_GraphicDrawLines

Func _ToDo_Liste_Kategorien_verwalten_zeige_Manager()
	If Not _ist_windows_vista_oder_hoeher() Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1294), 0, $Studiofenster)
		Return
	EndIf
	_ToDo_Liste_Kategorien_verwalten_GUI_Resize()
	_ToDo_Liste_Kategorien_verwalten_Liste_Laden()
	GUISetState(@SW_SHOW, $ToDoList_Category_Manager)
	GUISetState(@SW_DISABLE, $ToDoList_Manager)
	GUISetState(@SW_DISABLE, $Studiofenster)

EndFunc   ;==>_ToDo_Liste_Kategorien_verwalten_zeige_Manager

Func _ToDo_Liste_Kategorien_verwalten_Manager_ausblenden()
	GUISetState(@SW_ENABLE, $ToDoList_Manager)
	GUISetState(@SW_ENABLE, $Studiofenster)
	GUISetState(@SW_HIDE, $ToDoList_Category_Manager)
	_QuickView_ToDo_Liste_neu_einlesen()
EndFunc   ;==>_ToDo_Liste_Kategorien_verwalten_Manager_ausblenden

Func _ToDo_Liste_Kategorien_verwalten_GUI_Resize()
	;ToDoListe Spalten resize
	$Category_Manager_Listview_Pos_Array = _ControlGetPos($ToDoList_Category_Manager, "", $Category_Manager_Listview)
	If Not IsArray($Category_Manager_Listview_Pos_Array) Then Return
	_GUICtrlListView_SetColumnWidth($Category_Manager_Listview, 1, ($Category_Manager_Listview_Pos_Array[2] / 100) * 95)
EndFunc   ;==>_ToDo_Liste_Kategorien_verwalten_GUI_Resize

Func _ToDo_Liste_Kategorien_verwalten_Liste_Laden()
	_GUICtrlListView_DeleteAllItems(GUICtrlGetHandle($Category_Manager_Listview))

	$ToDo_List_categories = IniRead($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", "categories", "")
	If $ToDo_List_categories = "" Then Return ;Wenn keine Kategorien, dann stopp

	$ToDo_List_categories_split = StringSplit($ToDo_List_categories, "|", 2)
	If Not IsArray($ToDo_List_categories_split) Then Return

	For $Index = 0 To UBound($ToDo_List_categories_split) - 1
		If $ToDo_List_categories_split[$Index] = "" Then ContinueLoop
		$new_item = _GUICtrlListView_AddItem($Category_Manager_Listview, $ToDo_List_categories_split[$Index]) ;id
		_GUICtrlListView_AddSubItem($Category_Manager_Listview, $new_item, _ISN_Variablen_aufloesen(_IniReadRaw($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $ToDo_List_categories_split[$Index] & "_text", "")), 1) ;Text der Kategorie
	Next

EndFunc   ;==>_ToDo_Liste_Kategorien_verwalten_Liste_Laden



Func _ToDo_Liste_Kategorien_verwalten_Markierte_Kategorie_nach_oben_verschieben()
	If _GUICtrlListView_GetSelectionMark($Category_Manager_Listview) = -1 Then Return
	If _GUICtrlListView_GetItemCount($Category_Manager_Listview) = 0 Then Return
	_GUICtrlListView_MoveItems($Category_Manager_Listview, -1)
	_GUICtrlListView_EnsureVisible($Category_Manager_Listview, _GUICtrlListView_GetSelectionMark($Category_Manager_Listview))
	_GUICtrlListView_SetItemSelected($Category_Manager_Listview, _GUICtrlListView_GetSelectionMark($Category_Manager_Listview), True, True)

	;Einträge in INI Speichern
	$ToDo_List_categories = ""
	For $Index = 0 To _GUICtrlListView_GetItemCount($Category_Manager_Listview) - 1
		$ToDo_List_categories = $ToDo_List_categories & _GUICtrlListView_GetItemText($Category_Manager_Listview, $Index, 0) & "|"
	Next
	If StringRight($ToDo_List_categories, 1) = "|" Then $ToDo_List_categories = StringTrimRight($ToDo_List_categories, 1)
	IniWrite($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", "categories", $ToDo_List_categories)

EndFunc   ;==>_ToDo_Liste_Kategorien_verwalten_Markierte_Kategorie_nach_oben_verschieben

Func _ToDo_Liste_Kategorien_verwalten_Markierte_Kategorie_nach_unten_verschieben()
	If _GUICtrlListView_GetSelectionMark($Category_Manager_Listview) = -1 Then Return
	If _GUICtrlListView_GetItemCount($Category_Manager_Listview) = 0 Then Return
	_GUICtrlListView_MoveItems($Category_Manager_Listview, 1)
	_GUICtrlListView_EnsureVisible($Category_Manager_Listview, _GUICtrlListView_GetSelectionMark($Category_Manager_Listview))
	_GUICtrlListView_SetItemSelected($Category_Manager_Listview, _GUICtrlListView_GetSelectionMark($Category_Manager_Listview), True, True)

	;Einträge in INI Speichern
	$ToDo_List_categories = ""
	For $Index = 0 To _GUICtrlListView_GetItemCount($Category_Manager_Listview) - 1
		$ToDo_List_categories = $ToDo_List_categories & _GUICtrlListView_GetItemText($Category_Manager_Listview, $Index, 0) & "|"
	Next
	If StringRight($ToDo_List_categories, 1) = "|" Then $ToDo_List_categories = StringTrimRight($ToDo_List_categories, 1)
	IniWrite($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", "categories", $ToDo_List_categories)
EndFunc   ;==>_ToDo_Liste_Kategorien_verwalten_Markierte_Kategorie_nach_unten_verschieben

Func _ToDo_Liste_Kategorien_verwalten_Markierte_Kategorie_loeschen()
	If _GUICtrlListView_GetSelectionMark($Category_Manager_Listview) = -1 Then Return
	If _GUICtrlListView_GetItemCount($Category_Manager_Listview) = 0 Then Return

	GUICtrlSetState($todo_category_loeschen_delete_all_radio, $GUI_CHECKED)
	GUICtrlSetData($todo_category_loeschen_categories_combo, "", "")
	_ToDo_Liste_Kategorien_verwalten_Kategoriue_loeschen_Radio_Event()

	GUISetState(@SW_SHOW, $ToDoList_Delete_Category)
	GUISetState(@SW_DISABLE, $ToDoList_Category_Manager)


EndFunc   ;==>_ToDo_Liste_Kategorien_verwalten_Markierte_Kategorie_loeschen

Func _ToDo_Liste_Kategorien_verwalten_Kategoriue_loeschen_Radio_Event()
	If GUICtrlRead($todo_category_loeschen_delete_all_radio) = $GUI_CHECKED Then
		GUICtrlSetData($todo_category_loeschen_categories_combo, "", "")
		GUICtrlSetState($todo_category_loeschen_categories_combo, $GUI_DISABLE)
	Else
		GUICtrlSetState($todo_category_loeschen_categories_combo, $GUI_ENABLE)

		$ToDo_List_categories = IniRead($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", "categories", "")
		If $ToDo_List_categories = "" Then Return ;Wenn keine Kategorien, dann stopp

		$ToDo_List_categories_split = StringSplit($ToDo_List_categories, "|", 2)
		If Not IsArray($ToDo_List_categories_split) Then Return

		$ToDo_Liste_Kategorie_loaschen_Combo = $Leeres_Array
		$Combostring = ""
		For $Index = 0 To UBound($ToDo_List_categories_split) - 1
			If $ToDo_List_categories_split[$Index] = "" Then ContinueLoop
			If $ToDo_List_categories_split[$Index] = _GUICtrlListView_GetItemText($Category_Manager_Listview, _GUICtrlListView_GetSelectionMark($Category_Manager_Listview), 0) Then ContinueLoop ;Zu löschende Kategorie NICHT eintragen ^^
			$Combostring = $Combostring & _ISN_Variablen_aufloesen(_IniReadRaw($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $ToDo_List_categories_split[$Index] & "_text", "")) & "|"
			_ArrayAdd($ToDo_Liste_Kategorie_loaschen_Combo, $ToDo_List_categories_split[$Index])
		Next
		If StringRight($Combostring, 1) = "|" Then $Combostring = StringTrimRight($Combostring, 1)
		GUICtrlSetData($todo_category_loeschen_categories_combo, $Combostring, "")

	EndIf
EndFunc   ;==>_ToDo_Liste_Kategorien_verwalten_Kategoriue_loeschen_Radio_Event


Func _ToDo_Liste_Kategorien_verwalten_Neue_Kategorie_loeschen_Abbrechen()
	GUISetState(@SW_ENABLE, $ToDoList_Category_Manager)
	GUISetState(@SW_HIDE, $ToDoList_Delete_Category)
EndFunc   ;==>_ToDo_Liste_Kategorien_verwalten_Neue_Kategorie_loeschen_Abbrechen

Func _ToDo_Liste_Kategorien_verwalten_Neue_Kategorie_loeschen_OK()
	If _GUICtrlListView_GetSelectionMark($Category_Manager_Listview) = -1 Then Return
	If _GUICtrlListView_GetItemCount($Category_Manager_Listview) = 0 Then Return

	$zu_loeschende_Cat = _GUICtrlListView_GetItemText($Category_Manager_Listview, _GUICtrlListView_GetSelectionMark($Category_Manager_Listview), 0)

	If GUICtrlRead($todo_category_loeschen_delete_all_radio) = $GUI_CHECKED Then
		;Kategorie+Aufgaben löschen

		$ToDo_List_Items_String = IniRead($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $zu_loeschende_Cat & "_items", "")
		$ToDo_List_Items_split_Array = StringSplit($ToDo_List_Items_String, "|", 2)
		If IsArray($ToDo_List_Items_split_Array) Then
			For $Count = 0 To UBound($ToDo_List_Items_split_Array) - 1
				If $ToDo_List_Items_split_Array[$Count] = "" Then ContinueLoop
				;Items löschen
				IniDelete($Pfad_zur_Project_ISN, "TODOLIST_ITEM_" & $ToDo_List_Items_split_Array[$Count])
			Next
		EndIf

	Else
		;Aufgaben in neue Kategorie verschieben

		If IsArray($ToDo_Liste_Kategorie_loaschen_Combo) Then
			If GUICtrlRead($todo_category_loeschen_categories_combo) = "" Then
				MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1288), 0, $ToDoList_Delete_Category)
				Return
			EndIf
			$Selected_cat = $ToDo_Liste_Kategorie_loaschen_Combo[_GUICtrlComboBox_GetCurSel($todo_category_loeschen_categories_combo)]

			;Items einlesen...
			$alte_Items_zu_loeschende_Kategorie = IniRead($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $zu_loeschende_Cat & "_items", "")

			;..und in Zielkategorie eintragen
			$Items_zeilkatekorie = IniRead($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $Selected_cat & "_items", "")
			$Items_zeilkatekorie = $Items_zeilkatekorie & "|" & $alte_Items_zu_loeschende_Kategorie
			If StringRight($Items_zeilkatekorie, 1) = "|" Then $Items_zeilkatekorie = StringTrimRight($Items_zeilkatekorie, 1)
			IniWrite($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $Selected_cat & "_items", $Items_zeilkatekorie)

		EndIf
	EndIf


	;Kategorie endgültig entfernen
	$ToDo_List_categories = IniRead($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", "categories", "")
	$ToDo_List_categories_split = StringSplit($ToDo_List_categories, "|", 2)
	If Not IsArray($ToDo_List_categories_split) Then Return
	$Neuer_Kategoriestring = ""
	For $Index = 0 To UBound($ToDo_List_categories_split) - 1
		If $ToDo_List_categories_split[$Index] = "" Then ContinueLoop
		If $ToDo_List_categories_split[$Index] = $zu_loeschende_Cat Then ContinueLoop ;Diese Kategorie wird gelöscht
		$Neuer_Kategoriestring = $Neuer_Kategoriestring & $ToDo_List_categories_split[$Index] & "|"
	Next
	If StringRight($Neuer_Kategoriestring, 1) = "|" Then $Neuer_Kategoriestring = StringTrimRight($Neuer_Kategoriestring, 1)

	IniWrite($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", "categories", $Neuer_Kategoriestring)
	IniDelete($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $zu_loeschende_Cat & "_items")
	IniDelete($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $zu_loeschende_Cat & "_text")
	IniDelete($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $zu_loeschende_Cat & "_color")


	;Kategorien neu einlesen
	_ToDo_Liste_Kategorien_verwalten_Liste_Laden()

	GUISetState(@SW_ENABLE, $ToDoList_Category_Manager)
	GUISetState(@SW_HIDE, $ToDoList_Delete_Category)
EndFunc   ;==>_ToDo_Liste_Kategorien_verwalten_Neue_Kategorie_loeschen_OK

Func _ToDo_Liste_Kategorien_verwalten_Markierte_Kategorie_bearbeiten()
	If _GUICtrlListView_GetSelectionMark($Category_Manager_Listview) = -1 Then Return
	If _GUICtrlListView_GetItemCount($Category_Manager_Listview) = 0 Then Return

	GUICtrlSetData($neue_kategorie_title_label, _Get_langstr(1275))
	WinSetTitle($ToDoList_New_Category, "", _Get_langstr(1275))

	$Kategorie_ID = _GUICtrlListView_GetItemText($Category_Manager_Listview, _GUICtrlListView_GetSelectionMark($Category_Manager_Listview), 0)
	GUICtrlSetData($neue_kategorie_ID_label, $Kategorie_ID)

	GUICtrlSetData($neue_kategorie_Text_input, _IniReadRaw($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $Kategorie_ID & "_text", ""))
	GUICtrlSetData($neue_kategorie_Farbe_input, IniRead($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $Kategorie_ID & "_color", ""))

	If GUICtrlRead($neue_kategorie_Farbe_input) = "" Then
		GUICtrlSetColor($neue_kategorie_Farbe_input, $Schriftfarbe)
		GUICtrlSetBkColor($neue_kategorie_Farbe_input, $Fenster_Hintergrundfarbe)
	Else
		GUICtrlSetBkColor($neue_kategorie_Farbe_input, Execute(GUICtrlRead($neue_kategorie_Farbe_input)))
		GUICtrlSetColor($neue_kategorie_Farbe_input, _ColourInvert(Execute(GUICtrlRead($neue_kategorie_Farbe_input))))
	EndIf

	GUICtrlSetOnEvent($neue_kategorie_ok_button, "_ToDo_Liste_Kategorien_verwalten_Kategorie_Bearbeiten_OK")

	GUISetState(@SW_SHOW, $ToDoList_New_Category)
	GUISetState(@SW_DISABLE, $ToDoList_Category_Manager)

EndFunc   ;==>_ToDo_Liste_Kategorien_verwalten_Markierte_Kategorie_bearbeiten

Func _ToDo_Liste_Kategorien_verwalten_Neue_Kategorie()
	GUICtrlSetData($neue_kategorie_title_label, _Get_langstr(1274))
	WinSetTitle($ToDoList_New_Category, "", _Get_langstr(1274))

	$neue_Kategorie_ID = "ct_" & @YEAR & @MON & @MDAY & @SEC & Random(0, 500, 1)
	GUICtrlSetData($neue_kategorie_ID_label, $neue_Kategorie_ID)

	GUICtrlSetData($neue_kategorie_Text_input, "")
	GUICtrlSetData($neue_kategorie_Farbe_input, "")
	GUICtrlSetColor($neue_kategorie_Farbe_input, $Schriftfarbe)
	GUICtrlSetBkColor($neue_kategorie_Farbe_input, $Fenster_Hintergrundfarbe)

	GUICtrlSetOnEvent($neue_kategorie_ok_button, "_ToDo_Liste_Kategorien_verwalten_Neue_Kategorie_Erstellen")

	GUISetState(@SW_SHOW, $ToDoList_New_Category)
	GUISetState(@SW_DISABLE, $ToDoList_Category_Manager)
EndFunc   ;==>_ToDo_Liste_Kategorien_verwalten_Neue_Kategorie



Func _ToDo_Liste_Kategorien_verwalten_Neue_Kategorie_Keine_Farbe()
	GUICtrlSetData($neue_kategorie_Farbe_input, "")
	GUICtrlSetColor($neue_kategorie_Farbe_input, $Schriftfarbe)
	GUICtrlSetBkColor($neue_kategorie_Farbe_input, $Fenster_Hintergrundfarbe)
EndFunc   ;==>_ToDo_Liste_Kategorien_verwalten_Neue_Kategorie_Keine_Farbe

Func _ToDo_Liste_Kategorien_verwalten_Neue_Kategorie_Farbe_waehlen()
	$res = _ChooseColor(2, GUICtrlRead($neue_kategorie_Farbe_input), 2, $ToDoList_New_Category)
	If $res = -1 Then Return
	GUICtrlSetData($neue_kategorie_Farbe_input, $res)
	GUICtrlSetColor($neue_kategorie_Farbe_input, _ColourInvert(Execute($res)))
	GUICtrlSetBkColor($neue_kategorie_Farbe_input, $res)
EndFunc   ;==>_ToDo_Liste_Kategorien_verwalten_Neue_Kategorie_Farbe_waehlen

Func _ToDo_Liste_Kategorien_verwalten_Neue_Kategorie_Abbrechen()
	GUISetState(@SW_ENABLE, $ToDoList_Category_Manager)
	GUISetState(@SW_HIDE, $ToDoList_New_Category)
EndFunc   ;==>_ToDo_Liste_Kategorien_verwalten_Neue_Kategorie_Abbrechen

Func _ToDo_Liste_Kategorien_verwalten_Neue_Kategorie_Erstellen()

	If GUICtrlRead($neue_kategorie_Text_input) = "" Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1228), 0, $ToDoList_New_Category)
		Return
	EndIf

	;Neue Kategorie in INI_Speichern
	$ToDo_List_categories = _IniReadRaw($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", "categories", "")
	$ToDo_List_categories = $ToDo_List_categories & "|" & GUICtrlRead($neue_kategorie_ID_label)
	If StringLeft($ToDo_List_categories, 1) = "|" Then $ToDo_List_categories = StringTrimLeft($ToDo_List_categories, 1)
	If StringRight($ToDo_List_categories, 1) = "|" Then $ToDo_List_categories = StringTrimRight($ToDo_List_categories, 1)
	IniWrite($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", "categories", $ToDo_List_categories)
	IniWrite($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", GUICtrlRead($neue_kategorie_ID_label) & "_text", GUICtrlRead($neue_kategorie_Text_input))
	IniWrite($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", GUICtrlRead($neue_kategorie_ID_label) & "_color", GUICtrlRead($neue_kategorie_Farbe_input))

	;Kategorien neu einlesen
	_ToDo_Liste_Kategorien_verwalten_Liste_Laden()

	GUISetState(@SW_ENABLE, $ToDoList_Category_Manager)
	GUISetState(@SW_HIDE, $ToDoList_New_Category)
EndFunc   ;==>_ToDo_Liste_Kategorien_verwalten_Neue_Kategorie_Erstellen

Func _ToDo_Liste_Kategorien_verwalten_Kategorie_Bearbeiten_OK()

	If GUICtrlRead($neue_kategorie_Text_input) = "" Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1228), 0, $ToDoList_New_Category)
		_Input_Error_FX($neue_kategorie_Text_input)
		Return
	EndIf

	;Neue Kategorie in INI_Speichern
	IniWrite($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", GUICtrlRead($neue_kategorie_ID_label) & "_text", GUICtrlRead($neue_kategorie_Text_input))
	IniWrite($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", GUICtrlRead($neue_kategorie_ID_label) & "_color", GUICtrlRead($neue_kategorie_Farbe_input))

	;Kategorien neu einlesen
	_ToDo_Liste_Kategorien_verwalten_Liste_Laden()

	GUISetState(@SW_ENABLE, $ToDoList_Category_Manager)
	GUISetState(@SW_HIDE, $ToDoList_New_Category)
EndFunc   ;==>_ToDo_Liste_Kategorien_verwalten_Kategorie_Bearbeiten_OK

Func _ToDo_Liste_erstelle_Standard_Kategorien()
	If $Templatemode = 1 Then Return ;In Vorlagen keine Standardkategorien erstellen (Die müssen schon selbst angelegt werden ^^)
	IniReadSection($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA")
	If @error Then

		;ToDo Bereich existiert in der project.isn noch nicht...default wird erstellt
		$Kategorie1_ID = "ct_2017030916439"
		$Kategorie2_ID = "ct_2017030916222"
		$Kategorie3_ID = "ct_201703091641"
		$Kategorie4_ID = "ct_2017030916312"
		$Kategorie_String = $Kategorie1_ID & "|" & $Kategorie2_ID & "|" & $Kategorie3_ID & "|" & $Kategorie4_ID

		IniWrite($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", "categories", $Kategorie_String)
		IniWrite($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $Kategorie1_ID & "_text", "%langstring(1280)%")
		IniWrite($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $Kategorie2_ID & "_text", "%langstring(1281)%")
		IniWrite($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $Kategorie3_ID & "_text", "%langstring(1282)%")
		IniWrite($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $Kategorie4_ID & "_text", "%langstring(1283)%")

		IniWrite($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $Kategorie1_ID & "_color", "0xFF7A7A")
		IniWrite($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $Kategorie2_ID & "_color", "0xFFC56E")
		IniWrite($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $Kategorie3_ID & "_color", "0xF9FF5D")
		IniWrite($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $Kategorie4_ID & "_color", "0xAAEE99")
	EndIf
EndFunc   ;==>_ToDo_Liste_erstelle_Standard_Kategorien

Func _QuickView_Aufgabe_loeschen()
	If Not _ist_windows_vista_oder_hoeher() Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1294), 0, $Studiofenster)
		Return
	EndIf
	If _GUICtrlListView_GetSelectionMark($quick_view_ToDoList_Listview) = -1 Then Return
	If _GUICtrlListView_GetItemCount($quick_view_ToDoList_Listview) = 0 Then Return

	$i = MsgBox(262144 + 32 + 4, _Get_langstr(48), _Get_langstr(1290), 0, $Studiofenster)
	If @error Then Return
	If $i <> 6 Then Return

	$zu_loeschendes_item = _GUICtrlListView_GetItemText($quick_view_ToDoList_Listview, _GUICtrlListView_GetSelectionMark($quick_view_ToDoList_Listview), 0)
	$cat_des_items = _GUICtrlListView_GetItemText($quick_view_ToDoList_Listview, _GUICtrlListView_GetSelectionMark($quick_view_ToDoList_Listview), 1)

	_ToDo_Liste_Aufgabe_Loeschen($zu_loeschendes_item, $cat_des_items)
EndFunc   ;==>_QuickView_Aufgabe_loeschen

Func _ToDo_Liste_Manager_Aufgabe_loeschen()
	If _GUICtrlListView_GetSelectionMark($ToDoList_Listview) = -1 Then Return
	If _GUICtrlListView_GetItemCount($ToDoList_Listview) = 0 Then Return

	$i = MsgBox(262144 + 32 + 4, _Get_langstr(48), _Get_langstr(1290), 0, $ToDoList_Manager)
	If @error Then Return
	If $i <> 6 Then Return

	$zu_loeschendes_item = _GUICtrlListView_GetItemText($ToDoList_Listview, _GUICtrlListView_GetSelectionMark($ToDoList_Listview), 0)
	$cat_des_items = _GUICtrlListView_GetItemText($ToDoList_Listview, _GUICtrlListView_GetSelectionMark($ToDoList_Listview), 1)

	_ToDo_Liste_Aufgabe_Loeschen($zu_loeschendes_item, $cat_des_items)
EndFunc   ;==>_ToDo_Liste_Manager_Aufgabe_loeschen

Func _ToDo_Liste_Aufgabe_Loeschen($item = "", $Cat = "")
	If $item = "" Then Return
	If $Cat = "" Then Return

	$zu_loeschendes_item = $item
	$cat_des_items = $Cat

	$ToDo_List_Items_String = IniRead($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $cat_des_items & "_items", "")
	$ToDo_List_Items_split_Array = StringSplit($ToDo_List_Items_String, "|", 2)
	$Neuer_Item_string = ""
	If IsArray($ToDo_List_Items_split_Array) Then
		For $Count = 0 To UBound($ToDo_List_Items_split_Array) - 1
			If $ToDo_List_Items_split_Array[$Count] = "" Then ContinueLoop
			If $ToDo_List_Items_split_Array[$Count] = $zu_loeschendes_item Then ContinueLoop ;Zu löschendes Item überspringen
			$Neuer_Item_string = $Neuer_Item_string & $ToDo_List_Items_split_Array[$Count] & "|"
		Next
		If StringLeft($Neuer_Item_string, 1) = "|" Then $Neuer_Item_string = StringTrimLeft($Neuer_Item_string, 1)
		If StringRight($Neuer_Item_string, 1) = "|" Then $Neuer_Item_string = StringTrimRight($Neuer_Item_string, 1)
		IniWrite($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $cat_des_items & "_items", $Neuer_Item_string) ;Neuen String abspeichern
	EndIf

	;Und Item selbst löschen
	IniDelete($Pfad_zur_Project_ISN, "TODOLIST_ITEM_" & $zu_loeschendes_item)

	_QuickView_ToDo_Liste_neu_einlesen()
EndFunc   ;==>_ToDo_Liste_Aufgabe_Loeschen


Func _Datei_nach_UTF16_konvertieren($Datei = "", $Backup_erstellen = "true")
	;UTF16 Little Endian
	If $Datei = "" Then Return
	If Not FileExists($Datei) Then Return
	$Datei_Encoding = FileGetEncoding($Datei)
	If $Datei_Encoding = 32 Then Return ;Bereits richtiges Encoding

	Dim $szDrive, $szDir, $szFName, $szExt
	$Datei_Handle = FileOpen($Datei, $Datei_Encoding)
	If $Datei_Handle = -1 Then
		MsgBox(262144, "Error", "Error while reading file!" & @CRLF & $Datei)
		Return
	EndIf
	$Datei_Inhalt = FileRead($Datei_Handle)
	FileClose($Datei_Handle)

	$TestPath = _PathSplit($Datei, $szDrive, $szDir, $szFName, $szExt)

	If $Backup_erstellen = "true" Then
		FileMove($Datei, $szDrive & $szDir & $szFName & ".bak")
	Else
		FileRecycle($Datei) ;Alte Datei in den Papierkorb schmeißen
	EndIf

	Sleep(100)

	$Datei_Handle = FileOpen($Datei, 32 + 2)
	If $Datei_Handle = -1 Then
		MsgBox(262144, "Error", "Error while writing file!" & @CRLF & $Datei)
		Return
	EndIf
	FileWrite($Datei_Handle, $Datei_Inhalt)
	FileClose($Datei_Handle)

EndFunc   ;==>_Datei_nach_UTF16_konvertieren

Func _Leere_UTF16_Datei_erstellen($Datei = "")
	If $Datei = "" Then Return
	$Datei_Handle = FileOpen($Datei, 32 + 2)
	If $Datei_Handle = -1 Then
		MsgBox(262144, "Error", "Error while writing file!" & @CRLF & $Datei)
		Return
	EndIf
	FileWrite($Datei_Handle, "")
	FileClose($Datei_Handle)
EndFunc   ;==>_Leere_UTF16_Datei_erstellen



Func _QuickView_ToDo_Liste_Neue_Aufgabe()
	If Not _ist_windows_vista_oder_hoeher() Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1294), 0, $Studiofenster)
		Return
	EndIf

	GUICtrlSetData($todoliste_neuer_eintrag_titel_label, _Get_langstr(1265))
	WinSetTitle($ToDo_Liste_neuer_eintrag_GUI, "", _Get_langstr(1265))

	$neue_Aufgabe_ID = @YEAR & @MON & @MDAY & @SEC & Random(0, 500, 1)
	GUICtrlSetData($todoliste_neuer_eintrag_ID_label, $neue_Aufgabe_ID)

	GUICtrlSetData($todoliste_neuer_eintrag_betreff_input, "")
	GUICtrlSetData($todoliste_neuer_eintrag_text_edit, "")
	GUICtrlSetData($todoliste_neuer_eintrag_datum_input, @YEAR & "/" & @MON & "/" & @MDAY)

	GUISetOnEvent($GUI_EVENT_CLOSE, "_ToDo_Liste_Liste_Neue_Aufgabe_Abbrechen_QuickView", $ToDo_Liste_neuer_eintrag_GUI)
	GUICtrlSetOnEvent($todoliste_neuer_eintrag_ok_Button, "_ToDo_Liste_Liste_Neue_Aufgabe_OK")
	GUICtrlSetOnEvent($todoliste_neuer_eintrag_abbrechen_Button, "_ToDo_Liste_Liste_Neue_Aufgabe_Abbrechen_QuickView")

	GUICtrlSetState($todoliste_neuer_eintrag_betreff_input, $GUI_FOCUS)

	GUISetState(@SW_SHOW, $ToDo_Liste_neuer_eintrag_GUI)
	GUISetState(@SW_DISABLE, $Studiofenster)
EndFunc   ;==>_QuickView_ToDo_Liste_Neue_Aufgabe

Func _ToDo_Liste_Liste_Neue_Aufgabe_schreiben()
	$ToDo_List_categories = IniRead($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", "categories", "")
	If $ToDo_List_categories = "" Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1293), 0, $ToDo_Liste_neuer_eintrag_GUI)
		Return ;Wenn keine Kategorien, dann stopp
	EndIf

	$ToDo_List_categories_split = StringSplit($ToDo_List_categories, "|", 2)
	If Not IsArray($ToDo_List_categories_split) Then Return

	If UBound($ToDo_List_categories_split) > 0 Then
		$erste_kategorie = $ToDo_List_categories_split[0]
		$Erste_categorie_items = IniRead($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $erste_kategorie & "_items", "")
		$Erste_categorie_items = $Erste_categorie_items & "|" & GUICtrlRead($todoliste_neuer_eintrag_ID_label)
		If StringLeft($Erste_categorie_items, 1) = "|" Then $Erste_categorie_items = StringTrimLeft($Erste_categorie_items, 1)
		If StringRight($Erste_categorie_items, 1) = "|" Then $Erste_categorie_items = StringTrimRight($Erste_categorie_items, 1)
		IniWrite($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", $erste_kategorie & "_items", $Erste_categorie_items)


		IniWrite($Pfad_zur_Project_ISN, "TODOLIST_ITEM_" & GUICtrlRead($todoliste_neuer_eintrag_ID_label), "subject", GUICtrlRead($todoliste_neuer_eintrag_betreff_input))
		IniWrite($Pfad_zur_Project_ISN, "TODOLIST_ITEM_" & GUICtrlRead($todoliste_neuer_eintrag_ID_label), "text", StringReplace(GUICtrlRead($todoliste_neuer_eintrag_text_edit), @CRLF, "[BREAK]"))
		$Datum_Array = _GUICtrlDTP_GetSystemTime(GUICtrlGetHandle($todoliste_neuer_eintrag_datum_input))
		If IsArray($Datum_Array) Then
			IniWrite($Pfad_zur_Project_ISN, "TODOLIST_ITEM_" & GUICtrlRead($todoliste_neuer_eintrag_ID_label), "date", StringFormat("%04d/%02d/%02d", $Datum_Array[0], $Datum_Array[1], $Datum_Array[2]))
		EndIf
		_QuickView_ToDo_Liste_neu_einlesen()
	EndIf
EndFunc   ;==>_ToDo_Liste_Liste_Neue_Aufgabe_schreiben

Func _ToDo_Liste_Liste_Neue_Aufgabe_OK()

	If GUICtrlRead($todoliste_neuer_eintrag_betreff_input) = "" Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1228), 0, $ToDo_Liste_neuer_eintrag_GUI)
		_Input_Error_FX($todoliste_neuer_eintrag_betreff_input)
		Return
	EndIf


	$ToDo_List_categories = IniRead($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", "categories", "")
	If $ToDo_List_categories = "" Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1293), 0, $ToDo_Liste_neuer_eintrag_GUI)
		Return ;Wenn keine Kategorien, dann stopp
	EndIf

	_ToDo_Liste_Liste_Neue_Aufgabe_schreiben()

	GUISetState(@SW_ENABLE, $Studiofenster)
	GUISetState(@SW_HIDE, $ToDo_Liste_neuer_eintrag_GUI)

EndFunc   ;==>_ToDo_Liste_Liste_Neue_Aufgabe_OK

Func _ToDo_Liste_Liste_Neue_Aufgabe_OK_Manager()

	If GUICtrlRead($todoliste_neuer_eintrag_betreff_input) = "" Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1228), 0, $ToDo_Liste_neuer_eintrag_GUI)
		_Input_Error_FX($todoliste_neuer_eintrag_betreff_input)
		Return
	EndIf


	$ToDo_List_categories = IniRead($Pfad_zur_Project_ISN, "ISNPROJECT_TODOLISTDATA", "categories", "")
	If $ToDo_List_categories = "" Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1293), 0, $ToDo_Liste_neuer_eintrag_GUI)
		Return ;Wenn keine Kategorien, dann stopp
	EndIf

	_ToDo_Liste_Liste_Neue_Aufgabe_schreiben()

	GUISetState(@SW_ENABLE, $Studiofenster)
	GUISetState(@SW_HIDE, $ToDo_Liste_neuer_eintrag_GUI)
	GUISetState(@SW_SHOW, $ToDoList_Manager)

EndFunc   ;==>_ToDo_Liste_Liste_Neue_Aufgabe_OK_Manager

Func _ToDo_Liste_Liste_Neue_Aufgabe_Manager()
	GUICtrlSetData($todoliste_neuer_eintrag_titel_label, _Get_langstr(1265))
	WinSetTitle($ToDo_Liste_neuer_eintrag_GUI, "", _Get_langstr(1265))

	$neue_Aufgabe_ID = @YEAR & @MON & @MDAY & @SEC & Random(0, 500, 1)
	GUICtrlSetData($todoliste_neuer_eintrag_ID_label, $neue_Aufgabe_ID)

	GUICtrlSetData($todoliste_neuer_eintrag_betreff_input, "")
	GUICtrlSetData($todoliste_neuer_eintrag_text_edit, "")
	GUICtrlSetData($todoliste_neuer_eintrag_datum_input, @YEAR & "/" & @MON & "/" & @MDAY)

	GUISetOnEvent($GUI_EVENT_CLOSE, "_ToDo_Liste_Liste_Neue_Aufgabe_Abbrechen_Manager", $ToDo_Liste_neuer_eintrag_GUI)
	GUICtrlSetOnEvent($todoliste_neuer_eintrag_ok_Button, "_ToDo_Liste_Liste_Neue_Aufgabe_OK_Manager")
	GUICtrlSetOnEvent($todoliste_neuer_eintrag_abbrechen_Button, "_ToDo_Liste_Liste_Neue_Aufgabe_Abbrechen_Manager")

	GUICtrlSetState($todoliste_neuer_eintrag_betreff_input, $GUI_FOCUS)

	GUISetState(@SW_HIDE, $ToDoList_Manager)
	GUISetState(@SW_SHOW, $ToDo_Liste_neuer_eintrag_GUI)
	GUISetState(@SW_DISABLE, $Studiofenster)
EndFunc   ;==>_ToDo_Liste_Liste_Neue_Aufgabe_Manager

Func _ToDo_Liste_Aufgabe_Bearbeiten_Manager()
	If _GUICtrlListView_GetSelectionMark($ToDoList_Listview) = -1 Then Return
	If _GUICtrlListView_GetItemCount($ToDoList_Listview) = 0 Then Return

	GUICtrlSetData($todoliste_neuer_eintrag_titel_label, _Get_langstr(1272))
	WinSetTitle($ToDo_Liste_neuer_eintrag_GUI, "", _Get_langstr(1272))

	$Aufgabe_ID = _GUICtrlListView_GetItemText($ToDoList_Listview, _GUICtrlListView_GetSelectionMark($ToDoList_Listview), 0)
	GUICtrlSetData($todoliste_neuer_eintrag_ID_label, $Aufgabe_ID)

	GUICtrlSetData($todoliste_neuer_eintrag_betreff_input, IniRead($Pfad_zur_Project_ISN, "TODOLIST_ITEM_" & $Aufgabe_ID, "subject", ""))
	GUICtrlSetData($todoliste_neuer_eintrag_text_edit, StringReplace(IniRead($Pfad_zur_Project_ISN, "TODOLIST_ITEM_" & $Aufgabe_ID, "text", ""), "[BREAK]", @CRLF))
	GUICtrlSetData($todoliste_neuer_eintrag_datum_input, IniRead($Pfad_zur_Project_ISN, "TODOLIST_ITEM_" & $Aufgabe_ID, "date", @YEAR & " / " & @MON & " / " & @MDAY))

	GUISetOnEvent($GUI_EVENT_CLOSE, "_ToDo_Liste_Liste_Neue_Aufgabe_Abbrechen_Manager", $ToDo_Liste_neuer_eintrag_GUI)
	GUICtrlSetOnEvent($todoliste_neuer_eintrag_ok_Button, "_ToDo_Liste_Aufgabe_Bearbeiten_OK_Manager")
	GUICtrlSetOnEvent($todoliste_neuer_eintrag_abbrechen_Button, "_ToDo_Liste_Liste_Neue_Aufgabe_Abbrechen_Manager")

	GUICtrlSetState($todoliste_neuer_eintrag_betreff_input, $GUI_FOCUS)

	GUISetState(@SW_HIDE, $ToDoList_Manager)
	GUISetState(@SW_SHOW, $ToDo_Liste_neuer_eintrag_GUI)
	GUISetState(@SW_DISABLE, $Studiofenster)
EndFunc   ;==>_ToDo_Liste_Aufgabe_Bearbeiten_Manager

Func _ToDo_Liste_Aufgabe_Bearbeiten_QuickView()
	If _GUICtrlListView_GetSelectionMark($quick_view_ToDoList_Listview) = -1 Then Return
	If _GUICtrlListView_GetItemCount($quick_view_ToDoList_Listview) = 0 Then Return

	GUICtrlSetData($todoliste_neuer_eintrag_titel_label, _Get_langstr(1272))
	WinSetTitle($ToDo_Liste_neuer_eintrag_GUI, "", _Get_langstr(1272))

	$Aufgabe_ID = _GUICtrlListView_GetItemText($quick_view_ToDoList_Listview, _GUICtrlListView_GetSelectionMark($quick_view_ToDoList_Listview), 0)
	GUICtrlSetData($todoliste_neuer_eintrag_ID_label, $Aufgabe_ID)

	GUICtrlSetData($todoliste_neuer_eintrag_betreff_input, IniRead($Pfad_zur_Project_ISN, "TODOLIST_ITEM_" & $Aufgabe_ID, "subject", ""))
	GUICtrlSetData($todoliste_neuer_eintrag_text_edit, StringReplace(IniRead($Pfad_zur_Project_ISN, "TODOLIST_ITEM_" & $Aufgabe_ID, "text", ""), "[BREAK]", @CRLF))
	GUICtrlSetData($todoliste_neuer_eintrag_datum_input, IniRead($Pfad_zur_Project_ISN, "TODOLIST_ITEM_" & $Aufgabe_ID, "date", @YEAR & " / " & @MON & " / " & @MDAY))

	GUISetOnEvent($GUI_EVENT_CLOSE, "_ToDo_Liste_Liste_Neue_Aufgabe_Abbrechen_QuickView", $ToDo_Liste_neuer_eintrag_GUI)
	GUICtrlSetOnEvent($todoliste_neuer_eintrag_ok_Button, "_ToDo_Liste_Aufgabe_Bearbeiten_OK_QuickView")
	GUICtrlSetOnEvent($todoliste_neuer_eintrag_abbrechen_Button, "_ToDo_Liste_Liste_Neue_Aufgabe_Abbrechen_QuickView")

	GUICtrlSetState($todoliste_neuer_eintrag_betreff_input, $GUI_FOCUS)

	GUISetState(@SW_HIDE, $ToDoList_Manager)
	GUISetState(@SW_SHOW, $ToDo_Liste_neuer_eintrag_GUI)
	GUISetState(@SW_DISABLE, $Studiofenster)
EndFunc   ;==>_ToDo_Liste_Aufgabe_Bearbeiten_QuickView

Func _ToDo_Liste_Aufgabe_Bearbeiten_OK_Daten_Schreiben()
	IniWrite($Pfad_zur_Project_ISN, "TODOLIST_ITEM_" & GUICtrlRead($todoliste_neuer_eintrag_ID_label), "subject", GUICtrlRead($todoliste_neuer_eintrag_betreff_input))
	IniWrite($Pfad_zur_Project_ISN, "TODOLIST_ITEM_" & GUICtrlRead($todoliste_neuer_eintrag_ID_label), "text", StringReplace(GUICtrlRead($todoliste_neuer_eintrag_text_edit), @CRLF, "[BREAK]"))
	$Datum_Array = _GUICtrlDTP_GetSystemTime(GUICtrlGetHandle($todoliste_neuer_eintrag_datum_input))
	If IsArray($Datum_Array) Then
		IniWrite($Pfad_zur_Project_ISN, "TODOLIST_ITEM_" & GUICtrlRead($todoliste_neuer_eintrag_ID_label), "date", StringFormat("%04d/%02d/%02d", $Datum_Array[0], $Datum_Array[1], $Datum_Array[2]))
	EndIf
	_QuickView_ToDo_Liste_neu_einlesen()
EndFunc   ;==>_ToDo_Liste_Aufgabe_Bearbeiten_OK_Daten_Schreiben


Func _ToDo_Liste_Aufgabe_Bearbeiten_OK_QuickView()

	If GUICtrlRead($todoliste_neuer_eintrag_betreff_input) = "" Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1228), 0, $ToDo_Liste_neuer_eintrag_GUI)
		_Input_Error_FX($todoliste_neuer_eintrag_betreff_input)
		Return
	EndIf

	_ToDo_Liste_Aufgabe_Bearbeiten_OK_Daten_Schreiben()

	GUISetState(@SW_ENABLE, $Studiofenster)
	GUISetState(@SW_HIDE, $ToDo_Liste_neuer_eintrag_GUI)

EndFunc   ;==>_ToDo_Liste_Aufgabe_Bearbeiten_OK_QuickView

Func _ToDo_Liste_Aufgabe_Bearbeiten_OK_Manager()

	If GUICtrlRead($todoliste_neuer_eintrag_betreff_input) = "" Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1228), 0, $ToDo_Liste_neuer_eintrag_GUI)
		_Input_Error_FX($todoliste_neuer_eintrag_betreff_input)
		Return
	EndIf

	_ToDo_Liste_Aufgabe_Bearbeiten_OK_Daten_Schreiben()

	GUISetState(@SW_ENABLE, $Studiofenster)
	GUISetState(@SW_HIDE, $ToDo_Liste_neuer_eintrag_GUI)
	GUISetState(@SW_SHOW, $ToDoList_Manager)

EndFunc   ;==>_ToDo_Liste_Aufgabe_Bearbeiten_OK_Manager

Func _ToDo_Liste_Liste_Neue_Aufgabe_Abbrechen_Manager()
	GUISetState(@SW_ENABLE, $Studiofenster)
	GUISetState(@SW_HIDE, $ToDo_Liste_neuer_eintrag_GUI)
	GUISetState(@SW_SHOW, $ToDoList_Manager)
EndFunc   ;==>_ToDo_Liste_Liste_Neue_Aufgabe_Abbrechen_Manager

Func _ToDo_Liste_Liste_Neue_Aufgabe_Abbrechen_QuickView()
	GUISetState(@SW_ENABLE, $Studiofenster)
	GUISetState(@SW_HIDE, $ToDo_Liste_neuer_eintrag_GUI)
EndFunc   ;==>_ToDo_Liste_Liste_Neue_Aufgabe_Abbrechen_QuickView


Func _ISNTooltip_with_Timer($text = "", $x = 0, $y = 0, $Title = "", $icon = 0, $options = "")
	ToolTip($text, $x, $y, $Title, $icon, $options)
	AdlibRegister("_ISNTooltip_Timer_Hide_Tooltips", 2000)
EndFunc   ;==>_ISNTooltip_with_Timer

Func _ISNTooltip_Timer_Hide_Tooltips()
	ToolTip("")
EndFunc   ;==>_ISNTooltip_Timer_Hide_Tooltips

Func _Handle_mit_Dollar_zurueckgeben($handle = "")
	If $handle = "" Then Return ""
	$handle = StringStripWS($handle, 3)
	$handle = StringReplace($handle, "$$", "")
	$handle = StringReplace($handle, "$$$", "")
	$handle = StringReplace($handle, "$$$$", "")
	If StringLeft($handle, 1) <> "$" Then
		Return "$" & $handle
	Else
		Return $handle
	EndIf
EndFunc   ;==>_Handle_mit_Dollar_zurueckgeben

; ==================================================================================================
; Func _WinAPI_ProcessGetFilename($vProcessID,$bFullPath=False)
;
; Function to get the process executable filename, or full path name, for Process
;       using DLL calls rather than WMI.
;
; $vProcessID = either a process name ("explorer.exe") or Process ID (2314)
; $bFullPath = If True, return the full path to the executable. If False, just return the process executable filename.
;
; Returns:
;   Success: String - either full path or just executable name, based on $bFullPath parameter
;   Failure: "" empty string, with @error set:
;       @error = 1 = invalid parameter or process name not found to 'exist'
;       @error = 2 = DLL call error, use _WinAPI_GetLastError()
;       @error = 3 = Couldn't obtain Process handle
;       @error = 4 = empty string returned from call (possible privilege issue)
;
; Author: Ascend4nt
; ==================================================================================================

Func _WinAPI_ProcessGetFilename($vProcessID, $bFullPath = False)
	; Not a Process ID? Must be a Process Name
	If Not IsNumber($vProcessID) Then
		$vProcessID = ProcessExists($vProcessID)
		; Process Name not found (or invalid parameter?)
		If Not $vProcessID Then Return SetError(1, 0, "")
	EndIf

	Local $sDLLFunctionName, $tErr

	; Since the parameters and returns are the same for both of these DLL calls, we can keep it all in one function
	If $bFullPath Then
		$sDLLFunctionName = "GetModuleFileNameExW"
	Else
		$sDLLFunctionName = "GetModuleBaseNameW"
	EndIf

	; Get process handle
	Local $hProcess = DllCall('kernel32.dll', 'ptr', 'OpenProcess', 'int', BitOR(0x400, 0x10), 'int', 0, 'int', $vProcessID)
	If @error Then Return SetError(2, 0, "")
	If Not $hProcess[0] Then Return SetError(3, 0, "")

	; Create 'receiving' string buffers and make the call
	; Path length size maximum in Unicode is 32767 (-1 for NULL)
	Local $stFilename = DllStructCreate("wchar[32767]")
	; Make the call (same parameters for both)
	Local $aRet = DllCall("Psapi.dll", "dword", $sDLLFunctionName, "ptr", $hProcess[0], "ptr", 0, "ptr", DllStructGetPtr($stFilename), "dword", 32767)

	If @error Then
		$tErr = 2
	ElseIf Not $aRet[0] Then
		$tErr = 4
	Else
		$tErr = 0
	EndIf
	; Close process handle
	DllCall('kernel32.dll', 'int', 'CloseHandle', 'ptr', $hProcess[0])
	; Error above?
	If $tErr Then Return SetError($tErr, 0, "")

	;$stFilename should now contain either the filename or full path string (based on $bFullPath)
	Local $sFileName = DllStructGetData($stFilename, 1)

	; DLLStructDelete()'s
	$stFilename = 0
	$hProcess = 0

	SetError(0)
	Return $sFileName
EndFunc   ;==>_WinAPI_ProcessGetFilename

Func _ISN_Update_pruefe_ob_installer_vorhanden_ist()
	Local $ReturnValue = 1	
	
	If Not FileExists(@ScriptDir & "\update_installer.a3x") Then
		;EXTRACT HERE THE MISSING UPDATER!!!
		If _ISN_Update_Installer_aus_Package_installieren() <> 1 Then
			MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1332), 0)
			$ReturnValue = -1
		EndIf
	EndIf
	
	If Not FileExists(@ScriptDir & "\Data\ISN_Adme.a3x") Then
		;EXTRACT THE MISSING Administrator Elevation File!!!
		If _ISN_Adme_aus_Package_installieren() <> 1 Then
			MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1559), 0)
			$ReturnValue = -1
		EndIf
	EndIf
	
	Return $ReturnValue
EndFunc   ;==>_ISN_Update_pruefe_ob_installer_vorhanden_ist


Func _ISN_AutoIt_Studio_nach_updates_Suchen()

	If Not @Compiled Then
		MsgBox(262144 + 16, _Get_langstr(25), StringReplace(_Get_langstr(1468), "%1", $Studioversion & " (" & $VersionBuild & ")"), 0, 0)
		Return
	EndIf

	If _ISN_Update_pruefe_ob_installer_vorhanden_ist() <> 1 Then Return

	If Not FileExists($autoitexe) Then
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1461), 0, 0)
		Return
	EndIf

	If ProcessExists($ISN_Helper_Threads[$ISN_Helper_Updater][$ISN_Helper_PID]) Then
		MsgBox(262144 + 64, _Get_langstr(61), _Get_langstr(1325), 0)
		Return
	EndIf

	GUICtrlSetData($willkommen_update_suchen_button, _Get_langstr(337))
	GUICtrlSetState($willkommen_update_suchen_button, $GUI_DISABLE)

	$ISN_Scripttest_helper_Array = _Run_New_AutoIt_Studio_Helper_Instance('"/thread_task searchupdates"')
	If IsArray($ISN_Scripttest_helper_Array) Then
		$ISN_Helper_Threads[$ISN_Helper_Updater][$ISN_Helper_Handle] = $ISN_Scripttest_helper_Array[0] ;Handle
		$ISN_Helper_Threads[$ISN_Helper_Updater][$ISN_Helper_PID] = $ISN_Scripttest_helper_Array[1] ;PID
	Else
		$ISN_Helper_Threads[$ISN_Helper_Updater][$ISN_Helper_Handle] = ""
		$ISN_Helper_Threads[$ISN_Helper_Updater][$ISN_Helper_PID] = ""
		_Write_ISN_Debug_Console("Unable to start ISN updater thread!", $ISN_Debug_Console_Errorlevel_Critical, $ISN_Debug_Console_Linebreak)
		Return
	EndIf

EndFunc   ;==>_ISN_AutoIt_Studio_nach_updates_Suchen

Func _install_local_upgrade_file()
	If _ISN_Update_pruefe_ob_installer_vorhanden_ist() <> 1 Then Return
	If ProcessExists($ISN_Helper_Threads[$ISN_Helper_Updater][$ISN_Helper_PID]) Then
		MsgBox(262144 + 64, _Get_langstr(61), _Get_langstr(1325), 0)
		Return
	EndIf

	If $Skin_is_used = "true" Then
		$localupdatefile = _WinAPI_OpenFileDlg("Choose file to install", "", "All (*.*)", 0, '', '', BitOR($OFN_PATHMUSTEXIST, $OFN_FILEMUSTEXIST, $OFN_HIDEREADONLY), $OFN_EX_NOPLACESBAR, 0, 0, 0)
	Else
		$localupdatefile = FileOpenDialog("Choose file to install", "", "All (*.*)", 1 + 2, "", 0)
	EndIf
	If @error Or $localupdatefile = "" Then Return

	$res = MsgBox(48 + 262144 + 4, "Warning", "Are you sure to install this updatefile?" & @CRLF & "Installing a wrong update file may damage your ISN AutoIt Studio installation!!" & @CRLF & @CRLF & "Continue?", 0)
	If @error Or $res <> 6 Then Return

	GUICtrlSetData($willkommen_update_suchen_button, _Get_langstr(337))
	GUICtrlSetState($willkommen_update_suchen_button, $GUI_DISABLE)

	$ISN_Scripttest_helper_Array = _Run_New_AutoIt_Studio_Helper_Instance('"/thread_task searchupdates" "/updaterlocal_file ' & $localupdatefile & '"')
	If IsArray($ISN_Scripttest_helper_Array) Then
		$ISN_Helper_Threads[$ISN_Helper_Updater][$ISN_Helper_Handle] = $ISN_Scripttest_helper_Array[0] ;Handle
		$ISN_Helper_Threads[$ISN_Helper_Updater][$ISN_Helper_PID] = $ISN_Scripttest_helper_Array[1] ;PID
	Else
		$ISN_Helper_Threads[$ISN_Helper_Updater][$ISN_Helper_Handle] = ""
		$ISN_Helper_Threads[$ISN_Helper_Updater][$ISN_Helper_PID] = ""
		_Write_ISN_Debug_Console("Unable to start ISN updater thread!", $ISN_Debug_Console_Errorlevel_Critical, $ISN_Debug_Console_Linebreak)
		Return
	EndIf

EndFunc   ;==>_install_local_upgrade_file


Func _ISN_AutoIt_Studio_nach_updates_Suchen_Silent()

	If Not @Compiled Then Return

	If _ISN_Update_pruefe_ob_installer_vorhanden_ist() <> 1 Then Return
	If ProcessExists($ISN_Helper_Threads[$ISN_Helper_Updater][$ISN_Helper_PID]) Then Return ;Läuft bereits

	GUICtrlSetData($willkommen_update_suchen_button, _Get_langstr(337))
	GUICtrlSetState($willkommen_update_suchen_button, $GUI_DISABLE)

	$ISN_Scripttest_helper_Array = _Run_New_AutoIt_Studio_Helper_Instance('"/thread_task searchupdates" "/updater_mode silent"')
	If IsArray($ISN_Scripttest_helper_Array) Then
		$ISN_Helper_Threads[$ISN_Helper_Updater][$ISN_Helper_Handle] = $ISN_Scripttest_helper_Array[0] ;Handle
		$ISN_Helper_Threads[$ISN_Helper_Updater][$ISN_Helper_PID] = $ISN_Scripttest_helper_Array[1] ;PID
	Else
		$ISN_Helper_Threads[$ISN_Helper_Updater][$ISN_Helper_Handle] = ""
		$ISN_Helper_Threads[$ISN_Helper_Updater][$ISN_Helper_PID] = ""
		_Write_ISN_Debug_Console("Unable to start ISN updater thread!", $ISN_Debug_Console_Errorlevel_Critical, $ISN_Debug_Console_Linebreak)
		Return
	EndIf

EndFunc   ;==>_ISN_AutoIt_Studio_nach_updates_Suchen_Silent




Func _Hotkey_Scintilla_Paste_func()
	If $Offenes_Projekt = "" Then Return
	Local $current_window = _WinAPI_GetFocus()
	If _WinAPI_GetClassName($current_window) <> "Scintilla" Then Return
	SendMessage($current_window, $SCI_PASTE, 0, 0)
	_Check_tabs_for_changes()
EndFunc   ;==>_Hotkey_Scintilla_Paste_func

Func _Hotkey_Scintilla_BackTab_func()
	If $Offenes_Projekt = "" Then Return
	Local $current_window = _WinAPI_GetFocus()
	If _WinAPI_GetClassName($current_window) <> "Scintilla" Then Return
	_ISN_AutoIt_Studio_deactivate_GUI_Messages()
	SendMessage($current_window, $SCI_BACKTAB, 0, 0)
	_ISN_AutoIt_Studio_activate_GUI_Messages()
EndFunc   ;==>_Hotkey_Scintilla_BackTab_func


Func _Hotkey_Scintilla_Tab_func()
	If $Offenes_Projekt = "" Then Return
	Local $current_window = _WinAPI_GetFocus()
	If _WinAPI_GetClassName($current_window) <> "Scintilla" Then Return
	_ISN_AutoIt_Studio_deactivate_GUI_Messages()

	If SendMessage($current_window, $SCI_AUTOCACTIVE, 0, 0) And $allow_autocomplete_with_tabkey = "true" Then

		_ISN_AutoIt_Studio_activate_GUI_Messages()
		SendMessage($current_window, $SCI_AUTOCCOMPLETE, 0, 0) ;Allow autocomplete with tab key
		Return

	Else

		SendMessage($current_window, $SCI_TAB, 0, 0)

;~ 		Local $Sci_GetCurrentPos = Sci_GetCurrentPos($current_window)
;~ 		Local $selection_start = SendMessage($current_window, $SCI_GETSELECTIONSTART, 0, 0)
;~ 		Local $selection_end = SendMessage($current_window, $SCI_GETSELECTIONEND, 0, 0)
;~ 		Local $Startline = SendMessage($current_window, $SCI_LINEFROMPOSITION, $selection_start, 0)
;~ 		Local $endline = SendMessage($current_window, $SCI_LINEFROMPOSITION, $selection_end, 0)
;~ 		Local $CurrentPos = Sci_GetCurrentPos($current_window)

;~ 		If $Startline <> $endline Then
;~ 			;Multiline
;~ 			Sci_BeginUndoAction($current_window)
;~ 			For $Count = $Startline To $endline
;~ 				Sci_InsertText($current_window, Sci_GetLineStartPos($current_window, $Count), @TAB)
;~ 			Next
;~ 			If SendMessage($current_window, $SCI_LINEFROMPOSITION, $CurrentPos, 0) = $Startline Then
;~ 				Sci_SetSelection($current_window, Sci_GetLineEndPos($current_window, $endline), $selection_start)
;~ 			Else
;~ 				Sci_SetSelection($current_window, $selection_start, Sci_GetLineEndPos($current_window, $endline))
;~ 			EndIf
;~ 			Sci_EndUndoAction($current_window)
;~ 		Else
;~ 			;Single
;~ 			If SendMessage($current_window, $SCI_GETSELECTIONSTART, 0, 0) = 0 And SendMessage($current_window, $SCI_GETSELECTIONEND, 0, 0) = 0 Then
;~ 				Sci_InsertText($current_window, $Sci_GetCurrentPos, @TAB)
;~ 				Sci_SetCurrentPos($current_window, $Sci_GetCurrentPos + 1)
;~ 			Else
;~ 				Sci_ReplaceSel($current_window, @TAB)
;~ 			EndIf
;~ 		EndIf

	EndIf

	If WinActive($ParameterEditor_GUI) And _GUICtrlListView_GetSelectionMark($ParameterEditor_ListView) <> -1 Then
		If $autoit_editor_encoding = "2" Then
			_GUICtrlListView_SetItemText($ParameterEditor_ListView, _GUICtrlListView_GetSelectionMark($ParameterEditor_ListView), _ANSI2UNICODE(StringReplace(Sci_GetText($ParameterEditor_SCIEditor), @CRLF, "")), 1)
		Else
			_GUICtrlListView_SetItemText($ParameterEditor_ListView, _GUICtrlListView_GetSelectionMark($ParameterEditor_ListView), StringReplace(Sci_GetText($ParameterEditor_SCIEditor), @CRLF, ""), 1)
		EndIf
		AdlibRegister("_Parameter_Editor_Aktualisiere_Vorschaulabel", 1)
	EndIf

	_ISN_AutoIt_Studio_activate_GUI_Messages()
	_Check_tabs_for_changes()
EndFunc   ;==>_Hotkey_Scintilla_Tab_func



Func GetSystemMenu($hWnd, $bRevert)
	Local $hMenu = DllCall("user32.dll", "hwnd", "GetSystemMenu", _
			"hwnd", $hWnd, _
			"int", $bRevert)
	Return $hMenu[0]
EndFunc   ;==>GetSystemMenu

Func InsertMenu($hMenu, $nPosition, $nFlags, $nIDNewItem, $lpNewItem)
	Local $nResult = DllCall("user32.dll", "int", "InsertMenu", _
			"hwnd", $hMenu, _
			"int", $nPosition, _
			"int", $nFlags, _
			"int", $nIDNewItem, _
			"str", $lpNewItem)
	Return $nResult[0]
EndFunc   ;==>InsertMenu

Func CreatePopupMenu()
	Local $hMenu = DllCall("user32.dll", "hwnd", "CreatePopupMenu")
	Return $hMenu[0]
EndFunc   ;==>CreatePopupMenu

Func CheckMenuItem($hMenu, $nID, $nFlags)
	DllCall("user32.dll", "int", "CheckMenuItem", _
			"hwnd", $hMenu, _
			"int", $nID, _
			"int", $nFlags)
EndFunc   ;==>CheckMenuItem

Func CreateSystemMenuItem($hGUI, $sText, $hMenu = -1, $bIsPopup = False, $nPos = 0xFFFFFFFF) ; 0xFFFFFFFF means "insert at the end"

	If $hMenu = -1 Then $hMenu = GetSystemMenu($hGUI, 0)

	Local $nID = GUICtrlCreateDummy()
	Local $nFlags = 0

	If $sText = "" Then
		$nFlags = $MF_SEPARATOR
	ElseIf $bIsPopup Then
		$nID = CreatePopupMenu()
		$nFlags = $MF_POPUP
	EndIf

	$nFlags = BitOR($MF_BYPOSITION, $nFlags)

	$nResult = InsertMenu($hMenu, $nPos, $nFlags, $nID, $sText)

	Return $nID
EndFunc   ;==>CreateSystemMenuItem

Func GUICheckBoxSetColor(ByRef $CtrlID, $iColor, $iBkColor = "0xF1EDED")
	$CtrlHWnd = $CtrlID
	If Not IsHWnd($CtrlHWnd) Then $CtrlHWnd = GUICtrlGetHandle($CtrlID)
	$aParent = DllCall("user32.dll", "hwnd", "GetParent", "hwnd", $CtrlHWnd)
	$aCPos = _ControlGetPos($aParent[0], "", $CtrlID)
	$sOldT = GUICtrlRead($CtrlID, 1)
	GUICtrlDelete($CtrlID)
	DllCall('uxtheme.dll', 'none', 'SetThemeAppProperties', 'int', 0)
	$CtrlID = GUICtrlCreateCheckbox($sOldT, $aCPos[0], $aCPos[1], $aCPos[2], $aCPos[3])
	_Control_set_DPI_Scaling($CtrlID)
	GUICtrlSetColor(-1, $iColor)
	GUICtrlSetBkColor(-1, $iBkColor)
	DllCall('uxtheme.dll', 'none', 'SetThemeAppProperties', 'int', 7)
EndFunc   ;==>GUICheckBoxSetColor

Func _ISN_AutoIt_Studio_start_Scripttree_Helper_Thread()
	$ISN_Scripttree_Helper_Thread_Array = _Run_New_AutoIt_Studio_Helper_Instance('"/thread_task scripttree"')
	If IsArray($ISN_Scripttree_Helper_Thread_Array) Then
		$ISN_Helper_Threads[$ISN_Helper_Scripttree][$ISN_Helper_Handle] = $ISN_Scripttree_Helper_Thread_Array[0] ;Handle
		$ISN_Helper_Threads[$ISN_Helper_Scripttree][$ISN_Helper_PID] = $ISN_Scripttree_Helper_Thread_Array[1] ;PID
	Else
		_Write_ISN_Debug_Console("Unable to start ISN Helper Thread for the thread 'scripttree'!", 3)
		Return
	EndIf
EndFunc   ;==>_ISN_AutoIt_Studio_start_Scripttree_Helper_Thread

Func _RedirectOutputToCommandLineTool($text = "")
	If $text = "" Or $ISN_Helper_Threads[$ISN_Helper_CommandLineTool][$ISN_Helper_Handle] = "" Or $ISN_Helper_Threads[$ISN_Helper_CommandLineTool][$ISN_Helper_PID] = "" Then Return
	_ISN_Call_Async_Function_in_Plugin($ISN_Helper_Threads[$ISN_Helper_CommandLineTool][$ISN_Helper_Handle], "_ConsoleWrite", String($text))
EndFunc   ;==>_RedirectOutputToCommandLineTool

Func _ISN_AutoIt_Studio_Register_CommandLineTool($handle = "", $PID = "")
	If $PID = "" Or $handle = "" Then Return
	If $ISN_Helper_Threads[$ISN_Helper_CommandLineTool][$ISN_Helper_PID] <> "" Then
		_Write_ISN_Debug_Console("A new command line tool instance wanted to connect to this ISN session, but there is already another one connected!", 3)
		Return
	EndIf
	$ISN_Helper_Threads[$ISN_Helper_CommandLineTool][$ISN_Helper_Handle] = HWnd($handle) ;Handle
	$ISN_Helper_Threads[$ISN_Helper_CommandLineTool][$ISN_Helper_PID] = $PID ;PID
	_Write_ISN_Debug_Console("A new command line tool instance has been registered as ISN thread into this session with PID " & $PID & " and handle " & $handle & "!", 2)
EndFunc   ;==>_ISN_AutoIt_Studio_Register_CommandLineTool

Func _ISN_AutoIt_Studio_Unregister_CommandLineTool()
	$ISN_Helper_Threads[$ISN_Helper_CommandLineTool][$ISN_Helper_Handle] = "" ;Handle
	$ISN_Helper_Threads[$ISN_Helper_CommandLineTool][$ISN_Helper_PID] = "" ;PID
	_Write_ISN_Debug_Console("The command line tool has disconnected! It will no longer recieve any new messages.", 2)
EndFunc   ;==>_ISN_AutoIt_Studio_Unregister_CommandLineTool


Func _ISN_AutoIt_Studio_Exit_All_Helper_Threads()
	For $Count = 0 To UBound($ISN_Helper_Threads) - 1
		If $Count = $ISN_Helper_Updater Then ContinueLoop ;We won´t kill the updater..
		If $Count = $ISN_Helper_CommandLineTool Then ContinueLoop ;..and the CommandLineTool
		If ProcessExists($ISN_Helper_Threads[$Count][$ISN_Helper_PID]) Then
			_Write_ISN_Debug_Console("|--> Sending 'exit' command to thread '" & $ISN_Helper_Threads[$Count][$ISN_Helper_Handle] & "'...", 1)
			_ISN_Send_Message_to_Plugin($ISN_Helper_Threads[$Count][$ISN_Helper_Handle], "exit")
		EndIf
	Next
EndFunc   ;==>_ISN_AutoIt_Studio_Exit_All_Helper_Threads

Func _Skriptbaum_aktualisieren()
	If $Offenes_Projekt = "" Then Return
	If _GUICtrlTab_GetItemCount($htab) < 1 Then Return
	_ISN_Call_Async_Function_in_Plugin($ISN_Helper_Threads[$ISN_Helper_Scripttree][$ISN_Helper_Handle], "_Scripttree_Force_Refresh", String(_GUICtrlTab_GetCurFocus($htab))) ;Load Scripttree
EndFunc   ;==>_Skriptbaum_aktualisieren

Func _ISN_AutoIt_Studio_Destroy_GUI_Tooltips()
	_GUIToolTip_Destroy($hToolTip_CreditsGUI)
	_GUIToolTip_Destroy($hToolTip_pelock_obfuscator_GUI)
	_GUIToolTip_Destroy($hToolTip_QuickView_GUI)
	_GUIToolTip_Destroy($hToolTip_Welcome_GUI)
	_GUIToolTip_Destroy($hToolTip_ParameterEditor_GUI)
	_GUIToolTip_Destroy($hToolTip_trophys)
	_GUIToolTip_Destroy($hToolTip_Config_GUI)
	_GUIToolTip_Destroy($hToolTip_changelog_generieren_GUI)
	_GUIToolTip_Destroy($hToolTip_newrule_GUI)
	_GUIToolTip_Destroy($hToolTip_ToDoList_Category_Manager)
	_GUIToolTip_Destroy($hToolTip_ToDoList_Manager)
	_GUIToolTip_Destroy($hToolTip_StudioFenster)
	_GUIToolTip_Destroy($hToolTip_Find_GUI)
EndFunc   ;==>_ISN_AutoIt_Studio_Destroy_GUI_Tooltips

Func __WinAPI_OpenFileDlg_Multi_to_FileOpenDialog_MultiStr($array = "")
	If $array = "" Then Return ""
	If Not IsArray($array) Then Return ""
	if $array[0] <  1 then Return ""
	$path = StringTrimRight($array[1], StringLen($array[1]) - StringInStr($array[1], "\", 0, -1) + 1) & "|"
	For $x = 1 To UBound($array) - 1
		$path = $path & StringTrimLeft($array[$x], StringInStr($array[1], "\", 0, -1)) & "|"
	Next
	If StringRight($path, 1) = "|" Then $path = StringTrimRight($path, 1)
	Return $path
EndFunc   ;==>__WinAPI_OpenFileDlg_Multi_to_FileOpenDialog_MultiStr



Func _ISN_Add_Icon_to_Button($hbutton = "", $iconfile = "", $Index = 0, $aligment = 0, $size = 16)
	If $Skin_is_used = "true" Then
		$Pos_Array = _ControlGetPos(GUICtrlGetHandle($hbutton), "", 0)
		If IsArray($Pos_Array) Then
			GUICtrlSetStyle($hbutton, BitOR($GUI_SS_DEFAULT_BUTTON, $WS_CLIPSIBLINGS))
			GUICtrlSetState($hbutton, $GUI_ONTOP)

			GUICtrlCreatePic("", $Pos_Array[0] + 7, $Pos_Array[1] + (($Pos_Array[3] / 2) - ($size / 2)), $size, $size)
			GUICtrlSetState(-1, $GUI_DISABLE + $GUI_ONTOP)
			_SetIconAlpha(-1, $iconfile, $Index + 3, $size, $size)
;~ 			_SetImage($ico, "C:\Users\ISI\Google Drive\ProjektX\ISN AutoIt Studio\Data\isi360_logo_m.png")
;~ 			GUICtrlSetPos(-1, $Pos_Array[0]+7, $Pos_Array[1]+8, $size*$DPI, $size*$DPI)
;~

;~ 		    $ico = GUICtrlCreatePic("",$Pos_Array[0]-20, $Pos_Array[1]-50, 128, 128)

;~ 			_SetImage($ico, "C:\Users\ISI\Google Drive\ProjektX\ISN AutoIt Studio\Data\isi360_logo_m.png")
;~ _SetIconAlpha(-1, "shell32.dll",20,128,128)
;~ GUICtrlSetState( -1, $GUI_DISABLE)
;~ 			GUICtrlSetPos($ico,$Pos_Array[0]+7, $Pos_Array[1]+8, $size*$DPI, $size*$DPI)



;~ 			If $BIresizing > -1 Then GUICtrlSetResizing(-1, $BIresizing) ; $GUI_DOCKALL + $GUI_DOCKVCENTER)
;~

		EndIf


	Else
		; Button_AddIcon($hbutton, $iconfile, $index,$aligment)
	EndIf
EndFunc   ;==>_ISN_Add_Icon_to_Button


Func _ISN_Display_Imagelist($hList = "", $cnt = 40)
	If $hList = "" Then Return
	Local $Listview, $hImage

	GUICreate("ImageList AddBitmap", 400, 300)
	$Listview = GUICtrlCreateListView("", 2, 2, 394, 268, BitOR($LVS_SHOWSELALWAYS, $LVS_NOSORTHEADER, $LVS_REPORT))
	_GUICtrlListView_SetExtendedListViewStyle($Listview, BitOR($LVS_EX_FULLROWSELECT, $LVS_EX_GRIDLINES, $LVS_EX_DOUBLEBUFFER))
	_GUICtrlListView_SetImageList($Listview, $hList, 1)
	GUISetState()



	; Add columns
	_GUICtrlListView_AddColumn($Listview, "Items", 120)

	; Add items
	For $x = 0 To $cnt
		_GUICtrlListView_AddItem($Listview, $x, $x)

	Next
EndFunc   ;==>_ISN_Display_Imagelist





; #FUNCTION# =========================================================================================================
; Name...........: _GUIScrollbars_ReSizer
; Description ...: Registers required handlers and optionally creates GUI at max scrollable size
; Syntax.........: _GUIScrollbars_ReSizer ($hWnd, $iH_Max, $iV_Max, [, $bFullClient = False [, $bRegisterMsg = True]])
; Parameters ....: $hWnd         -> Resizable GUI
;                  $iH_Max       -> Max width where scrollbars needed
;                  $iV_Max       -> Max height where scrollbars needed
;                  $bFullClient  -> False (default) - GUI remains at created size and scrollbars shown if required
;                                   True - GUI resized to maximum client area where scrollbars not required
;                  $bRegisterMsg -> True (default) - Register WM_ENTER/EXITSIZEMOVE handlers
;                                   False - Do not register handlers
; Requirement(s).: v3.3.6.0 or higher
; Return values .: Success - An array holding width and height of GUI when scrollbars not needed
;                  Failure - Returns 0 with @error set as follows:
;                            1 - Invalid window handle
;                            2 - GUI not initiated
;                            3 - GUI not resizable
; Remarks .......; - Resizable GUIs have slightly smaller client areas than defined in GUICreate because of their
;                  thicker borders - setting $bFullClient to True resizes the GUI client area to the correct size
;                  - As this function resizes the GUI, it should be run BEFORE making the GUI visible
;                  - If there are existing message handlers for the WM_ENTER/EXITSIZEMOVE messages then
;                  $bMessageReg should be set to False and the relevant handler function(s) added to these handler(s)
;                  or registered separately
;                  - The returned array can be used in a WM_GETMINMAXINFO handler to prevent GUI being oversized
; Author ........: Melba23
; Example........; Yes
;=====================================================================================================================
Func _GUIScrollbars_ReSizer_ISN($hWnd, $iH_Max, $iV_Max, $bFullClient = False, $bRegisterMsg = True)

	; Check $hWnd
	If Not IsHWnd($hWnd) Then Return SetError(1, 0, 0)

	; Search for existing GUI
	For $iIndex = 1 To $__g_aSB_WindowInfo[0][0]
		If $hWnd = $__g_aSB_WindowInfo[$iIndex][0] Then
			ExitLoop
		EndIf
	Next
	If $iIndex > $__g_aSB_WindowInfo[0][0] Then Return SetError(2, 0, 0)

	; Check GUI resizable
	;If Not BitAND(_WinAPI_GetWindowLong($hWnd, $GWL_STYLE), 0x00040000) Then Return SetError(3, 0, 0)

	; Set max scrollable sizes
	$__g_aSB_WindowInfoEx[$iIndex][7] = $iH_Max
	$__g_aSB_WindowInfoEx[$iIndex][8] = $iV_Max

	; Get current GUI size
	Local $aPos = _WinGetPos($hWnd)
	; Resize GUI to max scrollable size
	_GUIScrollBars_ShowScrollBar($hWnd, $SB_BOTH, False)
	Local $aClientSize = _WinGetClientSize($hWnd)
	; Resize GUI to set correct client area for max size
	Local $aMaxSize[2] = [$aPos[2] + $__g_aSB_WindowInfoEx[$iIndex][7] - $aClientSize[0], $aPos[3] + $__g_aSB_WindowInfoEx[$iIndex][8] - $aClientSize[1]]
	;WinMove($hWnd, "", Default, Default, $aMaxSize[0], $aMaxSize[1])

	; Is GUI to be resized to original size
	If Not $bFullClient Then
		; Set scroll values
		$__g_aSB_WindowInfo[0][1] = 0
		$__g_aSB_WindowInfo[0][2] = 0
		; Resize GUI
		;WinMove($hWnd, "", Default, Default, $aPos[2], $aPos[3])
		; Adjust Scrollbars
		$__g_aSB_WindowInfo[0][3] = $hWnd
		$__g_aSB_WindowInfo[0][4] = $iIndex




		; Check if handle matches
		If $hWnd = $__g_aSB_WindowInfo[0][3] And $__g_aSB_WindowInfo[0][4] <> -1 Then
			; Retrieve index
			Local $iIndex = $__g_aSB_WindowInfo[0][4]
			; Get final size
			Local $aClientSize = _WinGetClientSize($hWnd)
			; Check if scrollbars needed
			Local $iH_Aperture = 0, $iV_Aperture = 0, $iH_Reduction = 0, $iV_Reduction = 0
			; Loop to check if client area reduced by scrollbars
			For $i = 1 To 2
				If $aClientSize[0] < $__g_aSB_WindowInfoEx[$iIndex][7] + $iH_Reduction Then
					$iH_Aperture = $__g_aSB_WindowInfoEx[$iIndex][7] + $iH_Reduction
					$iV_Reduction = $__g_aSB_WindowInfo[0][6] ; Height of HScrollbar
				EndIf
				If $aClientSize[1] < $__g_aSB_WindowInfoEx[$iIndex][8] + $iV_Reduction Then
					$iV_Aperture = $__g_aSB_WindowInfoEx[$iIndex][8] + $iV_Reduction
					$iH_Reduction = $__g_aSB_WindowInfo[0][5] ; Width of VScrollbar
				EndIf
			Next
			If $iH_Aperture Then _GUIScrollBars_SetScrollInfoPos($hWnd, $SB_HORZ, $__g_aSB_WindowInfo[0][1])
			If $iV_Aperture Then _GUIScrollBars_SetScrollInfoPos($hWnd, $SB_VERT, $__g_aSB_WindowInfo[0][2])
			; Generate required scrollbars
			_GUIScrollbars_Generate($hWnd, $iH_Aperture, $iV_Aperture)
			; Reset scrollbar positions
			If $iH_Aperture Then _GUIScrollBars_SetScrollInfoPos($hWnd, $SB_HORZ, $__g_aSB_WindowInfo[0][1])
			If $iV_Aperture Then _GUIScrollBars_SetScrollInfoPos($hWnd, $SB_VERT, $__g_aSB_WindowInfo[0][2])
			; Clear GUI handle and index
			$__g_aSB_WindowInfo[0][1] = 0
			$__g_aSB_WindowInfo[0][4] = -1
		EndIf


	EndIf

	; Register mesaage handlers if required
	If $bRegisterMsg Then
		GUIRegisterMsg($WM_EXITSIZEMOVE, "_Scrollbars_WM_EXITSIZEMOVE")
		GUIRegisterMsg($WM_ENTERSIZEMOVE, "_Scrollbars_WM_ENTERSIZEMOVE")
	EndIf

	; Return max GUI size
	Return $aMaxSize

EndFunc   ;==>_GUIScrollbars_ReSizer_ISN

Func _ISN_Get_MainExecutable_Path_for_Windows()
	If @Compiled Then
		Return '"' & @ScriptDir & "\" & 'AutoIt_Studio.exe"'
	Else
		Return $autoitexe & ' "' & @ScriptDir & "\" & @ScriptName & '"'
	EndIf
EndFunc   ;==>_ISN_Get_MainExecutable_Path_for_Windows

Func _ISN_Register_Filetypes()
	If $registerinexplorer = "true" Then
		RegDelete("HKEY_CLASSES_ROOT\AutoIt3Script\Shell\Edit_ISN")
		RegWrite("HKEY_CURRENT_USER\SOFTWARE\Classes\AutoIt3Script\Shell\Edit_ISN", "", "REG_SZ", _Get_langstr(674))
		RegWrite("HKEY_CURRENT_USER\SOFTWARE\Classes\AutoIt3Script\Shell\Edit_ISN\Command", "", "REG_SZ", _ISN_Get_MainExecutable_Path_for_Windows() & ' "%1"')
	Else
		RegDelete("HKEY_CLASSES_ROOT\AutoIt3Script\Shell\Edit_ISN")
		RegDelete("HKEY_CURRENT_USER\SOFTWARE\Classes\AutoIt3Script\Shell\Edit_ISN")
	EndIf

	If $registerau3files = "true" Then
		RegDelete("HKEY_CLASSES_ROOT\AutoIt3Script\Shell\Edit_ISN")
		RegWrite("HKEY_CURRENT_USER\SOFTWARE\Classes\AutoIt3Script\Shell\Edit_ISN", "", "REG_SZ", _Get_langstr(674))
		RegWrite("HKEY_CURRENT_USER\SOFTWARE\Classes\AutoIt3Script\Shell\Edit_ISN\Command", "", "REG_SZ", _ISN_Get_MainExecutable_Path_for_Windows() & ' "%1"')
		If RegRead("HKEY_CURRENT_USER\SOFTWARE\Classes\AutoIt3Script\Shell", "") <> "Edit_ISN" Then
			_Write_in_Config("SciTE4AutoIt_au3mode", RegRead("HKEY_CURRENT_USER\SOFTWARE\Classes\AutoIt3Script\Shell", ""))
		EndIf
		RegWrite("HKEY_CURRENT_USER\SOFTWARE\Classes\AutoIt3Script\Shell", "", "REG_SZ", "Edit_ISN")
	Else
		If RegRead("HKEY_CURRENT_USER\SOFTWARE\Classes\AutoIt3Script\Shell", "") <> "Edit_ISN" Then
			_Write_in_Config("SciTE4AutoIt_au3mode", RegRead("HKEY_CURRENT_USER\SOFTWARE\Classes\AutoIt3Script\Shell", ""))
		EndIf
		$au3mode = _Config_Read("scite4autoit_au3mode", "Run")
		If $au3mode = "" Then $au3mode = "Run" ;Falls kein vorheriger Wert gefunden werde..verwende RUN
		RegWrite("HKEY_CURRENT_USER\SOFTWARE\Classes\AutoIt3Script\Shell", "", "REG_SZ", $au3mode) ;Setze auf default zurück (def Run)
		If $registerinexplorer = "false" Then
			RegDelete("HKEY_CLASSES_ROOT\AutoIt3Script\Shell\Edit_ISN")
			RegDelete("HKEY_CURRENT_USER\SOFTWARE\Classes\AutoIt3Script\Shell\Edit_ISN")
		EndIf
	EndIf

	If $registerisnfiles = "true" Then
		_RegisterFileType("isn", _Get_langstr(193))
	Else
		_UnRegisterFileType("isn")
	EndIf

	If $registerispfiles = "true" Then
		_RegisterFileType("isp", _Get_langstr(479), "", @ScriptDir & "\Data\isp_icon.ico")
	Else
		_UnRegisterFileType("isp")
	EndIf

	If $registericpfiles = "true" Then
		_RegisterFileType("icp", _Get_langstr(1319), "", @ScriptDir & "\Data\isp_icon.ico")
	Else
		_UnRegisterFileType("icp")
	EndIf

	Return 1
EndFunc   ;==>_ISN_Register_Filetypes


Func _ISN_FindAutoItIncludeFolder()
	Local $path = ""
	Local $RegKey = 'HKEY_LOCAL_MACHINE64\SOFTWARE\'
	If @OSArch <> 'X86' Then $RegKey &= 'Wow6432Node\'
	Local $InstallPath = RegRead($RegKey & 'AutoIt v3\AutoIt', 'InstallDir')

	If FileExists($InstallPath) And FileExists($InstallPath & "\Include") Then $path = $InstallPath & "\Include"

	If $path = "" Or FileExists(@ScriptDir & "\portable.dat") Then
		If FileExists($autoitexe) Then
			$path = StringTrimRight($autoitexe, StringLen($autoitexe) - StringInStr($autoitexe, "\", 0, -1) + 1) & "\Include"
		EndIf
	EndIf

	Return $path
EndFunc   ;==>_ISN_FindAutoItIncludeFolder

Func _ISN_CopyFileToClipboard($FilePath = "")
	Local $ClipResult = 0
	If $FilePath = "" Then Return -1
	Return _ClipCopyCutFile($FilePath, 5, "|")
EndFunc   ;==>_ISN_CopyFileToClipboard

Func _ISN_CutFileToClipboard($FilePath = "")
	Local $ClipResult = 0
	If $FilePath = "" Then Return -1
	Return _ClipCopyCutFile($FilePath, 2, "|")
EndFunc   ;==>_ISN_CutFileToClipboard

Func _ISN_TVExplorer_Cut2Clipboard()
	If $Offenes_Projekt = "" Then Return -1
	If Not IsHWnd($Current_TVExplorer_TreeView) Then Return -1
	Local $FilePath = _GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView)
	If _WinAPI_PathIsRoot($FilePath) Then Return -1
	Local $SelectedItem = _GUICtrlTreeView_GetSelection($Current_TVExplorer_TreeView)
	If $SelectedItem = 0 Then Return -1
	_GUICtrlTreeView_SetState($Current_TVExplorer_TreeView, $SelectedItem, _GUICtrlTreeView_GetState($Current_TVExplorer_TreeView, $SelectedItem) + $TVIS_CUT)
	If Not FileExists($FilePath) Then Return 0
	_ISN_CutFileToClipboard($FilePath)
	Return 1
EndFunc   ;==>_ISN_TVExplorer_Cut2Clipboard

Func _ISN_TVExplorer_PasteFromClipboard()
	Local $SelectedPath_Drive, $SelectedPath_Dir, $SelectedPath_FileName, $SelectedPath_Extension, $CurrentFileFrom, $CurrentFileTo
	Local $CurrentFile_Drive, $CurrentFile_Dir, $CurrentFile_FileName, $CurrentFile_Extension

	If $Offenes_Projekt = "" Then Return -1
	If Not _ISN_TVExplorer_IsAFileInClipboard() Then Return -1 ;No file
	If Not IsHWnd($Current_TVExplorer_TreeView) Then Return -1
	Local $SelectedPath = _GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView)
	If Not FileExists($SelectedPath) Then Return 0
	Local $SelectedPath_Split = _PathSplit($SelectedPath, $SelectedPath_Drive, $SelectedPath_Dir, $SelectedPath_FileName, $SelectedPath_Extension)
	If Not _IsDir($SelectedPath) Then
		$SelectedPath = $SelectedPath_Drive & $SelectedPath_Dir
		If StringRight($SelectedPath, 1) = "\" Then $SelectedPath = StringTrimRight($SelectedPath, 1)
	EndIf
	If Not IsArray($ISN_FileClipboardArray) Then Return -1
	If UBound($ISN_FileClipboardArray) < 1 Then Return False
	$DROPEFFECT = $ISN_FileClipboardArray[0] ;Get Drop Effect
	For $ArrayCnt = 1 To UBound($ISN_FileClipboardArray) - 1

		;Prepare
		$CurrentFileFrom = $ISN_FileClipboardArray[$ArrayCnt]
		$CurrentFileSplit = _PathSplit($CurrentFileFrom, $CurrentFile_Drive, $CurrentFile_Dir, $CurrentFile_FileName, $CurrentFile_Extension)
		$CurrentFileTo = $SelectedPath & "\" & $CurrentFile_FileName & $CurrentFile_Extension


		;Perform a move operation
		If BitAND($DROPEFFECT, $DROPEFFECT_MOVE) = $DROPEFFECT_MOVE Then
			_FileOperationProgress($ISN_FileClipboardArray[$ArrayCnt], $SelectedPath, 1, $FO_MOVE, 0x0000)
		EndIf


		;Perform a copy operation
		If BitAND($DROPEFFECT, $DROPEFFECT_COPY) = $DROPEFFECT_COPY Then
			_FileOperationProgress($ISN_FileClipboardArray[$ArrayCnt], $SelectedPath, 1, $FO_COPY, 0x0000)
		EndIf

	Next

	;Select last processed file in the treeview
	If FileExists($CurrentFileTo) Then $Porjecttree_FileToSelect_after_Update = $CurrentFileTo

	;If operation was move, clear clipboard
	If BitAND($DROPEFFECT, $DROPEFFECT_MOVE) = $DROPEFFECT_MOVE Then ClipPut("")

	;Trigger Treeview Update in EditorMode
	If $Studiomodus = "2" Then AdlibRegister("_Update_Treeview")

EndFunc   ;==>_ISN_TVExplorer_PasteFromClipboard

Func _ISN_TVExplorer_GlobalEnterFunc()
	If $Offenes_Projekt = "" Then Return -1
	If Not IsHWnd($Current_TVExplorer_TreeView) Then Return -1

	Switch $Current_TVExplorer_TreeView

		Case $hWndTreeview
			If $Projektbaum_ist_bereit <> 1 Then Return
			If _GUICtrlTreeView_GetSelection($Current_TVExplorer_TreeView) = 0 Then Return
			If StringInStr(_GUICtrlTreeView_GetTree($Current_TVExplorer_TreeView, _GUICtrlTreeView_GetSelection($Current_TVExplorer_TreeView)), ".", 1, -1) = 0 Then Return
			Try_to_opten_file(_GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView))

		Case $ISN_UDF_Manager_GUI_hTreeview
			If _GUICtrlTreeView_GetSelection($ISN_UDF_Manager_GUI_Treeview) = 0 Then Return
			_ISN_UDF_Manager_Inspect_UDF(_GUICtrlTVExplorer_GetSelected($ISN_UDF_Manager_GUI_Treeview))

		Case $quick_view_udfexplorer_htreeview
			If $Projektbaum_ist_bereit <> 1 Then Return
			If _GUICtrlTreeView_GetSelection($Current_TVExplorer_TreeView) = 0 Then Return
			If StringInStr(_GUICtrlTreeView_GetTree($Current_TVExplorer_TreeView, _GUICtrlTreeView_GetSelection($Current_TVExplorer_TreeView)), ".", 1, -1) = 0 Then Return
			Try_to_opten_file(_GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView))

	EndSwitch

	Return 1
EndFunc   ;==>_ISN_TVExplorer_GlobalEnterFunc

Func _ISN_TVExplorer_Copy2Clipboard()
	If $Offenes_Projekt = "" Then Return -1
	If Not IsHWnd($Current_TVExplorer_TreeView) Then Return -1
	Local $FilePath = _GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView)

	;If it´s a favorite, then resolve lnk
	Local $FavoritesPath = _ISN_Variablen_aufloesen($FavoritesSubfolder)
	If StringRight($FilePath, 4) = ".lnk" And StringInStr($FilePath, $FavoritesPath) Then
		$FilePath = _ISN_Variablen_aufloesen(_ISN_Favorites_ShortGetCommentPath($FilePath))
	EndIf

	If Not FileExists($FilePath) Then Return 0
	_ISN_CopyFileToClipboard($FilePath)
	Return 1
EndFunc   ;==>_ISN_TVExplorer_Copy2Clipboard

Func _ISN_TVExplorer_IsAFileInClipboard()
	If Not IsArray($ISN_FileClipboardArray) Then Return False
	If $ISN_FileClipboardArray = $Leeres_Array Or $Offenes_Projekt = "" Then Return False
	If UBound($ISN_FileClipboardArray) < 1 Then Return False
	Return True
EndFunc   ;==>_ISN_TVExplorer_IsAFileInClipboard


Func _ISN_TVExplorer_DisplayOpenFileDialog()
	If $Offenes_Projekt = "" Then Return -1
	If Not IsHWnd($Current_TVExplorer_TreeView) Then Return -1
	Local $FilePath = _GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView)
	If Not FileExists($FilePath) Then Return 0
	ShellExecute(@SystemDir & '\RUNDLL32.EXE', 'shell32.dll,OpenAs_RunDLL ' & $FilePath)
	Return 1
EndFunc   ;==>_ISN_TVExplorer_DisplayOpenFileDialog


; #FUNCTION# ====================================================================================================================
; Name...........: _ClipCopyCutFile
; Description ...: Copy or Cut Files to Clipboard (almost) Like Explorer does
; Syntax.........: _ClipCopyCutFile($sFile[,$DROPEFFECT=5[, $sSeparator = "|"]])
; Parameters ....: $sFile      - Full Path to File(s)
;      $DROPEFFECT - 5=Copy(default), 2=Cut
;                 $sSeparator  - Seperator for multiple Files, Default = '|'
; Return values .: Success    - True
;                 Failure     - False and Sets @ERROR to:
;                 |1 - Unable to Open Clipboard
;                 |2 - Unable to Empty Cipboard
;                 |3 - GlobalAlloc Failed
;                 |4 - GlobalLock Failed
;                 |5 - Unable to Create DLLStruct
;                 |6 - Unable to Update Clipboard
;                 |7 - Unable to Close Clipboard
;                 |8 - GlobalUnlock Failed
;                 |9 - GlobalFree handle Failed
;                 |10- Invalid $DROPEFFECT
; Author ........: Piccaso (Florian Fida)
; Modified.......: Gary Frost (gafrost)
; Modified.......: JCCW (BOP)
; Remarks .......: This routine only puts "HDrop" and "Prefered DropEffect" clipboard formats
;    on the clipboard.
;    Windows Explorer also puts:
;     -DataObject
;     -Shell IDList Array
;     -FileName
;     -FileNameW
;     -Ole Private Data
;    It seems to work though.
; Related .......:
; Link ..........:
; Example .......: no
; ===============================================================================================================================
Func _ClipCopyCutFile($sFile, $DROPEFFECT = 5, $sSeparator = "|")
	Local Const $GMEM_MOVEABLE = 0x0002, $CF_HDROP = 15
	$sFile &= $sSeparator & $sSeparator
	Local $nGlobMemSize = 2 * (StringLen($sFile) + 20)
	Local $PreferredDropEffect = _ClipBoard_RegisterFormat("Preferred DropEffect")
	; $DROPEFFECT 2= cut, 5= copy
	If $DROPEFFECT <> 2 And $DROPEFFECT <> 5 Then Return SetError(10, 10, False)
	Local $aResult = DllCall("user32.dll", "bool", "OpenClipboard", "hwnd", 0)
	If @error Or $aResult[0] = 0 Then Return SetError(1, _WinAPI_GetLastError(), False)
	Local $iError = 0, $iLastError = 0
	$aResult = DllCall("user32.dll", "bool", "EmptyClipboard")
	If @error Or Not $aResult[0] Then Return _CCCFError(2, _WinAPI_GetLastError())
	$aResult = DllCall("kernel32.dll", "handle", "GlobalAlloc", "uint", $GMEM_MOVEABLE, "ulong_ptr", $nGlobMemSize)
	If @error Or Not $aResult[0] Then Return _CCCFError(3, _WinAPI_GetLastError())
	Local $hGlobal = $aResult[0]
	Local $aResult1 = DllCall("kernel32.dll", "handle", "GlobalAlloc", "uint", $GMEM_MOVEABLE, "ulong_ptr", 52)
	;Note: 52 is an arbitrary number. I know it is at least 4 bytes and 52 should be big enough.
	;A pox on MS documentation standards.
	If @error Or Not $aResult1[0] Then Return _CCCFError(3, _WinAPI_GetLastError())
	Local $hGlobal1 = $aResult1[0]
	$aResult = DllCall("kernel32.dll", "ptr", "GlobalLock", "handle", $hGlobal)
	If @error Or Not $aResult[0] Then Return _CCCFError(4, _WinAPI_GetLastError())
	Local $hLock = $aResult[0]
	$aResult1 = DllCall("kernel32.dll", "ptr", "GlobalLock", "handle", $hGlobal1)
	If @error Or Not $aResult1[0] Then Return _CCCFError(4, _WinAPI_GetLastError())
	Local $hLock1 = $aResult1[0]
	Local $DROPFILES = DllStructCreate("dword pFiles;" & $tagPOINT & ";bool fNC;bool fWide;wchar[" & StringLen($sFile) + 1 & "]", $hLock)
	If @error Then Return SetError(5, 6, False)
	Local $DROPFILES1 = DllStructCreate("dword CFSTR_PREFERREDDROPEFFECT", $hLock1)
	If @error Then Return SetError(5, 6, False)
	Local $tempStruct = DllStructCreate("dword;long;long;bool;bool")
	DllStructSetData($DROPFILES, "pFiles", DllStructGetSize($tempStruct))
	DllStructSetData($DROPFILES, "X", 0)
	DllStructSetData($DROPFILES, "Y", 0)
	DllStructSetData($DROPFILES, "fNC", 0)
	DllStructSetData($DROPFILES, "fWide", 1)
	DllStructSetData($DROPFILES, 6, $sFile)
	For $i = 1 To StringLen($sFile)
		If DllStructGetData($DROPFILES, 6, $i) = $sSeparator Then DllStructSetData($DROPFILES, 6, Chr(0), $i)
	Next
	$aResult = DllCall("user32.dll", "handle", "SetClipboardData", "uint", $CF_HDROP, "handle", $hGlobal)
	If @error Or Not $aResult[0] Then
		$iError = 6
		$iLastError = _WinAPI_GetLastError()
	EndIf
	DllStructSetData($DROPFILES1, "CFSTR_PREFERREDDROPEFFECT", $DROPEFFECT)
	$aResult1 = DllCall("user32.dll", "handle", "SetClipboardData", "uint", $PreferredDropEffect, "handle", $hGlobal1)
	If @error Or Not $aResult1[0] Then
		$iError = 6
		$iLastError = _WinAPI_GetLastError()
	EndIf
	$aResult = DllCall("kernel32.dll", "bool", "GlobalUnlock", "handle", $hGlobal)
	If (@error Or Not $aResult[0]) And Not $iError And _WinAPI_GetLastError() Then
		$iError = 8
		$iLastError = _WinAPI_GetLastError()
	EndIf
	$aResult1 = DllCall("kernel32.dll", "bool", "GlobalUnlock", "handle", $hGlobal1)
	If (@error Or Not $aResult1[0]) And Not $iError And _WinAPI_GetLastError() Then
		$iError = 8
		$iLastError = _WinAPI_GetLastError()
	EndIf
	$aResult = DllCall("kernel32.dll", "ptr", "GlobalFree", "handle", $hGlobal)
	If (@error Or $aResult[0]) And Not $iError Then
		$iError = 9
		$iLastError = _WinAPI_GetLastError()
	EndIf
	$aResult1 = DllCall("kernel32.dll", "ptr", "GlobalFree", "handle", $hGlobal1)
	If (@error Or $aResult1[0]) And Not $iError Then
		$iError = 9
		$iLastError = _WinAPI_GetLastError()
	EndIf
	Return _CCCFError($iError, $iLastError)
EndFunc   ;==>_ClipCopyCutFile
Func _CCCFError($error = 0, $extended = 0)
	Local $aResult = DllCall("user32.dll", "bool", "CloseClipboard")
	If (@error Or Not $aResult[0]) And Not $error Then Return SetError(7, _WinAPI_GetLastError(), False)
	If $error Then Return SetError($error, $extended, False)
	Return True
EndFunc   ;==>_CCCFError

Func _ClipBoardContents()
	; Determines whether files were cut or copyed to the clipboard.
	; Returns 0 if clipboard is empty or does not contain
	; clipboard format "HDrop".
	; Returns 2 if clipboard contains cut file(s)
	;(ClipBoard Format:"Preferred DropEffect" = 2 and ClipBoard Format:"HDrop").
	; Returns 5 if clipboard contains copied file(s) (ClipBoard Format:"HDrop").
	; Sets @error if clipboard does not contain at least one file (one ClipBoard Format:"HDrop").
	; Auther: BOP (JCCW)
	Local $CBF = 0, $CBFS, $data, $CountDropEffect2 = 0, $CountHDrop = 0
	Do
		Local $CBO = _ClipBoard_Open(0)
		$CBF = _ClipBoard_EnumFormats($CBF)
		If $CBF = 0 Then ExitLoop
		$CBFS = _ClipBoard_FormatStr($CBF)
		If $CBFS = "Preferred DropEffect" Then
			$data = BinaryMid(_ClipBoard_GetData($CBF), 1, 4)
			If $data = 2 Then $CountDropEffect2 += 1
		EndIf
		If $CBFS = "HDrop" Then $CountHDrop += 1
	Until Not $CBF
	_ClipBoard_Close()
	If $CountHDrop <> 1 Then Return SetError(1, 1, 0)
	If $CountDropEffect2 = 1 Then Return SetError(0, 0, 2)
	Return SetError(0, 0, 5)
EndFunc   ;==>_ClipBoardContents

Func _ISN_ClipBoardEvent()
	;Orginal func by rover
	Local $PID, $hClipOwner, $hOpenWindow, $iFormat = 0, $iCount, $hDrop, $tData, $nSize, $pFileName, $nAmt
	Local $hDropEffect, $tDropEffect, $iDropEffect, $oShell, $oShellWindows, $sString

	;Reset the ISN_ClipboardArray
	$ISN_FileClipboardArray = $Leeres_Array

	$hClipOwner = _ClipBoard_GetOwner()
	$hOpenWindow = _ClipBoard_GetOpenWindow()
	$iSequence = _ClipBoard_GetSequenceNumber()
	_WinAPI_GetWindowThreadProcessId($hClipOwner, $PID)

	; Open the clipboard
	If Not _ClipBoard_Open($hGUI) Then Return ;_WinAPI_ShowError("_ClipBoard_Open failed", False)

	Do
		$iFormat = _ClipBoard_EnumFormats($iFormat)
		If $iFormat <> 0 Then
			$iCount += 1
			$sTemp = _ClipBoard_FormatStr($iFormat)
			If $sTemp == "Preferred DropEffect" Then $CF_PREFERREDDROPEFFECT = $iFormat
			;not constant like CF_HDROP, value must be retrieved for each event
			;$sTemp = StringFormat("%-.25s%s%-40s%s", "Format " & $iCount & " ................", ": ", $sTemp, $iFormat)
		EndIf
	Until $iFormat = 0

	; if clipboard contains cut or copied files
	If _ClipBoard_IsFormatAvailable($CF_HDROP) Then
		$hDrop = _ClipBoard_GetDataEx($CF_HDROP) ; get handle to clipboard files
		$hDropEffect = _ClipBoard_GetDataEx($CF_PREFERREDDROPEFFECT) ; get handle to DropEffect enumeration
		If $hDrop = 0 And _ClipBoard_Close() Then Return ;_WinAPI_ShowError("_ClipBoard_GetDataEx failed: $hDrop", False)
		If $hDropEffect = 0 And _ClipBoard_Close() Then Return ;_WinAPI_ShowError("_ClipBoard_GetDataEx failed: $hDropEffect", False)
		$tDropEffect = DllStructCreate("dword", $hDropEffect)
		$iDropEffect = DllStructGetData($tDropEffect, 1)

		;Add the hDropEffect to the ISN Clipboard Array (first entry)
		_ArrayAdd($ISN_FileClipboardArray, $iDropEffect)

		$nAmt = DllCall("shell32.dll", "int", "DragQueryFile", "hwnd", $hDrop, "int", 0xFFFFFFFF, "ptr", 0, "int", 255) ; file count
		For $i = 0 To $nAmt[0] - 1
			$nSize = DllCall("shell32.dll", "int", "DragQueryFile", "hwnd", $hDrop, "int", $i, "ptr", 0, "int", 0) ; file name size
			$nSize = $nSize[0] + 1
			$pFileName = DllStructCreate("char[" & $nSize & "]")
			DllCall("shell32.dll", "int", "DragQueryFile", "hwnd", $hDrop, "int", $i, "ptr", DllStructGetPtr($pFileName), "int", $nSize)
			_ArrayAdd($ISN_FileClipboardArray, DllStructGetData($pFileName, 1)) ;Add files to the ISN Clipboard Array
			$pFileName = 0
		Next

	EndIf

	; Close the clipboard
	_ClipBoard_Close()

EndFunc   ;==>_ISN_ClipBoardEvent






Func _ISN_QuickSearchBar_FindNextButton()
	Send("{ENTER up}") ;Releases the ENTER key
	If $Scripteditor_EnableQuickSearchBar <> "true" Then Return
	If $Offenes_Projekt = "" Then Return
	Local $searchtext = GUICtrlRead($ISN_QuickSearchbar_Input)
	GUICtrlSetData($Search_Combo1, $searchtext, $searchtext) ;Copy text in the "real" search GUI
	_Hotkey_vorwaerts_suchen()
EndFunc   ;==>_ISN_QuickSearchBar_FindNextButton

Func _ISN_QuickSearchBar_FindPrevButton()
	If $Scripteditor_EnableQuickSearchBar <> "true" Then Return
	If $Offenes_Projekt = "" Then Return
	Local $searchtext = GUICtrlRead($ISN_QuickSearchbar_Input)
	GUICtrlSetData($Search_Combo1, $searchtext, $searchtext) ;Copy text in the "real" search GUI
	_Hotkey_Rueckwaerts_suchen()
EndFunc   ;==>_ISN_QuickSearchBar_FindPrevButton

Func _ISN_QuickSearchBar_ClearInputButton()
	If $Offenes_Projekt = "" Then Return
	GUICtrlSetData($ISN_QuickSearchbar_Input, "")
	_WinAPI_SetFocus(GUICtrlGetHandle($ISN_QuickSearchbar_Input))
EndFunc   ;==>_ISN_QuickSearchBar_ClearInputButton

Func _ISN_ProjecttreeSearchbar_ClearInputButton()
	If $Offenes_Projekt = "" Then Return
	GUICtrlSetData($Projecttree_Searchbar, "")
	_WinAPI_SetFocus(GUICtrlGetHandle($Projecttree_Searchbar))
EndFunc   ;==>_ISN_ProjecttreeSearchbar_ClearInputButton

Func _ISN_ProjecttreeSearchbar_AcInputSelectItem()
	_AcInputUDF_AutocompleteSelectedItem()
	_GUICtrlTVExplorer_Expand($hWndTreeview, _ISN_Variablen_aufloesen(GUICtrlRead($Projecttree_Searchbar)), 0)
	_WinAPI_SetFocus($hWndTreeview)
	$Current_TVExplorer_TreeView = $hWndTreeview
EndFunc   ;==>_ISN_ProjecttreeSearchbar_AcInputSelectItem

Func _ISN_Projecttree_BackgroundScanForAcInput()
	AdlibUnRegister("_ISN_Projecttree_BackgroundScanForAcInput")

	_AcInputUDF_ControlSetAcList($Projecttree_Searchbar, $Leeres_Array)
	If $Studiomodus <> 1 Then Return

	;Scan ISN UDFs Folder
	Local $ProjectFilesArray = _FileListToArrayRec($Offenes_Projekt, "*||.Favorites", $FLTAR_FILES, $FLTAR_RECUR, $FLTAR_NOSORT, $FLTAR_FULLPATH)
	If Not IsArray($ProjectFilesArray) Or @error Then Return 0
	_ArrayDelete($ProjectFilesArray, 0)

	;Replace paths with ISN Variables
	For $cnt = 0 To UBound($ProjectFilesArray) - 1
		$ProjectFilesArray[$cnt] = _ISN_Pfad_durch_Variablen_ersetzen($ProjectFilesArray[$cnt])
	Next

	;Set array for ACInout
	_AcInputUDF_ControlSetAcList($Projecttree_Searchbar, $ProjectFilesArray)
EndFunc   ;==>_ISN_Projecttree_BackgroundScanForAcInput

Func _GetHwndUnderMouse()
	Local $g_tStruct = DllStructCreate($tagPOINT)
	DllStructSetData($g_tStruct, "x", MouseGetPos(0))
	DllStructSetData($g_tStruct, "y", MouseGetPos(1))
	Return _WinAPI_WindowFromPoint($g_tStruct)
EndFunc   ;==>_GetHwndUnderMouse


Func _ISN_GUIImageList_AddBitmapWithBackground($hWnd, $sFile = "", $Background = 0xFFFFFF, $Alpha = 255)
	Local $aProcessIcons = _GDIPlus_BitmapCreateFromFile($sFile)
	If @error Then Return SetError(2, @extended, 0)

	If $DPI > 1.99 Then
		Local $iWidth = (_GDIPlus_ImageGetWidth($aProcessIcons) + 1) * $DPI
		Local $iHeight = (_GDIPlus_ImageGetHeight($aProcessIcons) + 4) * $DPI
	Else
		Local $iWidth = (_GDIPlus_ImageGetWidth($aProcessIcons) + 1) * $DPI
		Local $iHeight = (_GDIPlus_ImageGetHeight($aProcessIcons) + 1) * $DPI
	EndIf

	Local $iStride = 0, $iPixelFormat = 0x0026200A, $pScan0 = 0
	Local $aResult = _GDIPlus_BitmapCreateFromScan0($iWidth, $iHeight, $iPixelFormat, $iStride, $pScan0)
	If @error Then Return SetError(3, @extended, 0)
	Local $hGraphics = _GDIPlus_ImageGetGraphicsContext($aResult)
	Local $hBrush = _GDIPlus_BrushCreateSolid("0x" & Hex($Alpha, 2) & StringReplace(Hex($Background, 6), "0x", "")) ;color format AARRGGBB (hex)
	_GDIPlus_GraphicsFillRect($hGraphics, 0, 0, $iWidth, $iHeight, $hBrush)
	_GDIPlus_GraphicsDrawImageRect($hGraphics, $aProcessIcons, 0, 0, $iWidth, $iHeight)
	Local $hBmp = _GDIPlus_BitmapCreateHBITMAPFromBitmap($aResult)
	_GUIImageList_Add($hWnd, $hBmp)
	_GDIPlus_GraphicsDispose($hGraphics)
	_GDIPlus_BitmapDispose($aResult)
	_WinAPI_DeleteObject($hBmp)
	_GDIPlus_BitmapDispose($aProcessIcons)
	Return 1
EndFunc   ;==>_ISN_GUIImageList_AddBitmapWithBackground

Func _ISN_DrawPNGButton($handle = "")
	_GUICtrlButton_SetImageList($handle, $WelcomeGUI_ButtonsImagelist, 4)
EndFunc   ;==>_ISN_DrawPNGButton



Func _ISN_ShowQuickChangeAutoItArchitectureGUI()

	If $ISN_AutoitArchitecture = "x86" Then
		GUICtrlSetState($QuickChangeAutoItArchitectureX64Radio, $GUI_UNCHECKED)
		GUICtrlSetState($QuickChangeAutoItArchitectureX86Radio, $GUI_CHECKED)
	Else
		GUICtrlSetState($QuickChangeAutoItArchitectureX86Radio, $GUI_UNCHECKED)
		GUICtrlSetState($QuickChangeAutoItArchitectureX64Radio, $GUI_CHECKED)
	EndIf

	GUISetState(@SW_SHOW, $QuickChangeAutoItArchitectureGUI)
	GUISetState(@SW_DISABLE, $Studiofenster)
EndFunc   ;==>_ISN_ShowQuickChangeAutoItArchitectureGUI

Func _ISN_HideQuickChangeAutoItArchitectureOK()

	If GUICtrlRead($QuickChangeAutoItArchitectureX86Radio) = $GUI_CHECKED Then
		$ISN_AutoitArchitecture = "x86"
		_Write_in_Config("isn_autoitarchitecture", "x86")
	Else
		$ISN_AutoitArchitecture = "x64"
		_Write_in_Config("isn_autoitarchitecture", "x64")
	EndIf

	_ISN_HideQuickChangeAutoItArchitectureGUI()
EndFunc   ;==>_ISN_HideQuickChangeAutoItArchitectureOK

Func _ISN_HideQuickChangeAutoItArchitectureGUI()
	GUISetState(@SW_ENABLE, $Studiofenster)
	GUISetState(@SW_HIDE, $QuickChangeAutoItArchitectureGUI)
EndFunc   ;==>_ISN_HideQuickChangeAutoItArchitectureGUI






Func _ISN_DualEditor_SetTabForDualEditorMode($TabNr = -1)
	If $TabNr = -1 Then Return
	If _GUICtrlTab_GetItemCount($htab) < 1 Then Return MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1484), 0, $Studiofenster) ;Require at least 2 tabs to run
	If $Plugin_Handle[$TabNr] <> -1 Then Return ;Not allowed on Plugins

	Local $NewDualTab_Nr = $TabNr
	Local $NewDualTab_Handle = $SCE_EDITOR[_GUICtrlTab_GetCurFocus($htab)]
	Local $NewDualTab_MainNr = -1
	Local $NewDualTab_MainHandle = ""

	;Search for scintilla tabs before the current tab
	For $x = $TabNr To 0 Step -1
		If $x = $TabNr Then ContinueLoop
		If $Plugin_Handle[$x] <> -1 Then ContinueLoop ;Ignore Plugins

		$NewDualTab_MainNr = $x
		$NewDualTab_MainHandle = $SCE_EDITOR[$x]
	Next

	;Search for scintilla tabs after the current tab (if still nothing is found)
	If $NewDualTab_MainHandle = "" Then
		For $x = $TabNr To UBound($SCE_EDITOR) - 1
			If $x = $TabNr Then ContinueLoop
			If $Plugin_Handle[$x] <> -1 Then ContinueLoop ;Ignore Plugins

			$NewDualTab_MainNr = $x
			$NewDualTab_MainHandle = $SCE_EDITOR[$x]
		Next
		If $NewDualTab_MainHandle = "" Then Return MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1484), 0, $Studiofenster) ;Still not tab found, stop here
	EndIf

	;If there is already a dual mode tab, hide it
	If $Scripteditor_DualEditor_Handle <> "" Then WinMove($Scripteditor_DualEditor_Handle, "", -9900, -9900, Default, Default)

	;Setup DualMode
	$Scripteditor_EnableDualEditor = "true" ;Enable dual Mode
	$Scripteditor_DualEditor_Handle = $NewDualTab_Handle
	$Scripteditor_DualEditor_TabNrToUse = $NewDualTab_Nr
	$Scripteditor_DualEditor_MainTabHandle = $NewDualTab_MainHandle
	$Scripteditor_DualEditor_MainTabNr = $NewDualTab_MainNr
	GUICtrlSetState($Splitter_DualEditor, $GUI_SHOW)
	GUICtrlSetData($Scripteditor_DualEditorView_PrimaryTitle, StringTrimLeft($Datei_pfad[$NewDualTab_MainNr], StringInStr($Datei_pfad[$NewDualTab_MainNr], "\", 0, -1)))
	GUICtrlSetData($Scripteditor_DualEditorView_SecondaryTitle, StringTrimLeft($Datei_pfad[$NewDualTab_Nr], StringInStr($Datei_pfad[$NewDualTab_Nr], "\", 0, -1)))
	If $Scripteditor_DualEditor_ShowEditorTitle = "true" Then
		GUICtrlSetState($Scripteditor_DualEditorView_PrimaryTitle, $GUI_SHOW)
		GUICtrlSetState($Scripteditor_DualEditorView_SecondaryTitle, $GUI_SHOW)
	EndIf

	_Aktualisiere_Splittercontrols()
	_Check_Buttons(0)
EndFunc   ;==>_ISN_DualEditor_SetTabForDualEditorMode

Func _ISN_DualEditor_FindNewMainTab($StartFrom = -1)
	If $StartFrom < 0 Then Return _ISN_DualEditor_CloseDualTab()
	If _GUICtrlTab_GetItemCount($htab) < 1 Then Return _ISN_DualEditor_CloseDualTab()


	Local $NewDualTab_MainNr = -1
	Local $NewDualTab_MainHandle = ""

	;Search for scintilla tabs before the current tab
	For $x = $StartFrom To 0 Step -1
		If $x = $Scripteditor_DualEditor_TabNrToUse Then ContinueLoop
		If $Plugin_Handle[$x] <> -1 Then ContinueLoop ;Ignore Plugins

		$NewDualTab_MainNr = $x
		$NewDualTab_MainHandle = $SCE_EDITOR[$x]
	Next

	;Search for scintilla tabs after the current tab (if still nothing is found)
	If $NewDualTab_MainHandle = "" Then
		For $x = $StartFrom To UBound($SCE_EDITOR) - 1
			If $x = $Scripteditor_DualEditor_TabNrToUse Then ContinueLoop
			If $Plugin_Handle[$x] <> -1 Then ContinueLoop ;Ignore Plugins

			$NewDualTab_MainNr = $x
			$NewDualTab_MainHandle = $SCE_EDITOR[$x]
		Next
		If $NewDualTab_MainHandle = "" Then Return _ISN_DualEditor_CloseDualTab()
	EndIf

	GUICtrlSetData($Scripteditor_DualEditorView_PrimaryTitle, StringTrimLeft($Datei_pfad[$NewDualTab_MainNr], StringInStr($Datei_pfad[$NewDualTab_MainNr], "\", 0, -1)))
	$Scripteditor_DualEditor_MainTabHandle = $NewDualTab_MainHandle
	$Scripteditor_DualEditor_MainTabNr = $NewDualTab_MainNr
	_GUICtrlTab_SetCurSel($htab, $Scripteditor_DualEditor_MainTabNr)
	_Aktualisiere_Splittercontrols()

EndFunc   ;==>_ISN_DualEditor_FindNewMainTab

Func _ISN_DualEditor_VerifyTab($ScintillaToCheck = "")
	If _GUICtrlTab_GetCurFocus($htab) = -1 Then Return
	If $Scripteditor_DualEditor_MainTabNr = -1 Or $Scripteditor_DualEditor_Handle = "" Or $Scripteditor_DualEditor_MainTabHandle = "" Or $ScintillaToCheck = "" Then Return


	Switch $ScintillaToCheck

		Case $Scripteditor_DualEditor_Handle
			If $SCE_EDITOR[_GUICtrlTab_GetCurFocus($htab)] = $Scripteditor_DualEditor_Handle Then Return ;already active
			$SCI_SearchRequester_SCIHandle = $Scripteditor_DualEditor_Handle
			_GUICtrlTab_SetCurSel($htab, $Scripteditor_DualEditor_TabNrToUse)
			_WinAPI_SetFocus($Scripteditor_DualEditor_Handle)
			_ISN_Call_Async_Function_in_Plugin($ISN_Helper_Threads[$ISN_Helper_Scripttree][$ISN_Helper_Handle], "_Scripttree_Switch_Tab", String($Scripteditor_DualEditor_TabNrToUse)) ;Load Scripttree
			_Check_tabs_for_changes()


		Case $Scripteditor_DualEditor_MainTabHandle
			If $SCE_EDITOR[_GUICtrlTab_GetCurFocus($htab)] = $Scripteditor_DualEditor_MainTabHandle Then Return ;already active
			$SCI_SearchRequester_SCIHandle = $Scripteditor_DualEditor_MainTabHandle
			_GUICtrlTab_SetCurSel($htab, $Scripteditor_DualEditor_MainTabNr)
			_WinAPI_SetFocus($Scripteditor_DualEditor_MainTabHandle)
			_ISN_Call_Async_Function_in_Plugin($ISN_Helper_Threads[$ISN_Helper_Scripttree][$ISN_Helper_Handle], "_Scripttree_Switch_Tab", String($Scripteditor_DualEditor_MainTabNr)) ;Load Scripttree
			_Check_tabs_for_changes()



	EndSwitch


EndFunc   ;==>_ISN_DualEditor_VerifyTab

Func _ISN_DualEditor_CloseDualTab()
	If $Scripteditor_EnableDualEditor = "false" Then Return ;already disabled
	$Scripteditor_EnableDualEditor = "false" ;Disable dual Mode
	WinMove($Scripteditor_DualEditor_Handle, "", -9900, -9900, Default, Default)
	$Scripteditor_DualEditor_Handle = ""
	$Scripteditor_DualEditor_TabNrToUse = -1
	$Scripteditor_DualEditor_MainTabHandle = ""
	$Scripteditor_DualEditor_MainTabNr = -1
	GUICtrlSetState($Splitter_DualEditor, $GUI_HIDE)
	GUICtrlSetState($Scripteditor_DualEditorView_PrimaryTitle, $GUI_HIDE)
	GUICtrlSetState($Scripteditor_DualEditorView_SecondaryTitle, $GUI_HIDE)
	_Aktualisiere_Splittercontrols()
	_Show_Tab(_GUICtrlTab_GetCurFocus($htab))
	_Check_Buttons(0)
EndFunc   ;==>_ISN_DualEditor_CloseDualTab


Func _ISN_DualEditor_ResizeWindows()
	If $Scripteditor_EnableDualEditor <> "true" Then Return

	Local $ISN_ScintillaEditor1_Dummy_Control_Pos = _ControlGetPos($Studiofenster, "", $ISN_ScintillaEditor1_Dummy_Control)
	Local $ISN_ScintillaEditor2_Dummy_Control_Pos = _ControlGetPos($Studiofenster, "", $ISN_ScintillaEditor2_Dummy_Control)
	If IsArray($ISN_ScintillaEditor1_Dummy_Control_Pos) And IsArray($ISN_ScintillaEditor2_Dummy_Control_Pos) Then

		_WinAPI_SetWindowPos($Scripteditor_DualEditor_MainTabHandle, $HWND_TOP, $ISN_ScintillaEditor1_Dummy_Control_Pos[0], $ISN_ScintillaEditor1_Dummy_Control_Pos[1], $ISN_ScintillaEditor1_Dummy_Control_Pos[2], $ISN_ScintillaEditor1_Dummy_Control_Pos[3], $SWP_SHOWWINDOW)
		_WinAPI_SetWindowPos($Scripteditor_DualEditor_Handle, $HWND_TOP, $ISN_ScintillaEditor2_Dummy_Control_Pos[0], $ISN_ScintillaEditor2_Dummy_Control_Pos[1], $ISN_ScintillaEditor2_Dummy_Control_Pos[2], $ISN_ScintillaEditor2_Dummy_Control_Pos[3], $SWP_SHOWWINDOW)

		If Not BitAND(GUICtrlGetState($Splitter_DualEditor), $GUI_SHOW) Then GUICtrlSetState($Splitter_DualEditor, $GUI_SHOW)
		If $Scripteditor_DualEditor_ShowEditorTitle = "true" Then
			If Not BitAND(GUICtrlGetState($Scripteditor_DualEditorView_PrimaryTitle), $GUI_SHOW) Then GUICtrlSetState($Scripteditor_DualEditorView_PrimaryTitle, $GUI_SHOW)
			If Not BitAND(GUICtrlGetState($Scripteditor_DualEditorView_SecondaryTitle), $GUI_SHOW) Then GUICtrlSetState($Scripteditor_DualEditorView_SecondaryTitle, $GUI_SHOW)
		Else
			If Not BitAND(GUICtrlGetState($Scripteditor_DualEditorView_PrimaryTitle), $GUI_HIDE) Then GUICtrlSetState($Scripteditor_DualEditorView_PrimaryTitle, $GUI_HIDE)
			If Not BitAND(GUICtrlGetState($Scripteditor_DualEditorView_SecondaryTitle), $GUI_HIDE) Then GUICtrlSetState($Scripteditor_DualEditorView_SecondaryTitle, $GUI_HIDE)
		EndIf
		_ISN_QuickSearchBar_Set_State("show")
	EndIf
EndFunc   ;==>_ISN_DualEditor_ResizeWindows

Func _ISN_DualEditor_VScrollBothEditors($SourceEditor = "")
	If $SourceEditor = "" Then Return False
	If $Scripteditor_EnableDualEditor <> "true" Then Return
	Local $SCI_From = $SourceEditor
	Local $SCI_To = ""

	If $ScrollBothEditors_FirstEditorHandle <> "" Then
		If $SourceEditor <> $ScrollBothEditors_FirstEditorHandle And $ScrollBothEditors_SecondEditorHandle = $SourceEditor Then
			$ScrollBothEditors_SecondEditorHandle = ""
			Return False
		EndIf
	EndIf


	If $ScrollBothEditors_SecondEditorHandle = $SourceEditor Then Return False
	If $SourceEditor = $Scripteditor_DualEditor_Handle Then $SCI_To = $Scripteditor_DualEditor_MainTabHandle
	If $SourceEditor = $Scripteditor_DualEditor_MainTabHandle Then $SCI_To = $Scripteditor_DualEditor_Handle
	$ScrollBothEditors_FirstEditorHandle = $SCI_From
	$ScrollBothEditors_SecondEditorHandle = $SCI_To


	Local $LineToScrollTo = SendMessage($SCI_From, $SCI_GETFIRSTVISIBLELINE, 0, 0)
	If $LineToScrollTo > -1 Then SendMessage($SCI_To, $SCI_SETFIRSTVISIBLELINE, $LineToScrollTo, 0)


	Return True
EndFunc   ;==>_ISN_DualEditor_VScrollBothEditors

Func _ISN_DualEditor_HScrollBothEditors($SourceEditor = "")
	If $SourceEditor = "" Then Return False
	If $Scripteditor_EnableDualEditor <> "true" Then Return
	Local $SCI_From = $SourceEditor
	Local $SCI_To = ""

	If $ScrollBothEditors_FirstEditorHandle <> "" Then
		If $SourceEditor <> $ScrollBothEditors_FirstEditorHandle And $ScrollBothEditors_SecondEditorHandle = $SourceEditor Then
			$ScrollBothEditors_SecondEditorHandle = ""
			Return False
		EndIf
	EndIf


	If $ScrollBothEditors_SecondEditorHandle = $SourceEditor Then Return False
	If $SourceEditor = $Scripteditor_DualEditor_Handle Then $SCI_To = $Scripteditor_DualEditor_MainTabHandle
	If $SourceEditor = $Scripteditor_DualEditor_MainTabHandle Then $SCI_To = $Scripteditor_DualEditor_Handle
	$ScrollBothEditors_FirstEditorHandle = $SCI_From
	$ScrollBothEditors_SecondEditorHandle = $SCI_To

	Local $GETXOFFSET = SendMessage($SCI_From, $SCI_GETXOFFSET, 0, 0)
	SendMessage($SCI_To, $SCI_SETXOFFSET, $GETXOFFSET, 0)

	Return True
EndFunc   ;==>_ISN_DualEditor_HScrollBothEditors

Func _ViewMenu_Toggle_SetDualEditorVertical()
	If $Scripteditor_DualEditorView = "vertical" Then Return ;already vertical
	$Scripteditor_DualEditorView = "vertical"
	_Write_in_Config("scripteditor_dual_editor_view", "vertical")
	GUICtrlSetPos($Splitter_DualEditor, 60, 30, $Splitter_Breite, $size[3] - 80)
	GUICtrlSetPos($Splitter_DualEditor, ($size1[0] / 100) * Number(_Config_Read("Dual_Splitter_Vertical", $Splitter_DualEditor_DefaultVertical)))
	GUICtrlSetCursor($Splitter_DualEditor, 13)
	_Studiofenster_Refresh_Menu_Checkboxes()
	_Aktualisiere_Splittercontrols()
EndFunc   ;==>_ViewMenu_Toggle_SetDualEditorVertical

Func _ViewMenu_Toggle_SetDualEditorHorizontal()
	If $Scripteditor_DualEditorView = "horizontal" Then Return ;already horizontal
	$Scripteditor_DualEditorView = "horizontal"
	_Write_in_Config("scripteditor_dual_editor_view", "horizontal")
	GUICtrlSetPos($Splitter_DualEditor, 268, 30, 400, $Splitter_Breite)
	GUICtrlSetPos($Splitter_DualEditor, 2, ($size1[1] / 100) * Number(_Config_Read("Dual_Splitter_Horizontal", $Splitter_DualEditor_DefaultHorizontal)))
	GUICtrlSetCursor($Splitter_DualEditor, 11)
	_Studiofenster_Refresh_Menu_Checkboxes()
	_Aktualisiere_Splittercontrols()
EndFunc   ;==>_ViewMenu_Toggle_SetDualEditorHorizontal

Func _ViewMenu_Toggle_SyncVerticalScrolling()
	If $Scripteditor_DualEditor_SyncVerticalScrolling = "true" Then
		_GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DualEditor_SyncVerticalScrolling, $MFS_CHECKED, False, False) ;UnCheck
		$Scripteditor_DualEditor_SyncVerticalScrolling = "false"
		_Write_in_Config("scripteditor_dual_editor_sync_vertical_scrolling", "false")
	Else
		_GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DualEditor_SyncVerticalScrolling, $MFS_CHECKED, True, False) ;Check
		$Scripteditor_DualEditor_SyncVerticalScrolling = "true"
		_Write_in_Config("scripteditor_dual_editor_sync_vertical_scrolling", "true")
	EndIf
EndFunc   ;==>_ViewMenu_Toggle_SyncVerticalScrolling

Func _ViewMenu_Toggle_SyncHorizontalScrolling()
	If $Scripteditor_DualEditor_SyncHorizontalScrolling = "true" Then
		_GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DualEditor_SyncHorizontalScrolling, $MFS_CHECKED, False, False) ;UnCheck
		$Scripteditor_DualEditor_SyncHorizontalScrolling = "false"
		_Write_in_Config("scripteditor_dual_editor_sync_horizontal_scrolling", "false")
	Else
		_GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DualEditor_SyncHorizontalScrolling, $MFS_CHECKED, True, False) ;Check
		$Scripteditor_DualEditor_SyncHorizontalScrolling = "true"
		_Write_in_Config("scripteditor_dual_editor_sync_horizontal_scrolling", "true")
	EndIf
EndFunc   ;==>_ViewMenu_Toggle_SyncHorizontalScrolling

Func _ViewMenu_Toggle_DualEditorTitle()
	If $Scripteditor_DualEditor_ShowEditorTitle = "true" Then
		_GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DualEditor_ShowEditorTitle, $MFS_CHECKED, False, False) ;UnCheck
		$Scripteditor_DualEditor_ShowEditorTitle = "false"
		_Write_in_Config("scripteditor_dual_editor_show_editor_title", "false")
	Else
		_GUICtrlMenu_SetItemState($StudioFenster_MenuHandle, $ISN_ViewMenu_DualEditor_ShowEditorTitle, $MFS_CHECKED, True, False) ;Check
		$Scripteditor_DualEditor_ShowEditorTitle = "true"
		_Write_in_Config("scripteditor_dual_editor_show_editor_title", "true")
	EndIf
	_ISN_DualEditor_ResizeWindows()
	_Aktualisiere_Splittercontrols()
EndFunc   ;==>_ViewMenu_Toggle_DualEditorTitle

Func _ISN_ArrayMoveRow(ByRef $array, $FromIndex = -1, $ToIndex = -1, $ForceDelemiter = "|")
	;Moves a row in an array to a differen position
	If $FromIndex = -1 Or $ToIndex = -1 Or $ForceDelemiter = "" Then Return
	If $FromIndex > UBound($array) - 1 Then Return
	Local $Datatype = $ARRAYFILL_FORCE_DEFAULT
	Local $FromBackup = ""
	Local $2DBackupArray = ""
	Local $2DColumns = 0
	Local $Is2D = False
	If UBound($array, 2) > 0 Then $Is2D = True

	If $Is2D Then
		$2DBackupArray = _ArrayExtract($array, $FromIndex, $FromIndex, -1, -1)
		$FromBackup = _ArrayToString($array, $ForceDelemiter, $FromIndex, $FromIndex, @CRLF, -1, -1)
		$2DColumns = UBound($array, 2)
	Else
		$FromBackup = $array[$FromIndex]
	EndIf

	_ArrayDelete($array, $FromIndex)
	_ArrayInsert($array, $ToIndex, $FromBackup, 0, $ForceDelemiter, @CRLF, $Datatype)

	;Restore 2D Datatypes from backup
	If $Is2D Then
		For $x = 0 To $2DColumns - 1
			$array[$ToIndex][$x] = $2DBackupArray[0][$x]
		Next
	EndIf
EndFunc   ;==>_ISN_ArrayMoveRow


Func _Check_ISN_Error_Behavior($ErrorText = "")
	Local $ISN_Error_Behavior_Backup = $ISN_Error_Behavior ;orginal value can be modified by the command lind tool, while processing

	Switch $ISN_Error_Behavior_Backup

		Case 1 ;stop processing, isn stays active
			If $ISN_Helper_Threads[$ISN_Helper_CommandLineTool][$ISN_Helper_Handle] <> "" And $ISN_Helper_Threads[$ISN_Helper_CommandLineTool][$ISN_Helper_PID] <> "" Then
				_ISN_Call_Async_Function_in_Plugin($ISN_Helper_Threads[$ISN_Helper_CommandLineTool][$ISN_Helper_Handle], "_Exit", Number(1), String($ErrorText))
			EndIf

		Case 2 ;stop processing, isn shut down
			If $ISN_Helper_Threads[$ISN_Helper_CommandLineTool][$ISN_Helper_Handle] <> "" And $ISN_Helper_Threads[$ISN_Helper_CommandLineTool][$ISN_Helper_PID] <> "" Then
				_ISN_Call_Async_Function_in_Plugin($ISN_Helper_Threads[$ISN_Helper_CommandLineTool][$ISN_Helper_Handle], "_Exit", Number(1), String($ErrorText))
			EndIf
			$AskExit = "false"
			AdlibRegister("_exit", 1000)

		Case 3 ;ignore all erros, but send error to isn command line tool
			If $ISN_Helper_Threads[$ISN_Helper_CommandLineTool][$ISN_Helper_Handle] <> "" And $ISN_Helper_Threads[$ISN_Helper_CommandLineTool][$ISN_Helper_PID] <> "" Then
				_RedirectOutputToCommandLineTool($ErrorText)
			EndIf


	EndSwitch

	Return $ISN_Error_Behavior_Backup
EndFunc   ;==>_Check_ISN_Error_Behavior


Func _ISN_Set_Error_Behavior($Value = "")
	If $Value = "" Then Return
	$ISN_Error_Behavior = Number($Value)
EndFunc   ;==>_ISN_Set_Error_Behavior

Func _OpenNewCMDInThisFolder()
	If $Offenes_Projekt = "" Then Return -1
	Local $Treeview = $Current_TVExplorer_TreeView
	If _GUICtrlTreeView_GetSelection($Treeview) = 0 Then Return
	Local $file = _GUICtrlTVExplorer_GetSelected($Treeview)
	Local $sDrive = "", $sDir = "", $sFileName = "", $sExtension = "", $path = ""
	Local $FileAttributes = FileGetAttrib($file)
	If StringInStr($FileAttributes, "D") Then
		$path = $file
	Else
		Local $aPathSplit = _PathSplit($file, $sDrive, $sDir, $sFileName, $sExtension)
		$path = $sDrive & $sDir
	EndIf

	Run("C:\Windows\System32\cmd.exe", $path)
EndFunc   ;==>_OpenNewCMDInThisFolder

Func _OpenNewPowerShellInThisFolder()
	If $Offenes_Projekt = "" Then Return -1
	Local $Treeview = $Current_TVExplorer_TreeView
	If _GUICtrlTreeView_GetSelection($Treeview) = 0 Then Return
	Local $file = _GUICtrlTVExplorer_GetSelected($Treeview)
	Local $sDrive = "", $sDir = "", $sFileName = "", $sExtension = "", $path = ""
	Local $FileAttributes = FileGetAttrib($file)
	If StringInStr($FileAttributes, "D") Then
		$path = $file
	Else
		Local $aPathSplit = _PathSplit($file, $sDrive, $sDir, $sFileName, $sExtension)
		$path = $sDrive & $sDir
	EndIf

	Run("powershell.exe", $path)
EndFunc   ;==>_OpenNewPowerShellInThisFolder


; #FUNCTION# ====================================================================================================================
; Name...........: _FileGetIcon
; Description ...: Get icon location for a file path/type.
; Syntax.........: _FileGetIcon($sFilePath)
; Parameters ....: $sFilePath - Path to file, folder, URL, etc.
; Return values .: Returns 2 element array: [0] = Icon file path, [1] = icon index/ordinal.
;                  Failure: Sets @error:
;                  |1 - Path is drive root but cannot determine drive type
;                  |2 - Path is shortcut file but unable to read it
;                  |3 - The extension is not registered
;                  |4 - The filetype is not registered or has no DefaultIcon set
;                  |5 - Icon file does not exist and cannot be found
;                  |6 - Icon is invalid and cannot be loaded
; Author ........: Rob Saunders (rob at therks dot com)
; Modified.......: Rewrite to use more reliable WinAPI functions
; ===============================================================================================================================

Func _FileGetIcon($sFilePath, $sDefaultIcon = '', $sDefaultIndex = '')
	Local $t_SHFILEINFO = DllStructCreate($tagSHFILEINFO) ; ptr hIcon;int iIcon;dword Attributes;wchar DisplayName[260];wchar TypeName[80]
	_WinAPI_ShellGetFileInfo($sFilePath, BitOR($SHGFI_ICONLOCATION, $SHGFI_TYPENAME), $FILE_ATTRIBUTE_NORMAL, $t_SHFILEINFO) ; #include <WinAPIShellEx.au3>

	Local $aReturnIcon = [DllStructGetData($t_SHFILEINFO, 'DisplayName'), DllStructGetData($t_SHFILEINFO, 'iIcon')] ; Initialize $aReturnIcon
	If Not $aReturnIcon[0] Then
		; If no icon from ShellGetFileInfo, try AssocQueryString
		Local $sExt, $sIconData
		Local $aCheckProtocol = StringRegExp($sFilePath, '^(.+?)://', 1) ; check for protocol style path (ie: http://, file://, ftp://, etc)
		If Not @error Then
			If $aCheckProtocol[0] = 'file' Then
				; If path is a file URL, convert to normal file path and pass to function
				Return _FileGetIcon(_WinAPI_PathCreateFromUrl($sFilePath)) ; #include <WinAPIShPath.au3>
			Else
				; Get registry data for the protocol
				$sIconData = _WinAPI_AssocQueryString($aCheckProtocol[0], $ASSOCSTR_DEFAULTICON) ; #include <WinAPIReg.au3>
				$aReturnIcon = _WinAPI_PathParseIconLocation($sIconData) ; #include <WinAPIShPath.au3>
			EndIf
		Else
			$sExt = _WinAPI_PathFindExtension($sFilePath) ; #include <WinAPIShPath.au3>
			; Special case extension processing
			Switch $sExt
				Case '.lnk'
					; Analyze shortcut files to get the icon
					Local $aShortcut = FileGetShortcut($sFilePath)
					If Not @error Then
						If $aShortcut[4] Then
							; If the shortcut has a custom icon
							Local $aReturnIcon = [$aShortcut[4], $aShortcut[5]]
						Else
							; If no custom icon, pass shortcut target to function
							Return _FileGetIcon($aShortcut[0])
						EndIf
					EndIf
				Case '.url'
					; Analyze .URL file data for custom icons
					$aReturnIcon[0] = IniRead($sFilePath, 'InternetShortcut', 'IconFile', '')
					$aReturnIcon[1] = IniRead($sFilePath, 'InternetShortcut', 'IconIndex', '')
				Case '.scr', '.exe'
					; .exe is good for returning %1, but .scr seems to return blank
					$aReturnIcon[0] = $sFilePath
			EndSwitch
			If Not $aReturnIcon[0] Then
				; We put this outside the switch in case one of the special case methods returned an empty icon
				; We can still maybe get an icon by filetype
				$sIconData = _WinAPI_AssocQueryString($sExt, $ASSOCSTR_DEFAULTICON) ; #include <WinAPIReg.au3>
				$aReturnIcon = _WinAPI_PathParseIconLocation($sIconData) ; #include <WinAPIShPath.au3>
			EndIf
		EndIf
	EndIf

	If $aReturnIcon[0] = '%1' Then
		$aReturnIcon[0] = $sFilePath
	Else
		If $aReturnIcon[1] < 0 Then
			$aReturnIcon[1] = -$aReturnIcon[1]
		Else
			$aReturnIcon[1] = -($aReturnIcon[1] + 1)
		EndIf
	EndIf

	If UBound($aReturnIcon) <> 2 Or Not $aReturnIcon[0] Then
		Local $aReturnIcon = [$sDefaultIcon, $sDefaultIndex]
		Return SetError(1, 0, $aReturnIcon)
	Else
		$aReturnIcon[0] = _WinAPI_PathFindOnPath(FileGetLongName(_WinAPI_ExpandEnvironmentStrings($aReturnIcon[0]))) ; #include <WinAPIShPath.au3> / #include <WinAPISys.au3>
		Return $aReturnIcon
	EndIf
EndFunc   ;==>_FileGetIcon


Func _ISN_Favorites_DoesFavoritesFolderExist()
	If $ShowFavoritesInProjecttree <> "true" Then Return False
	If FileExists(_ISN_Variablen_aufloesen($FavoritesSubfolder)) Then Return True
	Return False
EndFunc   ;==>_ISN_Favorites_DoesFavoritesFolderExist

Func _ISN_Favorites_ShortGetCommentPath($FilePath = "")
	If $FilePath = "" Then Return

	$result = FileGetShortcut($FilePath)
	If IsArray($result) Then Return $result[3]
EndFunc   ;==>_ISN_Favorites_ShortGetCommentPath

; #FUNCTION# ====================================================================================================================
; Name ..........: _ISN_Favorites_AddNewItem
; Description ...: Creates a sortcut file in the .Favorits folder of the currently opened project.
;				   The Filepath is converted in ISN variables and is sotred in the comment field of the shortcut. (This uses the ISN)
;				   The "real" path of the .lnk file simply points to explorer.exe and selects the File in the Windows explorer. (If the shortcut is opened outside the ISN)
; Syntax ........: _ISN_Favorites_AddNewItem([$FilePath = ""])
; Parameters ....: $FilePath            - [optional] A floating point number value. Default is "".
; Return values .: None
; Author ........:
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _ISN_Favorites_AddNewItem($FilePath = "", $OldFileToOverwrite = "", $OldOriginalFilePath = "")
	If $ShowFavoritesInProjecttree <> "true" Then Return
	If Not _ISN_Favorites_CheckPathIfFavoriteIsAllowed($FilePath) Then Return
	If _ISN_Favorites_CreateFavoritesDirectory() Then _Update_Treeview() ;Create favorites dir, if it does not exist

	Local $sDrive = "", $sDir = "", $sFileName = "", $sExtension = ""
	Local $sDrive2 = "", $sDir2 = "", $sFileName2 = "", $sExtension2 = ""
	Local $sDrive3 = "", $sDir3 = "", $sFileName3 = "", $sExtension3 = ""
	Local $Treeview = $Current_TVExplorer_TreeView
	Local $aPathSplit = _PathSplit($FilePath, $sDrive, $sDir, $sFileName, $sExtension)
	Local $FavoritesPath = _ISN_Variablen_aufloesen($FavoritesSubfolder)


	Local $ShortcutExePath = "C:\Windows\Explorer.exe"
	Local $ShortcutWorkingDir = "C:\Windows"
	Local $ShortcutDestination = $FavoritesPath & "\" & $sFileName & $sExtension
	If $OldFileToOverwrite <> "" Then
		$ShortcutDestination = $OldFileToOverwrite
		$ShortcutDestination = StringReplace($ShortcutDestination, ".lnk", "")
	EndIf
	Local $ShortcutParameter = '/e, /select, "' & $FilePath & '"'
	Local $ShortcutComment = _ISN_Pfad_durch_Variablen_ersetzen($FilePath) ;We store the relative ISN path as comment, so the ISN can resolve it anywhere
	Local $ShortcutIconFile = @ScriptDir & "\autoitstudioicon.ico"
	Local $ShortcutIconIndex = 0


	Local $IconArray = _FileGetIcon($FilePath)
	If IsArray($IconArray) Then
		$ShortcutIconFile = $IconArray[0]
		$ShortcutIconIndex = $IconArray[1]
	EndIf

	;Overwrite some Icons
	Switch $sExtension

		Case ".isf"
			$ShortcutIconFile = $smallIconsdll
			$ShortcutIconIndex = 780

		Case ".isn"
			$ShortcutIconFile = $smallIconsdll
			$ShortcutIconIndex = 786

	EndSwitch

	If FileCreateShortcut($ShortcutExePath, $ShortcutDestination, $ShortcutWorkingDir, $ShortcutParameter, $ShortcutComment, $ShortcutIconFile, "", $ShortcutIconIndex) = 0 Then
		_Write_ISN_Debug_Console("Unable to create new favorites shortcut! (" & $ShortcutDestination & ".lnk" & ")", $ISN_Debug_Console_Errorlevel_Critical, $ISN_Debug_Console_Linebreak)
		Local $ActiveWindow = WinGetHandle("[ACTIVE]")
		If Not IsHWnd($ActiveWindow) Then $ActiveWindow = $Studiofenster
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1331), 0, $ActiveWindow)
		Return
	EndIf
	_Write_ISN_Debug_Console("New favorites shortcut created! (" & $ShortcutDestination & ".lnk" & ")", 1)

	If $OldFileToOverwrite = "" Then
		$Porjecttree_FileToSelect_after_Update = $ShortcutDestination & ".lnk"
		_GUICtrlTVExplorer_Expand($Treeview, $ShortcutDestination & ".lnk")
		If $Studiomodus = "2" Then AdlibRegister("_Update_Treeview")
	Else
		;Verify also the filename
		$aPathSplit2 = _PathSplit($ShortcutDestination, $sDrive2, $sDir2, $sFileName2, $sExtension2)
		$aPathSplit3 = _PathSplit($OldOriginalFilePath, $sDrive3, $sDir3, $sFileName3, $sExtension3)
		Local $NewFilePath = $sDrive2 & $sDir2 & $sFileName & $sExtension
		If $sFileName2 = $sFileName3 Then ;Only correct the file name, if the user has not modified it per hand
			If FileMove($ShortcutDestination & ".lnk", $NewFilePath & ".lnk", 0) = 0 Then
				_Write_ISN_Debug_Console("Unable to rename shortcut in favorites Store! File " & $NewFilePath & ".lnk already exists!", $ISN_Debug_Console_Errorlevel_Critical, $ISN_Debug_Console_Linebreak)
			EndIf
		EndIf
	EndIf
EndFunc   ;==>_ISN_Favorites_AddNewItem





Func _ISN_Favorites_RefreshFilePath($OldPath = "", $NewPath = "")
	If $Offenes_Projekt = "" Then Return
	If $ShowFavoritesInProjecttree <> "true" Then Return
	If Not FileExists(_ISN_Variablen_aufloesen($FavoritesSubfolder)) Then Return
	Local $FavoritesPath = _ISN_Variablen_aufloesen($FavoritesSubfolder)
	If StringInStr($OldPath, $FavoritesPath) Then Return ;Ignore stuff in favorites folder itselfe


	;Fix paths
	$OldPathAttributes = FileGetAttrib($OldPath)
	$NewPathAttributes = FileGetAttrib($NewPath)
	If Not StringInStr($OldPathAttributes, "D") And StringInStr($NewPathAttributes, "D") Then ;A File has moved to a folder -> add file name to path
		Local $sDrive = "", $sDir = "", $sFileName = "", $sExtension = ""
		Local $OldPathSplit = _PathSplit($OldPath, $sDrive, $sDir, $sFileName, $sExtension)
		$NewPath = $NewPath & "\" & $sFileName & $sExtension
	EndIf

	;Scan ISN UDFs Folder
	Local $FavoritesArray = _FileListToArrayRec($FavoritesPath, "*.lnk", $FLTAR_FILES, $FLTAR_RECUR, $FLTAR_NOSORT, $FLTAR_FULLPATH)
	If Not IsArray($FavoritesArray) Or @error Then Return
	_ArrayDelete($FavoritesArray, 0)

	For $cnt = 0 To UBound($FavoritesArray) - 1
		$FilePath = _ISN_Favorites_ShortGetCommentPath($FavoritesArray[$cnt])
		If $FilePath = "" Then ContinueLoop
		$FilePath = _ISN_Variablen_aufloesen($FilePath)
		If $FilePath = $OldPath Then _ISN_Favorites_AddNewItem($NewPath, $FavoritesArray[$cnt], $OldPath)
	Next

EndFunc   ;==>_ISN_Favorites_RefreshFilePath


Func _ISN_Favorites_CreateFavoritesDirectory()
	If $Offenes_Projekt = "" Then Return False
	If $ShowFavoritesInProjecttree <> "true" Then Return False
	If FileExists(_ISN_Variablen_aufloesen($FavoritesSubfolder)) Then Return False
	If DirCreate(_ISN_Variablen_aufloesen($FavoritesSubfolder)) = 0 Then
		Local $ActiveWindow = WinGetHandle("[ACTIVE]")
		If Not IsHWnd($ActiveWindow) Then $ActiveWindow = $Studiofenster
		MsgBox(262144 + 16, _Get_langstr(25), _Get_langstr(1331) & @CRLF & $FavoritesSubfolder, 0, $ActiveWindow)
		Return False
	EndIf
	Return True
EndFunc   ;==>_ISN_Favorites_CreateFavoritesDirectory

Func _ISN_Favorites_AddNewItemFromProjecttree()
	Local $Treeview = $Current_TVExplorer_TreeView
	If _GUICtrlTVExplorer_GetSelected($Treeview) = $Offenes_Projekt Then Return
	Local $file = _GUICtrlTVExplorer_GetSelected($Treeview)
	_ISN_Favorites_AddNewItem($file)
EndFunc   ;==>_ISN_Favorites_AddNewItemFromProjecttree

Func _ISN_Favorites_AddNewItemFromTab()
	If _GUICtrlTab_GetItemCount($htab) = 0 Then Return
	If $SCE_EDITOR[_GUICtrlTab_GetCurFocus($htab)] = 0 Then Return
	$Pfad = $Datei_pfad[_GUICtrlTab_GetCurFocus($htab)]
	If Not FileExists($Pfad) Then Return
	_ISN_Favorites_AddNewItem($Pfad)
EndFunc   ;==>_ISN_Favorites_AddNewItemFromTab



Func _ISN_Favorites_FixNewPath($file = "")
	If FileExists($file) Then Return $file
	If $Offenes_Projekt = "" Then Return $file
	Local $FavoritesPath = _ISN_Variablen_aufloesen($FavoritesSubfolder)

EndFunc   ;==>_ISN_Favorites_FixNewPath


Func _ISN_Favorites_CheckPathIfFavoriteIsAllowed($FilePath = "")
	If $FilePath = "" Then Return False
	If $Offenes_Projekt = "" Then Return False
	If $ShowFavoritesInProjecttree <> "true" Then Return False
	If Not FileExists($FilePath) Then Return False
	Local $FavoritesPath = _ISN_Variablen_aufloesen($FavoritesSubfolder)
	If StringInStr($FilePath, $FavoritesPath) Then Return False ;Ignore stuff in favorites folder itselfe
	Local $FilePathAttributes = FileGetAttrib($FilePath)
	If StringInStr($FilePathAttributes, "D") Then Return False ;do not allow folders
	Return True
EndFunc   ;==>_ISN_Favorites_CheckPathIfFavoriteIsAllowed

Func _ISN_TreeViewCopyFilePathtoClipboard()
	If $Offenes_Projekt = "" Then Return
	$file = _GUICtrlTVExplorer_GetSelected($Current_TVExplorer_TreeView)

	;If it´s a favorite, then resolve lnk
	Local $FavoritesPath = _ISN_Variablen_aufloesen($FavoritesSubfolder)
	If StringRight($file, 4) = ".lnk" And StringInStr($file, $FavoritesPath) Then
		$file = _ISN_Variablen_aufloesen(_ISN_Favorites_ShortGetCommentPath($file))
	EndIf

	ClipPut($file)
EndFunc   ;==>_ISN_TreeViewCopyFilePathtoClipboard

Func _ISN_TreeViewSelectNextItemAtLevelAndGetPath($TreeViewHandle = "")
	If $TreeViewHandle = "" Then $TreeViewHandle = $Current_TVExplorer_TreeView
	Local $SelectedHandle = _GUICtrlTreeView_GetSelection($TreeViewHandle)
	If $SelectedHandle = 0 Then Return ""
	Local $NextChild = _GUICtrlTreeView_GetNextChild($TreeViewHandle, $SelectedHandle)
	If $NextChild <> 0 Then Return _GUICtrlTVExplorer_GetPathFromItem($TreeViewHandle, $NextChild)
	Local $PrevChild = _GUICtrlTreeView_GetPrevChild($TreeViewHandle, $SelectedHandle)
	If $PrevChild <> 0 Then Return _GUICtrlTVExplorer_GetPathFromItem($TreeViewHandle, $PrevChild)
	Return "" ;No items anymore at the same level
EndFunc   ;==>_ISN_TreeViewSelectNextItemAtLevelAndGetPath


Func _ISN_VariablesSelector_ShowISNVariables()

	_GUICtrlListView_BeginUpdate($ISN_VariablesSelector_Listview)
	_GUICtrlListView_DeleteAllItems(GUICtrlGetHandle($ISN_VariablesSelector_Listview))
	Local $VariablesSplit = StringSplit($Programmvariablen, "|", 2)
	If IsArray($VariablesSplit) Then
		_ArraySort($VariablesSplit)
		For $cnt = 0 To UBound($VariablesSplit) - 1
			If $VariablesSplit[$cnt] = "" Then ContinueLoop
			_GUICtrlListView_AddItem($ISN_VariablesSelector_Listview, $VariablesSplit[$cnt])
		Next
	EndIf
	_GUICtrlListView_EndUpdate($ISN_VariablesSelector_Listview)


	_ISN_VariablesSelector_ShowGUI()
EndFunc   ;==>_ISN_VariablesSelector_ShowISNVariables



Func _ISN_VariablesSelector_ShowFormStudioVariables()


	_GUICtrlListView_BeginUpdate($ISN_VariablesSelector_Listview)
	_GUICtrlListView_DeleteAllItems(GUICtrlGetHandle($ISN_VariablesSelector_Listview))


	;General
	_GUICtrlListView_AddItem($ISN_VariablesSelector_Listview, _Get_langstr(125) & ":")
	Local $VariablesSplit = StringSplit($FormStudioVariables_General, "|", 2)
	If IsArray($VariablesSplit) Then
		For $cnt = 0 To UBound($VariablesSplit) - 1
			If $VariablesSplit[$cnt] = "" Then ContinueLoop
			_GUICtrlListView_AddItem($ISN_VariablesSelector_Listview, $VariablesSplit[$cnt])
		Next
	EndIf
	_GUICtrlListView_AddItem($ISN_VariablesSelector_Listview, "")

	;Control Handls
	$VariablesSplit = ""
	_GUICtrlListView_AddItem($ISN_VariablesSelector_Listview, _Get_langstr(1536) & ":")
	Local $VariablesSplit = StringSplit($FormStudioVariables_ControlStuff, "|", 2)
	If IsArray($VariablesSplit) Then
		For $cnt = 0 To UBound($VariablesSplit) - 1
			If $VariablesSplit[$cnt] = "" Then ContinueLoop
			_GUICtrlListView_AddItem($ISN_VariablesSelector_Listview, $VariablesSplit[$cnt])
		Next
	EndIf
	_GUICtrlListView_AddItem($ISN_VariablesSelector_Listview, "")

	;Gui variables
	_GUICtrlListView_AddItem($ISN_VariablesSelector_Listview, _Get_langstr(1527) & ":")
	$VariablesSplit = ""
	Local $VariablesSplit = StringSplit($FormStudioVariables_GUIStuff, "|", 2)
	If IsArray($VariablesSplit) Then
		For $cnt = 0 To UBound($VariablesSplit) - 1
			If $VariablesSplit[$cnt] = "" Then ContinueLoop
			_GUICtrlListView_AddItem($ISN_VariablesSelector_Listview, $VariablesSplit[$cnt])
		Next
	EndIf


	_GUICtrlListView_EndUpdate($ISN_VariablesSelector_Listview)
	_ISN_VariablesSelector_ShowGUI(_Get_langstr(1470))
EndFunc   ;==>_ISN_VariablesSelector_ShowFormStudioVariables

Func _ISN_VariablesSelector_ShowCompileFolderVariables()

	_GUICtrlListView_BeginUpdate($ISN_VariablesSelector_Listview)
	_GUICtrlListView_DeleteAllItems(GUICtrlGetHandle($ISN_VariablesSelector_Listview))
	Local $VariablesSplit = StringSplit($Variablen_Ordnerstruktur, "|", 2)
	If IsArray($VariablesSplit) Then
		_ArraySort($VariablesSplit)
		For $cnt = 0 To UBound($VariablesSplit) - 1
			If $VariablesSplit[$cnt] = "" Then ContinueLoop
			_GUICtrlListView_AddItem($ISN_VariablesSelector_Listview, $VariablesSplit[$cnt])
		Next
	EndIf
	_GUICtrlListView_EndUpdate($ISN_VariablesSelector_Listview)

	_ISN_VariablesSelector_ShowGUI(_Get_langstr(1524))
EndFunc   ;==>_ISN_VariablesSelector_ShowCompileFolderVariables

Func _ISN_VariablesSelector_ResizeGUI()
	_GUICtrlListView_SetColumnWidth($ISN_VariablesSelector_Listview, 0, _ISN_CalculateLastListViewColumn($ISN_VariablesSelector_Listview))
EndFunc   ;==>_ISN_VariablesSelector_ResizeGUI


Func _ISN_VariablesSelector_ShowGUI($TitleOverride = "")

	_GUICtrlListView_SetColumnWidth($ISN_VariablesSelector_Listview, 0, _ISN_CalculateLastListViewColumn($ISN_VariablesSelector_Listview))
	_GUICtrlListView_SetItemSelected($ISN_VariablesSelector_Listview, 0, True, True)
	_ISN_VariablesSelector_SelectItem()

	Local $FinishedArray = $Leeres_Array
	_AcInputUDF_ControlSetAcList($ISN_VariablesSelector_Searchbar, $Leeres_Array)

	If $TitleOverride = "" Then
		WinSetTitle($ISN_VariablesSelector, "", _Get_langstr(1492))
		GUICtrlSetData($ISN_VariablesSelector_Title, _Get_langstr(1492))
	Else
		WinSetTitle($ISN_VariablesSelector, "", $TitleOverride)
		GUICtrlSetData($ISN_VariablesSelector_Title, $TitleOverride)
	EndIf

	If $ISN_VariablesSelector_AutoCloseGUI = "true" Then
		GUICtrlSetState($ISN_VariablesSelector_AutocloseCheckbox, $GUI_CHECKED)
	Else
		GUICtrlSetState($ISN_VariablesSelector_AutocloseCheckbox, $GUI_UNCHECKED)
	EndIf

	GUISetState(@SW_SHOW, $ISN_VariablesSelector)
	WinSetOnTop($ISN_VariablesSelector, "", 1)

	;Set array for ACInout
	For $cnt = 0 To _GUICtrlListView_GetItemCount($ISN_VariablesSelector_Listview)
		Local $ItemText = _GUICtrlListView_GetItemText($ISN_VariablesSelector_Listview, $cnt, 0)
		If StringLeft($ItemText, 1) = "%" Then _ArrayAdd($FinishedArray, $ItemText)
	Next
	_AcInputUDF_ControlSetAcList($ISN_VariablesSelector_Searchbar, $FinishedArray)

EndFunc   ;==>_ISN_VariablesSelector_ShowGUI

Func _ISN_VariablesSelector_HideGUI()
	GUISetState(@SW_HIDE, $ISN_VariablesSelector)
	If GUICtrlRead($ISN_VariablesSelector_AutocloseCheckbox) = $GUI_CHECKED Then
		If $ISN_VariablesSelector_AutoCloseGUI <> "true" Then
			$ISN_VariablesSelector_AutoCloseGUI = "true"
			_Write_in_Config("ISN_variables_autoclose", "true")
		EndIf
	Else
		If $ISN_VariablesSelector_AutoCloseGUI <> "false" Then
			$ISN_VariablesSelector_AutoCloseGUI = "false"
			_Write_in_Config("ISN_variables_autoclose", "false")
		EndIf
	EndIf
EndFunc   ;==>_ISN_VariablesSelector_HideGUI

Func _ISN_VariablesSelector_SelectItem()
	If _GUICtrlListView_GetSelectionMark($ISN_VariablesSelector_Listview) = -1 Then Return
	Local $SelectedVariable = _GUICtrlListView_GetItemText($ISN_VariablesSelector_Listview, _GUICtrlListView_GetSelectionMark($ISN_VariablesSelector_Listview), 0)
	If Not StringInStr($SelectedVariable, "%") Or $SelectedVariable = "" Then
		GUICtrlSetData($ISN_VariablesSelector_VariableDescription, "")
		GUICtrlSetData($ISN_VariablesSelector_VariableHeader, "")
		GUICtrlSetState($ISN_VariablesSelector_VariableBeginInsertButton, $GUI_DISABLE)
		Return
	EndIf

	Switch $SelectedVariable

		Case "%ProjectDir%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(578))

		Case "%CompiledDir%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(579))

		Case "%ISNStudioDir%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(580))

		Case "%WindowsDir%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(581))

		Case "%TempDir%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(586))

		Case "%DesktopDir%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(587))

		Case "%BackupDir%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(588))

		Case "%MyDocumentsDir%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(816))

		Case "%ProjectVersion%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(977))

		Case "%FileDir%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1048))

		Case "%LastCompiledFile_exe%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1065))

		Case "%LastCompiledFile_source%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1066))

		Case "%ProjectName%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, StringReplace(_Get_langstr(5), ":", ""))

		Case "%ProjectAuthor%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, StringReplace(_Get_langstr(369), ":", ""))

		Case "%MyISNDataDir%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1125))

		Case "%CurrentTab_FileName%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1494))

		Case "%CurrentTab_FullPath%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1495))

		Case "%ProjecttreeSelectedFile_Name%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1519))

		Case "%ProjecttreeSelectedFile_Path%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1520))

		Case "%UDFsDir%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1548))

		Case "%PluginsDir%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1549))

		Case "%AutoItIncludesDir%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1550))

		Case "%ProjectsDir%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1551))

		Case "%TemplatesDir%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1552))

		Case "%Handle_Declaration%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1526))

		Case "%GUI_Handle%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1528))

		Case "%GUI_X%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1529))

		Case "%GUI_Y%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1530))

		Case "%GUI_Width%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1531))

		Case "%GUI_Height%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1532))

		Case "%GUI_Title%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1533))

		Case "%GUI_Style%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1534))

		Case "%GUI_ExStyle%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1535))			
			
		Case "%GUI_Parent%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1577))			
			
		Case "%GUI_BgColor%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1578))						
			
		Case "%GUI_BgImage%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1579))			
			
		Case "%GUI_DefaultFont%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1580))				
			
		Case "%GUI_DefaultFontSize%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1581))						

		Case "%Handle%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1537))

		Case "%X%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1538))

		Case "%Y%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1539))

		Case "%Width%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1540))

		Case "%Height%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1541))

		Case "%Text%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1542))

		Case "%TooltipText%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1565))

		Case "%OnClickFunc%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1566))

		Case "%ResizeValue%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1567))

		Case "%BgColor%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1568))

		Case "%ImageFilepath%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1569))

		Case "%ImageIndex%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1570))

		Case "%FontName%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1571))

		Case "%FontAttribute%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1572))

		Case "%FontColor%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1573))

		Case "%FontSize%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1574))

		Case "%FontWeight%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1575))
																																						
		Case "%Style%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1543))

		Case "%ExStyle%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1544))

		Case "%State%"
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, _Get_langstr(1576))
			
		Case Else
			GUICtrlSetData($ISN_VariablesSelector_VariableDescription, "")
			GUICtrlSetData($ISN_VariablesSelector_VariableHeader, "")
			GUICtrlSetData($ISN_VariablesSelector_VariablePreview, "")
			GUICtrlSetState($ISN_VariablesSelector_VariableBeginInsertButton, $GUI_DISABLE)
			Return

	EndSwitch
	GUICtrlSetData($ISN_VariablesSelector_VariableHeader, $SelectedVariable)
	GUICtrlSetData($ISN_VariablesSelector_VariablePreview, _ISN_Variablen_aufloesen($SelectedVariable, $Offenes_Projekt))
	GUICtrlSetState($ISN_VariablesSelector_VariableBeginInsertButton, $GUI_ENABLE)

EndFunc   ;==>_ISN_VariablesSelector_SelectItem


Func _ISN_VariablesSelector_Searchbar_ClearInputButton()
	If $Offenes_Projekt = "" Then Return
	GUICtrlSetData($ISN_VariablesSelector_Searchbar, "")
	_WinAPI_SetFocus(GUICtrlGetHandle($ISN_VariablesSelector_Searchbar))
EndFunc   ;==>_ISN_VariablesSelector_Searchbar_ClearInputButton

Func _ISN_VariablesSelector_Searchbar_AcInputSelectItem()
	_AcInputUDF_AutocompleteSelectedItem()
	If GUICtrlRead($ISN_VariablesSelector_Searchbar) = "" Then Return
	_WinAPI_SetFocus($ISN_VariablesSelector_Listview)
	$Foundindex = _GUICtrlListView_FindInText($ISN_VariablesSelector_Listview, GUICtrlRead($ISN_VariablesSelector_Searchbar))
	If @error Or $Foundindex = -1 Then Return


	_GUICtrlListView_SetItemSelected($ISN_VariablesSelector_Listview, $Foundindex, True, True)
	_GUICtrlListView_SetSelectionMark($ISN_VariablesSelector_Listview, $Foundindex)
	_GUICtrlListView_EnsureVisible($ISN_VariablesSelector_Listview, $Foundindex)
	_ISN_VariablesSelector_SelectItem()
EndFunc   ;==>_ISN_VariablesSelector_Searchbar_AcInputSelectItem





Func _ISN_VariablesSelector_BeginDragText()
	If $Offenes_Projekt = "" Then Return
	AdlibUnRegister("_ISN_VariablesSelector_BeginDragText")

	If _GUICtrlListView_GetSelectionMark($ISN_VariablesSelector_Listview) = -1 Then Return

	Local $MousePositionStruct = DllStructCreate($tagPOINT) ; Create a structure that defines the mouse cordinates

	Local $TextToInsert = _GUICtrlListView_GetItemText($ISN_VariablesSelector_Listview, _GUICtrlListView_GetSelectionMark($ISN_VariablesSelector_Listview), 0)

	If Not StringInStr($TextToInsert, "%") Or $TextToInsert = "" Then Return

	Local $HwndUnderMouse = ""
	Local $ControlClass = ""
	Local $ControlID = ""
	Local $ControlGetHandleResult = ""
	Local $CharPosArray
	Local $InsertPosition = -1
	Local $ToolTipText = "Abbrechen mit ESC"
	Local $ToolTipTitle = $TextToInsert
	Local $LastMouseX
	Local $LastMouseY
	Local $ToolTipYOffset = 20
	Local $ToolTipXOffset = 5

	_ISN_VariablesSelector_HideGUI()

	Local $WarnRes = _Show_Warning("confirmvariablesselector", 737 + 1, _Get_langstr(1492), _Get_langstr(1521), _Get_langstr(7))
	If $WarnRes = 1 Then Sleep(500)

	Opt("GUICloseOnESC", 0)
	ToolTip("")
	MouseUp("primary")
	Sleep(100)

	While Not _IsPressed("01")
		If _IsPressed("1B") Then
			ToolTip("")
			GUISetCursor(2, 0, $Studiofenster)
			Opt("GUICloseOnESC", 1)
			GUISetState(@SW_SHOW, $ISN_VariablesSelector)
			Return ;Cancel with ESC
		EndIf
		If _IsPressed("01") Then ExitLoop ;Exit when mouse button is pressed

		;Update mouse struct
		DllStructSetData($MousePositionStruct, "x", MouseGetPos(0))
		DllStructSetData($MousePositionStruct, "y", MouseGetPos(1))

		$HwndUnderMouse = _WinAPI_WindowFromPoint($MousePositionStruct)
		If IsHWnd($HwndUnderMouse) Then
			$ControlClass = _WinAPI_GetClassName($HwndUnderMouse)
			$ControlID = _WinAPI_GetDlgCtrlID($HwndUnderMouse)

			If ($LastMouseX <> MouseGetPos(0)) Or ($LastMouseY <> MouseGetPos(1)) Then
				ToolTip($ToolTipText, DllStructGetData($MousePositionStruct, "x") + $ToolTipXOffset, DllStructGetData($MousePositionStruct, "y") + $ToolTipYOffset, $ToolTipTitle)
				$LastMouseX = MouseGetPos(0)
				$LastMouseY = MouseGetPos(1)
			EndIf

			Switch $ControlClass

				Case "Edit" ;(edit) controls
					GUISetCursor(14, 1, $Studiofenster)
					$ControlGetHandleResult = ControlGetHandle(_GetHwndUnderMouse(), "", $HwndUnderMouse)
					$CharPosArray = _GUICtrlEdit_CharFromPos($ControlGetHandleResult, _WinAPI_GetMousePosX(True, $ControlGetHandleResult), _WinAPI_GetMousePosY(True, $ControlGetHandleResult))
					If IsArray($CharPosArray) Then
						If _WinAPI_GetFocus() <> $ControlGetHandleResult Then _WinAPI_SetFocus($ControlGetHandleResult)
						If $InsertPosition <> $CharPosArray[0] Then
							_GUICtrlEdit_SetSel($ControlGetHandleResult, $CharPosArray[0], $CharPosArray[0]) ;Set input cursor in input where the mouse pointer is
							$InsertPosition = $CharPosArray[0]
						EndIf
					EndIf

				Case "Scintilla"
					$ControlGetHandleResult = ControlGetHandle(_GetHwndUnderMouse(), "", $HwndUnderMouse)
					If _WinAPI_GetFocus() <> $ControlGetHandleResult Then _WinAPI_SetFocus($HwndUnderMouse)
					SendMessage($ControlGetHandleResult, $SCI_GOTOPOS, SendMessage($ControlGetHandleResult, $SCI_POSITIONFROMPOINT, _WinAPI_GetMousePosX(True, $ControlGetHandleResult) - 5, _WinAPI_GetMousePosY(True, $ControlGetHandleResult)), 0)


				Case Else
					GUISetCursor(2, 0, $Studiofenster)
			EndSwitch
		EndIf
		Sleep(50)
	WEnd

	;Drag has ended
	ToolTip("")
	GUISetCursor(2, 0, $Studiofenster)
	Opt("GUICloseOnESC", 1)

	Switch $ControlClass

		Case "Edit"
			Local $EditStyle = _WinAPI_GetWindowLong($ControlGetHandleResult, $GWL_STYLE)
			If Not BitAND($EditStyle, 0x0800) Then ;Only insert, if the control is NOT read only
				_GUICtrlEdit_InsertText($ControlGetHandleResult, $TextToInsert, $InsertPosition) ;Insert text
				_GUICtrlEdit_SetSel($ControlGetHandleResult, 0, 0)
				Sleep(150)
				_GUICtrlEdit_SetSel($ControlGetHandleResult, $InsertPosition, $InsertPosition + StringLen($TextToInsert))
				If GUICtrlRead($ISN_VariablesSelector_AutocloseCheckbox) <> $GUI_CHECKED Then GUISetState(@SW_SHOW, $ISN_VariablesSelector)
			EndIf

		Case "Scintilla"
			If _hit_win($ControlGetHandleResult) Then
				Local $SCIStartpos = Sci_GetCurrentPos($ControlGetHandleResult)
				Sci_InsertText($ControlGetHandleResult, $SCIStartpos, $TextToInsert)
				Sleep(150)
				Sci_SetSelection($ControlGetHandleResult, $SCIStartpos, $SCIStartpos + StringLen($TextToInsert))
				If GUICtrlRead($ISN_VariablesSelector_AutocloseCheckbox) <> $GUI_CHECKED Then GUISetState(@SW_SHOW, $ISN_VariablesSelector)
			EndIf


	EndSwitch




EndFunc   ;==>_ISN_VariablesSelector_BeginDragText

Func _ISN_CalculateLastListViewColumn($Listview = "")
	$Window = _WinAPI_GetParent(GUICtrlGetHandle($Listview))
	If $Window = 0 Then Return 0
	$Controlpos = _ControlGetPos($Window, "", $Listview)
	Local $Bisherige_Breite = 0
	Local $Abstand_fuer_Scrollbalken = 26 * $DPI
	Local $NeueBreite = 0
	If Not IsArray($Controlpos) Then Return
	If _GUICtrlListView_GetColumnCount($Listview) <> 1 Then
		For $cnt = 0 To _GUICtrlListView_GetColumnCount($Listview) - 1
			If _GUICtrlListView_GetColumnWidth($Listview, $cnt) < 1 Then ContinueLoop ;Column is hidden
			$Bisherige_Breite = $Bisherige_Breite + _GUICtrlListView_GetColumnWidth($Listview, $cnt)
		Next
	EndIf
	$NeueBreite = $Controlpos[2] - $Bisherige_Breite - $Abstand_fuer_Scrollbalken
	Return $NeueBreite
EndFunc   ;==>_ISN_CalculateLastListViewColumn



Func _ISN_ReCreateTVExplorerDummyControls($Index = 0)
	If Not IsArray($tvData) Then Return

	;First, delete the old controls
	For $i = 2 To 8
		GUICtrlDelete($tvData[$Index][$i])
	Next

	;Switch to the owner GUI
	If Not IsHWnd($tvData[$Index][0]) Then Return
	$OwnerWindow = _WinAPI_GetAncestor($tvData[$Index][0], $GA_PARENT)
	If Not IsHWnd($OwnerWindow) Then Return
	If Not BitAND(WinGetState($OwnerWindow, ""), 2) Then Return ;Gui is hidden

	GUISwitch($OwnerWindow)

	;And create new dummy´s
	For $i = 2 To 8
		$tvData[$Index][$i] = GUICtrlCreateDummy()
		GUICtrlSetOnEvent($tvData[$Index][$i], '_TV_Event')
	Next

	_Write_ISN_Debug_Console("TVExplorer ReCreated the dummy controls sucessfully!", $ISN_Debug_Console_Errorlevel_Warning)
EndFunc   ;==>_ISN_ReCreateTVExplorerDummyControls

Func _ISN_UnlockGUIWithoutFlickering($GUI = $Studiofenster)
	;Unlock Gui and avoid flickering
	_SendMessage($GUI, $WM_SETREDRAW, False)
	GUISetState(@SW_UNLOCK, $GUI)
	_SendMessage($GUI, $WM_SETREDRAW, True)
EndFunc   ;==>_ISN_UnlockGUIWithoutFlickering


Func _ISN_Studiofenster_SetClipchildren($Mode = "set")
	Local $Studiofenster_style = GUIGetStyle($Studiofenster)
	If Not IsArray($Studiofenster_style) Then Return
	If $Mode = "set" Then
		If Not BitAND($Studiofenster_style[0], $WS_CLIPCHILDREN) Then _WinAPI_SetWindowLong($Studiofenster, $GWL_STYLE, BitOR($Studiofenster_style[0], $WS_CLIPCHILDREN))
	Else
		If BitAND($Studiofenster_style[0], $WS_CLIPCHILDREN) Then _WinAPI_SetWindowLong($Studiofenster, $GWL_STYLE, BitXOR($Studiofenster_style[0], $WS_CLIPCHILDREN))
	EndIf
EndFunc   ;==>_ISN_Studiofenster_SetClipchildren


Func _return_FileIcon($filetype = "", $return_index_from_dll = 0)


	Switch $filetype
		Case "wmv", "avi", "mpg", "mpeg", "divx", "mkv"
			If $return_index_from_dll = 0 Then
				Return 2
			Else
				Return 707
			EndIf

		Case "wav", "mp3"
			If $return_index_from_dll = 0 Then
				Return 3
			Else
				Return 705
			EndIf

		Case "exe"
			If $return_index_from_dll = 0 Then
				Return 4
			Else
				Return 818
			EndIf

		Case "bat"
			If $return_index_from_dll = 0 Then
				Return 17
			Else
				Return 818
			EndIf

		Case "bmp", "jpg", "jpeg", "png"
			If $return_index_from_dll = 0 Then
				Return 6
			Else
				Return 30
			EndIf

		Case "ico"
			If $return_index_from_dll = 0 Then
				Return 16
			Else
				Return 1057
			EndIf

		Case "doc", "docx"
			If $return_index_from_dll = 0 Then
				Return 7
			Else
				Return 728
			EndIf

		Case "ppt", "pptx"
			If $return_index_from_dll = 0 Then
				Return 8
			Else
				Return 729
			EndIf

		Case "xls", "xlsx"
			If $return_index_from_dll = 0 Then
				Return 9
			Else
				Return 730
			EndIf

		Case $Autoitextension
			If $return_index_from_dll = 0 Then
				Return 10
			Else
				Return 1788
			EndIf

		Case "txt"
			If $return_index_from_dll = 0 Then
				Return 11
			Else
				Return 1177
			EndIf

		Case "isf"
			If $return_index_from_dll = 0 Then
				Return 12
			Else
				Return 780
			EndIf

		Case "ini", "inf"
			If $return_index_from_dll = 0 Then
				Return 13
			Else
				Return 1176
			EndIf

		Case "isn"
			If $return_index_from_dll = 0 Then
				Return 14
			Else
				Return 786
			EndIf

		Case "dll"
			If $return_index_from_dll = 0 Then
				Return 15
			Else
				Return 1699
			EndIf

	EndSwitch

	Return 1

EndFunc   ;==>_return_FileIcon

Func _ISN_HotkeyUDFRecieveLogs($text = "")
	If GUICtrlRead($debug_console_hotkey_checkbox) = $GUI_UNCHECKED Then Return
	_Write_ISN_Debug_Console($text, $ISN_Debug_Console_Errorlevel_Info, $ISN_Debug_Console_Linebreak, $ISN_Debug_Console_Insert_Time, $ISN_Debug_Console_Insert_Title, $ISN_Debug_Console_Category_Hotkey)
	_WinAPI_RedrawWindow($console_chatbox)
EndFunc   ;==>_ISN_HotkeyUDFRecieveLogs



; #FUNCTION# ====================================================================================================================
; Name ..........: _ISN_GetSystemParametersInfoValue
; Description ...: Receive the value of the "Show window contents while dragging" option in the windows Performance options dialog.
; Syntax ........: _ISN_GetSystemParametersInfoValue()
; Parameters ....: None
; Return values .: None
; Author ........: ISI360
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _ISN_GetSystemParametersInfoValue()
	$tBool = DllStructCreate("int")
	DllCall("user32.dll", "int", "SystemParametersInfo", "int", 38, "int", 0, "ptr", DllStructGetPtr($tBool), "int", 0)
	Return DllStructGetData($tBool, 1)
EndFunc   ;==>_ISN_GetSystemParametersInfoValue

; #FUNCTION# ====================================================================================================================
; Name ..........: _ISN_EasyHotKey_MouseCallback
; Description ...: Mouse func for the hotkey udf.
; Syntax ........: _ISN_EasyHotKey_MouseCallback($hWnd, $Msg, $ParamNo, $Param)
; Parameters ....: $hWnd                - A handle value.
;                  $Msg                 - An unknown value.
;                  $ParamNo             - A pointer value.
;                  $Param               - A pointer value.
; Return values .: None
; Author ........: ISI360
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _ISN_EasyHotKey_MouseCallback($hWnd, $msg, $ParamNo, $Param)
	Switch $ParamNo
		Case 1
			$EasyHotkey_MouseProcID = $Param
			Return 0
		Case 2
			$EasyHotkey_MouseCode = $Param
			Return 0
		Case 3
			$EasyHotkey_MouseWParam = $Param
			Return 0
		Case 4
			$EasyHotkey_MouseLParam = $Param
		Case Else
			Return 0
	EndSwitch

	Local $CODE = $EasyHotkey_MouseCode, $wParam = $EasyHotkey_MouseWParam, $lParam = $EasyHotkey_MouseLParam, $result, $Result2

	If $EasyHotkey_UDF_Enabled And $CODE = 0 Then
		Switch $wParam

			Case $WM_MBUTTONUP
				$result = _EasyHotkey_KeyDownEvent("4")
				$Result2 = _EasyHotkey_KeyUpEvent("4")

		EndSwitch
		If $result <> 0 Or $Result2 <> 0 Then Return $result
	EndIf

	Return 0
EndFunc   ;==>_ISN_EasyHotKey_MouseCallback

; #FUNCTION# ====================================================================================================================
; Name ..........: _CheckIfISNShouldRunAsAdmin
; Description ...: Checks if the ISN Studio should be startet with Admin rights. (If enebaled in the settings)
; Syntax ........: _CheckIfISNShouldRunAsAdmin()
; Parameters ....: None
; Return values .: None
; Author ........: ISI360
; Modified ......:
; Remarks .......: This func uses the ISN_Adme.a3x file to get admin privileges. It also passes all parameters from the running session to the new one.
; 				   thx to musicstashall for the ShellExecute tips.
; Related .......:
; Link ..........:
; Example .......: No
; ===============================================================================================================================
Func _CheckIfISNShouldRunAsAdmin()
	Local $Result
	Local $StudioExe

	If $StartISNAsAdmin = "true" AND _UserHasAdminRights() AND IsAdmin() = 0 Then

			;Restart ISN and passing all parameters to the new instance
			_Write_in_Config("last_admin_start_state", "wait")
			Local $AdditionalParams = ""

			If IsArray($CmdLine) Then
				For $x = 1 To $CmdLine[0]
					$AdditionalParams = $AdditionalParams & '%DoubleQuote%' & $CmdLine[$x] & '%DoubleQuote% '
				Next
				$AdditionalParams = StringStripWS($AdditionalParams, 3)
			EndIf

			If @Compiled Then
				$Result = ShellExecute('"' & $IntegratedAutoIt3_exe & '"', '"' & @ScriptDir & "\Data\ISN_Adme.a3x" & '" ' & '"/runasadmin %DoubleQuote%' & @ScriptDir & "\AutoIt_Studio.exe" & "%DoubleQuote% " & $AdditionalParams & '"', @ScriptDir, "runas")
			Else
				$StudioExe = "ShellExecute('%DoubleQuote%" & $autoitexe & "%DoubleQuote%','%DoubleQuote%" & @ScriptDir & '\' & @ScriptName & "%DoubleQuote%' " & "& ' ' &" & " '" & $AdditionalParams & "')"
				$Result = ShellExecute('"' & $IntegratedAutoIt3_exe & '"', '"' & @ScriptDir & "\Data\ISN_Adme.a3x" & '" ' & '"/execute ' & $StudioExe & '"', @ScriptDir, "runas")
			EndIf


			if not @error Then
				_GDIPlus_Shutdown()
				Exit 0;UAC was successful. We can exit this session
			EndIf

	EndIf

	return 0 ;If failed, the ISN will continue starting with normal user privileges
EndFunc   ;==>_CheckIfISNShouldRunAsAdmin


Func _UserHasAdminRights($sUserName = @UserName, $sComputerName = @ComputerName)
    Local $aCall = DllCall("netapi32.dll", "long", "NetUserGetInfo", _
        "wstr", $sComputerName, _
        "wstr", $sUserName, _
        "dword", 1, _ ; Return detailed information about the user account
        "ptr*", 0)

    If @error Then Return SetError(1, 0, False)
    ; Collect
    Local $pPointer = $aCall[4]
    ; Format
    Local $tUSER_INFO_1 = DllStructCreate("ptr Name;" & _
        "ptr Password;" & _
        "dword PasswordAge;" & _
        "dword Priv;" & _
        "ptr HomeDir;" & _
        "ptr Comment;" & _
        "dword Flags;" & _
        "ptr ScriptPath;", _
        $pPointer)
    ; You want this:
    Local $fPrivAdmin = DllStructGetData($tUSER_INFO_1, "Priv") = 2
    ; Free
    DllCall("netapi32.dll", "int", "NetApiBufferFree", "ptr", $pPointer)
    Return SetError(0, 0, $fPrivAdmin)
EndFunc

Func _TryToFindNetworkShareLabel($DriveLetter = "")
	if $DriveLetter = "" then return ""
		
	Local $FoundLabel = ""
	if StringRight($DriveLetter,1) = "\" then $DriveLetter = StringTrimRight($DriveLetter,1)
	Local $DriveUNCPath =  DriveMapGet($DriveLetter) 
	if @error then return ""
	
	$DriveUNCPath = StringReplace($DriveUNCPath,"\","#")
	$FoundLabel = RegRead ("HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\MountPoints2\"&$DriveUNCPath,  "_LabelFromDesktopINI")
	if $FoundLabel = "" OR @error then $FoundLabel =  RegRead ("HKEY_CURRENT_USER\SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\MountPoints2\"&$DriveUNCPath,  "_LabelFromReg")
	if $FoundLabel = "" OR @error then $FoundLabel = DriveGetLabel ($DriveLetter)

	return $FoundLabel
EndFunc


